/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.tooling.features.AbstractFeatureMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.osgi.framework.Version;

@Mojo(name="features-export-meta-data", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class ExportFeatureMetaDataMojo
extends AbstractFeatureMojo {
    @Parameter
    private boolean mergedFeature;
    @Parameter
    protected boolean oneVersion;
    @Parameter(defaultValue="${project.build.directory}/features.xml")
    private File metaDataFile;
    private Map<String, Attributes> manifests = new HashMap<String, Attributes>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<Feature> featuresSet = this.resolveFeatures();
        if (this.mergedFeature) {
            Feature feature = this.oneVersion ? this.mergeFeatureOneVersion(featuresSet) : this.mergeFeature(featuresSet);
            featuresSet = new HashSet<Feature>();
            featuresSet.add(feature);
        }
        try {
            this.metaDataFile.getParentFile().mkdirs();
            Features features = new Features();
            features.getFeature().addAll(featuresSet);
            try (FileOutputStream os = new FileOutputStream(this.metaDataFile);){
                JaxbUtil.marshal((Features)features, (OutputStream)os);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing feature meta data to " + this.metaDataFile + ": " + e.getMessage(), e);
        }
    }

    private Feature mergeFeature(Set<Feature> featuresSet) throws MojoExecutionException {
        Feature merged = new Feature("merged");
        HashSet<String> bundleIds = new HashSet<String>();
        for (Feature feature : featuresSet) {
            for (Bundle bundle : feature.getBundle()) {
                String symbolicName = this.getBundleSymbolicName(bundle);
                if (symbolicName == null) {
                    this.logIgnored(bundle);
                    continue;
                }
                String bundleId = symbolicName + ":" + this.getBundleVersion(bundle);
                if (bundleIds.contains(bundleId)) continue;
                bundleIds.add(bundleId);
                merged.getBundle().add(bundle);
            }
        }
        return merged;
    }

    private Feature mergeFeatureOneVersion(Set<Feature> featuresSet) throws MojoExecutionException {
        Feature merged = new Feature("merged");
        HashMap<String, Bundle> bundleVersions = new HashMap<String, Bundle>();
        for (Feature feature : featuresSet) {
            for (Bundle bundle : feature.getBundle()) {
                String symbolicName = this.getBundleSymbolicName(bundle);
                if (symbolicName == null) {
                    this.logIgnored(bundle);
                    continue;
                }
                Bundle existingBundle = (Bundle)bundleVersions.get(symbolicName);
                if (existingBundle != null) {
                    Version existingVersion = new Version(this.getBundleVersion(existingBundle));
                    Version newVersion = new Version(this.getBundleVersion(bundle));
                    if (newVersion.compareTo(existingVersion) <= 0) continue;
                    bundleVersions.put(symbolicName, bundle);
                    continue;
                }
                bundleVersions.put(symbolicName, bundle);
            }
        }
        for (Bundle bundle : bundleVersions.values()) {
            merged.getBundle().add(bundle);
        }
        return merged;
    }

    private void logIgnored(Bundle bundle) {
        this.getLog().warn((CharSequence)("Ignoring jar without BundleSymbolicName: " + bundle.getLocation()));
    }

    private String getBundleVersion(Bundle bundle) throws MojoExecutionException {
        return this.getManifest(bundle).getValue("Bundle-Version");
    }

    private String getBundleSymbolicName(Bundle bundle) throws MojoExecutionException {
        return this.getManifest(bundle).getValue("Bundle-SymbolicName");
    }

    private Attributes getManifest(Bundle bundle) throws MojoExecutionException {
        Attributes attributes = this.manifests.get(bundle.getLocation());
        if (attributes == null) {
            Artifact artifact = this.resourceToArtifact(bundle.getLocation(), this.skipNonMavenProtocols);
            if (artifact.getFile() == null) {
                this.resolveArtifact(artifact, this.remoteRepos);
            }
            try (JarInputStream jis = new JarInputStream(new FileInputStream(artifact.getFile()));){
                Manifest manifest = jis.getManifest();
                attributes = manifest != null ? manifest.getMainAttributes() : new Attributes();
                this.manifests.put(bundle.getLocation(), attributes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading bundle manifest from " + bundle.getLocation(), (Exception)e);
            }
        }
        return attributes;
    }
}

