/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import java.io.File;
import java.io.FileWriter;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="dockerfile", defaultPhase=LifecyclePhase.PACKAGE)
public class DockerfileMojo
extends MojoSupport {
    @Parameter(defaultValue="${project.build.directory}")
    private File destDir;
    @Parameter(defaultValue="${project.build.directory}/assembly")
    private File assembly;
    @Parameter(defaultValue="[\"karaf\", \"run\"]")
    private String command;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Creating Dockerfile");
        File dockerFile = new File(this.destDir, "Dockerfile");
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append("FROM adoptopenjdk:11-jre-hotspot").append("\n");
            buffer.append("ENV KARAF_INSTALL_PATH /opt").append("\n");
            buffer.append("ENV KARAF_HOME $KARAF_INSTALL_PATH/apache-karaf").append("\n");
            buffer.append("ENV KARAF_EXEC exec").append("\n");
            buffer.append("ENV PATH $PATH:$KARAF_HOME/bin").append("\n");
            buffer.append("COPY ").append(this.assembly.getName()).append(" $KARAF_HOME").append("\n");
            buffer.append("EXPOSE 8101 1099 44444 8181").append("\n");
            buffer.append("CMD ").append(this.command).append("\n");
            try (FileWriter writer = new FileWriter(dockerFile);){
                writer.write(buffer.toString());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't create Dockerfile: " + e.getMessage(), e);
        }
    }
}

