/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.itests;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.apache.karaf.features.BootFinished;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.itests.KarafTestWatcher;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.ConfigurationManager;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.RerunTestException;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.container.remote.RBCRemoteTargetOptions;
import org.ops4j.pax.exam.karaf.container.internal.JavaVersionUtil;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.extra.VMOption;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafTestSupport {
    private static final EnumSet<FeaturesService.Option> NO_AUTO_REFRESH = EnumSet.of(FeaturesService.Option.NoAutoRefreshBundles);
    public static final String MIN_RMI_SERVER_PORT = "44444";
    public static final String MAX_RMI_SERVER_PORT = "65534";
    public static final String MIN_HTTP_PORT = "9080";
    public static final String MAX_HTTP_PORT = "9999";
    public static final String MIN_RMI_REG_PORT = "1099";
    public static final String MAX_RMI_REG_PORT = "9999";
    public static final String MIN_SSH_PORT = "8101";
    public static final String MAX_SSH_PORT = "8888";
    static final Long COMMAND_TIMEOUT = 360000L;
    static final Long SERVICE_TIMEOUT = 360000L;
    static final long BUNDLE_TIMEOUT = 360000L;
    static final Long ALIAS_SERVICE_TIMEOUT = 1L;
    private static Logger LOG = LoggerFactory.getLogger(KarafTestSupport.class);
    @Rule
    public KarafTestWatcher baseTestWatcher = new KarafTestWatcher();
    ExecutorService executor = Executors.newCachedThreadPool();
    @Inject
    protected BundleContext bundleContext;
    @Inject
    protected FeaturesService featureService;
    @Inject
    protected SessionFactory sessionFactory;
    @Inject
    protected ConfigurationAdmin configurationAdmin;
    @Inject
    BootFinished bootFinished;
    @Rule
    public Retry retry = new Retry(true);

    @ProbeBuilder
    public TestProbeBuilder probeConfiguration(TestProbeBuilder probe) {
        probe.setHeader("DynamicImport-Package", "*,org.apache.felix.service.*;status=provisional");
        return probe;
    }

    public File getConfigFile(String path) {
        URL res = this.getClass().getResource(path);
        if (res == null) {
            throw new RuntimeException("Config resource " + path + " not found");
        }
        return new File(res.getFile());
    }

    public MavenArtifactUrlReference getKarafDistribution() {
        return CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").versionAsInProject().type("tar.gz");
    }

    @Configuration
    public Option[] config() {
        String httpPort = Integer.toString(KarafTestSupport.getAvailablePort(Integer.parseInt(MIN_HTTP_PORT), Integer.parseInt("9999")));
        String rmiRegistryPort = Integer.toString(KarafTestSupport.getAvailablePort(Integer.parseInt(MIN_RMI_REG_PORT), Integer.parseInt("9999")));
        String rmiServerPort = Integer.toString(KarafTestSupport.getAvailablePort(Integer.parseInt(MIN_RMI_SERVER_PORT), Integer.parseInt(MAX_RMI_SERVER_PORT)));
        String sshPort = Integer.toString(KarafTestSupport.getAvailablePort(Integer.parseInt(MIN_SSH_PORT), Integer.parseInt(MAX_SSH_PORT)));
        String localRepository = System.getProperty("org.ops4j.pax.url.mvn.localRepository");
        if (localRepository == null) {
            localRepository = "";
        }
        ConfigurationManager cm = new ConfigurationManager();
        String logging = cm.getProperty("pax.exam.logging", "pax-logging");
        Option[] examOptions = new Option[]{CoreOptions.bootDelegationPackage((String)"sun.*"), CoreOptions.frameworkStartLevel((int)5), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.exam.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.exam.inject.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.extender.service.link").startLevel(Integer.valueOf(2)), CoreOptions.when((boolean)logging.equals("pax-logging")).useOptions(new Option[]{(Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.logging.api.link").startLevel(Integer.valueOf(2))}), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.base.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.core.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.extender.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.framework.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.lifecycle.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.tracker.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:org.apache.servicemix.bundles.javax-inject.link").startLevel(Integer.valueOf(2))};
        Option[] testOptions = null;
        testOptions = JavaVersionUtil.getMajorVersion() >= 9 ? new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)this.getKarafDistribution()).name("Apache Karaf").unpackDirectory(new File("target/exam")), KarafDistributionOption.configureSecurity().disableKarafMBeanServerBuilder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), CoreOptions.systemTimeout((long)3600000L), RBCRemoteTargetOptions.waitForRBCFor((Integer)3600000), CoreOptions.mavenBundle().groupId("org.awaitility").artifactId("awaitility").versionAsInProject(), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.hamcrest").versionAsInProject(), CoreOptions.mavenBundle().groupId("org.apache.karaf.itests").artifactId("common").versionAsInProject(), CoreOptions.mavenBundle().groupId("javax.annotation").artifactId("javax.annotation-api").versionAsInProject(), KarafDistributionOption.replaceConfigurationFile((String)"etc/users.properties", (File)this.getConfigFile("/etc/users.properties")), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.features.cfg", (String)"updateSnapshots", (Object)"none"), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.web.cfg", (String)"org.osgi.service.http.port", (Object)httpPort), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.management.cfg", (String)"rmiRegistryPort", (Object)rmiRegistryPort), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.management.cfg", (String)"rmiServerPort", (Object)rmiServerPort), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.shell.cfg", (String)"sshPort", (Object)sshPort), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.url.mvn.cfg", (String)"org.ops4j.pax.url.mvn.localRepository", (Object)localRepository), KarafDistributionOption.editConfigurationFilePut((String)"etc/branding.properties", (String)"welcome", (Object)""), KarafDistributionOption.editConfigurationFilePut((String)"etc/branding-ssh.properties", (String)"welcome", (Object)""), new VMOption("--add-reads=java.xml=java.logging"), new VMOption("--add-exports=java.base/org.apache.karaf.specs.locator=java.xml,ALL-UNNAMED"), new VMOption("--patch-module"), new VMOption("java.base=lib/endorsed/org.apache.karaf.specs.locator-" + System.getProperty("karaf.version") + ".jar"), new VMOption("--patch-module"), new VMOption("java.xml=lib/endorsed/org.apache.karaf.specs.java.xml-" + System.getProperty("karaf.version") + ".jar"), new VMOption("--add-opens"), new VMOption("java.base/java.security=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.base/java.net=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.base/java.lang=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.base/java.util=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.naming/javax.naming.spi=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.rmi/sun.rmi.transport.tcp=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.file=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.ftp=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.http=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.https=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.jar=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.content.text=ALL-UNNAMED"), new VMOption("--add-exports=jdk.naming.rmi/com.sun.jndi.url.rmi=ALL-UNNAMED"), new VMOption("--add-exports=java.rmi/sun.rmi.registry=ALL-UNNAMED"), new VMOption("-classpath"), new VMOption("lib/jdk9plus/*" + File.pathSeparator + "lib/boot/*" + File.pathSeparator + "lib/endorsed/*")} : new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)this.getKarafDistribution()).name("Apache Karaf").unpackDirectory(new File("target/exam")), KarafDistributionOption.configureSecurity().disableKarafMBeanServerBuilder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), CoreOptions.systemTimeout((long)3600000L), RBCRemoteTargetOptions.waitForRBCFor((Integer)3600000), CoreOptions.mavenBundle().groupId("org.awaitility").artifactId("awaitility").versionAsInProject(), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.hamcrest").versionAsInProject(), CoreOptions.mavenBundle().groupId("org.apache.karaf.itests").artifactId("common").versionAsInProject(), KarafDistributionOption.replaceConfigurationFile((String)"etc/users.properties", (File)this.getConfigFile("/etc/users.properties")), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.features.cfg", (String)"updateSnapshots", (Object)"none"), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.web.cfg", (String)"org.osgi.service.http.port", (Object)httpPort), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.management.cfg", (String)"rmiRegistryPort", (Object)rmiRegistryPort), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.management.cfg", (String)"rmiServerPort", (Object)rmiServerPort), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.shell.cfg", (String)"sshPort", (Object)sshPort), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.url.mvn.cfg", (String)"org.ops4j.pax.url.mvn.localRepository", (Object)localRepository), KarafDistributionOption.editConfigurationFilePut((String)"etc/branding.properties", (String)"welcome", (Object)""), KarafDistributionOption.editConfigurationFilePut((String)"etc/branding-ssh.properties", (String)"welcome", (Object)"")};
        return OptionUtils.combine((Option[])examOptions, (Option[])testOptions);
    }

    public static int getAvailablePort(int min, int max) {
        int i = min;
        while (i <= max) {
            int n;
            ServerSocket socket = new ServerSocket(i);
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.err.println("Port " + i + " not available, trying next one");
                    ++i;
                }
            }
            socket.close();
            return n;
        }
        throw new IllegalStateException("Can't find available network ports");
    }

    public String executeCommand(String command, Principal ... principals) {
        return this.executeCommand(command, COMMAND_TIMEOUT, false, principals);
    }

    public String executeCommand(String command, Long timeout, Boolean silent, Principal ... principals) {
        return this.executeCommand(command, timeout, SERVICE_TIMEOUT, silent, principals);
    }

    public String executeAlias(String commandAlias, Principal ... principals) {
        return this.executeAlias(commandAlias, COMMAND_TIMEOUT, ALIAS_SERVICE_TIMEOUT, false, principals);
    }

    public String executeAlias(String commandAlias, Long timeout, Long commandServiceTimeout, Boolean silent, Principal ... principals) {
        return this.executeCommand(commandAlias, timeout, commandServiceTimeout, silent, principals);
    }

    private String executeCommand(String command, Long timeout, Long commandServiceTimeout, Boolean silent, Principal ... principals) {
        String response;
        this.waitForCommandService(command, commandServiceTimeout);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        SessionFactory sessionFactory = this.getOsgiService(SessionFactory.class);
        Session session = sessionFactory.create(System.in, printStream, System.err);
        Callable<String> commandCallable = () -> {
            try {
                if (!silent.booleanValue()) {
                    System.err.println(command);
                }
                this.executeInitScript(session);
                Object result = session.execute((CharSequence)command);
                if (result != null) {
                    session.getConsole().println(result.toString());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            printStream.flush();
            return byteArrayOutputStream.toString();
        };
        FutureTask<String> commandFuture = principals.length == 0 ? new FutureTask<String>(commandCallable) : new FutureTask<String>(() -> {
            Subject subject = new Subject();
            subject.getPrincipals().addAll(Arrays.asList(principals));
            return Subject.doAs(subject, commandCallable::call);
        });
        try {
            this.executor.submit(commandFuture);
            response = commandFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            e.printStackTrace(System.err);
            response = "SHELL COMMAND TIMED OUT: ";
        }
        catch (ExecutionException e) {
            ExecutionException cause = e.getCause() != null ? (e.getCause().getCause() != null ? e.getCause().getCause() : e.getCause()) : e;
            throw new RuntimeException(cause.getMessage(), cause);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return response;
    }

    private void executeInitScript(Session session) {
        try {
            Path initScript = Paths.get(System.getProperty("karaf.etc") + "/shell.init.script", new String[0]);
            String script = String.join((CharSequence)"\n", Files.readAllLines(initScript));
            session.execute((CharSequence)script);
        }
        catch (Exception e) {
            LOG.debug("Error in initialization script", (Throwable)e);
            System.err.println("Error in initialization script: " + e.getMessage());
        }
    }

    public void assertServiceAvailable(String type) {
        Assert.assertNotNull((Object)this.getOsgiService(type));
    }

    public void assertServiceAvailable(Class type) {
        Assert.assertNotNull(this.getOsgiService(type));
    }

    public void assertServiceAvailable(Class type, long timeout) {
        Assert.assertNotNull(this.getOsgiService(type, timeout));
    }

    public void assertServiceAvailable(Class type, String filter, long timeout) {
        Assert.assertNotNull(this.getOsgiService(type, filter, timeout));
    }

    public <T> T getOsgiService(Class<T> type, long timeout) {
        return this.getOsgiService(type, null, timeout);
    }

    public <T> T getOsgiService(Class<T> type) {
        return this.getOsgiService(type, null, (long)SERVICE_TIMEOUT);
    }

    public Object getOsgiService(String type) {
        return this.getOsgiService(type, null, (long)SERVICE_TIMEOUT);
    }

    public Object getOsgiService(String type, String filter, long timeout) {
        ServiceTracker tracker = null;
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type + ")" + filter + ")" : "(&(objectClass=" + type + ")(" + filter + "))") : "(objectClass=" + type + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(this.bundleContext, osgiFilter, null);
            tracker.open(true);
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                Dictionary dic = this.bundleContext.getBundle().getHeaders();
                System.err.println("Test bundle headers: " + KarafTestSupport.explode(dic));
                for (ServiceReference ref : KarafTestSupport.asCollection(this.bundleContext.getAllServiceReferences(null, null))) {
                    System.err.println("ServiceReference: " + ref);
                }
                for (ServiceReference ref : KarafTestSupport.asCollection(this.bundleContext.getAllServiceReferences(null, flt))) {
                    System.err.println("Filtered ServiceReference: " + ref);
                }
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return svc;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getOsgiService(Class<T> type, String filter, long timeout) {
        ServiceTracker tracker = null;
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(this.bundleContext, osgiFilter, null);
            tracker.open(true);
            T svc = type.cast(tracker.waitForService(timeout));
            if (svc == null) {
                Dictionary dic = this.bundleContext.getBundle().getHeaders();
                System.err.println("Test bundle headers: " + KarafTestSupport.explode(dic));
                for (ServiceReference ref : KarafTestSupport.asCollection(this.bundleContext.getAllServiceReferences(null, null))) {
                    System.err.println("ServiceReference: " + ref);
                }
                for (ServiceReference ref : KarafTestSupport.asCollection(this.bundleContext.getAllServiceReferences(null, flt))) {
                    System.err.println("Filtered ServiceReference: " + ref);
                }
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return type.cast(svc);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForCommandService(String command, Long timeout) {
        int colonIndx;
        if (command == null || command.length() == 0) {
            return;
        }
        int spaceIdx = command.indexOf(32);
        if (spaceIdx > 0) {
            command = command.substring(0, spaceIdx);
        }
        String scope = (colonIndx = command.indexOf(58)) > 0 ? command.substring(0, colonIndx) : "*";
        String name = colonIndx > 0 ? command.substring(colonIndx + 1) : command;
        try {
            long start;
            long cur = start = System.currentTimeMillis();
            while (cur - start < timeout) {
                if (this.sessionFactory.getRegistry().getCommand(scope, name) != null) {
                    return;
                }
                Thread.sleep(100L);
                cur = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForService(String filter, long timeout) throws InvalidSyntaxException, InterruptedException {
        try (ServiceTracker st = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter(filter), null);){
            st.open();
            st.waitForService(timeout);
        }
    }

    public Bundle waitBundleState(String symbolicName, int state) {
        long endTime = System.currentTimeMillis() + 360000L;
        while (System.currentTimeMillis() < endTime) {
            Bundle bundle = this.findBundleByName(symbolicName);
            if (bundle != null && bundle.getState() == state) {
                return bundle;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        Assert.fail((String)("Manadatory bundle " + symbolicName + " not found."));
        throw new IllegalStateException("Should not be reached");
    }

    private static String explode(Dictionary dictionary) {
        Enumeration keys = dictionary.keys();
        StringBuilder result = new StringBuilder();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            result.append(String.format("%s=%s", key, dictionary.get(key)));
            if (!keys.hasMoreElements()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private static Collection<ServiceReference> asCollection(ServiceReference[] references) {
        return references != null ? Arrays.asList(references) : Collections.emptyList();
    }

    public JMXConnector getJMXConnector() throws Exception {
        return this.getJMXConnector("karaf", "karaf");
    }

    public JMXConnector getJMXConnector(String userName, String passWord) throws Exception {
        JMXServiceURL url = new JMXServiceURL(this.getJmxServiceUrl());
        Hashtable<String, String[]> env = new Hashtable<String, String[]>();
        String[] credentials = new String[]{userName, passWord};
        env.put("jmx.remote.credentials", credentials);
        JMXConnector connector = JMXConnectorFactory.connect(url, env);
        return connector;
    }

    public String getJmxServiceUrl() throws Exception {
        org.osgi.service.cm.Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.management", null);
        if (configuration != null) {
            return configuration.getProcessedProperties(null).get("serviceUrl").toString();
        }
        return "service:jmx:rmi:///jndi/rmi://localhost:44444/karaf-root";
    }

    public String getSshPort() throws Exception {
        org.osgi.service.cm.Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.shell", null);
        if (configuration != null) {
            return configuration.getProcessedProperties(null).get("sshPort").toString();
        }
        return MIN_SSH_PORT;
    }

    public String getHttpPort() throws Exception {
        org.osgi.service.cm.Configuration configuration = this.configurationAdmin.getConfiguration("org.ops4j.pax.web", null);
        if (configuration != null) {
            return configuration.getProcessedProperties(null).get("org.osgi.service.http.port").toString();
        }
        return "8181";
    }

    public void assertFeatureInstalled(String featureName) throws Exception {
        String version;
        String name;
        if (featureName.contains("/")) {
            name = featureName.substring(0, featureName.indexOf("/"));
            version = featureName.substring(featureName.indexOf("/") + 1);
        } else {
            name = featureName;
            version = null;
        }
        this.assertFeatureInstalled(name, version);
    }

    public void assertFeatureInstalled(String featureName, String featureVersion) throws Exception {
        Feature[] features;
        Feature featureToAssert = this.featureService.getFeatures(featureName, featureVersion)[0];
        for (Feature feature : features = this.featureService.listInstalledFeatures()) {
            if (!featureToAssert.equals(feature)) continue;
            return;
        }
        Assert.fail((String)("Feature " + featureName + (featureVersion != null ? "/" + featureVersion : "") + " should be installed but is not"));
    }

    public void assertFeaturesInstalled(String ... expectedFeatures) throws Exception {
        HashSet<String> expectedFeaturesSet = new HashSet<String>(Arrays.asList(expectedFeatures));
        Feature[] features = this.featureService.listInstalledFeatures();
        HashSet<String> installedFeatures = new HashSet<String>();
        for (Feature feature : features) {
            installedFeatures.add(feature.getName());
        }
        String msg = "Expecting the following features to be installed : " + expectedFeaturesSet + " but found " + installedFeatures;
        Assert.assertTrue((String)msg, (boolean)installedFeatures.containsAll(expectedFeaturesSet));
    }

    public void assertFeatureNotInstalled(String featureName) throws Exception {
        String version;
        String name;
        if (featureName.contains("/")) {
            name = featureName.substring(0, featureName.indexOf("/"));
            version = featureName.substring(featureName.indexOf("/") + 1);
        } else {
            name = featureName;
            version = null;
        }
        this.assertFeatureNotInstalled(name, version);
    }

    public void assertFeatureNotInstalled(String featureName, String featureVersion) throws Exception {
        Feature[] features;
        Feature featureToAssert = this.featureService.getFeatures(featureName, featureVersion)[0];
        for (Feature feature : features = this.featureService.listInstalledFeatures()) {
            if (!featureToAssert.equals(feature)) continue;
            Assert.fail((String)("Feature " + featureName + (featureVersion != null ? "/" + featureVersion : "") + " is installed whereas it should not be"));
        }
    }

    public void assertContains(String expectedPart, String actual) {
        Assert.assertTrue((String)("Should contain '" + expectedPart + "' but was : " + actual), (boolean)actual.contains(expectedPart));
    }

    public void assertContainsNot(String expectedPart, String actual) {
        Assert.assertFalse((String)("Should not contain '" + expectedPart + "' but was : " + actual), (boolean)actual.contains(expectedPart));
    }

    public void assertBundleInstalled(String name) {
        Assert.assertNotNull((String)("Bundle " + name + " should be installed"), (Object)this.findBundleByName(name));
    }

    public void assertBundleNotInstalled(String name) {
        Assert.assertNull((String)("Bundle " + name + " should not be installed"), (Object)this.findBundleByName(name));
    }

    public void installBundle(String bundleLocation, boolean start) throws Exception {
        Bundle bundle = this.bundleContext.installBundle(bundleLocation);
        if (start) {
            bundle.start();
        }
    }

    public Bundle findBundleByName(String symbolicName) {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().equals(symbolicName)) continue;
            return bundle;
        }
        return null;
    }

    public void addFeaturesRepository(String featuresRepository) throws Exception {
        this.featureService.addRepository(new URI(featuresRepository));
    }

    public void installAndAssertFeature(String feature) throws Exception {
        this.featureService.installFeature(feature, NO_AUTO_REFRESH);
        this.assertFeatureInstalled(feature);
    }

    public void installAssertAndUninstallFeature(String feature, String version) throws Exception {
        this.installAssertAndUninstallFeatures(feature + "/" + version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installAssertAndUninstallFeatures(String ... feature) throws Exception {
        boolean success = false;
        HashSet<String> features = new HashSet<String>(Arrays.asList(feature));
        try {
            System.out.println("Installing " + features);
            this.featureService.installFeatures(features, NO_AUTO_REFRESH);
            for (String curFeature : feature) {
                this.assertFeatureInstalled(curFeature);
            }
            success = true;
        }
        finally {
            block9: {
                System.out.println("Uninstalling " + features);
                try {
                    this.featureService.uninstallFeatures(features, NO_AUTO_REFRESH);
                }
                catch (Exception e) {
                    if (!success) break block9;
                    throw e;
                }
            }
        }
    }

    public void uninstallNewFeatures(Set<Feature> featuresBefore) throws Exception {
        Feature[] features = this.featureService.listInstalledFeatures();
        HashSet<String> uninstall = new HashSet<String>();
        for (Feature curFeature : features) {
            if (featuresBefore.contains(curFeature)) continue;
            uninstall.add(curFeature.getId());
        }
        try {
            System.out.println("Uninstalling " + uninstall);
            this.featureService.uninstallFeatures(uninstall, NO_AUTO_REFRESH);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void close(Closeable closeAble) {
        if (closeAble != null) {
            try {
                closeAble.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static class Retry
    implements TestRule {
        private static boolean retry = true;

        public Retry(boolean retry) {
            Retry.retry = retry;
        }

        public Statement apply(Statement base, Description description) {
            return this.statement(base, description);
        }

        private Statement statement(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    try {
                        base.evaluate();
                        return;
                    }
                    catch (Throwable t) {
                        LOG.debug(t.getMessage(), t);
                        if (retry && !(t instanceof AssumptionViolatedException)) {
                            retry = false;
                            throw new RerunTestException("rerun this test pls", t);
                        }
                        throw t;
                    }
                }
            };
        }
    }
}

