/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.tracker;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public final class SingleServiceTracker<T>
implements ServiceListener {
    private final BundleContext ctx;
    private final String className;
    private final AtomicReference<T> service = new AtomicReference();
    private final AtomicReference<ServiceReference<T>> ref = new AtomicReference();
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final BiConsumer<T, T> serviceListener;
    private final String filterString;
    private final Filter filter;

    public SingleServiceTracker(BundleContext context, Class<T> clazz, BiConsumer<T, T> sl) throws InvalidSyntaxException {
        this(context, clazz, null, sl);
    }

    public SingleServiceTracker(BundleContext context, Class<T> clazz, String filterString, BiConsumer<T, T> sl) throws InvalidSyntaxException {
        this(context, clazz.getName(), filterString, sl);
    }

    public SingleServiceTracker(BundleContext context, String className, String filterString, BiConsumer<T, T> sl) throws InvalidSyntaxException {
        this.ctx = context;
        this.className = className;
        this.serviceListener = sl;
        if (filterString == null || filterString.isEmpty()) {
            this.filterString = null;
            this.filter = null;
        } else {
            this.filterString = filterString;
            this.filter = context.createFilter(filterString);
        }
    }

    public T getService() {
        return this.service.get();
    }

    public ServiceReference getServiceReference() {
        return this.ref.get();
    }

    public void open() {
        if (this.open.compareAndSet(false, true)) {
            try {
                String filterString = "(objectClass=" + this.className + ")";
                if (this.filter != null) {
                    filterString = "(&" + filterString + this.filter + ")";
                }
                this.ctx.addServiceListener((ServiceListener)this, filterString);
                this.findMatchingReference(null);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.open.get()) {
            if (event.getType() == 4) {
                ServiceReference deadRef = event.getServiceReference();
                if (deadRef.equals(this.ref.get())) {
                    this.findMatchingReference(deadRef);
                }
            } else if (event.getType() == 1 && this.ref.get() == null) {
                this.findMatchingReference(null);
            }
        }
    }

    private void findMatchingReference(ServiceReference<T> original) {
        try {
            boolean clear = true;
            Object[] refs = this.ctx.getServiceReferences(this.className, this.filterString);
            if (refs != null && refs.length > 0) {
                Object r;
                Object service;
                if (refs.length > 1) {
                    Arrays.sort(refs);
                }
                if ((service = this.ctx.getService((ServiceReference)(r = refs[0]))) != null) {
                    clear = false;
                    if (!this.update(original, (ServiceReference<T>)r, (T)service)) {
                        this.ctx.ungetService((ServiceReference)r);
                    }
                }
            } else if (original == null) {
                clear = false;
            }
            if (clear) {
                this.update(original, null, null);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(ServiceReference<T> deadRef, ServiceReference<T> newRef, T service) {
        boolean result = false;
        Object prev = null;
        Object lock = newRef != null ? newRef : (deadRef != null ? deadRef : this);
        ServiceReference<T> serviceReference = lock;
        synchronized (serviceReference) {
            if (this.open.get() && (result = this.ref.compareAndSet(deadRef, newRef))) {
                prev = this.service.getAndSet(service);
            }
        }
        if (result && this.serviceListener != null) {
            this.serviceListener.accept(prev, service);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            Object prev;
            ServiceReference deadRef;
            this.ctx.removeServiceListener((ServiceListener)this);
            SingleServiceTracker singleServiceTracker = this;
            synchronized (singleServiceTracker) {
                deadRef = this.ref.getAndSet(null);
                prev = this.service.getAndSet(null);
            }
            if (deadRef != null) {
                this.serviceListener.accept(prev, null);
                this.ctx.ungetService(deadRef);
            }
        }
    }
}

