/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.lock;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class GenericDataSource
implements DataSource {
    private static final String DRIVER_MANAGER_USER_PROPERTY = "user";
    private static final String DRIVER_MANAGER_PASSWORD_PROPERTY = "password";
    private final String driverClass;
    private final String url;
    private final Properties properties;
    private final int validTimeoutMs;
    private final Queue<Connection> cache;
    private volatile Driver driver;
    private volatile boolean driverClassLoaded;

    public GenericDataSource(String driverClass, String url, String user, String password, boolean cache, int validTimeoutMs) {
        this.driverClass = driverClass;
        this.url = url;
        this.properties = new Properties();
        if (user != null) {
            this.properties.setProperty(DRIVER_MANAGER_USER_PROPERTY, user);
        }
        if (password != null) {
            this.properties.setProperty(DRIVER_MANAGER_PASSWORD_PROPERTY, password);
        }
        this.validTimeoutMs = validTimeoutMs;
        this.cache = cache ? new ConcurrentLinkedQueue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDriverLoaded() throws SQLException {
        block7: {
            try {
                if (this.driverClassLoaded) break block7;
                GenericDataSource genericDataSource = this;
                synchronized (genericDataSource) {
                    if (!this.driverClassLoaded) {
                        if (this.driverClass != null) {
                            Class.forName(this.driverClass);
                        }
                        this.driverClassLoaded = true;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new SQLException("Unable to load driver class " + this.driverClass, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Driver driver() throws SQLException {
        if (this.driver == null) {
            GenericDataSource genericDataSource = this;
            synchronized (genericDataSource) {
                if (this.driver == null) {
                    this.driver = DriverManager.getDriver(this.url);
                }
            }
        }
        return this.driver;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection con;
        this.ensureDriverLoaded();
        do {
            Connection connection = con = this.cache != null ? this.cache.poll() : null;
            if (con == null) {
                con = this.driver().connect(this.url, this.properties);
                if (con != null) continue;
                throw new SQLException("Invalid jdbc URL '" + this.url + "' for driver " + this.driver());
            }
            if (con.isValid(this.validTimeoutMs)) continue;
            con.close();
            con = null;
        } while (con == null);
        return this.wrap(con);
    }

    private Connection wrap(final Connection con) {
        return (Connection)Proxy.newProxyInstance(con.getClass().getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){
            private boolean closed = false;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("close") && method.getParameterCount() == 0) {
                    this.closed = true;
                    if (!GenericDataSource.this.cache.offer(con)) {
                        con.close();
                    }
                    return null;
                }
                if (method.getName().equals("isClosed") && method.getParameterCount() == 0) {
                    return this.closed;
                }
                if (this.closed) {
                    throw new SQLException("Connection closed");
                }
                return method.invoke((Object)con, args);
            }
        });
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

