/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command.bundletree;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.karaf.bundle.command.bundletree.Tree;

public class Node<T> {
    private final T value;
    private Node<T> parent;
    private List<Node<T>> children = new LinkedList<Node<T>>();

    protected Node(T value) {
        this.value = value;
    }

    protected Node(T value, Node<T> parent) {
        this(value);
        this.parent = parent;
    }

    public T getValue() {
        return this.value;
    }

    public List<Node<T>> getChildren() {
        return this.children;
    }

    public Node<T> addChild(T value) {
        Node<T> node = new Node<T>(value, this);
        this.children.add(node);
        return node;
    }

    public Set<T> flatten() {
        HashSet<T> result = new HashSet<T>();
        result.add(this.getValue());
        for (Node<T> child : this.getChildren()) {
            result.addAll(child.flatten());
        }
        return result;
    }

    public boolean hasAncestor(T value) {
        if (this.parent == null) {
            return false;
        }
        return value.equals(this.parent.value) || this.parent.hasAncestor(value);
    }

    public boolean hasChild(T value) {
        for (Node<T> child : this.getChildren()) {
            if (!value.equals(child.getValue())) continue;
            return true;
        }
        return false;
    }

    protected void write(PrintWriter writer, Tree.Converter<T> converter, boolean ... indents) {
        for (boolean indent : indents) {
            writer.printf("%-3s", indent ? "|" : "");
        }
        writer.printf("+- %s%n", converter.toString(this));
        Object object = this.getChildren().iterator();
        while (object.hasNext()) {
            Node child = (Node)object.next();
            child.write(writer, converter, this.concat(indents, this.hasNextSibling()));
        }
    }

    private boolean hasNextSibling() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.getChildren().size() > 1 && this.parent.getChildren().indexOf(this) < this.parent.getChildren().size() - 1;
    }

    private boolean[] concat(boolean[] array, boolean element) {
        boolean[] result = new boolean[array.length + 1];
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = element;
        return result;
    }
}

