/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.parser;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.parser.Parser;
import org.apache.aries.blueprint.reflect.MetadataUtil;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParserContextImpl
implements ParserContext {
    private final Parser parser;
    private final ComponentDefinitionRegistry componentDefinitionRegistry;
    private final ComponentMetadata enclosingComponent;
    private final Node sourceNode;

    public ParserContextImpl(Parser parser, ComponentDefinitionRegistry componentDefinitionRegistry, ComponentMetadata enclosingComponent, Node sourceNode) {
        this.parser = parser;
        this.componentDefinitionRegistry = componentDefinitionRegistry;
        this.enclosingComponent = enclosingComponent;
        this.sourceNode = sourceNode;
    }

    @Override
    public ComponentDefinitionRegistry getComponentDefinitionRegistry() {
        return this.componentDefinitionRegistry;
    }

    @Override
    public ComponentMetadata getEnclosingComponent() {
        return this.enclosingComponent;
    }

    @Override
    public Node getSourceNode() {
        return this.sourceNode;
    }

    @Override
    public <T extends Metadata> T createMetadata(Class<T> type) {
        return MetadataUtil.createMetadata(type);
    }

    @Override
    public <T> T parseElement(Class<T> type, ComponentMetadata enclosingComponent, Element element) {
        return this.parser.parseElement(type, enclosingComponent, element);
    }

    public Parser getParser() {
        return this.parser;
    }

    @Override
    public String generateId() {
        return this.parser.generateId();
    }

    @Override
    public String getDefaultActivation() {
        return this.parser.getDefaultActivation();
    }

    @Override
    public String getDefaultAvailability() {
        return this.parser.getDefaultAvailability();
    }

    @Override
    public String getDefaultTimeout() {
        return this.parser.getDefaultTimeout();
    }

    @Override
    public Set<URI> getNamespaces() {
        return Collections.unmodifiableSet(this.parser.getNamespaces());
    }

    @Override
    public NamespaceHandler getNamespaceHandler(URI namespaceUri) {
        return this.parser.getNamespaceHandler(namespaceUri);
    }
}

