/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPTarget;
import org.apache.aries.jmx.blueprint.codec.TransferObject;
import org.apache.aries.jmx.blueprint.codec.Util;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.RegistrationListener;

public class BPRegistrationListener
implements TransferObject {
    private BPTarget listenerComponent;
    private String registrationMethod;
    private String unregistrationMethod;

    public BPRegistrationListener(CompositeData listener) {
        this.registrationMethod = (String)listener.get("RegistrationMethod");
        this.unregistrationMethod = (String)listener.get("UnregistrationMethod");
        Byte[] buf = (Byte[])listener.get("ListenerComponent");
        this.listenerComponent = (BPTarget)Util.boxedBinary2BPMetadata(buf);
    }

    public BPRegistrationListener(RegistrationListener listener) {
        this.registrationMethod = listener.getRegistrationMethod();
        this.unregistrationMethod = listener.getUnregistrationMethod();
        this.listenerComponent = (BPTarget)Util.metadata2BPMetadata((Metadata)listener.getListenerComponent());
    }

    @Override
    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("RegistrationMethod", this.registrationMethod);
        items.put("UnregistrationMethod", this.unregistrationMethod);
        items.put("ListenerComponent", Util.bpMetadata2BoxedBinary(this.listenerComponent));
        try {
            return new CompositeDataSupport(BlueprintMetadataMBean.REGISTRATION_LISTENER_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public BPTarget getListenerComponent() {
        return this.listenerComponent;
    }

    public String getRegistrationMethod() {
        return this.registrationMethod;
    }

    public String getUnregistrationMethod() {
        return this.unregistrationMethod;
    }
}

