/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;

@Command(scope="shell", name="alias", description="Create an alias to a command")
@Service
public class AliasAction
implements Action {
    @Argument(index=0, name="command", description="The command to alias, e.g. 'ldn = { log:display -n $args }'", required=true, multiValued=false)
    private String alias;
    @Option(name="--persist", aliases={"-p"}, description="Add this flag to persist the alias in ${karaf.etc}/shell.init.script")
    private boolean persist;
    @Reference
    Session session;

    public Object execute() throws Exception {
        this.session.execute((CharSequence)this.alias);
        if (this.persist) {
            String karafEtc = this.session.get("karaf.etc").toString();
            try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(new File(karafEtc, "shell.init.script"), true)));){
                writer.write("\n" + this.alias + ";");
            }
        }
        return null;
    }
}

