/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class Scanner
implements Closeable {
    public static final String SUBDIR_MODE_JAR = "jar";
    public static final String SUBDIR_MODE_SKIP = "skip";
    public static final String SUBDIR_MODE_RECURSE = "recurse";
    final File directory;
    final FilenameFilter filter;
    final boolean jarSubdir;
    final boolean skipSubdir;
    final boolean recurseSubdir;
    Map<File, Long> lastChecksums = new HashMap<File, Long>();
    Map<File, Long> storedChecksums = new HashMap<File, Long>();

    public Scanner(File directory) {
        this(directory, null, null);
    }

    public Scanner(File directory, final String filterString, String subdirMode) {
        this.directory = Scanner.canon(directory);
        this.filter = filterString != null && filterString.length() > 0 ? new FilenameFilter(){
            Pattern pattern;
            {
                this.pattern = Pattern.compile(filterString);
            }

            @Override
            public boolean accept(File dir, String name) {
                return this.pattern.matcher(name).matches();
            }
        } : null;
        this.jarSubdir = subdirMode == null || SUBDIR_MODE_JAR.equals(subdirMode);
        this.skipSubdir = SUBDIR_MODE_SKIP.equals(subdirMode);
        this.recurseSubdir = SUBDIR_MODE_RECURSE.equals(subdirMode);
    }

    public void initialize(Map<File, Long> checksums) {
        this.storedChecksums.putAll(checksums);
    }

    public Set<File> scan(boolean reportImmediately) {
        File[] list = this.directory.listFiles();
        Set<File> files = this.processFiles(reportImmediately, list);
        return new TreeSet<File>(files);
    }

    private Set<File> processFiles(boolean reportImmediately, File[] list) {
        if (list == null) {
            return new HashSet<File>();
        }
        HashSet<File> files = new HashSet<File>();
        HashSet<File> removed = new HashSet<File>(this.storedChecksums.keySet());
        for (File file : list) {
            if (file.isDirectory()) {
                if (this.skipSubdir) continue;
                if (this.recurseSubdir) {
                    files.addAll(this.processFiles(reportImmediately, file.listFiles()));
                    continue;
                }
            } else if (!this.filter.accept(file.getParentFile(), file.getName())) continue;
            long lastChecksum = this.lastChecksums.get(file) != null ? this.lastChecksums.get(file) : 0L;
            long storedChecksum = this.storedChecksums.get(file) != null ? this.storedChecksums.get(file) : 0L;
            long newChecksum = Scanner.checksum(file);
            this.lastChecksums.put(file, newChecksum);
            if ((newChecksum == lastChecksum || reportImmediately) && newChecksum != storedChecksum) {
                this.storedChecksums.put(file, newChecksum);
                files.add(file);
            }
            removed.remove(file);
        }
        files.addAll(removed);
        for (File file : removed) {
            this.lastChecksums.remove(file);
            this.storedChecksums.remove(file);
        }
        return files;
    }

    @Override
    public void close() throws IOException {
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public long getChecksum(File file) {
        Long c = this.storedChecksums.get(file);
        return c != null ? c : 0L;
    }

    public void updateChecksum(File file) {
        if (file != null && this.storedChecksums.containsKey(file)) {
            long newChecksum = Scanner.checksum(file);
            this.storedChecksums.put(file, newChecksum);
        }
    }

    static long checksum(File file) {
        CRC32 crc = new CRC32();
        Scanner.checksum(file, crc);
        return crc.getValue();
    }

    private static void checksum(File file, CRC32 crc) {
        File[] children;
        crc.update(file.getName().getBytes());
        if (file.isFile()) {
            Scanner.checksum(file.lastModified(), crc);
            Scanner.checksum(file.length(), crc);
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File aChildren : children) {
                Scanner.checksum(aChildren, crc);
            }
        }
    }

    private static void checksum(long l, CRC32 crc) {
        for (int i = 0; i < 8; ++i) {
            crc.update((int)(l & 0xFFL));
            l >>= 8;
        }
    }
}

