/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils.generics;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.apache.aries.blueprint.utils.generics.ClassUtil;
import org.apache.aries.blueprint.utils.generics.GenericsUtil;
import org.apache.aries.blueprint.utils.generics.OwbGenericArrayTypeImpl;
import org.apache.aries.blueprint.utils.generics.OwbParametrizedTypeImpl;
import org.apache.aries.blueprint.utils.generics.OwbTypeVariableImpl;
import org.apache.aries.blueprint.utils.generics.OwbWildcardTypeImpl;

public class TypeInference {
    private static final long COST_ASSIGN = 1L;
    private static final long COST_CAST = 100L;
    private static final long COST_CONVERT = 10000L;

    public static List<Match<Constructor<?>>> findMatchingConstructors(Type clazz, List<TypedObject> args, Converter converter, boolean reorder) {
        List executables = TypeInference.findConstructors(clazz, args.size());
        return TypeInference.findMatching(executables, args, converter, reorder);
    }

    public static List<Match<Method>> findMatchingMethods(Type clazz, String name, List<TypedObject> args, Converter converter, boolean reorder) {
        List executables = TypeInference.findMethods(clazz, name, true, args.size());
        return TypeInference.findMatching(executables, args, converter, reorder);
    }

    public static List<Match<Method>> findMatchingStatics(Type clazz, String name, List<TypedObject> args, Converter converter, boolean reorder) {
        List executables = TypeInference.findMethods(clazz, name, false, args.size());
        return TypeInference.findMatching(executables, args, converter, reorder);
    }

    private static List<Method> applyStaticHidingRules(Collection<Method> methods) {
        ArrayList<Method> result = new ArrayList<Method>(methods.size());
        for (Method m : methods) {
            boolean toBeAdded = true;
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Class<?> otherClass;
                Method other = (Method)it.next();
                if (!TypeInference.hasIdenticalParameters(m, other)) continue;
                Class<?> mClass = m.getDeclaringClass();
                if (mClass.isAssignableFrom(otherClass = other.getDeclaringClass())) {
                    toBeAdded = false;
                    break;
                }
                if (!otherClass.isAssignableFrom(mClass)) continue;
                it.remove();
            }
            if (!toBeAdded) continue;
            result.add(m);
        }
        return result;
    }

    private static boolean hasIdenticalParameters(Method one, Method two) {
        Class<?>[] twoTypes;
        Class<?>[] oneTypes = one.getParameterTypes();
        if (oneTypes.length != (twoTypes = two.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < oneTypes.length; ++i) {
            if (oneTypes[i].equals(twoTypes[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Executable<Constructor<?>>> findConstructors(Type clazz, int size) {
        void var5_7;
        ArrayList constructors = new ArrayList();
        Constructor<?>[] constructorArray = ClassUtil.getClass(clazz).getConstructors();
        int n = constructorArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            Constructor<?> constructor = constructorArray[var5_7];
            if (constructor.getGenericParameterTypes().length == size) {
                constructors.add(constructor);
            }
            ++var5_7;
        }
        ArrayList executables = new ArrayList();
        for (Constructor constructor : constructors) {
            executables.add(new ConstructorExecutable(constructor));
        }
        return executables;
    }

    private static List<Executable<Method>> findMethods(Type clazz, String name, boolean instance, int size) {
        List<Method> methods = new ArrayList<Method>();
        for (Method method : ReflectionUtils.getPublicMethods(ClassUtil.getClass(clazz))) {
            if (instance == Modifier.isStatic(method.getModifiers()) || method.isBridge() || !method.getName().equals(name) || method.getGenericParameterTypes().length != size) continue;
            methods.add(method);
        }
        methods = TypeInference.applyStaticHidingRules(methods);
        ArrayList<Executable<Method>> executables = new ArrayList<Executable<Method>>();
        for (Method method : methods) {
            executables.add(new MethodExecutable(method));
        }
        return executables;
    }

    private static <E> List<Match<E>> findMatching(List<Executable<E>> executables, List<TypedObject> args, Converter converter, boolean reorder) {
        Comparator comparator = new Comparator<Match<E>>(){

            @Override
            public int compare(Match<E> o1, Match<E> o2) {
                return o1.getScore() - o2.getScore();
            }
        };
        ArrayList<Match<Match<E>>> matches = new ArrayList<Match<Match<E>>>();
        for (Executable<E> e : executables) {
            Match<E> match = TypeInference.match(e, args, converter);
            if (match == null) continue;
            matches.add(match);
        }
        Collections.sort(matches, comparator);
        if (matches.isEmpty() && reorder) {
            long l = TypeInference.factorial(args.size());
            for (long p = 1L; p < l; ++p) {
                List<TypedObject> pargs = TypeInference.permutation(p, args);
                for (Executable<E> e : executables) {
                    Match<E> match = TypeInference.match(e, pargs, converter);
                    if (match == null) continue;
                    matches.add(match);
                }
            }
            Collections.sort(matches, comparator);
        }
        return matches;
    }

    private static <E> Match<E> match(Executable<E> executable, List<TypedObject> args, Converter converter) {
        HashMap variables = new HashMap();
        Type[] parameterTypes = executable.getGenericParameterTypes();
        boolean allowCast = true;
        for (int i = 0; i < parameterTypes.length; ++i) {
            TypedObject arg = args.get(i);
            Type needed = parameterTypes[i];
            if (!GenericsUtil.containsTypeVariable(needed) || !ClassUtil.getClass(needed).isAssignableFrom(ClassUtil.getClass(arg.type))) continue;
            try {
                Type[] neededTypes = TypeInference.getParameters(needed);
                Type[] actualTypes = TypeInference.getParameters(ClassUtil.getClass(needed), arg.type);
                for (int j = 0; j < neededTypes.length; ++j) {
                    if (!(neededTypes[j] instanceof TypeVariable)) continue;
                    TypeVariable tv = (TypeVariable)neededTypes[j];
                    Type t = (Type)variables.get(tv);
                    t = TypeInference.mergeBounds(t, actualTypes[j]);
                    variables.put(tv, t);
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                allowCast = false;
            }
        }
        int score = 0;
        ArrayList<TypedObject> converted = new ArrayList<TypedObject>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            TypedObject arg = args.get(i);
            Type needed = parameterTypes[i];
            long sc = needed == arg.type ? 1L : (allowCast && ClassUtil.getClass(needed).isAssignableFrom(ClassUtil.getClass(arg.type)) ? 100L : 10000L);
            try {
                Type real = TypeInference.mapVariables(needed, variables);
                converted.add(converter.convert(arg, real));
                score = (int)((long)score + sc);
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return new Match<E>(executable.getMember(), converted, variables, score);
    }

    private static Type[] mapVariables(Type[] types, Map<TypeVariable<?>, Type> variables) {
        Type[] resolved = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = TypeInference.mapVariables(types[i], variables);
        }
        return resolved;
    }

    private static Type mapVariables(Type type, Map<TypeVariable<?>, Type> variables) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return new OwbParametrizedTypeImpl(TypeInference.mapVariables(pt.getOwnerType(), variables), TypeInference.mapVariables(pt.getRawType(), variables), TypeInference.mapVariables(pt.getActualTypeArguments(), variables));
        }
        if (type instanceof TypeVariable) {
            return variables.containsKey(type) ? variables.get(type) : type;
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            return new OwbWildcardTypeImpl(TypeInference.mapVariables(wt.getUpperBounds(), variables), TypeInference.mapVariables(wt.getLowerBounds(), variables));
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return new OwbGenericArrayTypeImpl(TypeInference.mapVariables(gat.getGenericComponentType(), variables));
        }
        throw new UnsupportedOperationException();
    }

    private static Type mergeBounds(Type t1, Type t2) {
        HashSet<Type> types = new HashSet<Type>();
        TypeVariable vt = null;
        if (t1 instanceof TypeVariable) {
            Collections.addAll(types, ((TypeVariable)t1).getBounds());
            vt = (TypeVariable)t1;
        } else if (t1 != null) {
            types.add(t1);
        }
        if (t2 instanceof TypeVariable) {
            Collections.addAll(types, ((TypeVariable)t2).getBounds());
            vt = (TypeVariable)t2;
        } else if (t2 != null) {
            types.add(t2);
        }
        ArrayList<Type> bounds = new ArrayList<Type>();
        Class cl = null;
        for (Type type : types) {
            if (!TypeInference.isClass(type)) continue;
            cl = cl != null ? TypeInference.reduceClasses(cl, (Class)type) : (Class)type;
        }
        if (cl != null) {
            bounds.add(cl);
        }
        List<Type> l = Collections.emptyList();
        for (Type type : types) {
            if (TypeInference.isClass(type)) continue;
            l = TypeInference.reduceTypes(l, Collections.singletonList(type));
        }
        bounds.addAll(l);
        if (bounds.size() == 1) {
            return (Type)bounds.get(0);
        }
        return OwbTypeVariableImpl.createTypeVariable(vt, bounds.toArray(new Type[bounds.size()]));
    }

    private static boolean isClass(Type t) {
        Class<?> c = ClassUtil.getClass(t);
        return !c.isInterface() && !c.isEnum();
    }

    private static List<Type> reduceTypes(List<Type> l1, List<Type> l2) {
        boolean discard;
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type t1 : l1) {
            discard = false;
            for (Type t2 : l2) {
                discard |= GenericsUtil.isAssignableFrom(false, false, t1, t2);
            }
            if (discard) continue;
            types.add(t1);
        }
        for (Type t2 : l2) {
            discard = false;
            for (Type t1 : l1) {
                discard |= GenericsUtil.isAssignableFrom(false, false, t1, t2);
            }
            if (discard) continue;
            types.add(t2);
        }
        return types;
    }

    private static Class reduceClasses(Class<?> c1, Class<?> c2) {
        if (c1.isAssignableFrom(c2)) {
            return c1;
        }
        if (c2.isAssignableFrom(c1)) {
            return c2;
        }
        throw new IllegalArgumentException("Illegal bounds: " + c1 + ", " + c2);
    }

    private static Type[] getParameters(Class<?> neededClass, Type type) {
        return GenericsUtil.resolveTypes(TypeInference.getParameters(neededClass), type);
    }

    private static long factorial(int n) {
        if (n > 20 || n < 0) {
            throw new IllegalArgumentException(n + " is out of range");
        }
        long l = 1L;
        for (int i = 2; i <= n; ++i) {
            l *= (long)i;
        }
        return l;
    }

    private static <T> List<T> permutation(long no, List<T> items) {
        return TypeInference.permutationHelper(no, new LinkedList<T>(items), new ArrayList());
    }

    private static <T> List<T> permutationHelper(long no, LinkedList<T> in, List<T> out) {
        if (in.isEmpty()) {
            return out;
        }
        long subFactorial = TypeInference.factorial(in.size() - 1);
        out.add(in.remove((int)(no / subFactorial)));
        return TypeInference.permutationHelper((int)(no % subFactorial), in, out);
    }

    private static Type[] getParameters(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return clazz.getComponentType().getTypeParameters();
            }
            return clazz.getTypeParameters();
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        throw new RuntimeException("Unknown type " + type);
    }

    private static class MethodExecutable
    implements Executable<Method> {
        private final Method method;

        private MethodExecutable(Method method) {
            this.method = method;
        }

        @Override
        public Method getMember() {
            return this.method;
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }
    }

    private static class ConstructorExecutable
    implements Executable<Constructor<?>> {
        private final Constructor<?> constructor;

        private ConstructorExecutable(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public Constructor<?> getMember() {
            return this.constructor;
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return this.constructor.getGenericParameterTypes();
        }
    }

    private static interface Executable<T> {
        public T getMember();

        public Type[] getGenericParameterTypes();
    }

    public static interface Converter {
        public TypedObject convert(TypedObject var1, Type var2) throws Exception;
    }

    public static class TypedObject {
        final Type type;
        final Object value;

        public TypedObject(Type type, Object value) {
            this.type = type;
            this.value = value;
        }

        public Type getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class Match<E> {
        final E e;
        final List<TypedObject> args;
        final Map<TypeVariable<?>, Type> inferred;
        final int score;

        Match(E e, List<TypedObject> args, Map<TypeVariable<?>, Type> inferred, int score) {
            this.e = e;
            this.args = args;
            this.inferred = inferred;
            this.score = score;
        }

        public E getMember() {
            return this.e;
        }

        public List<TypedObject> getArgs() {
            return this.args;
        }

        public Map<TypeVariable<?>, Type> getInferred() {
            return this.inferred;
        }

        public int getScore() {
            return this.score;
        }
    }
}

