/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;

public interface JohnzonJsonParser
extends JsonParser {
    public boolean isFitLong();

    public boolean isNotTooLong();

    default public JsonParser.Event current() {
        throw new UnsupportedOperationException("getting the current JsonParser Event is not supported");
    }

    public static class JohnzonJsonParserWrapper
    implements JohnzonJsonParser {
        private final JsonParser jsonParser;

        public JohnzonJsonParserWrapper(JsonParser jsonParser) {
            this.jsonParser = jsonParser;
        }

        @Override
        public boolean isFitLong() {
            return JohnzonJsonParser.class.isInstance(this.jsonParser) ? ((JohnzonJsonParser)JohnzonJsonParser.class.cast(this.jsonParser)).isFitLong() : false;
        }

        @Override
        public boolean isNotTooLong() {
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.jsonParser.hasNext();
        }

        @Override
        public JsonParser.Event next() {
            return this.jsonParser.next();
        }

        @Override
        public String getString() {
            return this.jsonParser.getString();
        }

        @Override
        public boolean isIntegralNumber() {
            return this.jsonParser.isIntegralNumber();
        }

        @Override
        public int getInt() {
            return this.jsonParser.getInt();
        }

        @Override
        public long getLong() {
            return this.jsonParser.getLong();
        }

        @Override
        public BigDecimal getBigDecimal() {
            return this.jsonParser.getBigDecimal();
        }

        @Override
        public JsonLocation getLocation() {
            return this.jsonParser.getLocation();
        }

        @Override
        public void close() {
            this.jsonParser.close();
        }

        @Override
        public JsonObject getObject() {
            return this.jsonParser.getObject();
        }

        @Override
        public JsonValue getValue() {
            return this.jsonParser.getValue();
        }

        @Override
        public JsonArray getArray() {
            return this.jsonParser.getArray();
        }

        @Override
        public Stream<JsonValue> getArrayStream() {
            return this.jsonParser.getArrayStream();
        }

        @Override
        public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
            return this.jsonParser.getObjectStream();
        }

        @Override
        public Stream<JsonValue> getValueStream() {
            return this.jsonParser.getValueStream();
        }

        @Override
        public void skipArray() {
            this.jsonParser.skipArray();
        }

        @Override
        public void skipObject() {
            this.jsonParser.skipObject();
        }
    }
}

