/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.ArrayList;
import java.util.List;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.ColorPalette;
import org.jline.utils.Colors;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;
import org.jline.utils.WCWidth;

public abstract class AttributedCharSequence
implements CharSequence {
    public static final int TRUE_COLORS = 0x1000000;
    private static final int HIGH_COLORS = Short.MAX_VALUE;
    static final boolean DISABLE_ALTERNATE_CHARSET = Boolean.getBoolean("org.jline.utils.disableAlternateCharset");

    public void print(Terminal terminal) {
        terminal.writer().print(this.toAnsi(terminal));
    }

    public void println(Terminal terminal) {
        terminal.writer().println(this.toAnsi(terminal));
    }

    public String toAnsi() {
        return this.toAnsi(null);
    }

    public String toAnsi(Terminal terminal) {
        if (terminal != null && "dumb".equals(terminal.getType())) {
            return this.toString();
        }
        int colors = 256;
        ForceMode forceMode = ForceMode.None;
        ColorPalette palette = null;
        String alternateIn = null;
        String alternateOut = null;
        if (terminal != null) {
            Integer max_colors = terminal.getNumericCapability(InfoCmp.Capability.max_colors);
            if (max_colors != null) {
                colors = max_colors;
            }
            if ("windows-256color".equals(terminal.getType()) || "windows-conemu".equals(terminal.getType())) {
                forceMode = ForceMode.Force256Colors;
            }
            palette = terminal.getPalette();
            if (!DISABLE_ALTERNATE_CHARSET) {
                alternateIn = Curses.tputs(terminal.getStringCapability(InfoCmp.Capability.enter_alt_charset_mode), new Object[0]);
                alternateOut = Curses.tputs(terminal.getStringCapability(InfoCmp.Capability.exit_alt_charset_mode), new Object[0]);
            }
        }
        return this.toAnsi(colors, forceMode, palette, alternateIn, alternateOut);
    }

    @Deprecated
    public String toAnsi(int colors, boolean force256colors) {
        return this.toAnsi(colors, force256colors, null, null);
    }

    @Deprecated
    public String toAnsi(int colors, boolean force256colors, String altIn, String altOut) {
        return this.toAnsi(colors, force256colors ? ForceMode.Force256Colors : ForceMode.None, null, altIn, altOut);
    }

    public String toAnsi(int colors, ForceMode force) {
        return this.toAnsi(colors, force, null, null, null);
    }

    public String toAnsi(int colors, ForceMode force, ColorPalette palette) {
        return this.toAnsi(colors, force, palette, null, null);
    }

    public String toAnsi(int colors, ForceMode force, ColorPalette palette, String altIn, String altOut) {
        StringBuilder sb = new StringBuilder();
        long style = 0L;
        long foreground = 0L;
        long background = 0L;
        boolean alt = false;
        if (palette == null) {
            palette = ColorPalette.DEFAULT;
        }
        for (int i = 0; i < this.length(); ++i) {
            long s;
            char c = this.charAt(i);
            if (altIn != null && altOut != null) {
                char pc = c;
                switch (c) {
                    case '\u2518': {
                        c = 'j';
                        break;
                    }
                    case '\u2510': {
                        c = 'k';
                        break;
                    }
                    case '\u250c': {
                        c = 'l';
                        break;
                    }
                    case '\u2514': {
                        c = 'm';
                        break;
                    }
                    case '\u253c': {
                        c = 'n';
                        break;
                    }
                    case '\u2500': {
                        c = 'q';
                        break;
                    }
                    case '\u251c': {
                        c = 't';
                        break;
                    }
                    case '\u2524': {
                        c = 'u';
                        break;
                    }
                    case '\u2534': {
                        c = 'v';
                        break;
                    }
                    case '\u252c': {
                        c = 'w';
                        break;
                    }
                    case '\u2502': {
                        c = 'x';
                    }
                }
                boolean oldalt = alt;
                boolean bl = alt = c != pc;
                if (oldalt ^ alt) {
                    sb.append(alt ? altIn : altOut);
                }
            }
            if (style != (s = this.styleCodeAt(i) & 0xFFFFFFFFFFFFEFFFL)) {
                long bg;
                long d = (style ^ s) & 0x1FFFL;
                long fg = (s & 0x300L) != 0L ? s & 0x7FFFFF8300L : 0L;
                long l = bg = (s & 0xC00L) != 0L ? s & 0x7FFFFF8000000C00L : 0L;
                if (s == 0L) {
                    sb.append("\u001b[0m");
                    background = 0L;
                    foreground = 0L;
                } else {
                    int b;
                    int g;
                    int r;
                    int col;
                    int b2;
                    int g2;
                    int r2;
                    int rounded;
                    sb.append("\u001b[");
                    boolean first = true;
                    if ((d & 4L) != 0L) {
                        first = AttributedCharSequence.attr(sb, (s & 4L) != 0L ? "3" : "23", first);
                    }
                    if ((d & 8L) != 0L) {
                        first = AttributedCharSequence.attr(sb, (s & 8L) != 0L ? "4" : "24", first);
                    }
                    if ((d & 0x10L) != 0L) {
                        first = AttributedCharSequence.attr(sb, (s & 0x10L) != 0L ? "5" : "25", first);
                    }
                    if ((d & 0x20L) != 0L) {
                        first = AttributedCharSequence.attr(sb, (s & 0x20L) != 0L ? "7" : "27", first);
                    }
                    if ((d & 0x40L) != 0L) {
                        first = AttributedCharSequence.attr(sb, (s & 0x40L) != 0L ? "8" : "28", first);
                    }
                    if ((d & 0x80L) != 0L) {
                        first = AttributedCharSequence.attr(sb, (s & 0x80L) != 0L ? "9" : "29", first);
                    }
                    if (foreground != fg) {
                        if (fg > 0L) {
                            rounded = -1;
                            if ((fg & 0x200L) != 0L) {
                                r2 = (int)(fg >> 31) & 0xFF;
                                g2 = (int)(fg >> 23) & 0xFF;
                                b2 = (int)(fg >> 15) & 0xFF;
                                if (colors >= Short.MAX_VALUE) {
                                    first = AttributedCharSequence.attr(sb, "38;2;" + r2 + ";" + g2 + ";" + b2, first);
                                } else {
                                    rounded = palette.round(r2, g2, b2);
                                }
                            } else if ((fg & 0x100L) != 0L) {
                                rounded = palette.round((int)(fg >> 15) & 0xFF);
                            }
                            if (rounded >= 0) {
                                if (colors >= Short.MAX_VALUE && force == ForceMode.ForceTrueColors) {
                                    col = palette.getColor(rounded);
                                    r = col >> 16 & 0xFF;
                                    g = col >> 8 & 0xFF;
                                    b = col & 0xFF;
                                    first = AttributedCharSequence.attr(sb, "38;2;" + r + ";" + g + ";" + b, first);
                                } else if (force == ForceMode.Force256Colors || rounded >= 16) {
                                    first = AttributedCharSequence.attr(sb, "38;5;" + rounded, first);
                                } else if (rounded >= 8) {
                                    first = AttributedCharSequence.attr(sb, "9" + (rounded - 8), first);
                                    d |= s & 1L;
                                } else {
                                    first = AttributedCharSequence.attr(sb, "3" + rounded, first);
                                    d |= s & 1L;
                                }
                            }
                        } else {
                            first = AttributedCharSequence.attr(sb, "39", first);
                        }
                        foreground = fg;
                    }
                    if (background != bg) {
                        if (bg > 0L) {
                            rounded = -1;
                            if ((bg & 0x800L) != 0L) {
                                r2 = (int)(bg >> 55) & 0xFF;
                                g2 = (int)(bg >> 47) & 0xFF;
                                b2 = (int)(bg >> 39) & 0xFF;
                                if (colors >= Short.MAX_VALUE) {
                                    first = AttributedCharSequence.attr(sb, "48;2;" + r2 + ";" + g2 + ";" + b2, first);
                                } else {
                                    rounded = palette.round(r2, g2, b2);
                                }
                            } else if ((bg & 0x400L) != 0L) {
                                rounded = palette.round((int)(bg >> 39) & 0xFF);
                            }
                            if (rounded >= 0) {
                                if (colors >= Short.MAX_VALUE && force == ForceMode.ForceTrueColors) {
                                    col = palette.getColor(rounded);
                                    r = col >> 16 & 0xFF;
                                    g = col >> 8 & 0xFF;
                                    b = col & 0xFF;
                                    first = AttributedCharSequence.attr(sb, "48;2;" + r + ";" + g + ";" + b, first);
                                } else {
                                    first = force == ForceMode.Force256Colors || rounded >= 16 ? AttributedCharSequence.attr(sb, "48;5;" + rounded, first) : (rounded >= 8 ? AttributedCharSequence.attr(sb, "10" + (rounded - 8), first) : AttributedCharSequence.attr(sb, "4" + rounded, first));
                                }
                            }
                        } else {
                            first = AttributedCharSequence.attr(sb, "49", first);
                        }
                        background = bg;
                    }
                    if ((d & 3L) != 0L) {
                        if ((d & 1L) != 0L && (s & 1L) == 0L || (d & 2L) != 0L && (s & 2L) == 0L) {
                            first = AttributedCharSequence.attr(sb, "22", first);
                        }
                        if ((d & 1L) != 0L && (s & 1L) != 0L) {
                            first = AttributedCharSequence.attr(sb, "1", first);
                        }
                        if ((d & 2L) != 0L && (s & 2L) != 0L) {
                            first = AttributedCharSequence.attr(sb, "2", first);
                        }
                    }
                    sb.append("m");
                }
                style = s;
            }
            sb.append(c);
        }
        if (alt) {
            sb.append(altOut);
        }
        if (style != 0L) {
            sb.append("\u001b[0m");
        }
        return sb.toString();
    }

    @Deprecated
    public static int rgbColor(int col) {
        return Colors.rgbColor(col);
    }

    @Deprecated
    public static int roundColor(int col, int max) {
        return Colors.roundColor(col, max);
    }

    @Deprecated
    public static int roundRgbColor(int r, int g, int b, int max) {
        return Colors.roundRgbColor(r, g, b, max);
    }

    private static boolean attr(StringBuilder sb, String s, boolean first) {
        if (!first) {
            sb.append(";");
        }
        sb.append(s);
        return false;
    }

    public abstract AttributedStyle styleAt(int var1);

    long styleCodeAt(int index) {
        return this.styleAt(index).getStyle();
    }

    public boolean isHidden(int index) {
        return (this.styleCodeAt(index) & 0x1000L) != 0L;
    }

    public int runStart(int index) {
        AttributedStyle style = this.styleAt(index);
        while (index > 0 && this.styleAt(index - 1).equals(style)) {
            --index;
        }
        return index;
    }

    public int runLimit(int index) {
        AttributedStyle style = this.styleAt(index);
        while (index < this.length() - 1 && this.styleAt(index + 1).equals(style)) {
            ++index;
        }
        return index + 1;
    }

    @Override
    public abstract AttributedString subSequence(int var1, int var2);

    public AttributedString substring(int start, int end) {
        return this.subSequence(start, end);
    }

    protected abstract char[] buffer();

    protected abstract int offset();

    @Override
    public char charAt(int index) {
        return this.buffer()[this.offset() + index];
    }

    public int codePointAt(int index) {
        return Character.codePointAt(this.buffer(), index + this.offset());
    }

    public boolean contains(char c) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public int codePointBefore(int index) {
        return Character.codePointBefore(this.buffer(), index + this.offset());
    }

    public int codePointCount(int index, int length) {
        return Character.codePointCount(this.buffer(), index + this.offset(), length);
    }

    public int columnLength() {
        int cp;
        int cols = 0;
        int len = this.length();
        for (int cur = 0; cur < len; cur += Character.charCount(cp)) {
            cp = this.codePointAt(cur);
            if (this.isHidden(cur)) continue;
            cols += WCWidth.wcwidth(cp);
        }
        return cols;
    }

    public AttributedString columnSubSequence(int start, int stop) {
        int cp;
        int begin = 0;
        int col = 0;
        while (begin < this.length()) {
            int w;
            int cp2 = this.codePointAt(begin);
            int n = w = this.isHidden(begin) ? 0 : WCWidth.wcwidth(cp2);
            if (col + w > start) break;
            begin += Character.charCount(cp2);
            col += w;
        }
        int end = begin;
        while (end < this.length() && (cp = this.codePointAt(end)) != 10) {
            int w;
            int n = w = this.isHidden(end) ? 0 : WCWidth.wcwidth(cp);
            if (col + w > stop) break;
            end += Character.charCount(cp);
            col += w;
        }
        return this.subSequence(begin, end);
    }

    public List<AttributedString> columnSplitLength(int columns) {
        return this.columnSplitLength(columns, false, true);
    }

    public List<AttributedString> columnSplitLength(int columns, boolean includeNewlines, boolean delayLineWrap) {
        int cur;
        ArrayList<AttributedString> strings = new ArrayList<AttributedString>();
        int beg = cur = 0;
        int col = 0;
        while (cur < this.length()) {
            int w;
            int cp = this.codePointAt(cur);
            int n = w = this.isHidden(cur) ? 0 : WCWidth.wcwidth(cp);
            if (cp == 10) {
                strings.add(this.subSequence(beg, includeNewlines ? cur + 1 : cur));
                beg = cur + 1;
                col = 0;
            } else if ((col += w) > columns) {
                strings.add(this.subSequence(beg, cur));
                beg = cur;
                col = w;
            }
            cur += Character.charCount(cp);
        }
        strings.add(this.subSequence(beg, cur));
        return strings;
    }

    @Override
    public String toString() {
        return new String(this.buffer(), this.offset(), this.length());
    }

    public AttributedString toAttributedString() {
        return this.substring(0, this.length());
    }

    public static enum ForceMode {
        None,
        Force256Colors,
        ForceTrueColors;

    }
}

