/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkCheckAvailability;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005mf!B\u0014)\u0003\u0003y\u0003\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011A#\t\u0011%\u0003!\u0011!Q\u0001\n\u0019C\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0019\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003V\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011}\u0003!Q1A\u0005\u0002\u0001D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tW\u0002\u0011\t\u0019!C\u0005Y\"AQ\u000e\u0001BA\u0002\u0013%a\u000e\u0003\u0005u\u0001\t\u0005\t\u0015)\u0003e\u0011\u0015I\b\u0001\"\u0001{\u0011-\t)\u0001\u0001a\u0001\u0002\u0004%\t\"a\u0002\t\u0017\u0005=\u0001\u00011AA\u0002\u0013E\u0011\u0011\u0003\u0005\f\u0003+\u0001\u0001\u0019!A!B\u0013\tI\u0001C\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0003\u0002\u001c!I\u0011Q\u0005\u0001A\u0002\u0013%\u0011q\u0005\u0005\t\u0003W\u0001\u0001\u0015)\u0003\u0002\u001e!I\u0011Q\u0006\u0001C\u0002\u0013E\u0011q\u0006\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u00022!9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u0017\u0002A\u0011BA%\u0011\u001d\ti\u0005\u0001D\t\u0003\u0013Bq!a\u0014\u0001\r#\tI\u0005C\u0004\u0002R\u0001!\t!!\u0013\t\u000f\u0005M\u0003\u0001\"\u0003\u0002J!9\u0011Q\u000b\u0001\u0007\u0012\u0005%\u0003bBA,\u0001\u0019E\u0011\u0011\n\u0005\t\u00033\u0002A\u0011\u0001\u0015\u0002\\!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAR\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003K\u0003A\u0011AA%\u0011\u001d\t9\u000b\u0001C\u0001\u0003SC\u0001\"!-\u0001\t\u0003B\u00131\u0017\u0005\u0007\u0003s\u0003A\u0011\u00017\u0003A\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6DY&,g\u000e^'b]\u0006<WM\u001d\u0006\u0003S)\nA\u0001\\5oW*\u00111\u0006L\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00035\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001aYr\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g\r\u0005\u00028w9\u0011\u0001(O\u0007\u0002Q%\u0011!\bK\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0002={\ti1\t\\5f]Rl\u0015M\\1hKJT!A\u000f\u0015\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005c\u0013!B;uS2\u001c\u0018BA\"A\u0005\u001daunZ4j]\u001e\f!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feV\ta\t\u0005\u00029\u000f&\u0011\u0001\n\u000b\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T1oC\u001e,'/A\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b%\u0001\u0005mS:\\G)\u0019;b+\u0005a\u0005CA'Q\u001b\u0005q%BA(-\u0003\tQ8.\u0003\u0002R\u001d\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005YA.\u001b8l\u001b\u0016$(/[2t+\u0005)\u0006C\u0001\u001dW\u0013\t9\u0006F\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001\u00047j].lU\r\u001e:jGN\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u0005Y\u0006C\u0001\u001d]\u0013\ti\u0006F\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013\u0001\u00057j].\fE-\\5o\r\u0006\u001cGo\u001c:z+\u0005\t\u0007\u0003B\u0019cI\u001eL!a\u0019\u001a\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u001df\u0013\t1\u0007FA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0004\"\u0001\u000f5\n\u0005%D#AF\"mkN$XM\u001d'j].\fE-\\5o\u00072LWM\u001c;\u0002#1Lgn[!e[&tg)Y2u_JL\b%\u0001\u0006mS:\\7i\u001c8gS\u001e,\u0012\u0001Z\u0001\u000fY&t7nQ8oM&<w\fJ3r)\ty'\u000f\u0005\u00022a&\u0011\u0011O\r\u0002\u0005+:LG\u000fC\u0004t\u0019\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0013'A\u0006mS:\\7i\u001c8gS\u001e\u0004\u0003FA\u0007w!\t\tt/\u0003\u0002ye\tAao\u001c7bi&dW-\u0001\u0004=S:LGO\u0010\u000b\nwrlhp`A\u0001\u0003\u0007\u0001\"\u0001\u000f\u0001\t\u000b\u0011s\u0001\u0019\u0001$\t\u000b)s\u0001\u0019\u0001'\t\u000bMs\u0001\u0019A+\t\u000bes\u0001\u0019A.\t\u000b}s\u0001\u0019A1\t\u000b-t\u0001\u0019\u00013\u0002\u000b\u0005$W.\u001b8\u0016\u0005\u0005%\u0001\u0003B\u0019\u0002\f\u001dL1!!\u00043\u0005\u0019y\u0005\u000f^5p]\u0006I\u0011\rZ7j]~#S-\u001d\u000b\u0004_\u0006M\u0001\u0002C:\u0011\u0003\u0003\u0005\r!!\u0003\u0002\r\u0005$W.\u001b8!Q\t\tb/\u0001\u000fdYV\u001cH/\u001a:MS:\\7\t[3dW\u00063\u0018-\u001b7bE&d\u0017\u000e^=\u0016\u0005\u0005u\u0001#B\u0019\u0002\f\u0005}\u0001c\u0001\u001d\u0002\"%\u0019\u00111\u0005\u0015\u00039\rcWo\u001d;fe2Kgn[\"iK\u000e\\\u0017I^1jY\u0006\u0014\u0017\u000e\\5us\u0006\u00013\r\\;ti\u0016\u0014H*\u001b8l\u0007\",7m[!wC&d\u0017MY5mSRLx\fJ3r)\ry\u0017\u0011\u0006\u0005\tgN\t\t\u00111\u0001\u0002\u001e\u0005i2\r\\;ti\u0016\u0014H*\u001b8l\u0007\",7m[!wC&d\u0017MY5mSRL\b%\u0001\u0003m_\u000e\\WCAA\u0019!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tA\u0001\\1oO*\u0011\u00111H\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002@\u0005U\"AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%A\u0006de\u0016\fG/Z!e[&tG#A4\u0002\u000fM$\u0018M\u001d;vaR\tq.\u0001\nti\u0006\u0014H/\u001e9BGRLg/\u001a+bg.\u001c\u0018\u0001H:uCJ$X\u000f]!eI&$\u0018n\u001c8bY\u0006\u001bG/\u001b<f)\u0006\u001c8n]\u0001'gR\f'\u000f^;q\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017i\u0019;jm\u0016|%/\u00138bGRLg/\u001a+bg.\u001c\u0018\u0001C:ikR$wn\u001e8\u0002'MDW\u000f\u001e3po:\f5\r^5wKR\u000b7o[:\u0002;MDW\u000f\u001e3po:\fE\rZ5uS>t\u0017\r\\!di&4X\rV1tWN\fqe\u001d5vi\u0012|wO\\!eI&$\u0018n\u001c8bY\u0006\u001bG/\u001b<f\u001fJLe.Y2uSZ,G+Y:lg\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0015y\u0017QLA1\u0011\u0019\ty\u0006\ta\u0001I\u0006Ia.Z<D_:4\u0017n\u001a\u0005\b\u0003G\u0002\u0003\u0019AA3\u0003-)\b\u000fZ1uK\u0012\\U-_:\u0011\r\u0005\u001d\u0014QNA9\u001b\t\tIGC\u0002\u0002lI\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty'!\u001b\u0003\u0007M+G\u000f\u0005\u0003\u0002t\u0005\u0005e\u0002BA;\u0003{\u00022!a\u001e3\u001b\t\tIHC\u0002\u0002|9\na\u0001\u0010:p_Rt\u0014bAA@e\u00051\u0001K]3eK\u001aLA!a!\u0002\u0006\n11\u000b\u001e:j]\u001eT1!a 3\u0003!9W\r^!e[&tWCAAF!\u0011\ti)a(\u000e\u0005\u0005=%\u0002BA\u0003\u0003#SA!a%\u0002\u0016\u000691\r\\5f]R\u001c(bA\u0017\u0002\u0018*!\u0011\u0011TAN\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QT\u0001\u0004_J<\u0017\u0002BAQ\u0003\u001f\u0013abQ8oM2,XM\u001c;BI6Lg.A\tde\u0016\fG/Z!oIN+G/\u00113nS:\f!b\u00197pg\u0016\fE-\\5o\u0003!I7/Q2uSZ,GCAAV!\r\t\u0014QV\u0005\u0004\u0003_\u0013$a\u0002\"p_2,\u0017M\\\u0001\u0015_:\fe/Y5mC\nLG.\u001b;z\u0007\"\fgnZ3\u0015\u0007=\f)\fC\u0004\u00028\u0016\u0002\r!a+\u0002\u0017%\u001c\u0018I^1jY\u0006\u0014G.Z\u0001\u000eGV\u0014(/\u001a8u\u0007>tg-[4")
public abstract class AbstractClusterLinkClientManager
implements ClusterLinkFactory.ClientManager,
Logging {
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetrics linkMetrics;
    private final ClusterLinkScheduler scheduler;
    private final Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory;
    private volatile ClusterLinkConfig linkConfig;
    private volatile Option<ClusterLinkAdminClient> admin;
    private Option<ClusterLinkCheckAvailability> clusterLinkCheckAvailability;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetrics linkMetrics() {
        return this.linkMetrics;
    }

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory() {
        return this.linkAdminFactory;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    public Option<ClusterLinkAdminClient> admin() {
        return this.admin;
    }

    public void admin_$eq(Option<ClusterLinkAdminClient> x$1) {
        this.admin = x$1;
    }

    private Option<ClusterLinkCheckAvailability> clusterLinkCheckAvailability() {
        return this.clusterLinkCheckAvailability;
    }

    private void clusterLinkCheckAvailability_$eq(Option<ClusterLinkCheckAvailability> x$1) {
        this.clusterLinkCheckAvailability = x$1;
    }

    public Object lock() {
        return this.lock;
    }

    private ClusterLinkAdminClient createAdmin() {
        return (ClusterLinkAdminClient)this.linkAdminFactory().apply((Object)this.linkConfig());
    }

    @Override
    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Starting ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).toString());
        if (this.isActive()) {
            this.createAndSetAdmin();
            this.startupActiveTasks();
        }
        this.startupAdditionalActiveOrInactiveTasks();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Startup of ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void startupActiveTasks() {
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)new Some((Object)new ClusterLinkCheckAvailability(this.currentConfig(), this.linkMetrics(), this.clusterLinkManager(), Predef$.MODULE$.Integer2int(this.currentConfig().availabilityCheckMs()), this.scheduler(), this.linkData().linkName(), (Function0<ConfluentAdmin>)(Function0 & Serializable)() -> this.getAdmin())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
        this.startupAdditionalActiveTasks();
    }

    public abstract void startupAdditionalActiveTasks();

    public abstract void startupAdditionalActiveOrInactiveTasks();

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Shutting down ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).toString());
        this.shutdownAdditionalActiveOrInactiveTasks();
        if (this.isActive()) {
            this.shutdownActiveTasks();
            this.closeAdmin();
            this.admin_$eq(null);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Shutdown of ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void shutdownActiveTasks() {
        this.clusterLinkCheckAvailability().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)None$.MODULE$);
        this.shutdownAdditionalActiveTasks();
    }

    public abstract void shutdownAdditionalActiveTasks();

    public abstract void shutdownAdditionalActiveOrInactiveTasks();

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.lock();
        synchronized (object) {
            boolean oldActive = this.isActive();
            this.linkConfig_$eq(newConfig);
            boolean newActive = this.isActive();
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Reconfiguring ").append(this.getClass().getSimpleName()).append(". oldActive=").append(oldActive).append(" and newActive=").append(newActive).toString());
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(oldActive, newActive);
            if (oldActive || newActive) {
                if (!oldActive && newActive) {
                    this.createAndSetAdmin();
                    this.startupActiveTasks();
                } else if (oldActive && !newActive) {
                    this.shutdownActiveTasks();
                    this.closeAdmin();
                    this.admin_$eq((Option<ClusterLinkAdminClient>)None$.MODULE$);
                } else if (oldActive && newActive) {
                    if (updatedKeys.diff(ClusterLinkConfig$.MODULE$.ReplicationProps()).nonEmpty()) {
                        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Reconfiguring AdminClient and restarting tasks for ").append(this.getClass().getSimpleName()).toString());
                        this.createAndSetAdmin();
                        this.shutdownActiveTasks();
                        this.startupActiveTasks();
                    }
                } else {
                    throw new MatchError((Object)sp2);
                }
            }
            return;
        }
    }

    public ConfluentAdmin getAdmin() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(this.linkData()).toString());
        }
        return ((ClusterLinkAdminClient)currentAdmin.getOrElse((Function0 & Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.linkData().linkName()).append(" is paused").toString());
        })).admin();
    }

    public void createAndSetAdmin() {
        this.closeAdmin();
        this.admin_$eq((Option<ClusterLinkAdminClient>)new Some((Object)this.createAdmin()));
    }

    public void closeAdmin() {
        Option<ClusterLinkAdminClient> curAdmin = this.admin();
        if (curAdmin != null) {
            curAdmin.foreach((Function1 & Serializable)a -> {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> a.admin().close(Duration.ZERO), this, Level.WARN);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public boolean isActive() {
        return !Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused());
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Processing link availability change to ").append(isAvailable).toString());
            this.shutdownActiveTasks();
            if (!Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused())) {
                if (isAvailable) {
                    this.startupActiveTasks();
                } else {
                    int intervalMs = Math.max(10, Math.min((int)Predef$.MODULE$.Long2long(this.linkConfig().reconnectBackoffMaxMs()), Predef$.MODULE$.Integer2int(this.linkConfig().availabilityCheckMs())));
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(105).append("Link is unavailable, starting availability checks with periodic interval ").append(intervalMs).append(" ms until link becomes available").toString());
                    this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)new Some((Object)new ClusterLinkCheckAvailability(this.linkConfig(), this.linkMetrics(), this.clusterLinkManager(), intervalMs, this.scheduler(), this.linkData().linkName(), (Function0<ConfluentAdmin>)(Function0 & Serializable)() -> this.getAdmin())));
                    ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
                }
            }
            return;
        }
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.linkConfig();
    }

    public AbstractClusterLinkClientManager(ClusterLinkManager clusterLinkManager, ClusterLinkData linkData, ClusterLinkMetrics linkMetrics, ClusterLinkScheduler scheduler, Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory, ClusterLinkConfig linkConfig) {
        this.clusterLinkManager = clusterLinkManager;
        this.linkData = linkData;
        this.linkMetrics = linkMetrics;
        this.scheduler = scheduler;
        this.linkAdminFactory = linkAdminFactory;
        this.linkConfig = linkConfig;
        this.clusterLinkCheckAvailability = None$.MODULE$;
        this.lock = new Object();
    }
}

