/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\re\u0001\u0002\u000b\u0016\u0001iA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000bQ\u0003A\u0011A+\t\u000bq\u0003A\u0011A/\t\u000be\u0004A\u0011\u0001>\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/AqA!\n\u0001\t\u0013\u00119\u0003C\u0004\u0003>\u0001!IAa\u0010\t\u000f\t\r\u0003\u0001\"\u0003\u0003F!9!\u0011\n\u0001\u0005\n\t-\u0003b\u0002B;\u0001\u0011%!q\u000f\u0002\r\u0007>tg-[4IK2\u0004XM\u001d\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u0011S%D\u0001$\u0015\t!s#A\u0003vi&d7/\u0003\u0002'G\t9Aj\\4hS:<\u0017!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002*U5\tQ#\u0003\u0002,+\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\faaY8oM&<\u0007CA\u0015/\u0013\tySCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001E2p]\u001aLwMU3q_NLGo\u001c:z!\t\u0011T'D\u00014\u0015\t!T#\u0001\u0005nKR\fG-\u0019;b\u0013\t14G\u0001\tD_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006\t\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=\u0011\u0007qI4(\u0003\u0002;;\t1q\n\u001d;j_:\u0004\"\u0001P#\u000e\u0003uR!AP \u0002\rA|G.[2z\u0015\t1\u0002I\u0003\u0002\u0019\u0003*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1UHA\tBYR,'oQ8oM&<\u0007k\u001c7jGf\f!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feV\t\u0011\n\u0005\u0002K!:\u00111JT\u0007\u0002\u0019*\u0011Q*F\u0001\u0005Y&t7.\u0003\u0002P\u0019\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\t\t&KA\u0006MS:\\W*\u00198bO\u0016\u0014(BA(M\u0003M\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:!\u0003\u0019a\u0014N\\5u}Q1ak\u0016-Z5n\u0003\"!\u000b\u0001\t\u000b\u001d:\u0001\u0019\u0001\u0015\t\u000b1:\u0001\u0019A\u0017\t\u000bA:\u0001\u0019A\u0019\t\u000b]:\u0001\u0019\u0001\u001d\t\u000b\u001d;\u0001\u0019A%\u0002\u0015\u0005dGnQ8oM&<7\u000f\u0006\u0002_cB!q\f\u001a4o\u001b\u0005\u0001'BA1c\u0003\u001diW\u000f^1cY\u0016T!aY\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002fA\n\u0019Q*\u00199\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001\u00027b]\u001eT\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n11\u000b\u001e:j]\u001e\u0004\"aZ8\n\u0005AD'AB(cU\u0016\u001cG\u000fC\u0003-\u0011\u0001\u0007!\u000f\u0005\u0002to6\tAO\u0003\u0002-k*\u0011a\u000fQ\u0001\u0007G>lWn\u001c8\n\u0005a$(AD!cgR\u0014\u0018m\u0019;D_:4\u0017nZ\u0001\u0010I\u0016\u001c8M]5cK\u000e{gNZ5hgRI10a\t\u0002L\u0005U\u0013\u0011\u000e\t\u0006y\u0006%\u0011q\u0002\b\u0004{\u0006\u0015ab\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002e\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0007\u0005\u001dQ$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0011Q\u0002\u0002\u0005\u0019&\u001cHOC\u0002\u0002\bu\u0001B!!\u0005\u0002\u001e9!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018U\fq!\\3tg\u0006<W-\u0003\u0003\u0002\u001c\u0005U\u0011a\u0007#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002 \u0005\u0005\"!\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN,H\u000e\u001e\u0006\u0005\u00037\t)\u0002C\u0004\u0002&%\u0001\r!a\n\u0002+I,7o\\;sG\u0016$vnQ8oM&<g*Y7fgB)A0!\u0003\u0002*A!\u00111FA#\u001d\u0011\ti#!\u0011\u000f\t\u0005=\u0012q\b\b\u0005\u0003c\tiD\u0004\u0003\u00024\u0005mb\u0002BA\u001b\u0003sq1A`A\u001c\u0013\u0005!\u0015B\u0001\"D\u0013\tA\u0012)\u0003\u0002w\u0001&\u0019\u0011qC;\n\t\u0005\r\u0013QC\u0001\u001b\t\u0016\u001c8M]5cK\u000e{gNZ5hgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0003\u000f\nIEA\fEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001cx.\u001e:dK*!\u00111IA\u000b\u0011\u001d\ti%\u0003a\u0001\u0003\u001f\nq\"\u001b8dYV$WmU=o_:LXn\u001d\t\u00049\u0005E\u0013bAA*;\t9!i\\8mK\u0006t\u0007bBA,\u0013\u0001\u0007\u0011\u0011L\u0001\naJLgnY5qC2\u0004B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0003bkRD'bAA2k\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002h\u0005u#AD&bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\u0005\b\u0003WJ\u0001\u0019AA(\u0003QIgn\u00197vI\u0016$unY;nK:$\u0018\r^5p]\u000612M]3bi\u0016$v\u000e]5d\u0007>tg-[4F]R\u0014\u0018\u0010\u0006\u0006\u0002r\u0005U\u0015QVA_\u0003\u007f#b!a\u001d\u0002z\u0005-\u0005\u0003BA\t\u0003kJA!a\u001e\u0002\"\tiB)Z:de&\u0014WmQ8oM&<7OU3t_V\u00148-\u001a*fgVdG\u000fC\u0004\u0002|)\u0001\r!! \u0002\t9\fW.\u001a\t\u0005\u0003\u007f\n9I\u0004\u0003\u0002\u0002\u0006\r\u0005C\u0001@\u001e\u0013\r\t))H\u0001\u0007!J,G-\u001a4\n\u00075\fIIC\u0002\u0002\u0006vAq!!$\u000b\u0001\u0004\ty)A\u0003wC2,X\rE\u0002\u001d\u0003#K1!a%\u001e\u0005\r\te.\u001f\u0005\b\u0003/S\u0001\u0019AAM\u0003%awnZ\"p]\u001aLw\r\u0005\u0003\u0002\u001c\u0006%VBAAO\u0015\u0011\ty*!)\u0002\u00071|wM\u0003\u0003\u0002$\u0006\u0015\u0016!C5oi\u0016\u0014h.\u00197t\u0015\r\t9\u000bQ\u0001\bgR|'/Y4f\u0013\u0011\tY+!(\u0003\u00131{wmQ8oM&<\u0007bBAX\u0015\u0001\u0007\u0011\u0011W\u0001\u000bi>\u0004\u0018n\u0019)s_B\u001c\b\u0003BAZ\u0003sk!!!.\u000b\u0007\u0005]&.\u0001\u0003vi&d\u0017\u0002BA^\u0003k\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\tiE\u0003a\u0001\u0003\u001fBq!a\u001b\u000b\u0001\u0004\ty%\u0001\ngS2$XM\u001d+pa&\u001c7i\u001c8gS\u001e\u001cHCBAc\u0003#\fY\u000eE\u0003`\u0003\u000f\fY-C\u0002\u0002J\u0002\u0014aAQ;gM\u0016\u0014\bc\u0002\u000f\u0002N\u0006u\u0014qR\u0005\u0004\u0003\u001fl\"A\u0002+va2,'\u0007C\u0004\u0002T.\u0001\r!!6\u0002\u000f\r|gNZ5hgBA\u0011q[Am\u0003{\ny)D\u0001c\u0013\t)'\rC\u0004\u0002^.\u0001\r!a8\u0002\u0017\r|gNZ5h\u001d\u0006lWm\u001d\t\u00059e\n\t\u000f\u0005\u0004\u0002X\u0006\r\u0018QP\u0005\u0004\u0003K\u0014'aA*fi\u0006!b/\u00197jI\u0006$XmQ8oM&<\u0007k\u001c7jGf$\u0002\"a;\u0002r\u0006m(\u0011\u0001\t\u00049\u00055\u0018bAAx;\t!QK\\5u\u0011\u001d\t\u0019\u0010\u0004a\u0001\u0003k\f\u0001B]3t_V\u00148-\u001a\t\u0004g\u0006]\u0018bAA}i\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007bBA\u007f\u0019\u0001\u0007\u0011q`\u0001\u0011G>tg-[4F]R\u0014\u0018.Z:NCB\u0004\u0002\"a6\u0002Z\u0006u\u0014Q\u0010\u0005\b\u0003/b\u0001\u0019AA-\u0003]\u0019'/Z1uK\n\u0013xn[3s\u0007>tg-[4F]R\u0014\u0018\u0010\u0006\u0005\u0003\b\t5!\u0011\u0003B\n)\u0019\t\u0019H!\u0003\u0003\f!9\u00111P\u0007A\u0002\u0005u\u0004bBAG\u001b\u0001\u0007\u0011q\u0012\u0005\b\u0005\u001fi\u0001\u0019AA(\u0003=\u0001XM\u001d\"s_.,'oQ8oM&<\u0007bBA'\u001b\u0001\u0007\u0011q\n\u0005\b\u0003Wj\u0001\u0019AA(\u0003q\u0019'/Z1uK\u000ecWo\u001d;fe2Kgn[\"p]\u001aLw-\u00128uef$bA!\u0007\u0003 \t\rBCBA:\u00057\u0011i\u0002C\u0004\u0002|9\u0001\r!! \t\u000f\u00055e\u00021\u0001\u0002\u0010\"9!\u0011\u0005\bA\u0002\u0005\u0005\u0018aF3ya2L7-\u001b;msN+GoQ8oM&<7*Z=t\u0011\u0015ac\u00021\u0001s\u00039\u0019wN\u001c4jONKhn\u001c8z[N$\u0002B!\u000b\u00032\tM\"\u0011\b\t\u0006y\u0006%!1\u0006\t\u0005\u0003#\u0011i#\u0003\u0003\u00030\u0005\u0005\"A\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:Ts:|g._7\t\u000f\u0005mt\u00021\u0001\u0002~!9!QG\bA\u0002\t]\u0012\u0001C:z]>t\u00170\\:\u0011\u000bq\fI!! \t\u000f\tmr\u00021\u0001\u0002P\u0005Y\u0011n]*f]NLG/\u001b<f\u00039\u0011'o\\6feNKhn\u001c8z[N$BAa\u000e\u0003B!9\u00111\u0010\tA\u0002\u0005u\u0014a\u00052s_.,'\u000fR8dk6,g\u000e^1uS>tG\u0003BA?\u0005\u000fBq!a\u001f\u0012\u0001\u0004\ti(\u0001\nd_:4\u0017n\u001a*fgB|gn]3UsB,G\u0003\u0002B'\u0005C\u0002BAa\u0014\u0003\\9!!\u0011\u000bB,\u001b\t\u0011\u0019FC\u0002\u0003VU\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u00053\u0012\u0019&A\fEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001c\bo\u001c8tK&!!Q\fB0\u0005)\u0019uN\u001c4jORK\b/\u001a\u0006\u0005\u00053\u0012\u0019\u0006C\u0004\u0003dI\u0001\rA!\u001a\u0002\u0015\r|gNZ5h)f\u0004X\r\u0005\u0003\u001ds\t\u001d\u0004\u0003\u0002B5\u0005_r1a\u001dB6\u0013\r\u0011i\u0007^\u0001\n\u0007>tg-[4EK\u001aLAA!\u001d\u0003t\t!A+\u001f9f\u0015\r\u0011i\u0007^\u0001\u0017e\u0016\u001cx.\u001e:dK:\u000bW.\u001a+p\u0005J|7.\u001a:JIR!!\u0011\u0010B@!\ra\"1P\u0005\u0004\u0005{j\"aA%oi\"9!\u0011Q\nA\u0002\u0005u\u0014\u0001\u0004:fg>,(oY3OC6,\u0007")
public class ConfigHelper
implements Logging {
    private final MetadataCache metadataCache;
    private final KafkaConfig config;
    private final ConfigRepository configRepository;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public scala.collection.mutable.Map<String, Object> allConfigs(AbstractConfig config) {
        return (scala.collection.mutable.Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(config.originals()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$allConfigs$1(x$1)))).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(config.nonInternalValues()).asScala());
    }

    public List<DescribeConfigsResponseData.DescribeConfigsResult> describeConfigs(List<DescribeConfigsRequestData.DescribeConfigsResource> resourceToConfigNames, boolean includeSynonyms, KafkaPrincipal principal, boolean includeDocumentation) {
        return resourceToConfigNames.map((Function1 & Serializable)x0$1 -> {
            try {
                DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult;
                ConfigResource.Type type = ConfigResource.Type.forId((byte)x0$1.resourceType());
                if (ConfigResource.Type.TOPIC.equals(type)) {
                    String topic = x0$1.resourceName();
                    Topic.validate((String)topic);
                    if ($this.metadataCache.contains(topic)) {
                        void createResponseConfig$1_createConfigEntry;
                        Properties topicProps = $this.configRepository.topicConfig(topic);
                        LogConfig logConfig = LogConfig.fromProps($this.config.extractLogConfigMap(), (Properties)topicProps);
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs((AbstractConfig)logConfig);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                    }
                } else {
                    Properties properties;
                    if (ConfigResource.Type.BROKER.equals(type)) {
                        void createResponseConfig$1_createConfigEntry;
                        if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                            void createResponseConfig$1_createConfigEntry2;
                            Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, includeDocumentation, (String)name, value);
                            Map<String, String> createResponseConfig$1_configs = $this.config.dynamicConfig().currentDynamicDefaultConfigs();
                            Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs(createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry2, arg_0));
                            describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                            return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                        }
                        if (this.resourceNameToBrokerId(x0$1.resourceName()) != $this.config.brokerId()) throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" or empty string, but received ").append(x0$1.resourceName()).toString());
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs($this.config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                    }
                    if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        void createResponseConfig$1_createConfigEntry;
                        if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                            throw new InvalidRequestException("Broker id must not be empty");
                        }
                        if (this.resourceNameToBrokerId(x0$1.resourceName()) != $this.config.brokerId()) {
                            throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" but received ").append(x0$1.resourceName()).toString());
                        }
                        ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)x0$1.resourceType()), x0$1.resourceName());
                        this.validateConfigPolicy(configResource, (Map<String, String>)((Map)Map$.MODULE$.empty()), principal);
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
                        scala.collection.mutable.Map<String, String> createResponseConfig$1_configs = Log4jController$.MODULE$.loggers();
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                    }
                    if (!ConfigResource.Type.CLUSTER_LINK.equals(type)) throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    String linkName = x0$1.resourceName();
                    if (linkName == null || linkName.isEmpty()) {
                        throw new InvalidRequestException("Cluster link name must not be empty");
                    }
                    Uuid linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
                    this.clusterLinkManager().ensureClusterLinkExists(linkId);
                    ConfigRepository configRepository = $this.configRepository;
                    if (configRepository instanceof ZkConfigRepository) {
                        properties = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, CoreUtils$.MODULE$.toJavaUUID(linkId).toString()));
                    } else {
                        if (!(configRepository instanceof KRaftMetadataCache)) throw new IllegalStateException("Unsupported config repository type");
                        properties = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
                    }
                    Properties persistentProps = properties;
                    try {
                        void createResponseConfig$1_createConfigEntry;
                        scala.collection.mutable.Set explicitlySetConfigKeys = CollectionConverters$.MODULE$.SetHasAsScala(persistentProps.keySet()).asScala();
                        this.debug((Function0<String>)((Function0 & Serializable)() -> ConfigHelper.$anonfun$describeConfigs$9((Set)explicitlySetConfigKeys)));
                        ClusterLinkConfig config = this.clusterLinkManager().configEncoder().clusterLinkConfig(persistentProps);
                        Function2 & Serializable intersect = (arg_0, arg_1) -> ConfigHelper.$anonfun$describeConfigs$10(this, (Set)explicitlySetConfigKeys, config, arg_0, arg_1);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs(config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                    }
                    catch (ConfigException configException) {
                        throw new InvalidConfigurationException(new StringBuilder(202).append("Cluster link configs could not be decoded for link '").append(linkName).append("', '").append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append("' ").append("may be misconfigured on some brokers. Configure all brokers with the same encoder secret and reconfigure link by providing the full link config.").toString());
                    }
                }
                describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setConfigs(Collections.emptyList());
                return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
            }
            catch (Throwable e) {
                String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(x0$1).toString();
                if (e instanceof ApiException) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                } else {
                    this.error((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                ApiError err = ApiError.fromThrowable((Throwable)e);
                return new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType()).setErrorMessage(err.message()).setErrorCode(err.error().code()).setConfigs(Collections.emptyList());
            }
        });
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        Option configEntryType = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(LogConfig.configType((String)name)));
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        List list2 = (List)Option$.MODULE$.apply(ServerTopicConfigSynonyms.TOPIC_CONFIG_SYNONYMS.get(name)).map((Function1 & Serializable)s -> this.configSynonyms((String)s, DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)s, true), isSensitive)).getOrElse((Function0 & Serializable)() -> package$.MODULE$.List().empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG.id());
            list = (List)list2.$plus$colon((Object)describeConfigsSynonym);
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType((Option<ConfigDef.Type>)configEntryType);
        String configDocumentation = includeDocumentation ? logConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    public Buffer<Tuple2<String, Object>> filterTopicConfigs(Map<String, Object> configs, Option<Set<String>> configNames) {
        return ((IterableOnceOps)configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$filterTopicConfigs$1(configNames, x0$1)))).toBuffer();
    }

    public void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy;
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), CollectionConverters$.MODULE$.MapHasAsJava(configEntriesMap).asJava(), principal));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List<String> allNames = DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        String valueAsString = isSensitive ? null : (value instanceof String ? (String)value : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
        List allSynonyms = this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$5)));
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? this.brokerDocumentation(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(readOnly).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createClusterLinkConfigEntry(Set<String> explicitlySetConfigKeys, AbstractConfig config, String name, Object value) {
        ConfigDef.Type configEntryType = config.typeOf(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)Option$.MODULE$.apply((Object)configEntryType));
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(explicitlySetConfigKeys.contains((Object)name) ? DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG.id() : DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id()).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
    }

    private List<DescribeConfigsResponseData.DescribeConfigsSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config.dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$2$adapted(dynamicConfig.currentDynamicBrokerConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$3$adapted(dynamicConfig.currentDynamicDefaultConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach((Function1 & Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)allSynonyms.dropWhile((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private String brokerDocumentation(String name) {
        return this.config.documentationOf(name);
    }

    private DescribeConfigsResponse.ConfigType configResponseType(Option<ConfigDef.Type> configType) {
        if (configType.isEmpty()) {
            return DescribeConfigsResponse.ConfigType.UNKNOWN;
        }
        ConfigDef.Type type = (ConfigDef.Type)configType.get();
        if (ConfigDef.Type.BOOLEAN.equals(type)) {
            return DescribeConfigsResponse.ConfigType.BOOLEAN;
        }
        if (ConfigDef.Type.STRING.equals(type)) {
            return DescribeConfigsResponse.ConfigType.STRING;
        }
        if (ConfigDef.Type.INT.equals(type)) {
            return DescribeConfigsResponse.ConfigType.INT;
        }
        if (ConfigDef.Type.SHORT.equals(type)) {
            return DescribeConfigsResponse.ConfigType.SHORT;
        }
        if (ConfigDef.Type.LONG.equals(type)) {
            return DescribeConfigsResponse.ConfigType.LONG;
        }
        if (ConfigDef.Type.DOUBLE.equals(type)) {
            return DescribeConfigsResponse.ConfigType.DOUBLE;
        }
        if (ConfigDef.Type.LIST.equals(type)) {
            return DescribeConfigsResponse.ConfigType.LIST;
        }
        if (ConfigDef.Type.CLASS.equals(type)) {
            return DescribeConfigsResponse.ConfigType.CLASS;
        }
        if (ConfigDef.Type.PASSWORD.equals(type)) {
            return DescribeConfigsResponse.ConfigType.PASSWORD;
        }
        return DescribeConfigsResponse.ConfigType.UNKNOWN;
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(resourceName));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$allConfigs$1(Tuple2 x$1) {
        return x$1._2() != null;
    }

    private final DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig$1(Map configs, Function2 createConfigEntry, DescribeConfigsRequestData.DescribeConfigsResource x1$1) {
        Buffer configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x1$1.configurationKeys()).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala().toSet())).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                Object value = x0$1._2();
                return (DescribeConfigsResponseData.DescribeConfigsResourceResult)createConfigEntry.apply((Object)name, value);
            }
            throw new MatchError(null);
        });
        return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(configEntries).asJava());
    }

    public static final /* synthetic */ String $anonfun$describeConfigs$9(Set explicitlySetConfigKeys$1) {
        return new StringBuilder(28).append("Explicitly set config keys ").append(explicitlySetConfigKeys$1).append(".").toString();
    }

    public static final /* synthetic */ DescribeConfigsResponseData.DescribeConfigsResourceResult $anonfun$describeConfigs$10(ConfigHelper $this, Set explicitlySetConfigKeys$1, ClusterLinkConfig config$1, String name, Object value) {
        return $this.createClusterLinkConfigEntry((Set<String>)explicitlySetConfigKeys$1, config$1, name, value);
    }

    public static final /* synthetic */ boolean $anonfun$filterTopicConfigs$1(Option configNames$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean sslTruststorePasswordCheck;
            String configName = (String)x0$1._1();
            boolean recordInterceptorCheck = !configName.equals("confluent.append.record.interceptor.classes");
            boolean schemaRegistryUrlCheck = !configName.equals("confluent.schema.registry.url");
            boolean schemaValidatorSamplesPerMinCheck = !configName.equals("confluent.schema.validator.samples.per.min");
            boolean schemaValidatorInterceptorClassCheck = !configName.equals("confluent.schema.validator.interceptor.class");
            boolean multitenantSchemaValidationEnabledCheck = !configName.equals("confluent.schema.validator.multitenant.enable");
            boolean basicAuthCredentialsSourceCheck = !configName.equals("confluent.basic.auth.credentials.source");
            boolean userInfoCheck = !configName.equals("confluent.basic.auth.user.info");
            boolean bearerAuthCredentialsCheck = !configName.equals("confluent.bearer.auth.credentials.source");
            boolean bearerAuthTokenCheck = !configName.equals("confluent.bearer.auth.token");
            boolean bearerAuthIssuerEndpoint = !configName.equals("confluent.bearer.auth.issuer.endpoint.url");
            boolean bearerAuthClientId = !configName.equals("confluent.bearer.auth.client.id");
            boolean bearerAuthClientSecret = !configName.equals("confluent.bearer.auth.client.secret");
            boolean bearerAuthClientScope = !configName.equals("confluent.bearer.auth.scope");
            boolean bearerAuthClientScopeClaim = !configName.equals("confluent.bearer.auth.scope.claim.name");
            boolean bearerAuthClientSubClaim = !configName.equals("confluent.bearer.auth.sub.claim.name");
            boolean bearerAuthLogicalCluster = !configName.equals("confluent.bearer.auth.logical.cluster");
            boolean bearerAuthIdentityPool = !configName.equals("confluent.bearer.auth.identity.pool.id");
            boolean bearerAuthBufferExpirySecond = !configName.equals("confluent.bearer.auth.cache.expiry.buffer.seconds");
            boolean sslProtocolCheck = !configName.equals("confluent.ssl.protocol");
            boolean sslKeystoreTypeCheck = !configName.equals("confluent.ssl.keystore.type");
            boolean sslKeystoreLocationCheck = !configName.equals("confluent.ssl.keystore.location");
            boolean sslKeystorePasswordCheck = !configName.equals("confluent.ssl.keystore.password");
            boolean sslKeyPasswordCheck = !configName.equals("confluent.ssl.key.password");
            boolean sslTruststoreTypeCheck = !configName.equals("confluent.ssl.truststore.type");
            boolean sslTruststoreLocationCheck = !configName.equals("confluent.ssl.truststore.location");
            boolean bl = sslTruststorePasswordCheck = !configName.equals("confluent.ssl.truststore.password");
            return basicAuthCredentialsSourceCheck && userInfoCheck && bearerAuthCredentialsCheck && bearerAuthTokenCheck && bearerAuthIssuerEndpoint && bearerAuthClientId && bearerAuthClientSecret && bearerAuthClientScope && bearerAuthClientScopeClaim && bearerAuthClientSubClaim && bearerAuthLogicalCluster && bearerAuthIdentityPool && bearerAuthBufferExpirySecond && recordInterceptorCheck && schemaRegistryUrlCheck && schemaValidatorSamplesPerMinCheck && schemaValidatorInterceptorClassCheck && multitenantSchemaValidationEnabledCheck && sslProtocolCheck && sslKeystoreTypeCheck && sslKeystoreLocationCheck && sslKeystorePasswordCheck && sslKeyPasswordCheck && sslTruststoreTypeCheck && sslTruststoreLocationCheck && sslTruststorePasswordCheck && configNames$1.forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains((Object)configName)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponseData.DescribeConfigsSynonym x$5) {
        return perBrokerConfig$1 || x$5.source() == DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG.id();
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$2, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1 & Serializable)value -> {
            String configValue = isSensitive$2 ? null : value;
            return (Buffer)allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(configValue).setSource(source.id()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponseData.DescribeConfigsSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public ConfigHelper(MetadataCache metadataCache, KafkaConfig config, ConfigRepository configRepository, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.metadataCache = metadataCache;
        this.config = config;
        this.configRepository = configRepository;
        this.alterConfigPolicy = alterConfigPolicy;
        this.clusterLinkManager = clusterLinkManager;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }
}

