/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Properties;
import kafka.server.ConfigAdminManager;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ConfigAdminManager$ {
    public static final ConfigAdminManager$ MODULE$ = new ConfigAdminManager$();
    private static final Logger log = LoggerFactory.getLogger(ConfigAdminManager.class);

    public Logger log() {
        return log;
    }

    public AlterConfigsRequestData copyWithoutPreprocessed(AlterConfigsRequestData request, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        AlterConfigsRequestData copy = new AlterConfigsRequestData().setValidateOnly(request.validateOnly());
        request.resources().forEach(resource -> {
            if (!processed.containsKey(resource)) {
                copy.resources().mustAdd((ImplicitLinkedHashCollection.Element)resource.duplicate());
                return;
            }
        });
        return copy;
    }

    public AlterConfigsResponseData reassembleLegacyResponse(AlterConfigsRequestData original, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, AlterConfigsResponseData persistentResponses) {
        AlterConfigsResponseData response = new AlterConfigsResponseData();
        scala.collection.immutable.Map responsesByResource = CollectionConverters$.MODULE$.IteratorHasAsScala(persistentResponses.responses().iterator()).asScala().map((Function1 & Serializable)x0$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)x0$1.resourceName(), (Object)BoxesRunTime.boxToByte((byte)x0$1.resourceType()))), (Object)new ApiError(x0$1.errorCode(), x0$1.errorMessage()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        original.resources().forEach(r -> {
            ApiError apiError;
            Option option = Option$.MODULE$.apply(preprocessingResponses.get(r));
            if (None$.MODULE$.equals(option)) {
                Option option2 = responsesByResource.get((Object)new Tuple2((Object)r.resourceName(), (Object)BoxesRunTime.boxToByte((byte)r.resourceType())));
                if (None$.MODULE$.equals(option2)) {
                    MODULE$.log().error(new StringBuilder(79).append("The controller returned fewer results than we ").append("expected. No response found for ").append(r).append(".").toString());
                    apiError = new ApiError(Errors.UNKNOWN_SERVER_ERROR);
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                    apiError = (ApiError)((Some)option2).value();
                }
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                apiError = (ApiError)((Some)option).value();
            }
            ApiError err = apiError;
            response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName(r.resourceName()).setResourceType(r.resourceType()).setErrorCode(err.error().code()).setErrorMessage(err.message()));
        });
        return response;
    }

    public <T> boolean containsDuplicates(Iterable<T> iterable) {
        HashSet previous = new HashSet();
        return !iterable.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)previous.add(x$3)));
    }

    public Map<String, String> toLoggableProps(ConfigResource resource, Properties configProps) {
        return (Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(configProps).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                return new Tuple2((Object)key, (Object)KafkaConfig$.MODULE$.loggableValue(resource.type(), key, value));
            }
            throw new MatchError(null);
        });
    }

    public void prepareIncrementalConfigs(Seq<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        alterConfigOps.foreach((Function1 & Serializable)alterConfigOp -> {
            String configPropName = alterConfigOp.configEntry().name();
            AlterConfigOp.OpType opType = alterConfigOp.opType();
            if (AlterConfigOp.OpType.SET.equals(opType)) {
                return configProps.setProperty(alterConfigOp.configEntry().name(), alterConfigOp.configEntry().value());
            }
            if (AlterConfigOp.OpType.DELETE.equals(opType)) {
                return configProps.remove(alterConfigOp.configEntry().name());
            }
            if (AlterConfigOp.OpType.APPEND.equals(opType)) {
                if (!ConfigAdminManager$.listType$1(alterConfigOp.configEntry().name(), configKeys)) {
                    throw new InvalidConfigurationException(new StringBuilder(51).append("Config value append is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
                }
                List oldValueList = (List)Option$.MODULE$.apply((Object)configProps.getProperty(alterConfigOp.configEntry().name())).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)ConfigDef.convertToString((Object)((ConfigDef.ConfigKey)configKeys$1.apply((Object)configPropName$1)).defaultValue, (ConfigDef.Type)ConfigDef.Type.LIST))).filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)))).map((Function1 & Serializable)x$4 -> Predef$.MODULE$.wrapRefArray((Object[])x$4.split(",")).toList()).getOrElse((Function0 & Serializable)() -> package$.MODULE$.List().empty());
                List appendingValueList = Predef$.MODULE$.wrapRefArray((Object[])alterConfigOp.configEntry().value().split(",")).toList().filter((Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManager$.$anonfun$prepareIncrementalConfigs$6(oldValueList, value)));
                List oldValueListMinusBlanks = oldValueList.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManager$.$anonfun$prepareIncrementalConfigs$7(s)));
                List newValueList = appendingValueList.$colon$colon$colon(oldValueListMinusBlanks);
                return configProps.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
            }
            if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
                if (!ConfigAdminManager$.listType$1(alterConfigOp.configEntry().name(), configKeys)) {
                    throw new InvalidConfigurationException(new StringBuilder(53).append("Config value subtract is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
                }
                List newValueList = (List)Predef$.MODULE$.wrapRefArray((Object[])((String)Option$.MODULE$.apply((Object)configProps.getProperty(alterConfigOp.configEntry().name())).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)ConfigDef.convertToString((Object)((ConfigDef.ConfigKey)configKeys$1.apply((Object)configPropName$1)).defaultValue, (ConfigDef.Type)ConfigDef.Type.LIST))).getOrElse((Function0 & Serializable)() -> "")).split(",")).toList().diff((Seq)Predef$.MODULE$.wrapRefArray((Object[])alterConfigOp.configEntry().value().split(",")).toList());
                return configProps.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
            }
            throw new MatchError((Object)opType);
        });
    }

    private static final boolean listType$1(String configName, Map configKeys) {
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys.apply((Object)configName);
        if (configKey == null) {
            throw new InvalidConfigurationException(new StringBuilder(21).append("Unknown config name: ").append(configName).toString());
        }
        ConfigDef.Type type = configKey.type;
        ConfigDef.Type type2 = ConfigDef.Type.LIST;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$prepareIncrementalConfigs$6(List oldValueList$1, String value) {
        return !oldValueList$1.contains((Object)value);
    }

    public static final /* synthetic */ boolean $anonfun$prepareIncrementalConfigs$7(String s) {
        return !s.trim().isEmpty();
    }

    private ConfigAdminManager$() {
    }
}

