/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.zk.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.utils.CoreUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.metadata.BrokerReplicaExclusionRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerReplicaExclusion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\u0007\u000f\u0001]AQa\b\u0001\u0005\u0002\u0001BQa\t\u0001\u0005\u0002\u0011BQ\u0001\u000f\u0001\u0005\u0002\u0011BQA\u000f\u0001\u0005\u0002\u0011BQ\u0001\u0010\u0001\u0005\u0002\u0011BQA\u0010\u0001\u0005\u0002\u0011BQ\u0001\u0011\u0001\u0005\u0002\u0011BQA\u0011\u0001\u0005\n\rCQA\u0011\u0001\u0005\n9DQa\u001e\u0001\u0005\naDq!!\u0002\u0001\t\u0013\t9\u0001C\u0004\u0002 \u0001!I!!\t\u0003?i['+\u001a9mS\u000e\fW\t_2mkNLwN\\'jOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0010!\u0005IQ.[4sCRLwN\u001c\u0006\u0003#I\t!A_6\u000b\u0005M!\u0012!B6bM.\f'\"A\u000b\u0002\tUt\u0017\u000e^\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a;5\t!D\u0003\u0002\u00107)\u0011\u0011\u0003\b\u0006\u0002'%\u0011aD\u0007\u0002\u00175.l\u0015n\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\t\t\u0003E\u0001i\u0011AD\u0001\"i\u0016\u001cH/T5he\u0006$X-R7qif\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gn\u001d\u000b\u0002KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t!QK\\5uQ\t\u0011A\u0006\u0005\u0002.m5\taF\u0003\u00020a\u0005\u0019\u0011\r]5\u000b\u0005E\u0012\u0014a\u00026va&$XM\u001d\u0006\u0003gQ\nQA[;oSRT\u0011!N\u0001\u0004_J<\u0017BA\u001c/\u0005\u0011!Vm\u001d;\u00029Q,7\u000f^'jOJ\fG/\u001a*fa2L7-Y#yG2,8/[8og\"\u00121\u0001L\u0001*i\u0016\u001cH/T5he\u0006$XMU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8t\r>\u0014Hi\\<o\u0005J|7.\u001a:)\u0005\u0011a\u0013\u0001\r;fgRl\u0015n\u001a:bi\u0016\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gn\u001d$pe:{g.\u0012=jgR,g\u000e\u001e\"s_.,'\u000f\u000b\u0002\u0006Y\u0005YB/Z:u+B$\u0017\r^3SKBd\u0017nY1Fq\u000edWo]5p]ND#A\u0002\u0017\u0002QQ,7\u000f^+qI\u0006$XMU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8t/&dGn\u0014<fe^\u0014\u0018\u000e^3)\u0005\u001da\u0013\u0001G1tg\u0016\u0014H/\u0012=dYV\u001c\u0018n\u001c8t\u0003J,W)];bYR\u0019Q\u0005R,\t\u000b\u0015C\u0001\u0019\u0001$\u0002%\u0015D\b/Z2uK\u0012,\u0005p\u00197vg&|gn\u001d\t\u0004\u000f:\u000bfB\u0001%M!\tIu%D\u0001K\u0015\tYe#\u0001\u0004=e>|GOP\u0005\u0003\u001b\u001e\na\u0001\u0015:fI\u00164\u0017BA(Q\u0005\r\u0019V\r\u001e\u0006\u0003\u001b\u001e\u0002\"AU+\u000e\u0003MS!\u0001\u0016\u000f\u0002\r\r|W.\\8o\u0013\t16K\u0001\fCe>\\WM\u001d*fa2L7-Y#yG2,8/[8o\u0011\u0015A\u0006\u00021\u0001Z\u0003A\t7\r^;bY\u0016C8\r\\;tS>t7\u000fE\u0002[?\u0006l\u0011a\u0017\u0006\u00039v\u000bA!\u001e;jY*\ta,\u0001\u0003kCZ\f\u0017B\u00011\\\u0005\u0011a\u0015n\u001d;\u0011\u0005\tdgBA2k\u001b\u0005!'BA3g\u0003!iW\r^1eCR\f'B\u0001+h\u0015\t\u0019\u0002N\u0003\u0002ji\u00051\u0011\r]1dQ\u0016L!a\u001b3\u00029\t\u0013xn[3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u0014VmY8sI&\u0011a+\u001c\u0006\u0003W\u0012$2!J8w\u0011\u0015)\u0015\u00021\u0001q!\rQ\u0016O]\u0005\u0003\u001fn\u0003\"a];\u000e\u0003QT!!Z4\n\u0005Y#\b\"\u0002-\n\u0001\u00041\u0015\u0001E2sK\u0006$XM\u0011:pW\u0016\u0014\u0018J\u001c4p)\tIX\u0010\u0005\u0002{w6\t1$\u0003\u0002}7\tQ!I]8lKJLeNZ8\t\u000byT\u0001\u0019A@\u0002\u0005%$\u0007c\u0001\u0014\u0002\u0002%\u0019\u00111A\u0014\u0003\u0007%sG/\u0001\nce>\\WM\u001d*fO&\u001cHO]1uS>tG\u0003BA\u0005\u0003\u001f\u00012a]A\u0006\u0013\r\ti\u0001\u001e\u0002\u0013\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|g\u000eC\u0004\u0002\u0012-\u0001\r!a\u0005\u0002\u0011\t\u0014xn[3s\u0013\u0012\u0004B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033i\u0016\u0001\u00027b]\u001eLA!!\b\u0002\u0018\t9\u0011J\u001c;fO\u0016\u0014\u0018a\u00052s_.,'OU3hSN$(/\u0019;j_:\u001cH\u0003BA\u0012\u0003S\u0001rAWA\u0013\u0003'\tI!C\u0002\u0002(m\u00131!T1q\u0011\u0019\tY\u0003\u0004a\u0001\u007f\u0006Qa.^7Ce>\\WM]:")
public class ZkReplicaExclusionMigrationTest
extends ZkMigrationTestHarness {
    @Test
    public void testMigrateEmptyReplicaExclusions() {
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateReplicaExclusions(batch -> batches.add(batch), this.brokerRegistrations(3));
        Assertions.assertEquals((int)0, (int)batches.size());
    }

    @Test
    public void testMigrateReplicaExclusions() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        this.zkClient().registerBroker(this.createBrokerInfo(2));
        scala.collection.immutable.Set replicaExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123"), new kafka.common.BrokerReplicaExclusion(2, "rcca-234")}));
        this.zkClient().setOrCreateReplicaExclusions(replicaExclusions, 0);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateReplicaExclusions(batch -> batches.add(batch), this.brokerRegistrations(3));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq replicaExclusionRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$1 -> x$1.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaExclusionMigrationTest.$anonfun$testMigrateReplicaExclusions$3(message)))).map((Function1 & Serializable)x$2 -> (BrokerReplicaExclusionRecord)x$2)).toSeq();
        Assertions.assertEquals((int)1, (int)replicaExclusionRecords.size());
        this.assertExclusionsAreEqual((scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)replicaExclusions, ((BrokerReplicaExclusionRecord)replicaExclusionRecords.head()).brokerExclusions());
    }

    @Test
    public void testMigrateReplicaExclusionsForDownBroker() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        scala.collection.immutable.Set replicaExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123"), new kafka.common.BrokerReplicaExclusion(2, "rcca-234")}));
        this.zkClient().setOrCreateReplicaExclusions(replicaExclusions, 0);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateReplicaExclusions(batch -> batches.add(batch), this.brokerRegistrations(3));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq replicaExclusionRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$3 -> x$3.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaExclusionMigrationTest.$anonfun$testMigrateReplicaExclusionsForDownBroker$3(message)))).map((Function1 & Serializable)x$4 -> (BrokerReplicaExclusionRecord)x$4)).toSeq();
        Assertions.assertEquals((int)1, (int)replicaExclusionRecords.size());
        this.assertExclusionsAreEqual((scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)replicaExclusions, ((BrokerReplicaExclusionRecord)replicaExclusionRecords.head()).brokerExclusions());
    }

    @Test
    public void testMigrateReplicaExclusionsForNonExistentBroker() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        this.zkClient().registerBroker(this.createBrokerInfo(0));
        this.zkClient().registerBroker(this.createBrokerInfo(1));
        scala.collection.immutable.Set replicaExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123"), new kafka.common.BrokerReplicaExclusion(2, "rcca-234")}));
        this.zkClient().setOrCreateReplicaExclusions(replicaExclusions, 0);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateReplicaExclusions(batch -> batches.add(batch), this.brokerRegistrations(2));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Seq replicaExclusionRecords = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$5 -> x$5.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaExclusionMigrationTest.$anonfun$testMigrateReplicaExclusionsForNonExistentBroker$3(message)))).map((Function1 & Serializable)x$6 -> (BrokerReplicaExclusionRecord)x$6)).toSeq();
        Assertions.assertEquals((int)1, (int)replicaExclusionRecords.size());
        this.assertExclusionsAreEqual((scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123")}))), ((BrokerReplicaExclusionRecord)replicaExclusionRecords.head()).brokerExclusions());
    }

    @Test
    public void testUpdateReplicaExclusions() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Set replicaExclusions = CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(0, "rcca-123"), new BrokerReplicaExclusion(2, "rcca-234")}))).asJava();
        this.migrationState_$eq(this.migrationClient().replicaExclusionClient().writeReplicaExclusions(replicaExclusions, this.migrationState(), true));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        scala.collection.immutable.Set replicaExclusionsFromZk = (scala.collection.immutable.Set)this.zkClient().getReplicaExclusions().get();
        Assertions.assertEquals((int)2, (int)replicaExclusionsFromZk.size());
        this.assertExclusionsAreEqual(replicaExclusions, (scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)replicaExclusionsFromZk);
    }

    @Test
    public void testUpdateReplicaExclusionsWillOverwrite() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        scala.collection.immutable.Set replicaExclusion = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new kafka.common.BrokerReplicaExclusion[]{new kafka.common.BrokerReplicaExclusion(0, "rcca-123")}));
        this.zkClient().setOrCreateReplicaExclusions(replicaExclusion, 0);
        java.util.Set updatedReplicaExclusion = CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(2, "rcca-234")}))).asJava();
        this.migrationState_$eq(this.migrationClient().replicaExclusionClient().writeReplicaExclusions(updatedReplicaExclusion, this.migrationState(), false));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        scala.collection.immutable.Set replicaExclusionsFromZk = (scala.collection.immutable.Set)this.zkClient().getReplicaExclusions().get();
        Assertions.assertEquals((int)1, (int)replicaExclusionsFromZk.size());
        this.assertExclusionsAreEqual(updatedReplicaExclusion, (scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion>)replicaExclusionsFromZk);
        HashSet emptyReplicaExclusions = new HashSet();
        this.migrationState_$eq(this.migrationClient().replicaExclusionClient().writeReplicaExclusions(emptyReplicaExclusions, this.migrationState(), false));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        replicaExclusionsFromZk = (scala.collection.immutable.Set)this.zkClient().getReplicaExclusions().get();
        Assertions.assertEquals((int)0, (int)replicaExclusionsFromZk.size());
    }

    private void assertExclusionsAreEqual(scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion> expectedExclusions, java.util.List<BrokerReplicaExclusionRecord.BrokerReplicaExclusion> actualExclusions) {
        scala.collection.immutable.Set actual = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(actualExclusions).asScala().map((Function1 & Serializable)exclusion -> new kafka.common.BrokerReplicaExclusion(exclusion.brokerId(), exclusion.reason()))).toSet();
        Assertions.assertEquals(expectedExclusions, (Object)actual);
    }

    private void assertExclusionsAreEqual(java.util.Set<BrokerReplicaExclusion> expectedExclusions, scala.collection.immutable.Set<kafka.common.BrokerReplicaExclusion> actualExclusions) {
        Assertions.assertEquals((Object)((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(expectedExclusions).asScala().map((Function1 & Serializable)exclusion -> new kafka.common.BrokerReplicaExclusion(exclusion.getBrokerId(), exclusion.getReason()))), actualExclusions);
    }

    private BrokerInfo createBrokerInfo(int id) {
        return BrokerInfo$.MODULE$.apply(Broker$.MODULE$.apply(id, (Seq)new .colon.colon((Object)new EndPoint(new StringBuilder(9).append("test.host").append(Integer.toString(id)).toString(), 9000 + id, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$), (Option)None$.MODULE$, Features.emptySupportedFeatures()), MetadataVersion.latest(), 9010 + id);
    }

    private BrokerRegistration brokerRegistration(Integer brokerId) {
        return new BrokerRegistration(Predef$.MODULE$.Integer2int(brokerId), 1L, Uuid.randomUuid(), new HashMap(), new HashMap(), Optional.empty(), false, true, true, new HashSet());
    }

    private java.util.Map<Integer, BrokerRegistration> brokerRegistrations(int numBrokers) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBrokers).map((Function1 & Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.unboxToInt((Object)b)), (Object)this.brokerRegistration(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)b))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateReplicaExclusions$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateReplicaExclusionsForDownBroker$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD);
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateReplicaExclusionsForNonExistentBroker$3(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.BROKER_REPLICA_EXCLUSION_RECORD);
    }
}

