/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.io.Serializable;
import java.util.Collection;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ClusterTestDefaults(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001\u0002\u0007\u000e\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006i\u0001!\t!\u000b\u0005\u0006m\u0001!\t!\u000b\u0005\u0006q\u0001!I!\u000f\u0005\u0006q\u0001!IA\u0018\u0005\u0006Y\u0002!I!\u001c\u0005\u0006m\u0002!Ia\u001e\u0005\u0006u\u0002!Ia\u001f\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0005\u0019\"v\u000e]5d%\u0016\fX/Z:ugZ+'o]5p]\u000e{W\u000e]1uS\nLG.\u001b;z)\u0016\u001cHo\u001d\u0006\u0003\u001d=\taa]3sm\u0016\u0014(B\u0001\t\u0012\u0003\u0015Y\u0017MZ6b\u0015\u0005\u0011\u0012\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\fqb\u00197vgR,'/\u00138ti\u0006t7-\u001a\t\u0003;\u0005j\u0011A\b\u0006\u0003?\u0001\nA\u0001^3ti*\t\u0001#\u0003\u0002#=\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003K\u001d\u0002\"A\n\u0001\u000e\u00035AQa\u0007\u0002A\u0002q\t!\u0004^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018nY!qSZ+'o]5p]N$\u0012A\u000b\t\u0003--J!\u0001L\f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u00079\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00024a\tY1\t\\;ti\u0016\u0014H+Z:u\u0003q!Xm\u001d;BI\u0012\u0004\u0016M\u001d;ji&|gn]!qSZ+'o]5p]ND#\u0001\u0002\u0018\u00023Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e\f\u0005/\u001b,feNLwN\u001c\u0015\u0003\u000b9\nAb\u0019:fCR,Gk\u001c9jGN$\"AO*\u0011\tm\u0012U\t\u0013\b\u0003y\u0001\u0003\"!P\f\u000e\u0003yR!aP\n\u0002\rq\u0012xn\u001c;?\u0013\t\tu#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u00131!T1q\u0015\t\tu\u0003\u0005\u0002<\r&\u0011q\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005%\u000bV\"\u0001&\u000b\u0005-c\u0015AB2p[6|gN\u0003\u0002\u0011\u001b*\u0011ajT\u0001\u0007CB\f7\r[3\u000b\u0003A\u000b1a\u001c:h\u0013\t\u0011&J\u0001\u0003Vk&$\u0007\"\u0002+\u0007\u0001\u0004)\u0016A\u0003;pa&\u001cg*Y7fgB\u0019akW#\u000f\u0005]KfBA\u001fY\u0013\u0005A\u0012B\u0001.\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0007M+\u0017O\u0003\u0002[/Q\u0019qLZ4\u0011\tm\u0012U\t\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G*\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003K\n\u0014a!\u0012:s_J\u001c\b\"\u0002+\b\u0001\u0004)\u0006\"\u00025\b\u0001\u0004I\u0017A\u0004:fcV,7\u000f\u001e,feNLwN\u001c\t\u0003-)L!a[\f\u0003\u000bMCwN\u001d;\u0002/M,g\u000eZ\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$Hc\u00018ukB\u0011qN]\u0007\u0002a*\u0011\u0011OS\u0001\te\u0016\fX/Z:ug&\u00111\u000f\u001d\u0002\u0015\u0007J,\u0017\r^3U_BL7m\u001d*fgB|gn]3\t\u000bQC\u0001\u0019A+\t\u000b!D\u0001\u0019A5\u0002\u0019\u0011,G.\u001a;f)>\u0004\u0018nY:\u0015\u0007}C\u0018\u0010C\u0003U\u0013\u0001\u0007Q\u000bC\u0003i\u0013\u0001\u0007\u0011.A\neK2,G/\u001a+pa&\u001c7/V:j]\u001eLE\r\u0006\u0003}{\u0006\u0005\u0001\u0003B\u001eC\u0011\u0002DQA \u0006A\u0002}\f\u0001\u0002^8qS\u000eLEm\u001d\t\u0004-nC\u0005\"\u00025\u000b\u0001\u0004I\u0017!D1eIB\u000b'\u000f^5uS>t7\u000fF\u0003`\u0003\u000f\t\u0019\u0002C\u0004\u0002\n-\u0001\r!a\u0003\u00021Q|\u0007/[2U_B\u000b'\u000f^5uS>t7i\\;oi6\u000b\u0007\u000fE\u0003<\u0005\u0016\u000bi\u0001E\u0002\u0017\u0003\u001fI1!!\u0005\u0018\u0005\rIe\u000e\u001e\u0005\u0006Q.\u0001\r!\u001b\u0015\b\u0001\u0005]\u00111FA\u0017!\u0011\tI\"a\n\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t1!\u00199j\u0015\u0011\t\t#a\t\u0002\u000f),\b/\u001b;fe*\u0019\u0011QE(\u0002\u000b),h.\u001b;\n\t\u0005%\u00121\u0004\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017EAA\u0018\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8)\u000f\u0001\t\u0019$a\u000b\u0002@A!\u0011QGA\u001e\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0011!C3yi\u0016t7/[8o\u0013\u0011\ti$a\u000e\u0003\u0015\u0015CH/\u001a8e/&$\b\u000e\f\u0002\u0002B\r\u0012\u00111\t\t\u0005\u0003\u000b\nI%\u0004\u0002\u0002H)\u0019\u0011Q\u0005\u0010\n\t\u0005-\u0013q\t\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8tQ=\u0001\u0011qJA+\u0003/\n\t'a\u0019\u0002f\u0005\r\u0004cA\u0018\u0002R%\u0019\u00111\u000b\u0019\u0003'\rcWo\u001d;feR+7\u000f\u001e#fM\u0006,H\u000e^:\u0002\u0017\rdWo\u001d;feRK\b/\u001a\u0013\u0003\u00033JA!a\u0017\u0002^\u0005\u0011\u0012\t\u0014'`\u001d>sulQ(S\u000bNKE)\u0012(U\u0015\r\ty\u0006M\u0001\u0005)f\u0004X-A\u0004ce>\\WM]:\u001e\u0003\u0005\t1bY8oiJ|G\u000e\\3sg\u0002")
public class TopicRequestsVersionCompatibilityTests {
    private final ClusterInstance clusterInstance;

    @ClusterTest
    public void testCreateTopicApiVersions() {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)7, (int)7);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            ListBuffer topicNames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1 & Serializable)i -> TopicRequestsVersionCompatibilityTests.$anonfun$testCreateTopicApiVersions$2(topicNames, version, BoxesRunTime.unboxToInt((Object)i)));
            Assertions.assertTrue((boolean)this.createTopics((Seq<String>)((Seq)package$.MODULE$.Seq().empty()), (short)version).isEmpty());
            this.createTopics((Seq<String>)topicNames.toSeq(), (short)version).foreach((Function1 & Serializable)keyVal -> {
                TopicRequestsVersionCompatibilityTests.$anonfun$testCreateTopicApiVersions$3(keyVal);
                return BoxedUnit.UNIT;
            });
        });
    }

    @ClusterTest
    public void testAddPartitionsApiVersions() {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)3, (int)3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            ListBuffer topicNames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1 & Serializable)i -> TopicRequestsVersionCompatibilityTests.$anonfun$testAddPartitionsApiVersions$2(topicNames, version, BoxesRunTime.unboxToInt((Object)i)));
            this.createTopics((Seq<String>)topicNames.toSeq());
            Assertions.assertTrue((boolean)this.addPartitions((Map<String, Object>)Predef$.MODULE$.Map().empty(), (short)version).isEmpty());
            this.addPartitions((Map<String, Object>)((IterableOnceOps)topicNames.map((Function1 & Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)BoxesRunTime.boxToInteger((int)2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (short)version).foreach((Function1 & Serializable)keyVal -> {
                TopicRequestsVersionCompatibilityTests.$anonfun$testAddPartitionsApiVersions$4(keyVal);
                return BoxedUnit.UNIT;
            });
        });
    }

    @ClusterTest
    public void testDeleteTopicApiVersion() {
        Assertions.assertEquals((int)0, (int)0);
        Assertions.assertEquals((int)6, (int)6);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            ListBuffer topicNames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach((Function1 & Serializable)i -> TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$2(topicNames, version, BoxesRunTime.unboxToInt((Object)i)));
            Map<String, Uuid> topicNameToUuidMap = this.createTopics((Seq<String>)topicNames.toSeq());
            Assertions.assertTrue((boolean)this.deleteTopics((Seq<String>)((Seq)package$.MODULE$.Seq().empty()), (short)version).isEmpty());
            if (version <= 5) {
                this.deleteTopics((Seq<String>)topicNames.toSeq(), (short)version).foreach((Function1 & Serializable)keyVal -> {
                    TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$3(keyVal);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            ListBuffer requestWithNames = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ListBuffer requestWithIds = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach((Function1 & Serializable)i -> TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$4(requestWithNames, version, requestWithIds, topicNameToUuidMap, BoxesRunTime.unboxToInt((Object)i)));
            this.deleteTopics((Seq<String>)requestWithNames.toSeq(), (short)version).foreach((Function1 & Serializable)keyVal -> {
                TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$5(keyVal);
                return BoxedUnit.UNIT;
            });
            this.deleteTopicsUsingId((Seq<Uuid>)requestWithIds.toSeq(), (short)version).foreach((Function1 & Serializable)keyVal -> {
                TopicRequestsVersionCompatibilityTests.$anonfun$testDeleteTopicApiVersion$6(keyVal);
                return BoxedUnit.UNIT;
            });
        });
    }

    private Map<String, Uuid> createTopics(Seq<String> topicNames) {
        CreateTopicsResponse response = this.sendCreateTopicsRequest(topicNames, (short)7);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().topics()).asScala().map((Function1 & Serializable)result -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)result.errorCode()), (String)new StringBuilder(23).append("Failed to create topic ").append(result.name()).toString());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.name()), (Object)result.topicId());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, Errors> createTopics(Seq<String> topicNames, short requestVersion) {
        CreateTopicsResponse response = this.sendCreateTopicsRequest(topicNames, requestVersion);
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().topics()).asScala().map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.name()), (Object)Errors.forCode((short)result.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private CreateTopicsResponse sendCreateTopicsRequest(Seq<String> topicNames, short requestVersion) {
        CreateTopicsRequestData.CreatableTopicCollection topicCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicNames.foreach((Function1 & Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)topicCollection.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topic).setReplicationFactor((short)1).setNumPartitions(1))));
        CreateTopicsRequest request = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicCollection)).build(requestVersion);
        return (CreateTopicsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.clusterInstance.anyBrokerSocketServer(), this.clusterInstance.clientListener(), ClassTag$.MODULE$.apply(CreateTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Map<String, Errors> deleteTopics(Seq<String> topicNames, short requestVersion) {
        DeleteTopicsRequest request = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(CollectionConverters$.MODULE$.SeqHasAsJava(topicNames).asJava()).setTimeoutMs(10000)).build(requestVersion);
        DeleteTopicsResponse response = (DeleteTopicsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.clusterInstance.anyBrokerSocketServer(), this.clusterInstance.clientListener(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().responses()).asScala().map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic.name()), (Object)Errors.forCode((short)topic.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<Uuid, Errors> deleteTopicsUsingId(Seq<Uuid> topicIds, short requestVersion) {
        ListBuffer topicCollection = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        topicIds.foreach((Function1 & Serializable)topic -> (ListBuffer)topicCollection.$plus$eq((Object)new DeleteTopicsRequestData.DeleteTopicState().setTopicId(topic)));
        DeleteTopicsRequest request = new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)topicCollection).asJava()).setTimeoutMs(10000)).build(requestVersion);
        DeleteTopicsResponse response = (DeleteTopicsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.clusterInstance.anyBrokerSocketServer(), this.clusterInstance.clientListener(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().responses()).asScala().map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic.topicId()), (Object)Errors.forCode((short)topic.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, Errors> addPartitions(Map<String, Object> topicToPartitionCountMap, short requestVersion) {
        CreatePartitionsRequestData.CreatePartitionsTopicCollection topicCollection = new CreatePartitionsRequestData.CreatePartitionsTopicCollection();
        topicToPartitionCountMap.foreach((Function1 & Serializable)keyVal -> BoxesRunTime.boxToBoolean((boolean)topicCollection.add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName((String)keyVal._1()).setCount(keyVal._2$mcI$sp()).setAssignments(null))));
        CreatePartitionsRequest request = new CreatePartitionsRequest.Builder(new CreatePartitionsRequestData().setTopics(topicCollection).setTimeoutMs(10000)).build(requestVersion);
        CreatePartitionsResponse response = (CreatePartitionsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.clusterInstance.anyBrokerSocketServer(), this.clusterInstance.clientListener(), ClassTag$.MODULE$.apply(CreatePartitionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response.data().results()).asScala().map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.name()), (Object)Errors.forCode((short)result.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ ListBuffer $anonfun$testCreateTopicApiVersions$2(ListBuffer topicNames$1, int version$1, int i) {
        return (ListBuffer)topicNames$1.$plus$eq((Object)new StringBuilder(7).append("topic-").append(version$1).append("-").append(i).toString());
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicApiVersions$3(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(30).append("CreateTopics failed for topic ").append(keyVal._1()).toString());
    }

    public static final /* synthetic */ ListBuffer $anonfun$testAddPartitionsApiVersions$2(ListBuffer topicNames$2, int version$2, int i) {
        return (ListBuffer)topicNames$2.$plus$eq((Object)new StringBuilder(7).append("topic-").append(version$2).append("-").append(i).toString());
    }

    public static final /* synthetic */ void $anonfun$testAddPartitionsApiVersions$4(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(34).append("CreatePartitions failed for topic ").append(keyVal._1()).toString());
    }

    public static final /* synthetic */ ListBuffer $anonfun$testDeleteTopicApiVersion$2(ListBuffer topicNames$3, int version$3, int i) {
        return (ListBuffer)topicNames$3.$plus$eq((Object)new StringBuilder(7).append("topic-").append(version$3).append("-").append(i).toString());
    }

    public static final /* synthetic */ void $anonfun$testDeleteTopicApiVersion$3(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(30).append("DeleteTopics failed for topic ").append(keyVal._1()).toString());
    }

    public static final /* synthetic */ ListBuffer $anonfun$testDeleteTopicApiVersion$4(ListBuffer requestWithNames$1, int version$3, ListBuffer requestWithIds$1, Map topicNameToUuidMap$1, int i) {
        if (i < 2) {
            return (ListBuffer)requestWithNames$1.$plus$eq((Object)new StringBuilder(7).append("topic-").append(version$3).append("-").append(i).toString());
        }
        return (ListBuffer)requestWithIds$1.$plus$eq(topicNameToUuidMap$1.apply((Object)new StringBuilder(7).append("topic-").append(version$3).append("-").append(i).toString()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteTopicApiVersion$5(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(30).append("DeleteTopics failed for topic ").append(keyVal._1()).toString());
    }

    public static final /* synthetic */ void $anonfun$testDeleteTopicApiVersion$6(Tuple2 keyVal) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)keyVal._2(), (String)new StringBuilder(30).append("DeleteTopics failed for topic ").append(keyVal._1()).toString());
    }

    public TopicRequestsVersionCompatibilityTests(ClusterInstance clusterInstance) {
        this.clusterInstance = clusterInstance;
    }
}

