/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionLinkState;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.ConfigType$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.utils.CoreUtils$;
import kafka.utils.NoOpPasswordEncoder;
import kafka.utils.PasswordEncoder;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ClusterLinkData;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.KRaftMigrationOperation;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\t\u0013\u0001eAQA\b\u0001\u0005\u0002}Aq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004G\u0001\u0001\u0006Ia\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u00199\u0006\u0001)A\u0005\u0013\")\u0001\f\u0001C\u00013\")Q\u000e\u0001C\u00013\u001a!q\u000e\u0001\u0001q\u0011\u0015q\u0002\u0002\"\u0001u\u0011\u001d9\bB1A\u0005\u0002aDaa \u0005!\u0002\u0013I\b\"CA\u0001\u0011\u0001\u0007I\u0011AA\u0002\u0011%\tY\u0001\u0003a\u0001\n\u0003\ti\u0001\u0003\u0005\u0002\u0014!\u0001\u000b\u0015BA\u0003\u0011\u001d\t)\u0002\u0003C\u0001\u0003/Aq!a\r\t\t\u0003\t)D\u0001\u000e[W\u000ecWo\u001d;fe2Kgn['jOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0014)\u0005IQ.[4sCRLwN\u001c\u0006\u0003+Y\t!A_6\u000b\u0003]\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00015A\u00111\u0004H\u0007\u0002%%\u0011QD\u0005\u0002\u00175.l\u0015n\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u00037\u0001\ta#Z7qif|\u0005/\u001a:bi&|gnQ8ogVlWM]\u000b\u0002GA!AeK\u0017;\u001b\u0005)#B\u0001\u0014(\u0003!1WO\\2uS>t'B\u0001\u0015*\u0003\u0011)H/\u001b7\u000b\u0003)\nAA[1wC&\u0011A&\n\u0002\u000b\u0005&\u001cuN\\:v[\u0016\u0014\bC\u0001\u00188\u001d\tyS\u0007\u0005\u00021g5\t\u0011G\u0003\u000231\u00051AH]8pizR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011ag\r\t\u0003w\u0011k\u0011\u0001\u0010\u0006\u0003'uR!AP \u0002\u00115,G/\u00193bi\u0006T!a\u0006!\u000b\u0005\u0005\u0013\u0015AB1qC\u000eDWMC\u0001D\u0003\ry'oZ\u0005\u0003\u000br\u0012qc\u0013*bMRl\u0015n\u001a:bi&|gn\u00149fe\u0006$\u0018n\u001c8\u0002/\u0015l\u0007\u000f^=Pa\u0016\u0014\u0018\r^5p]\u000e{gn];nKJ\u0004\u0013AF3naRL(I]8lKJDU-\u00197uQN#\u0018\r^3\u0016\u0003%\u0003BAS&N'6\tq%\u0003\u0002MO\t\u0019Q*\u00199\u0011\u00059\u000bV\"A(\u000b\u0005AK\u0013\u0001\u00027b]\u001eL!AU(\u0003\u000f%sG/Z4feB\u0011A+V\u0007\u0002{%\u0011a+\u0010\u0002\u0013\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|g.A\ff[B$\u0018P\u0011:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;fA\u00051C/Z:u\u00072,8\u000f^3s\u0019&t7.\u00118e\u001b&\u0014(o\u001c:U_BL7-T5he\u0006$\u0018n\u001c8\u0015\u0003i\u0003\"a\u0017/\u000e\u0003MJ!!X\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003\r}\u0003\"\u0001Y4\u000e\u0003\u0005T!AY2\u0002\u0007\u0005\u0004\u0018N\u0003\u0002eK\u00069!.\u001e9ji\u0016\u0014(B\u00014C\u0003\u0015QWO\\5u\u0013\tA\u0017M\u0001\u0003UKN$\bF\u0001\u0004k!\t\u00017.\u0003\u0002mC\nAA)[:bE2,G-A\u0015uKN$X*[4sCR,g)Y5mkJ,w+\u001b;i+:\u001cX\u000f\u001d9peR,G-T3uC\u0012\fG/\u0019\u0015\u0003\u000f}\u0013Q#T3uC\u0012\fG/\u0019#fYR\fg+\u001a:jM&,'o\u0005\u0002\tcB\u00111L]\u0005\u0003gN\u0012a!\u00118z%\u00164G#A;\u0011\u0005YDQ\"\u0001\u0001\u0002\u001b5,G/\u00193bi\u0006$U\r\u001c;b+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?@\u0003\u0015IW.Y4f\u0013\tq8PA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u000f[\u0016$\u0018\rZ1uC\u0012+G\u000e^1!\u0003\u0019ygMZ:fiV\u0011\u0011Q\u0001\t\u00047\u0006\u001d\u0011bAA\u0005g\t\u0019\u0011J\u001c;\u0002\u0015=4gm]3u?\u0012*\u0017\u000fF\u0002[\u0003\u001fA\u0011\"!\u0005\u000e\u0003\u0003\u0005\r!!\u0002\u0002\u0007a$\u0013'A\u0004pM\u001a\u001cX\r\u001e\u0011\u0002\r\u0005\u001c7-\u001a9u)\rQ\u0016\u0011\u0004\u0005\b\u00037y\u0001\u0019AA\u000f\u0003\u0015\u0011\u0017\r^2i!\u0015Q\u0015qDA\u0012\u0013\r\t\tc\n\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\r\r|W.\\8o\u0015\r\ticP\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005E\u0012q\u0005\u0002\u0015\u0003BLW*Z:tC\u001e,\u0017I\u001c3WKJ\u001c\u0018n\u001c8\u0002\rY,'/\u001b4z)\rQ\u0016q\u0007\u0005\b\u0003s\u0001\u0002\u0019AA\u001e\u0003!1XM]5gS\u0016\u0014\bCB.\u0002>\u0005\u0005#,C\u0002\u0002@M\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007i\f\u0019%C\u0002\u0002Fm\u0014Q\"T3uC\u0012\fG/Y%nC\u001e,\u0007")
public class ZkClusterLinkMigrationTest
extends ZkMigrationTestHarness {
    private final BiConsumer<String, KRaftMigrationOperation> emptyOperationConsumer = (x$1, x$2) -> {};
    private final java.util.Map<Integer, BrokerRegistration> emptyBrokerHealthState = Collections.emptyMap();

    public BiConsumer<String, KRaftMigrationOperation> emptyOperationConsumer() {
        return this.emptyOperationConsumer;
    }

    public java.util.Map<Integer, BrokerRegistration> emptyBrokerHealthState() {
        return this.emptyBrokerHealthState;
    }

    /*
     * WARNING - void declaration
     */
    @Disabled
    @Test
    public void testClusterLinkAndMirrorTopicMigration() {
        HashSet brokers = new HashSet();
        ArrayList batches = new ArrayList();
        ClusterLinkData link1 = new ClusterLinkData("link1", Uuid.randomUuid(), (Option)new Some((Object)"cluster1"), (Option)None$.MODULE$, false);
        Properties linkConfigs1 = new Properties();
        linkConfigs1.put("link.mode", "destination");
        linkConfigs1.put("ssl.keystore.password", "test");
        ClusterLinkData link2 = new ClusterLinkData("link2", Uuid.randomUuid(), (Option)new Some((Object)"cluster2"), (Option)None$.MODULE$, false);
        Properties linkConfigs2 = new Properties();
        linkConfigs2.put("cluster.link.prefix", "migration");
        ClusterLinkData deletedLink = new ClusterLinkData("deletedLink", Uuid.randomUuid(), (Option)new Some((Object)"cluster3"), (Option)None$.MODULE$, true);
        Properties deletedConfigs = new Properties();
        deletedConfigs.put("cluster.link.prefix", "migration2");
        deletedConfigs.put("link.mode", "destination");
        this.adminZkClient().createClusterLink(link1, this.zkLinkConfigEncoder().encode(linkConfigs1));
        this.adminZkClient().createClusterLink(link2, this.zkLinkConfigEncoder().encode(linkConfigs2));
        this.adminZkClient().createClusterLink(deletedLink, this.zkLinkConfigEncoder().encode(deletedConfigs));
        Map partitionReplicaAssignment = (Map)((MapOps)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                Seq v = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)new ReplicaAssignment(v, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Option)None$.MODULE$));
            }
            throw new MatchError(null);
        });
        String mirrorTopic1 = "mirrorTopic1";
        String mirrorTopic2 = "migrationmirrorTopic2";
        String mirrorTopic3 = "migration2mirrorTopic3";
        ClusterLinkTopicState.Mirror mirrorState1 = new ClusterLinkTopicState.Mirror(link1.linkName(), link1.linkId(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})));
        ClusterLinkTopicState.PausedMirror mirrorState2 = new ClusterLinkTopicState.PausedMirror(link2.linkName(), link2.linkId(), Uuid.randomUuid(), false, true, false, MirrorTopicError.NO_ERROR, Time.SYSTEM.milliseconds(), ClusterLinkTopicState.PausedMirror$.MODULE$.apply$default$9());
        ClusterLinkTopicState.Mirror mirrorState3 = new ClusterLinkTopicState.Mirror(deletedLink.linkName(), deletedLink.linkId(), Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L})));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$2 = new Properties();
        Some x$5 = new Some((Object)mirrorState1);
        boolean x$6 = qual$1.createTopicWithAssignment$default$4();
        boolean x$7 = qual$1.createTopicWithAssignment$default$6();
        qual$1.createTopicWithAssignment(mirrorTopic1, x$2, partitionReplicaAssignment, x$6, true, x$7, (Option)x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        Properties x$9 = new Properties();
        Some x$12 = new Some((Object)mirrorState2);
        boolean x$13 = qual$2.createTopicWithAssignment$default$4();
        boolean x$14 = qual$2.createTopicWithAssignment$default$6();
        qual$2.createTopicWithAssignment(mirrorTopic2, x$9, partitionReplicaAssignment, x$13, true, x$14, (Option)x$12);
        AdminZkClient qual$3 = this.adminZkClient();
        Properties x$16 = new Properties();
        Some x$19 = new Some((Object)mirrorState3);
        boolean x$20 = qual$3.createTopicWithAssignment$default$4();
        boolean x$21 = qual$3.createTopicWithAssignment$default$6();
        qual$3.createTopicWithAssignment(mirrorTopic3, x$16, partitionReplicaAssignment, x$20, true, x$21, (Option)x$19);
        Map leaderAndIsrs1 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic1, 0)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(0, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic1, 1)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic1, 2)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1))}));
        Map leaderAndIsrs2 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic2, 0)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(0, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic2, 1)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic2, 2)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1))}));
        Map leaderAndIsrs3 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic3, 0)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(0, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic3, 1)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(mirrorTopic3, 2)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})), LeaderRecoveryState.RECOVERED, -1, (Option)new Some((Object)new PartitionLinkState(5, false, MirrorTopicError.NO_ERROR))), 1))}));
        this.zkClient().createTopicPartitionStatesRaw(leaderAndIsrs1, 0);
        this.zkClient().createTopicPartitionStatesRaw(leaderAndIsrs2, 0);
        this.zkClient().createTopicPartitionStatesRaw(leaderAndIsrs3, 0);
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        AccessControlEntry ace1 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1.linkId(), link2.linkId(), deletedLink.linkId(), Uuid.ZERO_UUID}))).asJava());
        AclBinding acl1 = new AclBinding(resource1, ace1);
        AccessControlEntry ace2 = new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{deletedLink.linkId()}))).asJava());
        AclBinding acl2 = new AclBinding(resource1, ace2);
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)this.zkConnect())}))).asJava());
            authorizer.createAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)Nil$.MODULE$))).asJava());
            scala.collection.immutable.Map expectedMirrorStatesAfterMigration = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic1), (Object)mirrorState1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic2), (Object)mirrorState2)}));
            scala.collection.immutable.Map expectedLeaderAndIsrAfterMigration = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic1), (Object)leaderAndIsrs1.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition tp = (TopicPartition)x0$2._1();
                    LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$2._2();
                    return new Tuple2((Object)tp, (Object)new LeaderIsrAndControllerEpoch(lisr.leaderAndIsr().withPartitionEpoch(lisr.leaderAndIsr().partitionEpoch() + 1), lisr.controllerEpoch()));
                }
                throw new MatchError(null);
            })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic2), (Object)leaderAndIsrs2.map((Function1 & Serializable)x0$3 -> {
                if (x0$3 != null) {
                    TopicPartition tp = (TopicPartition)x0$3._1();
                    LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$3._2();
                    return new Tuple2((Object)tp, (Object)new LeaderIsrAndControllerEpoch(lisr.leaderAndIsr().withPartitionEpoch(lisr.leaderAndIsr().partitionEpoch() + 1), lisr.controllerEpoch()));
                }
                throw new MatchError(null);
            })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic3), (Object)leaderAndIsrs3.map((Function1 & Serializable)x0$4 -> {
                if (x0$4 != null) {
                    TopicPartition tp = (TopicPartition)x0$4._1();
                    LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$4._2();
                    return new Tuple2((Object)tp, (Object)new LeaderIsrAndControllerEpoch(lisr.leaderAndIsr().newEpochWithoutLinkLeader().withPartitionEpoch(lisr.leaderAndIsr().partitionEpoch() + 2), this.migrationState().kraftControllerEpoch()));
                }
                throw new MatchError(null);
            }))}));
            this.migrationClient().cleanAndMigrateAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId), (x$3, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())), this.emptyBrokerHealthState());
            AclBindingFilter resourceFilter = new AclBindingFilter(new ResourcePatternFilter(resource1.resourceType(), resource1.name(), resource1.patternType()), AclBindingFilter.ANY.entryFilter());
            AccessControlEntry ace12 = new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1.linkId(), link2.linkId(), Uuid.ZERO_UUID}))).asJava());
            AccessControlEntry ace22 = new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW);
            scala.collection.immutable.Set expectedAclsAfterMigration = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{ace12, ace22}));
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$8(expectedAclsAfterMigration, authorizer, resourceFilter)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"ACLs are not updated in the authorizer");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            scala.collection.immutable.Set expectedLinksAfterMigration = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkData[]{link1, link2}));
            scala.collection.immutable.Set linksFromZk = this.zkClient().getAllClusterLinks();
            Assertions.assertEquals((Object)expectedLinksAfterMigration, (Object)linksFromZk);
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{CoreUtils$.MODULE$.toJavaUUID(link1.linkId()).toString(), CoreUtils$.MODULE$.toJavaUUID(link2.linkId()).toString()})), (Object)this.zkClient().getAllEntitiesWithConfig(ConfigType$.MODULE$.ClusterLink()).toSet());
            scala.collection.immutable.Map mirrorStatesFromZk = ((IterableOnceOps)((IterableOps)this.zkClient().getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{mirrorTopic1, mirrorTopic2, mirrorTopic3}))).map((Function1 & Serializable)assignment -> new Tuple2((Object)assignment.topic(), (Object)assignment.clusterLink()))).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, Option<ClusterLinkTopicState>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    if (x1 != null) {
                        String topic = (String)x1._1();
                        Option stateOpt = (Option)x1._2();
                        if (stateOpt.isDefined()) {
                            return (B1)new Tuple2((Object)topic, stateOpt.get());
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, Option<ClusterLinkTopicState>> x1) {
                    return x1 != null && ((Option)x1._2()).isDefined();
                }
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Assertions.assertEquals((Object)expectedMirrorStatesAfterMigration, (Object)mirrorStatesFromZk);
            expectedLeaderAndIsrAfterMigration.foreach((Function1 & Serializable)x0$5 -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$12(this, x0$5);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((int)3, (int)brokers.size());
            Assertions.assertEquals((int)7, (int)batches.size());
            Assertions.assertEquals((int)1, (int)((java.util.List)batches.get(0)).size());
            ApiMessage encryptorRecord = ((ApiMessageAndVersion)((java.util.List)batches.get(0)).get(0)).message();
            Assertions.assertEquals((short)this.INSTALL_METADATA_ENCRYPTOR_RECORD_API_KEY(), (short)encryptorRecord.apiKey());
            Assertions.assertEquals((Object)this.kraftEncryptor().id(), (Object)((InstallMetadataEncryptorRecord)encryptorRecord).keyId());
            MetadataDelta delta = new MetadataDelta.Builder().setMetadataEncryptorFactory(this.kraftEncryptorFactory()).build();
            CollectionConverters$.MODULE$.ListHasAsScala(batches).asScala().foreach((Function1 & Serializable)batch -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$13(delta, batch);
                return BoxedUnit.UNIT;
            });
            MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
            scala.collection.immutable.Set linksFromImage = ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(image.clusterLinks().linksByName()).asScala().map((Function1 & Serializable)x0$6 -> {
                if (x0$6 != null) {
                    String name = (String)x0$6._1();
                    ClusterLink link = (ClusterLink)x0$6._2();
                    return new Tuple2((Object)name, (Object)new ClusterLinkData(link.linkName(), link.linkId(), (Option)new Some((Object)link.remoteClusterId()), OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(link.tenantPrefix())), false));
                }
                throw new MatchError(null);
            })).values().toSet();
            Assertions.assertTrue((boolean)image.configs().configProperties(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, deletedLink.linkId().toString())).isEmpty());
            Properties actualLinkConfigs1 = image.configs().configProperties(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, link1.linkId().toString()));
            Assertions.assertEquals((Object)linkConfigs1, (Object)actualLinkConfigs1);
            Properties actualLinkConfigs2 = image.configs().configProperties(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, link2.linkId().toString()));
            Assertions.assertEquals((Object)linkConfigs2, (Object)actualLinkConfigs2);
            scala.collection.mutable.Map mirrorStatesFromImage = (scala.collection.mutable.Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)image.topics().topicsByName()).asScala().map((Function1 & Serializable)x0$7 -> {
                if (x0$7 != null) {
                    String topic = (String)x0$7._1();
                    TopicImage topicImage = (TopicImage)x0$7._2();
                    return new Tuple2((Object)topic, (Object)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(topicImage.mirrorTopic())));
                }
                throw new MatchError(null);
            })).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, Option<MirrorTopic>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    if (x2 != null) {
                        String topic = (String)x2._1();
                        Option mirrorImage = (Option)x2._2();
                        if (mirrorImage.isDefined()) {
                            return (B1)new Tuple2((Object)topic, (Object)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorImage.get()));
                        }
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Tuple2<String, Option<MirrorTopic>> x2) {
                    return x2 != null && ((Option)x2._2()).isDefined();
                }
            });
            Assertions.assertEquals((Object)expectedMirrorStatesAfterMigration, (Object)mirrorStatesFromImage);
            expectedLeaderAndIsrAfterMigration.foreach((Function1 & Serializable)x0$8 -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$17(image, x0$8);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((Object)expectedLinksAfterMigration, (Object)linksFromImage);
            Uuid mirrorTopicId1 = image.topics().getTopic(mirrorTopic1).id();
            java.util.Map mirrorTopicPartitions1 = image.topics().getTopic(mirrorTopic1).partitions();
            this.migrationState_$eq(this.migrationClient().topicClient().updateTopic(mirrorTopic1, mirrorTopicId1, mirrorTopicPartitions1, Optional.empty(), this.migrationState()));
            Assertions.assertTrue((boolean)this.zkClient().getClusterLinkForTopic(mirrorTopic1).isEmpty());
            java.util.Map newMirrorTopicPartitions = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(mirrorTopicPartitions1).asScala().map((Function1 & Serializable)x0$11 -> {
                if (x0$11 != null) {
                    Integer tp = (Integer)x0$11._1();
                    PartitionRegistration registration = (PartitionRegistration)x0$11._2();
                    return new Tuple2((Object)tp, (Object)registration.unlink());
                }
                throw new MatchError(null);
            })).asJava();
            this.migrationState_$eq(this.migrationClient().topicClient().updateTopicPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mirrorTopic1), (Object)newMirrorTopicPartitions)}))).asJava(), this.migrationState()));
            this.zkClient().getTopicPartitionStates((Seq)leaderAndIsrs1.keys().toSeq()).values().foreach((Function1 & Serializable)lisr -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$21(lisr);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testMigrateFailureWithUnsupportedMetadata() {
        String nonMirrorTopicName = "non-mirror-topic";
        Map assignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(nonMirrorTopicName, 0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty()))}));
        this.zkClient().createTopicAssignment(nonMirrorTopicName, (Option)None$.MODULE$, (Option)None$.MODULE$, assignment, (Option)None$.MODULE$);
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String mirrorTopicName = "mirror-topic";
        String remoteClusterId = Uuid.randomUuid().toString();
        this.zkClient().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)new Some((Object)remoteClusterId), (Option)None$.MODULE$, false));
        this.zkClient().createTopicAssignment(mirrorTopicName, (Option)None$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty(), (Option)new Some((Object)new ClusterLinkTopicState.Mirror(mirrorTopicName, linkId, Uuid.randomUuid(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty())));
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(this.zkClient(), (PasswordEncoder)new NoOpPasswordEncoder(), new MetadataEncryptorFactory(Collections.emptyMap()), null);
        ZkMigrationLeadershipState migrationState = migrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
        migrationState = migrationState.withNewKRaftController(3000, 42);
        migrationClient.claimControllerLeadership(migrationState);
        migrationState = null;
        HashSet brokers = new HashSet();
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> migrationClient.cleanAndMigrateAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), brokerId -> brokers.add(brokerId), this.emptyOperationConsumer(), this.emptyBrokerHealthState()));
        Assertions.assertEquals((Object)"Found cluster links in metadata. Cannot proceed with migration", (Object)e.getMessage());
        this.zkClient().deleteClusterLink(linkId);
        e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> migrationClient.cleanAndMigrateAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), brokerId -> brokers.add(brokerId), this.emptyOperationConsumer(), this.emptyBrokerHealthState()));
        Assertions.assertEquals((Object)"Found mirror topics in metadata. Cannot proceed with migration", (Object)e.getMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkAndMirrorTopicMigration$8(scala.collection.immutable.Set expectedAclsAfterMigration$1, AclAuthorizer authorizer$1, AclBindingFilter resourceFilter$1) {
        scala.collection.immutable.Set set = expectedAclsAfterMigration$1;
        scala.collection.immutable.Set set2 = ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(resourceFilter$1)).asScala().map((Function1 & Serializable)x$4 -> x$4.entry())).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkAndMirrorTopicMigration$10() {
        return "ACLs are not updated in the authorizer";
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$12(ZkClusterLinkMigrationTest $this, Tuple2 x0$5) {
        if (x0$5 != null) {
            Map lisrs = (Map)x0$5._2();
            Assertions.assertEquals((Object)lisrs, (Object)$this.zkClient().getTopicPartitionStates((Seq)lisrs.keys().toSeq()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$13(MetadataDelta delta$1, java.util.List batch) {
        CollectionConverters$.MODULE$.ListHasAsScala(batch).asScala().foreach((Function1 & Serializable)record -> {
            delta$1.replay(record.message());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$19(scala.collection.mutable.Map actualPartitionStates$1, Tuple2 x0$10) {
        if (x0$10 != null) {
            TopicPartition tp = (TopicPartition)x0$10._1();
            LeaderIsrAndControllerEpoch expectedPartition = (LeaderIsrAndControllerEpoch)x0$10._2();
            Assertions.assertTrue((boolean)expectedPartition.leaderAndIsr().equalsAllowStalePartitionEpoch((LeaderAndIsr)actualPartitionStates$1.apply((Object)tp)), (String)new StringBuilder(37).append("For partition ").append(tp).append(": Expected : ").append(expectedPartition.leaderAndIsr()).append(", ").append("Actual: ").append(actualPartitionStates$1.apply((Object)tp)).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$17(MetadataImage image$1, Tuple2 x0$8) {
        if (x0$8 != null) {
            String topic = (String)x0$8._1();
            Map lisrs = (Map)x0$8._2();
            scala.collection.mutable.Map actualPartitionStates = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicImage)image$1.topics().topicsByName().get((Object)topic)).partitions()).asScala().map((Function1 & Serializable)x0$9 -> {
                if (x0$9 != null) {
                    None$ none$;
                    Integer partition = (Integer)x0$9._1();
                    PartitionRegistration registration = (PartitionRegistration)x0$9._2();
                    TopicPartition topicPartition = new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition));
                    int n = registration.leader;
                    int n2 = registration.leaderEpoch;
                    List list = Predef$.MODULE$.wrapIntArray(registration.isr).toList();
                    LeaderRecoveryState leaderRecoveryState = registration.leaderRecoveryState;
                    int n3 = registration.partitionEpoch;
                    PartitionRegistration.LinkState linkState = registration.linkState;
                    PartitionRegistration.LinkState linkState2 = PartitionRegistration.LinkState.NOT_MIRROR;
                    if (linkState == null ? linkState2 != null : !linkState.equals(linkState2)) {
                        PartitionRegistration.LinkState linkState3 = registration.linkState;
                        PartitionRegistration.LinkState linkState4 = PartitionRegistration.LinkState.FAILED;
                        boolean bl = !(linkState3 != null ? !linkState3.equals(linkState4) : linkState4 != null);
                        none$ = new Some((Object)new PartitionLinkState(registration.linkedLeaderEpoch, bl, MirrorTopicError.NO_ERROR));
                    } else {
                        none$ = None$.MODULE$;
                    }
                    return new Tuple2((Object)topicPartition, (Object)LeaderAndIsr$.MODULE$.apply(n, n2, list, leaderRecoveryState, n3, (Option)none$));
                }
                throw new MatchError(null);
            });
            Assertions.assertEquals((int)lisrs.size(), (int)actualPartitionStates.size());
            Assertions.assertEquals((Object)lisrs.keySet(), (Object)actualPartitionStates.keySet());
            lisrs.foreach((Function1 & Serializable)x0$10 -> {
                ZkClusterLinkMigrationTest.$anonfun$testClusterLinkAndMirrorTopicMigration$19(actualPartitionStates, x0$10);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAndMirrorTopicMigration$21(LeaderIsrAndControllerEpoch lisr) {
        Assertions.assertTrue((boolean)lisr.leaderAndIsr().clusterLinkState().isEmpty());
    }

    public class MetadataDeltaVerifier {
        private final MetadataDelta metadataDelta;
        private int offset;

        public MetadataDelta metadataDelta() {
            return this.metadataDelta;
        }

        public int offset() {
            return this.offset;
        }

        public void offset_$eq(int x$1) {
            this.offset = x$1;
        }

        public void accept(java.util.List<ApiMessageAndVersion> batch) {
            batch.forEach(message -> {
                this.metadataDelta().replay(message.message());
                this.offset_$eq(this.offset() + 1);
            });
        }

        public void verify(Function1<MetadataImage, BoxedUnit> verifier) {
            MetadataImage image = this.metadataDelta().apply(new MetadataProvenance((long)this.offset(), 0, 0L));
            verifier.apply((Object)image);
        }

        public /* synthetic */ ZkClusterLinkMigrationTest kafka$zk$migration$ZkClusterLinkMigrationTest$MetadataDeltaVerifier$$$outer() {
            return ZkClusterLinkMigrationTest.this;
        }

        public MetadataDeltaVerifier() {
            if (ZkClusterLinkMigrationTest.this == null) {
                throw null;
            }
            this.metadataDelta = new MetadataDelta.Builder().build();
            this.offset = 0;
        }
    }
}

