/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import kafka.tier.serdes.CheckedFileIOHeader;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.TestArguments;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.kafka.common.errors.MultiChecksumTypeException;
import org.apache.kafka.common.errors.OtherChecksumTypeException;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t]c\u0001B\u0016-\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003>\u0011\u0019A\u0005\u0001)A\u0005}!9\u0011\n\u0001b\u0001\n\u0013i\u0004B\u0002&\u0001A\u0003%a\bC\u0004L\u0001\t\u0007I\u0011\u0002'\t\r]\u0003\u0001\u0015!\u0003N\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006b\u00020\u0001\u0005\u0004%I!\u0017\u0005\u0007?\u0002\u0001\u000b\u0011\u0002.\t\u000b\u0001\u0004A\u0011A1\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\"\u0002!\t!!%\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002\u0012\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0006bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0003#\u0004A\u0011AAI\u0011\u001d\t)\u000e\u0001C\u0001\u0003/Dq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002j\u0002!\t!!%\t\u000f\u00055\b\u0001\"\u0001\u0002\u0012\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M\bbBA}\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003{\u0004A\u0011AAI\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005\u0007AqA!\r\u0001\t\u0013\u0011\u0019\u0004C\u0004\u0003P\u0001!IA!\u0015\u0003#\rCWmY6fI\u001aKG.Z%P)\u0016\u001cHO\u0003\u0002.]\u0005)Q\u000f^5mg*\tq&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002uA\u00111\bA\u0007\u0002Y\u0005AA/Z:u'R\u0014\u0018'F\u0001?!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003mC:<'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013aa\u0015;sS:<\u0017!\u0003;fgR\u001cFO]\u0019!\u0003!!Xm\u001d;TiJ\u0014\u0014!\u0003;fgR\u001cFO\u001d\u001a!\u0003!!Xm\u001d;TiJ\u001c\u0014!\u0003;fgR\u001cFO]\u001a!\u0003)!Xm\u001d;IK\u0006$WM]\u000b\u0002\u001bB\u0011a*V\u0007\u0002\u001f*\u0011\u0001+U\u0001\fM2\fGOY;gM\u0016\u00148O\u0003\u0002S'\u00061qm\\8hY\u0016T\u0011\u0001V\u0001\u0004G>l\u0017B\u0001,P\u0005E1E.\u0019;Ck\u001a4WM\u001d\"vS2$WM]\u0001\fi\u0016\u001cH\u000fS3bI\u0016\u0014\b%\u0001\u0007uKN$\b*Z1eKJLE-F\u0001[!\t\u00194,\u0003\u0002]i\t\u0019\u0011J\u001c;\u0002\u001bQ,7\u000f\u001e%fC\u0012,'/\u00133!\u0003I)\u0007\u0010]3di\u0016$\u0007*Z1eKJ\u001c\u0016N_3\u0002'\u0015D\b/Z2uK\u0012DU-\u00193feNK'0\u001a\u0011\u0002\u0015Q,7\u000f^\"sK\u0006$X\r\u0006\u0002cKB\u00111gY\u0005\u0003IR\u0012A!\u00168ji\")aM\u0004a\u0001O\u0006!\u0011M]4t!\tA7N\u0004\u0002<S&\u0011!\u000eL\u0001\u000e)\u0016\u001cH/\u0011:hk6,g\u000e^:\n\u00051l'\u0001B!sONT!A\u001b\u0017)\t9yWP \t\u0003anl\u0011!\u001d\u0006\u0003eN\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003iV\fa\u0001]1sC6\u001c(B\u0001<x\u0003\u001dQW\u000f]5uKJT!\u0001_=\u0002\u000b),h.\u001b;\u000b\u0003i\f1a\u001c:h\u0013\ta\u0018OA\bBe\u001e,X.\u001a8ugN{WO]2f\u0003\u00151\u0018\r\\;fG\u0005y\bc\u00015\u0002\u0002%\u0019\u00111A7\u0003-Y\u000bG.\u001b3Be\u001e,X.\u001a8ugB\u0013xN^5eKJD3ADA\u0004!\u0011\tI!a\u0003\u000e\u0003ML1!!\u0004t\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0013i\u0016\u001cH\u000fS3bI\u0016\u00148\t[3dWN,X\u000eF\u0002c\u0003'AQAZ\bA\u0002\u001dDSaD8~\u0003/\u0019#!!\u0007\u0011\u0007!\fY\"C\u0002\u0002\u001e5\u00141DV1mS\u0012\fE\r\\3s\u0003J<W/\\3oiN\u0004&o\u001c<jI\u0016\u0014\bfA\b\u0002\b\u0005\u0011C/Z:u/JLG/Z,ji\"Le\u000e^3sY\u0016\fg/\u001a3CsR,')\u001e4gKJ$2AYA\u0013\u0011\u00151\u0007\u00031\u0001hQ\u0011\u0001r. @)\u0007A\t9!A\u000buKN$xK]5uK^KG\u000f\u001b)pg&$\u0018n\u001c8\u0015\u0007\t\fy\u0003C\u0003g#\u0001\u0007q\r\u000b\u0003\u0012_vt\bfA\t\u0002\b\u0005IA/Z:u/JLG/\u001a\u000b\u0004E\u0006e\u0002\"\u00024\u0013\u0001\u00049\u0007\u0006\u0002\np{zD3AEA\u0004\u0003)!Xm\u001d;SK>\u0003XM\u001c\u000b\u0004E\u0006\r\u0003\"\u00024\u0014\u0001\u00049\u0007\u0006B\np{zD3aEA\u0004\u0003u!Xm\u001d;G_J\u001cW-T8eS\u001aLh)\u001b7f)>4\u0015-\u001b7Pa\u0016tGc\u00012\u0002N!)a\r\u0006a\u0001O\"*Ac\\?\u0002\u0018!\u001aA#a\u0002\u0002CQ,7\u000f\u001e$pe\u000e,Wj\u001c3jMf4\u0015\u000e\\3U_\u001a\u000b\u0017\u000e\u001c,bY&$\u0017\r^3\u0015\u0007\t\f9\u0006C\u0003g+\u0001\u0007q\rK\u0003\u0016_v\f9\u0002K\u0002\u0016\u0003\u000f\tA\u0002^3tiR\u0013XO\\2bi\u0016$2AYA1\u0011\u00151g\u00031\u0001hQ\u00111r. @)\u0007Y\t9!\u0001\ruKN$HK];oG\u0006$XmV5uQB{7/\u001b;j_:$2AYA6\u0011\u00151w\u00031\u0001hQ\u00119r. @)\u0007]\t9!\u0001\buKN$HK]1og\u001a,'\u000fV8\u0015\u0007\t\f)\bC\u0003g1\u0001\u0007q\r\u000b\u0003\u0019_vt\bf\u0001\r\u0002\b\u0005\u0001B/Z:u)J\fgn\u001d4fe\u001a\u0013x.\u001c\u000b\u0004E\u0006}\u0004\"\u00024\u001a\u0001\u00049\u0007\u0006B\rp{zD3!GA\u0004\u0003\r\"Xm\u001d;Ue\u0006t7OZ3s)><\u0016\u000e\u001e5Q_NLG/[8o\r>\u0014H+\u0019:hKR$2AYAE\u0011\u00151'\u00041\u0001hQ\u0011Qr. @)\u0007i\t9!A\u000buKN$(+\u001a9fCR,G-T5he\u0006$X\rV8\u0015\u0003\tD3aGAK!\u0011\t9*!(\u000e\u0005\u0005e%bAANk\u0006\u0019\u0011\r]5\n\t\u0005}\u0015\u0011\u0014\u0002\u0005)\u0016\u001cH/A\u0011uKN$X*[4sCR,gI]8n\u001d>t7\t[3dWN,X\u000eV8BI2,'\u000fK\u0002\u001d\u0003+\u000b\u0011\u0005^3ti6KwM]1uK\u001a\u0013x.\\!eY\u0016\u0014Hk\u001c(p]\u000eCWmY6tk6D3!HAK\u00039!Xm\u001d;TkB,'O\u00117pG.$2AYAW\u0011\u00151g\u00041\u0001hQ\u0015qr.`A\fQ\rq\u0012qA\u0001\u0012S:4\u0018\r\\5e\u001fB,g\u000eS3ma\u0016\u0014H#\u00022\u00028\u0006\u001d\u0007bBA]?\u0001\u0007\u00111X\u0001\nC2<wN]5uQ6\u0004B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003d\u0013\u0001C2iK\u000e\\7/^7\n\t\u0005\u0015\u0017q\u0018\u0002\n\u00032<wN]5uQ6Dq!!3 \u0001\u0004\tY-\u0001\ttkB,'O\u00117pG.dUM\\4uQB\u00191'!4\n\u0007\u0005=GGA\u0003TQ>\u0014H/A\buKN$\u0018J\u001c<bY&$w\n]3oQ\r\u0001\u0013QS\u0001\ti\u0016\u001cHo\u00149f]R\u0019!-!7\t\u000b\u0019\f\u0003\u0019A4)\u000b\u0005zW0a\u0006)\u0007\u0005\n9!\u0001\buKN$x\n]3o\t&\u0014Xm\u0019;\u0015\u0007\t\f\u0019\u000fC\u0003gE\u0001\u0007q\rK\u0003#_v\f9\u0002K\u0002#\u0003\u000f\ta\u0003^3ti&sg/\u00197jI6KwM]1uK\u001aKG.\u001a\u0015\u0004G\u0005U\u0015a\u0006;fgRlU\u000f\u001c;ja2,gi\u001c:nCR4\u0015\u000e\\3tQ\r!\u0013QS\u0001#S:4\u0018\r\\5e\r&dWm\u00115b]:,Gn\u00149fe\u0006$\u0018n\u001c8t\u0011\u0016d\u0007/\u001a:\u0015\u000b\t\f)0a>\t\u000f\u0005eV\u00051\u0001\u0002<\"9\u0011\u0011Z\u0013A\u0002\u0005-\u0017\u0001\t;fgRLeN^1mS\u00124\u0015\u000e\\3DQ\u0006tg.\u001a7Pa\u0016\u0014\u0018\r^5p]ND3AJAK\u0003=!Xm\u001d;U_\u0006cwm\u001c:ji\"l\u0007fA\u0014\u0002\u0016\u0006\tb/\u001a:jMf4\u0015\u000e\\3D_:$XM\u001c;\u0015\u000f\t\u0014)A!\b\u0003(!9!q\u0001\u0015A\u0002\t%\u0011\u0001C3ya\u0016\u001cG/\u001a3\u0011\t\t-!\u0011\u0004\b\u0005\u0005\u001b\u0011)\u0002E\u0002\u0003\u0010Qj!A!\u0005\u000b\u0007\tM\u0001'\u0001\u0004=e>|GOP\u0005\u0004\u0005/!\u0014A\u0002)sK\u0012,g-C\u0002F\u00057Q1Aa\u00065\u0011\u001d\u0011y\u0002\u000ba\u0001\u0005C\taAZ5mK&{\u0005\u0003BA_\u0005GIAA!\n\u0002@\ni1\t[3dW\u0016$g)\u001b7f\u0013>CqA!\u000b)\u0001\u0004\u0011Y#\u0001\u0007e_Z\u000bG.\u001b3bi&|g\u000eE\u00024\u0005[I1Aa\f5\u0005\u001d\u0011un\u001c7fC:\fAB^3sS\u001aL\b*Z1eKJ$\u0012B\u0019B\u001b\u0005\u0013\u0012YE!\u0014\t\u000f\t]\u0012\u00061\u0001\u0003:\u0005!\u0001/\u0019;i!\u0011\u0011YD!\u0012\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\nAAZ5mK*\u0019!1\t\"\u0002\u00079Lw.\u0003\u0003\u0003H\tu\"\u0001\u0002)bi\"DqAa\u0002*\u0001\u0004\u0011I\u0001C\u0004\u0002J&\u0002\r!a3\t\u000f\t%\u0012\u00061\u0001\u0003,\u0005)!0\u001a:pgR!!\u0011\u0002B*\u0011\u0019\u0011)F\u000ba\u00015\u0006\ta\u000e")
public class CheckedFileIOTest {
    private final String testStr1;
    private final String testStr2;
    private final String testStr3;
    private final FlatBufferBuilder testHeader = new FlatBufferBuilder().forceDefaults(true);
    private final int testHeaderId = CheckedFileIOHeader.createCheckedFileIOHeader((FlatBufferBuilder)this.testHeader(), (byte)1, (long)1L, (long)0L);
    private final int expectedHeaderSize;

    private String testStr1() {
        return this.testStr1;
    }

    private String testStr2() {
        return this.testStr2;
    }

    private String testStr3() {
        return this.testStr3;
    }

    private FlatBufferBuilder testHeader() {
        return this.testHeader;
    }

    private int testHeaderId() {
        return this.testHeaderId;
    }

    private int expectedHeaderSize() {
        return this.expectedHeaderSize;
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testCreate(TestArguments.Args args) {
        Path path = File.createTempFile("testCreate", args.algorithm().suffix).toPath();
        Assertions.assertThrows(FileAlreadyExistsException.class, () -> CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength()));
        Files.delete(path);
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Assertions.assertThrows(FileAlreadyExistsException.class, () -> CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength()));
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testHeaderChecksum(TestArguments.Args args) {
        String expectedStr = "";
        String prvExpectedStr = "";
        Path adlerPath = new File(new StringBuilder(10).append("testHeader").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)adlerPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var6_5 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)adlerPath, (boolean)false, (OpenOption[])open_options);
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), 0L);
        expectedStr = new StringBuilder(0).append(expectedStr).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.flush();
        prvExpectedStr = expectedStr;
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), 0L);
        expectedStr = new StringBuilder(0).append(this.testStr2()).append(this.testStr3().substring(this.testStr2().length())).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.flush();
        prvExpectedStr = expectedStr;
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), (long)this.testStr2().length());
        expectedStr = new StringBuilder(0).append(this.testStr2()).append(this.testStr1()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.flush();
        prvExpectedStr = expectedStr;
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.close();
        Files.delete(adlerPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testWriteWithInterleavedByteBuffer(TestArguments.Args args) {
        Path path = new File(new StringBuilder(34).append("testWriteWithInterleavedByteBuffer").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        String expectedStr = this.testStr2();
        cfIO.write(CheckedFileIOTest.toInterleavedByteBuffer$1(this.testStr2()), 0L);
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTest.toInterleavedByteBuffer$1(this.testStr1()), 1L);
        expectedStr = new StringBuilder(0).append(this.testStr2().substring(0, 1)).append(this.testStr1()).append(this.testStr2().substring(1 + this.testStr1().length())).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTest.toInterleavedByteBuffer$1(this.testStr3()), 1L);
        expectedStr = new StringBuilder(0).append(this.testStr2().substring(0, 1)).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testWriteWithPosition(TestArguments.Args args) {
        Path path = new File(new StringBuilder(21).append("testWriteWithPosition").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var6_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        this.testStr1();
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        String expectedStr = this.testStr1();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)this.testStr1().length());
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr2()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), (long)this.testStr1().length());
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)this.testStr1().length());
        expectedStr = new StringBuilder(1).append(this.testStr1()).append(this.testStr2()).append("3").toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), (long)(this.testStr1().length() + this.testStr3().length() + 5));
        expectedStr = new StringBuilder(1).append(this.testStr1()).append(this.testStr2()).append("3").append(this.zeros(5)).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        String randomStr = RandomStringUtils.randomAscii((int)100000);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(randomStr), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(randomStr).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testWrite(TestArguments.Args args) {
        Path path = new File(new StringBuilder(9).append("testWrite").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var6_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        this.testStr1();
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()));
        String expectedStr = this.testStr1();
        Assertions.assertEquals((long)expectedStr.length(), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr2()).toString();
        Assertions.assertEquals((long)expectedStr.length(), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.position((long)this.testStr1().length());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()));
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr3()).toString();
        Assertions.assertEquals((long)expectedStr.length(), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.position((long)this.testStr1().length());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        expectedStr = new StringBuilder(1).append(this.testStr1()).append(this.testStr2()).append("3").toString();
        Assertions.assertEquals((long)(this.testStr1().length() + this.testStr2().length()), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.position((long)(this.testStr1().length() + this.testStr3().length() + 5));
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()));
        expectedStr = new StringBuilder(1).append(this.testStr1()).append(this.testStr2()).append("3").append(this.zeros(5)).append(this.testStr3()).toString();
        Assertions.assertEquals((long)expectedStr.length(), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        String randomStr = RandomStringUtils.randomAscii((int)100000);
        cfIO.position((long)expectedStr.length());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(randomStr), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(randomStr).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testReOpen(TestArguments.Args args) {
        void openOrCreate_options;
        void openOrCreate_superBlockLength;
        Path path = new File(new StringBuilder(10).append("testReOpen").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        String expectedStr = this.testStr1();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(path, "", args.superBlockLength(), args.doValidation());
        cfIO.close();
        this.verifyHeader(path, expectedStr, args.superBlockLength(), args.doValidation());
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        short s = args.superBlockLength();
        Algorithm openOrCreate_algo = args.algorithm();
        Object var6_8 = null;
        openOptionArray = null;
        cfIO = CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var9_9 = null;
        cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options2);
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)this.testStr1().length());
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr2()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(path, this.testStr1(), args.superBlockLength(), args.doValidation());
        cfIO.flush();
        this.verifyHeader(path, expectedStr, args.superBlockLength(), args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testForceModifyFileToFailOpen(TestArguments.Args args) {
        Path adlerPath = new File(new StringBuilder(33).append("testForceModifyFileToFailChecksum").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)adlerPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)adlerPath, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.close();
        FileChannel fc = FileChannel.open(adlerPath, StandardOpenOption.WRITE);
        Utils.writeFully((FileChannel)fc, (long)fc.size(), (ByteBuffer)CheckedFileIOTestUtils$.MODULE$.toByteBuffer("extra"));
        fc.close();
        Assertions.assertTrue((boolean)((IOException)Assertions.assertThrows(IOException.class, () -> {
            void openOrCreate_options;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            short openOrCreate_superBlockLength = args.superBlockLength();
            Algorithm openOrCreate_algo = args.algorithm();
            CheckedFileIO.openOrCreate((Path)adlerPath, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        })).getMessage().contains("File couldn't be opened because file sz has changed to"));
        Files.delete(adlerPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testForceModifyFileToFailValidate(TestArguments.Args args) {
        Path adlerPath = new File(new StringBuilder(33).append("testForceModifyFileToFailValidate").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)adlerPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)adlerPath, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), 0L);
        this.verifyFileContent(this.testStr2(), cfIO, args.doValidation());
        cfIO.close();
        FileChannel fc = FileChannel.open(adlerPath, StandardOpenOption.WRITE);
        Utils.writeFully((FileChannel)fc, (long)args.superBlockLength(), (ByteBuffer)CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()));
        fc.close();
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ};
        Object var6_6 = null;
        cfIO = CheckedFileIO.open((Path)adlerPath, (boolean)false, (OpenOption[])open_options2);
        Assertions.assertFalse((boolean)cfIO.validate());
        cfIO.close();
        Files.delete(adlerPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTruncate(TestArguments.Args args) {
        Path path = new File(new StringBuilder(12).append("testTruncate").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var4_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.truncate(0L);
        this.verifyFileContent("", cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.truncate(0L);
        this.verifyFileContent("", cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), 0L);
        this.verifyFileContent(this.testStr2(), cfIO, args.doValidation());
        cfIO.truncate(5L);
        this.verifyFileContent(this.testStr2().substring(0, 5), cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), 5L);
        this.verifyFileContent(new StringBuilder(0).append(this.testStr2().substring(0, 5)).append(this.testStr3()).toString(), cfIO, args.doValidation());
        cfIO.truncate(100L);
        this.verifyFileContent(new StringBuilder(0).append(this.testStr2().substring(0, 5)).append(this.testStr3()).toString(), cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTruncateWithPosition(TestArguments.Args args) {
        Path path = new File(new StringBuilder(24).append("testTruncateWithPosition").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var4_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.position(3L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.truncate(5L);
        Assertions.assertEquals((long)3L, (long)cfIO.position());
        this.verifyFileContent(this.testStr1().substring(0, 5), cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTransferTo(TestArguments.Args args) {
        Path srcPath = new File(new StringBuilder(18).append("testTransferTo-src").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var6_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Path destPath = new File(new StringBuilder(19).append("testTransferTo-dest").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var7_6 = null;
        CheckedFileIO dstIO = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent("", dstIO, args.doValidation());
        cfIO.transferTo(0L, (long)this.testStr1().length(), dstIO);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent(this.testStr1(), dstIO, args.doValidation());
        dstIO.truncate(0L);
        cfIO.transferTo(3L, (long)(this.testStr1().length() - 3), dstIO);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent(this.testStr1().substring(3), dstIO, args.doValidation());
        cfIO.transferTo((long)this.testStr1().length(), 100L, dstIO);
        this.verifyFileContent(this.testStr1().substring(3), dstIO, args.doValidation());
        cfIO.close();
        dstIO.close();
        Files.delete(srcPath);
        Files.delete(destPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTransferFrom(TestArguments.Args args) {
        Path srcPath = new File(new StringBuilder(20).append("testTransferFrom-src").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var6_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Path destPath = new File(new StringBuilder(21).append("testTransferFrom-dest").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var7_6 = null;
        ObjectRef dstIO = ObjectRef.create((Object)CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2));
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent("", (CheckedFileIO)dstIO.elem, args.doValidation());
        ((CheckedFileIO)dstIO.elem).transferFrom(cfIO, 0L, (long)this.testStr1().length());
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent(this.testStr1(), (CheckedFileIO)dstIO.elem, args.doValidation());
        ((CheckedFileIO)dstIO.elem).truncate(0L);
        ((CheckedFileIO)dstIO.elem).transferFrom(cfIO, 3L, (long)(this.testStr1().length() - 3));
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent(this.testStr1().substring(3), (CheckedFileIO)dstIO.elem, args.doValidation());
        ((CheckedFileIO)dstIO.elem).close();
        OpenOption[] open_options3 = new OpenOption[]{StandardOpenOption.READ};
        Object var8_8 = null;
        dstIO.elem = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options3);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((CheckedFileIO)dstIO$1.elem).transferFrom(cfIO, 0L, (long)this.testStr1().length()))).getMessage().contains("Cannot transfer from as file is read-only"));
        cfIO.close();
        ((CheckedFileIO)dstIO.elem).close();
        Files.delete(srcPath);
        Files.delete(destPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTransferToWithPositionForTarget(TestArguments.Args args) {
        Path srcPath = new File(new StringBuilder(30).append("testTransferToWithPosition-src").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var6_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Path destPath = new File(new StringBuilder(31).append("testTransferToWithPosition-dest").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var7_6 = null;
        CheckedFileIO dstIO = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        dstIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        this.verifyFileContent(this.testStr2(), dstIO, args.doValidation());
        cfIO.transferTo(0L, (long)this.testStr1().length(), dstIO);
        this.verifyFileContent(new StringBuilder(0).append(this.testStr2()).append(this.testStr1()).toString(), dstIO, args.doValidation());
        cfIO.close();
        dstIO.close();
        Files.delete(srcPath);
        Files.delete(destPath);
    }

    @Test
    public void testRepeatedMigrateTo() {
        Algorithm srcAlgorithm = Algorithm.ADLER;
        short srcSuperBlockLength = 4096;
        Path srcPath = new File(new StringBuilder(25).append("testRepeatedMigrateTo-src").append(srcAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)srcAlgorithm, (short)srcSuperBlockLength);
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var14_4 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        String expectedStr = this.testStr1();
        this.verifyFileContent(expectedStr, cfIO, true);
        cfIO.close();
        Algorithm destAlgorithm = Algorithm.NO_CHECKSUM;
        short destSuperBlockLength = 0;
        Path destPath = new File(new StringBuilder(26).append("testRepeatedMigrateTo-dest").append(destAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)destSuperBlockLength);
        Assertions.assertFalse((boolean)Files.exists(srcPath, new LinkOption[0]));
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var15_10 = null;
        cfIO = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        this.verifyFileContent(expectedStr, cfIO, false);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(this.testStr2()).toString();
        this.verifyFileContent(expectedStr, cfIO, false);
        cfIO.close();
        Path newSrcPath = new File(new StringBuilder(28).append("testRepeatedMigrateTo-srcNew").append(srcAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.migrateFile((Path)destPath, (Path)newSrcPath, (short)srcSuperBlockLength);
        Assertions.assertFalse((boolean)Files.exists(destPath, new LinkOption[0]));
        Path tmpPath = new File(new StringBuilder(17).append("CheckedFileIO.tmp").append(srcAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)tmpPath, (Algorithm)srcAlgorithm, (short)srcSuperBlockLength);
        OpenOption[] open_options3 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var16_13 = null;
        CheckedFileIO tmpIO = CheckedFileIO.open((Path)tmpPath, (boolean)false, (OpenOption[])open_options3);
        tmpIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()));
        Path anotherSrcPath = new File(new StringBuilder(32).append("testRepeatedMigrateTo-srcAnother").append(srcAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)anotherSrcPath, (Algorithm)srcAlgorithm, (short)srcSuperBlockLength);
        OpenOption[] open_options4 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var17_16 = null;
        CheckedFileIO srcAnotherIO = CheckedFileIO.open((Path)anotherSrcPath, (boolean)false, (OpenOption[])open_options4);
        srcAnotherIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        OpenOption[] open_options5 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var18_18 = null;
        cfIO = CheckedFileIO.open((Path)newSrcPath, (boolean)false, (OpenOption[])open_options5);
        this.verifyFileContent(expectedStr, cfIO, true);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, true);
        this.verifyFileContent(this.testStr3(), tmpIO, true);
        this.verifyFileContent(this.testStr2(), srcAnotherIO, true);
        cfIO.close();
        tmpIO.close();
        srcAnotherIO.close();
        Files.delete(anotherSrcPath);
        Files.delete(tmpPath);
        Files.delete(newSrcPath);
    }

    @Test
    public void testMigrateFromNonChecksumToAdler() {
        new .colon.colon((Object)"", (List)new .colon.colon((Object)this.testStr1(), (List)new .colon.colon((Object)RandomStringUtils.randomAscii((int)4096), (List)new .colon.colon((Object)RandomStringUtils.randomAscii((int)0xA00000), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)str -> {
            CheckedFileIOTest.$anonfun$testMigrateFromNonChecksumToAdler$1(this, str);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMigrateFromAdlerToNonChecksum() {
        new .colon.colon((Object)"", (List)new .colon.colon((Object)this.testStr1(), (List)new .colon.colon((Object)RandomStringUtils.randomAscii((int)4096), (List)new .colon.colon((Object)RandomStringUtils.randomAscii((int)0xA00000), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)str -> {
            CheckedFileIOTest.$anonfun$testMigrateFromAdlerToNonChecksum$1(this, str);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testSuperBlock(TestArguments.Args args) {
        void openOrCreate_options;
        void openOrCreate_superBlockLength;
        Path path = new File(new StringBuilder(14).append("testSuperBlock").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        String expectedStr = this.testStr1();
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.close();
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        short s = args.superBlockLength();
        Algorithm openOrCreate_algo = Algorithm.ADLER;
        Object var6_8 = null;
        openOptionArray = null;
        cfIO = CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(this.testStr2()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            void openOrCreate_options;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            short openOrCreate_superBlockLength = (short)4000;
            Algorithm openOrCreate_algo = Algorithm.ADLER;
            CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        })).getMessage().contains("Incorrect superBlockLength"));
        Files.delete(path);
    }

    private void invalidOpenHelper(Algorithm algorithm, short superBlockLength) {
        Path path = new File(new StringBuilder(15).append("testInvalidOpen").append(algorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)algorithm, (short)superBlockLength);
        ObjectRef otherAlgorithm = ObjectRef.create(null);
        if (algorithm.equals(Algorithm.ADLER)) {
            otherAlgorithm.elem = Algorithm.NO_CHECKSUM;
        } else {
            Algorithm algorithm2 = algorithm;
            Algorithm algorithm3 = Algorithm.NO_CHECKSUM;
            if (!(algorithm2 != null ? !algorithm2.equals(algorithm3) : algorithm3 != null)) {
                otherAlgorithm.elem = Algorithm.ADLER;
            }
        }
        Assertions.assertTrue((boolean)((OtherChecksumTypeException)Assertions.assertThrows(OtherChecksumTypeException.class, () -> {
            void openOrCreate_options;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            Algorithm openOrCreate_algo = (Algorithm)otherAlgorithm$1.elem;
            CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        })).getMessage().contains("file exists"));
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.openOrCreate((Path)path, (Algorithm)algorithm, (short)superBlockLength, (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE}))).getMessage().contains("options missing READ and WRITE"));
        Files.delete(path);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            OpenOption[] openOrCreate_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            CheckedFileIO.openOrCreate((Path)path, (Algorithm)algorithm, (short)superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        })).getMessage().contains("CREATE or CREATE_NEW option is missing"));
    }

    @Test
    public void testInvalidOpen() {
        this.invalidOpenHelper(Algorithm.ADLER, (short)600);
        this.invalidOpenHelper(Algorithm.ADLER, (short)4096);
        this.invalidOpenHelper(Algorithm.NO_CHECKSUM, (short)0);
        Path adlerPath = new File(new StringBuilder(24).append("testInvalidOpenWithAdler").append(Algorithm.ADLER.suffix).toString()).toPath();
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.create((Path)adlerPath, (Algorithm)Algorithm.ADLER, (short)((short)5000)))).getMessage().contains("Incorrect super block length argument for algorithm"));
        Path noChecksumPath = new File(new StringBuilder(29).append("testInvalidOpenWithNoChecksum").append(Algorithm.NO_CHECKSUM.suffix).toString()).toPath();
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.create((Path)noChecksumPath, (Algorithm)Algorithm.NO_CHECKSUM, (short)((short)10)))).getMessage().contains("Incorrect super block length argument for algorithm"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testOpen(TestArguments.Args args) {
        void openOrCreate_options;
        void openOrCreate_superBlockLength;
        Path path = new File(new StringBuilder(8).append("testOpen").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var4_3 = null;
        ObjectRef cfIO = ObjectRef.create((Object)CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options));
        ((CheckedFileIO)cfIO.elem).write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), (CheckedFileIO)cfIO.elem, args.doValidation());
        ((CheckedFileIO)cfIO.elem).close();
        Files.delete(path);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE};
        short s = args.superBlockLength();
        Algorithm openOrCreate_algo = args.algorithm();
        Object var5_7 = null;
        openOptionArray = null;
        cfIO.elem = CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        ((CheckedFileIO)cfIO.elem).write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), 0L);
        this.verifyFileContent(this.testStr2(), (CheckedFileIO)cfIO.elem, args.doValidation());
        ((CheckedFileIO)cfIO.elem).close();
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ};
        Object var8_8 = null;
        cfIO.elem = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options2);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((CheckedFileIO)cfIO$2.elem).write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1())))).getMessage().contains("Cannot write as file is read-only"));
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((CheckedFileIO)cfIO$2.elem).write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L))).getMessage().contains("Cannot write as file is read-only"));
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((CheckedFileIO)cfIO$2.elem).flush())).getMessage().contains("Cannot flush as file is read-only"));
        ((CheckedFileIO)cfIO.elem).close();
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            OpenOption[] open_options = new OpenOption[]{StandardOpenOption.WRITE};
            CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        })).getMessage().contains("options has WRITE but missing READ"));
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testOpenDirect(TestArguments.Args args) {
        Path path = new File(new StringBuilder(14).append("testOpenDirect").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var4_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()));
        cfIO.close();
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_5 = null;
        cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options2);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)this.testStr1().length());
        this.verifyFileContent(new StringBuilder(0).append(this.testStr1()).append(this.testStr2()).toString(), cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @Test
    public void testInvalidMigrateFile() {
        Algorithm srcAlgo = Algorithm.NO_CHECKSUM;
        short srcSuperBlockLength = 0;
        Path srcPath = new File(new StringBuilder(26).append("testInvalidMigrateFile-src").append(srcAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)srcAlgo, (short)srcSuperBlockLength);
        Algorithm destAlgo = Algorithm.ADLER;
        short destSuperBlockLength = 4096;
        Path destPath = new File(new StringBuilder(27).append("testInvalidMigrateFile-dest").append(destAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath, (Algorithm)destAlgo, (short)destSuperBlockLength);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)destSuperBlockLength))).getMessage().contains("Destination file path is present in migrate"));
        Files.delete(destPath);
        Path destPath2 = new File(new StringBuilder(28).append("testInvalidMigrateFile-dest2").append(destAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath2, (Algorithm)destAlgo, (short)destSuperBlockLength);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.migrateFile((Path)destPath2, (Path)destPath, (short)destSuperBlockLength))).getMessage().contains("Source and destination algorithm are same for migrate"));
        Files.delete(destPath2);
        Files.delete(srcPath);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)4096))).getMessage().contains("Source input file path is not present in migrate"));
    }

    @Test
    public void testMultipleFormatFiles() {
        Algorithm algo1 = Algorithm.NO_CHECKSUM;
        short superBlockLength1 = 0;
        Path path1 = new File(new StringBuilder(23).append("testMultipleFormatFiles").append(algo1.suffix).toString()).toPath();
        Algorithm algo2 = Algorithm.ADLER;
        short superBlockLength2 = 4096;
        Path path2 = new File(new StringBuilder(23).append("testMultipleFormatFiles").append(algo2.suffix).toString()).toPath();
        CheckedFileIO.create((Path)path2, (Algorithm)algo2, (short)superBlockLength2);
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path2, (boolean)false, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        cfIO.close();
        CheckedFileIO.create((Path)path1, (Algorithm)algo1, (short)superBlockLength1);
        Assertions.assertTrue((boolean)((MultiChecksumTypeException)Assertions.assertThrows(MultiChecksumTypeException.class, () -> {
            OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            CheckedFileIO.open((Path)path1, (boolean)false, (OpenOption[])open_options);
        })).getMessage().contains("Both non-checksum file"));
        Assertions.assertTrue((boolean)((MultiChecksumTypeException)Assertions.assertThrows(MultiChecksumTypeException.class, () -> {
            OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            CheckedFileIO.open((Path)path2, (boolean)false, (OpenOption[])open_options);
        })).getMessage().contains("Both non-checksum file"));
        cfIO = CheckedFileIO.open((Path)path1, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()));
        this.verifyFileContent(this.testStr1(), cfIO, false);
        cfIO.close();
        cfIO = CheckedFileIO.open((Path)path2, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        this.verifyFileContent(this.testStr2(), cfIO, true);
        cfIO.close();
        Files.delete(path1);
        Files.delete(path2);
    }

    private void invalidFileChannelOperationsHelper(Algorithm algorithm, short superBlockLength) {
        Path path = new File(new StringBuilder(38).append("testInvalidFileChannelOperationsHelper").append(algorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)algorithm, (short)superBlockLength);
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var10_4 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        IllegalArgumentException ex1 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), -1L));
        if (algorithm.equals(Algorithm.ADLER)) {
            Assertions.assertTrue((boolean)ex1.getMessage().contains("Cannot write as position"));
        }
        IllegalArgumentException ex2 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cfIO.position(-1L));
        Algorithm algorithm2 = algorithm;
        Algorithm algorithm3 = Algorithm.ADLER;
        if (!(algorithm2 != null ? !algorithm2.equals(algorithm3) : algorithm3 != null)) {
            Assertions.assertTrue((boolean)ex2.getMessage().contains("Cannot set as position"));
        }
        IllegalArgumentException ex3 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cfIO.truncate(-1L));
        Algorithm algorithm4 = algorithm;
        Algorithm algorithm5 = Algorithm.ADLER;
        if (!(algorithm4 != null ? !algorithm4.equals(algorithm5) : algorithm5 != null)) {
            Assertions.assertTrue((boolean)ex3.getMessage().contains("Cannot truncate as size"));
        }
        Files.delete(path);
    }

    @Test
    public void testInvalidFileChannelOperations() {
        this.invalidFileChannelOperationsHelper(Algorithm.ADLER, (short)500);
        this.invalidFileChannelOperationsHelper(Algorithm.ADLER, (short)4096);
        this.invalidFileChannelOperationsHelper(Algorithm.NO_CHECKSUM, (short)0);
    }

    @Test
    public void testToAlgorithm() {
        Assertions.assertEquals((Object)Algorithm.ADLER, (Object)Algorithm.toAlgorithm((String)".adler"));
        Assertions.assertEquals((Object)Algorithm.NO_CHECKSUM, (Object)Algorithm.toAlgorithm((String)""));
        Assertions.assertEquals(null, (Object)Algorithm.toAlgorithm((String)"random"));
        Assertions.assertEquals(null, (Object)Algorithm.toAlgorithm((Byte)Predef$.MODULE$.byte2Byte((byte)0)));
        Assertions.assertEquals((Object)Algorithm.ADLER, (Object)Algorithm.toAlgorithm((Byte)Predef$.MODULE$.byte2Byte((byte)1)));
        Assertions.assertEquals((Object)Algorithm.NO_CHECKSUM, (Object)Algorithm.toAlgorithm((Byte)Predef$.MODULE$.byte2Byte((byte)2)));
    }

    private void verifyFileContent(String expected, CheckedFileIO fileIO, boolean doValidation) {
        Assertions.assertTrue((boolean)fileIO.validate());
        if (doValidation) {
            Assertions.assertEquals((long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expected), (Long)((Long)fileIO.checksum().get()));
        }
        Assertions.assertEquals((long)expected.length(), (long)fileIO.size());
        ByteBuffer bb = ByteBuffer.allocate(expected.length()).order(ByteOrder.LITTLE_ENDIAN);
        fileIO.read(bb, 0L);
        Assertions.assertEquals((Object)bb, (Object)CheckedFileIOTestUtils$.MODULE$.toByteBuffer(expected).flip());
    }

    private void verifyHeader(Path path, String expected, short superBlockLength, boolean doValidation) {
        if (!doValidation) {
            return;
        }
        RandomAccessFile inp = new RandomAccessFile(((Object)path).toString(), "r");
        FileChannel fc = inp.getChannel();
        ByteBuffer bb = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        Utils.readFully((FileChannel)fc, (ByteBuffer)bb, (long)0L);
        Assertions.assertFalse((boolean)bb.hasRemaining());
        bb.flip();
        Assertions.assertEquals((short)superBlockLength, (short)bb.getShort());
        Assertions.assertEquals((int)this.expectedHeaderSize(), (int)bb.getShort());
        bb = ByteBuffer.allocate(this.expectedHeaderSize()).order(ByteOrder.LITTLE_ENDIAN);
        Utils.readFully((FileChannel)fc, (ByteBuffer)bb, (long)4L);
        Assertions.assertFalse((boolean)bb.hasRemaining());
        bb.flip();
        inp.close();
        CheckedFileIOHeader header = CheckedFileIOHeader.getRootAsCheckedFileIOHeader((ByteBuffer)bb);
        Assertions.assertEquals((int)1, (int)header.version());
        Assertions.assertEquals((long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expected), (long)header.checksum());
        Assertions.assertEquals((long)expected.length(), (long)header.endPosition());
    }

    private String zeros(int n) {
        byte[] ar = new byte[n];
        Arrays.fill(ar, (byte)0);
        ByteBuffer bb = ByteBuffer.wrap(ar).order(ByteOrder.LITTLE_ENDIAN);
        return new String(bb.array(), "ASCII");
    }

    private static final ByteBuffer toInterleavedByteBuffer$1(String s) {
        ByteBuffer bb = ByteBuffer.allocate(1000);
        String randomStr = "123";
        bb.put(randomStr.getBytes());
        bb.put(s.getBytes());
        bb.position(3);
        bb.limit(3 + s.length());
        return bb;
    }

    public static final /* synthetic */ void $anonfun$testMigrateFromNonChecksumToAdler$1(CheckedFileIOTest $this, String str) {
        Algorithm srcAlgo = Algorithm.NO_CHECKSUM;
        short srcSuperBlockLength = 0;
        Path srcPath = new File(new StringBuilder(37).append("testMigrateFromNonChecksumToAdler-src").append(srcAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)srcAlgo, (short)srcSuperBlockLength);
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var10_5 = null;
        CheckedFileIO srcIO = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Algorithm destAlgo = Algorithm.ADLER;
        short destSuperBlockLength = 4096;
        Path destPath = new File(new StringBuilder(38).append("testMigrateFromNonChecksumToAdler-dest").append(destAlgo.suffix).toString()).toPath();
        srcIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str));
        srcIO.close();
        CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)destSuperBlockLength);
        Assertions.assertFalse((boolean)Files.exists(srcPath, new LinkOption[0]));
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var11_10 = null;
        CheckedFileIO destIO = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        $this.verifyFileContent(str, destIO, false);
        destIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer($this.testStr1()), (long)str.length());
        $this.verifyFileContent(new StringBuilder(0).append(str).append($this.testStr1()).toString(), destIO, false);
        destIO.close();
        Files.delete(destPath);
    }

    public static final /* synthetic */ void $anonfun$testMigrateFromAdlerToNonChecksum$1(CheckedFileIOTest $this, String str) {
        Algorithm srcAlgo = Algorithm.ADLER;
        short srcSuperBlockLength = 4096;
        Path srcPath = new File(new StringBuilder(37).append("testMigrateFromAdlerToNonChecksum-src").append(srcAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)srcAlgo, (short)srcSuperBlockLength);
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var10_5 = null;
        CheckedFileIO srcIO = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Algorithm destAlgo = Algorithm.NO_CHECKSUM;
        short destSuperBlockLength = 0;
        Path destPath = new File(new StringBuilder(38).append("testMigrateFromAdlerToNonChecksum-dest").append(destAlgo.suffix).toString()).toPath();
        srcIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str));
        srcIO.close();
        CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)destSuperBlockLength);
        Assertions.assertFalse((boolean)Files.exists(srcPath, new LinkOption[0]));
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var11_10 = null;
        CheckedFileIO destIO = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        $this.verifyFileContent(str, destIO, false);
        destIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer($this.testStr1()), destIO.size());
        $this.verifyFileContent(new StringBuilder(0).append(str).append($this.testStr1()).toString(), destIO, false);
        destIO.close();
        Files.delete(destPath);
    }

    public CheckedFileIOTest() {
        this.testStr1 = "str1ng1";
        this.testStr2 = "str2ng22";
        this.testStr3 = "str3ng333";
        this.testHeader().finish(this.testHeaderId());
        this.expectedHeaderSize = this.testHeader().dataBuffer().remaining();
    }
}

