/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Supplier;
import kafka.log.LocalLog$;
import kafka.server.Defaults$;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.exceptions.TierMetadataDeserializationException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.tier.topic.TierTopicPartitioner;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tmc\u0001B\u001a5\u0001mBQA\u0011\u0001\u0005\u0002\r+AA\u0012\u0001\u0001\u000f\u0016!1\u000b\u0001\u0001U\u0011\u001d9\u0006A1A\u0005\naCa!\u0019\u0001!\u0002\u0013I\u0006b\u00022\u0001\u0005\u0004%Ia\u0019\u0005\u0007U\u0002\u0001\u000b\u0011\u00023\t\u000f-\u0004!\u0019!C\u00051\"1A\u000e\u0001Q\u0001\neCq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004v\u0001\u0001\u0006Ia\u001c\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u0011\u0019Y\b\u0001)A\u0005q\"9A\u0010\u0001b\u0001\n\u0013i\bbBA\u0002\u0001\u0001\u0006IA \u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"a\u0004\u0001A\u0003%\u0011\u0011\u0002\u0005\t\u0003#\u0001!\u0019!C\u00051\"9\u00111\u0003\u0001!\u0002\u0013I\u0006\"CA\u000b\u0001\t\u0007I\u0011BA\f\u0011!\t)\u0004\u0001Q\u0001\n\u0005e\u0001\"CA\u001c\u0001\t\u0007I\u0011BA\u001d\u0011!\t\t\u0005\u0001Q\u0001\n\u0005m\u0002\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005\u001d\u0003\"CA+\u0001\t\u0007I\u0011BA,\u0011\u001d\tI\u0006\u0001Q\u0001\nQC\u0011\"a\u0017\u0001\u0005\u0004%I!!\u0018\t\u000f\u0005}\u0003\u0001)A\u0005\u000f\"I\u0011\u0011\r\u0001C\u0002\u0013%\u0011Q\f\u0005\b\u0003G\u0002\u0001\u0015!\u0003H\u0011%\t)\u0007\u0001b\u0001\n\u0013\ti\u0006C\u0004\u0002h\u0001\u0001\u000b\u0011B$\t\u0013\u0005%\u0004A1A\u0005\n\u0005-\u0004\u0002CA;\u0001\u0001\u0006I!!\u001c\t\u0013\u0005]\u0004A1A\u0005\n\u0005e\u0004\u0002CAC\u0001\u0001\u0006I!a\u001f\t\u0013\u0005\u001d\u0005A1A\u0005\n\u0005%\u0005\u0002CAI\u0001\u0001\u0006I!a#\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0005bBA_\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003\u000f\u0004A\u0011AAK\u0011\u001d\tY\r\u0001C\u0001\u0003+Cq!a4\u0001\t\u0003\t)\nC\u0004\u0002T\u0002!\t!!&\t\u000f\u0005]\u0007\u0001\"\u0001\u0002\u0016\"9\u00111\u001c\u0001\u0005\u0002\u0005u\u0007b\u0002B\u0007\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0005U!\u0016.\u001a:U_BL7mQ8ogVlWM\u001d+fgRT!!\u000e\u001c\u0002\u000bQ|\u0007/[2\u000b\u0005]B\u0014\u0001\u0002;jKJT\u0011!O\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\b\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0003\"!\u0012\u0001\u000e\u0003Q\u0012\u0001cQ8ogVlWM]*vaBd\u0017.\u001a:\u0011\t![U*T\u0007\u0002\u0013*\u0011!JN\u0001\u0007G2LWM\u001c;\n\u00051K%\u0001F'pG.\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'\u000fE\u0002>\u001dBK!a\u0014 \u0003\u000b\u0005\u0013(/Y=\u0011\u0005u\n\u0016B\u0001*?\u0005\u0011\u0011\u0015\u0010^3\u0003!A\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0003\u0002%V\u001b6K!AV%\u0003)5{7m\u001b)s_\u0012,8-\u001a:TkB\u0004H.[3s\u0003%\u0019G.^:uKJLE-F\u0001Z!\tQv,D\u0001\\\u0015\taV,\u0001\u0003mC:<'\"\u00010\u0002\t)\fg/Y\u0005\u0003An\u0013aa\u0015;sS:<\u0017AC2mkN$XM]%eA\u00059A/Z7q\t&\u0014X#\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dl\u0016AA5p\u0013\tIgM\u0001\u0003GS2,\u0017\u0001\u0003;f[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\u0001\\8h\t&\u00148/F\u0001p!\r\u00018/W\u0007\u0002c*\u0011!/X\u0001\u0005kRLG.\u0003\u0002uc\nI\u0011I\u001d:bs2K7\u000f^\u0001\tY><G)\u001b:tA\u00051B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7/F\u0001y!\ti\u00140\u0003\u0002{}\t)1\u000b[8si\u00069B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0015i&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u001a:\u0016\u0003y\u0004\"!R@\n\u0007\u0005\u0005AG\u0001\u000bUS\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tWM]\u0001\u0016i&,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u001a:!\u0003Y!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<WCAA\u0005!\r)\u00151B\u0005\u0004\u0003\u001b!$A\u0006+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002/QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e\u0004\u0013!\u0004;jKJ$v\u000e]5d\u001d\u0006lW-\u0001\buS\u0016\u0014Hk\u001c9jG:\u000bW.\u001a\u0011\u0002'QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005e\u0001#\u00029\u0002\u001c\u0005}\u0011bAA\u000fc\n\u00191+\u001a;\u0011\t\u0005\u0005\u0012\u0011G\u0007\u0003\u0003GQA!!\n\u0002(\u000511m\\7n_:T1!OA\u0015\u0015\u0011\tY#!\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ty#A\u0002pe\u001eLA!a\r\u0002$\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0006;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0005uS\u0016\u0014Hk\u001c9jGV\u0011\u00111\b\t\u0004\u000b\u0006u\u0012bAA i\t!\u0012J\\5uS\u0006d\u0017N_3e)&,'\u000fV8qS\u000e\f!\u0002^5feR{\u0007/[2!\u0003A!\u0018.\u001a:Ti\u0006$XMR3uG\",'/\u0006\u0002\u0002HA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002NY\nqAZ3uG\",'/\u0003\u0003\u0002R\u0005-#\u0001\u0005+jKJ\u001cF/\u0019;f\r\u0016$8\r[3s\u0003E!\u0018.\u001a:Ti\u0006$XMR3uG\",'\u000fI\u0001\u0011aJ|G-^2feN+\b\u000f\u001d7jKJ,\u0012\u0001V\u0001\u0012aJ|G-^2feN+\b\u000f\u001d7jKJ\u0004\u0013a\u00069sS6\f'/_\"p]N,X.\u001a:TkB\u0004H.[3s+\u00059\u0015\u0001\u00079sS6\f'/_\"p]N,X.\u001a:TkB\u0004H.[3sA\u000592-\u0019;dQV\u00048i\u001c8tk6,'oU;qa2LWM]\u0001\u0019G\u0006$8\r[;q\u0007>t7/^7feN+\b\u000f\u001d7jKJ\u0004\u0013\u0001\u00073jg\u000e|g/\u001a:D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0006IB-[:d_Z,'oQ8ogVlWM]*vaBd\u0017.\u001a:!\u0003e!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8n[&$H/\u001a:\u0016\u0005\u00055\u0004\u0003BA8\u0003cj\u0011AN\u0005\u0004\u0003g2$!\u0007+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>lW.\u001b;uKJ\f!\u0004^5feR{\u0007/[2NC:\fw-\u001a:D_6l\u0017\u000e\u001e;fe\u0002\nq!\\3ue&\u001c7/\u0006\u0002\u0002|A!\u0011QPAA\u001b\t\tyH\u0003\u0003\u0002x\u0005\r\u0012\u0002BAB\u0003\u007f\u0012q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003E!\u0018.\u001a:U_BL7mQ8ogVlWM]\u000b\u0003\u0003\u0017\u00032!RAG\u0013\r\ty\t\u000e\u0002\u0012)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\u0018A\u0005;jKJ$v\u000e]5d\u0007>t7/^7fe\u0002\nQa]3ukB$\"!a&\u0011\u0007u\nI*C\u0002\u0002\u001cz\u0012A!\u00168ji\"\u001a\u0001&a(\u0011\t\u0005\u0005\u0016qV\u0007\u0003\u0003GSA!!*\u0002(\u0006\u0019\u0011\r]5\u000b\t\u0005%\u00161V\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\ti+!\f\u0002\u000b),h.\u001b;\n\t\u0005E\u00161\u0015\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017AD2mK\u0006tW\u000f]'pG.LGo\u001c\u0015\u0004S\u0005]\u0006\u0003BAQ\u0003sKA!a/\u0002$\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0012i\u0016\u001cH\u000fU8mY\u0012+(/\u0019;j_:\u001c\bf\u0001\u0016\u0002BB!\u0011\u0011UAb\u0013\u0011\t)-a)\u0003\tQ+7\u000f^\u0001\u0017i\u0016\u001cHOU3hSN$XM\u001d)beRLG/[8og\"\u001a1&!1\u0002?Q,7\u000f\u001e#va2L7-\u0019;f%\u0016<\u0017n\u001d;feB\u000b'\u000f^5uS>t7\u000fK\u0002-\u0003\u0003\fa\u0007^3tiB\u0013\u0018.\\1ss\u000e{gn];nKJ\u001cV-Z6t)>d\u0015m\u001d;D_6l\u0017\u000e\u001e;fI>3gm]3u\u001f:\u001cF/\u0019:ukBD3!LAa\u0003Y!Xm\u001d;NCR,'/[1mSj\fG/[8o\u0019\u0006<\u0007f\u0001\u0018\u0002B\u0006\u0019B/Z:u\u0007\u0006$8\r[;q\u0007>l\u0007\u000f\\3uK\"\u001aq&!1\u0002+Q,7\u000f^'bq6\u000bG/\u001a:jC2L'0\u001a'bOR!\u0011qSAp\u0011\u001d\t\t\u000f\ra\u0001\u0003G\fqb\u00195fG.\u001cX/\\#oC\ndW\r\u001a\t\u0004{\u0005\u0015\u0018bAAt}\t9!i\\8mK\u0006t\u0007f\u0002\u0019\u0002l\u0006m\u0018Q \t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BA{\u0003O\u000ba\u0001]1sC6\u001c\u0018\u0002BA}\u0003_\u00141BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0002\u0000\n\u0005\u0011$A\u0001\u001a\u0003\u0001A3\u0001\rB\u0003!\u0011\u00119A!\u0003\u000e\u0005\u0005M\u0018\u0002\u0002B\u0006\u0003g\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003M!Xm\u001d;HCJ\u0014\u0017mZ3IC:$G.\u001b8hQ\r\t\u0014\u0011Y\u0001\tO\u0016$8\u000b^1uKRq!Q\u0003B\u0011\u0005W\u0011iCa\u000e\u0003J\t-\u0003\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tma'A\u0003ti\u0006$X-\u0003\u0003\u0003 \te!A\u0006$jY\u0016$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000f\t\r\"\u00071\u0001\u0003&\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003_\u00129#C\u0002\u0003*Y\u0012\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000f\u0005\u001d%\u00071\u0001\u0002\f\"9!q\u0006\u001aA\u0002\tE\u0012!C2uqN#\u0018\r^;t!\u0011\u00119Ba\r\n\t\tU\"\u0011\u0004\u0002\u0014)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xo\u001d\u0005\b\u0005s\u0011\u0004\u0019\u0001B\u001e\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0003>\t\u0015SB\u0001B \u0015\r\u0011(\u0011\t\u0006\u0005\u0005\u0007\n9#\u0001\u0004tKJ4XM]\u0005\u0005\u0005\u000f\u0012yDA\u0005TG\",G-\u001e7fe\"9\u0011\u0011\u001d\u001aA\u0002\u0005\r\bb\u0002B'e\u0001\u0007!qJ\u0001\u0005i&lW\r\u0005\u0003\u0003R\t]SB\u0001B*\u0015\u0011\u0011)&a\t\u0002\u000bU$\u0018\u000e\\:\n\t\te#1\u000b\u0002\u0005)&lW\r")
public class TierTopicConsumerTest {
    private final String clusterId;
    private final File tempDir = TestUtils.tempDirectory(null, null);
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final short tierTopicNumPartitions = (short)10;
    private final TierTopicPartitioner kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner = new TierTopicPartitioner((int)this.tierTopicNumPartitions());
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()));
    private final String kafka$tier$topic$TierTopicConsumerTest$$tierTopicName = TierTopic.topicName((String)"");
    private final java.util.Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (int)this.tierTopicNumPartitions());
    private final InitializedTierTopic tierTopic = (InitializedTierTopic)Mockito.mock(InitializedTierTopic.class);
    private final TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> discoverConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("discover", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final TierTopicManagerCommitter tierTopicManagerCommitter = (TierTopicManagerCommitter)Mockito.mock(TierTopicManagerCommitter.class);
    private final Metrics metrics = new Metrics();
    private final TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(this.tierTopicManagerConfig(), this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), this.discoverConsumerSupplier(), this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.of(this.metrics()), (Time)new MockTime());

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public TierTopicPartitioner kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner() {
        return this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public String kafka$tier$topic$TierTopicConsumerTest$$tierTopicName() {
        return this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName;
    }

    private java.util.Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private InitializedTierTopic tierTopic() {
        return this.tierTopic;
    }

    private TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> discoverConsumerSupplier() {
        return this.discoverConsumerSupplier;
    }

    private TierTopicManagerCommitter tierTopicManagerCommitter() {
        return this.tierTopicManagerCommitter;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.tierTopic().numPartitions()).thenReturn((Object)OptionalInt.of(this.tierTopicNumPartitions()));
        Mockito.when((Object)this.tierTopic().topicName()).thenReturn((Object)this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName());
        Mockito.when((Object)this.tierTopic().toTierTopicPartition((TopicIdPartition)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<TopicPartition>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public TopicPartition answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartition((TopicIdPartition)((TopicIdPartition)invocation.getArgument(0)), (String)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (TierTopicPartitioner)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.tierTopic().toTierTopicPartitions((Collection)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<java.util.Set<TopicPartition>>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public java.util.Set<TopicPartition> answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartitions((Collection)((Collection)invocation.getArgument(0)), (String)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (TierTopicPartitioner)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn(null);
    }

    @AfterEach
    public void cleanupMockito() {
        Mockito.framework().clearInlineMocks();
    }

    @Test
    public void testPollDurations() {
        Consumer primary = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)primary.poll(Duration.ofMillis(0L))).thenReturn((Object)new ConsumerRecords(new HashMap()));
        TierTopicConsumer tierTopicConsumerWithMock = new TierTopicConsumer(this.tierTopicManagerConfig(), (Supplier)new Supplier<Consumer<byte[], byte[]>>(null, primary){
            private final Consumer primary$1;

            public Consumer<byte[], byte[]> get() {
                return this.primary$1;
            }
            {
                this.primary$1 = primary$1;
            }
        }, this.catchupConsumerSupplier(), this.discoverConsumerSupplier(), this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.empty(), (Time)new MockTime());
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        tierTopicConsumerWithMock.register(tp_1, ctx_1);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.INIT);
        tierTopicConsumerWithMock.register(tp_2, ctx_2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.immigratingPartitions().keySet()).asScala());
        tierTopicConsumerWithMock.initialize(this.tierTopic());
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.atLeastOnce())).assign((Collection)ArgumentMatchers.any());
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.atLeastOnce())).seekToBeginning((Collection)ArgumentMatchers.any());
        ((Consumer)Mockito.verify((Object)primary)).poll(Duration.ofMillis(0L));
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        tierTopicConsumerWithMock.doWork();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)2))).poll(Duration.ofMillis(5L));
    }

    @Test
    public void testRegisterPartitions() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_3 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_3.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TopicIdPartition tp_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_4 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_4.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        TopicIdPartition tp_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_5 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_5.status()).thenReturn((Object)TierPartitionStatus.ERROR);
        TopicIdPartition tp_6 = new TopicIdPartition("foo-6", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_6 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_6.status()).thenReturn((Object)TierPartitionStatus.FROZEN_LOG_START_OFFSET);
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().register(tp_3, ctx_3);
        this.tierTopicConsumer().register(tp_4, ctx_4);
        this.tierTopicConsumer().register(tp_5, ctx_5);
        this.tierTopicConsumer().register(tp_6, ctx_6);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2, tp_3, tp_4, tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)0, (int)this.tierTopicConsumer().primaryConsumerErrorPartitions().size());
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3, tp_4, tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)0, (int)this.tierTopicConsumer().primaryConsumerErrorPartitions().size());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_3, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_4, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_5, (VerificationMode)Mockito.times((int)0))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_6, (VerificationMode)Mockito.times((int)0))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)3))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)3))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_3, (VerificationMode)Mockito.times((int)4))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_4, (VerificationMode)Mockito.times((int)4))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_5, (VerificationMode)Mockito.times((int)5))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_6, (VerificationMode)Mockito.times((int)5))).status();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_3});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_4});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_5});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_6});
        Assertions.assertEquals((Object)this.tierTopic().toTierTopicPartitions((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3, tp_4, tp_5, tp_6}))).asJava()), (Object)this.catchupConsumerSupplier().consumers().get(0).assignment());
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)this.primaryConsumerSupplier().consumers().get(0).assignment());
    }

    @Test
    public void testDuplicateRegisterPartitions() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.id()).thenReturn((Object)"TierTopicConsumerTest.ctx-1");
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.id()).thenReturn((Object)"TierTopicConsumerTest.ctx-2");
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        TopicIdPartition tp_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_3 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_3.id()).thenReturn((Object)"TierTopicConsumerTest.ctx-3");
        Mockito.when((Object)ctx_3.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TierTopicConsumer.ClientCtx ctx_new = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_new.id()).thenReturn((Object)"TierTopicConsumerTest.ctx-new");
        Mockito.when((Object)ctx_new.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        Assertions.assertTrue((boolean)this.tierTopicConsumer().isPartitionRegistered(tp_1));
        Assertions.assertTrue((boolean)this.tierTopicConsumer().isPartitionRegistered(tp_2));
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_3, ctx_3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().register(tp_3, ctx_3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.tierTopicConsumer().register(tp_1, ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.tierTopicConsumer().register(tp_2, ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.tierTopicConsumer().register(tp_3, ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
    }

    @Test
    public void testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup() {
        scala.collection.mutable.Set committedOffsetMap = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().map((Function1 & Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch((long)tierTopicPartition.partition() + 100L, Optional.of(Predef$.MODULE$.int2Integer(3)))));
        committedOffsetMap.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
                OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
                return Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            }
            throw new MatchError(null);
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        Assertions.assertNotNull((Object)this.tierTopicConsumer().tierTopic());
        Consumer<byte[], byte[]> primaryConsumer = this.primaryConsumerSupplier().consumers().get(0);
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)primaryConsumer.assignment());
        committedOffsetMap.foreach((Function1 & Serializable)x0$2 -> {
            TierTopicConsumerTest.$anonfun$testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup$3(primaryConsumer, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMaterializationLag() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.fromString("26081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.INIT);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)ctx_1.materializationLag())).thenReturn((Object)BoxesRunTime.boxToLong((long)30L));
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.fromString("36081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)ctx_2.materializationLag())).thenReturn((Object)BoxesRunTime.boxToLong((long)50L));
        ((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().map((Function1 & Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)))))).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
                OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
                return Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            }
            throw new MatchError(null);
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.metrics().metric(this.tierTopicConsumer().maxTierLagMetricName).metricValue());
    }

    @Test
    public void testCatchupComplete() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.fromString("26081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.fromString("36081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        ((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicPartitions()).asScala().map((Function1 & Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)))))).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
                OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
                return Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            }
            throw new MatchError(null);
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Consumer<byte[], byte[]> catchupConsumer = this.catchupConsumerSupplier().consumers().get(0);
        scala.collection.mutable.Set assignment = CollectionConverters$.MODULE$.SetHasAsScala(catchupConsumer.assignment()).asScala();
        Assertions.assertEquals((int)2, (int)assignment.size());
        assignment.foreach((Function1 & Serializable)assignedPartition -> {
            catchupConsumer.seek(assignedPartition, 50L);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)0))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)0))).completeCatchup();
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        catchupConsumer.seek((TopicPartition)assignment.last(), 150L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)1))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)1))).completeCatchup();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMaxMaterializeLag(boolean checksumEnabled) {
        kafka.utils.MockTime time = new kafka.utils.MockTime();
        TopicIdPartition tp_1 = new TopicIdPartition("lag_test", UUID.randomUUID(), 0);
        FileTierPartitionState state_1 = this.getState(tp_1, this.tierTopicConsumer(), TierPartitionStatus.ONLINE, (Scheduler)time.scheduler(), checksumEnabled, (Time)time);
        TopicIdPartition tp_2 = new TopicIdPartition("lag_test2", UUID.randomUUID(), 0);
        FileTierPartitionState state_2 = this.getState(tp_2, this.tierTopicConsumer(), TierPartitionStatus.CATCHUP, (Scheduler)time.scheduler(), checksumEnabled, (Time)time);
        TopicIdPartition tp_3 = new TopicIdPartition("lag_test3", UUID.randomUUID(), 0);
        FileTierPartitionState state_3 = this.getState(tp_3, this.tierTopicConsumer(), TierPartitionStatus.ONLINE, (Scheduler)time.scheduler(), checksumEnabled, (Time)time);
        TopicIdPartition tp_4 = new TopicIdPartition("lag_test4", UUID.randomUUID(), 0);
        FileTierPartitionState state_4 = this.getState(tp_4, this.tierTopicConsumer(), TierPartitionStatus.CATCHUP, (Scheduler)time.scheduler(), checksumEnabled, (Time)time);
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((long)0L, (long)this.tierTopicConsumer().maxMaterializationLag());
        state_1.materializeUptoOffset(100L);
        state_2.materializeUptoOffset(101L);
        state_3.materializeUptoOffset(102L);
        state_4.materializeUptoOffset(103L);
        Assertions.assertEquals((long)103L, (long)this.tierTopicConsumer().maxMaterializationLag());
        state_1.close();
        state_2.close();
        state_3.close();
        state_4.close();
    }

    @Test
    public void testGarbageHandling() {
        ConsumerRecord garbageRecord = new ConsumerRecord("foo-1", 0, 1L, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> AbstractTierMetadata.deserialize((byte[])((byte[])garbageRecord.key()), (byte[])((byte[])garbageRecord.value()), (long)garbageRecord.timestamp()), ClassTag$.MODULE$.apply(TierMetadataDeserializationException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
    }

    private FileTierPartitionState getState(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer, TierPartitionStatus ctxStatus, Scheduler scheduler, boolean checksumEnabled, Time time) {
        TopicPartition logDirName_topicPartition = topicIdPartition.topicPartition();
        Object var10_7 = null;
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, new LogDirFailureChannel(5), topicIdPartition.topicPartition(), true, scheduler, checksumEnabled, false, time, TierPartitionStateCleanupConfig.EMPTY, false, -1);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        TierTopicConsumer.ClientCtx clientCtx = new TierTopicConsumer.ClientCtx(null, topicIdPartition, tierPartitionState, ctxStatus){
            private final TopicIdPartition topicIdPartition$1;
            private final FileTierPartitionState tierPartitionState$1;
            private final TierPartitionStatus ctxStatus$1;

            public String id() {
                return new StringBuilder(22).append("TierTopicConsumerTest.").append(this.topicIdPartition$1.toString()).toString();
            }

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.ctxStatus$1;
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus status, OffsetAndEpoch offsetAndEpoch, Optional<ByteBuffer> buffer) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, buffer, status, offsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processSnapshotMaterializationEvent(TierMetadataSnapshotUploadComplete metadata, ByteBuffer snapshotBuffer, TierPartitionStatus targetStatus, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.processSnapshotMaterializationEvent(metadata, snapshotBuffer, targetStatus, offsetAndEpoch);
            }

            public long localMaterializedOffset() {
                return this.tierPartitionState$1.lastLocalMaterializedSrcOffsetAndEpoch().offset();
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }

            public void beginDiscover() {
                this.tierPartitionState$1.beginDiscover();
            }

            public void completeDiscover() {
                this.tierPartitionState$1.onDiscoverComplete();
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$1 = tierPartitionState$1;
                this.ctxStatus$1 = ctxStatus$1;
            }
        };
        tierTopicConsumer.register(topicIdPartition, clientCtx);
        return tierPartitionState;
    }

    public static final /* synthetic */ void $anonfun$testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup$3(Consumer primaryConsumer$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition tierTopicPartition = (TopicPartition)x0$2._1();
            Assertions.assertEquals((long)((OffsetAndEpoch)x0$2._2()).offset(), (long)primaryConsumer$1.position(tierTopicPartition));
            return;
        }
        throw new MatchError(null);
    }

    public TierTopicConsumerTest() {
        this.clusterId = "mycluster";
    }
}

