/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierRecordType;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierMessageFormatter;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierMessageFormatterTest {
    private TierMessageFormatter formatter = new TierMessageFormatter();

    @Test
    public void formatTierTopicInitLeaderTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID messageId = UUID.randomUUID();
        TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, 1, messageId, 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", topicIdPartition.partition(), 0L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)initLeader.serializeKey(), (Object)initLeader.serializeValue(), (Headers)new RecordHeaders(), Optional.of(0));
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %d, %s): %s\n", topicIdPartition.partition(), 0, record.offset(), Instant.ofEpochMilli(record.timestamp()), initLeader.toString());
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatTierTopicInitLeaderWithPartitionCreationOffsetAndEpochTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID messageId = UUID.randomUUID();
        TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, 1, messageId, 0, Optional.of(new OffsetAndEpoch(100L, 1)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", topicIdPartition.partition(), 0L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)initLeader.serializeKey(), (Object)initLeader.serializeValue(), (Headers)new RecordHeaders(), Optional.of(0));
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %d, %s): %s\n", topicIdPartition.partition(), 0, record.offset(), Instant.ofEpochMilli(record.timestamp()), initLeader.toString());
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatTierPartitionDeleteInitiateTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID messageId = UUID.randomUUID();
        TierPartitionDeleteInitiate partDeleteInit = new TierPartitionDeleteInitiate(topicIdPartition, 1, messageId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", topicIdPartition.partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)partDeleteInit.serializeKey(), (Object)partDeleteInit.serializeValue(), (Headers)new RecordHeaders(), Optional.of(1));
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %d, %s): %s\n", topicIdPartition.partition(), 1, record.offset(), Instant.ofEpochMilli(record.timestamp()), partDeleteInit.toString());
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatTierPartitionForceRestoreTest() {
        UUID topicId = UUID.fromString("4da3c386-128c-48f3-bd2a-8c0e4ddc81c4");
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID messageId = UUID.fromString("71ad0b74-d8a3-487a-baf6-bb152d8f70d3");
        TierPartitionForceRestore partitionRestore = new TierPartitionForceRestore(topicIdPartition, messageId, 1L, 100L, new kafka.tier.state.OffsetAndEpoch(300L, Optional.of(30)), "contenthash", Boolean.valueOf(false), Algorithm.ADLER.id.byteValue());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", topicIdPartition.partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)partitionRestore.serializeKey(), (Object)partitionRestore.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %d, %s): %s\n", topicIdPartition.partition(), -1, record.offset(), Instant.ofEpochMilli(record.timestamp()), partitionRestore.toString());
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
        Assertions.assertEquals((Object)"TierPartitionForceRestore(version=1, topicIdPartition=TaPDhhKMSPO9KowOTdyBxA:foo-0, messageIdAsBase64=ca0LdNijSHq69rsVLY9w0w, startOffset=1, endOffset=100, stateOffsetAndEpoch=OffsetAndEpoch(offset=300, epoch=Optional[30]), contentHash=contenthash, restoreLogStartOffset=false, checksumAlgorithm=ADLER)", (Object)partitionRestore.toString());
    }

    @Test
    public void formatTierSegmentDeleteTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        TierSegmentDeleteInitiate segDeleteInit = new TierSegmentDeleteInitiate(topicIdPartition, 1, UUID.randomUUID(), new kafka.tier.state.OffsetAndEpoch(300L, Optional.of(30)));
        TierSegmentDeleteComplete segDeleteComplete = new TierSegmentDeleteComplete(topicIdPartition, 1, UUID.randomUUID(), new kafka.tier.state.OffsetAndEpoch(300L, Optional.of(30)), 600L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord initRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)segDeleteInit.serializeKey(), (Object)segDeleteInit.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter.writeTo(initRecord, ps);
        ConsumerRecord completeRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 2L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)segDeleteComplete.serializeKey(), (Object)segDeleteComplete.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter.writeTo(completeRecord, ps);
        String expected = String.format("(%d, %d, %d, %s): %s\n(%d, %d, %d, %s): %s\n", topicIdPartition.partition(), -1, initRecord.offset(), Instant.ofEpochMilli(initRecord.timestamp()), segDeleteInit.toString(), topicIdPartition.partition(), -1, completeRecord.offset(), Instant.ofEpochMilli(completeRecord.timestamp()), segDeleteComplete.toString());
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatTierSegmentUploadTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        TierSegmentUploadInitiate segUploadInit = new TierSegmentUploadInitiate(topicIdPartition, 1, UUID.randomUUID(), 0L, 0L, 0L, 0L, 100, false, false, false, TierUploadType.Archive, new kafka.tier.state.OffsetAndEpoch(300L, Optional.empty()), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete segUploadComplete = new TierSegmentUploadComplete(topicIdPartition, 1, UUID.randomUUID(), new kafka.tier.state.OffsetAndEpoch(400L, Optional.of(3)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord initRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)segUploadInit.serializeKey(), (Object)segUploadInit.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter.writeTo(initRecord, ps);
        ConsumerRecord completeRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 2L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)segUploadComplete.serializeKey(), (Object)segUploadComplete.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter.writeTo(completeRecord, ps);
        String expected = String.format("(%d, %d, %d, %s): %s\n(%d, %d, %d, %s): %s\n", topicIdPartition.partition(), -1, initRecord.offset(), Instant.ofEpochMilli(initRecord.timestamp()), segUploadInit.toString(), topicIdPartition.partition(), -1, completeRecord.offset(), Instant.ofEpochMilli(completeRecord.timestamp()), segUploadComplete.toString());
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatTierPartitionStateSnapshotUploadTest() {
        UUID topicId = UUID.randomUUID();
        UUID snapshotId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(topicIdPartition, 1, snapshotId, new kafka.tier.state.OffsetAndEpoch(300L, Optional.empty()), 5);
        TierMetadataSnapshotUploadComplete snapshotComplete = new TierMetadataSnapshotUploadComplete(topicIdPartition, 1, snapshotId, new kafka.tier.state.OffsetAndEpoch(400L, Optional.of(3)), new kafka.tier.state.OffsetAndEpoch(401L, Optional.of(3)), 123L, Algorithm.ADLER.id.byteValue());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord initRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)snapshotInitiate.serializeKey(), (Object)snapshotInitiate.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter.writeTo(initRecord, ps);
        ConsumerRecord completeRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 2L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)snapshotComplete.serializeKey(), (Object)snapshotComplete.serializeValue(), (Headers)new RecordHeaders(), Optional.of(0));
        this.formatter.writeTo(completeRecord, ps);
        String expected = String.format("(%d, %d, %d, %s): %s\n(%d, %d, %d, %s): %s\n", topicIdPartition.partition(), -1, initRecord.offset(), Instant.ofEpochMilli(initRecord.timestamp()), snapshotInitiate, topicIdPartition.partition(), 0, completeRecord.offset(), Instant.ofEpochMilli(completeRecord.timestamp()), snapshotComplete);
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatTierPartitionFenceTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID messageId = UUID.randomUUID();
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, messageId, false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", topicIdPartition.partition(), 0L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)partitionFence.serializeKey(), (Object)partitionFence.serializeValue(), (Headers)new RecordHeaders(), Optional.of(2));
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %d, %s): %s\n", topicIdPartition.partition(), 2, record.offset(), Instant.ofEpochMilli(record.timestamp()), partitionFence.toString());
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatDeserializationFailureTest() {
        UnknownTierMetadata unknown = new UnknownTierMetadata();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", 0, 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)unknown.serializeKey(), (Object)unknown.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %d, %s): failed to deserialize tier metadata. Error message: Deserialization error [Unknown id -1]. Record: %s\n", record.partition(), -1, record.offset(), Instant.ofEpochMilli(record.timestamp()), record.toString());
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatPartitionDeletePreInitiateTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID messageId = UUID.randomUUID();
        TierPartitionDeletePreInitiate partDeletePreInit = new TierPartitionDeletePreInitiate(topicIdPartition, messageId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", topicIdPartition.partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)partDeletePreInit.serializeKey(), (Object)partDeletePreInit.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %d, %s): %s\n", topicIdPartition.partition(), -1, record.offset(), Instant.ofEpochMilli(record.timestamp()), partDeletePreInit.toString());
        Assertions.assertEquals((Object)expected, (Object)baos.toString());
    }

    private class UnknownTierMetadata
    extends AbstractTierMetadata {
        private UnknownTierMetadata() {
        }

        public TierRecordType type() {
            return null;
        }

        public TopicIdPartition topicIdPartition() {
            return new TopicIdPartition("foo", UUID.randomUUID(), 0);
        }

        public ByteBuffer payloadBuffer() {
            return null;
        }

        public int tierEpoch() {
            return 0;
        }

        public kafka.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
            return kafka.tier.state.OffsetAndEpoch.EMPTY;
        }

        public UUID messageId() {
            return UUID.randomUUID();
        }

        public byte[] serializeValue() {
            return new byte[]{-1};
        }
    }
}

