/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import kafka.server.InternalAdmin;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.topic.TierCatchupConsumer;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManager;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Short$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\f\u0018\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u0004;\u0001\u0001\u0006Ia\u000b\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0001\u0005\u0001)A\u0005{!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005B\u0002$\u0001A\u0003%1\tC\u0004H\u0001\t\u0007I\u0011\u0001%\t\rU\u0003\u0001\u0015!\u0003J\u0011\u001d1\u0006A1A\u0005\u0002]Caa\u0017\u0001!\u0002\u0013A\u0006b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007C\u0002\u0001\u000b\u0011\u00020\t\u000b\t\u0004A\u0011A2\t\u000bQ\u0004A\u0011A2\t\u000be\u0004A\u0011A2\t\u000bm\u0004A\u0011A2\t\u000bu\u0004A\u0011\u0002@\t\r\u0005\r\u0002\u0001\"\u0001d\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!!\f\u0001\t\u0013\tyCA\fUS\u0016\u00148)\u0019;dQV\u00048i\u001c8tk6,'\u000fV3ti*\u0011\u0001$G\u0001\u0006i>\u0004\u0018n\u0019\u0006\u00035m\tA\u0001^5fe*\tA$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002/\u0005\tBo\u001c9jG&#\u0007+\u0019:uSRLwN\\:\u0016\u0003-\u00022\u0001L\u001a7\u001d\ti\u0013\u0007\u0005\u0002/C5\tqF\u0003\u00021;\u00051AH]8pizJ!AM\u0011\u0002\rA\u0013X\rZ3g\u0013\t!TGA\u0002TKRT!AM\u0011\u0011\u0005]BT\"A\r\n\u0005eJ\"\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003I!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u0005i\u0004C\u0001\u0011?\u0013\ty\u0014EA\u0003TQ>\u0014H/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0013QLWM\u001d+pa&\u001cW#A\"\u0011\u0005!\"\u0015BA#\u0018\u0005%!\u0016.\u001a:U_BL7-\u0001\u0006uS\u0016\u0014Hk\u001c9jG\u0002\n\u0001\u0003\u001d:pIV\u001cWM]*vaBd\u0017.\u001a:\u0016\u0003%\u0003BAS'P\u001f6\t1J\u0003\u0002M3\u000511\r\\5f]RL!AT&\u0003)5{7m\u001b)s_\u0012,8-\u001a:TkB\u0004H.[3s!\r\u0001\u0003KU\u0005\u0003#\u0006\u0012Q!\u0011:sCf\u0004\"\u0001I*\n\u0005Q\u000b#\u0001\u0002\"zi\u0016\f\u0011\u0003\u001d:pIV\u001cWM]*vaBd\u0017.\u001a:!\u0003A\u0019wN\\:v[\u0016\u00148+\u001e9qY&,'/F\u0001Y!\u0011Q\u0015lT(\n\u0005i[%\u0001F'pG.\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'/A\td_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0002\nA\u0002^3ti\u000e{gn];nKJ,\u0012A\u0018\t\u0003Q}K!\u0001Y\f\u0003'QKWM]\"bi\u000eDW\u000f]\"p]N,X.\u001a:\u0002\u001bQ,7\u000f^\"p]N,X.\u001a:!\u0003\u0015\u0019X\r^;q)\u0005!\u0007C\u0001\u0011f\u0013\t1\u0017E\u0001\u0003V]&$\bF\u0001\bi!\tI'/D\u0001k\u0015\tYG.A\u0002ba&T!!\u001c8\u0002\u000f),\b/\u001b;fe*\u0011q\u000e]\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002c\u0006\u0019qN]4\n\u0005MT'A\u0003\"fM>\u0014X-R1dQ\u0006\tB/Z:u'R\f'\u000f^\"p]N,X.\u001a:)\u0005=1\bCA5x\u0013\tA(N\u0001\u0003UKN$\u0018A\r;fgR\u001cF/\u0019:u\u0003:$7i\\7qY\u0016$XmQ1uG\",\boQ8ogVlWM],ji\"\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0005A1\u0018a\u0004;fgR$&/_\"p[BdW\r^3)\u0005E1\u0018A\u0004<fe&4\u0017pQ8na2,G/\u001a\u000b\u0003I~Dq!!\u0001\u0013\u0001\u0004\t\u0019!A\tdkJ\u0014XM\u001c;BgNLwM\\7f]R\u0004b!!\u0002\u0002\u0010\u0005EQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001b\tAA[1wC&\u0019A'a\u0002\u0011\t\u0005M\u0011qD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u000511m\\7n_:T1\u0001HA\u000e\u0015\r\ti\u0002]\u0001\u0007CB\f7\r[3\n\t\u0005\u0005\u0012Q\u0003\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003!!Xm\u001d;Q_2d\u0007FA\nw\u0003)\t7o]5h]6,g\u000e\u001e\u000b\u0005\u0003\u0007\tY\u0003C\u0003*)\u0001\u00071&A\rv]\u0012,'\u000f\\=j]\u001e\u001c\u0015\r^2ikB\u001cuN\\:v[\u0016\u0014XCAA\u0019!\u0019\t\u0019$!\u0010P\u001f6\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0005d_:\u001cX/\\3s\u0015\u0011\tY$!\u0007\u0002\u000f\rd\u0017.\u001a8ug&!\u0011qHA\u001b\u0005!\u0019uN\\:v[\u0016\u0014\b")
public class TierCatchupConsumerTest {
    private final scala.collection.immutable.Set<TopicIdPartition> topicIdPartitions = TierTestUtils$.MODULE$.randomTopicIdPartitions(3, 5);
    private final short numPartitions = (short)5;
    private final TierTopic tierTopic = new TierTopic("namespace");
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> consumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", TierTopicManager.partitions((String)this.tierTopic().topicName(), (int)this.numPartitions()), this.producerSupplier().producer(), 0L);
    private final TierCatchupConsumer testConsumer = new TierCatchupConsumer(this.consumerSupplier());

    public scala.collection.immutable.Set<TopicIdPartition> topicIdPartitions() {
        return this.topicIdPartitions;
    }

    public short numPartitions() {
        return this.numPartitions;
    }

    public TierTopic tierTopic() {
        return this.tierTopic;
    }

    public MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    public MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    public TierCatchupConsumer testConsumer() {
        return this.testConsumer;
    }

    @BeforeEach
    public void setup() {
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic(this.tierTopic().topicName(), (int)this.numPartitions(), (short)1, TierTopic.topicConfig()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.numPartitions())));
        this.tierTopic().initialize(internalAdmin, (int)this.numPartitions(), (short)1);
    }

    @Test
    public void testStartConsumer() {
        Set<TopicPartition> tierTopicPartitions = this.assignment(this.topicIdPartitions());
        this.testConsumer().doStart(tierTopicPartitions);
        Assertions.assertTrue((boolean)this.testConsumer().active());
        Assertions.assertEquals((Object)this.underlyingCatchupConsumer().assignment(), tierTopicPartitions);
        scala.collection.immutable.Set<TopicIdPartition> newTopicPartitions = TierTestUtils$.MODULE$.randomTopicIdPartitions(3, 2);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testConsumer().doStart(this.assignment(newTopicPartitions)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierCatchupConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        Assertions.assertEquals((Object)this.underlyingCatchupConsumer().assignment(), tierTopicPartitions);
        Assertions.assertTrue((boolean)this.testConsumer().active());
    }

    @Test
    public void testStartAndCompleteCatchupConsumerWithStartOffset() {
        Set<TopicPartition> tierTopicPartitions = this.assignment(this.topicIdPartitions());
        java.util.Map partitionsAndStartOffsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(tierTopicPartitions).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                int i = x0$1._2$mcI$sp();
                return new Tuple2((Object)tp, (Object)i);
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        this.testConsumer().doStart(partitionsAndStartOffsets);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testConsumer().doStart(partitionsAndStartOffsets), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierCatchupConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        Assertions.assertEquals((Object)this.underlyingCatchupConsumer().assignment(), tierTopicPartitions);
        Assertions.assertTrue((boolean)this.testConsumer().active());
        this.verifyComplete(tierTopicPartitions);
    }

    @Test
    public void testTryComplete() {
        Set<TopicPartition> currentAssignment = this.assignment(this.topicIdPartitions());
        this.testConsumer().doStart(currentAssignment);
        this.verifyComplete(currentAssignment);
    }

    private void verifyComplete(Set<TopicPartition> currentAssignment) {
        Consumer primaryConsumer = (Consumer)Mockito.mock(Consumer.class);
        CollectionConverters$.MODULE$.SetHasAsScala(currentAssignment).asScala().foreach((Function1 & Serializable)topicPartition -> {
            this.underlyingCatchupConsumer().seek(topicPartition, 10L);
            return Mockito.when((Object)BoxesRunTime.boxToLong((long)primaryConsumer.position(topicPartition))).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        });
        Assertions.assertFalse((boolean)this.testConsumer().tryComplete((tp, currentPosition) -> primaryConsumer.position(tp) <= currentPosition));
        Assertions.assertTrue((boolean)this.testConsumer().active());
        CollectionConverters$.MODULE$.SetHasAsScala(currentAssignment).asScala().foreach((Function1 & Serializable)topicPartition -> {
            this.underlyingCatchupConsumer().seek(topicPartition, 20L);
            return Mockito.when((Object)BoxesRunTime.boxToLong((long)primaryConsumer.position(topicPartition))).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        });
        Assertions.assertTrue((boolean)this.testConsumer().tryComplete((tp, currentPosition) -> primaryConsumer.position(tp) <= currentPosition));
        Assertions.assertFalse((boolean)this.testConsumer().active());
    }

    @Test
    public void testPoll() {
        Set<TopicPartition> currentAssignment = this.assignment(this.topicIdPartitions());
        Consumer primaryConsumer = (Consumer)Mockito.mock(Consumer.class);
        Assertions.assertEquals(null, (Object)this.testConsumer().poll(Duration.ZERO));
        this.testConsumer().doStart(currentAssignment);
        ConsumerRecords records = this.testConsumer().poll(Duration.ZERO);
        Assertions.assertEquals((int)0, (int)records.count());
        CollectionConverters$.MODULE$.SetHasAsScala(currentAssignment).asScala().foreach((Function1 & Serializable)topicPartition -> {
            this.underlyingCatchupConsumer().seek(topicPartition, 20L);
            return Mockito.when((Object)BoxesRunTime.boxToLong((long)primaryConsumer.position(topicPartition))).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        });
        Assertions.assertTrue((boolean)this.testConsumer().tryComplete((tp, currentPosition) -> primaryConsumer.position(tp) <= currentPosition));
        Assertions.assertEquals(null, (Object)this.testConsumer().poll(Duration.ZERO));
    }

    public Set<TopicPartition> assignment(scala.collection.immutable.Set<TopicIdPartition> topicIdPartitions) {
        return this.tierTopic().toTierTopicPartitions((Collection)CollectionConverters$.MODULE$.SetHasAsJava(topicIdPartitions).asJava());
    }

    private Consumer<byte[], byte[]> underlyingCatchupConsumer() {
        return this.testConsumer().consumer;
    }
}

