/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Matchers$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0007\u000f\u0001UAQ\u0001\b\u0001\u0005\u0002uAQ\u0001\t\u0001\u0005R\u0005BQ\u0001\u000b\u0001\u0005\u0002%BQa\u0016\u0001\u0005\u0002aCQ!\u0018\u0001\u0005\u0002yCQ!\u001a\u0001\u0005\u0002yCQa\u001a\u0001\u0005\u0002yCQ!\u001b\u0001\u0005\u0002yCQa\u001b\u0001\u0005\u00021DQ!\u001d\u0001\u0005\u0002IDQa\u001e\u0001\u0005\u0002aDQ! \u0001\u0005\u0002y\u0014\u0011CU3d_Z,'/_+uS2\u001cH+Z:u\u0015\ty\u0001#A\u0003u_>d7O\u0003\u0002\u0012%\u0005!A/[3s\u0015\u0005\u0019\u0012!B6bM.\f7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\n\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001c1\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u001d\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#aA%oi\u00069C/Z:u\u0013:TWm\u0019;US\u0016\u0014Hk\u001c9jG\u00163XM\u001c;P]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5d)\tQS\u0006\u0005\u0002$W%\u0011A\u0006\n\u0002\u0005+:LG\u000fC\u0003/\u0007\u0001\u0007q&\u0001\u0004rk>\u0014X/\u001c\t\u0003a]r!!M\u001b\u0011\u0005I\"S\"A\u001a\u000b\u0005Q\"\u0012A\u0002\u001fs_>$h(\u0003\u00027I\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1D\u0005\u000b\u0003\u0004w%S\u0005C\u0001\u001fH\u001b\u0005i$B\u0001 @\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001!B\u0003\u0019\u0001\u0018M]1ng*\u0011!iQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!U)A\u0003kk:LGOC\u0001G\u0003\ry'oZ\u0005\u0003\u0011v\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA&NC\u0005a\u0015A\u0001>lC\u0005q\u0015!B6sC\u001a$\b\u0006B\u0002Q)V\u0003\"!\u0015*\u000e\u0003}J!aU \u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001,\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0\u0001\u0016uKN$\u0018J\u001c6fGR$\u0016.\u001a:U_BL7-\u0012<f]R|eNT8o\u000bbL7\u000f^5oOR{\u0007/[2\u0015\u0005)J\u0006\"\u0002\u0018\u0005\u0001\u0004y\u0003\u0006\u0002\u0003<\u0013nc#aS')\t\u0011\u0001F+V\u0001*i\u0016\u001cH\u000fV8U_BL7-\u00133QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5F[B$\u0018\u0010V8qS\u000et\u0015-\\3\u0015\u0003)B#!\u00021\u0011\u0005\u0005\u001cW\"\u00012\u000b\u0005e\t\u0015B\u00013c\u0005\u0011!Vm\u001d;\u0002KQ,7\u000f\u001e+p)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u0005\u0006$Gk\u001c9jG&#\u0007F\u0001\u0004a\u00035\"Xm\u001d;U_R{\u0007/[2JIB\u000b'\u000f^5uS>t7oV5uQ\n\u000bG\rU1si&$\u0018n\u001c8Ok6\u0014WM\u001d\u0015\u0003\u000f\u0001\f1\u0005^3tiR{Gk\u001c9jG&#\u0007+\u0019:uSRLwN\\:XSRDwi\\8e\u0003J<7\u000f\u000b\u0002\tA\u0006!C/Z:u-\u0006d\u0017\u000eZ1uKB\u000b'\u000f^5uS>t7oV5uQZ\u000bG.\u001b3U_BL7\r\u0006\u0002+[\")a&\u0003a\u0001_!\"\u0011bO%pY\tYU\n\u000b\u0003\n!R+\u0016A\n;fgR4\u0016\r\\5eCR,\u0007+\u0019:uSRLwN\\:XSRD\u0017J\u001c<bY&$Gk\u001c9jGR\u0011!f\u001d\u0005\u0006])\u0001\ra\f\u0015\u0005\u0015mJU\u000f\f\u0002L\u001b\"\"!\u0002\u0015+V\u0003\u001d\"Xm\u001d;WC2LG-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u0013:$XM\u001d8bYR{\u0007/[2\u0015\u0005)J\b\"\u0002\u0018\f\u0001\u0004y\u0003\u0006B\u0006<\u0013nd#aS')\t-\u0001F+V\u0001+i\u0016\u001cHOV1mS\u0012\fG/\u001a)beRLG/[8og^KG\u000f[%om\u0006d\u0017\u000e\u001a)beRLG/[8o)\tQs\u0010C\u0003/\u0019\u0001\u0007q\u0006K\u0003\rw%\u000b\u0019\u0001\f\u0002L\u001b\"\"A\u0002\u0015+V\u0001")
public class RecoveryUtilsTest
extends IntegrationTestHarness {
    @Override
    public int brokerCount() {
        return 3;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInjectTierTopicEventOnExistingTopic(String quorum) {
        Some mayBeMetadata;
        String tierTopicName = TierTopic.topicName((String)"");
        int numTierTopicPartitions = 19;
        int tierTopicReplicationFactor = 3;
        TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("dummy", UUID.fromString("021516db-7a5f-40ef-adda-b6e2b21a3e83"), 123);
        this.createTopic(tierTopicName, numTierTopicPartitions, tierTopicReplicationFactor, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        int leaderEpoch = 1000;
        UUID messageId = UUID.randomUUID();
        int brokerId = 1;
        TierTopicInitLeader initLeaderEvent = new TierTopicInitLeader(tieredTopicIdPartition, leaderEpoch, messageId, brokerId);
        None$ mayBeProducer = None$.MODULE$;
        try {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
            mayBeProducer = new Some((Object)RecoveryUtils.createTierTopicProducer((Properties)properties, (String)"test"));
            Assertions.assertEquals((int)numTierTopicPartitions, (int)RecoveryUtils.getNumPartitions((Producer)((Producer)mayBeProducer.get()), (String)tierTopicName));
            mayBeMetadata = new Some((Object)RecoveryUtils.injectTierTopicEvent((Producer)((Producer)mayBeProducer.get()), (AbstractTierMetadata)initLeaderEvent, (String)tierTopicName, (int)numTierTopicPartitions));
        }
        finally {
            mayBeProducer.map((Function1 & Serializable)producer -> {
                producer.close();
                return BoxedUnit.UNIT;
            });
        }
        mayBeMetadata.map((Function1 & Serializable)metadata -> {
            RecoveryUtilsTest.$anonfun$testInjectTierTopicEventOnExistingTopic$2(metadata);
            return BoxedUnit.UNIT;
        });
        ObjectRef consumer = ObjectRef.create(null);
        try {
            Properties consumerProps = new Properties();
            consumerProps.put("auto.offset.reset", "earliest");
            consumerProps.put("enable.auto.commit", "false");
            consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
            consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            consumer.elem = new KafkaConsumer(consumerProps);
            Set tierTopicPartitions = TierTopicManager.partitions((String)tierTopicName, (int)numTierTopicPartitions);
            ((KafkaConsumer)consumer.elem).assign((Collection)tierTopicPartitions);
            tierTopicPartitions.forEach(tp -> ((KafkaConsumer)consumer$1.elem).seekToBeginning(Collections.singletonList(tp)));
            ConsumerRecords records = ((KafkaConsumer)consumer.elem).poll(Duration.ofMillis(100L));
            Assertions.assertEquals((int)1, (int)records.count());
            ConsumerRecord record = (ConsumerRecord)records.iterator().next();
            Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()), (long)record.timestamp());
            Assertions.assertTrue((boolean)eventOpt.isPresent());
            TierTopicInitLeader retrievedEvent = (TierTopicInitLeader)eventOpt.get();
            Assertions.assertEquals((Object)initLeaderEvent, (Object)retrievedEvent);
        }
        finally {
            ((KafkaConsumer)consumer.elem).close();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInjectTierTopicEventOnNonExistingTopic(String quorum) {
        TierTopicInitLeader initLeaderEvent = new TierTopicInitLeader(new TopicIdPartition("dummy", UUID.fromString("021516db-7a5f-40ef-adda-b6e2b21a3e83"), 123), 1000, UUID.randomUUID(), 1);
        short numTierTopicPartitions = 1;
        ObjectRef mayBeProducer = ObjectRef.create((Object)None$.MODULE$);
        try {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
            mayBeProducer.elem = new Some((Object)RecoveryUtils.createTierTopicProducer((Properties)properties, (String)"test"));
            boolean cfr_ignored_0 = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> RecoveryUtils.injectTierTopicEvent((Producer)((Producer)((Option)mayBeProducer$1.elem).get()), (AbstractTierMetadata)initLeaderEvent, (String)"", (int)numTierTopicPartitions), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142))).getCause() instanceof UnknownTopicOrPartitionException;
        }
        finally {
            ((Option)mayBeProducer.elem).map((Function1 & Serializable)producer -> {
                producer.close();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testToTopicIdPartitionsWithEmptyTopicName() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "", "23", "false"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "   ", "23", "false"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
    }

    @Test
    public void testToTopicIdPartitionsWithBadTopicId() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"", "foo", "23", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"  ", "foo", "23", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        String badUuid = "badUuid";
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{badUuid, "foo", "23", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
    }

    @Test
    public void testToTopicIdPartitionsWithBadPartitionNumber() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "foo", "", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "foo", "  ", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "foo", "abc", "true"})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }

    @Test
    public void testToTopicIdPartitionsWithGoodArgs() {
        TopicIdPartition topicIdPartition1 = new TopicIdPartition("foo", UUID.randomUUID(), 23);
        TopicIdPartition topicIdPartition2 = new TopicIdPartition("bar", UUID.randomUUID(), 97);
        Map result = RecoveryUtils.parseFencingInformation(Arrays.asList(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%d %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.uuidToBase64(topicIdPartition1.topicId()), topicIdPartition1.topic(), BoxesRunTime.boxToInteger((int)topicIdPartition1.partition()), "true"})), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%d %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.uuidToBase64(topicIdPartition2.topicId()), topicIdPartition2.topic(), BoxesRunTime.boxToInteger((int)topicIdPartition2.partition()), "true"}))));
        HashMap<TopicIdPartition, Boolean> expected = new HashMap<TopicIdPartition, Boolean>();
        expected.put(topicIdPartition1, BoxesRunTime.boxToBoolean((boolean)true));
        expected.put(topicIdPartition2, BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertEquals(expected, (Object)result);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidatePartitionsWithValidTopic(String quorum) {
        TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 3);
        this.createTopic(tieredTopicIdPartition.topic(), 5, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        HashSet<TopicPartition> inputPartitions = new HashSet<TopicPartition>();
        inputPartitions.add(new TopicPartition(tieredTopicIdPartition.topic(), tieredTopicIdPartition.partition()));
        RecoveryUtils.validatePartitions((Properties)properties, inputPartitions);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidatePartitionsWithInvalidTopic(String quorum) {
        TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 3);
        this.createTopic(tieredTopicIdPartition.topic(), 5, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        HashSet<TopicPartition> inputPartitions = new HashSet<TopicPartition>();
        inputPartitions.add(new TopicPartition("dummy", 13));
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, (Set)inputPartitions), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidatePartitionsWithInternalTopic(String quorum) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        HashSet<TopicPartition> inputPartitions = new HashSet<TopicPartition>();
        inputPartitions.add(new TopicPartition("__consumer_offsets", 0));
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, (Set)inputPartitions), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidatePartitionsWithInvalidPartition(String quorum) {
        TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 3);
        this.createTopic(tieredTopicIdPartition.topic(), 5, 1, TierTopic.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        HashSet<TopicPartition> inputPartitions = new HashSet<TopicPartition>();
        inputPartitions.add(new TopicPartition(tieredTopicIdPartition.topic(), 13));
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, (Set)inputPartitions), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
    }

    public static final /* synthetic */ void $anonfun$testInjectTierTopicEventOnExistingTopic$2(RecordMetadata metadata) {
        Assertions.assertTrue((boolean)metadata.hasOffset());
        Assertions.assertEquals((long)0L, (long)metadata.offset());
        Assertions.assertTrue((metadata.serializedKeySize() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((metadata.serializedValueSize() > 0 ? 1 : 0) != 0);
    }
}

