/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.UUID;
import kafka.log.MergedLog$;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.snapshot.MetadataSnapshotMetrics;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001B\r\u001b\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011!i\u0004A!A!\u0002\u0013q\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011%\u0003!\u00111A\u0005\u0002)C\u0001\u0002\u0017\u0001\u0003\u0002\u0004%\t!\u0017\u0005\t?\u0002\u0011\t\u0011)Q\u0005\u0017\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!q\u0007A!A!\u0002\u0013y\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\t\u0011i\u0004!\u0011!Q\u0001\nmDq!a\u0002\u0001\t\u0003\tI\u0001C\u0005\u0002&\u0001\u0011\r\u0011\"\u0001\u0002(!A\u0011\u0011\b\u0001!\u0002\u0013\tI\u0003C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005\"CA]\u0001E\u0005I\u0011AA^\u0011%\t\t\u000eAI\u0001\n\u0003\tY\fC\u0005\u0002T\u0002\t\n\u0011\"\u0001\u0002V\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m'!E*oCB\u001c\bn\u001c;UKN$X\u000b^5mg*\u00111\u0004H\u0001\tg:\f\u0007o\u001d5pi*\u0011QDH\u0001\u0006i\u0006\u001c8n\u001d\u0006\u0003?\u0001\nA\u0001^5fe*\t\u0011%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B\u0011A&L\u0007\u0002=%\u0011aF\b\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003KEJ!A\r\u0014\u0003\u0007%sG/A\u0006mK\u0006$WM]#q_\u000eD\u0017A\u00027pO\u0012K'\u000f\u0005\u00027w5\tqG\u0003\u00029s\u0005\u0011\u0011n\u001c\u0006\u0002u\u0005!!.\u0019<b\u0013\tatG\u0001\u0003GS2,\u0017aA2uqB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IH\u0001\bM\u0016$8\r[3s\u0013\t\u0019\u0005IA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/A\u0004nKR\u0014\u0018nY:\u0011\u0005\u0019;U\"\u0001\u000e\n\u0005!S\"aF'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u\u001b\u0016$(/[2t\u0003\u0011!\u0018.\\3\u0016\u0003-\u0003\"\u0001\u0014,\u000e\u00035S!AT(\u0002\u000bU$\u0018\u000e\\:\u000b\u0005A\u000b\u0016AB2p[6|gN\u0003\u0002\"%*\u00111\u000bV\u0001\u0007CB\f7\r[3\u000b\u0003U\u000b1a\u001c:h\u0013\t9VJ\u0001\u0005N_\u000e\\G+[7f\u0003!!\u0018.\\3`I\u0015\fHC\u0001.^!\t)3,\u0003\u0002]M\t!QK\\5u\u0011\u001dq\u0006\"!AA\u0002-\u000b1\u0001\u001f\u00132\u0003\u0015!\u0018.\\3!\u0003A!\u0018.\u001a:U_BL7-T1oC\u001e,'\u000f\u0005\u0002cK6\t1M\u0003\u0002e=\u0005)Ao\u001c9jG&\u0011am\u0019\u0002\u0011)&,'\u000fV8qS\u000el\u0015M\\1hKJ\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002jY6\t!N\u0003\u0002lA\u000511/\u001a:wKJL!!\u001c6\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006!\u0012N\\'f[RKWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0010\u0002\u000bM$xN]3\n\u0005Q\f(aG'pG.Le.T3n_JLH+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\buS\u0016\u0014H+Y:lg\u000e{gNZ5h!\t9\b0D\u0001\u001d\u0013\tIHDA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u00031\u0019h.\u00199tQ>$8\u000fR5s!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0005M&dWMC\u0002\u0002\u0002e\n1A\\5p\u0013\r\t)! \u0002\u0005!\u0006$\b.\u0001\u0004=S:LGO\u0010\u000b\u001b\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121\u0005\t\u0003\r\u0002AQAK\bA\u0002-BQaL\bA\u0002ABQaM\bA\u0002ABQ\u0001N\bA\u0002UBQ!P\bA\u0002yBQ\u0001R\bA\u0002\u0015CQ!S\bA\u0002-CQ\u0001Y\bA\u0002\u0005DQaZ\bA\u0002!DQA\\\bA\u0002=DQ!^\bA\u0002YDQA_\bA\u0002m\f\u0001\u0003Z3gCVdG/Q<bSR$\u0016.\\3\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\tIV\u0014\u0018\r^5p]*\u0019\u00111\u0007\u0014\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00028\u00055\"A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0012I\u00164\u0017-\u001e7u\u0003^\f\u0017\u000e\u001e+j[\u0016\u0004\u0013\u0001\n<fe&4\u0017p\u00158baNDw\u000e^#ySN$XM\\2f\u0003R|%M[3diN#xN]3\u0015\r\u0005}\u0012\u0011KA1!\u0015)\u0013\u0011IA#\u0013\r\t\u0019E\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013\u001f\u0003\u0015\u0019H/\u0019;f\u0013\u0011\ty%!\u0013\u0003I\u0019KG.\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cf.\u00199tQ>$xJ\u00196fGRDq!a\u0015\u0013\u0001\u0004\t)&\u0001\u0006t]\u0006\u00048\u000f[8u\u0013\u0012\u0004B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0004\u00037J\u0014\u0001B;uS2LA!a\u0018\u0002Z\t!Q+V%E\u0011\u001d\t\u0019G\u0005a\u0001\u0003K\n1b\u001d5pk2$W\t_5tiB\u0019Q%a\u001a\n\u0007\u0005%dEA\u0004C_>dW-\u00198\u00025Y,'/\u001b4z\u000bbL7\u000f^3oG\u0016|em\u00158baNDw\u000e^:\u0015\u000bi\u000by'a#\t\u000f\u0005E4\u00031\u0001\u0002t\u0005IQ.^:u\u000bbL7\u000f\u001e\t\u0007\u0003k\n))!\u0016\u000f\t\u0005]\u0014\u0011\u0011\b\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011Q\u0010\u0012\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0013bAABM\u00059\u0001/Y2lC\u001e,\u0017\u0002BAD\u0003\u0013\u0013A\u0001T5ti*\u0019\u00111\u0011\u0014\t\u000f\u000555\u00031\u0001\u0002t\u0005aQ.^:u\u001d>$X\t_5ti\u0006A2M]3bi\u0016\u0014\u0016M\u001c3p[Ns\u0017\r]:i_R4\u0015\u000e\\3\u0015\u0017i\u000b\u0019*!&\u0002(\u0006-\u0016q\u0016\u0005\b\u0003'\"\u0002\u0019AA+\u0011\u001d\t9\n\u0006a\u0001\u00033\u000bA!\u00197h_B!\u00111TAR\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001C2iK\u000e\\7/^7\u000b\u00059\u0003\u0013\u0002BAS\u0003;\u0013\u0011\"\u00117h_JLG\u000f[7\t\u0013\u0005%F\u0003%AA\u0002\u0005\u0015\u0014!\u0004<bY&$7\t[3dWN,X\u000eC\u0005\u0002.R\u0001\n\u00111\u0001\u0002f\u0005Ya/\u00197jI\"+\u0017\rZ3s\u0011%\t\t\f\u0006I\u0001\u0002\u0004\t\u0019,\u0001\u0010mCN$X*\u0019;fe&\fG.\u001b>fI>3gm]3u\u0003:$W\t]8dQB!\u0011qIA[\u0013\u0011\t9,!\u0013\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\u0006\u00113M]3bi\u0016\u0014\u0016M\u001c3p[Ns\u0017\r]:i_R4\u0015\u000e\\3%I\u00164\u0017-\u001e7uIM*\"!!0+\t\u0005\u0015\u0014qX\u0016\u0003\u0003\u0003\u0004B!a1\u0002N6\u0011\u0011Q\u0019\u0006\u0005\u0003\u000f\fI-A\u0005v]\u000eDWmY6fI*\u0019\u00111\u001a\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002P\u0006\u0015'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00113M]3bi\u0016\u0014\u0016M\u001c3p[Ns\u0017\r]:i_R4\u0015\u000e\\3%I\u00164\u0017-\u001e7uIQ\n!e\u0019:fCR,'+\u00198e_6\u001cf.\u00199tQ>$h)\u001b7fI\u0011,g-Y;mi\u0012*TCAAlU\u0011\t\u0019,a0\u00027\r\u0014X-\u0019;f\u0003:$W\u000b\u001d7pC\u0012\u001cf.\u00199tQ>$h)\u001b7f)\u0019\t)%!8\u0002`\"9\u00111\u000b\rA\u0002\u0005U\u0003bBAL1\u0001\u0007\u0011\u0011\u0014")
public class SnapshotTestUtils {
    private final TopicIdPartition topicIdPartition;
    private final int brokerId;
    private final int leaderEpoch;
    private final File logDir;
    private final CancellationContext ctx;
    private final MetadataSnapshotMetrics metrics;
    private MockTime time;
    private final TierTopicManager tierTopicManager;
    private final ReplicaManager replicaManager;
    private final MockInMemoryTierObjectStore inMemTierObjectStore;
    private final TierTasksConfig tierTasksConfig;
    private final Path snapshotsDir;
    private final FiniteDuration defaultAwaitTime;

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public FiniteDuration defaultAwaitTime() {
        return this.defaultAwaitTime;
    }

    public Option<FileTierPartitionStateSnapshotObject> verifySnapshotExistenceAtObjectStore(UUID snapshotId, boolean shouldExist) {
        String prefix = TierObjectStore.TierPartitionStateSnapshotMetadata.pathPrefix((String)"", (TopicIdPartition)this.topicIdPartition);
        Optional<String> snapshotPath = this.inMemTierObjectStore.listObject(prefix, false).keySet().stream().filter(s -> s.contains(snapshotId.toString())).findFirst();
        if (shouldExist) {
            Assertions.assertTrue((boolean)snapshotPath.isPresent(), (String)"Snapshot not present at the tier object store");
            String encodedName = TierObjectStore.TierPartitionStateSnapshotMetadata.extractEncodedName((String)snapshotPath.get());
            return new Some((Object)FileTierPartitionStateSnapshotObject.decodeSnapshotName((String)encodedName));
        }
        Assertions.assertTrue((!snapshotPath.isPresent() ? 1 : 0) != 0, (String)"Snapshot present at the tier object store");
        return None$.MODULE$;
    }

    public void verifyExistenceOfSnapshots(List<UUID> mustExist, List<UUID> mustNotExist) {
        mustExist.foreach((Function1 & Serializable)uuid -> this.verifySnapshotExistenceAtObjectStore((UUID)uuid, true));
        mustNotExist.foreach((Function1 & Serializable)uuid -> this.verifySnapshotExistenceAtObjectStore((UUID)uuid, false));
    }

    public void createRandomSnapshotFile(UUID snapshotId, Algorithm algo, boolean validChecksum, boolean validHeader, OffsetAndEpoch lastMaterializedOffsetAndEpoch) {
        short superBlockLength;
        String baseName = MergedLog$.MODULE$.tierStateFile(this.logDir, 0L, "").getName();
        FileTierPartitionStateSnapshotObject snapshotUtils = new FileTierPartitionStateSnapshotObject(snapshotId, this.time().milliseconds(), lastMaterializedOffsetAndEpoch, this.leaderEpoch, baseName, algo);
        Path snapshotPath = this.snapshotsDir.resolve(snapshotUtils.encodeSnapshotName());
        Algorithm algorithm = algo;
        Algorithm algorithm2 = Algorithm.ADLER;
        short s = !(algorithm != null ? !algorithm.equals(algorithm2) : algorithm2 != null) ? (short)512 : (superBlockLength = 0);
        if (validChecksum) {
            OpenOption[] openOrCreate_options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE};
            Object var16_11 = null;
            CheckedFileIO.openOrCreate((Path)snapshotPath, (Algorithm)algo, (short)superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options).close();
            return;
        }
        if (validHeader) {
            OpenOption[] openOrCreate_options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE};
            Object var17_12 = null;
            CheckedFileIO snapshotIO = CheckedFileIO.openOrCreate((Path)snapshotPath, (Algorithm)algo, (short)superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
            byte[] fileContentBytes = "BytesIncludedWhenCalculatingAChecksum".getBytes(StandardCharsets.UTF_8);
            ByteBuffer buf = ByteBuffer.allocate(fileContentBytes.length);
            buf.put(fileContentBytes);
            buf.flip();
            snapshotIO.write(buf);
            snapshotIO.close();
            File nonChecksumIO = new File(((Object)snapshotPath).toString());
            RandomAccessFile access = new RandomAccessFile(nonChecksumIO, "rw");
            access.seek(superBlockLength + 1);
            access.writeBytes("InvalidOverwrite");
            access.close();
            return;
        }
        Files.write(snapshotPath, "InvalidFileContentsWithNoChecksumHeader".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public boolean createRandomSnapshotFile$default$3() {
        return true;
    }

    public boolean createRandomSnapshotFile$default$4() {
        return true;
    }

    public OffsetAndEpoch createRandomSnapshotFile$default$5() {
        return new OffsetAndEpoch(0L, Optional.empty());
    }

    public FileTierPartitionStateSnapshotObject createAndUploadSnapshotFile(UUID snapshotId, Algorithm algo) {
        this.createRandomSnapshotFile(snapshotId, algo, this.createRandomSnapshotFile$default$3(), this.createRandomSnapshotFile$default$4(), this.createRandomSnapshotFile$default$5());
        TierMetadataSnapshotUploadInitiate snapshotInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition, this.leaderEpoch, snapshotId, new OffsetAndEpoch(0L, Optional.empty()), this.brokerId);
        MetadataSnapshotTask.MetadataSnapshotState state = new MetadataSnapshotTask.MetadataSnapshotState(this.leaderEpoch, this.logDir, snapshotInitiate);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (MetadataSnapshotTask.MetadataSnapshotTaskState)Await$.MODULE$.result((Awaitable)state.transition($this.ctx, $this.topicIdPartition, $this.metrics, $this.brokerId, (Time)this.time(), (TierTopicAppender)$this.tierTopicManager, (TierObjectStore)$this.inMemTierObjectStore, $this.replicaManager, $this.tierTasksConfig, (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex).toString(), new Position("SnapshotTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            }
            throw new MatchError((Object)try_);
        }
        MetadataSnapshotTask.MetadataSnapshotTaskState nextState = (MetadataSnapshotTask.MetadataSnapshotTaskState)((Success)try_).value();
        Assertions.assertEquals(MetadataSnapshotTask.AfterMetadataSnapshotState.class, nextState.getClass(), (String)"Unexpected next state");
        return (FileTierPartitionStateSnapshotObject)this.verifySnapshotExistenceAtObjectStore(snapshotId, true).get();
    }

    public SnapshotTestUtils(TopicIdPartition topicIdPartition, int brokerId, int leaderEpoch, File logDir, CancellationContext ctx, MetadataSnapshotMetrics metrics, MockTime time, TierTopicManager tierTopicManager, ReplicaManager replicaManager, MockInMemoryTierObjectStore inMemTierObjectStore, TierTasksConfig tierTasksConfig, Path snapshotsDir) {
        this.topicIdPartition = topicIdPartition;
        this.brokerId = brokerId;
        this.leaderEpoch = leaderEpoch;
        this.logDir = logDir;
        this.ctx = ctx;
        this.metrics = metrics;
        this.time = time;
        this.tierTopicManager = tierTopicManager;
        this.replicaManager = replicaManager;
        this.inMemTierObjectStore = inMemTierObjectStore;
        this.tierTasksConfig = tierTasksConfig;
        this.snapshotsDir = snapshotsDir;
        this.defaultAwaitTime = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
    }
}

