/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogSegment;
import kafka.log.TierLogSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.CompactStats;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.CompactionTask$;
import kafka.tier.tasks.compaction.OffsetMapSupplier;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.utils.MockTime;
import kafka.utils.Throttler;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.ConfluentLogConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001B\r\u001b\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001A\u0002\u0013\u0005q\u0006C\u0004>\u0001\u0001\u0007I\u0011\u0001 \t\r\u0011\u0003\u0001\u0015)\u00031\u0011\u001d)\u0005A1A\u0005\u0002\u0019Ca\u0001\u0014\u0001!\u0002\u00139\u0005bB'\u0001\u0005\u0004%\tA\u0014\u0005\u0007%\u0002\u0001\u000b\u0011B(\t\u000fM\u0003!\u0019!C\u0001)\"1\u0001\f\u0001Q\u0001\nUCQ!\u0017\u0001\u0005\u0002iCq! \u0001\u0012\u0002\u0013\u0005a\u0010\u0003\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001\u007f\u0011%\t)\u0002AI\u0001\n\u0003\t9\u0002C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003\u0003\u0004A\u0011AA?\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!a5\u0001\t\u0003\ti\bC\u0004\u0002X\u0002!\t!! \t\u000f\u0005m\u0007\u0001\"\u0001\u0002~!9\u0011q\u001c\u0001\u0005\u0002\u0005u$!\u0007+jKJdunZ\"mK\u0006tWM]'b]\u0006<WM\u001d+fgRT!a\u0007\u000f\u0002\u0015\r|W\u000e]1di&|gN\u0003\u0002\u001e=\u0005)A/Y:lg*\u0011q\u0004I\u0001\u0005i&,'OC\u0001\"\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0005\u0002.\u00015\t!$\u0001\u0005n_\u000e\\G+[7f+\u0005\u0001\u0004CA\u0019<\u001b\u0005\u0011$BA\u001a5\u0003\u0015)H/\u001b7t\u0015\t)d'\u0001\u0004d_6lwN\u001c\u0006\u0003C]R!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO&\u0011AH\r\u0002\u0005)&lW-\u0001\u0007n_\u000e\\G+[7f?\u0012*\u0017\u000f\u0006\u0002@\u0005B\u0011Q\u0005Q\u0005\u0003\u0003\u001a\u0012A!\u00168ji\"91iAA\u0001\u0002\u0004\u0001\u0014a\u0001=%c\u0005IQn\\2l)&lW\rI\u0001\ni\"\u0014x\u000e\u001e;mKJ,\u0012a\u0012\t\u0003\u0011*k\u0011!\u0013\u0006\u0003g\u0001J!aS%\u0003\u0013QC'o\u001c;uY\u0016\u0014\u0018A\u0003;ie>$H\u000f\\3sA\u0005\trN\u001a4tKRl\u0015\r]*vaBd\u0017.\u001a:\u0016\u0003=\u0003\"!\f)\n\u0005ES\"!E(gMN,G/T1q'V\u0004\b\u000f\\5fe\u0006\u0011rN\u001a4tKRl\u0015\r]*vaBd\u0017.\u001a:!\u0003U!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGN,\u0012!\u0016\t\u0003[YK!a\u0016\u000e\u0003+QKWM]\"p[B\f7\r^5p]6+GO]5dg\u00061B/[3s\u0007>l\u0007/Y2uS>tW*\u001a;sS\u000e\u001c\b%A\u0005ck&dGmU3hgR)1,\\:zwB\u0019A\fZ4\u000f\u0005u\u0013gB\u00010b\u001b\u0005y&B\u00011#\u0003\u0019a$o\\8u}%\tq%\u0003\u0002dM\u00059\u0001/Y2lC\u001e,\u0017BA3g\u0005\r\u0019V-\u001d\u0006\u0003G\u001a\u0002\"\u0001[6\u000e\u0003%T!A\u001b\u0011\u0002\u00071|w-\u0003\u0002mS\nqA+[3s\u0019><7+Z4nK:$\b\"\u00028\f\u0001\u0004y\u0017!B:ju\u0016\u001c\bc\u0001/eaB\u0011Q%]\u0005\u0003e\u001a\u00121!\u00138u\u0011\u001d!8\u0002%AA\u0002U\f1CZ5sgR\u0014\u0015\r^2i)&lWm\u001d;b[B\u00042\u0001\u00183w!\t)s/\u0003\u0002yM\t!Aj\u001c8h\u0011\u001dQ8\u0002%AA\u0002U\fA\"\\1y)&lWm\u001d;b[BDq\u0001`\u0006\u0011\u0002\u0003\u0007a/\u0001\u0006cCN,wJ\u001a4tKR\f1CY;jY\u0012\u001cVmZ:%I\u00164\u0017-\u001e7uII*\u0012a \u0016\u0004k\u0006\u00051FAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055a%\u0001\u0006b]:|G/\u0019;j_:LA!!\u0005\u0002\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002'\t,\u0018\u000e\u001c3TK\u001e\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0002'\t,\u0018\u000e\u001c3TK\u001e\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005e!f\u0001<\u0002\u0002\u0005a!-^5mI6{7m\u001b'pOR\u0011\u0012qDA\u0013\u0003c\t)$!\u000f\u0002>\u0005\u0005\u0013QIA%!\rA\u0017\u0011E\u0005\u0004\u0003GI'aC!cgR\u0014\u0018m\u0019;M_\u001eDq!a\n\u0010\u0001\u0004\tI#\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B!\u00111FA\u0017\u001b\u0005q\u0012bAA\u0018=\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003gy\u0001\u0019A.\u0002\u0013\rdW-\u00198TK\u001e\u001c\bBBA\u001c\u001f\u0001\u00071,A\u0005eSJ$\u0018pU3hg\"1\u00111H\bA\u0002A\fAa]5{K\"1\u0011qH\bA\u0002A\fa\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0003\u0004\u0002D=\u0001\rA^\u0001\u001aE\u0006\u001cXm\u00144gg\u0016$xJ\u001a$jeN$H)\u001b:usN+w\r\u0003\u0004\u0002H=\u0001\rA^\u0001\u0013i&,'/\u001a3M_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0002L=\u0001\r!!\u0014\u0002#%\u001cH+[3s\u0007>l\u0007/Y2uC\ndW\rE\u0002&\u0003\u001fJ1!!\u0015'\u0005\u001d\u0011un\u001c7fC:\f1DY;jY\u0012lunY6US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G\u0003DA,\u0003G\ni'!\u001d\u0002t\u0005]\u0004\u0003BA-\u0003?j!!a\u0017\u000b\u0007\u0005uc$A\u0003ti\u0006$X-\u0003\u0003\u0002b\u0005m#A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016Dq!!\u001a\u0011\u0001\u0004\t9'\u0001\tmCN$8i\\7qC\u000e$8\u000b^1ugB!\u0011\u0011LA5\u0013\u0011\tY'a\u0017\u0003\u0019\r{W\u000e]1diN#\u0018\r^:\t\u000f\u0005=\u0004\u00031\u0001\u0002h\u00059\u0012mY2v[Vd\u0017\r^3e\u0007>l\u0007/Y2u'R\fGo\u001d\u0005\u0007\u0003\u000f\u0002\u0002\u0019\u0001<\t\r\u0005U\u0004\u00031\u0001w\u0003]\u0019w.\u001c9bGR$\u0015N\u001d;z'R\f'\u000f^(gMN,G\u000f\u0003\u0004\u0002zA\u0001\r\u0001]\u0001\ni>$\u0018\r\\*ju\u0016\fQ\u0005^3tiN\u001b\u0007.\u001a3vY&tw\rT1h\u0007>l\u0007/Y2uS>tWI\u001a4jG&,gnY=\u0015\u0003}B3!EAA!\u0011\t\u0019)!%\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b1!\u00199j\u0015\u0011\tY)!$\u0002\u000f),\b/\u001b;fe*\u0019\u0011qR\u001d\u0002\u000b),h.\u001b;\n\t\u0005M\u0015Q\u0011\u0002\u0005)\u0016\u001cH/\u0001\u0012uKN$8k\u00195fIVd\u0017N\\4MC\u001el\u0015N\\\"mK\u0006t\u0017M\u00197f%\u0006$\u0018n\u001c\u000b\u0004\u007f\u0005e\u0005bBAN%\u0001\u0007\u0011QJ\u0001.I&\u0014H/_*uCJ$xJ\u001a4tKR\fE.[4oK\u0012<\u0016\u000e\u001e5TK\u001elWM\u001c;Ti\u0006\u0014Ho\u00144gg\u0016$\bf\u0002\n\u0002 \u0006=\u0016\u0011\u0017\t\u0005\u0003C\u000bY+\u0004\u0002\u0002$*!\u0011QUAT\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BAU\u0003\u0013\u000ba\u0001]1sC6\u001c\u0018\u0002BAW\u0003G\u00131BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u00024\u0006U\u0016$A\u0001\u001a\u0003\u0001A3AEA]!\u0011\tY,!0\u000e\u0005\u0005\u001d\u0016\u0002BA`\u0003O\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\r\"Xm\u001d;TG\",G-\u001e7j]\u001ed\u0015mZ'bq\u000e{W\u000e]1di&|g\u000eT1h\u001bND3aEAA\u0003\r\"Xm\u001d;TG\",G-\u001e7j]\u001ed\u0015mZ'j]\u000e{W\u000e]1di&|g\u000eT1h\u001bN$2aPAe\u0011\u001d\tY\r\u0006a\u0001\u0003\u001b\n\u0011\u0003[1t\u00072,\u0017M\\1cY\u0016\u0014\u0015\u0010^3tQ\u001d!\u0012qTAX\u0003\u001fdC!a-\u00026\"\u001aA#!/\u00023Q,7\u000f^*dQ\u0016$W\u000f\\5oO2\u000bwMT8o\t&\u0014H/\u001f\u0015\u0004+\u0005\u0005\u0015\u0001\b;fgR\u001c6\r[3ek2Lgn\u001a'bO\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0004-\u0005\u0005\u0015A\n;fgR\u001c6\r[3ek2Lgn\u001a'bO:{g\u000eV5fe\u000e{W\u000e]1di\u0016$Gk\u001c9jG\"\u001aq#!!\u0002IQ,7\u000f^*dQ\u0016$W\u000f\\5oO2\u000bwm\u00147e)&,'/\u00192mKN+w-\\3oiND3\u0001GAA\u0001")
public class TierLogCleanerManagerTest {
    private Time mockTime = new MockTime(0L, 0L);
    private final Throttler throttler;
    private final OffsetMapSupplier offsetMapSupplier;
    private final TierCompactionMetrics tierCompactionMetrics;

    public Time mockTime() {
        return this.mockTime;
    }

    public void mockTime_$eq(Time x$1) {
        this.mockTime = x$1;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public OffsetMapSupplier offsetMapSupplier() {
        return this.offsetMapSupplier;
    }

    public TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    public Seq<TierLogSegment> buildSegs(Seq<Object> sizes, Seq<Object> firstBatchTimestamp, Seq<Object> maxTimestamp, long baseOffset) {
        ListBuffer segsList = new ListBuffer();
        LongRef segBaseOffset = LongRef.create((long)baseOffset);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), sizes.size()).foreach((Function1 & Serializable)i -> TierLogCleanerManagerTest.$anonfun$buildSegs$1(sizes, segBaseOffset, firstBatchTimestamp, maxTimestamp, segsList, BoxesRunTime.unboxToInt((Object)i)));
        return segsList.toList();
    }

    public Seq<Object> buildSegs$default$2() {
        return Nil$.MODULE$;
    }

    public Seq<Object> buildSegs$default$3() {
        return Nil$.MODULE$;
    }

    public long buildSegs$default$4() {
        return 0L;
    }

    public AbstractLog buildMockLog(TopicIdPartition topicIdPartition, Seq<TierLogSegment> cleanSegs, Seq<TierLogSegment> dirtySegs, int size, int logStartOffset, long baseOffsetOfFirstDirtySeg, long tieredLogEndOffset, boolean isTierCompactable) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(logStartOffset)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.size())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(size)));
        Mockito.when((Object)log.tieredLogSegments(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)baseOffsetOfFirstDirtySeg))).thenAnswer(x$1 -> cleanSegs.iterator());
        Mockito.when((Object)log.tieredLogSegments(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)(baseOffsetOfFirstDirtySeg + 1L)))).thenAnswer(x$2 -> ((IterableOnce)cleanSegs.$plus$plus((IterableOnce)new .colon.colon((Object)((TierLogSegment)dirtySegs.head()), (List)Nil$.MODULE$))).iterator());
        Mockito.when((Object)log.tieredLogSegments(ArgumentMatchers.eq((long)baseOffsetOfFirstDirtySeg), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenAnswer(x$3 -> dirtySegs.iterator());
        Mockito.when((Object)log.tieredLogSegments(ArgumentMatchers.eq((long)(baseOffsetOfFirstDirtySeg + 1L)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenAnswer(x$4 -> dirtySegs.iterator());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log.isTierCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isTierCompactable));
        return log;
    }

    public TierPartitionState buildMockTierPartitionState(CompactStats lastCompactStats, CompactStats accumulatedCompactStats, long tieredLogEndOffset, long compactDirtyStartOffset, int totalSize) {
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)tieredLogEndOffset));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.compactDirtyStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)compactDirtyStartOffset));
        Mockito.when((Object)tierPartitionState.lastCompactStats()).thenReturn((Object)lastCompactStats);
        Mockito.when((Object)tierPartitionState.accumulatedCompactStats()).thenReturn((Object)accumulatedCompactStats);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.totalSize())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(totalSize)));
        return tierPartitionState;
    }

    @Test
    public void testSchedulingLagCompactionEfficiency() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.mockTime_$eq((Time)new MockTime(0L, 0L));
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), this.buildSegs$default$2(), this.buildSegs$default$3(), this.buildSegs$default$4());
        Seq x$1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 30}));
        Seq<Object> x$3 = this.buildSegs$default$2();
        Seq<Object> x$4 = this.buildSegs$default$3();
        Seq<TierLogSegment> dirtySegs = this.buildSegs((Seq<Object>)x$1, x$3, x$4, 41L);
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 80L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 300L, 250L);
        long tieredLogEndOffset = 100L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        ConfluentLogConfig confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)0.2));
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerMinCleanableRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)0.5));
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.tierableLogSegments()).thenAnswer(x$5 -> (Iterable)package$.MODULE$.Iterable().apply((Seq)Nil$.MODULE$));
        this.mockTime().sleep(501L);
        TierLogToClean logToClean = CompactionTask$.MODULE$.getTierLogToClean(log, this.mockTime(), this.mockTime().milliseconds());
        Assertions.assertEquals((long)40L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)60L, (long)logToClean.cleanableBytes());
        Assertions.assertEquals((double)0.6, (double)logToClean.cleanableRatio());
        Assertions.assertEquals((double)0.45, (double)logToClean.expectedCompactionEfficiency(), (double)0.001, (String)"Scheduling lag should use the min compaction efficiency value as threshold was met");
        Assertions.assertTrue((boolean)logToClean.cleanable(this.mockTime().milliseconds()), (String)"compaction efficiency should lead to cleanable log");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSchedulingLagMinCleanableRatio(boolean dirtyStartOffsetAlignedWithSegmentStartOffset) {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.mockTime_$eq((Time)new MockTime(0L, 0L));
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), this.buildSegs$default$2(), this.buildSegs$default$3(), this.buildSegs$default$4());
        Seq x$1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 30}));
        Seq x$2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{100L, 100L}));
        Seq<Object> x$4 = this.buildSegs$default$2();
        Seq<TierLogSegment> dirtySegs = this.buildSegs((Seq<Object>)x$1, x$4, (Seq<Object>)x$2, 41L);
        long baseOffsetOfFirstSeg = 41L;
        long compactDirtyStartOffset = dirtyStartOffsetAlignedWithSegmentStartOffset ? 41L : 42L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 60L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 200L, 250L);
        long tieredLogEndOffset = 100L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, dirtySegs, 100, 0, baseOffsetOfFirstSeg, tieredLogEndOffset, true);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        ConfluentLogConfig confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE));
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerMinCleanableRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)0.5));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.tierableLogSegments()).thenAnswer(x$6 -> (Iterable)package$.MODULE$.Iterable().apply((Seq)Nil$.MODULE$));
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        this.mockTime().sleep(301L);
        TierLogToClean logToClean = CompactionTask$.MODULE$.getTierLogToClean(log, this.mockTime(), this.mockTime().milliseconds());
        Assertions.assertEquals((long)40L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)60L, (long)logToClean.cleanableBytes());
        Assertions.assertEquals((double)0.6, (double)logToClean.cleanableRatio());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)logToClean.thresholdMaxCompactionDelayMs());
        CancellationContext ctx = CancellationContext.newContext();
        CompactionTask task = new CompactionTask(ctx.subContext(), topicIdPartition, this.offsetMapSupplier(), (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(0, (Option)None$.MODULE$), this.tierCompactionMetrics(), this.mockTime());
        task.maybeUpdateLogToClean(replicaManager, this.mockTime().milliseconds());
        Assertions.assertTrue((boolean)((TierLogToClean)task.logToClean().get()).cleanable(this.mockTime().milliseconds()), (String)"compaction ratio should lead to cleanable log");
        Mockito.when((Object)log.tieredLogSegments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), ArgumentMatchers.eq((long)(tieredLogEndOffset + 1L)))).thenAnswer(x$7 -> package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        task.maybeUpdateLogToClean(replicaManager, this.mockTime().milliseconds());
        Assertions.assertEquals((Object)new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(0))), (Object)((TierLogToClean)task.logToClean().get()).computedAtMaterializedOffset());
        Assertions.assertEquals((long)0L, (long)((TierLogToClean)task.logToClean().get()).cleanableBytes());
    }

    @Test
    public void testSchedulingLagMaxCompactionLagMs() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.mockTime_$eq((Time)new MockTime(0L, 0L));
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{100L, 100L}))), this.buildSegs$default$3(), this.buildSegs$default$4());
        Seq x$1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 30}));
        Seq x$2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{300L, 200L}));
        Seq<Object> x$4 = this.buildSegs$default$3();
        Seq<TierLogSegment> dirtySegs = this.buildSegs((Seq<Object>)x$1, (Seq<Object>)x$2, x$4, 41L);
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 60L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 200L, 250L);
        long tieredLogEndOffset = 100L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        ConfluentLogConfig confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logConfig.maxCompactionLagMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)300L));
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE));
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerMinCleanableRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)0.5));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.tierableLogSegments()).thenAnswer(x$8 -> (Iterable)package$.MODULE$.Iterable().apply((Seq)Nil$.MODULE$));
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        this.mockTime().sleep(501L);
        TierLogToClean logToClean = CompactionTask$.MODULE$.getTierLogToClean(log, this.mockTime(), this.mockTime().milliseconds());
        Assertions.assertEquals((long)40L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)60L, (long)logToClean.cleanableBytes());
        Assertions.assertEquals((double)0.6, (double)logToClean.cleanableRatio());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)logToClean.thresholdMaxCompactionDelayMs());
        Assertions.assertTrue((boolean)logToClean.cleanable(this.mockTime().milliseconds()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSchedulingLagMinCompactionLagMs(boolean hasCleanableBytes) {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.mockTime_$eq((Time)new MockTime(0L, 0L));
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), (Seq<Object>)Nil$.MODULE$, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{100L, 100L}))), this.buildSegs$default$4());
        Seq<TierLogSegment> dirtySegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 30}))), (Seq<Object>)Nil$.MODULE$, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{300L, 700L}))), 41L);
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 60L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 200L, 250L);
        long tieredLogEndOffset = 100L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)log.tieredLogSegments(ArgumentMatchers.eq((long)compactDirtyStartOffset), ArgumentMatchers.eq((long)71L))).thenAnswer(x$9 -> ((IterableOnce)dirtySegs.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TierLogCleanerManagerTest.$anonfun$testSchedulingLagMinCompactionLagMs$2(x$10)))).iterator());
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        ConfluentLogConfig confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        int minCompactionLagMs = hasCleanableBytes ? 200 : 250;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logConfig.compactionLagMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(minCompactionLagMs)));
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)0.3));
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerMinCleanableRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)0.6));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.tierableLogSegments()).thenAnswer(x$11 -> (Iterable)package$.MODULE$.Iterable().apply((Seq)Nil$.MODULE$));
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        this.mockTime().sleep(501L);
        Predef$.MODULE$.println((Object)log.topicPartition());
        TierLogToClean logToClean = CompactionTask$.MODULE$.getTierLogToClean(log, this.mockTime(), this.mockTime().milliseconds());
        Assertions.assertEquals((long)40L, (long)logToClean.cleanBytes());
        if (hasCleanableBytes) {
            Assertions.assertEquals((long)30L, (long)logToClean.cleanableBytes());
            Assertions.assertEquals((double)0.42, (double)logToClean.cleanableRatio(), (double)0.009);
            Assertions.assertEquals((long)71L, (long)logToClean.firstUncleanableOffset());
            Assertions.assertTrue((boolean)logToClean.cleanable(this.mockTime().milliseconds()));
            return;
        }
        Assertions.assertEquals((long)0L, (long)logToClean.cleanableBytes());
        Assertions.assertEquals((double)0.0, (double)logToClean.cleanableRatio(), (double)0.009);
        Assertions.assertEquals((long)41L, (long)logToClean.firstUncleanableOffset());
        Assertions.assertFalse((boolean)logToClean.cleanable(this.mockTime().milliseconds()));
    }

    @Test
    public void testSchedulingLagNonDirty() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.time()).thenReturn((Object)this.mockTime());
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), this.buildSegs$default$2(), this.buildSegs$default$3(), this.buildSegs$default$4());
        Nil$ dirtySegs = Nil$.MODULE$;
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 60L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 200L, 250L);
        long tieredLogEndOffset = 41L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, (Seq<TierLogSegment>)dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        ConfluentLogConfig confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logConfig.maxCompactionLagMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE));
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerMinCleanableRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)0.5));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.tierableLogSegments()).thenAnswer(x$12 -> (Iterable)package$.MODULE$.Iterable().apply((Seq)Nil$.MODULE$));
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        CancellationContext ctx = CancellationContext.newContext();
        CompactionTask task = new CompactionTask(ctx.subContext(), topicIdPartition, this.offsetMapSupplier(), (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(0, (Option)None$.MODULE$), this.tierCompactionMetrics(), this.mockTime());
        task.maybeUpdateLogToClean(replicaManager, this.mockTime().milliseconds());
        Assertions.assertFalse((boolean)((TierLogToClean)task.logToClean().get()).cleanable(this.mockTime().milliseconds()), (String)"No dirty bytes should result in non cleanable log");
    }

    @Test
    public void testSchedulingLagDeleteTopic() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("deleteTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logConfig.delete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logConfig.compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        CancellationContext ctx = CancellationContext.newContext();
        CompactionTask task = new CompactionTask(ctx.subContext(), topicIdPartition, this.offsetMapSupplier(), (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(0, (Option)None$.MODULE$), this.tierCompactionMetrics(), this.mockTime());
        task.maybeUpdateLogToClean(replicaManager, this.mockTime().milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)task.logToClean(), (String)"Scheduling lag of delete-retention partition should be None");
    }

    @Test
    public void testSchedulingLagNonTierCompactedTopic() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("nonCompactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logConfig.delete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logConfig.compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        CancellationContext ctx = CancellationContext.newContext();
        CompactionTask task = new CompactionTask(ctx.subContext(), topicIdPartition, this.offsetMapSupplier(), (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(0, (Option)None$.MODULE$), this.tierCompactionMetrics(), this.mockTime());
        task.maybeUpdateLogToClean(replicaManager, this.mockTime().milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)task.logToClean());
    }

    @Test
    public void testSchedulingLagOldTierableSegments() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.mockTime_$eq((Time)new MockTime(0L, 0L));
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{100L, 100L}))), this.buildSegs$default$3(), this.buildSegs$default$4());
        Seq x$1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 30}));
        Seq x$2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{300L, 200L}));
        Seq<Object> x$4 = this.buildSegs$default$3();
        Seq<TierLogSegment> dirtySegs = this.buildSegs((Seq<Object>)x$1, (Seq<Object>)x$2, x$4, 41L);
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 60L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 200L, 250L);
        long tieredLogEndOffset = 100L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        ConfluentLogConfig confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logConfig.maxCompactionLagMs())).thenReturn((Object)BoxesRunTime.boxToLong((long)300L));
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE));
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)confluentLogConfig.tierCleanerMinCleanableRatio())).thenReturn((Object)BoxesRunTime.boxToDouble((double)0.5));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        LogSegment tierableSeg = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)tierableSeg.lastFlushedTimeMs()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)400L)));
        Mockito.when((Object)log.tierableLogSegments()).thenAnswer(x$13 -> (Iterable)package$.MODULE$.Iterable().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{tierableSeg})));
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        this.mockTime().sleep(501L);
        TierLogToClean logToClean = CompactionTask$.MODULE$.getTierLogToClean(log, this.mockTime(), this.mockTime().milliseconds());
        Assertions.assertEquals((long)40L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)60L, (long)logToClean.cleanableBytes());
        Assertions.assertEquals((double)0.6, (double)logToClean.cleanableRatio());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)logToClean.thresholdMaxCompactionDelayMs());
        Assertions.assertFalse((boolean)logToClean.cleanable(this.mockTime().milliseconds()));
    }

    public static final /* synthetic */ ListBuffer $anonfun$buildSegs$1(Seq sizes$1, LongRef segBaseOffset$1, Seq firstBatchTimestamp$1, Seq maxTimestamp$1, ListBuffer segsList$1, int i) {
        TierLogSegment seg = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)seg.size())).thenReturn(sizes$1.apply(i - 1));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)seg.baseOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)segBaseOffset$1.elem));
        segBaseOffset$1.elem += (long)BoxesRunTime.unboxToInt((Object)sizes$1.apply(i - 1));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)seg.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)(segBaseOffset$1.elem - 1L)));
        if (firstBatchTimestamp$1.nonEmpty()) {
            Mockito.when((Object)BoxesRunTime.boxToLong((long)seg.firstBatchTimestamp())).thenReturn(firstBatchTimestamp$1.apply(i - 1));
        }
        if (maxTimestamp$1.nonEmpty()) {
            Mockito.when((Object)BoxesRunTime.boxToLong((long)seg.maxTimestamp())).thenReturn(maxTimestamp$1.apply(i - 1));
        }
        return (ListBuffer)segsList$1.append((Object)seg);
    }

    public static final /* synthetic */ boolean $anonfun$testSchedulingLagMinCompactionLagMs$2(TierLogSegment x$10) {
        return x$10.maxTimestamp() == 300L;
    }

    public TierLogCleanerManagerTest() {
        Time x$3 = this.mockTime();
        boolean x$4 = true;
        String x$5 = "throttler";
        String x$6 = "entries";
        this.throttler = new Throttler(2.147483647E9, Integer.MAX_VALUE, x$4, x$5, x$6, x$3);
        this.offsetMapSupplier = new OffsetMapSupplier(1, 0x100000);
        this.tierCompactionMetrics = new TierCompactionMetrics(new LogCleanerMetrics((Option)None$.MODULE$), (Option)None$.MODULE$);
    }
}

