/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.log.LogCleanerMetrics;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.StopLeadership;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.CompactionTaskQueue;
import kafka.tier.tasks.compaction.OffsetMapSupplier;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u0011#\u0001-BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013%q\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019q\u0005\u0001)A\u0005\u0003\"9q\n\u0001b\u0001\n\u0013\u0001\u0006B\u0002+\u0001A\u0003%\u0011\u000bC\u0004V\u0001\t\u0007I\u0011\u0001,\t\ru\u0003\u0001\u0015!\u0003X\u0011\u001dq\u0006A1A\u0005\u0002ACaa\u0018\u0001!\u0002\u0013\t\u0006b\u00021\u0001\u0005\u0004%\t!\u0019\u0005\u0007U\u0002\u0001\u000b\u0011\u00022\t\u000f-\u0004!\u0019!C\u0001!\"1A\u000e\u0001Q\u0001\nECq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001c\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011\u0011\u0002\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!A\u0011Q\u0003\u0001!\u0002\u0013\ty\u0001C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a!A\u0011\u0011\u0005\u0001!\u0002\u0013\tY\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002&!9\u0011q\t\u0001\u0005\u0002\u0005\u0015\u0002bBA&\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\ti\u0007\u0001C\u0005\u0003_B\u0011\"a&\u0001#\u0003%I!!'\t\u0013\u0005=\u0006!%A\u0005\n\u0005e\u0005\"CAY\u0001E\u0005I\u0011BAM\u0005]\u0019u.\u001c9bGRLwN\u001c+bg.\fV/Z;f)\u0016\u001cHO\u0003\u0002$I\u0005Q1m\\7qC\u000e$\u0018n\u001c8\u000b\u0005\u00152\u0013!\u0002;bg.\u001c(BA\u0014)\u0003\u0011!\u0018.\u001a:\u000b\u0003%\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001b\u0011\u0005U\u0002Q\"\u0001\u0012\u0002\u0007\r$\b0F\u00019!\tID(D\u0001;\u0015\tYd%A\u0004gKR\u001c\u0007.\u001a:\n\u0005uR$aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018\u0001B2uq\u0002\nA\u0001^5nKV\t\u0011\t\u0005\u0002C\u00196\t1I\u0003\u0002E\u000b\u0006)Q\u000f^5mg*\u0011aiR\u0001\u0007G>lWn\u001c8\u000b\u0005%B%BA%K\u0003\u0019\t\u0007/Y2iK*\t1*A\u0002pe\u001eL!!T\"\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\t[\u0006DH+Y:lgV\t\u0011\u000b\u0005\u0002.%&\u00111K\f\u0002\u0004\u0013:$\u0018!C7bqR\u000b7o[:!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035\"\naa]3sm\u0016\u0014\u0018B\u0001/Z\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\rS>\u0014UO\u001a4feNK'0Z\u0001\u000eS>\u0014UO\u001a4feNK'0\u001a\u0011\u0002\u0017]\u0014\u0018\u000e^3Ck\u001a4WM]\u000b\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0004]&|'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0012\u0014!BQ=uK\n+hMZ3s\u000319(/\u001b;f\u0005V4g-\u001a:!\u0003U1WM\\2fIN+w-\\3oiN$U\r\\1z\u001bN\faCZ3oG\u0016$7+Z4nK:$8\u000fR3mCfl5\u000fI\u0001\faJLwN]5us6\u000b\u0007/F\u0001p!\u0011\u0001Xo^>\u000e\u0003ET!A]:\u0002\u000f5,H/\u00192mK*\u0011AOL\u0001\u000bG>dG.Z2uS>t\u0017B\u0001<r\u0005\ri\u0015\r\u001d\t\u0003qfl\u0011AJ\u0005\u0003u\u001a\u0012\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\u0005Ub\u0018BA?#\u00059!\u0016.\u001a:M_\u001e$vn\u00117fC:\fA\u0002\u001d:j_JLG/_'ba\u0002\n\u0011c\u001c4gg\u0016$X*\u00199TkB\u0004H.[3s+\t\t\u0019\u0001E\u00026\u0003\u000bI1!a\u0002#\u0005EyeMZ:fi6\u000b\u0007oU;qa2LWM]\u0001\u0013_\u001a47/\u001a;NCB\u001cV\u000f\u001d9mS\u0016\u0014\b%A\u000buS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8NKR\u0014\u0018nY:\u0016\u0005\u0005=\u0001cA\u001b\u0002\u0012%\u0019\u00111\u0003\u0012\u0003+QKWM]\"p[B\f7\r^5p]6+GO]5dg\u00061B/[3s\u0007>l\u0007/Y2uS>tW*\u001a;sS\u000e\u001c\b%A\nd_6\u0004\u0018m\u0019;j_:$\u0016m]6Rk\u0016,X-\u0006\u0002\u0002\u001cA\u0019Q'!\b\n\u0007\u0005}!EA\nD_6\u0004\u0018m\u0019;j_:$\u0016m]6Rk\u0016,X-\u0001\u000bd_6\u0004\u0018m\u0019;j_:$\u0016m]6Rk\u0016,X\rI\u0001\u0015i\u0016\u001cH\u000fU8mYR\u000b7o[(sI\u0016\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0002cA\u0017\u0002*%\u0019\u00111\u0006\u0018\u0003\tUs\u0017\u000e\u001e\u0015\u00041\u0005=\u0002\u0003BA\u0019\u0003\u007fi!!a\r\u000b\t\u0005U\u0012qG\u0001\u0004CBL'\u0002BA\u001d\u0003w\tqA[;qSR,'OC\u0002\u0002>)\u000bQA[;oSRLA!!\u0011\u00024\t!A+Z:u\u0003m!Xm\u001d;BI\u0012\u0014V\r\u001d7bG\u0016\u001cX\t_5ti&tw\rV1tW\"\u001a\u0011$a\f\u0002\u001dQ,7\u000f\u001e*f[>4X\rV1tW\"\u001a!$a\f\u00021Q,7\u000f\u001e)pY2$\u0016m]6t\u001b>\u0014X\r\u00165b]6\u000b\u0007\u0010K\u0002\u001c\u0003_\tAb]2iK\u0012,H.\u001b8h\r:$b!a\u0015\u0002Z\u0005\r\u0004\u0003B\u0017\u0002VmL1!a\u0016/\u0005\u0019y\u0005\u000f^5p]\"9\u00111\f\u000fA\u0002\u0005u\u0013\u0001\u0002;bg.\u00042!NA0\u0013\r\t\tG\t\u0002\u000f\u0007>l\u0007/Y2uS>tG+Y:l\u0011\u001d\t)\u0007\ba\u0001\u0003O\n1A\\8x!\ri\u0013\u0011N\u0005\u0004\u0003Wr#\u0001\u0002'p]\u001e\f1\"\u001e9eCR,'+\u0019;j_R\u0011\u0012qEA9\u0003k\ny(a!\u0002\b\u0006-\u0015qRAJ\u0011\u0019\t\u0019(\ba\u0001o\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003oj\u0002\u0019AA=\u0003=)gMZ5dS\u0016t7-\u001f*bi&|\u0007cA\u0017\u0002|%\u0019\u0011Q\u0010\u0018\u0003\r\u0011{WO\u00197f\u0011\u001d\t\t)\ba\u0001\u0003s\n!#\\5o\u000b\u001a4\u0017nY5f]\u000eL(+\u0019;j_\"9\u0011QQ\u000fA\u0002\u0005e\u0014AD2mK\u0006t\u0017M\u00197f%\u0006$\u0018n\u001c\u0005\b\u0003\u0013k\u0002\u0019AA=\u0003Ei\u0017N\\\"mK\u0006t\u0017M\u00197f%\u0006$\u0018n\u001c\u0005\n\u0003\u001bk\u0002\u0013!a\u0001\u0003O\n1$Z1sY&,7\u000f\u001e$jeN$()\u0019;dQRKW.Z:uC6\u0004\b\"CAI;A\u0005\t\u0019AA4\u00035\u0019w.\u001c9bGRLwN\u001c'bO\"I\u0011QS\u000f\u0011\u0002\u0003\u0007\u0011qM\u0001\u0011[\u0006D8i\\7qC\u000e$\u0018n\u001c8MC\u001e\fQ#\u001e9eCR,'+\u0019;j_\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u001c*\"\u0011qMAOW\t\ty\n\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\u0013Ut7\r[3dW\u0016$'bAAU]\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00161\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!F;qI\u0006$XMU1uS>$C-\u001a4bk2$HeN\u0001\u0016kB$\u0017\r^3SCRLw\u000e\n3fM\u0006,H\u000e\u001e\u00139\u0001")
public class CompactionTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final Time time = new MockTime();
    private final int maxTasks;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final int ioBufferSize;
    private final ByteBuffer writeBuffer = ByteBuffer.allocate(this.ioBufferSize());
    private final int fencedSegmentsDelayMs;
    private final Map<TopicIdPartition, TierLogToClean> priorityMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final OffsetMapSupplier offsetMapSupplier = new OffsetMapSupplier(1, 0x100000);
    private final TierCompactionMetrics tierCompactionMetrics = new TierCompactionMetrics(new LogCleanerMetrics((Option)None$.MODULE$), (Option)None$.MODULE$);
    private final CompactionTaskQueue compactionTaskQueue = new CompactionTaskQueue(this.ctx(), this.maxTasks(), this.time(), (Function2 & Serializable)(task, now) -> CompactionTaskQueueTest.$anonfun$compactionTaskQueue$1(this, task, BoxesRunTime.unboxToLong((Object)now)), this.offsetMapSupplier(), this.tierCompactionMetrics());

    private CancellationContext ctx() {
        return this.ctx;
    }

    private Time time() {
        return this.time;
    }

    private int maxTasks() {
        return this.maxTasks;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public int ioBufferSize() {
        return this.ioBufferSize;
    }

    public ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    public int fencedSegmentsDelayMs() {
        return this.fencedSegmentsDelayMs;
    }

    private Map<TopicIdPartition, TierLogToClean> priorityMap() {
        return this.priorityMap;
    }

    private OffsetMapSupplier offsetMapSupplier() {
        return this.offsetMapSupplier;
    }

    private TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    private CompactionTaskQueue compactionTaskQueue() {
        return this.compactionTaskQueue;
    }

    @Test
    public void testPollTaskOrdering() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TopicIdPartition partition_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        TopicIdPartition partition_6 = new TopicIdPartition("foo-6", UUID.randomUUID(), 0);
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_5, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_6, 0));
        this.updateRatio(partition_1, 0.15, 0.1, 0.1, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.updateRatio(partition_2, 0.25, 0.1, 0.1, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.updateRatio(partition_3, 0.3, 0.5, 0.8, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.updateRatio(partition_4, 0.35, 0.5, 0.7, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.updateRatio(partition_5, 0.0, 0.5, 0.0, 0.75, 101L, 0L, 100L);
        this.updateRatio(partition_6, 0.0, 0.5, 0.0, 0.75, 101L, 1000L, Long.MAX_VALUE);
        List tasks = (List)this.compactionTaskQueue().poll().get();
        Assertions.assertEquals((Object)new .colon.colon((Object)partition_5, (List)new .colon.colon((Object)partition_2, (List)new .colon.colon((Object)partition_1, (List)new .colon.colon((Object)partition_3, (List)Nil$.MODULE$)))), (Object)tasks.map((Function1 & Serializable)x$1 -> x$1.topicIdPartition()));
    }

    @Test
    public void testAddReplacesExistingTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 1));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 2));
        this.compactionTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$1(partition_1, partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(partition_1));
        this.compactionTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            CompactionTaskQueueTest.$anonfun$testRemoveTask$1(partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
        this.compactionTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(partition_3));
        this.compactionTaskQueue().withAllTasks((Function1 & Serializable)tasks -> {
            CompactionTaskQueueTest.$anonfun$testRemoveTask$3(partition_2, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPollTasksMoreThanMax() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TopicIdPartition partition_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        TopicIdPartition partition_6 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_5, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_6, 0));
        this.updateRatio(partition_1, 0.6, 0.5, 0.1, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.updateRatio(partition_2, 0.7, 0.5, 0.1, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.updateRatio(partition_3, 0.8, 0.5, 0.1, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.updateRatio(partition_4, 0.9, 0.5, 0.1, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.updateRatio(partition_5, 0.95, 0.5, 0.1, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.updateRatio(partition_6, 0.97, 0.5, 0.1, 0.75, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_5, 0));
        this.compactionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_6, 0));
        Assertions.assertEquals((Object)new .colon.colon((Object)partition_6, (List)new .colon.colon((Object)partition_5, (List)new .colon.colon((Object)partition_4, (List)new .colon.colon((Object)partition_3, (List)new .colon.colon((Object)partition_2, (List)Nil$.MODULE$))))), (Object)((List)this.compactionTaskQueue().poll().get()).map((Function1 & Serializable)x$8 -> x$8.topicIdPartition()));
    }

    private Option<TierLogToClean> schedulingFn(CompactionTask task, long now) {
        return this.priorityMap().get((Object)task.topicIdPartition());
    }

    private void updateRatio(TopicIdPartition topicIdPartition, double efficiencyRatio, double minEfficiencyRatio, double cleanableRatio, double minCleanableRatio, long earliestFirstBatchTimestamp, long compactionLag, long maxCompactionLag) {
        this.priorityMap().update((Object)topicIdPartition, (Object)TierTestUtils$.MODULE$.tierLogToClean(topicIdPartition, this.time(), efficiencyRatio, minEfficiencyRatio, cleanableRatio, minCleanableRatio, earliestFirstBatchTimestamp, compactionLag, maxCompactionLag));
    }

    private long updateRatio$default$6() {
        return Long.MIN_VALUE;
    }

    private long updateRatio$default$7() {
        return 0L;
    }

    private long updateRatio$default$8() {
        return Long.MAX_VALUE;
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$2(TopicIdPartition partition_1$1, CompactionTask x$2) {
        TopicIdPartition topicIdPartition = x$2.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_1$1) : partition_1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$3(TopicIdPartition partition_2$1, CompactionTask x$3) {
        TopicIdPartition topicIdPartition = x$3.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_2$1) : partition_2$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$4(TopicIdPartition partition_3$1, CompactionTask x$4) {
        TopicIdPartition topicIdPartition = x$4.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_3$1) : partition_3$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$5(TopicIdPartition partition_4$1, CompactionTask x$5) {
        TopicIdPartition topicIdPartition = x$5.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_4$1) : partition_4$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testAddReplacesExistingTask$1(TopicIdPartition partition_1$1, TopicIdPartition partition_2$1, TopicIdPartition partition_3$1, TopicIdPartition partition_4$1, Set tasks) {
        Assertions.assertEquals((int)1, (int)((CompactionTask)tasks.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$2(partition_1$1, x$2))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((CompactionTask)tasks.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$3(partition_2$1, x$3))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)2, (int)((CompactionTask)tasks.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$4(partition_3$1, x$4))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((CompactionTask)tasks.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueueTest.$anonfun$testAddReplacesExistingTask$5(partition_4$1, x$5))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)4, (int)tasks.size());
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$1(TopicIdPartition partition_2$2, TopicIdPartition partition_3$2, TopicIdPartition partition_4$2, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$2, partition_3$2, partition_4$2})), (Object)tasks.map((Function1 & Serializable)x$6 -> x$6.topicIdPartition()));
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$3(TopicIdPartition partition_2$2, TopicIdPartition partition_4$2, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$2, partition_4$2})), (Object)tasks.map((Function1 & Serializable)x$7 -> x$7.topicIdPartition()));
    }

    public CompactionTaskQueueTest() {
        this.maxTasks = 5;
        this.ioBufferSize = 1024;
        this.fencedSegmentsDelayMs = 61000;
    }
}

