/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.UploadableSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015f\u0001B\u001e=\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004W\u0001\u0001\u0006IA\u0015\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019\t\u0007\u0001)A\u00053\"9!\r\u0001a\u0001\n\u0003\u0019\u0007b\u00026\u0001\u0001\u0004%\ta\u001b\u0005\u0007c\u0002\u0001\u000b\u0015\u00023\t\u000fI\u0004\u0001\u0019!C\u0001g\"9!\u0010\u0001a\u0001\n\u0003Y\bBB?\u0001A\u0003&A\u000fC\u0004\u007f\u0001\u0001\u0007I\u0011A@\t\u0013\u00055\u0001\u00011A\u0005\u0002\u0005=\u0001\u0002CA\n\u0001\u0001\u0006K!!\u0001\t\u0013\u0005U\u0001\u00011A\u0005\u0002\u0005]\u0001\"CA\u0013\u0001\u0001\u0007I\u0011AA\u0014\u0011!\tY\u0003\u0001Q!\n\u0005e\u0001\"CA\u0017\u0001\u0001\u0007I\u0011AA\u0018\u0011%\ti\u0004\u0001a\u0001\n\u0003\ty\u0004\u0003\u0005\u0002D\u0001\u0001\u000b\u0015BA\u0019\u0011%\t)\u0005\u0001a\u0001\n\u0003\t9\u0005C\u0005\u0002d\u0001\u0001\r\u0011\"\u0001\u0002f!A\u0011\u0011\u000e\u0001!B\u0013\tI\u0005C\u0005\u0002l\u0001\u0001\r\u0011\"\u0001\u0002n!I\u0011q\u0010\u0001A\u0002\u0013\u0005\u0011\u0011\u0011\u0005\t\u0003\u000b\u0003\u0001\u0015)\u0003\u0002p!I\u0011q\u0011\u0001C\u0002\u0013\u0005\u0011\u0011\u0012\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u0002\f\"I\u00111\u0013\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003?\u0003\u0001\u0015!\u0003\u0002\u0018\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBA^\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003\u000b\u0004A\u0011AAR\u0011\u001d\ty\r\u0001C\u0001\u0003GCq!a5\u0001\t\u0003\t\u0019\u000bC\u0004\u0002X\u0002!\t!a)\t\u000f\u0005m\u0007\u0001\"\u0001\u0002$\"9\u0011q\u001c\u0001\u0005\u0002\u0005\r\u0006bBAr\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003O\u0004A\u0011AAR\u0011\u001d\tY\u000f\u0001C\u0001\u0003GCq!a<\u0001\t\u0003\t\u0019\u000bC\u0004\u0002t\u0002!\t!a)\t\u000f\u0005]\b\u0001\"\u0001\u0002$\"9\u00111 \u0001\u0005\u0002\u0005\r\u0006bBA\u0000\u0001\u0011\u0005\u00111\u0015\u0005\b\u0005\u0007\u0001A\u0011AAR\u0011\u001d\u00119\u0001\u0001C\u0001\u0003GCqAa\u0003\u0001\t\u0003\t\u0019\u000bC\u0004\u0003\u0010\u0001!\t!a)\t\u000f\tM\u0001\u0001\"\u0001\u0002$\"9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u001a\u0001\u0011%!Q\u0007\u0005\b\u0005'\u0002A\u0011\u0002B+\u0011\u001d\u0011i\u0006\u0001C\u0005\u0005?BqAa\u001c\u0001\t\u0013\u0011\t\bC\u0004\u0003\u0004\u0002!IA!\"\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\ny\u0011I]2iSZ,G+Y:l)\u0016\u001cHO\u0003\u0002>}\u00059\u0011M]2iSZ,'BA A\u0003\u0015!\u0018m]6t\u0015\t\t%)\u0001\u0003uS\u0016\u0014(\"A\"\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0005CA(\u0001\u001b\u0005a\u0014\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o+\u0005\u0011\u0006CA*U\u001b\u0005\u0001\u0015BA+A\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\u0002\n\u0001\u0003Z3gCVdG/Q<bSR$\u0016.\\3\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u0011\u0011,(/\u0019;j_:T!A\u0018%\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002a7\nqa)\u001b8ji\u0016$UO]1uS>t\u0017!\u00053fM\u0006,H\u000e^!xC&$H+[7fA\u0005\u00191\r\u001e=\u0016\u0003\u0011\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a!\u0002\u000f\u0019,Go\u00195fe&\u0011\u0011N\u001a\u0002\u0014\u0007\u0006t7-\u001a7mCRLwN\\\"p]R,\u0007\u0010^\u0001\bGRDx\fJ3r)\taw\u000e\u0005\u0002H[&\u0011a\u000e\u0013\u0002\u0005+:LG\u000fC\u0004q\u000f\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0013'\u0001\u0003dib\u0004\u0013\u0001\u0005;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s+\u0005!\bCA;y\u001b\u00051(BA<A\u0003\u0015!x\u000e]5d\u0013\tIhO\u0001\tUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u0006!B/[3s)>\u0004\u0018nY'b]\u0006<WM]0%KF$\"\u0001\u001c?\t\u000fAT\u0011\u0011!a\u0001i\u0006\tB/[3s)>\u0004\u0018nY'b]\u0006<WM\u001d\u0011\u0002\u001fQLWM](cU\u0016\u001cGo\u0015;pe\u0016,\"!!\u0001\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002A\u0003\u0015\u0019Ho\u001c:f\u0013\u0011\tY!!\u0002\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\f1\u0003^5fe>\u0013'.Z2u'R|'/Z0%KF$2\u0001\\A\t\u0011!\u0001X\"!AA\u0002\u0005\u0005\u0011\u0001\u0005;jKJ|%M[3diN#xN]3!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\bC\u0003\u0019\u0019XM\u001d<fe&!\u00111EA\u000f\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR\u0019A.!\u000b\t\u0011A\u0004\u0012\u0011!a\u0001\u00033\tqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\na\u0006\u0014H/\u001b;j_:,\"!!\r\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000eC\u0003\u001d\u0019G.^:uKJLA!a\u000f\u00026\tI\u0001+\u0019:uSRLwN\\\u0001\u000ea\u0006\u0014H/\u001b;j_:|F%Z9\u0015\u00071\f\t\u0005\u0003\u0005q'\u0005\u0005\t\u0019AA\u0019\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u0005i&lW-\u0006\u0002\u0002JA!\u00111JA0\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!B;uS2\u001c(\u0002BA*\u0003+\naaY8n[>t'bA\"\u0002X)!\u0011\u0011LA.\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QL\u0001\u0004_J<\u0017\u0002BA1\u0003\u001b\u0012A\u0001V5nK\u0006AA/[7f?\u0012*\u0017\u000fF\u0002m\u0003OB\u0001\u0002\u001d\f\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0006i&lW\rI\u0001\bi6\u0004h)\u001b7f+\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0005%|'BAA=\u0003\u0011Q\u0017M^1\n\t\u0005u\u00141\u000f\u0002\u0005\r&dW-A\u0006u[B4\u0015\u000e\\3`I\u0015\fHc\u00017\u0002\u0004\"A\u0001/GA\u0001\u0002\u0004\ty'\u0001\u0005u[B4\u0015\u000e\\3!\u0003!\u0011'o\\6fe&#WCAAF!\r9\u0015QR\u0005\u0004\u0003\u001fC%aA%oi\u0006I!M]8lKJLE\rI\u0001\u0010i&,'\u000fV1tWN\u001cuN\u001c4jOV\u0011\u0011q\u0013\t\u0005\u00033\u000bY*D\u0001?\u0013\r\tiJ\u0010\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\u0006\u0001B/[3s)\u0006\u001c8n]\"p]\u001aLw\rI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002Y\"\u001aq$a*\u0011\t\u0005%\u0016qW\u0007\u0003\u0003WSA!!,\u00020\u0006\u0019\u0011\r]5\u000b\t\u0005E\u00161W\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t),a\u0017\u0002\u000b),h.\u001b;\n\t\u0005e\u00161\u0016\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007\u0001\ny\f\u0005\u0003\u0002*\u0006\u0005\u0017\u0002BAb\u0003W\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f^#ti\u0006\u0014G.[:iS:<G*Z1eKJ\u001c\b.\u001b9)\u0007\u0005\nI\r\u0005\u0003\u0002*\u0006-\u0017\u0002BAg\u0003W\u0013A\u0001V3ti\u0006YB/Z:u)&,'oU3h[\u0016tG/\u00138wC2LG-\u00129pG\"D3AIAe\u0003q!Xm\u001d;NKR\fG-\u0019;b'&TX\rR;sS:<W\u000b\u001d7pC\u0012D3aIAe\u0003M!Xm\u001d;SKR\u0014\u0018\u0010U;u'\u0016<W.\u001a8uQ\r!\u0013\u0011Z\u0001\u001ci\u0016\u001cH/T3uC\u0012\fG/Y*ju\u0016\fe\r^3s+Bdw.\u00193)\u0007\u0015\nI-A\u0011uKN$X\t_2faRLwN\u001c#ve&tw-\u00138ji&\fG/Z+qY>\fG\rK\u0002'\u0003\u0013\fq\u0007^3ti\u0016C8-\u001a9uS>tG)\u001e:j]\u001eLe.\u001b;jCR,W\u000b\u001d7pC\u0012<\u0006.\u001a8QCJ$\u0018\u000e^5p]&\u001bXK\\2mK\u0006t\u0007fA\u0014\u0002J\u0006!D/Z:u\u000bb\u001cW\r\u001d;j_:$UO]5oO&s\u0017\u000e^5bi\u0016,\u0006\u000f\\8bI^CWM\u001c+jKJLgn\u001a#jg\u0006\u0014G.\u001a3)\u0007!\nI-\u0001\u0010uKN$8+Z4nK:$H)\u001a7fi\u0016$G)\u001e:j]\u001e,\u0006\u000f\\8bI\"\u001a\u0011&!3\u0002IQ,7\u000f^!sG\"Lg/\u001a+bg.\u001c\u0015M\\2fY2,GMQ3g_J,W\u000b\u001d7pC\u0012D3AKAe\u0003\u0001\"Xm\u001d;V].twn\u001e8Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h+Bdw.\u00193)\u0007-\nI-A\ruKN$H+[3s'\u0016<W.\u001a8u\u001d>\u001cVmZ7f]R\u001c\bf\u0001\u0017\u0002J\u00061C/Z:u)&,'oU3h[\u0016tGoV5uQ>,H\u000fT3bI\u0016\u0014X\t]8dQN#\u0018\r^3)\u00075\nI-A\u0012uKN$H+[3s'\u0016<W.\u001a8u/&$\b\u000eT3bI\u0016\u0014X\t]8dQN#\u0018\r^3)\u00079\nI-\u0001\u0011uKN$\u0018I]2iSZ,'\u000fV1tWN+Go\u001d)bkN,wJ\u001c*fiJL\bfA\u0018\u0002J\u00069C/Z:u\u0007\u0006t7-\u001a7mK\u0012\f%o\u00195jm\u0016$\u0016m]6E_\u0016\u001chj\u001c;Qe><'/Z:tQ\r\u0001\u0014\u0011Z\u0001\"i\u0016\u001cH\u000fS1oI2,7+Z4nK:$H)\u001a7fi\u0016$W\t_2faRLwN\u001c\u0015\u0004c\u0005%\u0017A\u000e;fgRD\u0015M\u001c3mS:<gi\u001c:TK\u001elWM\u001c;EK2,G/\u001a3Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h)J\fgn]5uS>t\u0007f\u0001\u001a\u0002J\u0006AC/Z:u%\u0016$(/[1cY\u0016,\u0005pY3qi&|gNR3uG\"LgnZ(qCF,X\rR1uC\"\u001a1'!3\u0002GQ,7\u000f^%oSRL\u0017\r^3Va2|\u0017\rZ,ji\",fn\u00197fC:dU-\u00193feR!!1\u0004B\u0015!\u0019\u0011iBa\b\u0003$5\tQ,C\u0002\u0003\"u\u0013aAR;ukJ,\u0007cA(\u0003&%\u0019!q\u0005\u001f\u0003!\u0005\u00138\r[5wKR\u000b7o[*uCR,\u0007b\u0002B\u0016i\u0001\u0007!QF\u0001\u000ek:\u001cG.Z1o\u0019\u0016\fG-\u001a:\u0011\u0007\u001d\u0013y#C\u0002\u00032!\u0013qAQ8pY\u0016\fg.A\u0015uKN$X\t_2faRLwN\u001c%b]\u0012d\u0017N\\4EkJLgnZ%oSRL\u0017\r^3Va2|\u0017\r\u001a\u000b\u0005\u00057\u00119\u0004C\u0004\u0003:U\u0002\rAa\u000f\u0002\u0003\u0015\u0004BA!\u0010\u0003N9!!q\bB%\u001d\u0011\u0011\tEa\u0012\u000e\u0005\t\r#b\u0001B#\t\u00061AH]8pizJ\u0011!S\u0005\u0004\u0005\u0017B\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005\u001f\u0012\tFA\u0005Fq\u000e,\u0007\u000f^5p]*\u0019!1\n%\u0002CQ,7\u000f^#yG\u0016\u0004H/[8o\u0011\u0006tG\r\\5oO\u0012+(/\u001b8h+Bdw.\u00193\u0015\r\tm!q\u000bB-\u0011\u001d\u0011ID\u000ea\u0001\u0005wAqAa\u00177\u0001\u0004\u0011i#A\u0007eK2,G/Z*fO6,g\u000e^\u0001\u000f[>\u001c7\u000eT8h'\u0016<W.\u001a8u)\u0011\u0011\tG!\u001c\u0011\t\t\r$\u0011N\u0007\u0003\u0005KR1Aa\u001aC\u0003\rawnZ\u0005\u0005\u0005W\u0012)G\u0001\u0006M_\u001e\u001cVmZ7f]RDq!a\u001b8\u0001\u0004\ty'\u0001\fn_\u000e\\G+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\u0011\u0011\u0019Ha \u0011\t\tU$1P\u0007\u0003\u0005oR1A!\u001fA\u0003\u0015\u0019H/\u0019;f\u0013\u0011\u0011iHa\u001e\u0003%QKWM\u001d)beRLG/[8o'R\fG/\u001a\u0005\b\u0005\u0003C\u0004\u0019AAF\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0002\u001f5|7m[!cgR\u0014\u0018m\u0019;M_\u001e$BAa\"\u0003\u000eB!!1\rBE\u0013\u0011\u0011YI!\u001a\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u0005\u001fK\u0004\u0019\u0001B1\u0003)awnZ*fO6,g\u000e^\u0001\fi&,'oU3h[\u0016tG\u000f\u0006\u0004\u0003\u0016\n\u0005&1\u0015\t\u0005\u0005/\u0013i*\u0004\u0002\u0003\u001a*\u0019!1\u0014!\u0002\r\u0011|W.Y5o\u0013\u0011\u0011yJ!'\u0003%QKWM](cU\u0016\u001cG/T3uC\u0012\fG/\u0019\u0005\b\u0005OR\u0004\u0019\u0001BD\u0011\u001d\u0011\tI\u000fa\u0001\u0003\u0017\u0003")
public class ArchiveTaskTest {
    private final TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("cbf4eaed-cc00-47dc-b08c-f1f5685f085d"), 0);
    private final FiniteDuration defaultAwaitTime = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
    private CancellationContext ctx = CancellationContext.newContext();
    private TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private Partition partition = (Partition)Mockito.mock(Partition.class);
    private Time time = new MockTime();
    private File tmpFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
    private final int brokerId;
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, this.brokerId(), 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public FiniteDuration defaultAwaitTime() {
        return this.defaultAwaitTime;
    }

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(TierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public File tmpFile() {
        return this.tmpFile;
    }

    public void tmpFile_$eq(File x$1) {
        this.tmpFile = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    @BeforeEach
    public void setup() {
        this.tmpFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
    }

    @AfterEach
    public void tearDown() {
        this.tmpFile().delete();
        this.ctx().cancel();
        Mockito.reset((Object[])new Object[]{this.tierTopicManager(), this.tierObjectStore(), this.replicaManager()});
    }

    @Test
    public void testEstablishingLeadership() {
        int leaderEpoch = 0;
        ArgumentCaptor metadataCaptor = ArgumentCaptor.forClass(TierTopicInitLeader.class);
        org.apache.kafka.raft.OffsetAndEpoch topicCreationOffsetAndEpoch = new org.apache.kafka.raft.OffsetAndEpoch(100L, 1);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        BeforeUpload nextState = (BeforeUpload)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)new BeforeUpload(leaderEpoch), (Object)nextState, (String)"Expected task to establish leadership");
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager())).addMetadata((AbstractTierMetadata)metadataCaptor.capture());
        Assertions.assertEquals(Optional.empty(), (Object)((TierTopicInitLeader)metadataCaptor.getValue()).partitionCreationOffsetAndEpoch());
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)new Some((Object)topicCreationOffsetAndEpoch));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        BeforeUpload validOffsetResult = (BeforeUpload)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)new BeforeUpload(leaderEpoch), (Object)validOffsetResult, (String)"Expected task to establish leadership");
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.atLeast((int)1))).addMetadata((AbstractTierMetadata)metadataCaptor.capture());
        Assertions.assertEquals(Optional.of(topicCreationOffsetAndEpoch), (Object)((TierTopicInitLeader)metadataCaptor.getValue()).partitionCreationOffsetAndEpoch());
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.NOT_TIERABLE));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed(new Object()));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
    }

    @Test
    public void testTierSegmentInvalidEpoch() {
        int leaderEpoch = 0;
        TierPartitionState tps = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch + 1))).getMock();
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tps);
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)nextState, (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected segment tiering to fail due to fencing");
    }

    @Test
    public void testMetadataSizeDuringUpload() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        int epochStateSize = 100;
        long producerStateSize = 2000000000L;
        int abortedTxnsLimit = 150;
        int abortedTxnsPos = 50;
        long expectedSize = (long)(logSegment.size() + epochStateSize) + producerStateSize + (long)(abortedTxnsLimit - abortedTxnsPos);
        ByteBuffer epochState = ByteBuffer.wrap(new byte[epochStateSize]);
        File producerState = (File)Mockito.mock(File.class);
        ByteBuffer abortedTxns = ByteBuffer.wrap(new byte[abortedTxnsLimit]);
        abortedTxns.limit(abortedTxnsLimit);
        abortedTxns.position(abortedTxnsPos);
        Some epochStateOpt = new Some((Object)epochState);
        Some producerStateOpt = new Some((Object)producerState);
        Some abortedTxnsOpt = new Some((Object)abortedTxns);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)producerState.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)producerState.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)producerStateSize));
        ((TierObjectStore)Mockito.doNothing().when((Object)this.tierObjectStore())).putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value");
        Assertions.assertTrue((afterUpload.uploadedSize() > 0L ? 1 : 0) != 0, (String)"metadata size of AfterUpload object is negative and overflowed");
    }

    @Test
    public void testRetryPutSegment() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.ZEROED);
        MockInMemoryTierObjectStore inMemoryTierObjectStore = new MockInMemoryTierObjectStore(this.time(), new MockInMemoryTierObjectStoreConfig());
        int epochStateSize = 100;
        long producerStateSize = 0L;
        int abortedTxnsLimit = 150;
        int abortedTxnsPos = 50;
        long expectedSize = (long)(logSegment.size() + epochStateSize) + producerStateSize + (long)(abortedTxnsLimit - abortedTxnsPos);
        ByteBuffer epochState = ByteBuffer.wrap(new byte[epochStateSize]);
        File producerState = this.tmpFile();
        ByteBuffer abortedTxns = ByteBuffer.wrap(new byte[abortedTxnsLimit]);
        abortedTxns.limit(abortedTxnsLimit);
        abortedTxns.position(abortedTxnsPos);
        Some epochStateOpt = new Some((Object)epochState);
        Some producerStateOpt = new Some((Object)producerState);
        Some abortedTxnsOpt = new Some((Object)abortedTxns);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), (TierObjectStore)inMemoryTierObjectStore, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value");
        Assertions.assertTrue((afterUpload.uploadedSize() > 0L ? 1 : 0) != 0, (String)"metadata size of AfterUpload object is negative and overflowed");
        Assertions.assertEquals((int)abortedTxnsPos, (int)abortedTxns.position());
        Assertions.assertEquals((int)0, (int)epochState.position());
        UploadableSegment uploadableSegment2 = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload2 = new Upload(leaderEpoch, uploadInitiate, uploadableSegment2);
        Future uploadResult2 = ArchiveTask$.MODULE$.upload(upload2, this.topicIdPartition(), this.time(), this.ctx(), (TierObjectStore)inMemoryTierObjectStore, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload2 = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult2, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload2.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value after second retried upload");
    }

    @Test
    public void testMetadataSizeAfterUpload() {
        int testUploadSize = 400;
        String metricName = "BytesPerSec";
        new KafkaMetricsGroup(this.getClass()).removeMetric(metricName);
        Meter byteRate = new KafkaMetricsGroup(this.getClass()).newMeter(metricName, "bytes per second", TimeUnit.SECONDS);
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        AfterUpload afterUpload = new AfterUpload(0, uploadInitiate, (long)testUploadSize);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)new Some((Object)byteRate), ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)testUploadSize, (long)byteRate.count(), (String)"tier archiver mean rate shows no data uploaded to tiered storage");
    }

    @Test
    public void testExceptionDuringInitiateUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringInitiateUpload(new IllegalStateException("illegal state"));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
    }

    @Test
    public void testExceptionDuringInitiateUploadWhenPartitionIsUnclean() {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result(this.testInitiateUploadWithUncleanLeader(true), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(66).append("Unexpected transition to next state ").append(state.toString()).append(" when partition needs recovery").toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierMetadataRetriableException.class, ex.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex.getMessage().contains("is undergoing unclean leader recovery"), (String)"Unexpected cause for exception");
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result(this.testInitiateUploadWithUncleanLeader(false), (Duration)this.defaultAwaitTime()));
        if (try_2 instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_2).value();
            Assertions.assertEquals(Upload.class, state.getClass(), (String)"Unexpected next state");
            return;
        }
        if (try_2 instanceof Failure) {
            Throwable ex2 = ((Failure)try_2).exception();
            throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex2).toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        }
        throw new MatchError((Object)try_2);
    }

    @Test
    public void testExceptionDuringInitiateUploadWhenTieringDisabled() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, 100L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.empty());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Future maybeInitUploadState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)maybeInitUploadState, (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(72).append("Unexpected transition to next state ").append(state.toString()).append(" when partition has tiering disabled").toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            Assertions.assertEquals(NotTierablePartitionException.class, ex.getClass(), (String)"Unexpected exception");
            return;
        }
        throw new MatchError((Object)try_);
    }

    @Test
    public void testSegmentDeletedDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new NoSuchFileException("segment deleted"), true);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
    }

    @Test
    public void testArchiveTaskCancelledBeforeUpload() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), false, false, false, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        this.ctx().cancel();
        Future nextState = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (AfterUpload)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(TierArchiverFencedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
    }

    @Test
    public void testUnknownExceptionDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new IllegalStateException("illegal state"), false);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
    }

    @Test
    public void testTierSegmentNoSegments() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AbstractLog emptyLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)emptyLog.tierableLogSegments()).thenReturn((Object)CollectionConverters$.MODULE$.ListHasAsScala(Collections.emptyList()).asScala()).getMock();
        Partition partition = (Partition)Mockito.when((Object)((Partition)Mockito.mock(Partition.class)).log()).thenReturn((Object)new Some((Object)emptyLog)).getMock();
        Mockito.when((Object)emptyLog.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)emptyLog));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()) instanceof BeforeUpload), (String)"Expected segment tiering to complete successfully, but not progress to AfterUpload");
    }

    @Test
    public void testTierSegmentWithoutLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = this.mockTierPartitionState(leaderEpoch);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(Optional.empty());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)Nil$.MODULE$);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        TierObjectMetadata metadata = this.tierSegment(log, leaderEpoch);
        Assertions.assertEquals((long)metadata.baseOffset(), (long)0L, (String)"expected start offset to be 0");
        Assertions.assertEquals((long)metadata.endOffset(), (long)9L, (String)"expected end offset to be 9");
    }

    @Test
    public void testTierSegmentWithLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = this.mockTierPartitionState(leaderEpoch);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        byte[] epochArray = new byte[100];
        LeaderEpochFileCache mockLeaderEpochCache = (LeaderEpochFileCache)Mockito.mock(LeaderEpochFileCache.class);
        Mockito.when((Object)mockLeaderEpochCache.snapshotForSegment(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)epochArray);
        long nextOffset = logSegment.readNextOffset();
        ((LeaderEpochFileCache)Mockito.doNothing().when((Object)mockLeaderEpochCache)).truncateFromEnd(nextOffset);
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)new Some((Object)mockLeaderEpochCache));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)Nil$.MODULE$);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(Optional.empty());
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)new Some((Object)ByteBuffer.wrap(epochArray)), (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Assertions.assertTrue((boolean)this.tierSegment(log, leaderEpoch).hasEpochState(), (String)"expected metadata to claim to have epoch state");
        ((TierObjectStore)Mockito.verify((Object)this.tierObjectStore(), (VerificationMode)Mockito.times((int)1))).putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull());
    }

    @Test
    public void testArchiverTaskSetsPauseOnRetry() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TierMetadataRetriableException("something"), new TierObjectStoreRetriableException("foo", (Throwable)new RuntimeException("foo"))});
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result.pausedUntil().isDefined(), (String)"expected the task to be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"expected the task to not be canceled");
        Instant pauseTime = (Instant)result.pausedUntil().get();
        this.time().sleep(100L);
        ArchiveTask result2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result2.pausedUntil().isDefined(), (String)"expected the task to be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"expected the task to not be canceled");
        Assertions.assertTrue((boolean)((Instant)result2.pausedUntil().get()).isAfter(pauseTime), (String)"expected the second pause time to be larger than the first");
    }

    @Test
    public void testCancelledArchiveTaskDoesNotProgress() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        this.ctx().cancel();
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).state() instanceof BeforeLeader), (String)"expected task to remain in BeforeLeader");
    }

    @Test
    public void testHandleSegmentDeletedException() {
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        BeforeLeader beforeLeader = new BeforeLeader(0);
        BeforeUpload beforeUpload = new BeforeUpload(0);
        Upload upload = new Upload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), (UploadableSegment)Mockito.mock(UploadableSegment.class));
        AfterUpload afterUpload = new AfterUpload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), 0L);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> beforeLeader.handleSegmentDeletedException(exception), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
        Assertions.assertEquals(BeforeUpload.class, (Object)beforeUpload.handleSegmentDeletedException(exception).getClass());
        Assertions.assertEquals(BeforeUpload.class, (Object)upload.handleSegmentDeletedException(exception).getClass());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> afterUpload.handleSegmentDeletedException(exception), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
    }

    @Test
    public void testHandlingForSegmentDeletedExceptionDuringTransition() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenThrow(new Throwable[]{exception});
        BeforeUpload beforeUpload = new BeforeUpload(42);
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)beforeUpload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)result.state(), (Object)beforeUpload);
        Assertions.assertEquals((int)result.retryCount(), (int)1);
    }

    @Test
    public void testRetriableExceptionFetchingOpaqueData() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierPartitionState tierPartitionState = this.mockTierPartitionState(42);
        TierObjectStore throwingTierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)throwingTierObjectStore.prepPutSegment()).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("key fetch error")});
        BeforeUpload beforeUpload = new BeforeUpload(42);
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)beforeUpload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), throwingTierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assertions.assertEquals((Object)result.state(), (Object)beforeUpload);
        Assertions.assertEquals((int)result.retryCount(), (int)1);
    }

    private Future<ArchiveTaskState> testInitiateUploadWithUncleanLeader(boolean uncleanLeader) {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeader));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.empty());
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, 100L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        return ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringInitiateUpload(Exception e) {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenThrow(new Throwable[]{e});
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.empty());
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringUpload(Exception e, boolean deleteSegment) {
        int leaderEpoch = 0;
        File fileToUse = this.tmpFile();
        if (deleteSegment) {
            fileToUse = (File)Mockito.mock(File.class);
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fileToUse.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        LogSegment logSegment = this.mockLogSegment(fileToUse);
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), false, false, false, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        this.tierObjectStore().putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private LogSegment mockLogSegment(File tmpFile) {
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.mock(OffsetIndex.class);
        Mockito.when((Object)offsetIndex.file()).thenReturn((Object)tmpFile);
        TimeIndex timeIndex = (TimeIndex)Mockito.mock(TimeIndex.class);
        Mockito.when((Object)timeIndex.file()).thenReturn((Object)tmpFile);
        TransactionIndex txnIndex = (TransactionIndex)Mockito.mock(TransactionIndex.class);
        Mockito.when((Object)txnIndex.file()).thenReturn((Object)tmpFile);
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        Mockito.when((Object)fileRecords.file()).thenReturn((Object)tmpFile);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.readNextOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)10L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.baseOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.largestTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1000));
        Mockito.when((Object)logSegment.log()).thenReturn((Object)fileRecords);
        Mockito.when((Object)logSegment.offsetIndex()).thenReturn((Object)offsetIndex);
        Mockito.when((Object)logSegment.timeIndex()).thenReturn((Object)timeIndex);
        Mockito.when((Object)logSegment.txnIndex()).thenReturn((Object)txnIndex);
        return logSegment;
    }

    private TierPartitionState mockTierPartitionState(int leaderEpoch) {
        return (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
    }

    private AbstractLog mockAbstractLog(LogSegment logSegment) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        return log;
    }

    private TierObjectMetadata tierSegment(AbstractLog log, int leaderEpoch) {
        Future beforeUploadResult = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Upload upload = (Upload)Await$.MODULE$.result((Awaitable)beforeUploadResult, (Duration)this.defaultAwaitTime());
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)this.defaultAwaitTime());
        TierSegmentUploadInitiate uploadInitiate = upload.uploadInitiate();
        return new TierObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.tierEpoch(), uploadInitiate.messageId(), uploadInitiate.baseOffset(), uploadInitiate.endOffset(), uploadInitiate.maxTimestamp(), uploadInitiate.firstBatchTimestamp(), uploadInitiate.size(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, uploadInitiate.hasEpochState(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, true, true, -1L);
    }

    public ArchiveTaskTest() {
        this.brokerId = 1;
    }
}

