/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskIntegrationTest$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\rmq!\u0002\u001d:\u0011\u0003\u0011e!\u0002#:\u0011\u0003)\u0005\"\u0002'\u0002\t\u0003i\u0005\"\u0002(\u0002\t\u0003ye\u0001\u0002#:\u0001!DQ\u0001\u0014\u0003\u0005\u0002%D\u0011b\u001b\u0003A\u0002\u0003\u0007I\u0011\u00017\t\u0013M$\u0001\u0019!a\u0001\n\u0003!\b\"\u0003>\u0005\u0001\u0004\u0005\t\u0015)\u0003n\u0011\u001dYH\u00011A\u0005\u0004qD\u0011\"!\u0002\u0005\u0001\u0004%\t!a\u0002\t\u000f\u0005-A\u0001)Q\u0005{\"Y\u0011Q\u0002\u0003A\u0002\u0003\u0007I\u0011AA\b\u0011-\tI\u0002\u0002a\u0001\u0002\u0004%\t!a\u0007\t\u0017\u0005}A\u00011A\u0001B\u0003&\u0011\u0011\u0003\u0005\n\u0003C!!\u0019!C\u0001\u0003GA\u0001\"!\r\u0005A\u0003%\u0011Q\u0005\u0005\n\u0003g!\u0001\u0019!C\u0001\u0003kA\u0011\"a\u0011\u0005\u0001\u0004%\t!!\u0012\t\u0011\u0005%C\u0001)Q\u0005\u0003oA\u0011\"a\u0013\u0005\u0005\u0004%\t!!\u0014\t\u0011\u0005UC\u0001)A\u0005\u0003\u001fB1\"a\u0016\u0005\u0001\u0004\u0005\r\u0011\"\u0001\u0002Z!Y\u0011q\r\u0003A\u0002\u0003\u0007I\u0011AA5\u0011-\ti\u0007\u0002a\u0001\u0002\u0003\u0006K!a\u0017\t\u0017\u0005=D\u00011AA\u0002\u0013\u0005\u0011\u0011\f\u0005\f\u0003c\"\u0001\u0019!a\u0001\n\u0003\t\u0019\bC\u0006\u0002x\u0011\u0001\r\u0011!Q!\n\u0005m\u0003\"CA=\t\t\u0007I\u0011AA>\u0011!\tI\t\u0002Q\u0001\n\u0005u\u0004\"CAF\t\t\u0007I\u0011AAG\u0011!\tY\n\u0002Q\u0001\n\u0005=\u0005\"CAO\t\t\u0007I\u0011AAP\u0011!\ti\u000b\u0002Q\u0001\n\u0005\u0005\u0006\"CAX\t\t\u0007I\u0011AAY\u0011!\ty\f\u0002Q\u0001\n\u0005M\u0006\"CAa\t\t\u0007I\u0011AAb\u0011!\t\t\u000e\u0002Q\u0001\n\u0005\u0015\u0007\"CAj\t\t\u0007I\u0011AAk\u0011!\ty\u000e\u0002Q\u0001\n\u0005]\u0007\"CAq\t\t\u0007I\u0011AAr\u0011!\tY\u000f\u0002Q\u0001\n\u0005\u0015\b\"CAw\t\t\u0007I\u0011AAx\u0011!\t9\u0010\u0002Q\u0001\n\u0005E\bbBA}\t\u0011\u0005\u00111 \u0005\b\u0005\u0017!A\u0011AA~\u0011\u001d\u0011)\u0002\u0002C\u0005\u0005/AqAa\u000b\u0005\t\u0013\u0011iC\u0002\u0004\u0003h\u0011\u0001!\u0011\u000e\u0005\u0007\u0019B\"\tAa!\t\u000f\t%\u0005\u0007\"\u0011\u0003\f\"9!\u0011\u0017\u0019\u0005B\tM\u0006b\u0002B[\t\u0011\u0005!q\u0017\u0005\b\u00053$A\u0011\u0001Bn\u0011\u001d\u0011Y\u000f\u0002C\u0001\u0005[DqA!@\u0005\t\u0003\u0011y0\u0001\u000eBe\u000eD\u0017N^3UCN\\\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002;w\u00059\u0011M]2iSZ,'B\u0001\u001f>\u0003\u0015!\u0018m]6t\u0015\tqt(\u0001\u0003uS\u0016\u0014(\"\u0001!\u0002\u000b-\fgm[1\u0004\u0001A\u00111)A\u0007\u0002s\tQ\u0012I]2iSZ,G+Y:l\u0013:$Xm\u001a:bi&|g\u000eV3tiN\u0011\u0011A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0015!K4f]\u0016\u0014\u0018\r^3C_>dW-\u00198D_6\u0014\u0017N\\1uS>t7\u000fN,ji\"|W\u000f^)v_J,X.F\u0001Q!\r\t\u0006LW\u0007\u0002%*\u00111\u000bV\u0001\u0007gR\u0014X-Y7\u000b\u0005U3\u0016\u0001B;uS2T\u0011aV\u0001\u0005U\u00064\u0018-\u0003\u0002Z%\n11\u000b\u001e:fC6\u0004\"a\u00174\u000e\u0003qS!!\u00180\u0002\u0011A\u0014xN^5eKJT!a\u00181\u0002\rA\f'/Y7t\u0015\t\t'-A\u0004kkBLG/\u001a:\u000b\u0005\r$\u0017!\u00026v]&$(\"A3\u0002\u0007=\u0014x-\u0003\u0002h9\nI\u0011I]4v[\u0016tGo]\n\u0003\t\u0019#\u0012A\u001b\t\u0003\u0007\u0012\t\u0001\"\u001a=fGV$xN]\u000b\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001\u000fV\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001:p\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001D3yK\u000e,Ho\u001c:`I\u0015\fHCA;y!\t9e/\u0003\u0002x\u0011\n!QK\\5u\u0011\u001dIx!!AA\u00025\f1\u0001\u001f\u00132\u0003%)\u00070Z2vi>\u0014\b%\u0001\u0002fGV\tQ\u0010E\u0002\u007f\u0003\u0003i\u0011a \u0006\u0003a\"K1!a\u0001\u0000\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004fG~#S-\u001d\u000b\u0004k\u0006%\u0001bB=\u000b\u0003\u0003\u0005\r!`\u0001\u0004K\u000e\u0004\u0013\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005UQ\"A\u001f\n\u0007\u0005]QH\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006!Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\0%KF$2!^A\u000f\u0011!IX\"!AA\u0002\u0005E\u0011!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u0003K\u0001B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003Wy\u0014aB2mkN$XM]\u0005\u0005\u0003_\tICA\u0005QCJ$\u0018\u000e^5p]\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002\r\r|gNZ5h+\t\t9\u0004\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\tidP\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u0005\u00131\b\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$2!^A$\u0011!I(#!AA\u0002\u0005]\u0012aB2p]\u001aLw\rI\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\"!a\u0014\u0011\t\u0005e\u0012\u0011K\u0005\u0005\u0003'\nYD\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug\u0006\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\u0002\rQl\u0007\u000fR5s+\t\tY\u0006\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tGV\u0001\u0003S>LA!!\u001a\u0002`\t!a)\u001b7f\u0003)!X\u000e\u001d#je~#S-\u001d\u000b\u0004k\u0006-\u0004\u0002C=\u0018\u0003\u0003\u0005\r!a\u0017\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\f!\u0002\\8h\t&\u0014x\fJ3r)\r)\u0018Q\u000f\u0005\tsj\t\t\u00111\u0001\u0002\\\u00059An\\4ESJ\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u000bk!!!!\u000b\u0007\u0005\ru(A\u0003vi&d7/\u0003\u0003\u0002\b\u0006\u0005%\u0001C'pG.$\u0016.\\3\u0002\u00135|7m\u001b+j[\u0016\u0004\u0013!\u0007;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015m\u0019;pef,\"!a$\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!&>\u0003\u0015\u0019H/\u0019;f\u0013\u0011\tI*a%\u00033QKWM\u001d)beRLG/[8o'R\fG/\u001a$bGR|'/_\u0001\u001bi&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR1di>\u0014\u0018\u0010I\u0001\u0012i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001cXCAAQ!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAAT\u007f\u0005\u0019An\\4\n\t\u0005-\u0016Q\u0015\u0002\u0012)&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\u0018A\u0005;jKJdunZ\"p[B|g.\u001a8ug\u0002\n!\u0003\u001e:b]NLG/[8o/\u0006LG\u000fV5nKV\u0011\u00111\u0017\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0011\u0011X@\u0002\u0011\u0011,(/\u0019;j_:LA!!0\u00028\nqa)\u001b8ji\u0016$UO]1uS>t\u0017a\u0005;sC:\u001c\u0018\u000e^5p]^\u000b\u0017\u000e\u001e+j[\u0016\u0004\u0013a\u0005;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cXCAAc!\u001dq\u0017qYA\t\u0003\u0017L1!!3p\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003#\u000bi-\u0003\u0003\u0002P\u0006M%A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\fA\u0003^5feB\u000b'\u000f^5uS>t7\u000b^1uKN\u0004\u0013a\u0004;jKJ$\u0016m]6t\u0007>tg-[4\u0016\u0005\u0005]\u0007\u0003BAm\u00037l\u0011aO\u0005\u0004\u0003;\\$a\u0004+jKJ$\u0016m]6t\u0007>tg-[4\u0002!QLWM\u001d+bg.\u001c8i\u001c8gS\u001e\u0004\u0013AD2mK\u0006tW\u000f\u001d#fY\u0006LXj]\u000b\u0003\u0003K\u00042aRAt\u0013\r\tI\u000f\u0013\u0002\u0005\u0019>tw-A\bdY\u0016\fg.\u001e9EK2\f\u00170T:!\u0003E\u0019G.Z1okBLe\u000e^3sm\u0006dWj]\u000b\u0003\u0003c\u00042aRAz\u0013\r\t)\u0010\u0013\u0002\u0004\u0013:$\u0018AE2mK\u0006tW\u000f]%oi\u0016\u0014h/\u00197Ng\u0002\nQa]3ukB$\u0012!\u001e\u0015\u0004Y\u0005}\b\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\u0007\t\u0015\u0001-A\u0002ba&LAA!\u0003\u0003\u0004\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d3po:D3!\fB\b!\u0011\u0011\tA!\u0005\n\t\tM!1\u0001\u0002\n\u0003\u001a$XM]#bG\"\f!\u0004\\8h!J|g/\u001b3j]\u001e\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ$bA!\u0007\u0003 \t\u0005\u0002\u0003BA\u001d\u00057IAA!\b\u0002<\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bbBA\u0007]\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005Gq\u0003\u0019\u0001B\u0013\u0003-\t'm\u001d;sC\u000e$Hj\\4\u0011\t\u0005\r&qE\u0005\u0005\u0005S\t)KA\u0006BEN$(/Y2u\u0019><\u0017\u0001G2sK\u0006$X\rV5feB\u000b'\u000f^5uS>t7\u000b^1uKR\u0001\u00121\u001aB\u0018\u0005c\u0011iEa\u0016\u0003\\\t}#1\r\u0005\b\u0003\u001by\u0003\u0019AA\t\u0011\u001d\u0011\u0019d\fa\u0001\u0005k\tA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0003\u0002B\u001c\u0005\u0013j!A!\u000f\u000b\t\u0005\u001d&1\b\u0006\u0005\u0005{\u0011y$A\u0005j]R,'O\\1mg*!!\u0011\tB\"\u0003\u001d\u0019Ho\u001c:bO\u0016T1\u0001\u0011B#\u0015\r\u00119\u0005Z\u0001\u0007CB\f7\r[3\n\t\t-#\u0011\b\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\t\u000f\t=s\u00061\u0001\u0003R\u0005y1\r[3dWN,X.\u00128bE2,G\rE\u0002H\u0005'J1A!\u0016I\u0005\u001d\u0011un\u001c7fC:DqA!\u00170\u0001\u0004\u0011\t&\u0001\bd_6\u0004\u0018m\u0019;F]\u0006\u0014G.\u001a3\t\u000f\tus\u00061\u0001\u0003R\u0005q1\r\\3b]V\u0004XI\\1cY\u0016$\u0007b\u0002B1_\u0001\u0007!\u0011K\u0001\"i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u00158baNDw\u000e^#oC\ndW\r\u001a\u0005\b\u0005Kz\u0003\u0019AAy\u0003!\u0011'o\\6fe&#'\u0001F'pG.$\u0016.\u001a:U_BL7-T1oC\u001e,'oE\u00031\u0005W\u00129\b\u0005\u0003\u0003n\tMTB\u0001B8\u0015\r\u0011\tHV\u0001\u0005Y\u0006tw-\u0003\u0003\u0003v\t=$AB(cU\u0016\u001cG\u000f\u0005\u0003\u0003z\t}TB\u0001B>\u0015\r\u0011i(P\u0001\u0006i>\u0004\u0018nY\u0005\u0005\u0005\u0003\u0013YHA\tUS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJ$\"A!\"\u0011\u0007\t\u001d\u0005'D\u0001\u0005\u0003-\tG\rZ'fi\u0006$\u0017\r^1\u0015\t\t5%\u0011\u0015\t\u0006]\n=%1S\u0005\u0004\u0005#{'!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!!Q\u0013BN\u001d\u0011\t\tJa&\n\t\te\u00151S\u0001\u0013)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-\u0003\u0003\u0003\u001e\n}%\u0001D!qa\u0016tGMU3tk2$(\u0002\u0002BM\u0003'CqAa)3\u0001\u0004\u0011)+A\u0003f]R\u0014\u0018\u0010\u0005\u0003\u0003(\n5VB\u0001BU\u0015\r\u0011Y+P\u0001\u0007I>l\u0017-\u001b8\n\t\t=&\u0011\u0016\u0002\u0015\u0003\n\u001cHO]1diRKWM]'fi\u0006$\u0017\r^1\u0002!%\u001c(+Z1es\u001a{'o\u0016:ji\u0016\u001cHC\u0001B)\u0003]!Xm\u001d;Be\u000eD\u0017N^3UCN\\W)\u001c9us2{w\rF\u0005v\u0005s\u0013YL!0\u0003@\"9!q\n\u001bA\u0002\tE\u0003b\u0002B-i\u0001\u0007!\u0011\u000b\u0005\b\u0005;\"\u0004\u0019\u0001B)\u0011\u001d\u0011\t\u0007\u000ea\u0001\u0005#Bs\u0001\u000eBb\u0005\u0013\u0014Y\rE\u0002\\\u0005\u000bL1Aa2]\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\t\u0011i-I\u0001OQ\r!$\u0011\u001b\t\u0005\u0005'\u0014).D\u0001_\u0013\r\u00119N\u0018\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018a\t;fgR\f%o\u00195jm\u0016$\u0016m]6Va2|\u0017\rZ:Qe>$WoY3s'R\fG/\u001a\u000b\nk\nu'q\u001cBq\u0005GDqAa\u00146\u0001\u0004\u0011\t\u0006C\u0004\u0003ZU\u0002\rA!\u0015\t\u000f\tuS\u00071\u0001\u0003R!9!\u0011M\u001bA\u0002\tE\u0003fB\u001b\u0003D\n%'q\u001d\u0017\u0003\u0005\u001bD3!\u000eBi\u00031\"Xm\u001d;Be\u000eD\u0017N^3s%\u0016$(/[3t\u001f:\u001cuN\\2veJ,g\u000e\u001e#fY\u0016$XMU3d_J$7\u000fF\u0005v\u0005_\u0014\tPa=\u0003v\"9!q\n\u001cA\u0002\tE\u0003b\u0002B-m\u0001\u0007!\u0011\u000b\u0005\b\u0005;2\u0004\u0019\u0001B)\u0011\u001d\u0011\tG\u000ea\u0001\u0005#BsA\u000eBb\u0005\u0013\u0014I\u0010\f\u0002\u0003N\"\u001aaG!5\u0002QQ,7\u000f^!sG\"Lg/\u001a:Fq\u000e,\u0007\u000f^5p]>s\u0007+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8\u0015\u0013U\u001c\taa\u0001\u0004\u0006\r\u001d\u0001b\u0002B(o\u0001\u0007!\u0011\u000b\u0005\b\u00053:\u0004\u0019\u0001B)\u0011\u001d\u0011if\u000ea\u0001\u0005#BqA!\u00198\u0001\u0004\u0011\t\u0006K\u00048\u0005\u0007\u0014Ima\u0003-\u0005\t5\u0007fA\u001c\u0003R\":Aa!\u0005\u0003J\u000e]\u0001\u0003\u0002B\u0001\u0007'IAa!\u0006\u0003\u0004\t\u0019A+Y4\"\u0005\re\u0011aC5oi\u0016<'/\u0019;j_:\u0004")
public class ArchiveTaskIntegrationTest {
    private ExecutorService executor;
    private ExecutionContext ec = ExecutionContext$.MODULE$.fromExecutorService(this.executor());
    private TopicIdPartition topicIdPartition;
    private final Partition partition = (Partition)Mockito.mock(Partition.class);
    private KafkaConfig config = null;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private File tmpDir;
    private File logDir;
    private final MockTime mockTime = new MockTime();
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, this.tierPartitionStateFactory(), (Option)None$.MODULE$);
    private final FiniteDuration transitionWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private final ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates = new ConcurrentHashMap();
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, 1, 600000L, 500L, 50, 300000, false, false, (Option)None$.MODULE$, (Option)None$.MODULE$);
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;

    public static Stream<Arguments> generateBooleanCombinations4WithoutQuorum() {
        return ArchiveTaskIntegrationTest$.MODULE$.generateBooleanCombinations4WithoutQuorum();
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public void ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public void topicIdPartition_$eq(TopicIdPartition x$1) {
        this.topicIdPartition = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public FiniteDuration transitionWaitTime() {
        return this.transitionWaitTime;
    }

    public ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates() {
        return this.tierPartitionStates;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    @BeforeEach
    public void setup() {
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.executor_$eq(Executors.newFixedThreadPool(1));
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var21_8 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var22_11 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var23_14 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", x$4, x$5, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        File parseTopicPartitionName_dir = this.logDir();
        Object var24_23 = null;
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.topicIdPartition_$eq(new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition()));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.executor().shutdownNow();
        this.brokerTopicStats().close();
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.tierPartitionStates().values()).asScala().foreach((Function1 & Serializable)tierPartitionState -> {
            ArchiveTaskIntegrationTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        this.tierPartitionStates().clear();
        Utils.delete((File)this.tmpDir(), (boolean)false);
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    private ReplicaManager logProvidingReplicaManager(TopicIdPartition topicIdPartition, AbstractLog abstractLog) {
        return (ReplicaManager)Mockito.when((Object)((ReplicaManager)Mockito.mock(ReplicaManager.class)).getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)abstractLog)).getMock();
    }

    private TierPartitionState createTierPartitionState(TopicIdPartition topicIdPartition, LogDirFailureChannel logDirFailureChannel, boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled, int brokerId) {
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(TestUtils.tempDirectory(null, null), logDirFailureChannel, topicIdPartition.topicPartition(), true, (Scheduler)this.mockTime().scheduler(), checksumEnabled, compactEnabled, (Time)this.mockTime(), new TierPartitionStateCleanupConfig(cleanupEnabled, this.cleanupDelayMs(), (long)this.cleanupIntervalMs()), tierPartitionStateSnapshotEnabled, brokerId);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates().put(topicIdPartition, (TierPartitionState)tierPartitionState);
        return tierPartitionState;
    }

    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations4WithoutQuorum"})
    public void testArchiveTaskEmptyLog(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled) {
        int brokerId = 1;
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(brokerId)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        long x$3 = 604800000L;
        long x$4 = 604800000L;
        long x$5 = -1L;
        long x$6 = 0L;
        String x$7 = "delete";
        int x$8 = 0x10000C;
        int x$9 = 4096;
        int x$10 = 0xA00000;
        String x$11 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$12 = 60000L;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, 0x500000, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, true, x$13, x$14, x$15, x$16, x$17, x$18);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled, tierPartitionStateSnapshotEnabled, brokerId);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        File x$19 = this.logDir();
        BrokerTopicStats x$21 = this.brokerTopicStats();
        MockScheduler x$22 = this.mockTime().scheduler();
        MockTime x$23 = this.mockTime();
        TierLogComponents x$24 = this.tierLogComponents();
        long x$26 = 0L;
        long x$27 = 0L;
        int x$28 = 300000;
        ProducerStateManagerConfig x$29 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$30 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogOffsetsListener x$31 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$32 = true;
        None$ x$33 = None$.MODULE$;
        boolean x$34 = true;
        ConcurrentHashMap<String, Object> x$35 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$19, logConfig, x$21, (Scheduler)x$22, (Time)x$23, x$26, x$27, x$28, x$29, x$30, x$24, logDirFailureChannel, x$31, x$32, (Option<Uuid>)x$33, x$34, x$35);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        ArchiveTask nextState = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertTrue((boolean)(nextState.state() instanceof BeforeUpload), (String)"expected to be in BeforeUpload");
        Assertions.assertFalse((boolean)nextState.ctx().isCancelled(), (String)"expected task to not be cancelled");
        Assertions.assertEquals((Integer)tierObjectStore.getObjectCounts().getOrDefault(TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0)), (int)0, (String)"expected zero segments to be uploaded");
    }

    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations4WithoutQuorum"})
    public void testArchiveTaskUploadsProducerState(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled) {
        int brokerId = 1;
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -1L;
        long x$52 = 0L;
        String x$62 = "delete";
        int x$7 = 0x10000C;
        int x$8 = 4096;
        int x$9 = 0xA00000;
        String x$10 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$11 = 60000L;
        boolean x$12 = false;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 1024, x$3, x$4, x$52, x$62, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled, tierPartitionStateSnapshotEnabled, brokerId);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        File x$19 = this.logDir();
        BrokerTopicStats x$21 = this.brokerTopicStats();
        MockScheduler x$22 = this.mockTime().scheduler();
        MockTime x$23 = this.mockTime();
        TierLogComponents x$24 = this.tierLogComponents();
        long x$26 = 0L;
        long x$27 = 0L;
        int x$28 = 300000;
        ProducerStateManagerConfig x$29 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$30 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogOffsetsListener x$31 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$32 = true;
        None$ x$33 = None$.MODULE$;
        boolean x$34 = true;
        ConcurrentHashMap<String, Object> x$35 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$19, logConfig, x$21, (Scheduler)x$22, (Time)x$23, x$26, x$27, x$28, x$29, x$30, x$24, logDirFailureChannel, x$31, x$32, (Option<Uuid>)x$33, x$34, x$35);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        long pid1 = 1L;
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            .colon.colon x$36 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            byte x$40 = 2;
            CompressionType x$41 = CompressionType.NONE;
            long x$42 = 0L;
            int x$43 = -1;
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$36, x$40, x$41, pid1, (short)0, i, x$42, x$43), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$1.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size(), (String)"expected 5 local log segments");
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size(), (String)"expected 4 tierable segments");
        List snapshotFiles = ((IterableOnceOps)log.localLogSegments().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.baseOffset()))).toList().flatMap((Function1 & Serializable)x$6 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(log.producerStateManager().snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)x$6)))));
        Assertions.assertEquals((int)4, (int)snapshotFiles.size(), (String)"expected to be able to use segment base offset to get snapshot files for 4 segments");
        ArchiveTask maybeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload.state().getClass(), (String)"expected successful transition to Upload");
        ArchiveTask maybeAfterUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(AfterUpload.class, maybeAfterUpload.state().getClass(), (String)"expected successful transition to afterUpload");
        ConcurrentHashMap objectCounts = tierObjectStore.getObjectCounts();
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(TierObjectStore.FileType.SEGMENT)), (String)"expected 1 segment file");
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(TierObjectStore.FileType.PRODUCER_STATE)), (String)"expected 1 producer state");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)maybeAfterUpload.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime())).state() instanceof BeforeUpload), (String)"expected successful transition to beforeUpload");
        Assertions.assertEquals((int)tierPartitionState.numSegments(), (int)1, (String)"expected 1 segment to be materialized");
        Assertions.assertTrue((boolean)((TierLogSegment)tierPartitionState.metadata(0L).get()).metadata().hasProducerState(), (String)"expected hasProducerState metadata flag to be set");
    }

    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations4WithoutQuorum"})
    public void testArchiverRetriesOnConcurrentDeleteRecords(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled) {
        int brokerId = 1;
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(brokerId)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -1L;
        long x$5 = 0L;
        String x$6 = "delete";
        int x$7 = 0x10000C;
        int x$8 = 4096;
        int x$9 = 0xA00000;
        String x$10 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$11 = 60000L;
        boolean x$12 = false;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 1024, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled, tierPartitionStateSnapshotEnabled, brokerId);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$19 = this.logDir();
        BrokerTopicStats x$21 = this.brokerTopicStats();
        MockScheduler x$22 = this.mockTime().scheduler();
        MockTime x$23 = this.mockTime();
        TierLogComponents x$24 = this.tierLogComponents();
        long x$26 = 0L;
        long x$27 = 0L;
        int x$28 = 300000;
        ProducerStateManagerConfig x$29 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$30 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogOffsetsListener x$31 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$32 = true;
        None$ x$33 = None$.MODULE$;
        boolean x$34 = true;
        ConcurrentHashMap<String, Object> x$35 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$19, logConfig, x$21, (Scheduler)x$22, (Time)x$23, x$26, x$27, x$28, x$29, x$30, x$24, logDirFailureChannel, x$31, x$32, (Option<Uuid>)x$33, x$34, x$35);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            .colon.colon x$36 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            byte x$40 = 2;
            CompressionType x$41 = CompressionType.NONE;
            long x$42 = 0L;
            int x$43 = -1;
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$36, x$40, x$41, pid1, (short)0, i, x$42, x$43), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$2.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        ArchiveTask maybeUpload_1 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        File segmentFileBeingUploaded = ((Upload)maybeUpload_1.state()).uploadableSegment().logSegmentFile();
        Assertions.assertEquals(Upload.class, maybeUpload_1.state().getClass());
        Assertions.assertEquals((Object)segmentFileBeingUploaded, (Object)((LogSegment)log.localLogSegments().head()).log().file());
        LogSegment newFirstSegment = (LogSegment)log.localLogSegments().toList().apply(3);
        File newFirstSegmentFile = newFirstSegment.log().file();
        log.maybeIncrementLogStartOffset(newFirstSegment.baseOffset() + 3L, LogStartOffsetIncrementReason.SegmentDeletion);
        log.deleteOldSegments();
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        ArchiveTask maybeUpload_2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload_2.state().getClass());
        Assertions.assertEquals((Object)newFirstSegmentFile, (Object)((Upload)maybeUpload_2.state()).uploadableSegment().logSegmentFile());
    }

    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinations4WithoutQuorum"})
    public void testArchiverExceptionOnPartitionDeletion(boolean checksumEnabled, boolean compactEnabled, boolean cleanupEnabled, boolean tierPartitionStateSnapshotEnabled) {
        int brokerId = 1;
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(brokerId)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -1L;
        long x$5 = 0L;
        String x$6 = "delete";
        int x$7 = 0x10000C;
        int x$8 = 4096;
        int x$9 = 0xA00000;
        String x$10 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$11 = 60000L;
        boolean x$12 = false;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 1024, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled, compactEnabled, cleanupEnabled, tierPartitionStateSnapshotEnabled, brokerId);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$19 = this.logDir();
        BrokerTopicStats x$21 = this.brokerTopicStats();
        MockScheduler x$22 = this.mockTime().scheduler();
        MockTime x$23 = this.mockTime();
        TierLogComponents x$24 = this.tierLogComponents();
        long x$26 = 0L;
        long x$27 = 0L;
        int x$28 = 300000;
        ProducerStateManagerConfig x$29 = LogTestUtils$.MODULE$.createLog$default$9();
        int x$30 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogOffsetsListener x$31 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$32 = true;
        None$ x$33 = None$.MODULE$;
        boolean x$34 = true;
        ConcurrentHashMap<String, Object> x$35 = new ConcurrentHashMap<String, Object>();
        MergedLog log = LogTestUtils$.MODULE$.createLog(x$19, logConfig, x$21, (Scheduler)x$22, (Time)x$23, x$26, x$27, x$28, x$29, x$30, x$24, logDirFailureChannel, x$31, x$32, (Option<Uuid>)x$33, x$34, x$35);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), (AbstractLog)log);
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            .colon.colon x$36 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            byte x$40 = 2;
            CompressionType x$41 = CompressionType.NONE;
            long x$42 = 0L;
            int x$43 = -1;
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$36, x$40, x$41, pid1, (short)0, i, x$42, x$43), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$3.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        TopicPartition logDeleteDirName_topicPartition = this.topicIdPartition().topicPartition();
        Object var63_50 = null;
        log.renameDir(LocalLog$.MODULE$.logDeleteDirName(logDeleteDirName_topicPartition), true);
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, this.tierTasksConfig(), (Option)None$.MODULE$, this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        Predef$.MODULE$.assert(ctx.isCancelled());
        tierPartitionState.delete();
    }

    public static final /* synthetic */ void $anonfun$teardown$1(TierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public ArchiveTaskIntegrationTest() {
        this.cleanupIntervalMs = 0;
    }

    public class MockTierTopicManager
    implements TierTopicAppender {
        public CompletableFuture<TierPartitionState.AppendResult> addMetadata(AbstractTierMetadata entry) {
            TierPartitionState tierPartitionState = this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().tierPartitionStates().get(this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().topicIdPartition());
            return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(Future$.MODULE$.successful((Object)tierPartitionState.append(entry, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch())))).toCompletableFuture();
        }

        public boolean isReadyForWrites() {
            return true;
        }

        public /* synthetic */ ArchiveTaskIntegrationTest kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer() {
            return ArchiveTaskIntegrationTest.this;
        }

        public MockTierTopicManager() {
            if (ArchiveTaskIntegrationTest.this == null) {
                throw null;
            }
        }
    }
}

