/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.TierObjectStore;
import kafka.utils.checksum.Algorithm;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005!2Aa\u0001\u0003\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/\t\tC+[3s!\u0006\u0014H/\u001b;j_:lU\r^1eCR\f7K\\1qg\"|G\u000fV3ti*\u0011QAB\u0001\u0006gR|'/\u001a\u0006\u0003\u000f!\tA\u0001^5fe*\t\u0011\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011Q\u0003A\u0007\u0002\t\u0005aB/Z:u)&,'/T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;QCRDG#\u0001\r\u0011\u00055I\u0012B\u0001\u000e\u000f\u0005\u0011)f.\u001b;)\u0005\ta\u0002CA\u000f'\u001b\u0005q\"BA\u0010!\u0003\r\t\u0007/\u001b\u0006\u0003C\t\nqA[;qSR,'O\u0003\u0002$I\u0005)!.\u001e8ji*\tQ%A\u0002pe\u001eL!a\n\u0010\u0003\tQ+7\u000f\u001e")
public class TierPartitionMetadataSnapshotTest {
    @Test
    public void testTierMetadataSnapshotPath() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        UUID snapshotId = UUID.randomUUID();
        TierObjectStore.TierPartitionStateSnapshotMetadata metadata = new TierObjectStore.TierPartitionStateSnapshotMetadata(topicIdPartition, new FileTierPartitionStateSnapshotObject(snapshotId, 123L, new OffsetAndEpoch(45L, Optional.of(Predef$.MODULE$.int2Integer(6))), 7, "00000000000000000000.tierstate", Algorithm.ADLER));
        String keyPrefix = "bar";
        TierObjectStore.FileType fileType = TierObjectStore.FileType.TIER_PARTITION_STATE_METADATA_SNAPSHOT;
        String expectedPathStr = new StringBuilder(20).append(keyPrefix).append(TierObjectStore.DataTypePathPrefix.TIER_PARTITION_STATE_METADATA_SNAPSHOT.prefix).append("/").append(topicIdPartition.topicIdAsBase64()).append("/").append(topicIdPartition.partition()).append("/").append(metadata.snapshotObject().snapshotId().toString()).append("_").append(metadata.snapshotObject().snapshotTimestampMs()).append("_").append(metadata.snapshotObject().lastMaterializedEventOffsetAndEpoch().offset()).append("_").append(metadata.snapshotObject().lastMaterializedEventOffsetAndEpoch().epoch().orElse(Predef$.MODULE$.int2Integer(-1))).append("_").append(metadata.snapshotObject().tierEpoch()).append("_").append(metadata.snapshotObject().baseName()).append(".snapshot").append(metadata.snapshotObject().checksumAlgorithm().suffix).append("_v").append(metadata.version()).append(".").append(fileType.suffix()).toString();
        Assertions.assertEquals((int)0, (int)metadata.version());
        Assertions.assertEquals((Object)snapshotId, (Object)metadata.snapshotObject().snapshotId());
        Assertions.assertEquals((long)123L, (long)metadata.snapshotObject().snapshotTimestampMs());
        Assertions.assertEquals((Object)new OffsetAndEpoch(45L, Optional.of(Predef$.MODULE$.int2Integer(6))), (Object)metadata.snapshotObject().lastMaterializedEventOffsetAndEpoch());
        Assertions.assertEquals((int)7, (int)metadata.snapshotObject().tierEpoch());
        Assertions.assertEquals((Object)Algorithm.ADLER, (Object)metadata.snapshotObject().checksumAlgorithm());
        Assertions.assertEquals((Object)expectedPathStr, (Object)metadata.toPath(keyPrefix, fileType));
        Assertions.assertTrue((boolean)expectedPathStr.contains(snapshotId.toString()));
        Assertions.assertTrue((boolean)expectedPathStr.contains(Algorithm.ADLER.suffix));
    }
}

