/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AeadConfig;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.GcsTierObjectStore;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.EncryptionKeyManager;
import kafka.tier.store.encryption.KeyContext;
import kafka.tier.store.encryption.KeySha;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tEc\u0001B\u0016-\u0001MBQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013\u0005q\b\u0003\u0004G\u0001\u0001\u0006I\u0001\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019!\u0006\u0001)A\u0005\u0013\"9Q\u000b\u0001b\u0001\n\u00031\u0006B\u0002.\u0001A\u0003%q\u000bC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\r\u0001\u0004\u0001\u0015!\u0003^\u0011\u001d\t\u0007A1A\u0005\u0002\tDaa\u001d\u0001!\u0002\u0013\u0019\u0007b\u0002;\u0001\u0005\u0004%\t!\u001e\u0005\u0007}\u0002\u0001\u000b\u0011\u0002<\t\u0011}\u0004!\u0019!C\u0001\u0003\u0003A\u0001\"a\u0004\u0001A\u0003%\u00111\u0001\u0005\n\u0003#\u0001!\u0019!C\u0001\u0003'A\u0001\"!\n\u0001A\u0003%\u0011Q\u0003\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\tY\u0005\u0001C\u0001\u0003SAq!!\u0016\u0001\t\u0003\tI\u0003C\u0004\u0002Z\u0001!\t!!\u000b\t\u000f\u0005u\u0003\u0001\"\u0001\u0002*!9\u0011\u0011\r\u0001\u0005\u0002\u0005%\u0002bBA3\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003S\u0002A\u0011AA\u0015\u0011\u001d\ti\u0007\u0001C\u0001\u0003SAq!!\u001d\u0001\t\u0003\tI\u0003C\u0004\u0002v\u0001!\t!!\u000b\t\u000f\u0005e\u0004\u0001\"\u0001\u0002*!9\u0011Q\u0010\u0001\u0005\u0002\u0005%\u0002bBAA\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!!0\u0001\t\u0003\tI\u0003C\u0004\u0002B\u0002!\t!!\u000b\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002*\u00191\u0011\u0011\u001a\u0001\u0001\u0003\u0017D!\"!@&\u0005\u000b\u0007I\u0011AA\u0000\u0011)\u0011y!\nB\u0001B\u0003%!\u0011\u0001\u0005\u0007u\u0015\"\tA!\u0005\t\u000f\teQ\u0005\"\u0011\u0003\u001c!9!qE\u0013\u0005\u0002\t%\"AF$dgRKWM](cU\u0016\u001cGo\u0015;pe\u0016$Vm\u001d;\u000b\u00055r\u0013!B:u_J,'BA\u00181\u0003\u0011!\u0018.\u001a:\u000b\u0003E\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001iA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001f\u0011\u0005u\u0002Q\"\u0001\u0017\u0002\u00115|7m\u001b+j[\u0016,\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007B\nQ!\u001e;jYNL!!\u0012\"\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u000fM$xN]1hKV\t\u0011\n\u0005\u0002K%6\t1J\u0003\u0002H\u0019*\u0011QJT\u0001\u0006G2|W\u000f\u001a\u0006\u0003\u001fB\u000baaZ8pO2,'\"A)\u0002\u0007\r|W.\u0003\u0002T\u0017\n91\u000b^8sC\u001e,\u0017\u0001C:u_J\fw-\u001a\u0011\u0002\r\t,8m[3u+\u00059\u0006C\u0001&Y\u0013\tI6J\u0001\u0004Ck\u000e\\W\r^\u0001\bEV\u001c7.\u001a;!\u0003\u0019\u0019wN\u001c4jOV\tQ\f\u0005\u0002>=&\u0011q\f\f\u0002\u0019\u000f\u000e\u001cH+[3s\u001f\nTWm\u0019;Ti>\u0014XmQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\t[\u0016$\u0018\rZ1uCV\t1\r\u0005\u0002ea:\u0011QM\u001c\b\u0003M6t!a\u001a7\u000f\u0005!\\W\"A5\u000b\u0005)\u0014\u0014A\u0002\u001fs_>$h(C\u00012\u0013\ty\u0003'\u0003\u0002.]%\u0011q\u000eL\u0001\u0010)&,'o\u00142kK\u000e$8\u000b^8sK&\u0011\u0011O\u001d\u0002\u000f\u001f\nTWm\u0019;NKR\fG-\u0019;b\u0015\tyG&A\u0005nKR\fG-\u0019;bA\u0005AA/Z:u\r&dW-F\u0001w!\t9H0D\u0001y\u0015\tI(0\u0001\u0002j_*\t10\u0001\u0003kCZ\f\u0017BA?y\u0005\u00111\u0015\u000e\\3\u0002\u0013Q,7\u000f\u001e$jY\u0016\u0004\u0013A\u00012c+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIA_\u0001\u0004]&|\u0017\u0002BA\u0007\u0003\u000f\u0011!BQ=uK\n+hMZ3s\u0003\r\u0011'\rI\u0001\n[\u0006\u001cH/\u001a:LKf,\"!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005!A/\u001b8l\u0015\r\tyBT\u0001\u0007GJL\b\u000f^8\n\t\u0005\r\u0012\u0011\u0004\u0002\u0005\u0003\u0016\fG-\u0001\u0006nCN$XM]&fs\u0002\nQa]3ukB$\"!a\u000b\u0011\u0007U\ni#C\u0002\u00020Y\u0012A!\u00168ji\"\u001a!#a\r\u0011\t\u0005U\u0012qI\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005\u0019\u0011\r]5\u000b\t\u0005u\u0012qH\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t\t%a\u0011\u0002\u000b),h.\u001b;\u000b\u0005\u0005\u0015\u0013aA8sO&!\u0011\u0011JA\u001c\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u000ei\u0016\u001cHoU5oO2,\u0007+\u001e;)\u0007M\ty\u0005\u0005\u0003\u00026\u0005E\u0013\u0002BA*\u0003o\u0011A\u0001V3ti\u0006)B/Z:u\u0007J\u001bu+\u001b;i'&tw\r\\3CsR,\u0007f\u0001\u000b\u0002P\u0005!B/Z:u\u0007J\u001bu+\u001b;i\u001bVdG/\u001b\"zi\u0016D3!FA(\u0003\u0019\"Xm\u001d;D%\u000e;\u0016\u000e\u001e5Nk2$\u0018NQ=uK\u0006sGMT8o5\u0016\u0014x\u000eU8tSRLwN\u001c\u0015\u0004-\u0005=\u0013\u0001\b;fgR\u001c\u0016N\\4mKB+HoV5uQ\u0006\u0013wN\u001d;fIRChn\u001d\u0015\u0004/\u0005=\u0013\u0001\n;fgR\u001c\u0016N\\4mKB+H\u000f\u0015:pIV\u001cWM]*uCR,W\t]8dQN#\u0018\r^3)\u0007a\ty%\u0001\u000buKN$H)\u001a7fi\u0016\fE\u000e\\*vG\u000e,7o\u001d\u0015\u00043\u0005=\u0013\u0001\t;fgR$U\r\\3uKN{W.\u001a$bS2,GmR3u\u000bb\u001cW\r\u001d;j_:D3AGA(\u0003\t\"Xm\u001d;EK2,G/Z*p[\u00164\u0015-\u001b7fI\u001e+GOT8Fq\u000e,\u0007\u000f^5p]\"\u001a1$a\u0014\u0002eQ,7\u000f^#oGJL\b\u000f^3e\r\u0016$8\r[,ji\"tu.\u00128def\u0004H/[8o\u0017\u0016LX*\u00198bO\u0016\u0014H\u000b\u001b:poND3\u0001HA(\u0003e\"Xm\u001d;HGN$\u0016.\u001a:PE*,7\r^*u_J,7i\u001c8tiJ,8\r\u001e+ie><8oV5uQ&sg/\u00197jI.+\u0017pQ8oM&<\u0007fA\u000f\u0002P\u0005QC/Z:u!J,\u0007\u000fU;u'\u0016<W.\u001a8u/&$\b.\u00128def\u0004H/[8o\u0017\u0016LX*\u00198bO\u0016\u0014\bf\u0001\u0010\u0002P\u0005iC/Z:u!J,\u0007\u000fU;u'\u0016<W.\u001a8u/&$\bn\\;u\u000b:\u001c'/\u001f9uS>t7*Z=NC:\fw-\u001a:)\u0007}\ty%\u0001\u0019uKN$XI\\2ssB$X\rZ*fO6,g\u000e\u001e*fC\u0012,6/Z:F]\u000e\u0014\u0018\u0010\u001d;j_:\\U-_'b]\u0006<WM\u001d\u000b\u0005\u0003W\tI\tC\u0004\u0002\f\u0002\u0002\r!!$\u0002\u0011\u0019LG.\u001a;za\u0016\u00042\u0001ZAH\u0013\r\t\tJ\u001d\u0002\t\r&dW\rV=qK\":\u0001%!&\u0002&\u0006\u001d\u0006\u0003BAL\u0003Ck!!!'\u000b\t\u0005m\u0015QT\u0001\taJ|g/\u001b3fe*!\u0011qTA\u001e\u0003\u0019\u0001\u0018M]1ng&!\u00111UAM\u0005))e.^7T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003\u001bC3\u0001IAV!\u0011\ti+a,\u000e\u0005\u0005u\u0015\u0002BAY\u0003;\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003}!Xm\u001d;F]\u000e\u0014\u0018\u0010\u001d;fIJ+\u0017\r\u001a*fMJ,7\u000f[3t\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0003W\t9\fC\u0004\u0002\f\u0006\u0002\r!!$)\u000f\u0005\n)*!*\u0002(\"\u001a\u0011%a+\u0002#Q,7\u000f^#oGJL\b\u000f^3e!V$8\u000fK\u0002#\u0003\u001f\nq\u0004^3ti\u0016s7M]=qi\u0016$\u0007+\u001e;J]6+Wn\u001c:z'\u0016<W.\u001a8uQ\r\u0019\u0013qJ\u0001\u001bi\u0016\u001cH/\u00128def\u0004H/\u001a3SKN$xN]3Cs\u000e{\u0007/\u001f\u0015\u0004I\u0005=#aI$dgN#xN]1hK\u000e{\u0007/\u001f*fcV,7\u000f^(qi&|gn]'bi\u000eDWM]\u000b\u0005\u0003\u001b\fYoE\u0003&\u0003\u001f\fY\u000e\u0005\u0003\u0002R\u0006]WBAAj\u0015\r\t)N_\u0001\u0005Y\u0006tw-\u0003\u0003\u0002Z\u0006M'AB(cU\u0016\u001cG\u000f\u0005\u0004\u0002^\u0006\r\u0018q]\u0007\u0003\u0003?TA!!9\u0002D\u00059Qn\\2lSR|\u0017\u0002BAs\u0003?\u0014q\"\u0011:hk6,g\u000e^'bi\u000eDWM\u001d\t\u0005\u0003S\fY\u000f\u0004\u0001\u0005\u000f\u00055XE1\u0001\u0002p\n\tA+\u0005\u0003\u0002r\u0006]\bcA\u001b\u0002t&\u0019\u0011Q\u001f\u001c\u0003\u000f9{G\u000f[5oOB\u0019Q'!?\n\u0007\u0005mhGA\u0002B]f\f1bY8qsJ+\u0017/^3tiV\u0011!\u0011\u0001\t\u0005\u0005\u0007\u0011IAD\u0002K\u0005\u000bI1Aa\u0002L\u0003\u001d\u0019Fo\u001c:bO\u0016LAAa\u0003\u0003\u000e\tY1i\u001c9z%\u0016\fX/Z:u\u0015\r\u00119aS\u0001\rG>\u0004\u0018PU3rk\u0016\u001cH\u000f\t\u000b\u0005\u0005'\u00119\u0002E\u0003\u0003\u0016\u0015\n9/D\u0001\u0001\u0011\u001d\ti\u0010\u000ba\u0001\u0005\u0003\tq!\\1uG\",7\u000f\u0006\u0003\u0003\u001e\t\r\u0002cA\u001b\u0003 %\u0019!\u0011\u0005\u001c\u0003\u000f\t{w\u000e\\3b]\"9!QE\u0015A\u0002\u0005\u001d\u0018\u0001C1sOVlWM\u001c;\u0002#=\u0004H/[8o\u0019&\u001cH/T1uG\",7\u000f\u0006\u0004\u0003\u001e\t-\"1\t\u0005\b\u0005[Q\u0003\u0019\u0001B\u0018\u0003-y\u0007\u000f^5p]2K7\u000f^\u00191\t\tE\"q\b\t\u0007\u0005g\u0011ID!\u0010\u000e\u0005\tU\"b\u0001B\u001cu\u0006!Q\u000f^5m\u0013\u0011\u0011YD!\u000e\u0003\t1K7\u000f\u001e\t\u0005\u0003S\u0014y\u0004\u0002\u0007\u0003B\t-\u0012\u0011!A\u0001\u0006\u0003\tyOA\u0002`IEBqA!\u0012+\u0001\u0004\u00119%A\u0006paRLwN\u001c'jgR\u0014\u0004\u0007\u0002B%\u0005\u001b\u0002bAa\r\u0003:\t-\u0003\u0003BAu\u0005\u001b\"ABa\u0014\u0003D\u0005\u0005\t\u0011!B\u0001\u0003_\u00141a\u0018\u00133\u0001")
public class GcsTierObjectStoreTest {
    private final MockTime mockTime = new MockTime();
    private final Storage storage = (Storage)Mockito.mock(Storage.class);
    private final Bucket bucket = (Bucket)Mockito.mock(Bucket.class);
    private final GcsTierObjectStoreConfig config = GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"prefix", (String)"region", (Integer)Predef$.MODULE$.int2Integer(10240), (String)"path", null, null);
    private final TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    private final File testFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
    private final ByteBuffer bb = ByteBuffer.allocate(0);
    private final Aead masterKey;

    public MockTime mockTime() {
        return this.mockTime;
    }

    public Storage storage() {
        return this.storage;
    }

    public Bucket bucket() {
        return this.bucket;
    }

    public GcsTierObjectStoreConfig config() {
        return this.config;
    }

    public TierObjectStore.ObjectMetadata metadata() {
        return this.metadata;
    }

    public File testFile() {
        return this.testFile;
    }

    public ByteBuffer bb() {
        return this.bb;
    }

    public Aead masterKey() {
        return this.masterKey;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.storage().get(ArgumentMatchers.anyString(), new Storage.BucketGetOption[]{(Storage.BucketGetOption)ArgumentMatchers.any(Storage.BucketGetOption.class)})).thenReturn((Object)this.bucket());
        Mockito.when((Object)this.storage().writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.any(Storage.BlobWriteOption.class)})).thenReturn(Mockito.mock(WriteChannel.class));
        Mockito.when((Object)this.storage().copy((Storage.CopyRequest)ArgumentMatchers.any(Storage.CopyRequest.class))).thenReturn(Mockito.mock(CopyWriter.class));
        Mockito.when((Object)this.bucket().getLocation()).thenReturn((Object)"REGION");
    }

    @Test
    public void testSinglePut() {
        new GcsTierObjectStore(this.storage(), null, this.config()).putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)3))).writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.doesNotExist())});
    }

    @Test
    public void testCRCWithSingleByte() {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.put((byte)1);
        buffer.flip();
        Assertions.assertEquals((Object)"oBbQUg==", (Object)GcsTierObjectStore.crc32c((ByteBuffer)buffer));
    }

    @Test
    public void testCRCWithMultiByte() {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.put(new byte[]{1, 2, 3});
        buffer.flip();
        Assertions.assertEquals((Object)"8TDyHg==", (Object)GcsTierObjectStore.crc32c((ByteBuffer)buffer));
    }

    @Test
    public void testCRCWithMultiByteAndNonZeroPosition() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        buffer.put(new byte[]{6, 5, 4, 1, 2, 3});
        buffer.flip();
        buffer.position(3);
        Assertions.assertEquals((Object)"8TDyHg==", (Object)GcsTierObjectStore.crc32c((ByteBuffer)buffer));
    }

    @Test
    public void testSinglePutWithAbortedTxns() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArgumentCaptor capturedBlobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor capturedOption = ArgumentCaptor.forClass(Storage.BlobWriteOption.class);
        objectStore.putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.of(this.bb()), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)4))).writer((BlobInfo)capturedBlobInfos.capture(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)capturedOption.capture()});
        List captureds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedBlobInfos.getAllValues()).asScala().map((Function1 & Serializable)x$1 -> x$1)).map((Function1 & Serializable)x$2 -> x$2.getCrc32c())).toList();
        Assertions.assertEquals((Object)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)"AAAAAA==", (List)Nil$.MODULE$)))), (Object)captureds);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Storage.BlobWriteOption[]{Storage.BlobWriteOption.crc32cMatch(), Storage.BlobWriteOption.doesNotExist()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedOption.getAllValues()).asScala().map((Function1 & Serializable)x$3 -> x$3)).toSet());
    }

    @Test
    public void testSinglePutProducerStateEpochState() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArgumentCaptor capturedBlobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor capturedOption = ArgumentCaptor.forClass(Storage.BlobWriteOption.class);
        objectStore.putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.of(this.testFile()), Optional.empty(), Optional.of(this.bb()));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)5))).writer((BlobInfo)capturedBlobInfos.capture(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)capturedOption.capture()});
        List captureds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedBlobInfos.getAllValues()).asScala().map((Function1 & Serializable)x$4 -> x$4)).map((Function1 & Serializable)x$5 -> x$5.getCrc32c())).toList();
        Assertions.assertEquals((Object)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)"AAAAAA==", (List)Nil$.MODULE$))))), (Object)captureds);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Storage.BlobWriteOption[]{Storage.BlobWriteOption.crc32cMatch(), Storage.BlobWriteOption.doesNotExist()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedOption.getAllValues()).asScala().map((Function1 & Serializable)x$6 -> x$6)).toSet());
    }

    @Test
    public void testDeleteAllSuccess() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        objectStore.deleteSegment(this.metadata());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)0))).get((BlobId)ArgumentMatchers.any(BlobId.class));
    }

    @Test
    public void testDeleteSomeFailedGetException() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn((Object)blob);
        try {
            objectStore.deleteSegment(this.metadata());
        }
        catch (TierObjectStoreRetriableException tierObjectStoreRetriableException) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(BlobId.class));
            ((BlobInfo)Mockito.verify((Object)blob, (VerificationMode)Mockito.atLeastOnce())).getBlobId();
            return;
        }
        Assertions.fail((String)"TierObjectStoreRetriableException should have been thrown when attempting to delete segments");
    }

    @Test
    public void testDeleteSomeFailedGetNoException() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn(null);
        objectStore.deleteSegment(this.metadata());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)2))).get((BlobId)ArgumentMatchers.any(BlobId.class));
    }

    @Test
    public void testEncryptedFetchWithNoEncryptionKeyManagerThrows() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, TierObjectStore.OpaqueData.fromByteArray((byte[])"foo".getBytes()));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.SEGMENT));
    }

    @Test
    public void testGcsTierObjectStoreConstructThrowsWithInvalidKeyConfig() {
        GcsTierObjectStoreConfig config = GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"prefix", (String)"region", (Integer)Predef$.MODULE$.int2Integer(10240), (String)"path", (String)"invalid", (Duration)Duration.ofSeconds(30L));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> new GcsTierObjectStore((Time)this.mockTime(), null, config));
    }

    @Test
    public void testPrepPutSegmentWithEncryptionKeyManager() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.OpaqueData opaqueData1 = objectStore.prepPutSegment();
        TierObjectStore.OpaqueData opaqueData2 = objectStore.prepPutSegment();
        Assertions.assertTrue((boolean)Arrays.equals(opaqueData1.intoByteArray(), opaqueData2.intoByteArray()));
        this.mockTime().sleep(31000L);
        Assertions.assertFalse((boolean)Arrays.equals(opaqueData1.intoByteArray(), objectStore.prepPutSegment().intoByteArray()));
    }

    @Test
    public void testPrepPutSegmentWithoutEncryptionKeyManager() {
        Assertions.assertTrue((boolean)Arrays.equals(new GcsTierObjectStore(this.storage(), null, this.config()).prepPutSegment().intoByteArray(), TierObjectStore.OpaqueData.ZEROED.intoByteArray()));
    }

    @ParameterizedTest
    @EnumSource(value=TierObjectStore.FileType.class)
    public void testEncryptedSegmentReadUsesEncryptionKeyManager(TierObjectStore.FileType filetype) {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        ReadChannel reader = (ReadChannel)Mockito.mock(ReadChannel.class);
        Mockito.when((Object)this.storage().reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.any()})).thenReturn((Object)reader).thenReturn((Object)reader);
        objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, filetype);
        if (filetype.equals((Object)TierObjectStore.FileType.SEGMENT)) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
            return;
        }
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.never())).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
    }

    @ParameterizedTest
    @EnumSource(value=TierObjectStore.FileType.class)
    public void testEncryptedReadRefreshesCache(TierObjectStore.FileType filetype) {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        encryptionKeyManager.clear();
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))})).thenReturn((Object)blob);
        Mockito.when((Object)blob.getMetadata()).thenReturn((Object)expectedKeyContext.metadata);
        ReadChannel reader = (ReadChannel)Mockito.mock(ReadChannel.class);
        Mockito.when((Object)this.storage().reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.any()})).thenReturn((Object)reader).thenReturn((Object)reader);
        objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, filetype);
        if (filetype.equals((Object)TierObjectStore.FileType.SEGMENT)) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))});
            return;
        }
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.never())).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.never())).get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))});
    }

    @Test
    public void testEncryptedPuts() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        objectStore.putSegment(metadata, this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).writer((BlobInfo)ArgumentMatchers.any(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.encryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded())), (Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.doesNotExist())});
    }

    @Test
    public void testEncryptedPutInMemorySegment() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        objectStore.putInMemorySegment(metadata, this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).writer((BlobInfo)ArgumentMatchers.any(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.encryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded())), (Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.doesNotExist())});
    }

    @Test
    public void testEncryptedRestoreByCopy() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        String dataKeyBase64 = encryptionKeyManager.keyContext((KeySha)keySha).cleartextDataKey.base64Encoded();
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        String versionId = "1234";
        String bucketName = "bucket";
        String segmentPath = metadata.toPath("", TierObjectStore.FileType.SEGMENT);
        BlobId source = BlobId.of((String)bucketName, (String)segmentPath, (Long)Predef$.MODULE$.long2Long(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(versionId))));
        BlobId target = BlobId.of((String)bucketName, (String)segmentPath);
        Storage.BlobTargetOption targetOption = Storage.BlobTargetOption.encryptionKey((String)dataKeyBase64);
        Storage.CopyRequest copyRequest = Storage.CopyRequest.newBuilder().setSource(source).setSourceOptions(new Storage.BlobSourceOption[]{Storage.BlobSourceOption.decryptionKey((String)dataKeyBase64)}).setTarget(target, new Storage.BlobTargetOption[]{targetOption}).build();
        objectStore.restoreObjectByCopy(metadata, segmentPath, new VersionInformation(versionId));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).copy((Storage.CopyRequest)ArgumentMatchers.argThat(new GcsStorageCopyRequestOptionsMatcher(this, copyRequest)));
        String indexFilePath = metadata.toPath("", TierObjectStore.FileType.OFFSET_INDEX);
        BlobId source2 = BlobId.of((String)bucketName, (String)indexFilePath, (Long)Predef$.MODULE$.long2Long(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(versionId))));
        BlobId target2 = BlobId.of((String)bucketName, (String)indexFilePath);
        Storage.CopyRequest copyRequest2 = Storage.CopyRequest.newBuilder().setSource(source2).setTarget(target2).build();
        objectStore.restoreObjectByCopy(metadata, indexFilePath, new VersionInformation(versionId));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).copy((Storage.CopyRequest)ArgumentMatchers.argThat(new GcsStorageCopyRequestOptionsMatcher(this, copyRequest2)));
    }

    public GcsTierObjectStoreTest() {
        AeadConfig.register();
        this.masterKey = (Aead)KeysetHandle.generateNew((KeyTemplate)KeyTemplates.get((String)"AES256_GCM_RAW")).getPrimitive(Aead.class);
    }

    public class GcsStorageCopyRequestOptionsMatcher<T>
    implements ArgumentMatcher<T> {
        private final Storage.CopyRequest copyRequest;
        public final /* synthetic */ GcsTierObjectStoreTest $outer;

        public Storage.CopyRequest copyRequest() {
            return this.copyRequest;
        }

        public boolean matches(T argument) {
            Storage.CopyRequest other = (Storage.CopyRequest)argument;
            return this.optionListMatches(this.copyRequest().getSourceOptions(), other.getSourceOptions()) && this.optionListMatches(this.copyRequest().getTargetOptions(), other.getTargetOptions());
        }

        public boolean optionListMatches(java.util.List<?> optionList1, java.util.List<?> optionList2) {
            if (optionList1 == null && optionList2 == null) {
                return true;
            }
            if (optionList1 == null) {
                return false;
            }
            if (optionList2 == null) {
                return false;
            }
            if (optionList1.size() != optionList2.size()) {
                return false;
            }
            return optionList1.containsAll(optionList2);
        }

        public /* synthetic */ GcsTierObjectStoreTest kafka$tier$store$GcsTierObjectStoreTest$GcsStorageCopyRequestOptionsMatcher$$$outer() {
            return this.$outer;
        }

        public GcsStorageCopyRequestOptionsMatcher(GcsTierObjectStoreTest $outer, Storage.CopyRequest copyRequest) {
            this.copyRequest = copyRequest;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

