/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.domain.TierTopicPartitionSnapshot;
import kafka.tier.snapshot.TierTopicSnapshotManager;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import kafka.utils.cloud.EpochAndSeqNumber;
import kafka.utils.cloud.LinkedCloudObject;
import kafka.utils.cloud.SequencedObject;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001B\u000b\u0017\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001C\u0002\u0013%\u0011\u0006\u0003\u00041\u0001\u0001\u0006IA\u000b\u0005\nc\u0001\u0001\r\u00111A\u0005\u0002IB\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011A\u001c\t\u0013u\u0002\u0001\u0019!A!B\u0013\u0019\u0004b\u0002 \u0001\u0005\u0004%\ta\u0010\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002!\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0003Q\u0005\"C)\u0001\u0001\u0004\u0005\r\u0011\"\u0001S\u0011%!\u0006\u00011A\u0001B\u0003&1\nC\u0004V\u0001\t\u0007I\u0011\u0001,\t\r-\u0004\u0001\u0015!\u0003X\u0011%a\u0007\u00011AA\u0002\u0013\u0005Q\u000eC\u0005w\u0001\u0001\u0007\t\u0019!C\u0001o\"I\u0011\u0010\u0001a\u0001\u0002\u0003\u0006KA\u001c\u0005\u0006u\u0002!\ta\u001f\u0005\u0007\u0003'\u0001A\u0011A>\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u0011Q\b\u0001\u0005\n\u0005}\"\u0001\b+jKJ$v\u000e]5d':\f\u0007o\u001d5pi6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003/a\t\u0001b\u001d8baNDw\u000e\u001e\u0006\u00033i\tA\u0001^5fe*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002MA\u0011q\u0005A\u0007\u0002-\u0005\u0019B/[3s\u001f\nTWm\u0019;Ti>\u0014X-T8dWV\t!\u0006\u0005\u0002,]5\tAF\u0003\u0002.1\u0005)1\u000f^8sK&\u0011q\u0006\f\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006!B/[3s\u001f\nTWm\u0019;Ti>\u0014X-T8dW\u0002\nq!\\1oC\u001e,'/F\u00014!\t9C'\u0003\u00026-\tAB+[3s)>\u0004\u0018nY*oCB\u001c\bn\u001c;NC:\fw-\u001a:\u0002\u00175\fg.Y4fe~#S-\u001d\u000b\u0003qm\u0002\"aH\u001d\n\u0005i\u0002#\u0001B+oSRDq\u0001P\u0003\u0002\u0002\u0003\u00071'A\u0002yIE\n\u0001\"\\1oC\u001e,'\u000fI\u0001\u0006aJ|\u0007o]\u000b\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0005kRLGNC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%A\u0003)s_B,'\u000f^5fg\u00061\u0001O]8qg\u0002\naaY8oM&<W#A&\u0011\u00051{U\"A'\u000b\u00059S\u0012AB:feZ,'/\u0003\u0002Q\u001b\nY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0003qMCq\u0001\u0010\u0006\u0002\u0002\u0003\u00071*A\u0004d_:4\u0017n\u001a\u0011\u0002A%tG/\u001a:Ce>\\WM]\"mS\u0016tGoQ8oM&<7oU;qa2LWM]\u000b\u0002/B!\u0011\t\u0017.f\u0013\tI&IA\u0002NCB\u0004\"a\u00172\u000f\u0005q\u0003\u0007CA/!\u001b\u0005q&BA0\u001d\u0003\u0019a$o\\8u}%\u0011\u0011\rI\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002bAA\u0011a-[\u0007\u0002O*\u0011\u0001\u000eR\u0001\u0005Y\u0006tw-\u0003\u0002kO\n1qJ\u00196fGR\f\u0011%\u001b8uKJ\u0014%o\\6fe\u000ec\u0017.\u001a8u\u0007>tg-[4t'V\u0004\b\u000f\\5fe\u0002\n1b\u00197pk\u0012|%M[3diV\ta\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006)1\r\\8vI*\u00111OG\u0001\u0006kRLGn]\u0005\u0003kB\u0014\u0011\u0003T5oW\u0016$7\t\\8vI>\u0013'.Z2u\u0003=\u0019Gn\\;e\u001f\nTWm\u0019;`I\u0015\fHC\u0001\u001dy\u0011\u001dat\"!AA\u00029\fAb\u00197pk\u0012|%M[3di\u0002\nQa]3u+B$\u0012\u0001\u000f\u0015\u0003#u\u00042A`A\b\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t1!\u00199j\u0015\u0011\t)!a\u0002\u0002\u000f),\b/\u001b;fe*!\u0011\u0011BA\u0006\u0003\u0015QWO\\5u\u0015\t\ti!A\u0002pe\u001eL1!!\u0005\u0000\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0013i\u0016\u001cH/\u00138ji&\fG.\u001b>bi&|g\u000eK\u0002\u0013\u0003/\u00012A`A\r\u0013\r\tYb \u0002\u0005)\u0016\u001cH/A\u0003hKR$\u0006\u000f\u0006\u0003\u0002\"\u0005M\u0002\u0003BA\u0012\u0003_i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0007G>lWn\u001c8\u000b\u0007m\tYC\u0003\u0003\u0002.\u0005-\u0011AB1qC\u000eDW-\u0003\u0003\u00022\u0005\u0015\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003k\u0019\u0002\u0019AA\u001c\u0003%\u0001\u0018M\u001d;ji&|g\u000eE\u0002 \u0003sI1!a\u000f!\u0005\rIe\u000e^\u0001\u0010i&,'\u000fV8qS\u000e\u0014VmY8sIR1\u0011\u0011IA/\u0003?\u0002\u0002\"a\u0011\u0002N\u0005E\u0013\u0011K\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005A1m\u001c8tk6,'O\u0003\u0003\u0002L\u0005%\u0012aB2mS\u0016tGo]\u0005\u0005\u0003\u001f\n)E\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\u000b}\t\u0019&a\u0016\n\u0007\u0005U\u0003EA\u0003BeJ\f\u0017\u0010E\u0002 \u00033J1!a\u0017!\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005UB\u00031\u0001\u00028!9\u0011\u0011\r\u000bA\u0002\u0005\r\u0014AB8gMN,G\u000fE\u0002 \u0003KJ1!a\u001a!\u0005\u0011auN\\4")
public class TierTopicSnapshotManagerTest {
    private final TierObjectStore tierObjectStoreMock = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private TierTopicSnapshotManager manager;
    private final Properties props;
    private KafkaConfig config;
    private final Map<String, Object> interBrokerClientConfigsSupplier;
    private LinkedCloudObject cloudObject;

    private TierObjectStore tierObjectStoreMock() {
        return this.tierObjectStoreMock;
    }

    public TierTopicSnapshotManager manager() {
        return this.manager;
    }

    public void manager_$eq(TierTopicSnapshotManager x$1) {
        this.manager = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public Map<String, Object> interBrokerClientConfigsSupplier() {
        return this.interBrokerClientConfigsSupplier;
    }

    public LinkedCloudObject cloudObject() {
        return this.cloudObject;
    }

    public void cloudObject_$eq(LinkedCloudObject x$1) {
        this.cloudObject = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.props().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), Boolean.toString(true));
        this.props().setProperty(KafkaConfig$.MODULE$.TierTopicSnapshotsEnableProp(), Boolean.toString(true));
        this.interBrokerClientConfigsSupplier().put("bootstrap.servers", "localhost:80");
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(this.props()));
    }

    @Test
    public void testInitialization() {
        TierTopicSnapshotObject snapshotObject = new TierTopicSnapshotObject(123L, 456L, new EpochAndSeqNumber(2, 1L), new EpochAndSeqNumber(2, 0L));
        HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> records = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>(this){
            {
                this.put(new TopicPartition("_confluent-tier-state", 0), Arrays.asList($outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(0, 10L), $outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(0, 15L)));
                this.put(new TopicPartition("_confluent-tier-state", 1), Arrays.asList($outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(1, 11L)));
                this.put(new TopicPartition("_confluent-tier-state", 2), Arrays.asList($outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(2, 8L), $outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(2, 20L)));
            }
        };
        ConsumerRecords consumerRecords = new ConsumerRecords((Map)records);
        ArrayList offsets = new ArrayList(50);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 49).foreach((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> offsets.add(Predef$.MODULE$.long2Long(0L)));
        TierTopicPartitionSnapshot snapshot = new TierTopicPartitionSnapshot(Arrays.asList(consumerRecords), offsets);
        List<SequencedObject> objects = Arrays.asList(snapshotObject);
        SequencedObject arg = objects.get(0);
        MockConsumer mockConsumer = new MockConsumer(OffsetResetStrategy.LATEST);
        this.manager_$eq((TierTopicSnapshotManager)Mockito.spy((Object)new TierTopicSnapshotManager((Consumer)mockConsumer, this.tierObjectStoreMock(), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.short2Short((short)50), Predef$.MODULE$.long2Long(Duration.ofMinutes(5L).toMillis()), Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.int2Integer(2), Time.SYSTEM, new Metrics())));
        ((TierTopicSnapshotManager)Mockito.doAnswer(x$5 -> snapshot).when((Object)this.manager())).snapshot(arg);
        ((TierTopicSnapshotManager)Mockito.doAnswer(x$6 -> objects).when((Object)this.manager())).latestSnapshots();
        this.manager().initialize();
        int getTp_partition = 0;
        Assertions.assertEquals((long)15L, (long)mockConsumer.position(new TopicPartition("_confluent-tier-state", getTp_partition)));
        int getTp_partition2 = 1;
        Assertions.assertEquals((long)11L, (long)mockConsumer.position(new TopicPartition("_confluent-tier-state", getTp_partition2)));
        int getTp_partition3 = 2;
        Assertions.assertEquals((long)20L, (long)mockConsumer.position(new TopicPartition("_confluent-tier-state", getTp_partition3)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 49).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)0L, (long)mockConsumer.position(new TopicPartition("_confluent-tier-state", i))));
    }

    private TopicPartition getTp(int partition) {
        return new TopicPartition("_confluent-tier-state", partition);
    }

    public ConsumerRecord<byte[], byte[]> kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(int partition, long offset) {
        return TierTopicPartitionSnapshot.makeTierTopicRecord((int)partition, (long)offset, (long)Time.SYSTEM.milliseconds(), (byte[])new byte[]{1}, (byte[])new byte[]{1}, (int)1);
    }

    public TierTopicSnapshotManagerTest() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = TestUtils$.MODULE$.MockZkPort();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var21_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var22_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var23_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        this.props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, x$3, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.interBrokerClientConfigsSupplier = new HashMap<String, Object>();
    }
}

