/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import kafka.log.LocalLog$;
import kafka.log.TierLogSegment;
import kafka.restore.snapshot.FtpsSnapshotMaterializer;
import kafka.server.Defaults$;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.ConfluentLogConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001B\u001b7\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001J\u0011\u0019y\u0005\u0001)A\u0005\u0015\"9\u0001\u000b\u0001b\u0001\n\u0003I\u0005BB)\u0001A\u0003%!\nC\u0004S\u0001\t\u0007I\u0011A*\t\r]\u0003\u0001\u0015!\u0003U\u0011\u001dA\u0006A1A\u0005\u0002eCa!\u0018\u0001!\u0002\u0013Q\u0006b\u00020\u0001\u0005\u0004%\ta\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00021\t\u000f\u001d\u0004!\u0019!C\u0001\u0013\"1\u0001\u000e\u0001Q\u0001\n)Cq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004t\u0001\u0001\u0006Ia\u001b\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0011\u0019I\b\u0001)A\u0005m\"9!\u0010\u0001b\u0001\n\u0003I\u0006BB>\u0001A\u0003%!\fC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005\r\u0001\u0001)A\u0005}\"I\u0011Q\u0001\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\n!I\u00111\u0004\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\n!I\u0011q\u0004\u0001C\u0002\u0013\u0005\u0011\u0011\u0005\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002$!I\u0011Q\u0007\u0001C\u0002\u0013\u0005\u0011q\u0007\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002:!I\u0011\u0011\u000b\u0001C\u0002\u0013\u0005\u00111\u000b\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002V!I\u0011q\f\u0001C\u0002\u0013\u0005\u0011\u0011\r\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002d!I\u0011\u0011\u0010\u0001C\u0002\u0013\u0005\u00111\u0010\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002~!A1\r\u0001b\u0001\n\u0003\t9\t\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BAE\u0011%\t\t\n\u0001b\u0001\n\u0003\t\u0019\n\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BAK\u0011%\ti\n\u0001b\u0001\n\u0003\ty\n\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAQ\u0011%\tI\u000b\u0001b\u0001\n\u0003\tY\u000b\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BAW\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!a7\u0001\t\u0003\ti\fC\u0004\u0002f\u0002!\t!a:\t\u000f\u0005E\b\u0001\"\u0001\u0002>\"9\u00111 \u0001\u0005\u0002\u0005u\u0006bBA\u0000\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0005\u0007\u0001A\u0011AA_\u0005q1E\u000f]:T]\u0006\u00048\u000f[8u\u001b\u0006$XM]5bY&TXM\u001d+fgRT!a\u000e\u001d\u0002\u0011Mt\u0017\r]:i_RT!!\u000f\u001e\u0002\tQLWM\u001d\u0006\u0002w\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001?!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0012\t\u0003\u000f\u0002i\u0011AN\u0001\u0010G\",7m[:v[\u0016s\u0017M\u00197fIV\t!\n\u0005\u0002@\u0017&\u0011A\n\u0011\u0002\b\u0005>|G.Z1o\u0003A\u0019\u0007.Z2lgVlWI\\1cY\u0016$\u0007%\u0001\bd_6\u0004\u0018m\u0019;F]\u0006\u0014G.\u001a3\u0002\u001f\r|W\u000e]1di\u0016s\u0017M\u00197fI\u0002\nab\u00197fC:,\b/\u00128bE2,G-A\bdY\u0016\fg.\u001e9F]\u0006\u0014G.\u001a3!\u00039\u0019G.Z1okB$U\r\\1z\u001bN,\u0012\u0001\u0016\t\u0003\u007fUK!A\u0016!\u0003\t1{gnZ\u0001\u0010G2,\u0017M\\;q\t\u0016d\u0017-_'tA\u0005\t2\r\\3b]V\u0004\u0018J\u001c;feZ\fG.T:\u0016\u0003i\u0003\"aP.\n\u0005q\u0003%aA%oi\u0006\u00112\r\\3b]V\u0004\u0018J\u001c;feZ\fG.T:!\u00035\u0019G.Z1okB\u001cuN\u001c4jOV\t\u0001\r\u0005\u0002bI6\t!M\u0003\u0002dq\u0005)1\u000f^1uK&\u0011QM\u0019\u0002 )&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u00117fC:,\boQ8oM&<\u0017AD2mK\u0006tW\u000f]\"p]\u001aLw\rI\u0001\"i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u00158baNDw\u000e^#oC\ndW\rZ\u0001#i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u00158baNDw\u000e^#oC\ndW\r\u001a\u0011\u0002#\rDWmY6tk6\fEnZ8sSRDW.F\u0001l!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0005dQ\u0016\u001c7n];n\u0015\t\u0001((A\u0003vi&d7/\u0003\u0002s[\nI\u0011\t\\4pe&$\b.\\\u0001\u0013G\",7m[:v[\u0006cwm\u001c:ji\"l\u0007%\u0001\ttkB,'O\u00117pG.dUM\\4uQV\ta\u000f\u0005\u0002@o&\u0011\u0001\u0010\u0011\u0002\u0006'\"|'\u000f^\u0001\u0012gV\u0004XM\u001d\"m_\u000e\\G*\u001a8hi\"\u0004\u0013\u0001\u00032s_.,'/\u00133\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013a\u00024bGR|'/_\u000b\u0002}B\u0011\u0011m`\u0005\u0004\u0003\u0003\u0011'!\u0007+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015m\u0019;pef\f\u0001BZ1di>\u0014\u0018\u0010I\u0001\na\u0006\u0014XM\u001c;ESJ,\"!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005\u0011\u0011n\u001c\u0006\u0003\u0003'\tAA[1wC&!\u0011qCA\u0007\u0005\u00111\u0015\u000e\\3\u0002\u0015A\f'/\u001a8u\t&\u0014\b%A\u0002eSJ\fA\u0001Z5sA\u0005a1O\\1qg\"|Go\u001d#jeV\u0011\u00111\u0005\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003\u00111\u0017\u000e\\3\u000b\t\u00055\u0012\u0011C\u0001\u0004]&|\u0017\u0002BA\u0019\u0003O\u0011A\u0001U1uQ\u0006i1O\\1qg\"|Go\u001d#je\u0002\n!\u0001\u001e9\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u0017j!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0007G>lWn\u001c8\u000b\u0007m\n\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013AB1qC\u000eDWM\u0003\u0002\u0002J\u0005\u0019qN]4\n\t\u00055\u0013Q\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\r!\b\u000fI\u0001\u0005iBLG-\u0006\u0002\u0002VA!\u0011qKA-\u001b\u0005A\u0014bAA.q\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0006iBLG\rI\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0005\u0005\r\u0004\u0003BA3\u0003gj!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0004Y><'\u0002BA7\u0003_\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\u0005E\u0014\u0011I\u0001\bgR|'/Y4f\u0013\u0011\t)(a\u001a\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\nA\u0001^5nKV\u0011\u0011Q\u0010\t\u0005\u0003\u007f\n\t)D\u0001p\u0013\r\t\u0019i\u001c\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fAU\u0011\u0011\u0011\u0012\t\u0004C\u0006-\u0015bAAGE\n1b)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-\u0001\u0004ti\u0006$X\rI\u0001\nY><7i\u001c8gS\u001e,\"!!&\u0011\t\u0005\u0015\u0014qS\u0005\u0005\u00033\u000b9GA\u0005M_\u001e\u001cuN\u001c4jO\u0006QAn\\4D_:4\u0017n\u001a\u0011\u0002%\r|gN\u001a7vK:$Hj\\4D_:4\u0017nZ\u000b\u0003\u0003C\u0003B!!\u001a\u0002$&!\u0011QUA4\u0005I\u0019uN\u001c4mk\u0016tG\u000fT8h\u0007>tg-[4\u0002'\r|gN\u001a7vK:$Hj\\4D_:4\u0017n\u001a\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011Q\u0016\t\u0005\u0003_\u000b),\u0004\u0002\u00022*\u0019\u00111\u0017\u001e\u0002\rM,'O^3s\u0013\u0011\t9,!-\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\u0003tKR,\b\u000f\u0006\u0002\u0002@B\u0019q(!1\n\u0007\u0005\r\u0007I\u0001\u0003V]&$\bf\u0001\u0018\u0002HB!\u0011\u0011ZAl\u001b\t\tYM\u0003\u0003\u0002N\u0006=\u0017aA1qS*!\u0011\u0011[Aj\u0003\u001dQW\u000f]5uKJTA!!6\u0002H\u0005)!.\u001e8ji&!\u0011\u0011\\Af\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fZ8x]\"\u001aq&a8\u0011\t\u0005%\u0017\u0011]\u0005\u0005\u0003G\fYMA\u0005BMR,'/R1dQ\u0006a2M]3bi\u00164E\u000f]:T]\u0006\u00048\u000f[8u\u0005f$XMQ;gM\u0016\u0014HCAAu!\u0011\tY/!<\u000e\u0005\u0005-\u0012\u0002BAx\u0003W\u0011!BQ=uK\n+hMZ3s\u0003\r\"Xm\u001d;GiB\u001c8K\\1qg\"|G/T1uKJL\u0017\r\\5{KJ\u0014Vm\u001d;pe\u0016D3!MA{!\u0011\tI-a>\n\t\u0005e\u00181\u001a\u0002\u0005)\u0016\u001cH/\u0001\u001buKN$h\t\u001e9t':\f\u0007o\u001d5pi6\u000bG/\u001a:jC2L'0\u001a:SKN$xN]3BMR,'/T;uCR,Gm\u0015;bi\u0016D3AMA{\u0003I\"Xm\u001d;GiB\u001c8K\\1qg\"|G/T1uKJL\u0017\r\\5{KJLeN^1mS\u0012,6/Z!gi\u0016\u00148\t\\3b]V\u0004\bfA\u001a\u0002v\u0006AC/Z:u\rR\u00048o\u00158baNDw\u000e^'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\u001c<bY&$Wk]1hK\"\u001aA'!>")
public class FtpsSnapshotMaterializerTest {
    private final boolean checksumEnabled;
    private final boolean compactEnabled;
    private final boolean cleanupEnabled;
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final TierPartitionStateCleanupConfig cleanupConfig = new TierPartitionStateCleanupConfig(this.cleanupEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs());
    private final boolean tierPartitionStateSnapshotEnabled;
    private final Algorithm checksumAlgorithm = CheckedFileIOTestUtils$.MODULE$.checksumAlgorithm(this.checksumEnabled());
    private final short superBlockLength = CheckedFileIOTestUtils$.MODULE$.superBlockLength(this.checksumEnabled());
    private final int brokerId;
    private final TierPartitionStateFactory factory = new TierPartitionStateFactory(true, this.checksumEnabled(), this.compactEnabled(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
    private final File parentDir = TestUtils.tempDirectory(null, null);
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
    private final Path snapshotsDir = this.dir().toPath().resolve("snapshots");
    private final TopicPartition tp;
    private final TopicIdPartition tpid;
    private final LogDirFailureChannel logDirFailureChannel;
    private final MockTime time;
    private final FileTierPartitionState state;
    private final LogConfig logConfig;
    private final ConfluentLogConfig confluentLogConfig;
    private final ReplicaManager replicaManager;

    public boolean checksumEnabled() {
        return this.checksumEnabled;
    }

    public boolean compactEnabled() {
        return this.compactEnabled;
    }

    public boolean cleanupEnabled() {
        return this.cleanupEnabled;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public TierPartitionStateCleanupConfig cleanupConfig() {
        return this.cleanupConfig;
    }

    public boolean tierPartitionStateSnapshotEnabled() {
        return this.tierPartitionStateSnapshotEnabled;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public short superBlockLength() {
        return this.superBlockLength;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TierPartitionStateFactory factory() {
        return this.factory;
    }

    public File parentDir() {
        return this.parentDir;
    }

    public File dir() {
        return this.dir;
    }

    public Path snapshotsDir() {
        return this.snapshotsDir;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime time() {
        return this.time;
    }

    public FileTierPartitionState state() {
        return this.state;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public ConfluentLogConfig confluentLogConfig() {
        return this.confluentLogConfig;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @BeforeEach
    public void setup() {
        this.state().setTopicId(this.tpid().topicId());
        this.state().setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ debug_this = TestUtils$.MODULE$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = FtpsSnapshotMaterializerTest.$anonfun$setup$2(this, op);
                Object var3_3 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)debug_this, (String)msgWithLogIdent_msg));
                return;
            }
        });
        this.state().beginCatchup();
        this.state().onCatchUpComplete();
        Mockito.when((Object)this.logConfig().confluentLogConfig()).thenReturn((Object)this.confluentLogConfig());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.confluentLogConfig().tierEnable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TierTestUtils$.MODULE$.initTierTopicOffset();
        Mockito.when((Object)this.replicaManager().liveLogDirs()).thenReturn((Object)new .colon.colon((Object)Paths.get("/tmp/ftpsSnapshotMaterializerTest", new String[0]).toFile(), (List)Nil$.MODULE$));
    }

    @AfterEach
    public void teardown() {
        this.state().close();
        this.dir().delete();
        this.parentDir().delete();
    }

    public ByteBuffer createFtpsSnapshotByteBuffer() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0);
        UUID objectId1 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(3))), this.time().milliseconds());
        UUID objectId2 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(5))), this.time().milliseconds());
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractTierMetadata[]{initLeader, uploadInitiate1, uploadComplete1, uploadInitiate2, uploadComplete2, deleteInitiate1, deleteComplete1, deleteInitiate2, deleteComplete2})).foreach((Function1 & Serializable)transition -> {
            Assertions.assertEquals((Object)this.state().append(transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()), (Object)TierPartitionState.AppendResult.ACCEPTED);
            return (ListBuffer)currentTransitions.$plus$eq(transition);
        });
        Assertions.assertTrue((boolean)this.state().flush());
        return CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
    }

    @Test
    public void testFtpsSnapshotMaterializerRestore() {
        ByteBuffer ftpsSnapshotByteBuffer = this.createFtpsSnapshotByteBuffer();
        Option ftpsSnapshotMaterializer = Option$.MODULE$.empty();
        try {
            ftpsSnapshotMaterializer = new Some((Object)new FtpsSnapshotMaterializer(this.replicaManager().liveLogDirs().toString()));
            FileTierPartitionState materializedFtps = ((FtpsSnapshotMaterializer)ftpsSnapshotMaterializer.get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), (Time)this.time());
            List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().toList();
            Set deletedSegments = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(this.state(), -1L)).asScala().toSet();
            TierTestUtils$.MODULE$.verifyFtpsEntries(materializedFtps, (List<TierLogSegment>)segments, (Set<UUID>)deletedSegments, this.cleanupEnabled(), this.time().milliseconds());
        }
        finally {
            ftpsSnapshotMaterializer.foreach((Function1 & Serializable)x$1 -> {
                x$1.cleanup();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testFtpsSnapshotMaterializerRestoreAfterMutatedState() {
        Option ftpsSnapshotMaterializer = Option$.MODULE$.empty();
        try {
            ftpsSnapshotMaterializer = new Some((Object)new FtpsSnapshotMaterializer(this.replicaManager().liveLogDirs().toString()));
            FileTierPartitionState materializedFtps = ((FtpsSnapshotMaterializer)ftpsSnapshotMaterializer.get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), this.createFtpsSnapshotByteBuffer(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), (Time)this.time());
            List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().toList();
            Set deletedSegments = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(this.state(), -1L)).asScala().toSet();
            UUID objectId3 = UUID.randomUUID();
            TierSegmentUploadInitiate uploadInitiate3 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, 21L, 30L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, new OffsetAndEpoch(9L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED);
            TierSegmentUploadComplete uploadComplete3 = new TierSegmentUploadComplete(this.tpid(), 0, objectId3, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(5))));
            new .colon.colon((Object)uploadInitiate3, (List)new .colon.colon((Object)uploadComplete3, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)transition -> {
                FtpsSnapshotMaterializerTest.$anonfun$testFtpsSnapshotMaterializerRestoreAfterMutatedState$1(this, transition);
                return BoxedUnit.UNIT;
            });
            Assertions.assertTrue((boolean)this.state().flush());
            Assertions.assertEquals((Object)this.state().status(), (Object)TierPartitionStatus.ONLINE);
            TierTestUtils$.MODULE$.verifyFtpsEntries(materializedFtps, (List<TierLogSegment>)segments, (Set<UUID>)deletedSegments, this.cleanupEnabled(), this.time().milliseconds());
        }
        finally {
            ftpsSnapshotMaterializer.foreach((Function1 & Serializable)x$2 -> {
                x$2.cleanup();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testFtpsSnapshotMaterializerInvalidUseAfterCleanup() {
        ByteBuffer ftpsSnapshotByteBuffer = this.createFtpsSnapshotByteBuffer();
        ObjectRef ftpsSnapshotMaterializer = ObjectRef.create((Object)Option$.MODULE$.empty());
        try {
            ftpsSnapshotMaterializer.elem = new Some((Object)new FtpsSnapshotMaterializer(this.replicaManager().liveLogDirs().toString()));
            FileTierPartitionState materializedFtps = ((FtpsSnapshotMaterializer)((Option)ftpsSnapshotMaterializer.elem).get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), (Time)this.time());
            List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().toList();
            Set deletedSegments = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(this.state(), -1L)).asScala().toSet();
            TierTestUtils$.MODULE$.verifyFtpsEntries(materializedFtps, (List<TierLogSegment>)segments, (Set<UUID>)deletedSegments, this.cleanupEnabled(), this.time().milliseconds());
            Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ((FtpsSnapshotMaterializer)((Option)ftpsSnapshotMaterializer$1.elem).get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), (Time)this.time()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("FtpsSnapshotMaterializerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }
        finally {
            ((Option)ftpsSnapshotMaterializer.elem).foreach((Function1 & Serializable)x$3 -> {
                x$3.cleanup();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testFtpsSnapshotMaterializerInvalidUsage() {
        ByteBuffer ftpsSnapshotByteBuffer = this.createFtpsSnapshotByteBuffer();
        ObjectRef ftpsSnapshotMaterializer = ObjectRef.create((Object)Option$.MODULE$.empty());
        try {
            ftpsSnapshotMaterializer.elem = new Some((Object)new FtpsSnapshotMaterializer(this.replicaManager().liveLogDirs().toString()));
            FileTierPartitionState materializedFtps = ((FtpsSnapshotMaterializer)((Option)ftpsSnapshotMaterializer.elem).get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), (Time)this.time());
            List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().toList();
            Set deletedSegments = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(this.state(), -1L)).asScala().toSet();
            TierTestUtils$.MODULE$.verifyFtpsEntries(materializedFtps, (List<TierLogSegment>)segments, (Set<UUID>)deletedSegments, this.cleanupEnabled(), this.time().milliseconds());
            Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ((FtpsSnapshotMaterializer)((Option)ftpsSnapshotMaterializer$2.elem).get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), (Time)this.time()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("FtpsSnapshotMaterializerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        }
        finally {
            ((Option)ftpsSnapshotMaterializer.elem).foreach((Function1 & Serializable)x$4 -> {
                x$4.cleanup();
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ String $anonfun$setup$2(FtpsSnapshotMaterializerTest $this, TierPartitionState.RecoveryOperation op$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append($this.state().topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testFtpsSnapshotMaterializerRestoreAfterMutatedState$1(FtpsSnapshotMaterializerTest $this, AbstractTierSegmentMetadata transition) {
        Assertions.assertEquals((Object)$this.state().append((AbstractTierMetadata)transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()), (Object)TierPartitionState.AppendResult.ACCEPTED);
    }

    public FtpsSnapshotMaterializerTest() {
        this.checksumEnabled = true;
        this.compactEnabled = true;
        this.cleanupEnabled = true;
        this.cleanupIntervalMs = 0;
        this.tierPartitionStateSnapshotEnabled = false;
        this.brokerId = 0;
        File parseTopicPartitionName_dir = this.dir();
        Object var1_1 = null;
        this.tp = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.tpid = new TopicIdPartition(this.tp().topic(), UUID.randomUUID(), this.tp().partition());
        this.logDirFailureChannel = new LogDirFailureChannel(5);
        this.time = new MockTime();
        this.state = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        this.logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        this.confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        this.replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    }
}

