/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.raft.KRaftSnapshotObjectUtils;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KRaftSnapshotObjectUtilsTest {
    MockTime mockTime = new MockTime();
    MockInMemoryTierObjectStore tierObjectStore;
    String keyPrefix = "";
    int partition = 0;
    String clusterId = "pkc-abc";

    @BeforeEach
    public void setUp() {
        this.tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime, new MockInMemoryTierObjectStoreConfig());
        this.tierObjectStore.clearForClusterId();
    }

    @AfterEach
    public void tearDown() {
        this.tierObjectStore.clearForClusterId();
        this.tierObjectStore.close();
    }

    @Test
    public void testList() throws IOException {
        KRaftSnapshotObject snapshotObject = new KRaftSnapshotObject(Uuid.randomUuid(), this.partition, this.clusterId, 1, 234L, new OffsetAndEpoch(567L, 89));
        File file = TestUtils.tempFile();
        file.createNewFile();
        TierObjectStore.KRaftSnapshotMetadata metadata = new TierObjectStore.KRaftSnapshotMetadata(snapshotObject);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (TierObjectStore.KRaftSnapshotMetadata)metadata, (File)file);
        Map objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Collections.singletonList(snapshotObject)), objects.keySet());
        objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)"randomPrefix");
        Assertions.assertEquals(new HashSet(Collections.emptyList()), objects.keySet());
    }

    @Test
    public void testListByNode() throws IOException {
        Uuid topicId = Uuid.randomUuid();
        int nodeId1 = 1;
        int nodeId2 = 2;
        KRaftSnapshotObject snapshotObjectNodeId1 = new KRaftSnapshotObject(topicId, this.partition, this.clusterId, nodeId1, 234L, new OffsetAndEpoch(567L, 89));
        KRaftSnapshotObject snapshotObjectNodeId2 = new KRaftSnapshotObject(topicId, this.partition, this.clusterId, nodeId2, 1L, new OffsetAndEpoch(23L, 45));
        KRaftSnapshotObject snapshotObjectNodeId2Another = new KRaftSnapshotObject(topicId, this.partition, this.clusterId, nodeId2, 12L, new OffsetAndEpoch(34L, 56));
        File file = TestUtils.tempFile();
        file.createNewFile();
        TierObjectStore.KRaftSnapshotMetadata metadata1 = new TierObjectStore.KRaftSnapshotMetadata(snapshotObjectNodeId1);
        TierObjectStore.KRaftSnapshotMetadata metadata2 = new TierObjectStore.KRaftSnapshotMetadata(snapshotObjectNodeId2);
        TierObjectStore.KRaftSnapshotMetadata metadata2Another = new TierObjectStore.KRaftSnapshotMetadata(snapshotObjectNodeId2Another);
        this.tierObjectStore.putObject((TierObjectStore.ObjectStoreMetadata)metadata1, file, TierObjectStore.FileType.KRAFT_SNAPSHOT);
        this.tierObjectStore.putObject((TierObjectStore.ObjectStoreMetadata)metadata2, file, TierObjectStore.FileType.KRAFT_SNAPSHOT);
        this.tierObjectStore.putObject((TierObjectStore.ObjectStoreMetadata)metadata2Another, file, TierObjectStore.FileType.KRAFT_SNAPSHOT);
        Map objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Arrays.asList(snapshotObjectNodeId1, snapshotObjectNodeId2, snapshotObjectNodeId2Another)), objects.keySet());
        objects = KRaftSnapshotObjectUtils.listObjectsByNode((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix, (Uuid)topicId, (int)this.partition, (String)this.clusterId, (int)nodeId1);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Collections.singletonList(snapshotObjectNodeId1)), objects.keySet());
        objects = KRaftSnapshotObjectUtils.listObjectsByNode((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix, (Uuid)topicId, (int)this.partition, (String)this.clusterId, (int)nodeId2);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Arrays.asList(snapshotObjectNodeId2, snapshotObjectNodeId2Another)), objects.keySet());
    }

    @Test
    public void testGetVersion() throws IOException {
        Uuid topicId = Uuid.randomUuid();
        KRaftSnapshotObject snapshotObject = new KRaftSnapshotObject(topicId, this.partition, this.clusterId, 1, 234L, new OffsetAndEpoch(567L, 89));
        File file = TestUtils.tempFile();
        file.createNewFile();
        TierObjectStore.KRaftSnapshotMetadata metadata = new TierObjectStore.KRaftSnapshotMetadata(snapshotObject);
        this.tierObjectStore.putObject((TierObjectStore.ObjectStoreMetadata)metadata, file, TierObjectStore.FileType.KRAFT_SNAPSHOT);
        Map objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)true, (String)this.keyPrefix);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Collections.singletonList(snapshotObject)), objects.keySet());
        VersionInformation versionInformation = (VersionInformation)((List)objects.values().iterator().next()).get(0);
        Assertions.assertDoesNotThrow(() -> KRaftSnapshotObjectUtils.getObject((TierObjectStore)this.tierObjectStore, (TierObjectStore.KRaftSnapshotMetadata)metadata, (VersionInformation)versionInformation));
    }
}

