/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.util.OptionalInt;
import java.util.UUID;
import kafka.tier.fetcher.offsetcache.FetchOffsetCache;
import kafka.tier.fetcher.offsetcache.FetchOffsetMetadata;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FetchOffsetCacheTest {
    @Test
    public void offsetCacheExpiry() {
        MockTime time = new MockTime(0L, 0L, 0L);
        FetchOffsetCache offsetCache = new FetchOffsetCache((Time)time, 100, 100);
        UUID objectId1 = UUID.randomUUID();
        offsetCache.put(objectId1, 100L, 100, OptionalInt.of(200));
        FetchOffsetMetadata cached1 = offsetCache.get(objectId1, 100L);
        Assertions.assertEquals((int)200, (int)cached1.recordBatchSize.getAsInt());
        Assertions.assertEquals((double)1.0, (double)offsetCache.hitRatio(), (double)1.0E-6);
        time.sleep(99L);
        offsetCache.expireEntries();
        FetchOffsetMetadata cached2 = offsetCache.get(objectId1, 100L);
        Assertions.assertEquals((int)200, (int)cached2.recordBatchSize.getAsInt(), (String)"entry should still be present within expiry time");
        Assertions.assertEquals((double)1.0, (double)offsetCache.hitRatio(), (double)1.0E-6);
        time.sleep(50L);
        Assertions.assertEquals((long)1L, (long)offsetCache.size(), (String)"expiration timestamp should have been refreshed due to cache hit");
        time.sleep(50L);
        offsetCache.expireEntries();
        Assertions.assertNull((Object)offsetCache.get(objectId1, 100L));
        Assertions.assertEquals((long)0L, (long)offsetCache.size(), (String)"entry should have expired");
        Assertions.assertEquals((double)0.66666666666666, (double)offsetCache.hitRatio(), (double)1.0E-6);
    }

    @Test
    public void offsetCacheMaxSize() {
        MockTime time = new MockTime(0L, 0L, 0L);
        FetchOffsetCache offsetCache = new FetchOffsetCache((Time)time, 2, 100);
        UUID objectId1 = UUID.randomUUID();
        offsetCache.put(objectId1, 100L, 100, OptionalInt.of(200));
        offsetCache.put(objectId1, 200L, 100, OptionalInt.of(200));
        offsetCache.put(objectId1, 300L, 100, OptionalInt.of(200));
        Assertions.assertEquals((long)2L, (long)offsetCache.size());
        Assertions.assertNull((Object)offsetCache.get(objectId1, 100L), (String)"least recent entry should have expired");
        Assertions.assertNotNull((Object)offsetCache.get(objectId1, 200L));
        Assertions.assertNotNull((Object)offsetCache.get(objectId1, 300L));
        Assertions.assertEquals((double)0.66666666666666, (double)offsetCache.hitRatio(), (double)1.0E-6);
        Assertions.assertEquals((long)2L, (long)offsetCache.size());
    }

    @Test
    public void offsetCacheDisable() {
        MockTime time = new MockTime(0L, 0L, 0L);
        FetchOffsetCache offsetCache = new FetchOffsetCache((Time)time, 0, 100);
        Assertions.assertFalse((boolean)offsetCache.enabled(), (String)"expected TierFetcher cache enabled to be false");
        UUID objectId = UUID.randomUUID();
        offsetCache.put(objectId, 100L, 100, OptionalInt.of(200));
        FetchOffsetMetadata cached = offsetCache.get(objectId, 100L);
        Assertions.assertNull((Object)cached);
    }
}

