/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.state.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierMetadataSnapshotUploadInitiateTest {
    @Test
    public void testTierMetadataSnapshotInitiateSerializationDeserialization() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        OffsetAndEpoch offsetEpoch = new OffsetAndEpoch(11L, Optional.of(12));
        UUID randomId = UUID.randomUUID();
        int brokerId = 3;
        TierMetadataSnapshotUploadInitiate actual = new TierMetadataSnapshotUploadInitiate(topicIdPartition, 5, randomId, offsetEpoch, brokerId);
        TierMetadataSnapshotUploadInitiate fromSerialized = new TierMetadataSnapshotUploadInitiate(topicIdPartition, actual.metadata);
        Assertions.assertEquals((Object)actual, (Object)fromSerialized);
        Assertions.assertEquals((Object)fromSerialized.stateOffsetAndEpoch(), (Object)offsetEpoch);
        Assertions.assertEquals((int)fromSerialized.tierEpoch(), (int)5);
        Assertions.assertEquals((Object)fromSerialized.messageId(), (Object)randomId);
        Assertions.assertEquals((Object)fromSerialized.topicIdPartition(), (Object)topicIdPartition);
        Assertions.assertEquals((int)fromSerialized.brokerId(), (int)brokerId);
    }

    @Test
    public void testAbstractTierMetadataCompatibleSerializationDeserialization() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        OffsetAndEpoch offsetEpoch = new OffsetAndEpoch(11L, Optional.of(12));
        UUID randomId = UUID.randomUUID();
        TierMetadataSnapshotUploadInitiate actual = new TierMetadataSnapshotUploadInitiate(topicIdPartition, 5, randomId, offsetEpoch, 6);
        TierMetadataSnapshotUploadInitiate derived = (TierMetadataSnapshotUploadInitiate)AbstractTierMetadata.deserialize((byte[])actual.serializeKey(), (byte[])actual.serializeValue(), (long)0L).get();
        Assertions.assertEquals((Object)actual, (Object)derived);
    }
}

