/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.OffsetAndEpoch;
import kafka.utils.checksum.Algorithm;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TierMetadataSnapshotUploadCompleteTest {
    private final TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
    private final long snapshotTimestampMs = 123L;
    private final OffsetAndEpoch stateOffsetEpoch = new OffsetAndEpoch(11L, Optional.of(12));
    private final OffsetAndEpoch snapshotOffsetEpoch = new OffsetAndEpoch(12L, Optional.of(12));
    private final int tierEpoch = 5;
    private UUID randomId;
    private TierMetadataSnapshotUploadComplete actual;

    @BeforeEach
    public void setUp() {
        this.randomId = UUID.randomUUID();
        this.actual = new TierMetadataSnapshotUploadComplete(this.topicIdPartition, 5, this.randomId, this.stateOffsetEpoch, this.snapshotOffsetEpoch, 123L, Algorithm.ADLER.id.byteValue());
    }

    @Test
    public void testTierMetadataSnapshotCompleteSerializationDeserialization() {
        TierMetadataSnapshotUploadComplete fromSerialized = new TierMetadataSnapshotUploadComplete(this.topicIdPartition, this.actual.metadata);
        Assertions.assertEquals((Object)this.actual, (Object)fromSerialized);
        Assertions.assertEquals((Object)fromSerialized.stateOffsetAndEpoch(), (Object)this.stateOffsetEpoch);
        Assertions.assertEquals((Object)fromSerialized.snapshotOffsetAndEpoch(), (Object)this.snapshotOffsetEpoch);
        Assertions.assertEquals((int)fromSerialized.tierEpoch(), (int)5);
        Assertions.assertEquals((Object)fromSerialized.messageId(), (Object)this.randomId);
        Assertions.assertEquals((Object)fromSerialized.topicIdPartition(), (Object)this.topicIdPartition);
        Assertions.assertEquals((long)fromSerialized.snapshotTimestampMs(), (long)123L);
    }

    @Test
    public void testAbstractTierMetadataCompatibleSerializationDeserialization() {
        TierMetadataSnapshotUploadComplete derived = (TierMetadataSnapshotUploadComplete)AbstractTierMetadata.deserialize((byte[])this.actual.serializeKey(), (byte[])this.actual.serializeValue(), (long)0L).get();
        Assertions.assertEquals((Object)this.actual, (Object)derived);
    }

    @Test
    public void testConstructFromFTPSSnapshotObject() {
        boolean brokerId = false;
        TierMetadataSnapshotUploadInitiate uploadInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition, 5, this.randomId, this.stateOffsetEpoch, 0);
        String baseName = "00000000000000000000.tierstate.snapshot.adler";
        FileTierPartitionStateSnapshotObject snapshotObject = new FileTierPartitionStateSnapshotObject(this.randomId, 123L, this.snapshotOffsetEpoch, 5, "00000000000000000000.tierstate.snapshot.adler", Algorithm.ADLER);
        TierMetadataSnapshotUploadComplete uploadComplete = new TierMetadataSnapshotUploadComplete(uploadInitiate, snapshotObject);
        Assertions.assertEquals((Object)this.actual, (Object)uploadComplete);
        Assertions.assertEquals((Object)this.stateOffsetEpoch, (Object)uploadComplete.stateOffsetAndEpoch());
        Assertions.assertEquals((Object)this.snapshotOffsetEpoch, (Object)uploadComplete.snapshotOffsetAndEpoch());
    }
}

