/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupObjectLifecycle;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.backupRestore.objectLifecycle.serdes.Header;
import kafka.backupRestore.objectLifecycle.serdes.LifecycleManagerState;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupObjectLifecycle.LifecycleManager;
import kafka.tier.backupObjectLifecycle.LifecycleManagerConfig;
import kafka.tier.backupObjectLifecycle.NameAndId;
import kafka.tier.backupObjectLifecycle.StateManager;
import kafka.tier.backupObjectLifecycle.StateManagerConfig;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.cloud.EpochAndSeqNumber;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001\u0002\u0010 \u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004A\u0001\u0001\u0006Ia\r\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0011\u0019A\u0005\u0001)A\u0005\u0007\"9\u0011\n\u0001a\u0001\n\u0003Q\u0005bB*\u0001\u0001\u0004%\t\u0001\u0016\u0005\u00075\u0002\u0001\u000b\u0015B&\t\u000fm\u0003\u0001\u0019!C\u00019\"91\r\u0001a\u0001\n\u0003!\u0007B\u00024\u0001A\u0003&Q\fC\u0004h\u0001\t\u0007I\u0011\u00015\t\r=\u0004\u0001\u0015!\u0003j\u0011\u001d\u0001\bA1A\u0005\u0002EDa!\u001e\u0001!\u0002\u0013\u0011\bb\u0002<\u0001\u0005\u0004%\ta\u001e\u0005\u0007}\u0002\u0001\u000b\u0011\u0002=\t\u0011}\u0004!\u0019!C\u0001\u0003\u0003A\u0001\"a\u0003\u0001A\u0003%\u00111\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t9\u0003\u0001C\u0001\u0003\u001fAq!a\u000b\u0001\t\u0003\ty\u0001C\u0004\u00020\u0001!\t!a\u0004\t\u000f\u0005M\u0002\u0001\"\u0001\u0002\u0010!9\u0011q\u0007\u0001\u0005\u0002\u0005=\u0001bBA\u001e\u0001\u0011%\u0011Q\b\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!!'\u0001\t\u0013\tYJA\u0013CC\u000e\\W\u000f](cU\u0016\u001cG\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:V]&$H+Z:ug*\u0011\u0001%I\u0001\u0016E\u0006\u001c7.\u001e9PE*,7\r\u001e'jM\u0016\u001c\u0017p\u00197f\u0015\t\u00113%\u0001\u0003uS\u0016\u0014(\"\u0001\u0013\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0003C\u0001\u0019\u0001\u001b\u0005y\u0012\u0001\u0002;j[\u0016,\u0012a\r\t\u0003iyj\u0011!\u000e\u0006\u0003m]\nQ!\u001e;jYNT!\u0001O\u001d\u0002\r\r|W.\\8o\u0015\t!#H\u0003\u0002<y\u00051\u0011\r]1dQ\u0016T\u0011!P\u0001\u0004_J<\u0017BA 6\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aB7fiJL7m]\u000b\u0002\u0007B\u0011AIR\u0007\u0002\u000b*\u0011\u0011iN\u0005\u0003\u000f\u0016\u0013q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u0015\u0001(o\u001c9t+\u0005Y\u0005C\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0011)H/\u001b7\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00039s_B\u001cx\fJ3r)\t)\u0006\f\u0005\u0002)-&\u0011q+\u000b\u0002\u0005+:LG\u000fC\u0004Z\u000f\u0005\u0005\t\u0019A&\u0002\u0007a$\u0013'\u0001\u0004qe>\u00048\u000fI\u0001\u0007G>tg-[4\u0016\u0003u\u0003\"AX1\u000e\u0003}S!\u0001Y\u0012\u0002\rM,'O^3s\u0013\t\u0011wLA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR\u0011Q+\u001a\u0005\b3*\t\t\u00111\u0001^\u0003\u001d\u0019wN\u001c4jO\u0002\n\u0011b\u00197vgR,'/\u00133\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\\(\u0002\t1\fgnZ\u0005\u0003].\u0014aa\u0015;sS:<\u0017AC2mkN$XM]%eA\u0005)\u0011\rZ7j]V\t!\u000f\u0005\u0002_g&\u0011Ao\u0018\u0002\u000e\u0013:$XM\u001d8bY\u0006#W.\u001b8\u0002\r\u0005$W.\u001b8!\u0003-y'M[3diN#xN]3\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a_\u0011\u0002\u000bM$xN]3\n\u0005uT(aG'pG.Le.T3n_JLH+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0001\u0007pE*,7\r^*u_J,\u0007%\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]V\u0011\u00111\u0001\t\u0005\u0003\u000b\t9!D\u0001\"\u0013\r\tI!\t\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f\u0011\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8!\u0003\t\"Xm\u001d;MS\u001a,7-_2mK\u001a{'\u000fV5feR{\u0007/[2T]\u0006\u00048\u000f[8ugR\tQ\u000bK\u0002\u0015\u0003'\u0001B!!\u0006\u0002$5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0002ba&TA!!\b\u0002 \u00059!.\u001e9ji\u0016\u0014(bAA\u0011y\u0005)!.\u001e8ji&!\u0011QEA\f\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f^\"M\u001b6+8\u000f\u001e(pi\u0012+G.\u001a;f\u0019&4Xm\u00142kK\u000e$8\u000fK\u0002\u0016\u0003'\tQ\u0005^3ti2Kg-Z2zG2,W*\u00198bO\u0016\u00148\u000b^1uK\u0012K7oY1sI\u000e\u000b7/Z:)\u0007Y\t\u0019\"A\u0015uKN$8\tT'SKR,(O\\:Va\u0012\fG/\u001a3Ti\u0006$X-\u00114uKJ\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u0004/\u0005M\u0011a\u0007;fgR\u0014V\r^3oi&|g\u000eV8CC\u000e\\W\u000f]\"p]\u001aLw\rK\u0002\u0019\u0003'\t1\u0004^3tiJ+7m\u001c8gS\u001e,(/\u001a\"bG.,\b\u000fU8mS\u000eL\bfA\r\u0002\u0014\u0005\u0001B.\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\u000b\u0005\u0003\u007f\t)\u0005E\u00021\u0003\u0003J1!a\u0011 \u0005Aa\u0015NZ3ds\u000edW-T1oC\u001e,'\u000f\u0003\u0004w5\u0001\u0007\u0011q\t\t\u0004s\u0006%\u0013bAA&u\nyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\ffqR\u0014\u0018m\u0019;Qe\u00164\u0017\u000e_!oI\u000e{W\u000e]1sKRA\u0011\u0011KA,\u0003_\nI\bE\u0002)\u0003'J1!!\u0016*\u0005\u001d\u0011un\u001c7fC:Dq!!\u0017\u001c\u0001\u0004\tY&A\u0002lKf\u0004B!!\u0018\u0002l9!\u0011qLA4!\r\t\t'K\u0007\u0003\u0003GR1!!\u001a&\u0003\u0019a$o\\8u}%\u0019\u0011\u0011N\u0015\u0002\rA\u0013X\rZ3g\u0013\rq\u0017Q\u000e\u0006\u0004\u0003SJ\u0003bBA97\u0001\u0007\u00111O\u0001\t_\nTWm\u0019;JIB\u0019A*!\u001e\n\u0007\u0005]TJ\u0001\u0003V+&#\u0005BB@\u001c\u0001\u0004\t\u0019!\u0001\rcC\u000e\\W\u000f](cU\u0016\u001cG\u000fT5tiN\u0004&/Z:f]R$b!!\u0015\u0002\u0000\u0005\r\u0005bBAA9\u0001\u0007\u00111L\u0001\u0005I\u0006$X\rC\u0004\u0002\u0006r\u0001\r!a\"\u0002\u000b9\fW.Z:\u0011\r\u0005%\u00151SA.\u001d\u0011\tY)a$\u000f\t\u0005\u0005\u0014QR\u0005\u0002U%\u0019\u0011\u0011S\u0015\u0002\u000fA\f7m[1hK&!\u0011QSAL\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005E\u0015&\u0001\u0013va2|\u0017\r\u001a\"bG.,\bo\u00142kK\u000e$8\u000fT5ti^KG\u000f\u001b#v[6LH)\u0019;b)\u0015)\u0016QTAP\u0011\u001d\t\t)\ba\u0001\u00037Bq!!\"\u001e\u0001\u0004\t9\t")
public class BackupObjectLifecycleManagerUnitTests {
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
    private KafkaConfig config;
    private final String clusterId;
    private final InternalAdmin admin;
    private final MockInMemoryTierObjectStore objectStore;
    private final TopicIdPartition topicIdPartition;

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Properties props() {
        return this.props;
    }

    public void props_$eq(Properties x$1) {
        this.props = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public InternalAdmin admin() {
        return this.admin;
    }

    public MockInMemoryTierObjectStore objectStore() {
        return this.objectStore;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Test
    public void testLifecycleForTierTopicSnapshots() {
        ByteBuffer b = ByteBuffer.allocate(100);
        long currentTimestampMs = this.time().milliseconds();
        long pastRetentionMs = TimeUnit.DAYS.toMillis(10L);
        TierTopicSnapshotObject snapshotObject1 = new TierTopicSnapshotObject(currentTimestampMs - pastRetentionMs, currentTimestampMs - pastRetentionMs, new EpochAndSeqNumber(3, 0L), new EpochAndSeqNumber(2, 4L));
        TierObjectStore.TierTopicSnapshotMetadata obj1 = new TierObjectStore.TierTopicSnapshotMetadata(snapshotObject1);
        this.objectStore().putBuffer((TierObjectStore.ObjectStoreMetadata)obj1, b, TierObjectStore.FileType.TIER_TOPIC_SNAPSHOT);
        TierTopicSnapshotObject snapshotObject2 = new TierTopicSnapshotObject(currentTimestampMs, currentTimestampMs, new EpochAndSeqNumber(7, 0L), new EpochAndSeqNumber(6, 4L));
        TierObjectStore.TierTopicSnapshotMetadata obj2 = new TierObjectStore.TierTopicSnapshotMetadata(snapshotObject2);
        this.objectStore().putBuffer((TierObjectStore.ObjectStoreMetadata)obj2, b, TierObjectStore.FileType.TIER_TOPIC_SNAPSHOT);
        this.lifecycleManager((TierObjectStore)this.objectStore()).manageLifecycleForTierTopicSnapshots();
        Assertions.assertFalse((boolean)this.objectStore().objectExists((TierObjectStore.ObjectStoreMetadata)obj1, (TierObjectStore.FileType)TierObjectStore.FileType.TIER_TOPIC_SNAPSHOT).exist);
        Assertions.assertTrue((boolean)this.objectStore().objectExists((TierObjectStore.ObjectStoreMetadata)obj2, (TierObjectStore.FileType)TierObjectStore.FileType.TIER_TOPIC_SNAPSHOT).exist);
    }

    @Test
    public void testCLMMustNotDeleteLiveObjects() {
        long currTimeMs = this.time().milliseconds();
        String currDateStr = StateManager.convertToDateKey((Long)Predef$.MODULE$.long2Long(currTimeMs));
        UUID obj1Id = UUID.randomUUID();
        UUID obj2Id = UUID.randomUUID();
        int obj1BaseOffset = 0;
        int obj2BaseOffset = 100;
        String obj1Prefix = "00000001";
        String obj2Prefix = "00000100";
        File obj1Log = File.createTempFile(obj1Prefix, ".log");
        File obj2Log = File.createTempFile(obj2Prefix, ".log");
        File obj1Index = File.createTempFile(obj1Prefix, ".index");
        File obj2Index = File.createTempFile(obj2Prefix, ".index");
        File obj1TimeIndex = File.createTempFile(obj1Prefix, ".timeindex");
        File obj2TimeIndex = File.createTempFile(obj2Prefix, ".timeindex");
        TierObjectStore.ObjectMetadata obj1Metadata = new TierObjectStore.ObjectMetadata(this.topicIdPartition(), obj1Id, 0, (long)obj1BaseOffset, false, false, false, TierObjectStore.OpaqueData.ZEROED);
        TierObjectStore.ObjectMetadata obj2Metadata = new TierObjectStore.ObjectMetadata(this.topicIdPartition(), obj2Id, 0, (long)obj2BaseOffset, false, false, false, TierObjectStore.OpaqueData.ZEROED);
        this.objectStore().putSegment(obj1Metadata, obj1Log, obj1Index, obj1TimeIndex, Optional.empty(), Optional.empty(), Optional.empty());
        this.objectStore().putSegment(obj2Metadata, obj2Log, obj2Index, obj2TimeIndex, Optional.empty(), Optional.empty(), Optional.empty());
        this.objectStore().deleteSegment(obj2Metadata);
        HashMap dateToDeletionLists = new HashMap();
        ArrayList<LifecycleManager.BlobMetadata> blobs = new ArrayList<LifecycleManager.BlobMetadata>();
        HashMap<TopicIdPartition, ArrayList<LifecycleManager.BlobMetadata>> tpIdToBlobs = new HashMap<TopicIdPartition, ArrayList<LifecycleManager.BlobMetadata>>();
        blobs.add(new LifecycleManager.BlobMetadata(obj1Id.toString(), Predef$.MODULE$.long2Long(currTimeMs), Predef$.MODULE$.int2Integer(0)));
        blobs.add(new LifecycleManager.BlobMetadata(obj2Id.toString(), Predef$.MODULE$.long2Long(currTimeMs), Predef$.MODULE$.int2Integer(0)));
        tpIdToBlobs.put(this.topicIdPartition(), blobs);
        dateToDeletionLists.put(currDateStr, tpIdToBlobs);
        this.time().setCurrentTimeMs(currTimeMs + 10L);
        java.util.List objectsFinalizedForDeletion = this.lifecycleManager((TierObjectStore)this.objectStore()).retrieveObjectsEligibleForDeletion(Predef$.MODULE$.long2Long(this.time().milliseconds()), dateToDeletionLists);
        Predef$.MODULE$.assert(objectsFinalizedForDeletion.size() == 3);
        objectsFinalizedForDeletion.forEach(o -> Predef$.MODULE$.assert(this.extractPrefixAndCompare(o.key(), obj2Id, this.topicIdPartition())));
        Predef$.MODULE$.assert(dateToDeletionLists.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLifecycleManagerStateDiscardCases() {
        void var10_9;
        void var9_4;
        LifecycleManager clm = this.lifecycleManager((TierObjectStore)this.objectStore());
        FlatBufferBuilder builder = new FlatBufferBuilder(512);
        int headerOffset = Header.createHeader((FlatBufferBuilder)builder, (int)1002);
        builder.startTable(5);
        builder.addOffset(0, headerOffset, 0);
        int endLifecycleManagerState_o = builder.endTable();
        builder.finishSizePrefixed((int)var9_4);
        TierObjectStore.LifecycleManagerStateMetadata metadata = new TierObjectStore.LifecycleManagerStateMetadata(this.clusterId());
        this.objectStore().putBuffer((TierObjectStore.ObjectStoreMetadata)metadata, builder.dataBuffer().slice(), TierObjectStore.FileType.LIFECYCLE_MANAGER_STATE);
        Assertions.assertFalse((boolean)clm.lifecycleManagerState(Predef$.MODULE$.long2Long(this.time().milliseconds())).isPresent());
        long lastRunTs = this.time().milliseconds() - TimeUnit.MILLISECONDS.convert(8L, TimeUnit.DAYS);
        FlatBufferBuilder builder2 = new FlatBufferBuilder(512);
        int headerOffset2 = Header.createHeader((FlatBufferBuilder)builder2, (int)1);
        builder2.startTable(5);
        builder2.addOffset(0, headerOffset2, 0);
        builder2.addLong(1, lastRunTs, 0L);
        int endLifecycleManagerState_o2 = builder2.endTable();
        builder2.finishSizePrefixed((int)var10_9);
        this.objectStore().putBuffer((TierObjectStore.ObjectStoreMetadata)metadata, builder2.dataBuffer().slice(), TierObjectStore.FileType.LIFECYCLE_MANAGER_STATE);
        Assertions.assertFalse((boolean)clm.lifecycleManagerState(Predef$.MODULE$.long2Long(this.time().milliseconds())).isPresent());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCLMReturnsUpdatedStateAfterCheckpoint() {
        long currTimeMs = System.currentTimeMillis();
        String currDateStr = StateManager.convertToDateKey((Long)Predef$.MODULE$.long2Long(currTimeMs));
        long[] endOffsets = (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 100L, (ClassTag)ClassTag$.MODULE$.Long());
        HashMap<NameAndId, Integer> topicToBackupRetentionInDays = new HashMap<NameAndId, Integer>();
        topicToBackupRetentionInDays.put(new NameAndId("foo"), Predef$.MODULE$.int2Integer(3));
        HashMap retentionChanges = new HashMap();
        HashMap<String, String> dateToLatestDeletionList = new HashMap<String, String>();
        dateToLatestDeletionList.put(currDateStr, "00000003");
        LifecycleManagerState state = StateManager.deserializeState((ByteBuffer)StateManager.serializeState((Long)Predef$.MODULE$.long2Long(currTimeMs), (long[])endOffsets, topicToBackupRetentionInDays, retentionChanges, dateToLatestDeletionList).duplicate());
        HashMap<String, java.util.List<String>> deletionListsCurrentOrPastDays = new HashMap<String, java.util.List<String>>();
        deletionListsCurrentOrPastDays.put(currDateStr, Arrays.asList("00000001", "00000002", "00000003"));
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        HashMap<TopicIdPartition, java.util.List<LifecycleManager.BlobMetadata>> tpIdToBlobs = new HashMap<TopicIdPartition, java.util.List<LifecycleManager.BlobMetadata>>();
        LifecycleManager.BlobMetadata blob = new LifecycleManager.BlobMetadata(UUID.randomUUID().toString(), Predef$.MODULE$.long2Long(currTimeMs + 100L), Predef$.MODULE$.int2Integer(3));
        tpIdToBlobs.put(topicIdPartition, Arrays.asList(blob));
        HashMap<String, HashMap<TopicIdPartition, java.util.List<LifecycleManager.BlobMetadata>>> dateToDeletableBlobs = new HashMap<String, HashMap<TopicIdPartition, java.util.List<LifecycleManager.BlobMetadata>>>();
        dateToDeletableBlobs.put(currDateStr, tpIdToBlobs);
        boolean currentDayBlobsAlreadyLoaded = true;
        this.uploadBackupObjectsListWithDummyData(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.backupObjectListsPresent(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Backup object files not present");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LifecycleManager clm = this.lifecycleManager((TierObjectStore)this.objectStore());
        LifecycleManagerState newState = clm.cleanupAndCheckpoint(Predef$.MODULE$.long2Long(currTimeMs), state, topicToBackupRetentionInDays, retentionChanges, deletionListsCurrentOrPastDays, dateToDeletableBlobs, Predef$.MODULE$.boolean2Boolean(currentDayBlobsAlreadyLoaded));
        Predef$.MODULE$.assert(newState.lastRunTimestamp() == currTimeMs);
        Predef$.MODULE$.assert(newState.latestDataFilesLength() == 1);
        String string = newState.latestDataFiles(0).date();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(currDateStr) : currDateStr != null));
        String string2 = newState.latestDataFiles(0).latestFile();
        String string3 = "00000001";
        Predef$.MODULE$.assert(string2 != null && string2.equals(string3));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 60L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerUnitTests.$anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$4(this, currDateStr)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Backup object files must have been deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 60L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!this.backupObjectListsPresent(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)Nil$.MODULE$))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Backup object files must have been present");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.uploadBackupObjectsListWithDummyData(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))));
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 60L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!this.backupObjectListsPresent(currDateStr, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Backup object files not present");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        dateToDeletableBlobs.remove(currDateStr);
        newState = clm.cleanupAndCheckpoint(Predef$.MODULE$.long2Long(currTimeMs), state, topicToBackupRetentionInDays, retentionChanges, deletionListsCurrentOrPastDays, dateToDeletableBlobs, Predef$.MODULE$.boolean2Boolean(currentDayBlobsAlreadyLoaded));
        Predef$.MODULE$.assert(newState.lastRunTimestamp() == currTimeMs);
        Predef$.MODULE$.assert(newState.latestDataFilesLength() == 0);
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 60L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerUnitTests.$anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$10(this, currDateStr)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"Backup object files must have been deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testRetentionToBackupConfig() {
        TreeMap retentionToBackup = LifecycleManagerConfig.parseRetentionToBackupConfig((String)"\"0:0,3:3\"");
        Predef$.MODULE$.assert(retentionToBackup.size() == 3);
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToInteger((int)0)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)-1L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        retentionToBackup = LifecycleManagerConfig.parseRetentionToBackupConfig((String)"3:3");
        Predef$.MODULE$.assert(retentionToBackup.size() == 3);
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToInteger((int)0)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)-1L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        retentionToBackup = LifecycleManagerConfig.parseRetentionToBackupConfig((String)"3:3,-1:7");
        Predef$.MODULE$.assert(retentionToBackup.size() == 3);
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToInteger((int)0)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)-1L)), (Object)BoxesRunTime.boxToInteger((int)7)));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)""));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0033"));
        Assertions.assertThrows(NumberFormatException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"abc:abc"));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0:0,3:3,3:3"));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0:0,3:3,4:2"));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0:0,3:3,-1:2"));
    }

    @Test
    public void testReconfigureBackupPolicy() {
        NameAndId topic_1h = new NameAndId("topic_1h");
        NameAndId topic_1d = new NameAndId("topic_1d");
        NameAndId topic_2d = new NameAndId("topic_2d");
        NameAndId topic_3d = new NameAndId("topic_3d");
        NameAndId topic_4d = new NameAndId("topic_4d");
        NameAndId topic_5d = new NameAndId("topic_5d");
        NameAndId topic_6d = new NameAndId("topic_6d");
        NameAndId topic_7d = new NameAndId("topic_7d");
        NameAndId topic_8d = new NameAndId("topic_8d");
        NameAndId topic_365d = new NameAndId("topic_365d");
        NameAndId topic_infinite = new NameAndId("topic_infinite");
        HashMap<NameAndId, Long> latestRetentionConfigs = new HashMap<NameAndId, Long>(null, topic_1h, topic_1d, topic_2d, topic_3d, topic_4d, topic_5d, topic_6d, topic_7d, topic_8d, topic_365d, topic_infinite){
            {
                this.put(topic_1h$1, Predef$.MODULE$.long2Long(3600000L));
                this.put(topic_1d$1, Predef$.MODULE$.long2Long(86400000L));
                this.put(topic_2d$1, Predef$.MODULE$.long2Long(172800000L));
                this.put(topic_3d$1, Predef$.MODULE$.long2Long(259200000L));
                this.put(topic_4d$1, Predef$.MODULE$.long2Long(345600000L));
                this.put(topic_5d$1, Predef$.MODULE$.long2Long(432000000L));
                this.put(topic_6d$1, Predef$.MODULE$.long2Long(518400000L));
                this.put(topic_7d$1, Predef$.MODULE$.long2Long(604800000L));
                this.put(topic_8d$1, Predef$.MODULE$.long2Long(691200000L));
                this.put(topic_365d$1, Predef$.MODULE$.long2Long(1471228928L));
                this.put(topic_infinite$1, Predef$.MODULE$.long2Long(-1L));
            }
        };
        this.props().put(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp(), "7");
        this.props().put(KafkaConfig$.MODULE$.CLMTopicRetentionInDaysToBackupInDaysProp(), "0:0,3:3,4:4,5:5,6:6,7:7");
        this.config_$eq(new KafkaConfig((Map)this.props()));
        Map backupRetentionDays = this.lifecycleManager((TierObjectStore)this.objectStore()).getBackupRetentionInDaysForAllTopics((Map)latestRetentionConfigs);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1h), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_2d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_3d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_4d), (Object)BoxesRunTime.boxToInteger((int)4)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_5d), (Object)BoxesRunTime.boxToInteger((int)5)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_6d), (Object)BoxesRunTime.boxToInteger((int)6)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_7d), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_8d), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_infinite), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_365d), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        this.props().put(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp(), "3");
        this.props().put(KafkaConfig$.MODULE$.CLMTopicRetentionInDaysToBackupInDaysProp(), "0:0,3:3");
        this.config_$eq(new KafkaConfig((Map)this.props()));
        backupRetentionDays = this.lifecycleManager((TierObjectStore)this.objectStore()).getBackupRetentionInDaysForAllTopics((Map)latestRetentionConfigs);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1h), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_2d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_3d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_4d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_5d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_6d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_7d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_8d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_infinite), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_365d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
    }

    private LifecycleManager lifecycleManager(TierObjectStore objectStore) {
        HashMap interBrokerClientConfigs = new HashMap();
        LifecycleManagerConfig lifecycleManagerConfig = new LifecycleManagerConfig(this.config(), this.clusterId(), () -> interBrokerClientConfigs, () -> this.admin());
        return new LifecycleManager(objectStore, lifecycleManagerConfig, () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(true), (Time)this.time(), this.metrics());
    }

    private boolean extractPrefixAndCompare(String key, UUID objectId, TopicIdPartition topicIdPartition) {
        String prefix = new StringBuilder(3).append(TierObjectStore.DataTypePathPrefix.TOPIC.prefix).append("/").append(CoreUtils$.MODULE$.uuidToBase64(objectId)).append("/").append(topicIdPartition.topicIdAsBase64()).append("/").append(topicIdPartition.partition()).toString();
        int endIndex = key.lastIndexOf("/");
        Predef$.MODULE$.assert(endIndex != -1);
        String string = key.substring(0, endIndex);
        return !(string != null ? !string.equals(prefix) : prefix != null);
    }

    private boolean backupObjectListsPresent(String date, List<String> names) {
        return names.forall((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)BackupObjectLifecycleManagerUnitTests.$anonfun$backupObjectListsPresent$1(this, date, name)));
    }

    private void uploadBackupObjectsListWithDummyData(String date, List<String> names) {
        StateManagerConfig config = new StateManagerConfig((TierObjectStore)this.objectStore(), this.clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false));
        long currTimeMs = System.currentTimeMillis();
        TopicIdPartition topicIdPartition = new TopicIdPartition("bar", UUID.randomUUID(), 0);
        HashMap<TopicIdPartition, java.util.List<LifecycleManager.BlobMetadata>> tpIdToBlobs = new HashMap<TopicIdPartition, java.util.List<LifecycleManager.BlobMetadata>>();
        LifecycleManager.BlobMetadata blob = new LifecycleManager.BlobMetadata(UUID.randomUUID().toString(), Predef$.MODULE$.long2Long(currTimeMs + 100L), Predef$.MODULE$.int2Integer(3));
        tpIdToBlobs.put(topicIdPartition, Arrays.asList(blob));
        ByteBuffer buf = StateManager.serializeBackupObjectsList(tpIdToBlobs);
        names.foreach((Function1 & Serializable)name -> {
            BackupObjectLifecycleManagerUnitTests.$anonfun$uploadBackupObjectsListWithDummyData$3(config, buf, date, name);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$3() {
        return "Backup object files not present";
    }

    public static final /* synthetic */ boolean $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$4(BackupObjectLifecycleManagerUnitTests $this, String currDateStr$1) {
        return !$this.backupObjectListsPresent(currDateStr$1, (List<String>)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$5() {
        return "Backup object files must have been deleted";
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$7() {
        return "Backup object files must have been present";
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$9() {
        return "Backup object files not present";
    }

    public static final /* synthetic */ boolean $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$10(BackupObjectLifecycleManagerUnitTests $this, String currDateStr$1) {
        return !$this.backupObjectListsPresent(currDateStr$1, (List<String>)new .colon.colon((Object)"00000001", (List)new .colon.colon((Object)"00000002", (List)new .colon.colon((Object)"00000003", (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ String $anonfun$testCLMReturnsUpdatedStateAfterCheckpoint$11() {
        return "Backup object files must have been deleted";
    }

    public static final /* synthetic */ boolean $anonfun$backupObjectListsPresent$1(BackupObjectLifecycleManagerUnitTests $this, String date$1, String name) {
        String path = new TierObjectStore.BackupObjectsListMetadata($this.clusterId(), date$1, name).toPath("", TierObjectStore.FileType.BACKUP_OBJECTS_LIST);
        Map objects = $this.objectStore().listObject(path, false);
        return objects.size() == 1 && objects.containsKey(path);
    }

    public static final /* synthetic */ void $anonfun$uploadBackupObjectsListWithDummyData$3(StateManagerConfig config$1, ByteBuffer buf$1, String date$2, String name) {
        StateManager.putBackedUpObjectsListBufToObjectStore((StateManagerConfig)config$1, (ByteBuffer)buf$1, (String)date$2, (String)name);
    }

    public BackupObjectLifecycleManagerUnitTests() {
        this.props().setProperty("confluent.tier.feature", "true");
        this.props().setProperty("node.id", "1");
        this.props().setProperty("confluent.clm.enabled", "true");
        this.props().setProperty("confluent.tier.topic.snapshots.retention.hours", "168");
        this.config = new KafkaConfig((Map)this.props());
        this.clusterId = "testCluster";
        this.admin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        this.objectStore = new MockInMemoryTierObjectStore((Time)this.time(), new MockInMemoryTierObjectStoreConfig());
        this.topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
    }
}

