/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierIntegrationTest$;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasks;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\r\rg\u0001B$I\u00015CQ\u0001\u0016\u0001\u0005\u0002UCq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004a\u0001\u0001\u0006IA\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u0019\t\b\u0001)A\u0005G\"9!\u000f\u0001b\u0001\n\u0003\u0019\bB\u0002>\u0001A\u0003%A\u000fC\u0005|\u0001\u0001\u0007\t\u0019!C\u0001y\"Y\u0011\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0002\u0011)\ty\u0001\u0001a\u0001\u0002\u0003\u0006K! \u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019\u0002C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\u0002\u0005\r\u0002bCA\u0014\u0001\u0001\u0007\t\u0011)Q\u0005\u0003+A1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002,!Y\u0011\u0011\b\u0001A\u0002\u0003\u0007I\u0011AA\u001e\u0011-\ty\u0004\u0001a\u0001\u0002\u0003\u0006K!!\f\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013\u0005\u00111\t\u0005\f\u0003#\u0002\u0001\u0019!a\u0001\n\u0003\t\u0019\u0006C\u0006\u0002X\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0003bCA-\u0001\u0001\u0007\t\u0019!C\u0001\u00037B1\"!\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002l!Y\u0011q\u000e\u0001A\u0002\u0003\u0005\u000b\u0015BA/\u0011-\t\t\b\u0001a\u0001\u0002\u0004%\t!a\u001d\t\u0017\u0005\u0005\u0005\u00011AA\u0002\u0013\u0005\u00111\u0011\u0005\f\u0003\u000f\u0003\u0001\u0019!A!B\u0013\t)\bC\u0005\u0002\n\u0002\u0001\r\u0011\"\u0001\u0002\f\"I\u00111\u0013\u0001A\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u00033\u0003\u0001\u0015)\u0003\u0002\u000e\"I\u00111\u0014\u0001A\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003W\u0003\u0001\u0019!C\u0001\u0003[C\u0001\"!-\u0001A\u0003&\u0011q\u0014\u0005\f\u0003g\u0003\u0001\u0019!a\u0001\n\u0003\t)\fC\u0006\u0002V\u0002\u0001\r\u00111A\u0005\u0002\u0005]\u0007bCAn\u0001\u0001\u0007\t\u0011)Q\u0005\u0003oC1\"!8\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002`\"Y\u0011q\u001d\u0001A\u0002\u0003\u0007I\u0011AAu\u0011-\ti\u000f\u0001a\u0001\u0002\u0003\u0006K!!9\t\u0017\u0005=\b\u00011AA\u0002\u0013\u0005\u0011\u0011\u001f\u0005\f\u0005\u0017\u0001\u0001\u0019!a\u0001\n\u0003\u0011i\u0001C\u0006\u0003\u0012\u0001\u0001\r\u0011!Q!\n\u0005M\b\"\u0003B\n\u0001\t\u0007I\u0011\u0001B\u000b\u0011!\u0011i\u0002\u0001Q\u0001\n\t]\u0001\"\u0003B\u0010\u0001\t\u0007I\u0011\u0001B\u0011\u0011!\u0011I\u0003\u0001Q\u0001\n\t\r\u0002\"\u0003B\u0016\u0001\t\u0007I\u0011\u0001B\u0017\u0011!\u0011y\u0004\u0001Q\u0001\n\t=\u0002b\u0002B!\u0001\u0011\u0005!1\t\u0005\b\u0005\u0017\u0002A\u0011\u0001B\"\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001fBqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0005\u0003p\u0001\t\n\u0011\"\u0001\u0003r!I!q\u0011\u0001\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\b\u0005\u0013\u0003A\u0011\u0001BF\u0011\u001d\u00119\u000b\u0001C\u0001\u0005\u0017CqA!-\u0001\t\u0003\u0011Y\tC\u0004\u0003<\u0002!\tAa#\t\u000f\t}\u0006\u0001\"\u0001\u0003\f\"9!1\u0019\u0001\u0005\u0002\t-\u0005b\u0002Bd\u0001\u0011\u0005!1\u0012\u0005\b\u0005\u0017\u0004A\u0011\u0002Bg\u0011%\u0011i\u000eAI\u0001\n\u0013\u0011y\u000eC\u0004\u0003d\u0002!IA!:\t\u000f\r\u0015\u0001\u0001\"\u0003\u0004\b!91\u0011\u0004\u0001\u0005\n\t-\u0005bBB\u000e\u0001\u0011%1Q\u0004\u0005\b\u0007'\u0002A\u0011BB+\u0011\u001d\u0019I\u0006\u0001C\u0005\u00077Bqaa\u001d\u0001\t\u0013\u0019)\bC\u0004\u0004\u001c\u0002!Ia!(\t\u000f\r\u001d\u0006\u0001\"\u0003\u0004*\n\u0019B+[3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011\u0011JS\u0001\u0005i&,'OC\u0001L\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u000b\u0005\u0002X\u00015\t\u0001*\u0001\u0005n_\u000e\\G+[7f+\u0005Q\u0006CA._\u001b\u0005a&BA/K\u0003\u0015)H/\u001b7t\u0013\tyFL\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%A\u0004m_\u001e$\u0015N]:\u0016\u0003\r\u00042\u0001Z5l\u001b\u0005)'B\u00014h\u0003\u0011)H/\u001b7\u000b\u0003!\fAA[1wC&\u0011!.\u001a\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u0004\"\u0001\\8\u000e\u00035T!A\\4\u0002\t1\fgnZ\u0005\u0003a6\u0014aa\u0015;sS:<\u0017\u0001\u00037pO\u0012K'o\u001d\u0011\u0002-QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e,\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003o\"\u000bQ\u0001^8qS\u000eL!!\u001f<\u0003-QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e\fq\u0003^5feR{\u0007/[2NC:\fw-\u001a:D_:4\u0017n\u001a\u0011\u0002#QLWM\u001d+pa&\u001c7i\u001c8tk6,'/F\u0001~!\t)h0\u0003\u0002\u0000m\n\tB+[3s)>\u0004\u0018nY\"p]N,X.\u001a:\u0002+QLWM\u001d+pa&\u001c7i\u001c8tk6,'o\u0018\u0013fcR!\u0011QAA\u0006!\ry\u0015qA\u0005\u0004\u0003\u0013\u0001&\u0001B+oSRD\u0001\"!\u0004\n\u0003\u0003\u0005\r!`\u0001\u0004q\u0012\n\u0014A\u0005;jKJ$v\u000e]5d\u0007>t7/^7fe\u0002\n\u0011\u0003^5fe2{wmQ8na>tWM\u001c;t+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYBS\u0001\u0004Y><\u0017\u0002BA\u0010\u00033\u0011\u0011\u0003V5fe2{wmQ8na>tWM\u001c;t\u0003U!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]0%KF$B!!\u0002\u0002&!I\u0011Q\u0002\u0007\u0002\u0002\u0003\u0007\u0011QC\u0001\u0013i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\b%A\u0004uK6\u0004H)\u001b:\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005Mr-\u0001\u0002j_&!\u0011qGA\u0019\u0005\u00111\u0015\u000e\\3\u0002\u0017Q,W\u000e\u001d#je~#S-\u001d\u000b\u0005\u0003\u000b\ti\u0004C\u0005\u0002\u000e=\t\t\u00111\u0001\u0002.\u0005AA/Z7q\t&\u0014\b%A\u0005uS\u0016\u0014H+Y:lgV\u0011\u0011Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111\n%\u0002\u000bQ\f7o[:\n\t\u0005=\u0013\u0011\n\u0002\n)&,'\u000fV1tWN\fQ\u0002^5feR\u000b7o[:`I\u0015\fH\u0003BA\u0003\u0003+B\u0011\"!\u0004\u0013\u0003\u0003\u0005\r!!\u0012\u0002\u0015QLWM\u001d+bg.\u001c\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\r$*\u0001\u0004tKJ4XM]\u0005\u0005\u0003O\n\tG\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u000b\ti\u0007C\u0005\u0002\u000eU\t\t\u00111\u0001\u0002^\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f+\t\t)\b\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tY\bS\u0001\u0006gR|'/Z\u0005\u0005\u0003\u007f\nIHA\u000eN_\u000e\\\u0017J\\'f[>\u0014\u0018\u0010V5fe>\u0013'.Z2u'R|'/Z\u0001\u0014i&,'o\u00142kK\u000e$8\u000b^8sK~#S-\u001d\u000b\u0005\u0003\u000b\t)\tC\u0005\u0002\u000ea\t\t\u00111\u0001\u0002v\u0005\u0001B/[3s\u001f\nTWm\u0019;Ti>\u0014X\rI\u0001!i&,'\u000fR3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'/\u0006\u0002\u0002\u000eB\u0019q+a$\n\u0007\u0005E\u0005J\u0001\u0011US\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014\u0018\u0001\n;jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J|F%Z9\u0015\t\u0005\u0015\u0011q\u0013\u0005\n\u0003\u001bY\u0012\u0011!a\u0001\u0003\u001b\u000b\u0011\u0005^5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;pe\u0002\n\u0001\u0003^5feN#\u0018\r^3GKR\u001c\u0007.\u001a:\u0016\u0005\u0005}\u0005\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015\u0006*A\u0004gKR\u001c\u0007.\u001a:\n\t\u0005%\u00161\u0015\u0002\u0011)&,'o\u0015;bi\u00164U\r^2iKJ\fA\u0003^5feN#\u0018\r^3GKR\u001c\u0007.\u001a:`I\u0015\fH\u0003BA\u0003\u0003_C\u0011\"!\u0004\u001f\u0003\u0003\u0005\r!a(\u0002#QLWM]*uCR,g)\u001a;dQ\u0016\u0014\b%\u0001\u0003m_\u001e\u001cXCAA\\!\u0019\tI,!3\u0002P:!\u00111XAc\u001d\u0011\ti,a1\u000e\u0005\u0005}&bAAa\u0019\u00061AH]8pizJ\u0011!U\u0005\u0004\u0003\u000f\u0004\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\fiMA\u0002TKFT1!a2Q!\u0011\t9\"!5\n\t\u0005M\u0017\u0011\u0004\u0002\n\u001b\u0016\u0014x-\u001a3M_\u001e\f\u0001\u0002\\8hg~#S-\u001d\u000b\u0005\u0003\u000b\tI\u000eC\u0005\u0002\u000e\u0005\n\t\u00111\u0001\u00028\u0006)An\\4tA\u0005\u0001B/[3s)>\u0004\u0018nY'b]\u0006<WM]\u000b\u0003\u0003C\u00042!^Ar\u0013\r\t)O\u001e\u0002\u0011)&,'\u000fV8qS\u000el\u0015M\\1hKJ\fA\u0003^5feR{\u0007/[2NC:\fw-\u001a:`I\u0015\fH\u0003BA\u0003\u0003WD\u0011\"!\u0004%\u0003\u0003\u0005\r!!9\u0002#QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\b%\u0001\td_:\u001cX/\\3s'V\u0004\b\u000f\\5feV\u0011\u00111\u001f\t\t\u0003k\fY0a@\u0002\u00006\u0011\u0011q\u001f\u0006\u0004\u0003sD\u0015AB2mS\u0016tG/\u0003\u0003\u0002~\u0006](\u0001F'pG.\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'\u000fE\u0003P\u0005\u0003\u0011)!C\u0002\u0003\u0004A\u0013Q!\u0011:sCf\u00042a\u0014B\u0004\u0013\r\u0011I\u0001\u0015\u0002\u0005\u0005f$X-\u0001\u000bd_:\u001cX/\\3s'V\u0004\b\u000f\\5fe~#S-\u001d\u000b\u0005\u0003\u000b\u0011y\u0001C\u0005\u0002\u000e\u001d\n\t\u00111\u0001\u0002t\u0006\t2m\u001c8tk6,'oU;qa2LWM\u001d\u0011\u0002\u001b5\f\u0007pV1jiRKW.Z't+\t\u00119\u0002E\u0002P\u00053I1Aa\u0007Q\u0005\rIe\u000e^\u0001\u000f[\u0006Dx+Y5u)&lW-T:!\u0003I!\u0018.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\t\r\u0002cA,\u0003&%\u0019!q\u0005%\u0003%QKWM\u001d*fa2L7-Y'b]\u0006<WM]\u0001\u0014i&,'OU3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\f[\n+\u0017M\\*feZ,'/\u0006\u0002\u00030A!!\u0011\u0007B\u001e\u001b\t\u0011\u0019D\u0003\u0003\u00036\t]\u0012AC7b]\u0006<W-\\3oi*\u0011!\u0011H\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0005{\u0011\u0019DA\u0006N\u0005\u0016\fgnU3sm\u0016\u0014\u0018\u0001D7CK\u0006t7+\u001a:wKJ\u0004\u0013aD2iK\u000e\\7/^7F]\u0006\u0014G.\u001a3\u0016\u0005\t\u0015\u0003cA(\u0003H%\u0019!\u0011\n)\u0003\u000f\t{w\u000e\\3b]\u0006q1\r\\3b]V\u0004XI\\1cY\u0016$\u0017!D2mK\u0006tW\u000f]\"p]\u001aLw-\u0006\u0002\u0003RA!!1\u000bB-\u001b\t\u0011)FC\u0002\u0003X!\u000bQa\u001d;bi\u0016LAAa\u0017\u0003V\tyB+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u00072,\u0017M\\;q\u0007>tg-[4\u0002\u000bM,G/\u001e9\u0015\r\u0005\u0015!\u0011\rB6\u0011%\u0011\u0019G\rI\u0001\u0002\u0004\u0011)'A\u0004ok6dunZ:\u0011\u00071\u00149'C\u0002\u0003j5\u0014q!\u00138uK\u001e,'\u000fC\u0005\u0003nI\u0002\n\u00111\u0001\u0003f\u0005\u0011b.^7Be\u000eD\u0017N^3s)\"\u0014X-\u00193t\u0003=\u0019X\r^;qI\u0011,g-Y;mi\u0012\nTC\u0001B:U\u0011\u0011)G!\u001e,\u0005\t]\u0004\u0003\u0002B=\u0005\u0007k!Aa\u001f\u000b\t\tu$qP\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!!Q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000b\u0013YHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqb]3ukB$C-\u001a4bk2$HEM\u0001\u0007E\u00164wN]3\u0015\u0005\u0005\u0015\u0001fA\u001b\u0003\u0010B!!\u0011\u0013BR\u001b\t\u0011\u0019J\u0003\u0003\u0003\u0016\n]\u0015aA1qS*!!\u0011\u0014BN\u0003\u001dQW\u000f]5uKJTAA!(\u0003 \u0006)!.\u001e8ji*\u0011!\u0011U\u0001\u0004_J<\u0017\u0002\u0002BS\u0005'\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007f\u0001\u001c\u0003,B!!\u0011\u0013BW\u0013\u0011\u0011yKa%\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u0006;fgR\f%o\u00195jm\u0016\u0014\u0018*\\7jOJ\fG/\u001a\u0015\u0004o\tU\u0006\u0003\u0002BI\u0005oKAA!/\u0003\u0014\n!A+Z:u\u0003\u0001\"Xm\u001d;Be\u000eD\u0017N^3s+Bdw.\u00193B]\u0012l\u0015\r^3sS\u0006d\u0017N_3)\u0007a\u0012),A!uKN$\u0018I]2iSZ,'/\u00169m_\u0006$\u0017I\u001c3NCR,'/[1mSj,w\u000b[3o/JLG/\u001a%baB,gn]!gi\u0016\u0014()Z2p[\u0016dU-\u00193fe\"\u001a\u0011H!.\u0002]Q,7\u000f^!sG\"Lg/\u001a:Va2|\u0017\rZ,ji\"d\u0015.\\5uK\u0012,\u0006\u000f\\8bI\u000e{gnY;se\u0016t7-\u001f\u0015\u0004u\tU\u0016A\u0006;fgR\f%o\u00195jm\u0016\u0014H*Y4NKR\u0014\u0018nY:)\u0007m\u0012),\u0001\nxC&$hi\u001c:J[6LwM]1uS>tG\u0003DA\u0003\u0005\u001f\u0014\tN!6\u0003X\ne\u0007bBAZy\u0001\u0007\u0011q\u0017\u0005\b\u0005'd\u0004\u0019\u0001B\f\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u000f\u0005\u0005C\b1\u0001\u0002F!9\u0011q\u001e\u001fA\u0002\u0005M\b\"\u0003BnyA\u0005\t\u0019\u0001B#\u00031\u0011WmY8nK2+\u0017\rZ3s\u0003q9\u0018-\u001b;G_JLU.\\5he\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uIU*\"A!9+\t\t\u0015#QO\u0001\u001fCJ\u001c\u0007.\u001b<f\u0003:$W*\u0019;fe&\fG.\u001b>f+:$\u0018\u000e\u001c+sk\u0016$\u0002\"!\u0002\u0003h\nE81\u0001\u0005\b\u0005St\u0004\u0019\u0001Bv\u0003\u0011\u0001(/\u001a3\u0011\u000b=\u0013iO!\u0012\n\u0007\t=\bKA\u0005Gk:\u001cG/[8oa!9!1\u001f A\u0002\tU\u0018aA7tOB!!q\u001fB\u0000\u001d\u0011\u0011IPa?\u0011\u0007\u0005u\u0006+C\u0002\u0003~B\u000ba\u0001\u0015:fI\u00164\u0017b\u00019\u0004\u0002)\u0019!Q )\t\u000f\u0005=h\b1\u0001\u0002t\u0006ac/\u00197jI\u0006$X\rU1si&$\u0018n\u001c8Ti\u0006$XmQ8oi\u0006Lg.\u001a3J]>\u0013'.Z2u'R|'/\u001a\u000b\u0007\u0003\u000b\u0019Iaa\u0003\t\u000f\u0005Et\b1\u0001\u0002v!9\u00111W A\u0002\r5\u0001CBA]\u0007\u001f\u0019\u0019\"\u0003\u0003\u0004\u0012\u00055'\u0001C%uKJ\f'\r\\3\u0011\t\u0005]1QC\u0005\u0005\u0007/\tIBA\u0006BEN$(/Y2u\u0019><\u0017aE:fiV\u0004H+[3s\u0007>l\u0007o\u001c8f]R\u001c\u0018AC2sK\u0006$X\rT8hgRa1qDB\u0013\u0007S\u0019)ea\u0012\u0004JA1\u0011\u0011XB\u0011\u0003\u001fLAaa\t\u0002N\nQ\u0011J\u001c3fq\u0016$7+Z9\t\u000f\r\u001d\u0012\t1\u0001\u0003\u0018\u0005\ta\u000eC\u0004\u0004,\u0005\u0003\ra!\f\u0002\u00131|wmQ8oM&<\u0007\u0003BB\u0018\u0007\u0003j!a!\r\u000b\t\u0005m11\u0007\u0006\u0005\u0007k\u00199$A\u0005j]R,'O\\1mg*!1\u0011HB\u001e\u0003\u001d\u0019Ho\u001c:bO\u0016T1aSB\u001f\u0015\u0011\u0019yDa(\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0019\u0019e!\r\u0003\u00131{wmQ8oM&<\u0007bBA\u0015\u0003\u0002\u0007\u0011Q\u0006\u0005\b\u0003#\t\u0005\u0019AA\u000b\u0011\u001d\u0019Y%\u0011a\u0001\u0007\u001b\nA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0003BB\u0018\u0007\u001fJAa!\u0015\u00042\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\f!#\\8dWJ+\u0007\u000f\\5dC6\u000bg.Y4feR!\u0011QLB,\u0011\u001d\t\u0019L\u0011a\u0001\u0007\u001b\t!c\u001e:ji\u0016\u0014VmY8sI\n\u000bGo\u00195fgRa\u0011QAB/\u0007?\u001a\tga\u001b\u0004p!9\u00111D\"A\u0002\rM\u0001b\u0002Bj\u0007\u0002\u0007!q\u0003\u0005\b\u0007G\u001a\u0005\u0019AB3\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\t\u0004\u001f\u000e\u001d\u0014bAB5!\n!Aj\u001c8h\u0011\u001d\u0019ig\u0011a\u0001\u0005/\tqAY1uG\",7\u000fC\u0004\u0004r\r\u0003\rAa\u0006\u0002\u001fI,7m\u001c:egB+'OQ1uG\"\fQb\u0019:fCR,'+Z2pe\u0012\u001cHCCB<\u0007\u000f\u001b\u0019j!&\u0004\u0018B!1\u0011PBB\u001b\t\u0019YH\u0003\u0003\u0004~\r}\u0014A\u0002:fG>\u0014HM\u0003\u0003\u0004\u0002\u000em\u0012AB2p[6|g.\u0003\u0003\u0004\u0006\u000em$!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0004\n\u0012\u0003\raa#\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!1QRBH\u001b\t\u0019y(\u0003\u0003\u0004\u0012\u000e}$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005'$\u0005\u0019\u0001B\f\u0011\u001d\u0019\u0019\u0007\u0012a\u0001\u0007KBqa!'E\u0001\u0004\u00119\"\u0001\u0006ok6\u0014VmY8sIN\f1\"\\3ue&\u001cg+\u00197vKR11QMBP\u0007GCqa!)F\u0001\u0004\u0011)0\u0001\u0006nKR\u0014\u0018n\u0019+za\u0016Dqa!*F\u0001\u0004\u0011)0\u0001\u0003oC6,\u0017A\u0005;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$Baa+\u00042B!!1KBW\u0013\u0011\u0019yK!\u0016\u0003%QKWM\u001d)beRLG/[8o'R\fG/\u001a\u0005\b\u0007g3\u0005\u0019ABF\u0003%\u0001\u0018M\u001d;ji&|g\u000eK\u0004\u0001\u0007o\u001bila0\u0011\t\tE5\u0011X\u0005\u0005\u0007w\u0013\u0019JA\u0002UC\u001e\fQA^1mk\u0016\f#a!1\u0002\u0017%tG/Z4sCRLwN\u001c")
public class TierIntegrationTest {
    private final MockTime mockTime = new MockTime(0L, 0L);
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(TestUtils.tempDirectory(null, null).getAbsolutePath()));
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), null, 1, 1, 33, "cluster99", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()));
    private TierTopicConsumer tierTopicConsumer;
    private TierLogComponents tierLogComponents;
    private File tempDir;
    private TierTasks tierTasks;
    private ReplicaManager replicaManager;
    private MockInMemoryTierObjectStore tierObjectStore;
    private TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator = (TierDeletedPartitionsCoordinator)Mockito.mock(TierDeletedPartitionsCoordinator.class);
    private TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private Seq<MergedLog> logs;
    private TierTopicManager tierTopicManager;
    private MockConsumerSupplier<byte[], byte[]> consumerSupplier;
    private final int maxWaitTimeMs;
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    private MockTime mockTime() {
        return this.mockTime;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public void tierTopicConsumer_$eq(TierTopicConsumer x$1) {
        this.tierTopicConsumer = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public void tierLogComponents_$eq(TierLogComponents x$1) {
        this.tierLogComponents = x$1;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public TierTasks tierTasks() {
        return this.tierTasks;
    }

    public void tierTasks_$eq(TierTasks x$1) {
        this.tierTasks = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(MockInMemoryTierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator() {
        return this.tierDeletedPartitionsCoordinator;
    }

    public void tierDeletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.tierDeletedPartitionsCoordinator = x$1;
    }

    public TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    public void tierStateFetcher_$eq(TierStateFetcher x$1) {
        this.tierStateFetcher = x$1;
    }

    public Seq<MergedLog> logs() {
        return this.logs;
    }

    public void logs_$eq(Seq<MergedLog> x$1) {
        this.logs = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    public void consumerSupplier_$eq(MockConsumerSupplier<byte[], byte[]> x$1) {
        this.consumerSupplier = x$1;
    }

    public int maxWaitTimeMs() {
        return this.maxWaitTimeMs;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public MBeanServer mBeanServer() {
        return this.mBeanServer;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean cleanupEnabled() {
        return false;
    }

    public TierPartitionStateCleanupConfig cleanupConfig() {
        return new TierPartitionStateCleanupConfig(this.cleanupEnabled(), Defaults$.MODULE$.TierPartitionStateCleanupDelayMs(), 0L);
    }

    public void setup(Integer numLogs, Integer numArchiverThreads) {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.tierObjectStore_$eq(new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1))));
        this.setupTierComponents();
        long x$5 = 604800000L;
        long x$6 = 604800000L;
        long x$7 = -1L;
        long x$8 = 0L;
        String x$9 = "delete";
        int x$10 = 0xA00000;
        String x$11 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$12 = 60000L;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, 150, x$6, x$7, x$8, x$9, 65536, 1, x$10, x$11, x$12, true, x$13, x$14, x$15, x$16, x$17, x$18);
        File tempDir = TestUtils.tempDirectory(null, null);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(Predef$.MODULE$.Integer2int(numLogs));
        IndexedSeq<MergedLog> logs = this.createLogs(Predef$.MODULE$.Integer2int(numLogs), logConfig, tempDir, this.tierLogComponents(), logDirFailureChannel);
        ReplicaManager replicaManager = this.mockReplicaManager((Iterable<AbstractLog>)logs);
        Pool logPool = new Pool((Option)None$.MODULE$);
        logs.map((Function1 & Serializable)log -> (AbstractLog)logPool.put((Object)log.topicPartition(), log));
        int x$19 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        int x$20 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        int x$21 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        long x$24 = 600000L;
        long x$25 = 500L;
        int x$26 = 50;
        boolean x$27 = false;
        boolean x$28 = false;
        None$ x$29 = None$.MODULE$;
        None$ x$30 = None$.MODULE$;
        TierTasks tierTasks = new TierTasks(new TierTasksConfig(x$19, x$20, x$21, 1, x$24, x$25, x$26, 20, x$27, x$28, (Option)x$29, (Option)x$30), replicaManager, this.tierReplicaManager(), this.tierDeletedPartitionsCoordinator(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.tierObjectStore(), (Time)this.mockTime());
        this.tierTasks_$eq(tierTasks);
        this.replicaManager_$eq(replicaManager);
        this.logs_$eq((Seq<MergedLog>)logs);
        this.tempDir_$eq(tempDir);
    }

    public Integer setup$default$1() {
        return Predef$.MODULE$.int2Integer(2);
    }

    public Integer setup$default$2() {
        return Predef$.MODULE$.int2Integer(10);
    }

    @BeforeEach
    public void before() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@Before");
    }

    @AfterEach
    public void teardown() {
        this.tierTasks().shutdown();
        this.tierTopicManager().shutdown();
        this.tierTopicConsumer().shutdown();
        ReplicaManager qual$1 = this.replicaManager();
        boolean x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.tierObjectStore().close();
        this.logs().foreach((Function1 & Serializable)x$10 -> {
            x$10.close();
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(this.logDirs()).asScala().foreach((Function1 & Serializable)path -> {
            TierIntegrationTest.$anonfun$teardown$2(path);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@After");
        Mockito.framework().clearInlineMocks();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverImmigrate() {
        this.setup(this.setup$default$1(), this.setup$default$2());
        this.tierTasks().start();
        this.waitForImmigration(this.logs(), 1, this.tierTasks(), this.consumerSupplier(), true);
        this.tierReplicaManager().becomeFollower(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()));
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$testArchiverImmigrate$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Archiver should process pending emigrations");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
        this.tierReplicaManager().becomeLeader(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()), 2);
        long l = 100L;
        long waitUntilTrue_waitTimeMs2 = 2000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$testArchiverImmigrate$4(this)) {
            void waitUntilTrue_pause2;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Archiver should process pending immigrations");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverUploadAndMaterialize() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        void archiveAndMaterializeUntilTrue_consumerSupplier2;
        void archiveAndMaterializeUntilTrue_consumerSupplier3;
        this.setup(Predef$.MODULE$.int2Integer(10), this.setup$default$2());
        this.tierTasks().start();
        int numBatches = 6;
        int leaderEpoch = 1;
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, numBatches, 4);
            return BoxedUnit.UNIT;
        });
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$2(leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$4(log)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier3, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var3_5 = null;
        string = null;
        mockConsumerSupplier = null;
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$5(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier2 = this.consumerSupplier();
        String string2 = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred2 = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$7(log)));
        long l2 = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs2 = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier2, (Function0)archiveAndMaterializeUntilTrue_pred2)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime2 + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs2) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs2), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var12_11 = null;
        string2 = null;
        mockConsumerSupplier2 = null;
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$8(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier3 = this.consumerSupplier();
        String string3 = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred3 = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$10(log)));
        long l3 = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs3 = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred3)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime3 + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs3) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs3), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var21_17 = null;
        string3 = null;
        mockConsumerSupplier3 = null;
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$11(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        this.setup(Predef$.MODULE$.int2Integer(10), this.setup$default$2());
        this.tierTasks().start();
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, 6, 4);
            return BoxedUnit.UNIT;
        });
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String archiveAndMaterializeUntilTrue_msg = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$3(log)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var2_4 = null;
        Object var3_3 = null;
        mockConsumerSupplier = null;
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$4(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverUploadWithLimitedUploadConcurrency() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        int maxConcurrentUploads = 2;
        int nLogs = 3;
        this.setup(Predef$.MODULE$.int2Integer(nLogs), Predef$.MODULE$.int2Integer(maxConcurrentUploads));
        this.tierTasks().start();
        int batches = 3;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, batches, recordsPerBatch);
            return BoxedUnit.UNIT;
        });
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Expected all logs to eventually become tiered";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadWithLimitedUploadConcurrency$3(x$12))) && this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadWithLimitedUploadConcurrency$4(log)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
    }

    @Test
    public void testArchiverLagMetrics() {
        int numLogs = 5;
        int batches = 6;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.setup(Predef$.MODULE$.int2Integer(numLogs), this.setup$default$2());
        this.tierTasks().start();
        Assertions.assertEquals((long)0L, (long)this.totalLag$1());
        Assertions.assertEquals((long)0L, (long)this.maxTimeLag$1());
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverLagMetrics$5(this, leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)0L, (long)this.totalLag$1());
        Assertions.assertEquals((long)0L, (long)this.maxTimeLag$1());
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, batches, recordsPerBatch);
            return BoxedUnit.UNIT;
        });
        this.mockTime().sleep(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1);
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assertions.assertTrue((this.maxTimeLag$1() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.logs().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)TierIntegrationTest.$anonfun$testArchiverLagMetrics$7(x$15)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), false);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), batches).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)archivedBatches -> this.awaitMaterializeBatchAndAssertLag$1(archivedBatches));
        Assertions.assertEquals((long)0L, (long)this.maxTimeLag$1());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForImmigration(Seq<MergedLog> logs, int leaderEpoch, TierTasks tierTasks, MockConsumerSupplier<byte[], byte[]> consumerSupplier, boolean becomeLeader) {
        if (becomeLeader) {
            logs.foreach((Function1 & Serializable)log -> {
                TierIntegrationTest.$anonfun$waitForImmigration$1(this, leaderEpoch, log);
                return BoxedUnit.UNIT;
            });
        }
        String string = "Expect leadership to materialize";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> logs.forall((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$3(x$17)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var6_7 = null;
        string = null;
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$waitForImmigration$4(this, consumerSupplier, tierTasks, logs)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$waitForImmigration$7(tierTasks));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean waitForImmigration$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void archiveAndMaterializeUntilTrue(Function0<Object> pred, String msg, MockConsumerSupplier<byte[], byte[]> consumerSupplier) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, consumerSupplier, pred)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void validatePartitionStateContainedInObjectStore(MockInMemoryTierObjectStore tierObjectStore, Iterable<AbstractLog> logs) {
        logs.foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$1(tierObjectStore, log);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void setupTierComponents() {
        MockProducerSupplier producerSupplier = new MockProducerSupplier();
        this.consumerSupplier_$eq(new MockConsumerSupplier<byte[], byte[]>("primary", TierTopicManager.partitions((String)TierTopic.topicName((String)this.tierTopicManagerConfig().tierNamespace), (int)this.tierTopicManagerConfig().configuredNumPartitions), producerSupplier.producer()));
        this.tierTopicConsumer_$eq(new TierTopicConsumer(this.tierTopicManagerConfig(), this.consumerSupplier(), this.consumerSupplier(), this.consumerSupplier(), new TierTopicManagerCommitter(this.tierTopicManagerConfig(), (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class)), this.tierStateFetcher(), Optional.empty(), (Time)this.mockTime()));
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenAnswer((Answer)new Answer<Object>(null){

            public int answer(InvocationOnMock invocation) {
                return BoxesRunTime.unboxToInt((Object)invocation.getArgument(1));
            }
        });
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.tierTopicManager_$eq(new TierTopicManager(this.tierTopicManagerConfig(), this.tierTopicConsumer(), producerSupplier, () -> internalAdmin, replicaManager, (Time)this.mockTime(), (Metrics)Mockito.mock(Metrics.class)));
        this.tierLogComponents_$eq(new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), new TierPartitionStateFactory(true, this.checksumEnabled(), true, this.cleanupConfig(), true, 0), (Option)None$.MODULE$));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$setupTierComponents$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private IndexedSeq<MergedLog> createLogs(int n, LogConfig logConfig, File tempDir, TierLogComponents tierLogComponents, LogDirFailureChannel logDirFailureChannel) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable)i -> TierIntegrationTest.$anonfun$createLogs$1(this, tempDir, logConfig, logDirFailureChannel, tierLogComponents, BoxesRunTime.unboxToInt((Object)i)));
    }

    private ReplicaManager mockReplicaManager(Iterable<AbstractLog> logs) {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog((TopicPartition)ArgumentMatchers.any(TopicPartition.class))).thenAnswer((Answer)new Answer<Option<AbstractLog>>(null, logs){
            private final Iterable logs$2;

            public Option<AbstractLog> answer(InvocationOnMock invocation) {
                TopicPartition target = (TopicPartition)invocation.getArgument(0);
                return this.logs$2.find((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)$anon$2.$anonfun$answer$1(target, log)));
            }

            public static final /* synthetic */ boolean $anonfun$answer$1(TopicPartition target$1, AbstractLog log) {
                TopicPartition topicPartition = log.topicPartition();
                return !(topicPartition != null ? !topicPartition.equals(target$1) : target$1 != null);
            }
            {
                this.logs$2 = logs$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(org.apache.kafka.common.TopicPartition kafka.log.AbstractLog )}, serializedLambda);
            }
        });
        Iterable partitions = (Iterable)logs.map((Function1 & Serializable)log -> {
            Partition partition = (Partition)Mockito.mock(Partition.class);
            Mockito.when((Object)partition.log()).thenReturn((Object)new Some(log));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
            Mockito.when((Object)replicaManager.getPartitionOrError(log.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
            return partition;
        });
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer(x$19 -> partitions.iterator());
        return replicaManager;
    }

    private void writeRecordBatches(AbstractLog log, int leaderEpoch, long baseOffset, int batches, int recordsPerBatch) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), batches).foreach((Function1 & Serializable)idx -> TierIntegrationTest.$anonfun$writeRecordBatches$1(this, log, leaderEpoch, baseOffset, recordsPerBatch, BoxesRunTime.unboxToInt((Object)idx)));
        log.flush(false);
        log.updateHighWatermark((long)(batches * recordsPerBatch));
    }

    private MemoryRecords createRecords(TopicPartition topicPartition, int leaderEpoch, long baseOffset, int numRecords) {
        IndexedSeq recList = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)x$20 -> TierIntegrationTest.$anonfun$createRecords$1(BoxesRunTime.unboxToInt((Object)x$20)));
        byte x$3 = 2;
        CompressionType x$4 = CompressionType.NONE;
        long x$5 = -1L;
        short x$6 = -1;
        int x$7 = -1;
        int x$8 = -1;
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)recList, x$3, x$4, x$5, x$6, x$7, baseOffset, x$8);
        ByteBuffer filtered = ByteBuffer.allocate(100 * numRecords);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().foreach((Function1 & Serializable)x$21 -> {
            x$21.setPartitionLeaderEpoch(leaderEpoch);
            return BoxedUnit.UNIT;
        });
        records.filterTo(topicPartition, new MemoryRecords.RecordFilter(null){

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                return new MemoryRecords.RecordFilter.BatchRetentionResult(MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY, false);
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return new MemoryRecords(filtered);
    }

    private long metricValue(String metricType, String name) {
        return BoxesRunTime.unboxToLong((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$metricValue$1(metricType, name, x0$1)))).values().head()).value());
    }

    private TierPartitionState tierPartitionState(TopicPartition partition) {
        return (TierPartitionState)this.logs().find((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$tierPartitionState$1(partition, x$22))).map((Function1 & Serializable)x$23 -> x$23.tierPartitionState()).get();
    }

    public static final /* synthetic */ void $anonfun$teardown$2(String path) {
        Utils.delete((File)new File(path), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$2(Set x$11) {
        return x$11.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$1(TierIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverImmigrate$2(x$11))));
    }

    public static final /* synthetic */ String $anonfun$testArchiverImmigrate$3() {
        return "Archiver should process pending emigrations";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$6(ArchiveTask task) {
        return task.state() instanceof BeforeUpload || task.state() instanceof AfterUpload;
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$4(TierIntegrationTest $this) {
        $this.consumerSupplier().moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)$this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)tasks.forall((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverImmigrate$6(task))))));
    }

    public static final /* synthetic */ String $anonfun$testArchiverImmigrate$7() {
        return "Archiver should process pending immigrations";
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$2(int leaderEpoch$1, MergedLog log) {
        Assertions.assertEquals((int)log.tierPartitionState().tierEpoch(), (int)leaderEpoch$1, (String)new StringBuilder(43).append("topic manager should materialize entry for ").append(log.topicPartition()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$4(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 1;
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$5(MergedLog log) {
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)log.tierPartitionState().metadata(0L).get()).baseOffset(), (String)"batch 1: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0, (String)"batch 1: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$7(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 2 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$8(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        Assertions.assertEquals((long)4L, (long)((TierLogSegment)tierPartitionState.metadata(6L).get()).baseOffset(), (String)"batch 2: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((tierPartitionState.committedEndOffset() >= 7L ? 1 : 0) != 0, (String)"batch 2: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$10(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 3 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$11(MergedLog log) {
        Assertions.assertEquals((long)8L, (long)((TierLogSegment)log.tierPartitionState().metadata(10L).get()).baseOffset(), (String)"batch 3: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 11L ? 1 : 0) != 0, (String)"batch 3: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$3(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() > 0 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$4(MergedLog log) {
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)log.tierPartitionState().metadata(0L).get()).baseOffset(), (String)"Segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0, (String)"Segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadWithLimitedUploadConcurrency$3(MergedLog x$12) {
        return x$12.tierableLogSegments().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadWithLimitedUploadConcurrency$4(MergedLog log) {
        return log.tieredLogSegments().nonEmpty();
    }

    private final long totalLag$1() {
        return this.metricValue("TierArchiver", "TotalLag");
    }

    private final long maxTimeLag$1() {
        return this.metricValue("TierArchiver", "PartitionTimeLagMaxValue");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverLagMetrics$2(int archivedBatches$1, MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= archivedBatches$1 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ int $anonfun$testArchiverLagMetrics$3(MergedLog x$13) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)x$13.tierableLogSegments().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private final void awaitMaterializeBatchAndAssertLag$1(int archivedBatches) {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String archiveAndMaterializeUntilTrue_msg = new StringBuilder(49).append("Should materialize segments for batch ").append(archivedBatches).append(" or greater").toString();
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverLagMetrics$2(archivedBatches, log)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var2_4 = null;
        Object var3_3 = null;
        mockConsumerSupplier = null;
        this.mockTime().sleep(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1);
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.logs().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)TierIntegrationTest.$anonfun$testArchiverLagMetrics$3(x$13)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
        if (this.totalLag$1() > 0L) {
            Assertions.assertTrue((this.maxTimeLag$1() > 0L ? 1 : 0) != 0);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testArchiverLagMetrics$5(TierIntegrationTest $this, int leaderEpoch$4, MergedLog log) {
        log.assignTopicId(Uuid.randomUuid(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$4);
    }

    public static final /* synthetic */ int $anonfun$testArchiverLagMetrics$7(MergedLog x$15) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)x$15.tierableLogSegments().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$waitForImmigration$1(TierIntegrationTest $this, int leaderEpoch$5, MergedLog log) {
        log.assignTopicId(Uuid.randomUuid(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$5);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$3(MergedLog x$17) {
        TierPartitionStatus tierPartitionStatus = x$17.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$6(ArchiveTask x$18) {
        return x$18.state() instanceof BeforeLeader;
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$5(Seq logs$1, Set tasks) {
        return tasks.size() == logs$1.size() && !tasks.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$6(x$18)));
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$4(TierIntegrationTest $this, MockConsumerSupplier consumerSupplier$1, TierTasks tierTasks$1, Seq logs$1) {
        consumerSupplier$1.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)tierTasks$1.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$5(logs$1, tasks))));
    }

    public static final /* synthetic */ String $anonfun$waitForImmigration$7(TierTasks tierTasks$1) {
        return new StringBuilder(28).append("Expect zero BeforeLeader in ").append(tierTasks$1.archiverTaskQueue()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$archiveAndMaterializeUntilTrue$1(TierIntegrationTest $this, MockConsumerSupplier consumerSupplier$2, Function0 pred$1) {
        consumerSupplier$2.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return pred$1.apply$mcZ$sp();
    }

    public static final /* synthetic */ String $anonfun$archiveAndMaterializeUntilTrue$2(String msg$1) {
        return msg$1;
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$2(MockInMemoryTierObjectStore tierObjectStore$1, TierLogSegment tierSegment) {
        Assertions.assertNotNull((Object)tierObjectStore$1.getObject((TierObjectStore.ObjectStoreMetadata)tierSegment.metadata(), TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1000)));
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$1(MockInMemoryTierObjectStore tierObjectStore$1, AbstractLog log) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(log.tierPartitionState().segments()).asScala().foreach((Function1 & Serializable)tierSegment -> {
            TierIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$2(tierObjectStore$1, tierSegment);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$setupTierComponents$2(TierIntegrationTest $this) {
        $this.tierTopicManager().tryBecomeReady(false);
        return $this.tierTopicManager().isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$setupTierComponents$3() {
        return "Timed out waiting for TierTopicManager to be ready";
    }

    public static final /* synthetic */ MergedLog $anonfun$createLogs$1(TierIntegrationTest $this, File tempDir$1, LogConfig logConfig$1, LogDirFailureChannel logDirFailureChannel$1, TierLogComponents tierLogComponents$1, int i) {
        File logDir = tempDir$1.toPath().resolve(new StringBuilder(12).append("tierlogtest-").append(i).toString()).toFile();
        logDir.mkdir();
        MockScheduler x$5 = $this.mockTime().scheduler();
        BrokerTopicStats x$6 = new BrokerTopicStats();
        Metrics x$7 = new Metrics();
        MockTime x$8 = $this.mockTime();
        ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(3600000);
        None$ x$12 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        LogOffsetsListener x$19 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        ConcurrentHashMap x$20 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(logDir, logConfig$1, 0L, 0L, (Scheduler)x$5, x$6, x$7, (Time)x$8, 300000, x$10, 600000, (Option)x$12, logDirFailureChannel$1, tierLogComponents$1, true, (Option)x$17, true, x$19, (Option)x$18, x$20);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$writeRecordBatches$1(TierIntegrationTest $this, AbstractLog log$1, int leaderEpoch$6, long baseOffset$1, int recordsPerBatch$3, int idx) {
        MemoryRecords records = $this.createRecords(log$1.topicPartition(), leaderEpoch$6, baseOffset$1 + (long)(idx * recordsPerBatch$3), recordsPerBatch$3);
        return log$1.appendAsFollower(records);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createRecords$1(int x$20) {
        return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String metricType$1, String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.getType();
            if (!(string != null ? !string.equals(metricType$1) : metricType$1 != null)) {
                String string2 = metricName.getName();
                if (!(string2 != null ? !string2.equals(name$1) : name$1 != null)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tierPartitionState$1(TopicPartition partition$1, MergedLog x$22) {
        TopicPartition topicPartition = x$22.topicPartition();
        return !(topicPartition != null ? !topicPartition.equals(partition$1) : partition$1 != null);
    }

    public TierIntegrationTest() {
        this.maxWaitTimeMs = 20000;
    }
}

