/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0015e\u0001B\u0014)\u00015BQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013\u0005q\b\u0003\u0004I\u0001\u0001\u0006I\u0001\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019!\u0006\u0001)A\u0005\u0017\"9Q\u000b\u0001b\u0001\n\u0003Q\u0005B\u0002,\u0001A\u0003%1\nC\u0004X\u0001\u0001\u0007I\u0011\u0001-\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\"1a\u000e\u0001Q!\neCqa\u001c\u0001A\u0002\u0013\u0005\u0001\u000fC\u0004~\u0001\u0001\u0007I\u0011\u0001@\t\u000f\u0005\u0005\u0001\u0001)Q\u0005c\"I\u00111\u0001\u0001C\u0002\u0013\u0005\u0011Q\u0001\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\b!I\u0011Q\u0004\u0001C\u0002\u0013\u0005\u0011q\u0004\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002\"!I\u00111\u0007\u0001A\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0001\u0003\u000bB\u0001\"!\u0013\u0001A\u0003&\u0011q\u0007\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\ty\u0007\u0001C!\u0003cBq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9\u00111\u001e\u0001\u0005\n\u0005E\u0004bBAw\u0001\u0011%\u0011q\u001e\u0005\b\u0003k\u0004A\u0011BA|\u0011\u001d\tY\u0010\u0001C\u0005\u0003{DqA!\u0001\u0001\t\u0013\u0011\u0019\u0001C\u0004\u0003\u001c\u0001!IA!\b\t\r\t=\u0002\u0001\"\u0003q\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005gAqA!\u000e\u0001\t#\u00129\u0004C\u0004\u0003D\u0001!IA!\u0012\t\u000f\t-\u0003\u0001\"\u0003\u0003N!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003\"\u0003B7\u0001E\u0005I\u0011\u0001B8\u0005u!\u0016.\u001a:Fa>\u001c\u0007n\u0015;bi\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8UKN$(BA\u0015+\u0003\u0011!\u0018.\u001a:\u000b\u0003-\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0016\u0002\rM,'O^3s\u0013\t\u0019\u0004GA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0016\u0002\u000bU$\u0018\u000e\\:\n\u0005e2$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0002\"!\u0010\u0001\u000e\u0003!\nQ\u0001^8qS\u000e,\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA\u0001\\1oO*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n1!\\:h+\u0005Y\u0005c\u0001'P#6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJA\u0003BeJ\f\u0017\u0010\u0005\u0002M%&\u00111+\u0014\u0002\u0005\u0005f$X-\u0001\u0003ng\u001e\u0004\u0013!C7tO\nKwmZ3s\u0003)i7o\u001a\"jO\u001e,'\u000fI\u0001\bEJ|7.\u001a:t+\u0005I\u0006\u0003\u0002.`C\u0012l\u0011a\u0017\u0006\u00039v\u000bq!\\;uC\ndWM\u0003\u0002_\u001b\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001\\&aA'baB\u0011AJY\u0005\u0003G6\u00131!\u00138u!\tyS-\u0003\u0002ga\tY1*\u00194lC\n\u0013xn[3s\u0003-\u0011'o\\6feN|F%Z9\u0015\u0005%d\u0007C\u0001'k\u0013\tYWJ\u0001\u0003V]&$\bbB7\n\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\n\u0014\u0001\u00032s_.,'o\u001d\u0011\u0002\u0011A\u0014x\u000eZ;dKJ,\u0012!\u001d\t\u0005en\\5*D\u0001t\u0015\tyGO\u0003\u0002vm\u000691\r\\5f]R\u001c(BA\u0016x\u0015\tA\u00180\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0006\u0019qN]4\n\u0005q\u001c(!D&bM.\f\u0007K]8ek\u000e,'/\u0001\u0007qe>$WoY3s?\u0012*\u0017\u000f\u0006\u0002j\u007f\"9Q\u000eDA\u0001\u0002\u0004\t\u0018!\u00039s_\u0012,8-\u001a:!\u0003\u0019)\u00070\u001b;fIV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t9\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0019\tGo\\7jG*!\u0011\u0011CA\n\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003+!\u0015\u0001B;uS2LA!!\u0007\u0002\f\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fq!\u001a=ji\u0016$\u0007%\u0001\u0007mSN$XM\\3s\u001d\u0006lW-\u0006\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012a\u00028fi^|'o\u001b\u0006\u0004\u0003W1\u0018AB2p[6|g.\u0003\u0003\u00020\u0005\u0015\"\u0001\u0004'jgR,g.\u001a:OC6,\u0017!\u00047jgR,g.\u001a:OC6,\u0007%\u0001\tle\u00064G/\u00113nS:\u001cE.[3oiV\u0011\u0011q\u0007\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b;\u0002\u000b\u0005$W.\u001b8\n\t\u0005\u0005\u00131\b\u0002\f\u0003\u0012l\u0017N\\\"mS\u0016tG/\u0001\u000ble\u00064G/\u00113nS:\u001cE.[3oi~#S-\u001d\u000b\u0004S\u0006\u001d\u0003\u0002C7\u0014\u0003\u0003\u0005\r!a\u000e\u0002#-\u0014\u0018M\u001a;BI6Lgn\u00117jK:$\b%A\u0003tKR,\u0006\u000fF\u0002j\u0003\u001fBq!!\u0015\u0016\u0001\u0004\t\u0019&\u0001\u0005uKN$\u0018J\u001c4p!\u0011\t)&a\u0019\u000e\u0005\u0005]#\u0002BA-\u00037\n1!\u00199j\u0015\u0011\ti&a\u0018\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011M=\u0002\u000b),h.\u001b;\n\t\u0005\u0015\u0014q\u000b\u0002\t)\u0016\u001cH/\u00138g_\"\u001aQ#!\u001b\u0011\t\u0005U\u00131N\u0005\u0005\u0003[\n9F\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002S\"\u001aa#!\u001e\u0011\t\u0005U\u0013qO\u0005\u0005\u0003s\n9FA\u0005BMR,'/R1dQ\u0006\t2M]3bi\u0016\fE-\\5o\u00072LWM\u001c;\u0015\t\u0005]\u0012q\u0010\u0005\u0007/^\u0001\r!!!\u0011\u000b\u0005\r\u0015Q\u00113\u000e\u0003uK1!a\"^\u0005\r\u0019V-]\u0001%i\u0016\u001cH\u000fV5feN#\u0018\r^3SKN$xN]3P]2\u000bwmZ5oOJ+\u0007\u000f\\5dCR\u0019\u0011.!$\t\u000f\u0005=\u0005\u00041\u0001\u0002\u0012\u00061\u0011/^8sk6\u0004B!a%\u0002\":!\u0011QSAO!\r\t9*T\u0007\u0003\u00033S1!a'-\u0003\u0019a$o\\8u}%\u0019\u0011qT'\u0002\rA\u0013X\rZ3g\u0013\r9\u00151\u0015\u0006\u0004\u0003?k\u0005f\u0002\r\u0002(\u0006]\u0016\u0011\u0018\t\u0005\u0003S\u000b\u0019,\u0004\u0002\u0002,*!\u0011QVAX\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BAY\u00037\na\u0001]1sC6\u001c\u0018\u0002BA[\u0003W\u00131BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BA^\u0003\u007f\u000b#!!0\u0002\u0005i\\\u0017EAAa\u0003\u0015Y'/\u00194uQ\u001dA\u0012QYAg\u0003\u001f\u0004B!a2\u0002J6\u0011\u0011qV\u0005\u0005\u0003\u0017\fyKA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011\u0011[\u0001\u0019w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBj\u0018AB4fi2{w\r\u0006\u0004\u0002X\u0006\r\u0018q\u001d\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\u001c\u0016\u0002\u00071|w-\u0003\u0003\u0002b\u0006m'aC!cgR\u0014\u0018m\u0019;M_\u001eDa!!:\u001a\u0001\u0004!\u0017A\u00022s_.,'\u000f\u0003\u0004\u0002jf\u0001\r!Y\u0001\na\u0006\u0014H/\u001b;j_:\fQB\u0019:pW\u0016\u00148\t[1oO\u0016$\u0017\u0001B:u_B$2![Ay\u0011\u0019\t\u0019p\u0007a\u0001C\u0006\u0011\u0011\u000eZ\u0001\u0006gR\f'\u000f\u001e\u000b\u0004S\u0006e\bBBAz9\u0001\u0007\u0011-\u0001\u0004c_Vt7-\u001a\u000b\u0004S\u0006}\bBBAz;\u0001\u0007\u0011-\u0001\u0006fa>\u001c\u0007nQ1dQ\u0016$BA!\u0002\u0003\u001aA!!q\u0001B\u000b\u001b\t\u0011IA\u0003\u0003\u0003\f\t5\u0011!B3q_\u000eD'\u0002\u0002B\b\u0005#\t\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\tMa/A\u0004ti>\u0014\u0018mZ3\n\t\t]!\u0011\u0002\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3\t\r\u0005\u0015h\u00041\u0001e\u0003!\tw/Y5u\u0013N\u0013F#B5\u0003 \t-\u0002b\u0002B\u0011?\u0001\u0007!1E\u0001\u0003iB\u0004BA!\n\u0003(5\u0011\u0011\u0011F\u0005\u0005\u0005S\tIC\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\t5r\u00041\u0001b\u0003-qW/\u001c*fa2L7-Y:\u0002\u001d\r\u0014X-\u0019;f!J|G-^2fe\u0006y1-\u001e:sK:$H*Z1eKJLE-F\u0001b\u0003YY'/\u00194u\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e\u001cHC\u0001B\u001d!\u0019\t\u0019)!\"\u0003<A!!Q\bB \u001b\t\t\u0019\"\u0003\u0003\u0003B\u0005M!A\u0003)s_B,'\u000f^5fg\u0006\t\u0012\r\u001a3O_\u0012,\u0007K]8qKJ$\u0018.Z:\u0015\u0007%\u00149\u0005C\u0004\u0003J\r\u0002\rAa\u000f\u0002\r\r|gNZ5h\u0003I\u0019'/Z1uK\n\u0013xn[3s/&$\b.\u00133\u0015\u0007\u0011\u0014y\u0005\u0003\u0004\u0002t\u0012\u0002\r!Y\u0001\fGJ,\u0017\r^3U_BL7\r\u0006\u0006\u0003V\t}#\u0011\rB3\u0005S\u0002bAa\u0016\u0003^\u0005\fWB\u0001B-\u0015\r\u0011Y&X\u0001\nS6lW\u000f^1cY\u0016L1\u0001\u0019B-\u0011\u0019qT\u00051\u0001\u0002\u0012\"1!1M\u0013A\u0002\u0005\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bB\u0002B4K\u0001\u0007\u0011-A\tsKBd\u0017nY1uS>tg)Y2u_JD\u0011Ba\u001b&!\u0003\u0005\rAa\u000f\u0002\u0017Q|\u0007/[2D_:4\u0017nZ\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\tH\u000b\u0003\u0003<\tM4F\u0001B;!\u0011\u00119H!!\u000e\u0005\te$\u0002\u0002B>\u0005{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}T*\u0001\u0006b]:|G/\u0019;j_:LAAa!\u0003z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TierEpochStateReplicationTest
extends QuorumTestHarness {
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final byte[] msgBigger = new byte[10000];
    private scala.collection.mutable.Map<Object, KafkaBroker> brokers = (scala.collection.mutable.Map)Map$.MODULE$.empty();
    private KafkaProducer<byte[], byte[]> producer = null;
    private final AtomicBoolean exited = new AtomicBoolean(false);
    private final ListenerName listenerName = ListenerName.normalised((String)"PLAINTEXT");
    private AdminClient kraftAdminClient = null;

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public byte[] msgBigger() {
        return this.msgBigger;
    }

    public scala.collection.mutable.Map<Object, KafkaBroker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(scala.collection.mutable.Map<Object, KafkaBroker> x$1) {
        this.brokers = x$1;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    public ListenerName listenerName() {
        return this.listenerName;
    }

    public AdminClient kraftAdminClient() {
        return this.kraftAdminClient;
    }

    public void kraftAdminClient_$eq(AdminClient x$1) {
        this.kraftAdminClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        if (this.kraftAdminClient() != null) {
            this.kraftAdminClient().close();
        }
        TestUtils$.MODULE$.shutdownServers(this.brokers().values().toSeq(), true);
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    public AdminClient createAdminClient(Seq<KafkaBroker> brokers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers(brokers, this.listenerName()));
        properties.put("request.timeout.ms", "20000");
        return (AdminClient)Admin.create((Properties)properties);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTierStateRestoreOnLaggingReplica(String quorum) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 102).foreach((Function1 & Serializable)id -> TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$1(this, BoxesRunTime.unboxToInt((Object)id)));
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("segment.bytes", "10000");
        properties.put("retention.bytes", "-1");
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        int leaderId = ((Tuple2)this.createTopic(this.topic(), 1, 3, properties).head())._2$mcI$sp();
        int followerId = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.option2Iterable(this.brokers().keys().find((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 != leaderId)).head());
        KafkaBroker leader = (KafkaBroker)this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)leaderId));
        KafkaBroker follower = (KafkaBroker)this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)followerId));
        this.producer_$eq(this.createProducer());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        int epochBeforeLeaderBounce = this.epochCache(leader).latestEpoch().getAsInt();
        this.bounce(leaderId);
        this.awaitISR(tp, 3);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$3(this, leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for preferred leader to be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaBroker newLeader = (KafkaBroker)this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)leaderId));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$5(newLeader)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for tier topic manager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        int epochAfterLeaderBounce = this.epochCache(newLeader).latestEpoch().getAsInt();
        Assertions.assertTrue((epochAfterLeaderBounce > epochBeforeLeaderBounce ? 1 : 0) != 0);
        Assertions.assertEquals((Object)this.epochCache(newLeader).epochEntries(), (Object)this.epochCache(follower).epochEntries());
        this.brokers().foreach((Function1 & Serializable)kv -> {
            TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$7(kv);
            return BoxedUnit.UNIT;
        });
        this.stop(followerId);
        this.awaitISR(tp, 2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 999).foreach((Function1 & Serializable)x$4 -> TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$10(this, BoxesRunTime.unboxToInt((Object)x$4)));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 60000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$11(newLeader, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"timed out waiting for segment tiering and hotset retention");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((this.epochCache(newLeader).latestEpoch().getAsInt() > epochAfterLeaderBounce ? 1 : 0) != 0);
        this.start(followerId);
        this.awaitISR(tp, 3);
        KafkaBroker newFollower = (KafkaBroker)this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)followerId));
        Assertions.assertEquals((Object)this.epochCache(newLeader).epochEntries(), (Object)this.epochCache(newFollower).epochEntries());
    }

    private AbstractLog getLog(KafkaBroker broker, int partition) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(this.topic(), partition);
        boolean x$2 = qual$1.getLog$default$2();
        return (AbstractLog)qual$1.getLog(x$1, x$2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void brokerChanged() {
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private void stop(int id) {
        this.brokers().remove((Object)BoxesRunTime.boxToInteger((int)id)).foreach((Function1 & Serializable)broker -> {
            TierEpochStateReplicationTest.$anonfun$stop$1(broker);
            return BoxedUnit.UNIT;
        });
        this.brokerChanged();
    }

    private void start(int id) {
        this.brokers().put((Object)BoxesRunTime.boxToInteger((int)id), (Object)this.createBrokerWithId(id));
        this.brokerChanged();
    }

    private void bounce(int id) {
        this.brokers().remove((Object)BoxesRunTime.boxToInteger((int)id)).foreach((Function1 & Serializable)broker -> {
            TierEpochStateReplicationTest.$anonfun$bounce$1(broker);
            return BoxedUnit.UNIT;
        });
        this.brokers().put((Object)BoxesRunTime.boxToInteger((int)id), (Object)this.createBrokerWithId(id));
        this.brokerChanged();
    }

    private LeaderEpochFileCache epochCache(KafkaBroker broker) {
        return (LeaderEpochFileCache)this.getLog(broker, 0).leaderEpochCache().get();
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition tp, int numReplicas) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$awaitISR$1(this, tp, numReplicas)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for replicas to join ISR");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaProducer<byte[], byte[]> createProducer() {
        return TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers().values().toSeq(), SecurityProtocol.PLAINTEXT), -1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false);
    }

    private int currentLeaderId() {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)((Tuple2)this.brokers().head())._2()).metadataCache().getPartitionInfo(this.topic(), 0).get()).leader();
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs();
        controllerConfigs.foreach((Function1 & Serializable)config -> {
            this.addNodeProperties(config);
            return BoxedUnit.UNIT;
        });
        return controllerConfigs;
    }

    private void addNodeProperties(Properties config) {
        config.setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        config.setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        config.setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        config.setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        config.setProperty(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        config.setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp(), "0");
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "10");
    }

    private KafkaBroker createBrokerWithId(int id) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        this.addNodeProperties(config);
        return this.createBroker(KafkaConfig$.MODULE$.fromProps(config), Time.SYSTEM, this.createBroker$default$3(), this.createBroker$default$4());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        if (this.isKRaftTest()) {
            this.kraftAdminClient_$eq(this.createAdminClient((Seq<KafkaBroker>)this.brokers().values().toSeq()));
            AdminClient x$1 = this.kraftAdminClient();
            scala.collection.immutable.Seq x$3 = this.brokers().values().toSeq();
            Map x$7 = (Map)scala.collection.Map$.MODULE$.empty();
            return TestUtils$.MODULE$.createTopicWithAdmin((Admin)x$1, topic, x$3, numPartitions, replicationFactor, (Map<Object, Seq<Object>>)x$7, topicConfig);
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaBroker>)this.brokers().values().toSeq(), topicConfig);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public static final /* synthetic */ Option $anonfun$testTierStateRestoreOnLaggingReplica$1(TierEpochStateReplicationTest $this, int id) {
        return $this.brokers().put((Object)BoxesRunTime.boxToInteger((int)id), (Object)$this.createBrokerWithId(id));
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$3(TierEpochStateReplicationTest $this, int leaderId$1) {
        return $this.currentLeaderId() == leaderId$1;
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$4() {
        return "Timed out waiting for preferred leader to be elected";
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$5(KafkaBroker newLeader$1) {
        return ((TierTopicManager)newLeader$1.tierTopicManagerOpt().get()).isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$6() {
        return "Timed out waiting for tier topic manager to be ready";
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$8(Tuple2 kv$1) {
        return ((TierTopicManager)((KafkaBroker)kv$1._2()).tierTopicManagerOpt().get()).isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$9() {
        return "Timed out waiting for tier topic manager to be ready";
    }

    public static final /* synthetic */ void $anonfun$testTierStateRestoreOnLaggingReplica$7(Tuple2 kv) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$8(kv)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for tier topic manager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testTierStateRestoreOnLaggingReplica$10(TierEpochStateReplicationTest $this, int x$4) {
        return (RecordMetadata)$this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg())).get();
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$11(KafkaBroker newLeader$1, TopicPartition tp$1) {
        boolean x$2;
        LogManager qual$1 = newLeader$1.replicaManager().logManager();
        return ((AbstractLog)qual$1.getLog(tp$1, x$2 = qual$1.getLog$default$2()).get()).localLogStartOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$12() {
        return "timed out waiting for segment tiering and hotset retention";
    }

    public static final /* synthetic */ void $anonfun$stop$1(KafkaBroker broker) {
        broker.shutdown();
        broker.awaitShutdown();
    }

    public static final /* synthetic */ void $anonfun$bounce$1(KafkaBroker broker) {
        broker.shutdown();
        broker.awaitShutdown();
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$2(int numReplicas$1, Partition x$5) {
        return x$5.inSyncReplicaIds().size() == numReplicas$1;
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(TierEpochStateReplicationTest $this, TopicPartition tp$2, int numReplicas$1) {
        return ((KafkaBroker)$this.brokers().apply((Object)BoxesRunTime.boxToInteger((int)$this.currentLeaderId()))).replicaManager().onlinePartition(tp$2).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TierEpochStateReplicationTest.$anonfun$awaitISR$2(numReplicas$1, x$5)));
    }

    public static final /* synthetic */ String $anonfun$awaitISR$3() {
        return "Timed out waiting for replicas to join ISR";
    }

    public TierEpochStateReplicationTest() {
        this.topic = "topic1";
    }
}

