/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.common.TenantHelpers;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.AwaitingDeleteComplete$;
import kafka.tier.Config;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.MaterializationComplete$;
import kafka.tier.MaterializingState$;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierObjectGarbageCollector;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\ruf\u0001B\u001f?\u0001\rCQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001C\u0002\u0013%q\n\u0003\u0004W\u0001\u0001\u0006I\u0001\u0015\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0011\u0019y\u0006\u0001)A\u00053\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007B\u00025\u0001A\u0003%!\rC\u0004j\u0001\t\u0007I\u0011\u00026\t\r9\u0004\u0001\u0015!\u0003l\u0011\u001dy\u0007A1A\u0005\nADaa\u001e\u0001!\u0002\u0013\t\bb\u0002=\u0001\u0005\u0004%I!\u001f\u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003{\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA\n\u0011-\t9\u0006\u0001a\u0001\u0002\u0004%I!!\u0017\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013%\u00111\r\u0005\f\u0003_\u0002\u0001\u0019!A!B\u0013\tY\u0006C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002t!A\u0011Q\u0011\u0001!\u0002\u0013\t)\bC\u0005\u0002\b\u0002\u0011\r\u0011\"\u0003\u0002t!A\u0011\u0011\u0012\u0001!\u0002\u0013\t)\bC\u0005\u0002\f\u0002\u0011\r\u0011\"\u0003\u0002\u000e\"A\u00111\u0014\u0001!\u0002\u0013\ty\tC\u0005\u0002\u001e\u0002\u0011\r\u0011\"\u0003\u0002 \"A\u0011q\u0015\u0001!\u0002\u0013\t\t\u000bC\u0004\u0002*\u0002!\t!a+\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002,\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007bBA\u0000\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u00119\u0002\u0001C\u0001\u00053AqAa\t\u0001\t\u0003\u0011)\u0003C\u0004\u00030\u0001!\tA!\r\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\b\u0005?\u0002A\u0011\u0001B1\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0003WCqA!\u001e\u0001\t\u0013\u00119\bC\u0004\u0003&\u0002!IAa*\t\u000f\t]\u0006\u0001\"\u0003\u0003:\"9!q\u0018\u0001\u0005\n\t\u0005\u0007b\u0002Bd\u0001\u0011%!\u0011\u001a\u0005\b\u0005g\u0004A\u0011\u0002B{\u0011\u001d\u0011I\u0010\u0001C\u0005\u0005wDqAa@\u0001\t\u0013\u0019\t\u0001C\u0004\u0004\u0012\u0001!Iaa\u0005\t\u0013\r\u001d\u0004!%A\u0005\n\r%\u0004\"CB@\u0001E\u0005I\u0011BBA\u0011%\u0019)\tAI\u0001\n\u0013\u00199\tC\u0005\u0004\f\u0002\t\n\u0011\"\u0003\u0004\b\"I1Q\u0012\u0001\u0012\u0002\u0013%1q\u0012\u0005\n\u0007'\u0003\u0011\u0013!C\u0005\u0007+C\u0011b!'\u0001#\u0003%Iaa'\t\u0013\r}\u0005!%A\u0005\n\rmeABBQ\u0001\u0011\u0019\u0019\u000b\u0003\u0004Ks\u0011\u000511\u0016\u0005\b\u0005gLD\u0011IBY\u0011\u001d\u00199,\u000fC!\u0007s\u0013A\u0005V5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;peR+7\u000f\u001e\u0006\u0003\u007f\u0001\u000bA\u0001^5fe*\t\u0011)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0019B\u0011Q\nA\u0007\u0002}\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005M\u0003\u0015AB:feZ,'/\u0003\u0002V%\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002#QLWM\u001d+pa&\u001c7i\u001c8tk6,'/F\u0001Z!\tQV,D\u0001\\\u0015\taf(A\u0003u_BL7-\u0003\u0002_7\n\tB+[3s)>\u0004\u0018nY\"p]N,X.\u001a:\u0002%QLWM\u001d+pa&\u001c7i\u001c8tk6,'\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003\t\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a*\u0002\u00115,G/\u00193bi\u0006L!a\u001a3\u0003%-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003A!\u0018.\u001a:U_BL7-T1oC\u001e,'/F\u0001l!\tQF.\u0003\u0002n7\n\u0001B+[3s)>\u0004\u0018nY'b]\u0006<WM]\u0001\u0012i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i\u0002\u000bQ!\u001e;jYNL!A^:\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0003i\u00042a_A\u0005\u001b\u0005a(BA?\u007f\u0003\u0011)H/\u001b7\u000b\u0005M{(bA!\u0002\u0002)!\u00111AA\u0003\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qA\u0001\u0004_J<\u0017bAA\u0006y\niQj\\2l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u00035!\u0018.\u001a:fI>\u0013'.Z2ugV\u0011\u00111\u0003\t\t\u0003+\ty\"a\t\u0002*5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005ua)\u0001\u0006d_2dWm\u0019;j_:LA!!\t\u0002\u0018\t\u0019Q*\u00199\u0011\u00075\u000b)#C\u0002\u0002(y\u0012\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\r\u0005-\u00121HA!\u001d\u0011\ti#a\u000e\u000f\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\rC\u0003\u0019a$o\\8u}%\tq)C\u0002\u0002:\u0019\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002>\u0005}\"\u0001\u0002'jgRT1!!\u000fG!\u0011\t\u0019%a\u0014\u000f\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013?\u0003\u0015\u0019Ho\u001c:f\u0013\u0011\ti%a\u0012\u0002\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016LA!!\u0015\u0002T\tqqJ\u00196fGRlU\r^1eCR\f'\u0002BA'\u0003\u000f\na\u0002^5fe\u0016$wJ\u00196fGR\u001c\b%\u0001\u000feK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001cun\u001c:eS:\fGo\u001c:\u0016\u0005\u0005m\u0003cA'\u0002^%\u0019\u0011q\f \u0003AQKWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN]\u0001!I\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s?\u0012*\u0017\u000f\u0006\u0003\u0002f\u0005-\u0004cA#\u0002h%\u0019\u0011\u0011\u000e$\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003[\n\u0012\u0011!a\u0001\u00037\n1\u0001\u001f\u00132\u0003u!W\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\u0004\u0013a\u00013jeV\u0011\u0011Q\u000f\t\u0005\u0003o\n\t)\u0004\u0002\u0002z)!\u00111PA?\u0003\tIwN\u0003\u0002\u0002\u0000\u0005!!.\u0019<b\u0013\u0011\t\u0019)!\u001f\u0003\t\u0019KG.Z\u0001\u0005I&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u0003I!\u0018.\u001a:U_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005=\u0005\u0003BAI\u0003/k!!a%\u000b\u0007\u0005Uu0\u0001\u0004d_6lwN\\\u0005\u0005\u00033\u000b\u0019J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002'QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002!%t\u0017\u000e^5bY\n\u000b7m[8gM6\u001bXCAAQ!\r)\u00151U\u0005\u0004\u0003K3%\u0001\u0002'p]\u001e\f\u0011#\u001b8ji&\fGNQ1dW>4g-T:!\u0003\u0015\u0019X\r^;q)\t\t)\u0007K\u0002\u001c\u0003_\u0003B!!-\u0002@6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,A\u0002ba&TA!!/\u0002<\u00069!.\u001e9ji\u0016\u0014(\u0002BA_\u0003\u000b\tQA[;oSRLA!!1\u00024\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d3po:D3\u0001HAd!\u0011\t\t,!3\n\t\u0005-\u00171\u0017\u0002\n\u0003\u001a$XM]#bG\"\fA\u0003^3ti&s\u0017\u000e^5bi\u0016$U\r\\3uS>tG\u0003BA3\u0003#Dq!a5\u001e\u0001\u0004\t).A\biCN$\u0016.\u001a:PE*,7\r^$D!\r)\u0015q[\u0005\u0004\u000334%a\u0002\"p_2,\u0017M\u001c\u0015\b;\u0005u\u0017Q^Ax!\u0011\ty.!;\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003O\f9,\u0001\u0004qCJ\fWn]\u0005\u0005\u0003W\f\tOA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\u0005E\u00181_\r\u0002\u0003e\t\u0001\u0001K\u0002\u001e\u0003o\u0004B!!?\u0002|6\u0011\u0011Q]\u0005\u0005\u0003{\f)OA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fA\u0003^3ti\u000e{W\u000e\u001d7fi\u0016$U\r\\3uS>tG\u0003BA3\u0005\u0007Aq!a5\u001f\u0001\u0004\t)\u000eK\u0004\u001f\u0003;\fiOa\u0002-\t\u0005E\u00181\u001f\u0015\u0004=\u0005]\u0018\u0001\u0007;fgR\u0014UmZ5o\u001b\u0006$XM]5bY&T\u0018\r^5p]R!\u0011Q\rB\b\u0011\u001d\t\u0019n\ba\u0001\u0003+DsaHAo\u0003[\u0014\u0019\u0002\f\u0003\u0002r\u0006M\bfA\u0010\u0002x\u0006\u0019B/Z:u\t\u0016dW\r^3QCJ$\u0018\u000e^5p]R!\u0011Q\rB\u000e\u0011\u001d\t\u0019\u000e\ta\u0001\u0003+Ds\u0001IAo\u0003[\u0014y\u0002\f\u0003\u0002r\u0006M\bf\u0001\u0011\u0002x\u0006YB/Z:u\tV\u0004H.[2bi\u0016$U\r\\3uK&s\u0017\u000e^5bi\u0016$B!!\u001a\u0003(!9\u00111[\u0011A\u0002\u0005U\u0007fB\u0011\u0002^\u00065(1\u0006\u0017\u0005\u0003c\f\u0019\u0010K\u0002\"\u0003o\fq\u0006^3ti\u000e{G\u000e\\3di\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oV5uQ>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$B!!\u001a\u00034!9\u00111\u001b\u0012A\u0002\u0005U\u0007f\u0002\u0012\u0002^\u00065(q\u0007\u0017\u0005\u0003c\f\u0019\u0010K\u0002#\u0003o\f\u0001\u0007^3ti\u000e{G\u000e\\3di\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oV5uQ>3g\r\\5oKB\u000b'\u000f^5uS>tG\u0003BA3\u0005\u007fAq!a5$\u0001\u0004\t)\u000eK\u0004$\u0003;\fiOa\u0011-\t\u0005E\u00181\u001f\u0015\u0004G\u0005]\u0018!\f;fgR\u001cu\u000e\u001c7fGR$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn],ji\"tuN\\3QCJ$\u0018\u000e^5p]R!\u0011Q\rB&\u0011\u001d\t\u0019\u000e\na\u0001\u0003+Ds\u0001JAo\u0003[\u0014y\u0005\f\u0003\u0002r\u0006M\bf\u0001\u0013\u0002x\u0006!D/Z:u\u0007>dG.Z2u\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u000b6LwM]1uS>tG)\u001e:j]\u001e\u0014V-\u00193\u0015\t\u0005\u0015$q\u000b\u0005\b\u0003',\u0003\u0019AAkQ\u001d)\u0013Q\\Aw\u00057bC!!=\u0002t\"\u001aQ%a>\u0002'Q,7\u000f\u001e*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u0005\u0015$1\r\u0005\b\u0003'4\u0003\u0019AAkQ\u001d1\u0013Q\\Aw\u0005ObC!!=\u0002t\"\u001aa%a>\u0002)Q,7\u000f^$be\n\fw-Z\"pY2,7\r^8sQ\r9#q\u000e\t\u0005\u0003c\u0013\t(\u0003\u0003\u0003t\u0005M&\u0001\u0002+fgR\f1c\u0019:fCR,W*\u001a;bI\u0006$\u0018-S7bO\u0016$bA!\u001f\u0003\u0006\nU\u0005\u0003\u0002B>\u0005\u0003k!A! \u000b\u0007\t}t0A\u0003j[\u0006<W-\u0003\u0003\u0003\u0004\nu$!D'fi\u0006$\u0017\r^1J[\u0006<W\rC\u0004\u0003\b\"\u0002\rA!#\u0002\u0017Q|\u0007/[2J[\u0006<Wm\u001d\t\u0007\u0003W\u0011YIa$\n\t\t5\u0015q\b\u0002\u0004'\u0016\f\b\u0003\u0002B>\u0005#KAAa%\u0003~\tQAk\u001c9jG&k\u0017mZ3\t\u000f\t]\u0005\u00061\u0001\u0003\u001a\u0006\u0019\u0012.\\1hK>3gm]3u\u0003:$W\t]8dQB!!1\u0014BQ\u001b\t\u0011iJC\u0002\u0003 ~\fAA]1gi&!!1\u0015BO\u00059yeMZ:fi\u0006sG-\u00129pG\"\f1D^3sS\u001aLH)\u001a7fi\u0016\u0004&/Z%oSRL\u0017\r^3DC2dGCBA3\u0005S\u0013i\u000bC\u0004\u0003,&\u0002\r!a\t\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007b\u0002BXS\u0001\u0007!\u0011W\u0001\fi&lWm]\"bY2,G\rE\u0002F\u0005gK1A!.G\u0005\rIe\u000e^\u0001\u0019m\u0016\u0014\u0018NZ=EK2,G/Z%oSRL\u0017\r^3DC2dGCBA3\u0005w\u0013i\fC\u0004\u0003,*\u0002\r!a\t\t\u000f\t=&\u00061\u0001\u00032\u000613M]3bi\u0016$\u0016.\u001a:EK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001cun\u001c:eS:\fGo\u001c:\u0015\t\u0005\u0015$1\u0019\u0005\b\u0005\u000b\\\u0003\u0019AAk\u0003EA\u0017m\u001d+jKJ,Gm\u00142kK\u000e$xiQ\u0001\u0016S:LG/[1uKN+w-\\3oiV\u0003Hn\\1e)1\u0011YMa6\u0003Z\nu'1\u001eBx!\u0011\u0011iMa5\u000e\u0005\t='\u0002\u0002Bi\u0003'\u000baA]3d_J$\u0017\u0002\u0002Bk\u0005\u001f\u0014Q\"T3n_JL(+Z2pe\u0012\u001c\bb\u0002BVY\u0001\u0007\u00111\u0005\u0005\b\u00057d\u0003\u0019\u0001BY\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u000f\t}G\u00061\u0001\u0003b\u0006AqN\u00196fGRLE\r\u0005\u0003\u0003d\n\u001dXB\u0001Bs\u0015\ri\u0018QP\u0005\u0005\u0005S\u0014)O\u0001\u0003V+&#\u0005b\u0002BwY\u0001\u0007\u0011\u0011U\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bb\u0002ByY\u0001\u0007\u0011\u0011U\u0001\nK:$wJ\u001a4tKR\f\u0011$\u001b8ji&\fG/\u001a)beRLG/[8o\t\u0016dW\r^5p]R!!1\u001aB|\u0011\u001d\u0011Y+\fa\u0001\u0003G\t\u0011dY8na2,G/\u001a)beRLG/[8o\t\u0016dW\r^5p]R!!1\u001aB\u007f\u0011\u001d\u0011YK\fa\u0001\u0003G\tQ\"\\3n_JL(+Z2pe\u0012\u001cH\u0003\u0002Bf\u0007\u0007Aa!Z\u0018A\u0002\r\u0015\u0001\u0003BB\u0004\u0007\u001bi!a!\u0003\u000b\u0007\r-a(\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0007\u001f\u0019IA\u0001\u000bBEN$(/Y2u)&,'/T3uC\u0012\fG/Y\u0001\nGJ,\u0017\r^3M_\u001e$Bc!\u0006\u0004\"\r\r2\u0011HB\"\u0007\u000f\u001aYea\u0015\u0004`\r\r\u0004\u0003BB\f\u0007;i!a!\u0007\u000b\u0007\rm\u0001)A\u0002m_\u001eLAaa\b\u0004\u001a\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\t\t\b\ra\u0001\u0003kB\u0011b!\n1!\u0003\u0005\raa\n\u0002\r\r|gNZ5h!\u0011\u0019Ic!\u000e\u000e\u0005\r-\"\u0002BB\u000e\u0007[QAaa\f\u00042\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0007gy\u0018aB:u_J\fw-Z\u0005\u0005\u0007o\u0019YCA\u0005M_\u001e\u001cuN\u001c4jO\"I11\b\u0019\u0011\u0002\u0003\u00071QH\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u00042!UB \u0013\r\u0019\tE\u0015\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biND\u0011b!\u00121!\u0003\u0005\r!!)\u0002\u001d1|wm\u0015;beR|eMZ:fi\"I1\u0011\n\u0019\u0011\u0002\u0003\u0007\u0011\u0011U\u0001\u000ee\u0016\u001cwN^3ssB{\u0017N\u001c;\t\u0011a\u0004\u0004\u0013!a\u0001\u0007\u001b\u00022a_B(\u0013\r\u0019\t\u0006 \u0002\n'\u000eDW\rZ;mKJD\u0001b\u001c\u0019\u0011\u0002\u0003\u00071Q\u000b\t\u0005\u0007/\u001aY&\u0004\u0002\u0004Z)\u0019A/a%\n\t\ru3\u0011\f\u0002\u0005)&lW\rC\u0005\u0004bA\u0002\n\u00111\u0001\u00032\u0006IR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'t\u0011%\u0019)\u0007\rI\u0001\u0002\u0004\u0011\t,A\u0012qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\\"iK\u000e\\\u0017J\u001c;feZ\fG.T:\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r-$\u0006BB\u0014\u0007[Z#aa\u001c\u0011\t\rE41P\u0007\u0003\u0007gRAa!\u001e\u0004x\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007s2\u0015AC1o]>$\u0018\r^5p]&!1QPB:\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0007\u0007SCa!\u0010\u0004n\u0005\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u00111\u0011\u0012\u0016\u0005\u0003C\u001bi'A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$S'A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$c'\u0006\u0002\u0004\u0012*\"1QJB7\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u00199J\u000b\u0003\u0004V\r5\u0014aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012BTCABOU\u0011\u0011\tl!\u001c\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001d\u0003\u00111K7\u000f^3oKJ\u001cB!\u000f#\u0004&B\u0019Qja*\n\u0007\r%fHA\u0010EK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001c\u0005.\u00198hK2K7\u000f^3oKJ$\"a!,\u0011\u0007\r=\u0016(D\u0001\u0001)\u0019\t)ga-\u00046\"9!1V\u001eA\u0002\u0005\r\u0002bBA\bw\u0001\u0007\u0011\u0011F\u0001\u0016gR|\u0007\u000fU1si&$\u0018n\u001c8EK2,G/[8o)\u0011\t)ga/\t\u000f\t-F\b1\u0001\u0002$\u0001")
public class TierDeletedPartitionsCoordinatorTest {
    private final ReplicaManager kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final TierTopicConsumer kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final KRaftMetadataCache metadataCache = new KRaftMetadataCache(0);
    private final TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private final MockTime kafka$tier$TierDeletedPartitionsCoordinatorTest$$time = new MockTime();
    private final MockScheduler kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().scheduler();
    private final scala.collection.mutable.Map<TopicIdPartition, List<TierObjectStore.ObjectMetadata>> tieredObjects = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private TierDeletedPartitionsCoordinator deletedPartitionsCoordinator;
    private final File dir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.dir());
    private final TopicPartition tierTopicPartition;
    private final long initialBackoffMs;

    public ReplicaManager kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager;
    }

    public TierTopicConsumer kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer;
    }

    private KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public MockTime kafka$tier$TierDeletedPartitionsCoordinatorTest$$time() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time;
    }

    public MockScheduler kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler;
    }

    private scala.collection.mutable.Map<TopicIdPartition, List<TierObjectStore.ObjectMetadata>> tieredObjects() {
        return this.tieredObjects;
    }

    private TierDeletedPartitionsCoordinator deletedPartitionsCoordinator() {
        return this.deletedPartitionsCoordinator;
    }

    private void deletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.deletedPartitionsCoordinator = x$1;
    }

    private File dir() {
        return this.dir;
    }

    private File logDir() {
        return this.logDir;
    }

    private TopicPartition tierTopicPartition() {
        return this.tierTopicPartition;
    }

    private long initialBackoffMs() {
        return this.initialBackoffMs;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().liveLogDirs()).thenReturn((Object)new .colon.colon((Object)Paths.get("/tmp/", new String[0]).toFile(), (List)Nil$.MODULE$));
    }

    @AfterEach
    public void teardown() {
        this.dir().delete();
        Mockito.framework().clearInlineMocks();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInitiateDeletion(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-1", UUID.randomUUID(), 0), new TopicIdPartition("foo-2", UUID.randomUUID(), 2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-3", UUID.randomUUID(), 0)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        deletedPartitionsMap.foreach((Function1 & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int tierTopicPartitionId = x0$2._1$mcI$sp();
                ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
            }
            throw new MatchError(null);
        }));
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.deletedPartitionsCoordinator().immigratedPartitions().values().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$5(x$2)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.deletedPartitionsCoordinator().immigratedPartitions().values().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$7(x$3)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(1, new TopicIdPartition("foo", UUID.randomUUID(), 0), 20L);
        Assertions.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                int tierTopicPartitionId = x0$3._1$mcI$sp();
                ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$3._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
            }
            throw new MatchError(null);
        }));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCompleteDeletion(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        TopicIdPartition foo_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition foo_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 2);
        TopicIdPartition foo_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 5);
        LongRef offset = LongRef.create((long)0L);
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_1, foo_2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        deletedPartitionsMap.foreach((Function1 & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$2(this, offset, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.deletedPartitionsCoordinator().immigratedPartitions().values().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$4(x$4)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(0, foo_1);
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(3, foo_3);
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_2})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)0))).pendingDeletions().keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)3))).pendingDeletions().keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)5))).pendingDeletions().keySet());
        Assertions.assertEquals((int)3, (int)immigratedPartitions.size());
        this.deletedPartitionsCoordinator().handleEmigration(0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), (Object)immigratedPartitions.keySet());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBeginMaterialization(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        Tuple2 foo_1 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-1", UUID.randomUUID(), 0));
        Tuple2 foo_2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-2", UUID.randomUUID(), 2));
        Tuple2 foo_3 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-3", UUID.randomUUID(), 2));
        Tuple2 foo_4 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new TopicIdPartition("foo-4", UUID.randomUUID(), 5));
        this.deletedPartitionsCoordinator().handleImmigration(0);
        this.deletedPartitionsCoordinator().handleImmigration(3);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 10L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 20L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_4._1$mcI$sp(), (TopicIdPartition)foo_4._2(), 30L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 31L);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_1._1$mcI$sp()))).inProgressDeletions().contains(foo_1._2()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_2._1$mcI$sp()))).inProgressDeletions().contains(foo_2._2()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_4._1$mcI$sp()))).inProgressDeletions().contains(foo_4._2()));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)immigratedPartitions.values().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$1(x$5)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 32L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 34L);
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)immigratedPartitions.values().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$2(x$6)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        new .colon.colon((Object)((TopicIdPartition)foo_1._2()), (List)new .colon.colon((Object)((TopicIdPartition)foo_2._2()), (List)new .colon.colon((Object)((TopicIdPartition)foo_4._2()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)topicIdPartition -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$3(this, topicIdPartition);
            return BoxedUnit.UNIT;
        });
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).register((Map)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Map<TopicIdPartition, TierTopicConsumer.ClientCtx>>(null, foo_1, foo_2, foo_4){
            private final Tuple2 foo_1$1;
            private final Tuple2 foo_2$1;
            private final Tuple2 foo_4$1;

            public boolean matches(Map<TopicIdPartition, TierTopicConsumer.ClientCtx> argument) {
                Set set = CollectionConverters$.MODULE$.SetHasAsScala(argument.keySet()).asScala();
                Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)this.foo_1$1._2(), (TopicIdPartition)this.foo_2$1._2(), (TopicIdPartition)this.foo_4$1._2()}));
                return !(set != null ? !set.equals(object) : object != null);
            }
            {
                this.foo_1$1 = foo_1$1;
                this.foo_2$1 = foo_2$1;
                this.foo_4$1 = foo_4$1;
            }
        }));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer()});
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_3._1$mcI$sp(), (TopicIdPartition)foo_3._2(), 100L);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).pendingDeletions().keySet());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2());
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).inProgressDeletions().keySet());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeletePartition(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        int tierTopicPartition = 1;
        TopicIdPartition deletedPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        TopicIdPartition deletedPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 0);
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments_1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> TierDeletedPartitionsCoordinatorTest.$anonfun$testDeletePartition$1(deletedPartition_1, BoxesRunTime.unboxToInt((Object)i)));
        this.tieredObjects().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deletedPartition_1), (Object)tieredSegments_1.toList()));
        this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_1, (long)deleteInitiateOffset_1);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_2, (long)deleteInitiateOffset_2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().keySet());
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map inProgressPartitions = ((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions();
        Assertions.assertEquals((int)2, (int)inProgressPartitions.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assertions.assertEquals((Object)new .colon.colon((Object)MaterializingState$.MODULE$, (List)new .colon.colon((Object)MaterializingState$.MODULE$, (List)Nil$.MODULE$)), (Object)inProgressPartitions.values().map((Function1 & Serializable)x$7 -> x$7.currentState()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().isEmpty());
        int numCompacted = 2;
        LongRef offset = LongRef.create((long)0L);
        InProgressDeletion inProgress_1 = (InProgressDeletion)inProgressPartitions.apply((Object)deletedPartition_1);
        ((IterableOnceOps)tieredSegments_1.take(numCompacted)).foreach((Function1 & Serializable)segment -> {
            OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$2.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
            ++offset$2.elem;
            return inProgress_1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100L, 100, false, false, false, TierUploadType.Compaction, stateOffsetAndEpoch, TierObjectStore.OpaqueData.ZEROED), stateOffsetAndEpoch);
        });
        ((IterableOnceOps)tieredSegments_1.drop(numCompacted)).foreach((Function1 & Serializable)segment -> {
            OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$2.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
            ++offset$2.elem;
            return inProgress_1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100L, 100, false, false, false, TierUploadType.Archive, stateOffsetAndEpoch, TierObjectStore.OpaqueData.ZEROED), stateOffsetAndEpoch);
        });
        inProgress_1.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(deletedPartition_1, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.deletedPartitionsCoordinator().maybeBeginDeletion();
        Assertions.assertEquals((Object)AwaitingDeleteComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(tierTopicPartition, deletedPartition_1);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assertions.assertEquals((Object)new .colon.colon((Object)MaterializingState$.MODULE$, (List)Nil$.MODULE$), (Object)inProgressPartitions.values().map((Function1 & Serializable)x$8 -> x$8.currentState()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDuplicateDeleteInitiate(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        int tierTopicPartition = 1;
        TopicIdPartition partition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        int deleteCompleteOffset_1 = 15;
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> TierDeletedPartitionsCoordinatorTest.$anonfun$testDuplicateDeleteInitiate$1(partition, BoxesRunTime.unboxToInt((Object)i)));
        this.tieredObjects().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)tieredSegments.toList()));
        this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, partition, (long)deleteInitiateOffset_2);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        InProgressDeletion inProgress = (InProgressDeletion)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions().apply((Object)partition);
        LongRef offset = LongRef.create((long)0L);
        tieredSegments.foreach((Function1 & Serializable)segment -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testDuplicateDeleteInitiate$2(offset, inProgress, segment);
            return BoxedUnit.UNIT;
        });
        Mockito.reset((Object[])new TierTopicConsumer[]{this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer()});
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), new OffsetAndEpoch((long)deleteCompleteOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.never())).deregister(partition);
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_2, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), new OffsetAndEpoch((long)(deleteInitiateOffset_2 + 1), Optional.of(Predef$.MODULE$.int2Integer(0))));
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).deregister(partition);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithOnlinePartition(boolean hasTierObjectGC) {
        void var9_9;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        AbstractLog log = this.createLog(this.logDir(), this.createLog$default$2(), new BrokerTopicStats(), 0L, 0L, (Scheduler)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), 3600000, 600000);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        int leaderEpoch = 0;
        this.deletedPartitionsCoordinator().handleImmigration(this.tierTopicPartition().partition());
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)new HostedPartition.Online(partition));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 3);
        new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_1, 0, UUID.randomUUID(), 0L, 100L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_1), (List)new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_2, 0, UUID.randomUUID(), 100L, 1000L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_2), (List)new .colon.colon((Object)this.completePartitionDeletion(topicIdPartition_1), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)record -> log.appendAsLeader(record, leaderEpoch, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.updateHighWatermark(log.logEndOffset());
        ByteBuffer buffer = ByteBuffer.allocate(200);
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), 0L, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)log.logEndOffset(), (long)var9_9);
        ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)this.tierTopicPartition().partition()));
        Assertions.assertEquals((Object)new .colon.colon((Object)topicIdPartition_2, (List)Nil$.MODULE$), (Object)immigratedPartition.pendingDeletions().keySet().toList());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithOfflinePartition(boolean hasTierObjectGC) {
        void var5_5;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)HostedPartition.Offline$.MODULE$);
        ByteBuffer buffer = ByteBuffer.allocate(200);
        int startOffset = 0;
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), (long)startOffset, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)var5_5, (long)startOffset);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithNonePartition(boolean hasTierObjectGC) {
        void var5_5;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)HostedPartition.None$.MODULE$);
        ByteBuffer buffer = ByteBuffer.allocate(200);
        int startOffset = 0;
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), (long)startOffset, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)var5_5, (long)startOffset);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithEmigrationDuringRead(boolean hasTierObjectGC) {
        void var9_9;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        AbstractLog log = this.createLog(this.logDir(), this.createLog$default$2(), new BrokerTopicStats(), 0L, 0L, (Scheduler)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), 3600000, 600000);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        int leaderEpoch = 0;
        this.deletedPartitionsCoordinator().handleImmigration(this.tierTopicPartition().partition());
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)new HostedPartition.Online(partition));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 3);
        new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_1, 0, UUID.randomUUID(), 0L, 100L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_1), (List)new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_2, 0, UUID.randomUUID(), 100L, 1000L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_2), (List)new .colon.colon((Object)this.completePartitionDeletion(topicIdPartition_1), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)record -> log.appendAsLeader(record, leaderEpoch, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.updateHighWatermark(log.logEndOffset());
        this.deletedPartitionsCoordinator().handleEmigration(this.tierTopicPartition().partition());
        ByteBuffer buffer = ByteBuffer.allocate(200);
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), 0L, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)var9_9);
        Assertions.assertEquals((int)0, (int)this.deletedPartitionsCoordinator().immigratedPartitions().size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReconfiguration(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        ListBuffer heartbeats = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int initialDelayMs = 100;
        ObjectRef config = ObjectRef.create((Object)new Config(200L, 100, 15000L));
        TierDeletedPartitionsCoordinator coordinator = new TierDeletedPartitionsCoordinator(this, config, heartbeats){
            private final /* synthetic */ TierDeletedPartitionsCoordinatorTest $outer;
            private final ListBuffer heartbeats$1;

            public void heartbeat() {
                super.heartbeat();
                this.heartbeats$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.heartbeats$1 = heartbeats$1;
                super((Scheduler)$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), $outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager(), $outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), ((Config)config$1.elem).intervalMs(), ((Config)config$1.elem).maxInprogressPartitions(), ((Config)config$1.elem).deleteBackoffMs(), "foo", (Time)$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), (Option)None$.MODULE$);
            }
        };
        coordinator.startup();
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(initialDelayMs);
        Assertions.assertEquals((int)1, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs());
        Assertions.assertEquals((int)2, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L);
        Assertions.assertEquals((int)2, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L + 1L);
        Assertions.assertEquals((int)3, (int)heartbeats.size());
        config.elem = new Config(10L, 100, 15000L);
        coordinator.reconfigure((Config)config.elem);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(1L);
        Assertions.assertEquals((int)4, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs());
        Assertions.assertEquals((int)5, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L);
        Assertions.assertEquals((int)5, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L + 1L);
        Assertions.assertEquals((int)6, (int)heartbeats.size());
        coordinator.shutdown();
    }

    @Test
    public void testGarbageCollector() {
        this.createTierDeletedPartitionsCoordinator(true);
        .colon.colon topicPartitions = new .colon.colon((Object)new TopicIdPartition("foo-1", UUID.randomUUID(), 0), (List)new .colon.colon((Object)new TopicIdPartition("foo-2", UUID.randomUUID(), 2), (List)new .colon.colon((Object)new TopicIdPartition("foo-3", UUID.randomUUID(), 0), (List)Nil$.MODULE$)));
        this.deletedPartitionsCoordinator().handleImmigration(0);
        this.deletedPartitionsCoordinator().trackInitLeader(0, (TopicIdPartition)topicPartitions.apply(0), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.deletedPartitionsCoordinator().handleImmigration(1);
        this.deletedPartitionsCoordinator().trackInitLeader(1, (TopicIdPartition)topicPartitions.apply(1), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.deletedPartitionsCoordinator().handleImmigration(2);
        this.deletedPartitionsCoordinator().trackInitLeader(2, (TopicIdPartition)topicPartitions.apply(2), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        TopicImage topicImage1 = new TopicImage(((TopicIdPartition)topicPartitions.apply(0)).topic(), new Uuid(((TopicIdPartition)topicPartitions.apply(0)).topicId().getMostSignificantBits(), ((TopicIdPartition)topicPartitions.apply(0)).topicId().getLeastSignificantBits()), null, null);
        this.metadataCache().setImage(this.createMetadataImage((Seq<TopicImage>)new .colon.colon((Object)topicImage1, (List)Nil$.MODULE$), new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.deletedPartitionsCoordinator().runGarbageCollectorTasks();
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
        this.deletedPartitionsCoordinator().trackPreInitiatePartitionDelete(1, (TopicIdPartition)topicPartitions.apply(1), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds());
        this.deletedPartitionsCoordinator().trackPreInitiatePartitionDelete(2, (TopicIdPartition)topicPartitions.apply(2), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds());
        this.deletedPartitionsCoordinator().trackInitLeader(1, (TopicIdPartition)topicPartitions.apply(1), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.deletedPartitionsCoordinator().trackInitLeader(2, (TopicIdPartition)topicPartitions.apply(2), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(this.initialBackoffMs() - 5L);
        this.deletedPartitionsCoordinator().runGarbageCollectorTasks();
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(1), 0);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(2), 0);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(this.initialBackoffMs());
        this.deletedPartitionsCoordinator().runGarbageCollectorTasks();
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
    }

    private MetadataImage createMetadataImage(Seq<TopicImage> topicImages, org.apache.kafka.raft.OffsetAndEpoch imageOffsetAndEpoch) {
        ObjectRef image = ObjectRef.create((Object)TopicsImage.EMPTY);
        topicImages.foreach((Function1 & Serializable)t -> {
            image.elem = ((TopicsImage)image.elem).including(t, TenantHelpers.NAME_TO_NULL_CALLBACK);
            return BoxedUnit.UNIT;
        });
        return new MetadataImage(new MetadataProvenance(imageOffsetAndEpoch.offset(), imageOffsetAndEpoch.epoch(), 0L), FeaturesImage.EMPTY, ClusterImage.EMPTY, (TopicsImage)image.elem, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
    }

    private void verifyDeletePreInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeletePreInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$2;

            public boolean matches(TierPartitionDeletePreInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$2;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$2 = topicIdPartition$2;
            }
        }));
    }

    private void verifyDeleteInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeleteInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$3;

            public boolean matches(TierPartitionDeleteInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$3;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$3 = topicIdPartition$3;
            }
        }));
    }

    private void createTierDeletedPartitionsCoordinator(boolean hasTieredObjectGC) {
        None$ tieredObjectGC = hasTieredObjectGC ? new Some((Function0 & Serializable)() -> new TierObjectGarbageCollector(this.tierTopicManager(), this.metadataCache(), (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time())) : None$.MODULE$;
        this.deletedPartitionsCoordinator_$eq(new TierDeletedPartitionsCoordinator((Scheduler)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager(), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), 1L, 100, this.initialBackoffMs(), "foo", (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), (Option)tieredObjectGC));
        this.deletedPartitionsCoordinator().registerListener((DeletedPartitionsChangeListener)new Listener());
    }

    private MemoryRecords initiateSegmentUpload(TopicIdPartition topicIdPartition, int leaderEpoch, UUID objectId, long baseOffset, long endOffset) {
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, objectId, baseOffset, endOffset, 10L, 100L, 500, true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), TierObjectStore.OpaqueData.ZEROED);
        return this.memoryRecords((AbstractTierMetadata)uploadInitiate);
    }

    private MemoryRecords initiatePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteInitiate(topicIdPartition, 0, UUID.randomUUID()));
    }

    private MemoryRecords completePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteComplete(topicIdPartition, UUID.randomUUID()));
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords memoryRecords(AbstractTierMetadata metadata) {
        void withRecords_records;
        void withRecords_compressionType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(0L, metadata.serializeKey(), metadata.serializeValue())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        return MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    private AbstractLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, long logStartOffset, long recoveryPoint, Scheduler scheduler, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs) {
        ProducerStateManagerConfig x$8 = new ProducerStateManagerConfig(maxProducerIdExpirationMs);
        int x$10 = 300000;
        TierLogComponents x$11 = TierLogComponents$.MODULE$.EMPTY();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        LogOffsetsListener x$13 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$14 = true;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = true;
        ConcurrentHashMap<String, Object> x$17 = new ConcurrentHashMap<String, Object>();
        return LogTestUtils$.MODULE$.createLog(dir, config, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, x$10, x$8, producerIdExpirationCheckIntervalMs, x$11, x$12, x$13, x$14, (Option<Uuid>)x$15, x$16, x$17);
    }

    private LogConfig createLog$default$2() {
        return LogTestUtils$.MODULE$.createLogConfig(604800000L, 0x40000000, 604800000L, -1L, 0L, "delete", 0x10000C, 4096, 0xA00000, LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION, 60000L, false, -1L, 86400000L, 0x6400000, -1L, true, 1L);
    }

    private BrokerTopicStats createLog$default$3() {
        return new BrokerTopicStats();
    }

    private long createLog$default$4() {
        return 0L;
    }

    private long createLog$default$5() {
        return 0L;
    }

    private Scheduler createLog$default$6() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler();
    }

    private Time createLog$default$7() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time();
    }

    private int createLog$default$8() {
        return 3600000;
    }

    private int createLog$default$9() {
        return 600000;
    }

    public static final /* synthetic */ void $anonfun$testInitiateDeletion$3(TierDeletedPartitionsCoordinatorTest $this, int tierTopicPartitionId$1, TopicIdPartition deletedPartition) {
        $this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartitionId$1, deletedPartition, 10L);
    }

    public static final /* synthetic */ void $anonfun$testInitiateDeletion$2(TierDeletedPartitionsCoordinatorTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ((scala.collection.immutable.Set)x0$1._2()).foreach((Function1 & Serializable)deletedPartition -> {
                TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$3($this, tierTopicPartitionId, deletedPartition);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$testInitiateDeletion$5(ImmigratedTierTopicPartition x$2) {
        return x$2.pendingDeletions().size();
    }

    public static final /* synthetic */ long $anonfun$testInitiateDeletion$7(ImmigratedTierTopicPartition x$3) {
        return x$3.pendingDeletions().size();
    }

    public static final /* synthetic */ void $anonfun$testCompleteDeletion$3(TierDeletedPartitionsCoordinatorTest $this, int tierTopicPartitionId$2, LongRef offset$1, TopicIdPartition deletedPartition) {
        $this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartitionId$2, deletedPartition, offset$1.elem);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testCompleteDeletion$2(TierDeletedPartitionsCoordinatorTest $this, LongRef offset$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ((scala.collection.immutable.Set)x0$1._2()).foreach((Function1 & Serializable)deletedPartition -> {
                TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$3($this, tierTopicPartitionId, offset$1, deletedPartition);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$testCompleteDeletion$4(ImmigratedTierTopicPartition x$4) {
        return x$4.pendingDeletions().size();
    }

    public static final /* synthetic */ int $anonfun$testBeginMaterialization$1(ImmigratedTierTopicPartition x$5) {
        return x$5.pendingDeletions().size();
    }

    public static final /* synthetic */ int $anonfun$testBeginMaterialization$2(ImmigratedTierTopicPartition x$6) {
        return x$6.pendingDeletions().size();
    }

    public static final /* synthetic */ void $anonfun$testBeginMaterialization$3(TierDeletedPartitionsCoordinatorTest $this, TopicIdPartition topicIdPartition) {
        ((TierTopicConsumer)Mockito.verify((Object)$this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).deregister((TopicIdPartition)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TopicIdPartition>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$1;

            public boolean matches(TopicIdPartition argument) {
                TopicIdPartition topicIdPartition = argument;
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$1;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
            }
        }));
    }

    public static final /* synthetic */ TierObjectStore.ObjectMetadata $anonfun$testDeletePartition$1(TopicIdPartition deletedPartition_1$1, int i) {
        return new TierObjectStore.ObjectMetadata(deletedPartition_1$1, UUID.randomUUID(), 0, (long)i, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    }

    public static final /* synthetic */ TierObjectStore.ObjectMetadata $anonfun$testDuplicateDeleteInitiate$1(TopicIdPartition partition$1, int i) {
        return new TierObjectStore.ObjectMetadata(partition$1, UUID.randomUUID(), 0, (long)i, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    }

    public static final /* synthetic */ void $anonfun$testDuplicateDeleteInitiate$2(LongRef offset$3, InProgressDeletion inProgress$1, TierObjectStore.ObjectMetadata segment) {
        OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$3.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
        inProgress$1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100L, 100, false, false, false, TierUploadType.Archive, stateOffsetAndEpoch, TierObjectStore.OpaqueData.ZEROED), stateOffsetAndEpoch);
        ++offset$3.elem;
    }

    public TierDeletedPartitionsCoordinatorTest() {
        File parseTopicPartitionName_dir = this.logDir();
        this.tierTopicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.initialBackoffMs = 10L;
    }

    private class Listener
    implements DeletedPartitionsChangeListener {
        public void initiatePartitionDeletion(TopicIdPartition topicIdPartition, List<TierObjectStore.ObjectMetadata> tieredObjects) {
        }

        public void stopPartitionDeletion(TopicIdPartition topicIdPartition) {
        }

        public /* synthetic */ TierDeletedPartitionsCoordinatorTest kafka$tier$TierDeletedPartitionsCoordinatorTest$Listener$$$outer() {
            return TierDeletedPartitionsCoordinatorTest.this;
        }

        public Listener() {
            if (TierDeletedPartitionsCoordinatorTest.this == null) {
                throw null;
            }
        }
    }
}

