/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.server.ReplicaManager;
import kafka.tier.TierCompactionIntegrationTest$;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompactionTasksConfig;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.TierTasks;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierLogCleanerManager;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rmg\u0001\u0002%J\u00019CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001C\u0002\u0013%!\f\u0003\u0004b\u0001\u0001\u0006Ia\u0017\u0005\bE\u0002\u0011\r\u0011\"\u0001d\u0011\u0019\u0011\b\u0001)A\u0005I\"91\u000f\u0001b\u0001\n\u0003!\bBB>\u0001A\u0003%Q\u000fC\u0005}\u0001\u0001\u0007\t\u0019!C\u0001{\"Y\u00111\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0003\u0011)\t\t\u0002\u0001a\u0001\u0002\u0003\u0006KA \u0005\f\u0003'\u0001\u0001\u0019!a\u0001\n\u0003\t)\u0002C\u0006\u0002$\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0002bCA\u0015\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/A1\"a\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002.!Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011AA\u001f\u0011-\t\t\u0005\u0001a\u0001\u0002\u0003\u0006K!a\f\t\u0013\u0005\r\u0003A1A\u0005\u0002\u0005\u0015\u0003\u0002CA'\u0001\u0001\u0006I!a\u0012\t\u0013\u0005=\u0003A1A\u0005\u0002\u0005E\u0003\u0002CA0\u0001\u0001\u0006I!a\u0015\t\u0013\u0005\u0005\u0004A1A\u0005\u0002\u0005\r\u0004\u0002CA6\u0001\u0001\u0006I!!\u001a\t\u0017\u00055\u0004\u00011AA\u0002\u0013\u0005\u0011q\u000e\u0005\f\u0003o\u0002\u0001\u0019!a\u0001\n\u0003\tI\bC\u0006\u0002~\u0001\u0001\r\u0011!Q!\n\u0005E\u0004bCA@\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0003C1\"a$\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0012\"Y\u0011Q\u0013\u0001A\u0002\u0003\u0005\u000b\u0015BAB\u0011-\t9\n\u0001a\u0001\u0002\u0004%\t!!'\t\u0017\u0005\u001d\u0006\u00011AA\u0002\u0013\u0005\u0011\u0011\u0016\u0005\f\u0003[\u0003\u0001\u0019!A!B\u0013\tY\nC\u0005\u00020\u0002\u0001\r\u0011\"\u0001\u00022\"I\u0011\u0011\u0018\u0001A\u0002\u0013\u0005\u00111\u0018\u0005\t\u0003\u007f\u0003\u0001\u0015)\u0003\u00024\"I\u0011\u0011\u0019\u0001A\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003#\u0004\u0001\u0019!C\u0001\u0003'D\u0001\"a6\u0001A\u0003&\u0011Q\u0019\u0005\f\u00033\u0004\u0001\u0019!a\u0001\n\u0003\tY\u000eC\u0006\u0002|\u0002\u0001\r\u00111A\u0005\u0002\u0005u\bb\u0003B\u0001\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;D1Ba\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u0006!Y!Q\u0002\u0001A\u0002\u0003\u0007I\u0011\u0001B\b\u0011-\u0011\u0019\u0002\u0001a\u0001\u0002\u0003\u0006KAa\u0002\t\u0017\tU\u0001\u00011AA\u0002\u0013\u0005!q\u0003\u0005\f\u0005c\u0001\u0001\u0019!a\u0001\n\u0003\u0011\u0019\u0004C\u0006\u00038\u0001\u0001\r\u0011!Q!\n\te\u0001\"\u0003B\u001d\u0001\t\u0007I\u0011AA#\u0011!\u0011Y\u0004\u0001Q\u0001\n\u0005\u001d\u0003\"\u0003B\u001f\u0001\t\u0007I\u0011\u0001B \u0011!\u00119\u0005\u0001Q\u0001\n\t\u0005\u0003b\u0002B%\u0001\u0011\u0005!1\n\u0005\n\u00057\u0002\u0011\u0013!C\u0001\u0005;B\u0011Ba\u001d\u0001#\u0003%\tA!\u0018\t\u000f\tU\u0004\u0001\"\u0001\u0003x!9!1\u0013\u0001\u0005\u0002\t]\u0004b\u0002BO\u0001\u0011\u0005!q\u000f\u0005\b\u0005O\u0003A\u0011\u0001B<\u0011\u001d\u0011I\f\u0001C\u0001\u0005oBqA!0\u0001\t\u0003\u00119\bC\u0004\u0003B\u0002!IAa1\t\u0013\te\u0007!%A\u0005\n\tm\u0007b\u0002Bp\u0001\u0011%!\u0011\u001d\u0005\b\u0007\u0003\u0001A\u0011BB\u0002\u0011\u001d\u0019)\u0002\u0001C\u0005\u0005oBqaa\u0006\u0001\t\u0013\u0019I\u0002C\u0004\u0004F\u0001!Iaa\u0012\t\u000f\r-\u0003\u0001\"\u0003\u0004N!91Q\r\u0001\u0005\n\r\u001d\u0004bBBG\u0001\u0011%1q\u0012\u0005\b\u0007C\u0003A\u0011BBR\u0011\u001d\u0019I\u000e\u0001C\u0005\u0005o\u0012Q\u0004V5fe\u000e{W\u000e]1di&|g.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0015.\u000bA\u0001^5fe*\tA*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0005C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002/B\u0011\u0001\fA\u0007\u0002\u0013\u0006AQn\\2l)&lW-F\u0001\\!\tav,D\u0001^\u0015\tq6*A\u0003vi&d7/\u0003\u0002a;\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u00059An\\4ESJ\u001cX#\u00013\u0011\u0007\u0015TG.D\u0001g\u0015\t9\u0007.\u0001\u0003vi&d'\"A5\u0002\t)\fg/Y\u0005\u0003W\u001a\u0014\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\u00055\u0004X\"\u00018\u000b\u0005=D\u0017\u0001\u00027b]\u001eL!!\u001d8\u0003\rM#(/\u001b8h\u0003!awn\u001a#jeN\u0004\u0013A\u0006;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0003U\u0004\"A^=\u000e\u0003]T!\u0001_%\u0002\u000bQ|\u0007/[2\n\u0005i<(A\u0006+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002/QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e\u0004\u0013!\u0005;jKJ$v\u000e]5d\u0007>t7/^7feV\ta\u0010\u0005\u0002w\u007f&\u0019\u0011\u0011A<\u0003#QKWM\u001d+pa&\u001c7i\u001c8tk6,'/A\u000buS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004!\u0006%\u0011bAA\u0006#\n!QK\\5u\u0011!\ty!CA\u0001\u0002\u0004q\u0018a\u0001=%c\u0005\u0011B/[3s)>\u0004\u0018nY\"p]N,X.\u001a:!\u0003E!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u000b\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;Y\u0015a\u00017pO&!\u0011\u0011EA\u000e\u0005E!\u0016.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u0001\u0016i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001cx\fJ3r)\u0011\t9!a\n\t\u0013\u0005=A\"!AA\u0002\u0005]\u0011A\u0005;jKJdunZ\"p[B|g.\u001a8ug\u0002\nq\u0001^3na\u0012K'/\u0006\u0002\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026!\f!![8\n\t\u0005e\u00121\u0007\u0002\u0005\r&dW-A\u0006uK6\u0004H)\u001b:`I\u0015\fH\u0003BA\u0004\u0003\u007fA\u0011\"a\u0004\u0010\u0003\u0003\u0005\r!a\f\u0002\u0011Q,W\u000e\u001d#je\u0002\n!B\\;n)\"\u0014X-\u00193t+\t\t9\u0005E\u0002Q\u0003\u0013J1!a\u0013R\u0005\rIe\u000e^\u0001\f]VlG\u000b\u001b:fC\u0012\u001c\b%\u0001\ruS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8UCN\\7i\u001c8gS\u001e,\"!a\u0015\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017J\u0003\u0015!\u0018m]6t\u0013\u0011\ti&a\u0016\u0003+\r{W\u000e]1di&|g\u000eV1tWN\u001cuN\u001c4jO\u0006IB/[3s\u0007>l\u0007/Y2uS>tG+Y:l\u0007>tg-[4!\u0003=!\u0018.\u001a:UCN\\7oQ8oM&<WCAA3!\u0011\t)&a\u001a\n\t\u0005%\u0014q\u000b\u0002\u0010)&,'\u000fV1tWN\u001cuN\u001c4jO\u0006\u0001B/[3s)\u0006\u001c8n]\"p]\u001aLw\rI\u0001\ni&,'\u000fV1tWN,\"!!\u001d\u0011\t\u0005U\u00131O\u0005\u0005\u0003k\n9FA\u0005US\u0016\u0014H+Y:lg\u0006iA/[3s)\u0006\u001c8n]0%KF$B!a\u0002\u0002|!I\u0011q\u0002\r\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u000bi&,'\u000fV1tWN\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013[\u0015AB:feZ,'/\u0003\u0003\u0002\u000e\u0006\u001d%A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0005M\u0005\"CA\b7\u0005\u0005\t\u0019AAB\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013a\u0004;jKJ|%M[3diN#xN]3\u0016\u0005\u0005m\u0005\u0003BAO\u0003Gk!!a(\u000b\u0007\u0005\u0005\u0016*A\u0003ti>\u0014X-\u0003\u0003\u0002&\u0006}%aG'pG.Le.T3n_JLH+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\nuS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0005-\u0006\"CA\b=\u0005\u0005\t\u0019AAN\u0003A!\u0018.\u001a:PE*,7\r^*u_J,\u0007%\u0001\u0011uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014XCAAZ!\rA\u0016QW\u0005\u0004\u0003oK%\u0001\t+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\fA\u0005^5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;pe~#S-\u001d\u000b\u0005\u0003\u000f\ti\fC\u0005\u0002\u0010\u0005\n\t\u00111\u0001\u00024\u0006\tC/[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8sA\u0005\u0001B/[3s'R\fG/\u001a$fi\u000eDWM]\u000b\u0003\u0003\u000b\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017L\u0015a\u00024fi\u000eDWM]\u0005\u0005\u0003\u001f\fIM\u0001\tUS\u0016\u00148\u000b^1uK\u001a+Go\u00195fe\u0006!B/[3s'R\fG/\u001a$fi\u000eDWM]0%KF$B!a\u0002\u0002V\"I\u0011q\u0002\u0013\u0002\u0002\u0003\u0007\u0011QY\u0001\u0012i&,'o\u0015;bi\u00164U\r^2iKJ\u0004\u0013\u0001\u00027pON,\"!!8\u0011\r\u0005}\u0017q^A{\u001d\u0011\t\t/a;\u000f\t\u0005\r\u0018\u0011^\u0007\u0003\u0003KT1!a:N\u0003\u0019a$o\\8u}%\t!+C\u0002\u0002nF\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002r\u0006M(aA*fc*\u0019\u0011Q^)\u0011\t\u0005e\u0011q_\u0005\u0005\u0003s\fYBA\u0005NKJ<W\r\u001a'pO\u0006AAn\\4t?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0005}\b\"CA\bO\u0005\u0005\t\u0019AAo\u0003\u0015awnZ:!\u0003A!\u0018.\u001a:U_BL7-T1oC\u001e,'/\u0006\u0002\u0003\bA\u0019aO!\u0003\n\u0007\t-qO\u0001\tUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u0006!B/[3s)>\u0004\u0018nY'b]\u0006<WM]0%KF$B!a\u0002\u0003\u0012!I\u0011q\u0002\u0016\u0002\u0002\u0003\u0007!qA\u0001\u0012i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u0004\u0013\u0001E2p]N,X.\u001a:TkB\u0004H.[3s+\t\u0011I\u0002\u0005\u0005\u0003\u001c\t\u0005\"Q\u0005B\u0013\u001b\t\u0011iBC\u0002\u0003 %\u000baa\u00197jK:$\u0018\u0002\u0002B\u0012\u0005;\u0011A#T8dW\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b#\u0002)\u0003(\t-\u0012b\u0001B\u0015#\n)\u0011I\u001d:bsB\u0019\u0001K!\f\n\u0007\t=\u0012K\u0001\u0003CsR,\u0017\u0001F2p]N,X.\u001a:TkB\u0004H.[3s?\u0012*\u0017\u000f\u0006\u0003\u0002\b\tU\u0002\"CA\b[\u0005\u0005\t\u0019\u0001B\r\u0003E\u0019wN\\:v[\u0016\u00148+\u001e9qY&,'\u000fI\u0001\u000e[\u0006Dx+Y5u)&lW-T:\u0002\u001d5\f\u0007pV1jiRKW.Z'tA\u0005\u0011B/[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\u0011\t\u0005E\u0002Y\u0005\u0007J1A!\u0012J\u0005I!\u0016.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\u0002'QLWM\u001d*fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\r\u0005\u001d!Q\nB,\u0011%\u0011ye\rI\u0001\u0002\u0004\u0011\t&\u0001\bok6\u001cu.\u001c9bGRdunZ:\u0011\u00075\u0014\u0019&C\u0002\u0003V9\u0014q!\u00138uK\u001e,'\u000fC\u0005\u0003ZM\u0002\n\u00111\u0001\u0003R\u0005ia.^7EK2,G/\u001a'pON\fqb]3ukB$C-\u001a4bk2$H%M\u000b\u0003\u0005?RCA!\u0015\u0003b-\u0012!1\r\t\u0005\u0005K\u0012y'\u0004\u0002\u0003h)!!\u0011\u000eB6\u0003%)hn\u00195fG.,GMC\u0002\u0003nE\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tHa\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\btKR,\b\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003\u0019\u0011WMZ8sKR\u0011\u0011q\u0001\u0015\u0004m\tm\u0004\u0003\u0002B?\u0005\u001fk!Aa \u000b\t\t\u0005%1Q\u0001\u0004CBL'\u0002\u0002BC\u0005\u000f\u000bqA[;qSR,'O\u0003\u0003\u0003\n\n-\u0015!\u00026v]&$(B\u0001BG\u0003\ry'oZ\u0005\u0005\u0005#\u0013yH\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004o\t]\u0005\u0003\u0002B?\u00053KAAa'\u0003\u0000\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0018i\u0016\u001cHoQ8na\u0006\u001cG/[8o\u00136l\u0017n\u001a:bi\u0016D3\u0001\u000fBQ!\u0011\u0011iHa)\n\t\t\u0015&q\u0010\u0002\u0005)\u0016\u001cH/A\u0012uKN$8i\\7qC\u000e$\u0018I\u001c3EK2,G/Z\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017.Z:)\u0007e\u0012\t\u000bK\u0004:\u0005[\u0013\u0019L!.\u0011\t\tu$qV\u0005\u0005\u0005c\u0013yH\u0001\u0005ESN\f'\r\\3e\u0003\u00151\u0018\r\\;fC\t\u00119,A\u0007L'R{%+Q$F[I\u0002\u0004\u0007M\u0001\u0013i\u0016\u001cH\u000fV5fe\u0006sGmQ8na\u0006\u001cG\u000fK\u0002;\u0005C\u000b\u0011\u0004^3tiRKWM\u001d+bg.\u001c8i\u001c8gS\u001e,\u0006\u000fZ1uK\"\u001a1H!)\u0002%]\f\u0017\u000e\u001e$pe&kW.[4sCRLwN\u001c\u000b\r\u0003\u000f\u0011)Ma2\u0003L\n5'q\u001a\u0005\b\u00033d\u0004\u0019AAo\u0011\u001d\u0011I\r\u0010a\u0001\u0003\u000f\n1\u0002\\3bI\u0016\u0014X\t]8dQ\"9\u0011Q\u000e\u001fA\u0002\u0005E\u0004b\u0002B\u000by\u0001\u0007!\u0011\u0004\u0005\n\u0005#d\u0004\u0013!a\u0001\u0005'\fABY3d_6,G*Z1eKJ\u00042\u0001\u0015Bk\u0013\r\u00119.\u0015\u0002\b\u0005>|G.Z1o\u0003q9\u0018-\u001b;G_JLU.\\5he\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uIU*\"A!8+\t\tM'\u0011M\u0001\u0015[\u0006$XM]5bY&TX-\u00168uS2$&/^3\u0015\u0011\u0005\u001d!1\u001dBw\u0005\u007fDqA!:?\u0001\u0004\u00119/\u0001\u0003qe\u0016$\u0007#\u0002)\u0003j\nM\u0017b\u0001Bv#\nIa)\u001e8di&|g\u000e\r\u0005\b\u0005_t\u0004\u0019\u0001By\u0003\ri7o\u001a\t\u0005\u0005g\u0014YP\u0004\u0003\u0003v\n]\bcAAr#&\u0019!\u0011`)\u0002\rA\u0013X\rZ3g\u0013\r\t(Q \u0006\u0004\u0005s\f\u0006b\u0002B\u000b}\u0001\u0007!\u0011D\u0001-m\u0006d\u0017\u000eZ1uKB\u000b'\u000f^5uS>t7\u000b^1uK\u000e{g\u000e^1j]\u0016$\u0017J\\(cU\u0016\u001cGo\u0015;pe\u0016$b!a\u0002\u0004\u0006\r\u001d\u0001bBAL\u007f\u0001\u0007\u00111\u0014\u0005\b\u00033|\u0004\u0019AB\u0005!\u0019\tyna\u0003\u0004\u0010%!1QBAz\u0005!IE/\u001a:bE2,\u0007\u0003BA\r\u0007#IAaa\u0005\u0002\u001c\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0003M\u0019X\r^;q)&,'oQ8na>tWM\u001c;t\u0003)\u0019'/Z1uK2{wm\u001d\u000b\r\u00077\u0019\tca\t\u0004&\r\u001d2\u0011\u0006\t\u0007\u0003?\u001ci\"!>\n\t\r}\u00111\u001f\u0002\u000b\u0013:$W\r_3e'\u0016\f\bb\u0002B(\u0003\u0002\u0007\u0011q\t\u0005\b\u00053\n\u0005\u0019AA$\u0011\u001d\tY#\u0011a\u0001\u0003_Aq!a\u0005B\u0001\u0004\t9\u0002C\u0004\u0004,\u0005\u0003\ra!\f\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\u0011\u0019yc!\u0011\u000e\u0005\rE\"\u0002BA\u000f\u0007gQAa!\u000e\u00048\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0007s\u0019Y$A\u0004ti>\u0014\u0018mZ3\u000b\u00071\u001biD\u0003\u0003\u0004@\t-\u0015AB1qC\u000eDW-\u0003\u0003\u0004D\rE\"\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0001\nn_\u000e\\'+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014H\u0003BAB\u0007\u0013Bq!!7C\u0001\u0004\u0019I!\u0001\nxe&$XMU3d_J$')\u0019;dQ\u0016\u001cH\u0003DA\u0004\u0007\u001f\u001a\tfa\u0015\u0004^\r\u0005\u0004bBA\u000f\u0007\u0002\u00071q\u0002\u0005\b\u0005\u0013\u001c\u0005\u0019AA$\u0011\u001d\u0019)f\u0011a\u0001\u0007/\n!BY1tK>3gm]3u!\r\u00016\u0011L\u0005\u0004\u00077\n&\u0001\u0002'p]\u001eDqaa\u0018D\u0001\u0004\t9%A\u0004cCR\u001c\u0007.Z:\t\u000f\r\r4\t1\u0001\u0002H\u0005y!/Z2pe\u0012\u001c\b+\u001a:CCR\u001c\u0007.A\u0007de\u0016\fG/\u001a*fG>\u0014Hm\u001d\u000b\u000b\u0007S\u001aIh!\"\u0004\b\u000e%\u0005\u0003BB6\u0007kj!a!\u001c\u000b\t\r=4\u0011O\u0001\u0007e\u0016\u001cwN\u001d3\u000b\t\rM41H\u0001\u0007G>lWn\u001c8\n\t\r]4Q\u000e\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\rmD\t1\u0001\u0004~\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BB@\u0007\u0003k!a!\u001d\n\t\r\r5\u0011\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\u0011I\r\u0012a\u0001\u0003\u000fBqa!\u0016E\u0001\u0004\u00199\u0006C\u0004\u0004\f\u0012\u0003\r!a\u0012\u0002\u00159,XNU3d_J$7/\u0001\nuS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G\u0003BBI\u0007;\u0003Baa%\u0004\u001a6\u00111Q\u0013\u0006\u0004\u0007/K\u0015!B:uCR,\u0017\u0002BBN\u0007+\u0013!\u0003V5feB\u000b'\u000f^5uS>t7\u000b^1uK\"91qT#A\u0002\ru\u0014!\u00039beRLG/[8o\u0003!9W\r^$bk\u001e,W\u0003BBS\u0007\u0007$Baa*\u0004VB11\u0011VB^\u0007\u007fk!aa+\u000b\t\r56qV\u0001\u0005G>\u0014XM\u0003\u0003\u00042\u000eM\u0016aB7fiJL7m\u001d\u0006\u0005\u0007k\u001b9,\u0001\u0004zC6lWM\u001d\u0006\u0003\u0007s\u000b1aY8n\u0013\u0011\u0019ila+\u0003\u000b\u001d\u000bWoZ3\u0011\t\r\u000571\u0019\u0007\u0001\t\u001d\u0019)M\u0012b\u0001\u0007\u000f\u0014\u0011\u0001V\t\u0005\u0007\u0013\u001cy\rE\u0002Q\u0007\u0017L1a!4R\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001UBi\u0013\r\u0019\u0019.\u0015\u0002\u0004\u0003:L\bbBBl\r\u0002\u0007!\u0011_\u0001\u0005]\u0006lW-A\u0007wKJLg-_'fiJL7m\u001d")
public class TierCompactionIntegrationTest {
    private final MockTime mockTime = new MockTime();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(TestUtils.tempDirectory(null, null).getAbsolutePath()));
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), null, 1, 1, 33, "cluster99", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()));
    private TierTopicConsumer tierTopicConsumer;
    private TierLogComponents tierLogComponents;
    private File tempDir;
    private final int numThreads;
    private final CompactionTasksConfig tierCompactionTaskConfig = new CompactionTasksConfig(120, 0.9, 524288, 0x100000, Double.MAX_VALUE, 300, 0, 0x40000000L);
    private final TierTasksConfig tierTasksConfig;
    private TierTasks tierTasks;
    private ReplicaManager replicaManager;
    private MockInMemoryTierObjectStore tierObjectStore;
    private TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator;
    private TierStateFetcher tierStateFetcher;
    private Seq<MergedLog> logs;
    private TierTopicManager tierTopicManager;
    private MockConsumerSupplier<byte[], byte[]> consumerSupplier;
    private final int maxWaitTimeMs;
    private final TierReplicaManager tierReplicaManager;

    private MockTime mockTime() {
        return this.mockTime;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public void tierTopicConsumer_$eq(TierTopicConsumer x$1) {
        this.tierTopicConsumer = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public void tierLogComponents_$eq(TierLogComponents x$1) {
        this.tierLogComponents = x$1;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public int numThreads() {
        return this.numThreads;
    }

    public CompactionTasksConfig tierCompactionTaskConfig() {
        return this.tierCompactionTaskConfig;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public TierTasks tierTasks() {
        return this.tierTasks;
    }

    public void tierTasks_$eq(TierTasks x$1) {
        this.tierTasks = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(MockInMemoryTierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator() {
        return this.tierDeletedPartitionsCoordinator;
    }

    public void tierDeletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.tierDeletedPartitionsCoordinator = x$1;
    }

    public TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    public void tierStateFetcher_$eq(TierStateFetcher x$1) {
        this.tierStateFetcher = x$1;
    }

    public Seq<MergedLog> logs() {
        return this.logs;
    }

    public void logs_$eq(Seq<MergedLog> x$1) {
        this.logs = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    public void consumerSupplier_$eq(MockConsumerSupplier<byte[], byte[]> x$1) {
        this.consumerSupplier = x$1;
    }

    public int maxWaitTimeMs() {
        return this.maxWaitTimeMs;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public void setup(Integer numCompactLogs, Integer numDeleteLogs) {
        this.tierObjectStore_$eq(new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1))));
        this.setupTierComponents();
        int numTotalLogs = Predef$.MODULE$.Integer2int(numCompactLogs) + Predef$.MODULE$.Integer2int(numDeleteLogs);
        File tempDir = TestUtils.tempDirectory(null, null);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(numTotalLogs);
        this.logs_$eq((Seq<MergedLog>)this.createLogs(Predef$.MODULE$.Integer2int(numCompactLogs), Predef$.MODULE$.Integer2int(numDeleteLogs), tempDir, this.tierLogComponents(), logDirFailureChannel));
        ReplicaManager replicaManager = this.mockReplicaManager((Iterable<AbstractLog>)this.logs());
        Pool logPool = new Pool((Option)None$.MODULE$);
        this.logs().map((Function1 & Serializable)log -> (AbstractLog)logPool.put((Object)log.topicPartition(), log));
        this.tierTasks_$eq(new TierTasks(this.tierTasksConfig(), replicaManager, this.tierReplicaManager(), this.tierDeletedPartitionsCoordinator(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.tierObjectStore(), (Time)this.mockTime()));
        this.replicaManager_$eq(replicaManager);
        this.logs_$eq(this.logs());
        this.tempDir_$eq(tempDir);
    }

    public Integer setup$default$1() {
        return Predef$.MODULE$.int2Integer(2);
    }

    public Integer setup$default$2() {
        return Predef$.MODULE$.int2Integer(0);
    }

    @BeforeEach
    public void before() {
        TestUtils$.MODULE$.clearYammerMetrics();
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@Before");
    }

    @AfterEach
    public void teardown() {
        this.tierTasks().shutdown();
        this.tierTopicManager().shutdown();
        this.tierTopicConsumer().shutdown();
        ReplicaManager qual$1 = this.replicaManager();
        boolean x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.tierObjectStore().close();
        this.logs().foreach((Function1 & Serializable)x$10 -> {
            x$10.close();
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(this.logDirs()).asScala().foreach((Function1 & Serializable)path -> {
            TierCompactionIntegrationTest.$anonfun$teardown$2(path);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@After");
        TestUtils$.MODULE$.clearYammerMetrics();
        Mockito.framework().clearInlineMocks();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompactionImmigrate() {
        this.setup(this.setup$default$1(), this.setup$default$2());
        this.tierTasks().start();
        this.waitForImmigration(this.logs(), 1, this.tierTasks(), this.consumerSupplier(), true);
        this.tierReplicaManager().becomeFollower(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()));
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$testCompactionImmigrate$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Tier Log Cleaner Manager should process pending emigrations");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
        this.tierReplicaManager().becomeLeader(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()), 2);
        long l = 100L;
        long waitUntilTrue_waitTimeMs2 = 2000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$testCompactionImmigrate$4(this)) {
            void waitUntilTrue_pause2;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Tier Log Cleaner Manager should process pending immigrations");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Disabled(value="KSTORAGE-2000")
    @Test
    public void testCompactAndDeleteCleanupPolicies() {
        void materializeUntilTrue_consumerSupplier;
        void materializeUntilTrue_consumerSupplier2;
        void materializeUntilTrue_consumerSupplier3;
        void materializeUntilTrue_consumerSupplier4;
        int numCompactLogs = 10;
        int numDeleteLogs = 10;
        this.setup(Predef$.MODULE$.int2Integer(numCompactLogs), Predef$.MODULE$.int2Integer(numDeleteLogs));
        this.tierTasks().start();
        int leaderEpoch = 1;
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, 6, 4);
            return BoxedUnit.UNIT;
        });
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.logs().foreach((Function1 & Serializable)log -> {
            TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$2(leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should have materialized at least two segments";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$4(log)));
        long l = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier4, (Function0)materializeUntilTrue_pred)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime + materializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var4_6 = null;
        string = null;
        mockConsumerSupplier = null;
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier2 = this.consumerSupplier();
        String string2 = "Archiver should have tasks for all logs";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred2 = (JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$6(numCompactLogs, numDeleteLogs, x$13))));
        long l2 = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs2 = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier3, (Function0)materializeUntilTrue_pred2)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime2 + materializeUntilTrue_waitUntilTrue_waitTimeMs2) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs2), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var13_12 = null;
        string2 = null;
        mockConsumerSupplier2 = null;
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier3 = this.consumerSupplier();
        String string3 = "Tier Log Cleaner Manager should have tasks for all logs, though not all will be scheduled";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred3 = (JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((TierTaskQueue)this.tierTasks().compactionTaskQueue().get()).withAllTasks((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$8(numCompactLogs, numDeleteLogs, x$14))));
        long l3 = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs3 = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier2, (Function0)materializeUntilTrue_pred3)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime3 + materializeUntilTrue_waitUntilTrue_waitTimeMs3) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs3), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var22_18 = null;
        string3 = null;
        mockConsumerSupplier3 = null;
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier4 = this.consumerSupplier();
        String string4 = "Tier Log Cleaner Manager should have found all of the compactable tasks did compact";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred4 = (JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)((TierTaskQueue)this.tierTasks().compactionTaskQueue().get()).withAllTasks((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$10(x$15)))) == numCompactLogs;
        long l4 = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs4 = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier, (Function0)materializeUntilTrue_pred4)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime4 + materializeUntilTrue_waitUntilTrue_waitTimeMs4) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs4), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var31_24 = null;
        string4 = null;
        mockConsumerSupplier4 = null;
        ((TierTaskQueue)this.tierTasks().compactionTaskQueue().get()).poll();
        this.verifyMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTierAndCompact() {
        void materializeUntilTrue_consumerSupplier;
        void materializeUntilTrue_consumerSupplier2;
        this.setup(Predef$.MODULE$.int2Integer(10), this.setup$default$2());
        this.tierTasks().start();
        ((ThreadPoolExecutor)this.tierTasks().cleaningExecutor()).prestartAllCoreThreads();
        int numBatches = 6;
        int leaderEpoch = 1;
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, numBatches, 4);
            return BoxedUnit.UNIT;
        });
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.logs().foreach((Function1 & Serializable)log -> {
            TierCompactionIntegrationTest.$anonfun$testTierAndCompact$2(leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should have materialized at least two segments";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testTierAndCompact$4(log)));
        long l = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier2, (Function0)materializeUntilTrue_pred)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime + materializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var3_5 = null;
        string = null;
        mockConsumerSupplier = null;
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The first call to CPU stats should return 0 as we do not have reference values");
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier2 = this.consumerSupplier();
        String string2 = "Should also eventually compact down to one segment each";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred2 = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testTierAndCompact$6(log)));
        long l2 = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs2 = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier, (Function0)materializeUntilTrue_pred2)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime2 + materializeUntilTrue_waitUntilTrue_waitTimeMs2) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs2), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var12_11 = null;
        string2 = null;
        mockConsumerSupplier2 = null;
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        ((TierTaskQueue)this.tierTasks().compactionTaskQueue().get()).poll();
        Assertions.assertNotEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The subsequents calls to CPU stats metric after some valid cleanup should return a non-zero value");
        this.verifyMetrics();
    }

    @Test
    public void testTierTasksConfigUpdate() {
        this.setup(this.setup$default$1(), this.setup$default$2());
        Assertions.assertEquals((int)this.tierTasksConfig().numCleanerThreads(), (int)((ThreadPoolExecutor)this.tierTasks().cleaningExecutor()).getCorePoolSize());
        Assertions.assertEquals((Object)this.tierTasksConfig(), (Object)((TierLogCleanerManager)this.tierTasks().tierLogCleanerManager().get()).config());
        CompactionTasksConfig newCompactionTasksConfig = new CompactionTasksConfig(240, 0.9, 0x100000, 0x100000, Double.MAX_VALUE, 300, 0, 0x40000000L);
        int x$1 = this.tierTasksConfig().numCleanerThreads();
        int x$2 = this.tierTasksConfig().numCleanerThreads() + 2;
        int x$3 = this.tierTasksConfig().numSnapshotThreads();
        int x$4 = this.tierTasksConfig().brokerId();
        int x$5 = this.tierTasksConfig().maxRetryBackoffMs();
        boolean x$6 = this.tierTasksConfig().tierCleanerFeatureEnable();
        Some x$7 = new Some((Object)newCompactionTasksConfig);
        long x$8 = 600000L;
        long x$9 = 500L;
        int x$10 = 50;
        boolean x$11 = false;
        None$ x$12 = None$.MODULE$;
        TierTasksConfig newTierTasksConfig = new TierTasksConfig(x$1, x$2, x$3, x$4, x$8, x$9, x$10, x$5, x$6, x$11, (Option)x$7, (Option)x$12);
        this.tierTasks().reconfigure(this.tierTasksConfig(), newTierTasksConfig);
        Assertions.assertEquals((Object)newTierTasksConfig, (Object)((TierLogCleanerManager)this.tierTasks().tierLogCleanerManager().get()).config());
        Assertions.assertEquals((int)(this.tierTasksConfig().numCleanerThreads() + 2), (int)((ThreadPoolExecutor)this.tierTasks().cleaningExecutor()).getCorePoolSize());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForImmigration(Seq<MergedLog> logs, int leaderEpoch, TierTasks tierTasks, MockConsumerSupplier<byte[], byte[]> consumerSupplier, boolean becomeLeader) {
        if (becomeLeader) {
            logs.foreach((Function1 & Serializable)log -> {
                TierCompactionIntegrationTest.$anonfun$waitForImmigration$1(this, leaderEpoch, log);
                return BoxedUnit.UNIT;
            });
        }
        String string = "Expect leadership to materialize";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> logs.forall((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$waitForImmigration$3(x$17)));
        long l = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, consumerSupplier, (Function0)materializeUntilTrue_pred)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime + materializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var6_7 = null;
        string = null;
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$waitForImmigration$4(this, consumerSupplier, tierTasks, logs)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionIntegrationTest.$anonfun$waitForImmigration$7(tierTasks));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean waitForImmigration$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void materializeUntilTrue(Function0<Object> pred, String msg, MockConsumerSupplier<byte[], byte[]> consumerSupplier) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, consumerSupplier, pred)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void validatePartitionStateContainedInObjectStore(MockInMemoryTierObjectStore tierObjectStore, Iterable<AbstractLog> logs) {
        logs.foreach((Function1 & Serializable)log -> {
            TierCompactionIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$1(tierObjectStore, log);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void setupTierComponents() {
        String tierTopicName = TierTopic.topicName((String)this.tierTopicManagerConfig().tierNamespace);
        MockProducerSupplier producerSupplier = new MockProducerSupplier();
        this.consumerSupplier_$eq(new MockConsumerSupplier<byte[], byte[]>("primary", TierTopicManager.partitions((String)tierTopicName, (int)this.tierTopicManagerConfig().configuredNumPartitions), producerSupplier.producer()));
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)ArgumentMatchers.eq((Object)tierTopicName), ArgumentMatchers.eq((int)this.tierTopicManagerConfig().configuredNumPartitions), ArgumentMatchers.eq((short)this.tierTopicManagerConfig().configuredReplicationFactor), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicManagerConfig().configuredNumPartitions)));
        this.tierTopicConsumer_$eq(new TierTopicConsumer(this.tierTopicManagerConfig(), this.consumerSupplier(), this.consumerSupplier(), this.consumerSupplier(), new TierTopicManagerCommitter(this.tierTopicManagerConfig(), (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class)), this.tierStateFetcher(), Optional.empty(), (Time)this.mockTime()));
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.tierTopicManager_$eq(new TierTopicManager(this.tierTopicManagerConfig(), this.tierTopicConsumer(), producerSupplier, () -> internalAdmin, replicaManager, (Time)this.mockTime(), (Metrics)Mockito.mock(Metrics.class)));
        this.tierLogComponents_$eq(new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), new TierPartitionStateFactory(true, false, true, new TierPartitionStateCleanupConfig(true, Defaults$.MODULE$.TierPartitionStateCleanupDelayMs(), 0L), false, -1), (Option)None$.MODULE$));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$setupTierComponents$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private IndexedSeq<MergedLog> createLogs(int numCompactLogs, int numDeleteLogs, File tempDir, TierLogComponents tierLogComponents, LogDirFailureChannel logDirFailureChannel) {
        int segmentBytes = 150;
        int indexIntervalBytes = 1;
        int maxMessageBytes = 65536;
        long x$6 = 604800000L;
        long x$7 = 604800000L;
        long x$8 = -1L;
        long x$9 = 0L;
        int x$10 = 0xA00000;
        String x$11 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$12 = 60000L;
        long x$13 = -1L;
        long x$14 = 86400000L;
        int x$15 = 0x6400000;
        long x$16 = -1L;
        boolean x$17 = true;
        long x$18 = 1L;
        LogConfig compactLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$6, segmentBytes, x$7, x$8, x$9, "compact", maxMessageBytes, indexIntervalBytes, x$10, x$11, x$12, true, x$13, x$14, x$15, x$16, x$17, x$18);
        long x$24 = 604800000L;
        long x$25 = 604800000L;
        long x$26 = -1L;
        long x$27 = 0L;
        int x$28 = 0xA00000;
        String x$29 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$30 = 60000L;
        long x$31 = -1L;
        long x$32 = 86400000L;
        int x$33 = 0x6400000;
        long x$34 = -1L;
        boolean x$35 = true;
        long x$36 = 1L;
        LogConfig deleteLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$24, segmentBytes, x$25, x$26, x$27, "delete", maxMessageBytes, indexIntervalBytes, x$28, x$29, x$30, true, x$31, x$32, x$33, x$34, x$35, x$36);
        IndexedSeq compactLogs = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numCompactLogs).map((Function1 & Serializable)i -> TierCompactionIntegrationTest.$anonfun$createLogs$1(this, tempDir, compactLogConfig, logDirFailureChannel, tierLogComponents, BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq deleteLogs = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDeleteLogs).map((Function1 & Serializable)i -> TierCompactionIntegrationTest.$anonfun$createLogs$2(this, tempDir, deleteLogConfig, logDirFailureChannel, tierLogComponents, BoxesRunTime.unboxToInt((Object)i)));
        return (IndexedSeq)compactLogs.$plus$plus((IterableOnce)deleteLogs);
    }

    private ReplicaManager mockReplicaManager(Iterable<AbstractLog> logs) {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.time()).thenReturn((Object)new MockTime());
        Mockito.when((Object)replicaManager.getLog((TopicPartition)ArgumentMatchers.any(TopicPartition.class))).thenAnswer((Answer)new Answer<Option<AbstractLog>>(null, logs){
            private final Iterable logs$2;

            public Option<AbstractLog> answer(InvocationOnMock invocation) {
                TopicPartition target = (TopicPartition)invocation.getArgument(0);
                return this.logs$2.find((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$answer$1(target, log)));
            }

            public static final /* synthetic */ boolean $anonfun$answer$1(TopicPartition target$1, AbstractLog log) {
                TopicPartition topicPartition = log.topicPartition();
                return !(topicPartition != null ? !topicPartition.equals(target$1) : target$1 != null);
            }
            {
                this.logs$2 = logs$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(org.apache.kafka.common.TopicPartition kafka.log.AbstractLog )}, serializedLambda);
            }
        });
        Iterable partitions = (Iterable)logs.map((Function1 & Serializable)log -> {
            Partition partition = (Partition)Mockito.mock(Partition.class);
            Mockito.when((Object)partition.log()).thenReturn((Object)new Some(log));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
            Mockito.when((Object)replicaManager.getPartitionOrError(log.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
            return partition;
        });
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer(x$19 -> partitions.iterator());
        return replicaManager;
    }

    private void writeRecordBatches(AbstractLog log, int leaderEpoch, long baseOffset, int batches, int recordsPerBatch) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), batches).foreach((Function1 & Serializable)idx -> TierCompactionIntegrationTest.$anonfun$writeRecordBatches$1(this, log, leaderEpoch, baseOffset, recordsPerBatch, BoxesRunTime.unboxToInt((Object)idx)));
        log.flush(false);
        log.updateHighWatermark((long)(batches * recordsPerBatch));
    }

    private MemoryRecords createRecords(TopicPartition topicPartition, int leaderEpoch, long baseOffset, int numRecords) {
        IndexedSeq recList = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)x$20 -> TierCompactionIntegrationTest.$anonfun$createRecords$1(BoxesRunTime.unboxToInt((Object)x$20)));
        byte x$3 = 2;
        CompressionType x$4 = CompressionType.NONE;
        long x$5 = -1L;
        short x$6 = -1;
        int x$7 = -1;
        int x$8 = -1;
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)recList, x$3, x$4, x$5, x$6, x$7, baseOffset, x$8);
        ByteBuffer filtered = ByteBuffer.allocate(100 * numRecords);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().foreach((Function1 & Serializable)x$21 -> {
            x$21.setPartitionLeaderEpoch(leaderEpoch);
            return BoxedUnit.UNIT;
        });
        records.filterTo(topicPartition, new MemoryRecords.RecordFilter(null){

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                return new MemoryRecords.RecordFilter.BatchRetentionResult(MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY, false);
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return new MemoryRecords(filtered);
    }

    private TierPartitionState tierPartitionState(TopicPartition partition) {
        return (TierPartitionState)this.logs().find((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$tierPartitionState$1(partition, x$22))).map((Function1 & Serializable)x$23 -> x$23.tierPartitionState()).get();
    }

    private <T> Gauge<T> getGauge(String name) {
        Map allMetrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        MetricName metricName = allMetrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(name) : name != null);
        }).findFirst().get();
        return (Gauge)allMetrics.get(metricName);
    }

    private void verifyMetrics() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$verifyMetrics$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionIntegrationTest.$anonfun$verifyMetrics$4(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$teardown$2(String path) {
        Utils.delete((File)new File(path), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testCompactionImmigrate$2(Set x$11) {
        return x$11.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactionImmigrate$1(TierCompactionIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)((TierTaskQueue)$this.tierTasks().compactionTaskQueue().get()).withAllTasks((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactionImmigrate$2(x$11))));
    }

    public static final /* synthetic */ String $anonfun$testCompactionImmigrate$3() {
        return "Tier Log Cleaner Manager should process pending emigrations";
    }

    public static final /* synthetic */ boolean $anonfun$testCompactionImmigrate$5(Set x$12) {
        return x$12.size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactionImmigrate$4(TierCompactionIntegrationTest $this) {
        $this.consumerSupplier().moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)((TierTaskQueue)$this.tierTasks().compactionTaskQueue().get()).withAllTasks((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactionImmigrate$5(x$12))));
    }

    public static final /* synthetic */ String $anonfun$testCompactionImmigrate$6() {
        return "Tier Log Cleaner Manager should process pending immigrations";
    }

    public static final /* synthetic */ void $anonfun$testCompactAndDeleteCleanupPolicies$2(int leaderEpoch$1, MergedLog log) {
        String tierPartitionStateStr = log.tierPartitionState().toString();
        Assertions.assertEquals((int)log.tierPartitionState().tierEpoch(), (int)leaderEpoch$1, (String)new StringBuilder(55).append("topic manager should materialize entry with epoch ").append(leaderEpoch$1).append(" for ").append(tierPartitionStateStr).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testCompactAndDeleteCleanupPolicies$4(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        if (tierPartitionState.numSegments() >= 2) {
            tierPartitionState.flush();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactAndDeleteCleanupPolicies$6(int numCompactLogs$1, int numDeleteLogs$1, Set x$13) {
        return x$13.size() == numCompactLogs$1 + numDeleteLogs$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactAndDeleteCleanupPolicies$8(int numCompactLogs$1, int numDeleteLogs$1, Set x$14) {
        return x$14.size() == numCompactLogs$1 + numDeleteLogs$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactAndDeleteCleanupPolicies$11(CompactionTask t) {
        return BoxesRunTime.unboxToLong((Object)t.state().cleanerStats().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.bytesRead())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) > 0L;
    }

    public static final /* synthetic */ int $anonfun$testCompactAndDeleteCleanupPolicies$10(Set x$15) {
        return x$15.toList().count((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$11(t)));
    }

    public static final /* synthetic */ void $anonfun$testTierAndCompact$2(int leaderEpoch$2, MergedLog log) {
        String tierPartitionStateStr = log.tierPartitionState().toString();
        Assertions.assertEquals((int)log.tierPartitionState().tierEpoch(), (int)leaderEpoch$2, (String)new StringBuilder(55).append("topic manager should materialize entry with epoch ").append(leaderEpoch$2).append(" for ").append(tierPartitionStateStr).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testTierAndCompact$4(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 2 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset() && tierPartitionState.endOffset() >= 10L;
    }

    public static final /* synthetic */ boolean $anonfun$testTierAndCompact$6(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return log.tierableLogSegments().isEmpty() && tierPartitionState.numSegments() == 1;
    }

    public static final /* synthetic */ void $anonfun$waitForImmigration$1(TierCompactionIntegrationTest $this, int leaderEpoch$3, MergedLog log) {
        TopicIdPartition topicIdPartition = new TopicIdPartition(log.topicPartition().topic(), UUID.randomUUID(), log.topicPartition().partition());
        log.assignTopicId(topicIdPartition.kafkaTopicId(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$3);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$3(MergedLog x$17) {
        TierPartitionStatus tierPartitionStatus = x$17.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$6(ArchiveTask x$18) {
        return !(x$18.state() instanceof BeforeLeader);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$5(Seq logs$1, Set tasks) {
        return tasks.size() == logs$1.size() && tasks.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$waitForImmigration$6(x$18)));
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$4(TierCompactionIntegrationTest $this, MockConsumerSupplier consumerSupplier$1, TierTasks tierTasks$1, Seq logs$1) {
        consumerSupplier$1.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)tierTasks$1.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$waitForImmigration$5(logs$1, tasks))));
    }

    public static final /* synthetic */ String $anonfun$waitForImmigration$7(TierTasks tierTasks$1) {
        return new StringBuilder(28).append("Expect zero BeforeLeader in ").append(tierTasks$1.archiverTaskQueue()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$materializeUntilTrue$1(TierCompactionIntegrationTest $this, MockConsumerSupplier consumerSupplier$2, Function0 pred$1) {
        consumerSupplier$2.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return pred$1.apply$mcZ$sp();
    }

    public static final /* synthetic */ String $anonfun$materializeUntilTrue$2(String msg$1) {
        return msg$1;
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$2(MockInMemoryTierObjectStore tierObjectStore$1, TierLogSegment seg) {
        Assertions.assertNotNull((Object)tierObjectStore$1.getObject((TierObjectStore.ObjectStoreMetadata)seg.metadata(), TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1000)));
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$1(MockInMemoryTierObjectStore tierObjectStore$1, AbstractLog log) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(log.tierPartitionState().segments()).asScala().foreach((Function1 & Serializable)seg -> {
            TierCompactionIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$2(tierObjectStore$1, seg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$setupTierComponents$2(TierCompactionIntegrationTest $this) {
        $this.tierTopicManager().tryBecomeReady(false);
        return $this.tierTopicManager().isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$setupTierComponents$3() {
        return "Timed out waiting for TierTopicManager to be ready";
    }

    public static final /* synthetic */ MergedLog $anonfun$createLogs$1(TierCompactionIntegrationTest $this, File tempDir$1, LogConfig compactLogConfig$1, LogDirFailureChannel logDirFailureChannel$1, TierLogComponents tierLogComponents$1, int i) {
        File logDir = tempDir$1.toPath().resolve(new StringBuilder(19).append("tierCompactLogTest-").append(i).toString()).toFile();
        logDir.mkdir();
        MockScheduler x$41 = $this.mockTime().scheduler();
        BrokerTopicStats x$42 = new BrokerTopicStats();
        Metrics x$43 = new Metrics();
        MockTime x$44 = $this.mockTime();
        ProducerStateManagerConfig x$46 = new ProducerStateManagerConfig(3600000);
        None$ x$48 = None$.MODULE$;
        None$ x$52 = None$.MODULE$;
        None$ x$54 = None$.MODULE$;
        LogOffsetsListener x$55 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        ConcurrentHashMap x$56 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(logDir, compactLogConfig$1, 0L, 0L, (Scheduler)x$41, x$42, x$43, (Time)x$44, 300000, x$46, 600000, (Option)x$48, logDirFailureChannel$1, tierLogComponents$1, true, (Option)x$52, true, x$55, (Option)x$54, x$56);
    }

    public static final /* synthetic */ MergedLog $anonfun$createLogs$2(TierCompactionIntegrationTest $this, File tempDir$1, LogConfig deleteLogConfig$1, LogDirFailureChannel logDirFailureChannel$1, TierLogComponents tierLogComponents$1, int i) {
        File logDir = tempDir$1.toPath().resolve(new StringBuilder(18).append("tierDeleteLogTest-").append(i).toString()).toFile();
        logDir.mkdir();
        MockScheduler x$61 = $this.mockTime().scheduler();
        BrokerTopicStats x$62 = new BrokerTopicStats();
        Metrics x$63 = new Metrics();
        MockTime x$64 = $this.mockTime();
        ProducerStateManagerConfig x$66 = new ProducerStateManagerConfig(3600000);
        None$ x$68 = None$.MODULE$;
        None$ x$72 = None$.MODULE$;
        None$ x$74 = None$.MODULE$;
        LogOffsetsListener x$75 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        ConcurrentHashMap x$76 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(logDir, deleteLogConfig$1, 0L, 0L, (Scheduler)x$61, x$62, x$63, (Time)x$64, 300000, x$66, 600000, (Option)x$68, logDirFailureChannel$1, tierLogComponents$1, true, (Option)x$72, true, x$75, (Option)x$74, x$76);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$writeRecordBatches$1(TierCompactionIntegrationTest $this, AbstractLog log$1, int leaderEpoch$4, long baseOffset$1, int recordsPerBatch$1, int idx) {
        MemoryRecords records = $this.createRecords(log$1.topicPartition(), leaderEpoch$4, baseOffset$1 + (long)(idx * recordsPerBatch$1), recordsPerBatch$1);
        return log$1.appendAsFollower(records);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createRecords$1(int x$20) {
        return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$tierPartitionState$1(TopicPartition partition$1, MergedLog x$22) {
        TopicPartition topicPartition = x$22.topicPartition();
        return !(topicPartition != null ? !topicPartition.equals(partition$1) : partition$1 != null);
    }

    private final long cleanBytes$1() {
        return BoxesRunTime.unboxToLong((Object)this.getGauge("cleanable-partitions-clean-bytes-last-run").value());
    }

    private final long cleanableBytes$1() {
        return BoxesRunTime.unboxToLong((Object)this.getGauge("cleanable-partitions-cleanable-bytes-last-run").value());
    }

    private final long uncleanableBytes$1() {
        return BoxesRunTime.unboxToLong((Object)this.getGauge("cleanable-partitions-uncleanable-bytes-last-run").value());
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetrics$1(MergedLog x$24) {
        return x$24.config().compact();
    }

    private final long totalSize$1() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)this.logs().filter((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$verifyMetrics$1(x$24)))).map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetrics$3(TierCompactionIntegrationTest $this) {
        return $this.totalSize$1() == $this.cleanBytes$1() + $this.cleanableBytes$1() + $this.uncleanableBytes$1();
    }

    public static final /* synthetic */ String $anonfun$verifyMetrics$4(TierCompactionIntegrationTest $this) {
        return new StringBuilder(131).append("total size didn't end up matching clean/cleanable/uncleanable bytes. cleanBytes: ").append($this.cleanBytes$1()).append(", cleanableBytes: ").append($this.cleanableBytes$1()).append(", uncleanableBytes: ").append($this.uncleanableBytes$1()).append(", totalSize=").append($this.totalSize$1()).toString();
    }

    public TierCompactionIntegrationTest() {
        this.numThreads = 3;
        int x$1 = this.numThreads();
        int x$2 = this.numThreads();
        int x$3 = this.numThreads();
        Some x$7 = new Some((Object)this.tierCompactionTaskConfig());
        long x$8 = 600000L;
        long x$9 = 500L;
        int x$10 = 50;
        boolean x$11 = false;
        None$ x$12 = None$.MODULE$;
        this.tierTasksConfig = new TierTasksConfig(x$1, x$2, x$3, 1, x$8, x$9, x$10, 20, true, x$11, (Option)x$7, (Option)x$12);
        this.tierDeletedPartitionsCoordinator = (TierDeletedPartitionsCoordinator)Mockito.mock(TierDeletedPartitionsCoordinator.class);
        this.tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
        this.maxWaitTimeMs = 20000;
        this.tierReplicaManager = new TierReplicaManager();
    }
}

