/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kafka.common.TenantHelpers;
import kafka.log.AbstractLog;
import kafka.server.BrokerServer;
import kafka.server.KafkaConfig$;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.fault.FaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001\u0002\b\u0010\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004<\u0001\u0001\u0006Ia\t\u0005\u0006y\u0001!\t!\u0010\u0005\u0006\u001d\u0002!\t!\u0010\u0005\u0006'\u0002!\t!\u0010\u0005\u00061\u0002!\t!\u0010\u0005\u00065\u0002!Ia\u0017\u0005\u0006e\u0002!Ia\u001d\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAa!!\u0017\u0001\t\u0003i\u0004BBA/\u0001\u0011\u0005QHA\u000eCe>\\WM]'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5feR+7\u000f\u001e\u0006\u0003!E\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003%M\taa]3sm\u0016\u0014(\"\u0001\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005y\u0011!D3ySR,\u0005pY3qi&|g.F\u0001$!\r!SfL\u0007\u0002K)\u0011aeJ\u0001\u0007CR|W.[2\u000b\u0005!J\u0013AC2p]\u000e,(O]3oi*\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059*#aD!u_6L7MU3gKJ,gnY3\u0011\u0005ABdBA\u00197\u001d\t\u0011T'D\u00014\u0015\t!T#\u0001\u0004=e>|GOP\u0005\u00025%\u0011q'G\u0001\ba\u0006\u001c7.Y4f\u0013\tI$HA\u0005UQJ|w/\u00192mK*\u0011q'G\u0001\u000fKbLG/\u0012=dKB$\u0018n\u001c8!\u0003\u0015\u0019X\r^+q)\u0005q\u0004C\u0001\r@\u0013\t\u0001\u0015D\u0001\u0003V]&$\bF\u0001\u0003C!\t\u0019E*D\u0001E\u0015\t)e)A\u0002ba&T!a\u0012%\u0002\u000f),\b/\u001b;fe*\u0011\u0011JS\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0017\u0006\u0019qN]4\n\u00055#%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0006!B\u00111)U\u0005\u0003%\u0012\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002#Q,7\u000f^$fiR{\u0007/[2EK2$\u0018\r\u000b\u0002\u0007+B\u00111IV\u0005\u0003/\u0012\u0013A\u0001V3ti\u0006)B/Z:u\r&tGm\u0015;sCf\u0014V\r\u001d7jG\u0006\u001c\bFA\u0004V\u0003\u001diwnY6M_\u001e$2\u0001\u00182n!\ti\u0006-D\u0001_\u0015\ty6#A\u0002m_\u001eL!!\u00190\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\u0006G\"\u0001\r\u0001Z\u0001\bi>\u0004\u0018nY%e!\t)7.D\u0001g\u0015\t9\u0007.\u0001\u0004d_6lwN\u001c\u0006\u0003)%T!A\u001b&\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tagM\u0001\u0003Vk&$\u0007\"\u00028\t\u0001\u0004y\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003KBL!!\u001d4\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006QAo\u001c9jG&k\u0017mZ3\u0015\u000bQT80a\u0003\u0011\u0005UDX\"\u0001<\u000b\u0005]D\u0017!B5nC\u001e,\u0017BA=w\u0005)!v\u000e]5d\u00136\fw-\u001a\u0005\u0006G&\u0001\r\u0001\u001a\u0005\u0006y&\u0001\r!`\u0001\u0006i>\u0004\u0018n\u0019\t\u0004}\u0006\u0015abA@\u0002\u0002A\u0011!'G\u0005\u0004\u0003\u0007I\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\b\u0005%!AB*ue&twMC\u0002\u0002\u0004eAq!!\u0004\n\u0001\u0004\ty!\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004rA`A\t\u0003+\tY\"\u0003\u0003\u0002\u0014\u0005%!aA'baB\u0019\u0001$a\u0006\n\u0007\u0005e\u0011DA\u0002J]R\u0004R\u0001MA\u000f\u0003+I1!a\b;\u0005\r\u0019V-]\u0001\fi>\u0004\u0018nY:J[\u0006<W\r\u0006\u0003\u0002&\u0005-\u0002cA;\u0002(%\u0019\u0011\u0011\u0006<\u0003\u0017Q{\u0007/[2t\u00136\fw-\u001a\u0005\b\u0003[Q\u0001\u0019AA\u0018\u0003\u0019!x\u000e]5dgB!\u0001'!\bu\u0003uqWm^'pG.$\u0015P\\1nS\u000e\u001cuN\u001c4jOB+(\r\\5tQ\u0016\u0014HCBA\u001b\u0003w\t9\u0005E\u0002!\u0003oI1!!\u000f\u0010\u0005Y!\u0015P\\1nS\u000e\u001cuN\u001c4jOB+(\r\\5tQ\u0016\u0014\bbBA\u001f\u0017\u0001\u0007\u0011qH\u0001\u0007EJ|7.\u001a:\u0011\t\u0005\u0005\u00131I\u0007\u0002#%\u0019\u0011QI\t\u0003\u0019\t\u0013xn[3s'\u0016\u0014h/\u001a:\t\u000f\u0005%3\u00021\u0001\u0002L\u0005aQM\u001d:pe\"\u000bg\u000e\u001a7feB!\u0011QJA+\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013!\u00024bk2$(B\u0001\ni\u0013\u0011\t9&a\u0014\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u0002SQ,7\u000f\u001e*fY>\fG-\u00169eCR,GMR5mKN<\u0016\u000e\u001e5pkR\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\taQ+\u0001\u0011uKN$X\t_2faRLwN\\%o+B$\u0017\r^3D_>\u0014H-\u001b8bi>\u0014\bFA\u0007V\u0001")
public class BrokerMetadataPublisherTest {
    private final AtomicReference<Throwable> exitException = new AtomicReference<Object>(null);

    public AtomicReference<Throwable> exitException() {
        return this.exitException;
    }

    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((code, x$1) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Exit ").append(code).toString())));
        Exit.setHaltProcedure((code, x$2) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Halt ").append(code).toString())));
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        Throwable exception = this.exitException().get();
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable)() -> "Expected to see delta for changed topic");
    }

    @Test
    public void testFindStrayReplicas() {
        int brokerId = 0;
        String deletedTopic = "a";
        Uuid deletedTopicId = Uuid.randomUuid();
        TopicPartition deletedTopicPartition1 = new TopicPartition(deletedTopic, 0);
        AbstractLog deletedTopicLog1 = this.mockLog(deletedTopicId, deletedTopicPartition1);
        TopicPartition deletedTopicPartition2 = new TopicPartition(deletedTopic, 1);
        AbstractLog deletedTopicLog2 = this.mockLog(deletedTopicId, deletedTopicPartition2);
        String recreatedTopic = "b";
        TopicPartition recreatedTopicPartition = new TopicPartition(recreatedTopic, 0);
        AbstractLog recreatedTopicLog = this.mockLog(Uuid.randomUuid(), recreatedTopicPartition);
        TopicImage recreatedTopicImage = this.topicImage(Uuid.randomUuid(), recreatedTopic, (scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)recreatedTopicPartition.partition())), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))));
        String reassignedTopic = "c";
        Uuid reassignedTopicId = Uuid.randomUuid();
        TopicPartition reassignedTopicPartition = new TopicPartition(reassignedTopic, 0);
        AbstractLog reassignedTopicLog = this.mockLog(reassignedTopicId, reassignedTopicPartition);
        TopicPartition retainedTopicPartition = new TopicPartition(reassignedTopic, 1);
        AbstractLog retainedTopicLog = this.mockLog(reassignedTopicId, retainedTopicPartition);
        TopicImage reassignedTopicImage = this.topicImage(reassignedTopicId, reassignedTopic, (scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reassignedTopicPartition.partition())), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)retainedTopicPartition.partition())), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))}))));
        .colon.colon logs = new .colon.colon((Object)deletedTopicLog1, (List)new .colon.colon((Object)deletedTopicLog2, (List)new .colon.colon((Object)recreatedTopicLog, (List)new .colon.colon((Object)reassignedTopicLog, (List)new .colon.colon((Object)retainedTopicLog, (List)Nil$.MODULE$)))));
        TopicsImage image = this.topicsImage((scala.collection.immutable.Seq<TopicImage>)new .colon.colon((Object)recreatedTopicImage, (List)new .colon.colon((Object)reassignedTopicImage, (List)Nil$.MODULE$)));
        Set expectedStrayPartitions = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{deletedTopicPartition1, deletedTopicPartition2, recreatedTopicPartition, reassignedTopicPartition}));
        Set strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, image, (Iterable)logs).toSet();
        Assertions.assertEquals((Object)expectedStrayPartitions, (Object)strayPartitions);
    }

    private AbstractLog mockLog(Uuid topicId, TopicPartition topicPartition) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        return log;
    }

    private TopicImage topicImage(Uuid topicId, String topic, scala.collection.immutable.Map<Object, scala.collection.immutable.Seq<Object>> partitions) {
        scala.collection.immutable.Map partitionRegistrations = (scala.collection.immutable.Map)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partitionId = x0$1._1$mcI$sp();
                scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionRegistration.Builder().setReplicas((int[])replicas.toArray((ClassTag)ClassTag$.MODULE$.Int())).setIsr((int[])replicas.toArray((ClassTag)ClassTag$.MODULE$.Int())).setLeader(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)replicas.head()))).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(0)).build());
            }
            throw new MatchError(null);
        });
        return new TopicImage(topic, topicId, CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionRegistrations).asJava(), null);
    }

    private TopicsImage topicsImage(scala.collection.immutable.Seq<TopicImage> topics) {
        ObjectRef retval = ObjectRef.create((Object)TopicsImage.EMPTY);
        topics.foreach((Function1 & Serializable)t -> {
            retval.elem = ((TopicsImage)retval.elem).including(t, TenantHelpers.NAME_TO_NULL_CALLBACK);
            return BoxedUnit.UNIT;
        });
        return (TopicsImage)retval.elem;
    }

    private DynamicConfigPublisher newMockDynamicConfigPublisher(BrokerServer broker, FaultHandler errorHandler) {
        return (DynamicConfigPublisher)Mockito.spy((Object)new DynamicConfigPublisher(broker.config(), errorHandler, broker.dynamicConfigHandlers().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), "broker"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReloadUpdatedFilesWithoutConfigChange() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            DynamicConfigPublisher publisher = this.newMockDynamicConfigPublisher(broker, (FaultHandler)cluster.nonFatalFaultHandler());
            AtomicInteger numTimesReloadCalled = new AtomicInteger(0);
            publisher.reloadUpdatedFilesWithoutConfigChange((Properties)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, numTimesReloadCalled){
                private final AtomicInteger numTimesReloadCalled$1;

                public void answer(InvocationOnMock invocation) {
                    this.numTimesReloadCalled$1.addAndGet(1);
                }
                {
                    this.numTimesReloadCalled$1 = numTimesReloadCalled$1;
                }
            });
            broker.brokerMetadataPublisher().dynamicConfigPublisher_$eq(publisher);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((int)0, (int)numTimesReloadCalled.get());
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$1(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"numTimesConfigured never reached desired value");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(broker.config().nodeId())), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l2 = 100L;
                long waitUntilTrue_waitTimeMs2 = 15000L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$3(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                        Assertions.fail((String)"numTimesConfigured never reached desired value");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExceptionInUpdateCoordinator() {
        KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();
        try {
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$1(broker);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var19_7 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var7_4 = null;
            Object var12_9 = null;
            BrokerMetadataPublisher publisher = (BrokerMetadataPublisher)Mockito.spy((Object)broker.brokerMetadataPublisher());
            ((BrokerMetadataPublisher)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("injected failure")}).when((Object)publisher)).updateCoordinator((MetadataImage)ArgumentMatchers.any(), (MetadataDelta)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any());
            broker.sharedServer().loader().removeAndClosePublisher((MetadataPublisher)broker.brokerMetadataPublisher()).get(1L, TimeUnit.MINUTES);
            broker.metadataPublishers().remove(broker.brokerMetadataPublisher());
            broker.sharedServer().loader().installPublishers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)publisher, (List)Nil$.MODULE$)).asJava()).get(1L, TimeUnit.MINUTES);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(Collections.singletonList(new NewTopic("foo", 1, (short)1))).all().get();
            }
            long l3 = 60000L;
            TestUtils$ retry_this2 = TestUtils$.MODULE$;
            long l4 = 1L;
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$2(cluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                        Object var20_19 = null;
                        retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l4);
                    l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                    continue;
                }
                break;
            }
            Object var13_14 = null;
            Object var18_18 = null;
        }
        finally {
            cluster.nonFatalFaultHandler().setIgnore(true);
            cluster.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$1(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 0;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$2() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$3(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 1;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$4() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$1(BrokerServer broker$1) {
        Assertions.assertNotNull((Object)broker$1.brokerMetadataPublisher());
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$2(KafkaClusterTestKit cluster$1) {
        Assertions.assertTrue((boolean)((String)Option$.MODULE$.apply((Object)cluster$1.nonFatalFaultHandler().firstException()).flatMap((Function1 & Serializable)e -> Option$.MODULE$.apply((Object)e.getMessage())).getOrElse((Function0 & Serializable)() -> "(none)")).contains("injected failure"));
    }
}

