/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Stream;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.link.ClusterLinkTopicStateTest$;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkPendingSynchronizeMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MirrorTopic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\u000f\u001f\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019A\u0005\u0001)A\u0005{!9\u0011\n\u0001b\u0001\n\u0003a\u0004B\u0002&\u0001A\u0003%Q\bC\u0004L\u0001\t\u0007I\u0011\u0001'\t\ra\u0003\u0001\u0015!\u0003N\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015I\u0007\u0001\"\u0001[\u0011\u0015Y\u0007\u0001\"\u0001[\u0011\u0015i\u0007\u0001\"\u0001[\u0011\u0015y\u0007\u0001\"\u0001[\u0011\u0015\t\b\u0001\"\u0001[\u0011\u0015\u0019\b\u0001\"\u0001[\u0011\u0015)\b\u0001\"\u0001[\u0011\u00159\b\u0001\"\u0001[\u0011\u0015I\b\u0001\"\u0001[\u0011\u0015Y\b\u0001\"\u0001[\u0011\u0015i\b\u0001\"\u0001[\u0011\u0015y\b\u0001\"\u0001[\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!!\u0005\u0001\t\u0003\t\u0019bB\u0004\u0002VyA\t!a\u0016\u0007\ruq\u0002\u0012AA-\u0011\u0019a#\u0004\"\u0001\u0002\\!9\u0011\u0011\n\u000e\u0005\u0002\u0005u#!G\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a+fgRT!a\b\u0011\u0002\t1Lgn\u001b\u0006\u0003C\t\naa]3sm\u0016\u0014(\"A\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005q\u0012\u0001\u00037j].t\u0015-\\3\u0016\u0003I\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\t1\fgn\u001a\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDG\u0001\u0004TiJLgnZ\u0001\nY&t7NT1nK\u0002\na\u0001\\5oW&#W#A\u001f\u0011\u0005y2U\"A \u000b\u0005\u0001\u000b\u0015AB2p[6|gN\u0003\u0002$\u0005*\u00111\tR\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9uH\u0001\u0003Vk&$\u0017a\u00027j].LE\rI\u0001\u000eg>,(oY3U_BL7-\u00133\u0002\u001dM|WO]2f)>\u0004\u0018nY%eA\u0005\u0011R.\u001b:s_J\u001cF/\u0019:u\u001f\u001a47/\u001a;t+\u0005i\u0005c\u0001(T+6\tqJ\u0003\u0002Q#\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003%\"\n!bY8mY\u0016\u001cG/[8o\u0013\t!vJA\u0002TKF\u0004\"a\n,\n\u0005]C#\u0001\u0002'p]\u001e\f1#\\5se>\u00148\u000b^1si>3gm]3ug\u0002\n!\u0003^3ti\u001a\u0013x.\u001c&t_:\u001cFO]5oOR\t1\f\u0005\u0002(9&\u0011Q\f\u000b\u0002\u0005+:LG\u000f\u000b\u0002\u000b?B\u0011\u0001mZ\u0007\u0002C*\u0011!mY\u0001\u0004CBL'B\u00013f\u0003\u001dQW\u000f]5uKJT!A\u001a#\u0002\u000b),h.\u001b;\n\u0005!\f'\u0001\u0002+fgR\f\u0001\u0003^3tiR{'j]8o'R\u0014\u0018N\\4)\u0005-y\u0016A\u0003;fgRl\u0015N\u001d:pe\"\u0012AbX\u0001\u0011i\u0016\u001cH\u000fU1vg\u0016$W*\u001b:s_JD#!D0\u0002!Q,7\u000f\u001e$bS2,G-T5se>\u0014\bF\u0001\b`\u0003a!Xm\u001d;QK:$\u0017N\\4Ti>\u0004\b/\u001a3NSJ\u0014xN\u001d\u0015\u0003\u001f}\u000b\u0011\u0003^3tiN#x\u000e\u001d9fI6K'O]8sQ\t\u0001r,\u0001\u0007uKN$()\u00193F]R\u0014\u0018\u0010\u000b\u0002\u0012?\u0006qA/Z:u\u0005\u0006$g+\u001a:tS>t\u0007F\u0001\n`\u0003M!Xm\u001d;Nk2$\u0018\u000e\u001d7f\u000b:$(/[3tQ\t\u0019r,\u0001\u0010uKN$8\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY*uCR,\u0017\t\u001d9ms\"\u0012AcX\u0001\u0017i\u0016\u001cH/T5se>\u00148\u000b^1si>3gm]3ug\"\u0012QcX\u0001\u0015i\u0016\u001cH/T5se>\u0014Hk\u001c9jG\u0016\u0013(o\u001c:)\u0005Yy\u0016A\u0003<fe&4\u0017PS:p]R\u00191,a\u0002\t\u000f\u0005%q\u00031\u0001\u0002\f\u0005)1\u000f^1uKB\u0019q&!\u0004\n\u0007\u0005=aDA\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3\u0002YQ,7\u000f^\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a+p\u001b&\u0014(o\u001c:U_BL7MU3d_J$G#B.\u0002\u0016\u00055\u0002bBA\f1\u0001\u0007\u0011\u0011D\u0001\ri\u0016t\u0017M\u001c;Qe\u00164\u0017\u000e\u001f\t\u0005\u00037\tIC\u0004\u0003\u0002\u001e\u0005\u0015\u0002cAA\u0010Q5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G!\u0013A\u0002\u001fs_>$h(C\u0002\u0002(!\na\u0001\u0015:fI\u00164\u0017bA\u001d\u0002,)\u0019\u0011q\u0005\u0015\t\u000f\u0005=\u0002\u00041\u0001\u0002\u001a\u0005QA.\u001b8l!J,g-\u001b=)\u000fa\t\u0019$a\u0011\u0002FA!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005u2-\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u0003\n9D\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002H\u0005\u0012\u0011\u0011J\u0001\taJ,g-\u001b=fg\"\u001a\u0001$!\u0014\u0011\t\u0005=\u0013\u0011K\u0007\u0003\u0003wIA!a\u0015\u0002<\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u00023\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uKR+7\u000f\u001e\t\u0003_i\u0019\"A\u0007\u0014\u0015\u0005\u0005]SCAA0!\u0019\t\t'a\u001b\u0002p5\u0011\u00111\r\u0006\u0005\u0003K\n9'\u0001\u0004tiJ,\u0017-\u001c\u0006\u0004\u0003S2\u0014\u0001B;uS2LA!!\u001c\u0002d\t11\u000b\u001e:fC6\u0004B!!\u000e\u0002r%!\u00111OA\u001c\u0005%\t%oZ;nK:$8\u000f")
public class ClusterLinkTopicStateTest {
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final scala.collection.immutable.Seq<Object> mirrorStartOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 20L, Long.MAX_VALUE}));

    public static Stream<Arguments> prefixes() {
        return ClusterLinkTopicStateTest$.MODULE$.prefixes();
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    public scala.collection.immutable.Seq<Object> mirrorStartOffsets() {
        return this.mirrorStartOffsets;
    }

    @Test
    public void testFromJsonString() {
        int timeMs = 123456789;
        ClusterLinkTopicState result = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(173).append("|{\n          |  \"Mirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\"\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), Uuid.ZERO_UUID, (long)timeMs, (Seq)Seq$.MODULE$.empty()), (Object)result);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)result.mirrorStartOffsets());
        ClusterLinkTopicState mirrorWithSourceTopicId = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(211).append("|{\n          |  \"Mirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\",\n          |    \"source_topic_id\": \"").append(this.sourceTopicId()).append("\"\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs, (Seq)Seq$.MODULE$.empty()), (Object)mirrorWithSourceTopicId);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)mirrorWithSourceTopicId.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)mirrorWithSourceTopicId.clearMirrorStartOffsets());
        ClusterLinkTopicState mirrorWithStartOffsets = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(290).append("|{\n          |  \"Mirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\",\n          |    \"source_topic_id\": \"").append(this.sourceTopicId()).append("\",\n          |    \"mirror_start_offsets\": [0, 20, ").append(Long.MAX_VALUE).append("]\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs, this.mirrorStartOffsets()), (Object)mirrorWithStartOffsets);
        Assertions.assertEquals(this.mirrorStartOffsets(), (Object)mirrorWithStartOffsets.mirrorStartOffsets());
        Assertions.assertEquals((Object)new Some((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs, (Seq)Seq$.MODULE$.empty())), (Object)mirrorWithStartOffsets.clearMirrorStartOffsets());
        this.verifyJson(mirrorWithStartOffsets);
        ClusterLinkTopicState failedMirrorWithoutReason = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(217).append("|{\n          |  \"FailedMirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\",\n          |    \"source_topic_id\": \"").append(this.sourceTopicId()).append("\"\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_MAY_BE_DELETED, (long)timeMs), (Object)failedMirrorWithoutReason);
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_MAY_BE_DELETED, (Object)failedMirrorWithoutReason.mirrorTopicError());
        this.verifyJson(failedMirrorWithoutReason);
        ClusterLinkTopicState failedMirrorWithReason = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(256).append("|{\n          |  \"FailedMirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(CoreUtils$.MODULE$.toJavaUUID(this.linkId())).append("\",\n          |    \"source_topic_id\": \"").append(this.sourceTopicId()).append("\",\n          |    \"mirror_topic_error\": ").append(MirrorTopicError.SOURCE_TOPIC_ID_CHANGED.code()).append("\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (long)timeMs), (Object)failedMirrorWithReason);
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)failedMirrorWithReason.mirrorTopicError());
        this.verifyJson(failedMirrorWithReason);
    }

    @Test
    public void testToJsonString() {
        int timeMs = 123456789;
        ClusterLinkTopicState.Mirror mirror = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs, (Seq)Seq$.MODULE$.empty());
        Assertions.assertEquals((Object)mirror, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(mirror.toJsonString()));
        ClusterLinkTopicState.Mirror mirrorWithSourceTopicId = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), Uuid.ZERO_UUID, (long)timeMs, (Seq)Seq$.MODULE$.empty());
        Assertions.assertEquals((Object)mirrorWithSourceTopicId, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(mirrorWithSourceTopicId.toJsonString()));
        scala.collection.immutable.Seq mirrorStartOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 20L, Long.MAX_VALUE}));
        ClusterLinkTopicState.Mirror mirrorWithStartOffsets = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), Uuid.ZERO_UUID, (long)timeMs, (Seq)mirrorStartOffsets);
        Assertions.assertEquals((Object)mirrorWithStartOffsets, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(mirrorWithStartOffsets.toJsonString()));
    }

    @Test
    public void testMirror() {
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.Mirror state = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), timeMs, (Seq)Seq$.MODULE$.empty());
        ClusterLinkTopicState.Mirror data = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertTrue((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.NO_ERROR.code(), (short)data.toMirrorTopicState().mirrorTopicError());
    }

    @Test
    public void testPausedMirror() {
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)linkLevel -> {
            ClusterLinkTopicStateTest.$anonfun$testPausedMirror$1(this, BoxesRunTime.unboxToBoolean((Object)linkLevel));
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFailedMirror() {
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.FailedMirror state = new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, timeMs);
        ClusterLinkTopicState.FailedMirror data = (ClusterLinkTopicState.FailedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED.code(), (short)data.toMirrorTopicState().mirrorTopicError());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        this.verifyJson((ClusterLinkTopicState)state);
    }

    @Test
    public void testPendingStoppedMirror() {
        boolean synchronize = true;
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.PendingStoppedMirror state = new ClusterLinkTopicState.PendingStoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), synchronize, timeMs);
        ClusterLinkTopicState.PendingStoppedMirror data = (ClusterLinkTopicState.PendingStoppedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)synchronize), (Object)BoxesRunTime.boxToBoolean((boolean)data.synchronize()));
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.NO_ERROR.code(), (short)data.toMirrorTopicState().mirrorTopicError());
    }

    @Test
    public void testStoppedMirror() {
        List logEndOffsets = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{12345L, 23456L, 34567L}));
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.StoppedMirror state = new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)logEndOffsets, timeMs);
        ClusterLinkTopicState.StoppedMirror data = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((Object)logEndOffsets, (Object)data.logEndOffsets());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertFalse((boolean)data.state().readOnly());
        Assertions.assertFalse((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)MirrorTopicError.NO_ERROR.code(), (short)data.toMirrorTopicState().mirrorTopicError());
    }

    @Test
    public void testBadEntry() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(200).append("|{\n            |  \"Unexpected\": {\n            |    \"version\": 1,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"").append(this.linkName()).append("\",\n            |    \"link_id\": \"").append(this.linkId()).append("\"\n            |  }\n            |}").toString()))));
    }

    @Test
    public void testBadVersion() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(196).append("|{\n            |  \"Mirror\": {\n            |    \"version\": 0,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"").append(this.linkName()).append("\",\n            |    \"link_id\": \"").append(this.linkId()).append("\"\n            |  }\n            |}").toString()))));
    }

    @Test
    public void testMultipleEntries() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(404).append("|{\n            |  \"Mirror\": {\n            |    \"version\": 1,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"test-link-1\",\n            |    \"link_id\": \"").append(UUID.randomUUID()).append("\"\n            |  },\n            |  \"FailedMirror\": {\n            |    \"version\": 1,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"test-link-2\",\n            |    \"link_id\": \"").append(UUID.randomUUID()).append("\"\n            |  }\n            |}").toString()))));
    }

    @Test
    public void testClusterLinkTopicStateApply() {
        Uuid linkId = Uuid.randomUuid();
        String linkName = "testLink";
        Uuid topicId = Uuid.randomUuid();
        String topicName = "mirrorTopic";
        Uuid sourceTopicId = Uuid.randomUuid();
        String sourceTopicName = "sourceMirrorTopic";
        ArrayList mirrorStartOffsets = new ArrayList();
        MirrorTopic.State active = MirrorTopic.State.MIRROR;
        MirrorTopic.State paused = MirrorTopic.State.PAUSED;
        MirrorTopic.State failed = MirrorTopic.State.FAILED;
        MirrorTopic.State pendingMirror = MirrorTopic.State.PENDING_MIRROR;
        MirrorTopic.State pendingSynchronize = MirrorTopic.State.PENDING_SYNCHRONIZE;
        MirrorTopic.State pendingStopped = MirrorTopic.State.PENDING_STOPPED;
        MirrorTopic.State stopped = MirrorTopic.State.STOPPED;
        long timeMs = System.currentTimeMillis();
        MirrorTopic.PendingMirrorTopic pendingMirrorTopic = new MirrorTopic.PendingMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs);
        ClusterLinkTopicState.PendingMirror clusterLinkPendingMirrorTopic = (ClusterLinkTopicState.PendingMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPendingMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPendingMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPendingMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)pendingMirror.stateName(), (Object)clusterLinkPendingMirrorTopic.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPendingMirrorTopic.timeMs());
        MirrorTopic.ActiveMirrorTopic mirrorTopic = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, mirrorStartOffsets, timeMs);
        ClusterLinkTopicState.Mirror clusterLinkMirrorTopic = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)active.stateName(), (Object)clusterLinkMirrorTopic.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkMirrorTopic.timeMs());
        Assertions.assertEquals((int)mirrorStartOffsets.size(), (int)clusterLinkMirrorTopic.mirrorStartOffsets().size());
        MirrorTopic.ActiveMirrorTopic mirrorTopicWithoutStartOffsets = new MirrorTopic.ActiveMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, null, timeMs);
        ClusterLinkTopicState.Mirror clusterLinkMirrorTopicWithoutStartOffsets = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopicWithoutStartOffsets);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkMirrorTopicWithoutStartOffsets.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkMirrorTopicWithoutStartOffsets.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkMirrorTopicWithoutStartOffsets.sourceTopicId());
        Assertions.assertEquals((Object)active.stateName(), (Object)clusterLinkMirrorTopicWithoutStartOffsets.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkMirrorTopicWithoutStartOffsets.timeMs());
        Assertions.assertEquals((int)mirrorStartOffsets.size(), (int)clusterLinkMirrorTopicWithoutStartOffsets.mirrorStartOffsets().size());
        boolean topicLevelPause = false;
        boolean linkLevelPause = true;
        MirrorTopic.PausedMirrorTopic pausedMirrorTopic = new MirrorTopic.PausedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, mirrorStartOffsets, timeMs, topicLevelPause, linkLevelPause, active, MirrorTopicError.NO_ERROR);
        ClusterLinkTopicState.PausedMirror clusterLinkPausedMirrorTopic = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pausedMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPausedMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPausedMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPausedMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)paused.stateName(), (Object)clusterLinkPausedMirrorTopic.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPausedMirrorTopic.timeMs());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)topicLevelPause), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopic.topicLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)linkLevelPause), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopic.linkLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((active.equals(failed) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopic.wasFailed()));
        Assertions.assertEquals((int)mirrorStartOffsets.size(), (int)clusterLinkPausedMirrorTopic.mirrorStartOffsets().size());
        MirrorTopic.PausedMirrorTopic pausedMirrorTopicWithoutStartOffsets = new MirrorTopic.PausedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, null, timeMs, topicLevelPause, linkLevelPause, active, MirrorTopicError.NO_ERROR);
        ClusterLinkTopicState.PausedMirror clusterLinkPausedMirrorTopicWithoutStartOffsets = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pausedMirrorTopicWithoutStartOffsets);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPausedMirrorTopicWithoutStartOffsets.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPausedMirrorTopicWithoutStartOffsets.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPausedMirrorTopicWithoutStartOffsets.sourceTopicId());
        Assertions.assertEquals((Object)paused.stateName(), (Object)clusterLinkPausedMirrorTopicWithoutStartOffsets.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPausedMirrorTopicWithoutStartOffsets.timeMs());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)topicLevelPause), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopicWithoutStartOffsets.topicLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)linkLevelPause), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopicWithoutStartOffsets.linkLevel()));
        MirrorTopic.State state = active;
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!(state != null ? !state.equals(failed) : failed != null) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPausedMirrorTopicWithoutStartOffsets.wasFailed()));
        Assertions.assertEquals((int)mirrorStartOffsets.size(), (int)clusterLinkPausedMirrorTopicWithoutStartOffsets.mirrorStartOffsets().size());
        boolean promoted = true;
        MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirrorTopic = new MirrorTopic.PendingStoppedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, promoted);
        ClusterLinkTopicState.PendingStoppedMirror clusterLinkPendingStoppedMirrorTopic = (ClusterLinkTopicState.PendingStoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingStoppedMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPendingStoppedMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPendingStoppedMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPendingStoppedMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)pendingStopped.stateName(), (Object)clusterLinkPendingStoppedMirrorTopic.state().name());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)promoted), (Object)BoxesRunTime.boxToBoolean((boolean)clusterLinkPendingStoppedMirrorTopic.synchronize()));
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPendingStoppedMirrorTopic.timeMs());
        String nextState = "PausedMirror";
        MirrorTopic.PendingSynchronizeMirrorTopic pendingSynchronizeMirrorTopic = new MirrorTopic.PendingSynchronizeMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, MirrorTopic.State.PAUSED);
        ClusterLinkTopicState.PendingSynchronizeMirror clusterLinkPendingSynchronizeMirrorTopic = (ClusterLinkTopicState.PendingSynchronizeMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingSynchronizeMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkPendingSynchronizeMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkPendingSynchronizeMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkPendingSynchronizeMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)pendingSynchronize.stateName(), (Object)clusterLinkPendingSynchronizeMirrorTopic.state().name());
        Assertions.assertEquals((Object)nextState, (Object)clusterLinkPendingSynchronizeMirrorTopic.nextState());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkPendingSynchronizeMirrorTopic.timeMs());
        ArrayList stoppedLogEndOffsets = new ArrayList();
        MirrorTopic.StoppedMirrorTopic stoppedMirrorTopic = new MirrorTopic.StoppedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, stoppedLogEndOffsets);
        ClusterLinkTopicState.StoppedMirror clusterLinkStoppedMirrorTopic = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)stoppedMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkStoppedMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkStoppedMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkStoppedMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)stopped.stateName(), (Object)clusterLinkStoppedMirrorTopic.state().name());
        Assertions.assertEquals((int)stoppedLogEndOffsets.size(), (int)clusterLinkStoppedMirrorTopic.logEndOffsets().size());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkStoppedMirrorTopic.timeMs());
        MirrorTopic.StoppedMirrorTopic stoppedMirrorTopicWithoutStoppedLogEndOffsets = new MirrorTopic.StoppedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, null);
        ClusterLinkTopicState.StoppedMirror clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)stoppedMirrorTopicWithoutStoppedLogEndOffsets);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.sourceTopicId());
        Assertions.assertEquals((Object)stopped.stateName(), (Object)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.state().name());
        Assertions.assertEquals((int)stoppedLogEndOffsets.size(), (int)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.logEndOffsets().size());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkStoppedMirrorTopicWithoutStoppedLogEndOffsets.timeMs());
        MirrorTopic.FailedMirrorTopic failedMirrorTopic = new MirrorTopic.FailedMirrorTopic(linkId, linkName, topicId, topicName, sourceTopicId, sourceTopicName, timeMs, MirrorTopicError.SOURCE_TOPIC_ID_CHANGED);
        ClusterLinkTopicState.FailedMirror clusterLinkFailedMirrorTopic = (ClusterLinkTopicState.FailedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)failedMirrorTopic);
        Assertions.assertEquals((Object)linkId, (Object)clusterLinkFailedMirrorTopic.linkId());
        Assertions.assertEquals((Object)linkName, (Object)clusterLinkFailedMirrorTopic.linkName());
        Assertions.assertEquals((Object)sourceTopicId, (Object)clusterLinkFailedMirrorTopic.sourceTopicId());
        Assertions.assertEquals((Object)failed.stateName(), (Object)clusterLinkFailedMirrorTopic.state().name());
        Assertions.assertEquals((long)timeMs, (long)clusterLinkFailedMirrorTopic.timeMs());
    }

    @Test
    public void testMirrorStartOffsets() {
        Uuid linkId = Uuid.randomUuid();
        String linkName = "testLink";
        Uuid topicId = Uuid.randomUuid();
        String topicName = "mirrorTopic";
        Uuid sourceTopicId = Uuid.randomUuid();
        String sourceTopicName = "sourceTopic";
        java.util.List<Long> mirrorStartOffsets = Arrays.asList(Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.long2Long(11L));
        java.util.List emptyStartOffsets = Collections.emptyList();
        long timeMs = System.currentTimeMillis();
        MirrorTopicRecord mirrorTopicRecord = new MirrorTopicRecord().setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setClusterLinkId(linkId).setClusterLinkName(linkName).setTopicId(topicId).setTopicName(topicName).setSourceTopicId(sourceTopicId).setSourceTopicName(sourceTopicName).setMirrorStartOffsets(mirrorStartOffsets).setTimeMs(timeMs);
        MirrorTopic.ActiveMirrorTopic mirrorTopic = (MirrorTopic.ActiveMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.Mirror mirrorState = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopic);
        Assertions.assertEquals(mirrorStartOffsets, (Object)mirrorTopic.mirrorStartOffsets());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(mirrorStartOffsets).asScala(), (Object)mirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)((ClusterLinkTopicState)mirrorState.clearMirrorStartOffsets().get()).mirrorStartOffsets());
        MirrorTopicChangeRecord changeRecord = new MirrorTopicChangeRecord().setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setMirrorStartOffsets(emptyStartOffsets).setTimeMs(System.currentTimeMillis());
        MirrorTopic mirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)mirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)mirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setPreviousToPausedState(MirrorTopic.State.MIRROR.stateName());
        MirrorTopic.PausedMirrorTopic pausedMirrorTopic = (MirrorTopic.PausedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PausedMirror pausedMirrorState = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pausedMirrorTopic);
        Assertions.assertEquals(mirrorStartOffsets, (Object)pausedMirrorTopic.mirrorStartOffsets());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(mirrorStartOffsets).asScala(), (Object)pausedMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)((ClusterLinkTopicState)pausedMirrorState.clearMirrorStartOffsets().get()).mirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setPreviousToPausedState(MirrorTopic.State.MIRROR.stateName());
        MirrorTopic pausedMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)pausedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)pausedMirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.FAILED.stateName());
        MirrorTopic.FailedMirrorTopic failedMirrorTopic = (MirrorTopic.FailedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.FailedMirror failedMirrorState = (ClusterLinkTopicState.FailedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)failedMirrorTopic);
        if (failedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals(emptyStartOffsets, Collections.emptyList());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)failedMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)failedMirrorState.clearMirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorStartOffsets(mirrorStartOffsets);
        MirrorTopic failedMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)failedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)failedMirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName());
        MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirrorTopic = (MirrorTopic.PendingStoppedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirrorState = (ClusterLinkTopicState.PendingStoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingStoppedMirrorTopic);
        if (pendingStoppedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals(emptyStartOffsets, Collections.emptyList());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)pendingStoppedMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)pendingStoppedMirrorState.clearMirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName());
        MirrorTopic pendingStoppedMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)pendingStoppedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)pendingStoppedMirrorTopicWithoutOffsets.mirrorStartOffsets());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName());
        MirrorTopic.StoppedMirrorTopic stoppedMirrorTopic = (MirrorTopic.StoppedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.StoppedMirror stoppedMirrorState = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)stoppedMirrorTopic);
        if (stoppedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals(emptyStartOffsets, Collections.emptyList());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)stoppedMirrorState.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)stoppedMirrorState.clearMirrorStartOffsets());
        changeRecord.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName());
        MirrorTopic stoppedMirrorTopicWithoutOffsets = MirrorTopic.fromChangeRecord((MirrorTopic)stoppedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals(emptyStartOffsets, (Object)stoppedMirrorTopicWithoutOffsets.mirrorStartOffsets());
    }

    @Test
    public void testMirrorTopicError() {
        Uuid linkId = Uuid.randomUuid();
        String linkName = "testLink";
        Uuid topicId = Uuid.randomUuid();
        String topicName = "mirrorTopic";
        Uuid sourceTopicId = Uuid.randomUuid();
        String sourceTopicName = "sourceTopic";
        long timeMs = System.currentTimeMillis();
        MirrorTopicRecord mirrorTopicRecord = new MirrorTopicRecord().setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setClusterLinkId(linkId).setClusterLinkName(linkName).setTopicId(topicId).setTopicName(topicName).setSourceTopicId(sourceTopicId).setSourceTopicName(sourceTopicName).setTimeMs(timeMs);
        MirrorTopic.ActiveMirrorTopic mirrorTopic = (MirrorTopic.ActiveMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.Mirror mirrorState = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)mirrorTopic);
        if (mirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopicError.NO_ERROR);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)mirrorState.mirrorTopicError());
        MirrorTopicChangeRecord changeRecord = new MirrorTopicChangeRecord().setMirrorTopicState(MirrorTopic.State.MIRROR.stateName()).setTimeMs(System.currentTimeMillis());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)mirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setPreviousToPausedState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(MirrorTopicError.SOURCE_TOPIC_ID_CHANGED.code());
        MirrorTopic.PausedMirrorTopic pausedMirrorTopic = (MirrorTopic.PausedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PausedMirror pausedMirrorState = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pausedMirrorTopic);
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)pausedMirrorTopic.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)pausedMirrorState.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(pausedMirrorState.toJsonString()).mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_MAY_BE_DELETED, (Object)ClusterLinkTopicStateTest.stateWithoutError$1((ClusterLinkTopicState)pausedMirrorState).mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setPreviousToPausedState(MirrorTopic.State.MIRROR.stateName()).setMirrorTopicError((short)-1);
        MirrorTopic pausedMirror2 = MirrorTopic.fromChangeRecord((MirrorTopic)pausedMirrorTopic, (MirrorTopicChangeRecord)changeRecord);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)pausedMirror2.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)ClusterLinkTopicStateTest.stateWithoutError$1(ClusterLinkTopicState$.MODULE$.apply(pausedMirror2)).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH.code());
        MirrorTopic.FailedMirrorTopic failedMirrorTopic = (MirrorTopic.FailedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.FailedMirror failedMirrorState = (ClusterLinkTopicState.FailedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)failedMirrorTopic);
        Assertions.assertEquals((Object)MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH, (Object)failedMirrorTopic.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH, (Object)failedMirrorState.mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.NON_MONOTONIC_LOG_APPEND_EPOCH, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(failedMirrorState.toJsonString()).mirrorTopicError());
        Assertions.assertEquals((Object)MirrorTopicError.SOURCE_TOPIC_MAY_BE_DELETED, (Object)ClusterLinkTopicStateTest.stateWithoutError$1((ClusterLinkTopicState)failedMirrorState).mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(MirrorTopicError.UNEXPECTED_TRUNCATION.code());
        Assertions.assertEquals((Object)MirrorTopicError.UNEXPECTED_TRUNCATION, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)failedMirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName());
        MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirrorTopic = (MirrorTopic.PendingStoppedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirrorState = (ClusterLinkTopicState.PendingStoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)pendingStoppedMirrorTopic);
        if (pendingStoppedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopicError.NO_ERROR);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)pendingStoppedMirrorState.mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)pendingStoppedMirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
        mirrorTopicRecord.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName());
        MirrorTopic.StoppedMirrorTopic stoppedMirrorTopic = (MirrorTopic.StoppedMirrorTopic)MirrorTopic.fromRecord((MirrorTopicRecord)mirrorTopicRecord);
        ClusterLinkTopicState.StoppedMirror stoppedMirrorState = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)stoppedMirrorTopic);
        if (stoppedMirrorTopic == null) {
            throw null;
        }
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopicError.NO_ERROR);
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)stoppedMirrorState.mirrorTopicError());
        changeRecord.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName());
        Assertions.assertEquals((Object)MirrorTopicError.NO_ERROR, (Object)MirrorTopic.fromChangeRecord((MirrorTopic)pendingStoppedMirrorTopic, (MirrorTopicChangeRecord)changeRecord).mirrorTopicError());
    }

    private void verifyJson(ClusterLinkTopicState state) {
        Assertions.assertEquals((Object)state, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString()));
    }

    @ParameterizedTest
    @MethodSource(value={"prefixes"})
    public void testClusterLinkTopicStateToMirrorTopicRecord(String tenantPrefix, String linkPrefix) {
        Assertions.assertEquals((Object)TopicLinkState$.MODULE$.states().toSet(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicLinkState[]{TopicLinkMirror$.MODULE$, TopicLinkPausedMirror$.MODULE$, TopicLinkFailedMirror$.MODULE$, TopicLinkPendingStoppedMirror$.MODULE$, TopicLinkStoppedMirror$.MODULE$, TopicLinkPendingMirror$.MODULE$, TopicLinkPendingSynchronizeMirror$.MODULE$})), (String)"If a new state is added to the mirror topics, please add a test case for it here.");
        Option tenantPrefixOpt = Option$.MODULE$.apply((Object)tenantPrefix);
        Option linkPrefixOpt = Option$.MODULE$.apply((Object)linkPrefix);
        Uuid linkId = Uuid.randomUuid();
        String linkName = "testLink";
        Uuid topicId = Uuid.randomUuid();
        String sourceTopicName = new StringBuilder(11).append((String)tenantPrefixOpt.getOrElse((Function0 & Serializable)() -> "")).append("sourceTopic").toString();
        String topicName = new StringBuilder(11).append((String)tenantPrefixOpt.getOrElse((Function0 & Serializable)() -> "")).append(linkPrefixOpt.getOrElse((Function0 & Serializable)() -> "")).append("sourceTopic").toString();
        Uuid sourceTopicId = Uuid.randomUuid();
        long timeMs = System.currentTimeMillis();
        MirrorTopicError mirrorTopicNoError = MirrorTopicError.NO_ERROR;
        MirrorTopicError mirrorTopicError = MirrorTopicError.ILLEGAL_STATE;
        scala.collection.immutable.Seq logEndOffsets = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{10L, 20L, 30L}));
        TopicLinkState$.MODULE$.states().foreach((Function1 & Serializable)state -> {
            ClusterLinkTopicStateTest.$anonfun$testClusterLinkTopicStateToMirrorTopicRecord$4(this, linkName, linkId, sourceTopicId, timeMs, mirrorTopicNoError, mirrorTopicError, logEndOffsets, topicName, topicId, tenantPrefixOpt, linkPrefixOpt, sourceTopicName, state);
            return BoxedUnit.UNIT;
        });
    }

    private final void runTest$1(boolean linkLevel, boolean topicLevel, boolean wasFailed) {
        long timeMs = Time.SYSTEM.milliseconds();
        MirrorTopicError failReason = wasFailed ? MirrorTopicError.SOURCE_TOPIC_ID_CHANGED : MirrorTopicError.NO_ERROR;
        ClusterLinkTopicState.PausedMirror state = new ClusterLinkTopicState.PausedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), linkLevel, topicLevel, wasFailed, failReason, timeMs, (Seq)Seq$.MODULE$.empty());
        ClusterLinkTopicState.PausedMirror data = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)linkLevel), (Object)BoxesRunTime.boxToBoolean((boolean)data.linkLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)topicLevel), (Object)BoxesRunTime.boxToBoolean((boolean)data.topicLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)wasFailed), (Object)BoxesRunTime.boxToBoolean((boolean)data.wasFailed()));
        Assertions.assertEquals((Object)failReason, (Object)data.mirrorTopicError());
        Assertions.assertEquals((short)failReason.code(), (short)data.toMirrorTopicState().mirrorTopicError());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)state.mirrorStartOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.clearMirrorStartOffsets());
        ClusterLinkTopicState.PausedMirror stateWithStartOffsets = new ClusterLinkTopicState.PausedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), linkLevel, topicLevel, wasFailed, failReason, timeMs, this.mirrorStartOffsets());
        Assertions.assertEquals(this.mirrorStartOffsets(), (Object)stateWithStartOffsets.mirrorStartOffsets());
        Assertions.assertEquals((Object)new Some((Object)state), (Object)stateWithStartOffsets.clearMirrorStartOffsets());
        this.verifyJson((ClusterLinkTopicState)stateWithStartOffsets);
    }

    public static final /* synthetic */ void $anonfun$testPausedMirror$2(ClusterLinkTopicStateTest $this, boolean linkLevel$1, boolean topicLevel) {
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)wasFailed -> {
            $this.runTest$1(linkLevel$1, topicLevel, BoxesRunTime.unboxToBoolean((Object)wasFailed));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testPausedMirror$1(ClusterLinkTopicStateTest $this, boolean linkLevel) {
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)topicLevel -> {
            ClusterLinkTopicStateTest.$anonfun$testPausedMirror$2($this, linkLevel, BoxesRunTime.unboxToBoolean((Object)topicLevel));
            return BoxedUnit.UNIT;
        });
    }

    private static final ClusterLinkTopicState stateWithoutError$1(ClusterLinkTopicState state) {
        String jsonWithoutError = state.toJsonString().replace(new StringBuilder(22).append(",\"mirror_topic_error\":").append(state.mirrorTopicError().code()).toString(), "");
        return ClusterLinkTopicState$.MODULE$.fromJsonString(jsonWithoutError);
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkTopicStateToMirrorTopicRecord$4(ClusterLinkTopicStateTest $this, String linkName$1, Uuid linkId$1, Uuid sourceTopicId$1, long timeMs$1, MirrorTopicError mirrorTopicNoError$1, MirrorTopicError mirrorTopicError$1, scala.collection.immutable.Seq logEndOffsets$1, String topicName$1, Uuid topicId$1, Option tenantPrefixOpt$1, Option linkPrefixOpt$1, String sourceTopicName$1, TopicLinkState state) {
        ClusterLinkTopicState.Mirror mirrorState = TopicLinkMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.Mirror(linkName$1, linkId$1, sourceTopicId$1, timeMs$1, $this.mirrorStartOffsets()) : (TopicLinkPausedMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.PausedMirror(linkName$1, linkId$1, sourceTopicId$1, true, false, false, mirrorTopicNoError$1, timeMs$1, $this.mirrorStartOffsets()) : (TopicLinkFailedMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.FailedMirror(linkName$1, linkId$1, sourceTopicId$1, mirrorTopicError$1, timeMs$1) : (TopicLinkPendingStoppedMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.PendingStoppedMirror(linkName$1, linkId$1, sourceTopicId$1, true, timeMs$1) : (TopicLinkStoppedMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.StoppedMirror(linkName$1, linkId$1, sourceTopicId$1, (Seq)logEndOffsets$1, timeMs$1) : (TopicLinkPendingMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.PendingMirror(linkName$1, linkId$1, sourceTopicId$1, timeMs$1) : (TopicLinkPendingSynchronizeMirror$.MODULE$.equals(state) ? new ClusterLinkTopicState.PendingSynchronizeMirror(linkName$1, linkId$1, sourceTopicId$1, TopicLinkMirror$.MODULE$.name(), timeMs$1) : (Product)Assertions.fail((String)new StringBuilder(40).append("Unknown mirror state ").append(state).append(", please add a test").toString())))))));
        MirrorTopicRecord record = ((ClusterLinkTopicState)mirrorState).toMirrorTopicRecord(topicName$1, topicId$1, linkPrefixOpt$1, tenantPrefixOpt$1);
        Assertions.assertEquals((Object)topicName$1, (Object)record.topicName());
        Assertions.assertEquals((Object)topicId$1, (Object)record.topicId());
        Assertions.assertEquals((Object)sourceTopicName$1, (Object)record.sourceTopicName());
        MirrorTopic mirrorTopic = MirrorTopic.fromRecord((MirrorTopicRecord)record);
        Assertions.assertEquals((Object)mirrorState, (Object)ClusterLinkTopicState$.MODULE$.apply(mirrorTopic));
    }

    public ClusterLinkTopicStateTest() {
        this.linkName = "test-link";
    }
}

