/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncTopicsConfigs;
import kafka.server.link.ConnectionMode;
import kafka.server.link.LocalClusterLinkAdminClient;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]a\u0001\u0002\u0014(\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004?\u0001\u0001\u0006Ia\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019q\u0005\u0001)A\u0005\u0003\"9q\n\u0001b\u0001\n\u0013\u0001\u0006B\u0002+\u0001A\u0003%\u0011\u000bC\u0004V\u0001\t\u0007I\u0011\u0002,\t\ri\u0003\u0001\u0015!\u0003X\u0011\u001dY\u0006A1A\u0005\nqCa\u0001\u0019\u0001!\u0002\u0013i\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007M\u0002\u0001\u000b\u0011B2\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1A\u000e\u0001Q\u0001\n%Dq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0007\u0003\u000f\u0001A\u0011\u0001;\t\r\u0005E\u0001\u0001\"\u0001u\u0011\u0019\tY\u0002\u0001C\u0001i\"1\u0011q\u0004\u0001\u0005\u0002QDa!a\t\u0001\t\u0003!\bBBA\u0014\u0001\u0011\u0005A\u000f\u0003\u0004\u0002,\u0001!\t\u0001\u001e\u0005\u0007\u0003_\u0001A\u0011\u0001;\t\r\u0005M\u0002\u0001\"\u0001u\u0011\u0019\t9\u0004\u0001C\u0001i\"1\u00111\b\u0001\u0005\u0002QDq!a\u0010\u0001\t\u0013\t\t\u0005C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"I\u00111\u001a\u0001\u0012\u0002\u0013%\u0011Q\u001a\u0005\b\u0003G\u0004A\u0011BAs\u0011\u001d\ti\u000f\u0001C\u0005\u0003_D\u0011Ba\u0003\u0001#\u0003%IA!\u0004\t\u0013\tE\u0001!%A\u0005\n\tM!\u0001I\"mkN$XM\u001d'j].\u001c\u0016P\\2U_BL7m]\"p]\u001aLwm\u001d+fgRT!\u0001K\u0015\u0002\t1Lgn\u001b\u0006\u0003U-\naa]3sm\u0016\u0014(\"\u0001\u0017\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\f\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0004C\u0001\u001d\u0001\u001b\u00059\u0013!C:dQ\u0016$W\u000f\\3s+\u0005Y\u0004C\u0001\u001d=\u0013\titE\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013aC:pkJ\u001cW-\u00113nS:,\u0012!\u0011\t\u0003\u00052k\u0011a\u0011\u0006\u0003\t\u0016\u000bQ!\u00193nS:T!AR$\u0002\u000f\rd\u0017.\u001a8ug*\u0011A\u0006\u0013\u0006\u0003\u0013*\u000ba!\u00199bG\",'\"A&\u0002\u0007=\u0014x-\u0003\u0002N\u0007\nq1i\u001c8gYV,g\u000e^!e[&t\u0017\u0001D:pkJ\u001cW-\u00113nS:\u0004\u0013a\u00077pG\u0006d7\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\\"mS\u0016tG/F\u0001R!\tA$+\u0003\u0002TO\tYBj\\2bY\u000ecWo\u001d;fe2Kgn[!e[&t7\t\\5f]R\fA\u0004\\8dC2\u001cE.^:uKJd\u0015N\\6BI6Lgn\u00117jK:$\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\u00059\u0006C\u0001\u001dY\u0013\tIvE\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\u0012!\u0018\t\u0003qyK!aX\u0014\u00039\rcWo\u001d;fe2Kgn\u001b#fgR\u001cE.[3oi6\u000bg.Y4fe\u0006q1\r\\5f]Rl\u0015M\\1hKJ\u0004\u0013aB7fiJL7m]\u000b\u0002GB\u0011\u0001\bZ\u0005\u0003K\u001e\u0012!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0006mS:\\7i\u001c8gS\u001e,\u0012!\u001b\t\u0003q)L!a[\u0014\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-A\u0006mS:\\7i\u001c8gS\u001e\u0004\u0013\u0001\u0006;pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7/F\u0001p!\tA\u0004/\u0003\u0002rO\tQR*\u001b:s_J$v\u000e]5d\u0007>tg-[4Ts:\u001c'+\u001e7fg\u0006)Bo\u001c9jG\u000e{gNZ5h'ft7MU;mKN\u0004\u0013!B:fiV\u0003H#A;\u0011\u0005A2\u0018BA<2\u0005\u0011)f.\u001b;)\u0005II\bc\u0001>\u0002\u00045\t1P\u0003\u0002}{\u0006\u0019\u0011\r]5\u000b\u0005y|\u0018a\u00026va&$XM\u001d\u0006\u0004\u0003\u0003Q\u0015!\u00026v]&$\u0018bAA\u0003w\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3aEA\u0006!\rQ\u0018QB\u0005\u0004\u0003\u001fY(!C!gi\u0016\u0014X)Y2i\u0003E!Xm\u001d;Va\u0012\fG/Z\"p]\u001aLwm\u001d\u0015\u0004)\u0005U\u0001c\u0001>\u0002\u0018%\u0019\u0011\u0011D>\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cHOT8Va\u0012\fG/Z\"p]\u001aLwm\u001d\u0015\u0004+\u0005U\u0011\u0001\b;fgR,\u0005pY3qi&|gNR3uG\"LgnZ\"p]\u001aLwm\u001d\u0015\u0004-\u0005U\u0011\u0001\b;fgR,\u0005pY3qi&|g.\u00117uKJLgnZ\"p]\u001aLwm\u001d\u0015\u0004/\u0005U\u0011A\u0007;fgR,\u0005pY3qi&|gnQ8oM&<7OU3tk2$\bf\u0001\r\u0002\u0016\u0005yB/Z:u\u000bb\u001cW\r\u001d;j_:\fE\u000e^3s\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;)\u0007e\t)\"\u0001\tuKN$8\t[1oO\u0016$v\u000e]5dg\"\u001a!$!\u0006\u0002AQ,7\u000f^\"mkN$XM\u001d'j].\fE\u000e^3s\u0007>tg-[4Q_2L7-\u001f\u0015\u00047\u0005U\u0011A\b;fgR\fE\u000e^3s\u0007>tg-[4Q_2L7-\u001f,j_2\fG/[8oQ\ra\u0012QC\u0001\u0011i\u0016\u001cH/\u0012=dKN\u001c\u0018N^3M_\u001eD3!HA\u000b\u0003EqWm^\"p]\u001aLwMU3t_V\u00148-\u001a\u000b\u0005\u0003\u0007\n\u0019\u0006\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\r\r|gNZ5h\u0015\r\tieR\u0001\u0007G>lWn\u001c8\n\t\u0005E\u0013q\t\u0002\u000f\u0007>tg-[4SKN|WO]2f\u0011\u001d\t)F\ba\u0001\u0003/\nQ\u0001^8qS\u000e\u0004B!!\u0017\u0002h9!\u00111LA2!\r\ti&M\u0007\u0003\u0003?R1!!\u0019.\u0003\u0019a$o\\8u}%\u0019\u0011QM\u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)'M\u0001\u0016C2$XM]\"p]\u001aLwMU3rk\u0016\u001cH/T1q)\u0011\t\t(!$\u0011\u0011\u0005M\u0014QPA\"\u0003\u0003k!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u0005kRLGN\u0003\u0002\u0002|\u0005!!.\u0019<b\u0013\u0011\ty(!\u001e\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0002t\u0005\r\u0015qQ\u0005\u0005\u0003\u000b\u000b)H\u0001\u0006D_2dWm\u0019;j_:\u00042AQAE\u0013\r\tYi\u0011\u0002\u000e\u00032$XM]\"p]\u001aLwm\u00149\t\u000f\u0005=u\u00041\u0001\u0002\u0012\u0006I1m\u001c8gS\u001el\u0015\r\u001d\t\t\u00033\n\u0019*a\u0016\u0002\u0016&!\u0011qPA6!\u0011\t\u0019(a&\n\t\u0005e\u0015Q\u000f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018AF7pG.\fE\u000e^3s\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;\u0015\r\u0005}\u0015QUA^!\r\u0011\u0015\u0011U\u0005\u0004\u0003G\u001b%AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDq!a*!\u0001\u0004\tI+\u0001\u0004u_BL7m\u001d\t\u0007\u0003W\u000b),a\u0016\u000f\t\u00055\u0016\u0011\u0017\b\u0005\u0003;\ny+C\u00013\u0013\r\t\u0019,M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9,!/\u0003\t1K7\u000f\u001e\u0006\u0004\u0003g\u000b\u0004\"CA_AA\u0005\t\u0019AA`\u0003%)\u0007pY3qi&|g\u000eE\u00031\u0003\u0003\f)-C\u0002\u0002DF\u0012aa\u00149uS>t\u0007\u0003BAV\u0003\u000fLA!!3\u0002:\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001![>\u001c7.\u00117uKJ\u001cuN\u001c4jON\u0014Vm];mi\u0012\"WMZ1vYR$#'\u0006\u0002\u0002P*\"\u0011qXAiW\t\t\u0019\u000e\u0005\u0003\u0002V\u0006}WBAAl\u0015\u0011\tI.a7\u0002\u0013Ut7\r[3dW\u0016$'bAAoc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0018q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\b8fo\u000ecWo\u001d;fe2Kgn[*z]\u000e$v\u000e]5dg\u000e{gNZ5hgR\u0011\u0011q\u001d\t\u0004q\u0005%\u0018bAAvO\ta2\t\\;ti\u0016\u0014H*\u001b8l'ft7\rV8qS\u000e\u001c8i\u001c8gS\u001e\u001c\u0018!C:fiV\u0004Xj\\2l)\u0015)\u0018\u0011\u001fB\u0003\u0011%\t\u0019p\tI\u0001\u0002\u0004\t)0A\tbYR,'oQ8oM&<\u0007k\u001c7jGf\u0004R\u0001MAa\u0003o\u0004B!!?\u0003\u00025\u0011\u00111 \u0006\u0005\u0003{\fy0\u0001\u0004q_2L7-\u001f\u0006\u0003U\u001dKAAa\u0001\u0002|\n\t\u0012\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=\t\u0013\t\u001d1\u0005%AA\u0002\t%\u0011\u0001\u0004;f]\u0006tG\u000f\u0015:fM&D\b#\u0002\u0019\u0002B\u0006]\u0013aE:fiV\u0004Xj\\2lI\u0011,g-Y;mi\u0012\nTC\u0001B\bU\u0011\t)0!5\u0002'M,G/\u001e9N_\u000e\\G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tU!\u0006\u0002B\u0005\u0003#\u0004")
public class ClusterLinkSyncTopicsConfigsTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin sourceAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final LocalClusterLinkAdminClient localClusterLinkAdminClient = (LocalClusterLinkAdminClient)Mockito.mock(LocalClusterLinkAdminClient.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", Uuid.randomUuid(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)new Properties(null){
        {
            this.put("bootstrap.servers", "localhost:2345");
        }
    }, true);
    private final MirrorTopicConfigSyncRules topicConfigSyncRules = this.linkConfig().topicConfigSyncRules();

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin sourceAdmin() {
        return this.sourceAdmin;
    }

    private LocalClusterLinkAdminClient localClusterLinkAdminClient() {
        return this.localClusterLinkAdminClient;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.topicConfigSyncRules;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    @Test
    public void testUpdateConfigs() {
        this.setupMock((Option<AlterConfigPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$);
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        AlterConfigsResult alterConfigsResult = this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Option<Throwable>)None$.MODULE$);
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenReturn((Object)alterConfigsResult);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
        newProps.remove("unclean.leader.election.enable");
    }

    @Test
    public void testNoUpdateConfigs() {
        this.setupMock((Option<AlterConfigPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$);
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "compact");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
    }

    @Test
    public void testExceptionFetchingConfigs() {
        this.setupMock((Option<AlterConfigPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$);
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Set<ConfigResource> describeConfigsArg = Collections.singleton(new ConfigResource(ConfigResource.Type.TOPIC, topic));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenThrow(new Throwable[]{new TopicAuthorizationException("")});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncTopicsConfigsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141))).getCause() instanceof TopicAuthorizationException));
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
    }

    @Test
    public void testExceptionAlteringConfigs() {
        this.setupMock((Option<AlterConfigPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$);
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenThrow(new Throwable[]{new TopicAuthorizationException("")});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncTopicsConfigsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179))).getCause() instanceof TopicAuthorizationException));
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
    }

    @Test
    public void testExceptionConfigsResult() {
        this.setupMock((Option<AlterConfigPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$);
        .colon.colon topics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$)));
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn((Object)topics.toSet());
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl successConfig = new KafkaFutureImpl();
        successConfig.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        KafkaFutureImpl errorConfig = new KafkaFutureImpl();
        errorConfig.completeExceptionally((Throwable)new TopicAuthorizationException(""));
        List resources = topics.map((Function1 & Serializable)topic -> this.newConfigResource((String)topic));
        HashSet describeConfigsArg = new HashSet(3);
        resources.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)describeConfigsArg.add(x$1)));
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.head()), (Object)successConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(1)), (Object)errorConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(2)), (Object)successConfig)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        Mockito.when((Object)this.metadataManager().getTopicConfig((String)topics.head())).thenReturn((Object)curProps);
        Mockito.when((Object)this.metadataManager().getTopicConfig((String)topics.apply(2))).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        .colon.colon changedTopics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$));
        AlterConfigsResult alterConfigsResult = this.mockAlterConfigsResult((List<String>)changedTopics, (Option<Throwable>)None$.MODULE$);
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)changedTopics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)newProps)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())))).thenReturn((Object)alterConfigsResult);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)2))).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig((String)topics.head());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig((String)topics.apply(2));
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)changedTopics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)newProps)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    @Test
    public void testExceptionAlterConfigsResult() {
        this.setupMock((Option<AlterConfigPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$);
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        AlterConfigsResult alterConfigResult = this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Option<Throwable>)new Some((Object)new TopicAuthorizationException("unauthorized")));
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenReturn((Object)alterConfigResult);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
    }

    @Test
    public void testChangeTopics() {
        this.setupMock((Option<AlterConfigPolicy>)None$.MODULE$, (Option<String>)None$.MODULE$);
        .colon.colon topics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)Nil$.MODULE$));
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.head()}))).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1)})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config1 = new KafkaFutureImpl();
        config1.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        KafkaFutureImpl config2 = new KafkaFutureImpl();
        config2.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("retention.ms", "1000000"), (List)Nil$.MODULE$)).asJavaCollection()));
        List resources = topics.map((Function1 & Serializable)topic -> this.newConfigResource((String)topic));
        Set<Object> describeConfigsArg1 = Collections.singleton(resources.head());
        Set<Object> describeConfigsArg2 = Collections.singleton(resources.apply(1));
        DescribeConfigsResult describeConfigsResult1 = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.head()), (Object)config1)}))).asJava()));
        DescribeConfigsResult describeConfigsResult2 = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(1)), (Object)config2)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg1))).thenReturn((Object)describeConfigsResult1);
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg2))).thenReturn((Object)describeConfigsResult2);
        Properties curProps1 = new Properties();
        curProps1.put("cleanup.policy", "compact");
        Properties curProps2 = new Properties();
        curProps2.put("retention.ms", "1000000");
        Mockito.when((Object)this.metadataManager().getTopicConfig((String)topics.head())).thenReturn((Object)curProps1);
        Mockito.when((Object)this.metadataManager().getTopicConfig((String)topics.apply(1))).thenReturn((Object)curProps2);
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)2))).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)2))).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg1));
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg2));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig((String)topics.head());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig((String)topics.apply(1));
    }

    @Test
    public void testClusterLinkAlterConfigPolicy() {
        scala.collection.immutable.Map oldConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preallocate"), (Object)"true")}));
        scala.collection.immutable.Map newConfigs = Predef$.MODULE$.Map().empty();
        ClusterLinkAlterConfigPolicy policy = (ClusterLinkAlterConfigPolicy)Mockito.mock(ClusterLinkAlterConfigPolicy.class);
        Mockito.when((Object)policy.clusterLinkRestrictTopicConfigs((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)oldConfigs).asJava()))).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)newConfigs).asJava());
        ((ClusterLinkAlterConfigPolicy)Mockito.doNothing().when((Object)policy)).clusterLinkValidateTopicConfigs((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)newConfigs).asJava()));
        this.setupMock((Option<AlterConfigPolicy>)new Some((Object)policy), (Option<String>)new Some((Object)"tenant_"));
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("preallocate", "true"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("preallocate", "true");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        AlterConfigsResult alterConfigsResult = this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Option<Throwable>)None$.MODULE$);
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenReturn((Object)alterConfigsResult);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
        ((ClusterLinkAlterConfigPolicy)Mockito.verify((Object)policy)).clusterLinkRestrictTopicConfigs((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)oldConfigs).asJava()));
        ((ClusterLinkAlterConfigPolicy)Mockito.verify((Object)policy)).clusterLinkValidateTopicConfigs((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)newConfigs).asJava()));
    }

    @Test
    public void testAlterConfigPolicyViolation() {
        AlterConfigPolicy policy = new AlterConfigPolicy(null){

            public void configure(java.util.Map<String, ?> configs) {
            }

            public void close() {
            }

            public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
                throw new PolicyViolationException("Violated!");
            }
        };
        this.setupMock((Option<AlterConfigPolicy>)new Some((Object)policy), (Option<String>)None$.MODULE$);
        String topic = "test-topic";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        this.newClusterLinkSyncTopicsConfigs().runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
    }

    @Test
    public void testExcessiveLog() {
        AlterConfigPolicy policy = new AlterConfigPolicy(null){

            public void configure(java.util.Map<String, ?> configs) {
            }

            public void close() {
            }

            public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
                throw new PolicyViolationException("Violated!");
            }
        };
        this.setupMock((Option<AlterConfigPolicy>)new Some((Object)policy), (Option<String>)None$.MODULE$);
        String topic = "test-topic-1";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Mockito.when((Object)this.clientManager().topicConfigSyncRules()).thenReturn((Object)this.topicConfigSyncRules());
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)syncTopicsConfigs.uniqueTopicException().get((Object)topic).contains((Object)"PolicyViolationException Violated! handleDescribeTopicConfigs"));
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        Mockito.when((Object)this.clientManager().alterConfigPolicy()).thenReturn((Object)None$.MODULE$);
        topic = "test-topic-2";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        KafkaFutureImpl exceptionRemoteConfig = new KafkaFutureImpl();
        exceptionRemoteConfig.completeExceptionally((Throwable)new TopicAuthorizationException(""));
        resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        describeConfigsArg = Collections.singleton(resource);
        describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)exceptionRemoteConfig)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)syncTopicsConfigs.uniqueTopicException().get((Object)topic).contains((Object)"TopicAuthorizationException  handleDescribeTopicConfigs"));
        Assertions.assertTrue((!syncTopicsConfigs.uniqueTopicException().contains((Object)"test-topic-1") ? 1 : 0) != 0);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)2))).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager())).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        topic = "test-topic-3";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        describeConfigsArg = Collections.singleton(resource);
        describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        AlterConfigsResult alterConfigResult = this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Option<Throwable>)new Some((Object)new TopicAuthorizationException("unauthorized")));
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenReturn((Object)alterConfigResult);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)syncTopicsConfigs.uniqueTopicException().get((Object)topic).contains((Object)"TopicAuthorizationException unauthorized handleAlterTopicConfigs"));
        Assertions.assertTrue((!syncTopicsConfigs.uniqueTopicException().contains((Object)"test-topic-2") ? 1 : 0) != 0);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)3))).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)2))).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient())).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
        alterConfigResult = this.mockAlterConfigsResult((List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Option<Throwable>)None$.MODULE$);
        Mockito.when((Object)this.localClusterLinkAdminClient().incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))))).thenReturn((Object)alterConfigResult);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((!syncTopicsConfigs.uniqueTopicException().contains((Object)topic) ? 1 : 0) != 0);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)3))).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).getTopicConfig(topic);
        ((LocalClusterLinkAdminClient)Mockito.verify((Object)this.localClusterLinkAdminClient(), (VerificationMode)Mockito.times((int)2))).incrementalAlterMirrorTopicConfigs(this.alterConfigRequestMap((scala.collection.immutable.Map<String, Properties>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)newProps)})))));
        topic = "test-topic-1";
        Mockito.when((Object)this.clientManager().getTopics()).thenReturn(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        describeConfigsArg = Collections.singleton(resource);
        describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        Mockito.when((Object)this.sourceAdmin().describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg))).thenReturn((Object)describeConfigsResult);
        curProps.put("cleanup.policy", "compact");
        Mockito.when((Object)this.metadataManager().getTopicConfig(topic)).thenReturn((Object)curProps);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((!syncTopicsConfigs.uniqueTopicException().contains((Object)topic) ? 1 : 0) != 0);
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)5))).getTopics();
        ((ClusterLinkDestClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).topicConfigSyncRules();
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).describeConfigs((Collection)ArgumentMatchers.eq(describeConfigsArg));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).getTopicConfig(topic);
    }

    private ConfigResource newConfigResource(String topic) {
        return new ConfigResource(ConfigResource.Type.TOPIC, topic);
    }

    private java.util.Map<ConfigResource, Collection<AlterConfigOp>> alterConfigRequestMap(scala.collection.immutable.Map<String, Properties> configMap) {
        HashMap<ConfigResource, Collection<AlterConfigOp>> requestMap = new HashMap<ConfigResource, Collection<AlterConfigOp>>();
        configMap.foreach((Function1 & Serializable)entry2 -> {
            String topic = (String)entry2._1();
            Properties props = (Properties)entry2._2();
            HashSet configs = new HashSet();
            CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)configs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
            return requestMap.put(new ConfigResource(ConfigResource.Type.TOPIC, topic), configs);
        });
        return requestMap;
    }

    private AlterConfigsResult mockAlterConfigsResult(List<String> topics, Option<Throwable> exception) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (exception instanceof Some) {
            Throwable e = (Throwable)((Some)exception).value();
            future.completeExceptionally(e);
        } else if (None$.MODULE$.equals(exception)) {
            future.complete(null);
        } else {
            throw new MatchError(exception);
        }
        scala.collection.immutable.Map valueMap = topics.map((Function1 & Serializable)t -> new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, t), (Object)future)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterConfigsResult result = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        Mockito.when((Object)result.all()).thenReturn((Object)future);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)valueMap).asJava());
        return result;
    }

    private Option<Throwable> mockAlterConfigsResult$default$2() {
        return None$.MODULE$;
    }

    private ClusterLinkSyncTopicsConfigs newClusterLinkSyncTopicsConfigs() {
        return new ClusterLinkSyncTopicsConfigs(this.clientManager(), this.metadataManager(), this.localClusterLinkAdminClient(), 100, this.metrics());
    }

    private void setupMock(Option<AlterConfigPolicy> alterConfigPolicy, Option<String> tenantPrefix) {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.sourceAdmin()});
        Mockito.reset((Object[])new LocalClusterLinkAdminClient[]{this.localClusterLinkAdminClient()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ClusterLinkDestClientManager[]{this.clientManager()});
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.sourceAdmin());
        Mockito.when((Object)this.clientManager().alterConfigPolicy()).thenReturn(alterConfigPolicy);
        Mockito.when((Object)this.clientManager().linkData()).thenReturn((Object)new ClusterLinkData("link-name", Uuid.randomUuid(), (Option)None$.MODULE$, tenantPrefix, false));
    }

    private Option<AlterConfigPolicy> setupMock$default$1() {
        return None$.MODULE$;
    }

    private Option<String> setupMock$default$2() {
        return None$.MODULE$;
    }
}

