/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.link.AbstractClusterLinkClientManager;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls;
import kafka.server.link.ConnectionMode;
import kafka.server.link.IdentityAclBindingFilterTransformer;
import kafka.utils.Implicits;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011\rd\u0001\u00022d\u0001)DQ!\u001d\u0001\u0005\u0002IDq!\u001e\u0001C\u0002\u0013%a\u000f\u0003\u0004{\u0001\u0001\u0006Ia\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0011\u001d\t\u0019\u0002\u0001Q\u0001\nuD\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005}\u0001\u0001)A\u0005\u00033A\u0011\"!\t\u0001\u0005\u0004%I!a\t\t\u0011\u0005-\u0002\u0001)A\u0005\u0003KA1\"!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020!Y!Q\u0007\u0001A\u0002\u0003\u0007I\u0011\u0002B\u001c\u0011-\u0011i\u0004\u0001a\u0001\u0002\u0003\u0006K!!\r\t\u0017\t}\u0002\u00011AA\u0002\u0013%!\u0011\t\u0005\f\u0005{\u0003\u0001\u0019!a\u0001\n\u0013\u0011y\fC\u0006\u0003D\u0002\u0001\r\u0011!Q!\n\t\r\u0003\"\u0003Bc\u0001\t\u0007I\u0011\u0002Bd\u0011!\u0011y\r\u0001Q\u0001\n\t%\u0007\"\u0003Bi\u0001\t\u0007I\u0011\u0002Bj\u0011!\u0011Y\u000e\u0001Q\u0001\n\tU\u0007\"\u0003Bo\u0001\t\u0007I\u0011\u0002Bp\u0011!\u0011\u0019\u000f\u0001Q\u0001\n\t\u0005\b\"\u0003Bs\u0001\t\u0007I\u0011\u0002Bt\u0011!\u0011)\u0010\u0001Q\u0001\n\t%\b\"\u0003B|\u0001\t\u0007I\u0011\u0001B}\u0011!\u0011Y\u0010\u0001Q\u0001\n\u0005m\b\"\u0003B\u007f\u0001\t\u0007I\u0011\u0001B}\u0011!\u0011y\u0010\u0001Q\u0001\n\u0005m\b\"CB\u0001\u0001\t\u0007I\u0011\u0001B}\u0011!\u0019\u0019\u0001\u0001Q\u0001\n\u0005m\b\"CB\u0003\u0001\t\u0007I\u0011\u0001B}\u0011!\u00199\u0001\u0001Q\u0001\n\u0005m\bbBB\u0005\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0007C\u0001A\u0011\u0001B\u0011\u0011\u001d\u0019Y\u0003\u0001C\u0005\u0005CAqa!\f\u0001\t\u0003\u0011\t\u0003C\u0004\u00048\u0001!\tA!\t\t\u000f\rm\u0002\u0001\"\u0001\u0003\"!91q\b\u0001\u0005\u0002\t\u0005\u0002bBB\"\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0007\u000f\u0002A\u0011\u0001B\u0011\u0011\u001d\u0019Y\u0005\u0001C\u0001\u0005CAqaa\u0014\u0001\t\u0003\u0011\t\u0003C\u0004\u0004T\u0001!\tA!\t\t\u000f\r]\u0003\u0001\"\u0001\u0003\"!911\f\u0001\u0005\u0002\t\u0005\u0002bBB0\u0001\u0011%1\u0011\r\u0005\b\u0007S\u0002A\u0011\u0001B\u0011\u0011\u001d\u0019i\u0007\u0001C\u0001\u0005CAqa!\u001d\u0001\t\u0003\u0011\t\u0003C\u0004\u0004v\u0001!\tA!\t\t\u000f\re\u0004\u0001\"\u0001\u0003\"!91Q\u0010\u0001\u0005\u0002\t\u0005\u0002bBBA\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0007\u000b\u0003A\u0011\u0001B\u0011\u0011\u001d\u0019I\t\u0001C\u0001\u0005CAqa!$\u0001\t\u0003\u0011\t\u0003C\u0004\u0004\u0012\u0002!\tA!\t\t\u000f\tU\u0006\u0001\"\u0003\u0004\u0016\"91\u0011\u001b\u0001\u0005\n\rM\u0007bBBl\u0001\u0011%1\u0011\u001c\u0005\b\u0007;\u0004A\u0011BBp\u0011\u001d\u0019I\u000f\u0001C\u0005\u0007WDqaa<\u0001\t\u0013\u0019\t\u0010C\u0004\u0004j\u0002!Ia!>\t\u000f\rm\b\u0001\"\u0003\u0004~\"9A\u0011\u0001\u0001\u0005\n\u0011\r\u0001b\u0002C\u000f\u0001\u0011%Aq\u0004\u0005\b\tG\u0001A\u0011\u0002C\u0013\u0011\u001d!I\u0003\u0001C\u0005\tWAq\u0001\"\r\u0001\t\u0013!\u0019\u0004C\u0004\u0005B\u0001!I\u0001b\u0011\t\u000f\u0011\u0015\u0003\u0001\"\u0003\u0005H!9A1\u000b\u0001\u0005\n\u0011U\u0003b\u0002C.\u0001\u0011%AQ\f\u0004\u0007\u0005\u000b\u0002\u0001Aa\u0012\t\u0015\t=3J!A!\u0002\u0013\u0011\t\u0006\u0003\u0006\u0002H-\u0013\t\u0011)A\u0005\u0003\u0013Ba!]&\u0005\u0002\t]\u0003\"\u0003B/\u0017\n\u0007I\u0011\u0001B0\u0011!\u0011ig\u0013Q\u0001\n\t\u0005\u0004\"\u0003B8\u0017\n\u0007I\u0011\u0001B9\u0011!\u0011Yh\u0013Q\u0001\n\tM\u0004b\u0002B?\u0017\u0012\u0005#q\u0010\u0005\b\u0005\u0013[E\u0011\tBF\u0011\u001d\u00119j\u0013C!\u00053CqA!)L\t\u0003\u0011\u0019\u000bC\u0004\u0003*.#\tAa+\t\u000f\t=6\n\"\u0001\u00032\"9!qW&\u0005\u0002\tefABA\u001b\u0001\u0011\t9\u0004\u0003\u0006\u0002Hi\u0013\t\u0011)A\u0005\u0003\u0013Ba!\u001d.\u0005\u0002\u0005%\u0004bBA75\u0012\u0005\u0013q\u000e\u0005\b\u0003\u0007TF\u0011IAc\u0011\u001d\tIO\u0017C!\u0003WDqAa\b[\t\u0003\u0012\t\u0003C\u0004\u0002Hi#\tEa\t\u0003/\rcWo\u001d;fe2Kgn[*z]\u000e\f5\r\\:UKN$(B\u00013f\u0003\u0011a\u0017N\\6\u000b\u0005\u0019<\u0017AB:feZ,'OC\u0001i\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A6\u0011\u00051|W\"A7\u000b\u00039\fQa]2bY\u0006L!\u0001]7\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1\u000f\u0005\u0002u\u00015\t1-A\u0005tG\",G-\u001e7feV\tq\u000f\u0005\u0002uq&\u0011\u0011p\u0019\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%A\u0003bI6Lg.F\u0001~!\rq\u0018qB\u0007\u0002\u007f*\u001910!\u0001\u000b\t\u0005\r\u0011QA\u0001\bG2LWM\u001c;t\u0015\rA\u0017q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001b\t1a\u001c:h\u0013\r\t\tb \u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003\u0019\tG-\\5oA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u0002\u001aA\u0019A/a\u0007\n\u0007\u0005u1M\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\"!!\n\u0011\u0007Q\f9#C\u0002\u0002*\r\u0014Ad\u00117vgR,'\u000fT5oW\u0012+7\u000f^\"mS\u0016tG/T1oC\u001e,'/\u0001\bdY&,g\u000e^'b]\u0006<WM\u001d\u0011\u0002\u0015\u0005,H\u000f[8sSj,'/\u0006\u0002\u00022A\u0019\u00111\u0007.\u000e\u0003\u0001\u0011a\u0002V3ti\u0006+H\u000f[8sSj,'oE\u0002[\u0003s\u0001B!a\u000f\u0002D5\u0011\u0011Q\b\u0006\u0005\u0003[\tyDC\u0002\u0002B\u001d\f\u0001b]3dkJLG/_\u0005\u0005\u0003\u000b\niDA\u0007BG2\fU\u000f\u001e5pe&TXM]\u0001\u0005C\u000ed7\u000f\u0005\u0004\u0002L\u0005U\u0013\u0011L\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u00059Q.\u001e;bE2,'bAA*[\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0004'\u0016$\b\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0004C\u000ed'\u0002BA2\u0003\u000b\taaY8n[>t\u0017\u0002BA4\u0003;\u0012!\"Q2m\u0005&tG-\u001b8h)\u0011\t\t$a\u001b\t\u000f\u0005\u001dC\f1\u0001\u0002J\u0005)1\u000f^1siR!\u0011\u0011OAZa\u0011\t\u0019(a$\u0011\u0011\u0005U\u0014qPAB\u0003\u0017k!!a\u001e\u000b\t\u0005e\u00141P\u0001\u0005kRLGN\u0003\u0002\u0002~\u0005!!.\u0019<b\u0013\u0011\t\t)a\u001e\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0006\u0006\u001dUBAA1\u0013\u0011\tI)!\u0019\u0003\u0011\u0015sG\r]8j]R\u0004B!!$\u0002\u00102\u0001AaCAI;\u0006\u0005\t\u0011!B\u0001\u0003'\u00131a\u0018\u00132#\u0011\t)*a'\u0011\u00071\f9*C\u0002\u0002\u001a6\u0014qAT8uQ&tw\r\u0005\u0004\u0002\u001e\u0006\r\u0016qU\u0007\u0003\u0003?SA!!)\u0002x\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u0015\u0016q\u0014\u0002\u0010\u0007>l\u0007\u000f\\3uS>t7\u000b^1hKB!\u0011\u0011VAX\u001b\t\tYK\u0003\u0003\u0002.\u0006m\u0014\u0001\u00027b]\u001eLA!!-\u0002,\n!ak\\5e\u0011\u001d\t),\u0018a\u0001\u0003o\u000b!b]3sm\u0016\u0014\u0018J\u001c4p!\u0011\tI,a0\u000e\u0005\u0005m&\u0002BA\u0017\u0003{S1AZA\u0003\u0013\u0011\t\t-a/\u0003)\u0005+H\u000f[8sSj,'oU3sm\u0016\u0014\u0018J\u001c4p\u0003%\tW\u000f\u001e5pe&TX\r\u0006\u0004\u0002H\u0006M\u0017Q\u001c\t\u0007\u0003k\nI-!4\n\t\u0005-\u0017q\u000f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002:\u0006=\u0017\u0002BAi\u0003w\u00131#Q;uQ>\u0014\u0018N_1uS>t'+Z:vYRDq!!6_\u0001\u0004\t9.\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0011\t\u0005e\u0016\u0011\\\u0005\u0005\u00037\fYL\u0001\u000eBkRDwN]5{C\ndWMU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0002`z\u0003\r!!9\u0002\u000f\u0005\u001cG/[8ogB1\u0011QOAe\u0003G\u0004B!!/\u0002f&!\u0011q]A^\u0005\u0019\t5\r^5p]\u0006I1m\u001c8gS\u001e,(/\u001a\u000b\u0005\u0003[\f\u0019\u0010E\u0002m\u0003_L1!!=n\u0005\u0011)f.\u001b;\t\u000f\u0005Ux\f1\u0001\u0002x\u000691m\u001c8gS\u001e\u001c\b\u0007BA}\u0005'\u0001\u0002\"!\u001e\u0002\u0000\u0005m(\u0011\u0003\t\u0005\u0003{\u0014YA\u0004\u0003\u0002\u0000\n\u001d\u0001c\u0001B\u0001[6\u0011!1\u0001\u0006\u0004\u0005\u000bI\u0017A\u0002\u001fs_>$h(C\u0002\u0003\n5\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0007\u0005\u001f\u0011aa\u0015;sS:<'b\u0001B\u0005[B!\u0011Q\u0012B\n\t1\u0011)\"a=\u0002\u0002\u0003\u0005)\u0011\u0001B\f\u0005\ryFEM\t\u0005\u0003+\u0013I\u0002E\u0002m\u00057I1A!\bn\u0005\r\te._\u0001\u0006G2|7/\u001a\u000b\u0003\u0003[$BA!\n\u0003,A1\u0011\u0011\u0016B\u0014\u00033JAA!\u000b\u0002,\nA\u0011\n^3sC\ndW\rC\u0004\u0003.\u0005\u0004\rAa\f\u0002\r\u0019LG\u000e^3s!\u0011\tYF!\r\n\t\tM\u0012Q\f\u0002\u0011\u0003\u000ed')\u001b8eS:<g)\u001b7uKJ\fa\"Y;uQ>\u0014\u0018N_3s?\u0012*\u0017\u000f\u0006\u0003\u0002n\ne\u0002\"\u0003B\u001e\u0017\u0005\u0005\t\u0019AA\u0019\u0003\rAH%M\u0001\fCV$\bn\u001c:ju\u0016\u0014\b%A\u0005eKN$\u0018\tZ7j]V\u0011!1\t\t\u0004\u0003gY%a\u0004+fgR\fE-\\5o\u00072LWM\u001c;\u0014\u0007-\u0013I\u0005E\u0002\u007f\u0005\u0017J1A!\u0014\u0000\u0005=iunY6BI6Lgn\u00117jK:$\u0018\u0001\u00028pI\u0016\u0004B!!\"\u0003T%!!QKA1\u0005\u0011qu\u000eZ3\u0015\r\t\r#\u0011\fB.\u0011\u001d\u0011yE\u0014a\u0001\u0005#Bq!a\u0012O\u0001\u0004\tI%A\toKb$8I]3bi\u0016\u0014Vm];miN,\"A!\u0019\u0011\r\u0005u%1\rB4\u0013\u0011\u0011)'a(\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB\u0019aP!\u001b\n\u0007\t-tP\u0001\tDe\u0016\fG/Z!dYN\u0014Vm];mi\u0006\u0011b.\u001a=u\u0007J,\u0017\r^3SKN,H\u000e^:!\u0003EqW\r\u001f;EK2,G/\u001a*fgVdGo]\u000b\u0003\u0005g\u0002b!!(\u0003d\tU\u0004c\u0001@\u0003x%\u0019!\u0011P@\u0003!\u0011+G.\u001a;f\u0003\u000ed7OU3tk2$\u0018A\u00058fqR$U\r\\3uKJ+7/\u001e7ug\u0002\nA\u0002Z3tGJL'-Z!dYN$BA!!\u0003\bB\u0019aPa!\n\u0007\t\u0015uP\u0001\nEKN\u001c'/\u001b2f\u0003\u000ed7OU3tk2$\bb\u0002B\u0017'\u0002\u0007!qF\u0001\u000bGJ,\u0017\r^3BG2\u001cH\u0003\u0002B4\u0005\u001bCqAa$U\u0001\u0004\u0011\t*A\u0004oK^\f5\r\\:\u0011\r\u0005U$1SA-\u0013\u0011\u0011)*a\u001e\u0003\u0015\r{G\u000e\\3di&|g.\u0001\u0006eK2,G/Z!dYN$BA!\u001e\u0003\u001c\"9!QT+A\u0002\t}\u0015a\u00024jYR,'o\u001d\t\u0007\u0003k\u0012\u0019Ja\f\u0002!\u0005$Gm\u0011:fCR,'+Z:vYR\u001cH\u0003BAw\u0005KCqAa*W\u0001\u0004\u00119'\u0001\u0004sKN,H\u000e^\u0001\u0011C\u0012$G)\u001a7fi\u0016\u0014Vm];miN$B!!<\u0003.\"9!qU,A\u0002\tU\u0014aD1eI\u0006\u001bGnT;u\u001f\u001a\u0014\u0015M\u001c3\u0015\t\u00055(1\u0017\u0005\b\u0005kC\u0006\u0019AA-\u0003)\t7\r\u001c\"j]\u0012LgnZ\u0001\u0013e\u0016lwN^3BG2|U\u000f^(g\u0005\u0006tG\r\u0006\u0003\u0002n\nm\u0006b\u0002B[3\u0002\u0007\u0011\u0011L\u0001\u000eI\u0016\u001cH/\u00113nS:|F%Z9\u0015\t\u00055(\u0011\u0019\u0005\n\u0005wq\u0011\u0011!a\u0001\u0005\u0007\n!\u0002Z3ti\u0006#W.\u001b8!\u0003\u0019a\u0017N\\6JIV\u0011!\u0011\u001a\t\u0005\u0003\u000b\u0013Y-\u0003\u0003\u0003N\u0006\u0005$\u0001B+vS\u0012\fq\u0001\\5oW&#\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0005\tU\u0007c\u0001;\u0003X&\u0019!\u0011\\2\u0003%\rcWo\u001d;fe2Kgn['fiJL7m]\u0001\t[\u0016$(/[2tA\u00059\u0011m\u00197MSN$XC\u0001Bq!\u0019\t)(!3\u0002Z\u0005A\u0011m\u00197MSN$\b%\u0001\u0005mS:\\G)\u0019;b+\t\u0011I\u000f\u0005\u0003\u0003l\nEXB\u0001Bw\u0015\r\u0011yoZ\u0001\u0003u.LAAa=\u0003n\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005YR.[4sCR,wJ\\3Qe&t7-\u001b9bY\u0006\u001bGn\u001d&t_:,\"!a?\u000295LwM]1uK>sW\r\u0015:j]\u000eL\u0007/\u00197BG2\u001c(j]8oA\u0005\u0011R.[4sCR,\u0017\t\u001c7BG2\u001c(j]8o\u0003Mi\u0017n\u001a:bi\u0016\fE\u000e\\!dYNT5o\u001c8!\u0003Yi\u0017n\u001a:bi\u0016$UMZ1vYR\f5\r\\:Kg>t\u0017aF7jOJ\fG/\u001a#fM\u0006,H\u000e^!dYNT5o\u001c8!\u0003YiW\u000f\u001c;ja2,\u0017i\u00197GS2$XM]:Kg>t\u0017aF7vYRL\u0007\u000f\\3BG24\u0015\u000e\u001c;feNT5o\u001c8!\u0003\u0015\u0019X\r^+qQ\r\u00013Q\u0002\t\u0005\u0007\u001f\u0019i\"\u0004\u0002\u0004\u0012)!11CB\u000b\u0003\r\t\u0007/\u001b\u0006\u0005\u0007/\u0019I\"A\u0004kkBLG/\u001a:\u000b\t\rm\u00111B\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0007?\u0019\tB\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004C\r\u0015\u0002\u0003BB\b\u0007OIAa!\u000b\u0004\u0012\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\ng\u0016$X\u000f]'pG.\f1\u0003^3ti\u0006\u001bGNR5mi\u0016\u0014X\u000b\u001d3bi\u0016D3aIB\u0019!\u0011\u0019yaa\r\n\t\rU2\u0011\u0003\u0002\u0005)\u0016\u001cH/A\buKN$\u0018i\u00197BI\u0012LG/[8oQ\r!3\u0011G\u0001#i\u0016\u001cH/Q2m\u0003\u0012$W\r\u001a+p\t\u0016\u001cHo\u00117vgR,'oT;u\u001f\u001a\u0014\u0015M\u001c3)\u0007\u0015\u001a\t$\u0001\u0014uKN$\u0018i\u00197SK6|g/\u001a3Ge>lG)Z:u\u00072,8\u000f^3s\u001fV$xJ\u001a\"b]\u0012D3AJB\u0019\u00031\"Xm\u001d;BG2\fE\rZ5uS>tw+\u001b;i\u001bVdG/\u001b9mK\u0006\u001bGNQ5oI&twMR5mi\u0016\u00148\u000fK\u0002(\u0007c\t\u0001\u0005^3ti:{'+\u001a9fCR,G-\u00169eCR,w\u000b[3o\u001d>\u001c\u0005.\u00198hK\"\u001a\u0001f!\r\u0002{Q,7\u000f\u001e(p%\u0016\u0004X-\u0019;fIV\u0003H-\u0019;f/\",gNT8DQ\u0006tw-Z,ji\"lU\u000f\u001c;ja2,\u0017i\u00197CS:$\u0017N\\4GS2$XM]:)\u0007%\u001a\t$A\buKN$\u0018i\u00197EK2,G/[8oQ\rQ3\u0011G\u0001-i\u0016\u001cH/Q2m\t\u0016dW\r^5p]^KG\u000f['vYRL\u0007\u000f\\3BG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feND3aKB\u0019\u0003i!Xm\u001d;BG2\fE\rZ5uS>t\u0017I\u001c3EK2,G/[8oQ\ra3\u0011G\u0001,i\u0016\u001cH/Q2m\u0003\u0012$\u0017\u000e^5p]\u0006sG\rR3mKRLwN\\,ji\"$UMZ1vYR4\u0015\u000e\u001c;fe\"\u001aQf!\r\u00029Y,'/\u001b4z\u0003\u000ed\u0017\t\u001a3ji&|g.\u00118e\t\u0016dW\r^5p]R1\u0011Q^B2\u0007OBqa!\u001a/\u0001\u0004\tY0\u0001\u0006gS2$XM\u001d&t_:DqA!\f/\u0001\u0004\u0011y#A\u001cuKN$\u0018i\u00197BI\u0012LG/[8o\u0003:$G)\u001a7fi&|gnV5uQ6+H\u000e^5qY\u0016\f5\r\u001c\"j]\u0012Lgn\u001a$jYR,'o\u001d\u0015\u0004_\rE\u0012\u0001\f;fgR,\u0005pY3qi&|g.S:UQJ|wO\\%g+:\f'\r\\3U_\u001e+GoU8ve\u000e,\u0017i\u00197tQ\r\u00014\u0011G\u00012i\u0016\u001cH/\u0012:s_J|e.Q2m\u0003\u0012$\u0017\u000e^5p]V\u0003H-\u0019;fg2{7-\u00197BG2\u001cV\r^\"peJ,7\r\u001e7zQ\r\t4\u0011G\u00012i\u0016\u001cH/\u0012:s_J|e.Q2m\t\u0016dW\r^5p]V\u0003H-\u0019;fg2{7-\u00197BG2\u001cV\r^\"peJ,7\r\u001e7zQ\r\u00114\u0011G\u0001\u001ai\u0016\u001cH\u000fS1oI2,\u0017i\u00197EK2,G/\u001a*fgVdG\u000fK\u00024\u0007c\tq\u0007^3ti\u0016\u0013(o\u001c:P]\u0006\u001bG.\u00113eSRLwN\u001c$viV\u0014X-\u00169eCR,7\u000fT8dC2\f5\r\\*fi\u000e{'O]3di2L\bf\u0001\u001b\u00042\u00059D/Z:u\u000bJ\u0014xN](o\u0003\u000edG)\u001a7fi&|gNR;ukJ,W\u000b\u001d3bi\u0016\u001cHj\\2bY\u0006\u001bG.T1q\u0007>\u0014(/Z2uYfD3!NB\u0019\u0003U!Xm\u001d;FeJ|'o\u00148T_V\u00148-Z!dYND3ANB\u0019\u0003%\"Xm\u001d;TK\u000e,(/\u001b;z\t&\u001c\u0018M\u00197fI\u0016C8-\u001a9uS>tG*[7ji^\u000b'O\u001c'pO\"\u001aqg!\r\u0002%Q,7\u000f\u001e#pKNLe.\u001b;jC2L'0\u001a\u0015\u0004q\rE\u0012\u0001\b;fgR$u.Z:O_RLe.\u001b;jC2L'0Z(o\u000bJ\u0014xN\u001d\u0015\u0004s\rEB\u0003EA-\u0007/\u001b9ka+\u00046\u000ee6QXBd\u0011\u001d\u0019IJ\u000fa\u0001\u00077\u000bAB]3t_V\u00148-\u001a+za\u0016\u0004Ba!(\u0004$6\u00111q\u0014\u0006\u0005\u0007C\u000b\t'\u0001\u0005sKN|WO]2f\u0013\u0011\u0019)ka(\u0003\u0019I+7o\\;sG\u0016$\u0016\u0010]3\t\u000f\r%&\b1\u0001\u0002|\u0006a!/Z:pkJ\u001cWMT1nK\"91Q\u0016\u001eA\u0002\r=\u0016a\u00039biR,'O\u001c+za\u0016\u0004Ba!(\u00042&!11WBP\u0005-\u0001\u0016\r\u001e;fe:$\u0016\u0010]3\t\u000f\r]&\b1\u0001\u0002|\u0006i\u0001O]5oG&\u0004\u0018\r\u001c(b[\u0016Dqaa/;\u0001\u0004\tY0\u0001\u0005i_N$h*Y7f\u0011\u001d\u0019yL\u000fa\u0001\u0007\u0003\fA\"Y2m\u001fB,'/\u0019;j_:\u0004B!a\u0017\u0004D&!1QYA/\u00051\t5\r\\(qKJ\fG/[8o\u0011\u001d\u0019IM\u000fa\u0001\u0007\u0017\fa\u0002]3s[&\u001c8/[8o)f\u0004X\r\u0005\u0003\u0002\\\r5\u0017\u0002BBh\u0003;\u0012\u0011#Q2m!\u0016\u0014X.[:tS>tG+\u001f9f\u00035\tG\rZ!dY\nKg\u000eZ5oOR!!\u0011]Bk\u0011\u001d\tyf\u000fa\u0001\u00033\n\u0001C]3n_Z,\u0017i\u00197CS:$\u0017N\\4\u0015\t\t\u000581\u001c\u0005\b\u0003?b\u0004\u0019AA-\u00031\tg._!dY\u001aKG\u000e^3s)\u0011\u0011yc!9\t\u000f\r\rX\b1\u0001\u0004f\u00069A.\u001b8l\u0013\u0012\u001c\bCBA\u007f\u0007O\u0014I-\u0003\u0003\u0002X\t=\u0011\u0001\u00037j].\f5\r\\:\u0015\t\t\u00058Q\u001e\u0005\b\u0003\u000fr\u0004\u0019\u0001Bq\u0003\u001da\u0017N\\6BG2$B!!\u0017\u0004t\"9\u0011qL A\u0002\u0005eC\u0003BB|\u0007s\u0004b!!@\u0004h\u0006e\u0003bBA$\u0001\u0002\u00071q_\u0001\u0018GJ,\u0017\r^3BG2\u001c(+Z:vYR\u001cVoY2fgN$BAa\u001a\u0004\u0000\"9\u0011qI!A\u0002\t\u0005\u0018aF2sK\u0006$X-Q2mgJ+7/\u001e7u\r\u0006LG.\u001e:f)\u0019\u00119\u0007\"\u0002\u0005\b!9\u0011q\t\"A\u0002\t\u0005\bb\u0002C\u0005\u0005\u0002\u0007A1B\u0001\u0003Kb\u0004B\u0001\"\u0004\u0005\u00189!Aq\u0002C\n\u001d\u0011\u0011\t\u0001\"\u0005\n\u00039L1\u0001\"\u0006n\u0003\u001d\u0001\u0018mY6bO\u0016LA\u0001\"\u0007\u0005\u001c\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\t+i\u0017a\u00063fY\u0016$X-Q2mgJ+7/\u001e7u'V\u001c7-Z:t)\u0011\u0011)\b\"\t\t\u000f\u0005\u001d3\t1\u0001\u0003b\u0006\u0019C-\u001a7fi\u0016\f5\r\\:SKN,H\u000e\u001e$bS2,(/Z!qS\u0016C8-\u001a9uS>tG\u0003\u0002B;\tOAq!a\u0012E\u0001\u0004\u0011\t/A\feK2,G/Z!dYN\u0014Vm];mi\u001a\u000b\u0017\u000e\\;sKR1!Q\u000fC\u0017\t_Aq!a\u0012F\u0001\u0004\u0011\t\u000fC\u0004\u0005\n\u0015\u0003\r\u0001b\u0003\u0002\u00139,woQ8oM&<G\u0003\u0002C\u001b\tw\u00012\u0001\u001eC\u001c\u0013\r!Id\u0019\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0007bBA{\r\u0002\u0007AQ\b\t\t\u0003{$y$a?\u0002|&!\u0011\u0011\u0011B\b\u0003E\u0019WO\u001d:f]R$Um\u001d;BG2\u001cV\r^\u000b\u0003\u0007o\f!#\\1uG\"Lgn\u001a#fgR\f5\r\\*fiR!1q\u001fC%\u0011\u001d!Y\u0005\u0013a\u0001\t\u001b\nQ\"Y2m\r&dG/\u001a:Kg>t\u0007c\u0001;\u0005P%\u0019A\u0011K2\u0003\u001d\u0005\u001bGNR5mi\u0016\u00148OS:p]\u0006I\u0011m\u00197GS2$XM\u001d\u000b\u0005\u0005_!9\u0006C\u0004\u0005Z%\u0003\r!a?\u0002\u0013\u0019LG\u000e^3s'R\u0014\u0018A\u00047pG\u0006d\u0017i\u00197GS2$XM\u001d\u000b\u0005\u0005_!y\u0006C\u0004\u0005b)\u0003\r!!\u0017\u0002\u000f\tLg\u000eZ5oO\u0002")
public class ClusterLinkSyncAclsTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
    private TestAuthorizer authorizer;
    private TestAdminClient destAdmin;
    private final Uuid linkId = Uuid.randomUuid();
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final java.util.List<AclBinding> aclList = new ArrayList<AclBinding>();
    private final ClusterLinkData linkData = new ClusterLinkData("test-link", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final String migrateOnePrincipalAclsJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }"));
    private final String migrateAllAclsJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(309).append("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\",\n      |     \"clusterLinkIds\": [\"").append(Uuid.ZERO_UUID).append("\", \"").append(this.linkId()).append("\"]\n      |    }\n      |  }]\n      | }").toString()));
    private final String migrateDefaultAclsJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }"));
    private final String multipleAclFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"topic\",\n      |      \"name\": \"foo\",\n      |      \"patternType\": \"literal\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"read\",\n      |     \"permissionType\": \"allow\"\n      |    }\n      |  },\n      |  {\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"topic\",\n      |      \"name\": \"foo\",\n      |      \"patternType\": \"prefixed\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Alice\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"alter\",\n      |     \"permissionType\": \"allow\"\n      |    }\n      |  },\n      |  {\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"cluster\",\n      |      \"name\": \"*\",\n      |      \"patternType\": \"literal\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Mallory\",\n      |     \"host\":\"badhost\",\n      |     \"operation\": \"clusterAction\",\n      |     \"permissionType\": \"deny\"\n      |    }\n      |  }]\n      | }"));

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    private TestAuthorizer authorizer() {
        return this.authorizer;
    }

    private void authorizer_$eq(TestAuthorizer x$1) {
        this.authorizer = x$1;
    }

    private TestAdminClient destAdmin() {
        return this.destAdmin;
    }

    private void destAdmin_$eq(TestAdminClient x$1) {
        this.destAdmin = x$1;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private java.util.List<AclBinding> aclList() {
        return this.aclList;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    public String migrateOnePrincipalAclsJson() {
        return this.migrateOnePrincipalAclsJson;
    }

    public String migrateAllAclsJson() {
        return this.migrateAllAclsJson;
    }

    public String migrateDefaultAclsJson() {
        return this.migrateDefaultAclsJson;
    }

    public String multipleAclFiltersJson() {
        return this.multipleAclFiltersJson;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
        scala.collection.mutable.Set sharedAcls = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.destAdmin_$eq(new TestAdminClient(this, new Node(1, "localhost", 9090), (scala.collection.mutable.Set<AclBinding>)sharedAcls));
        this.authorizer_$eq(new TestAuthorizer(this, (scala.collection.mutable.Set<AclBinding>)sharedAcls));
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
        this.destAdmin().close();
    }

    private void setupMock() {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ClusterLinkDestClientManager[]{this.clientManager()});
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.admin());
        Mockito.when((Object)this.clientManager().getAuthorizer()).thenReturn((Object)new Some((Object)this.authorizer()));
        Mockito.when((Object)this.clientManager().linkData()).thenReturn((Object)new ClusterLinkData("test-link", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false));
    }

    @Test
    public void testAclFilterUpdate() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding bobAcl = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(bobAcl);
        AclBinding aliceAcl = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        this.addAclBinding(aliceAcl);
        AclBinding malloryAcl = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        java.util.List<AclBinding> linkedAcls = this.addAclBinding(malloryAcl);
        .colon.colon unlinkedAcls = new .colon.colon((Object)bobAcl, (List)new .colon.colon((Object)aliceAcl, (List)new .colon.colon((Object)malloryAcl, (List)Nil$.MODULE$)));
        DescribeAclsResult fullDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(linkedAcls));
        DescribeAclsResult bobDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)bobAcl, (List)Nil$.MODULE$)).asJava()));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateOnePrincipalAclsJson()))).thenReturn((Object)bobDescribeAclsResult);
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)fullDescribeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)bobAcl, (List)Nil$.MODULE$)).asJava())));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(linkedAcls));
        ClusterLinkConfig bobConfig = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateOnePrincipalAclsJson())}))));
        ClusterLinkConfig allConfig = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)bobConfig, (Object[])new ClusterLinkConfig[]{bobConfig, bobConfig, allConfig, bobConfig});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set bobAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)bobDescribeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)bobAclSet), this.matchingDestAclSet((AclFiltersJson)bobConfig.aclFilters().get()));
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set allAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)fullDescribeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)allAclSet), this.matchingDestAclSet((AclFiltersJson)allConfig.aclFilters().get()));
        List notMatchingUnlinkedAcls = unlinkedAcls.toSet().$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{bobAcl}))).toList();
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)notMatchingUnlinkedAcls).asJava())));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)notMatchingUnlinkedAcls).asJava()));
        TestUtils.setFieldValue((Object)syncAclsTask, (String)"initialized", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set<AclBinding> matchingAcls = this.linkAcls((scala.collection.immutable.Set<AclBinding>)bobAclSet);
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(linkedAcls).asScala().toSet().$minus$minus(matchingAcls).map((Function1 & Serializable)acl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, Collections.emptySet()))).$plus$plus(matchingAcls), this.matchingDestAclSet((AclFiltersJson)allConfig.aclFilters().get()));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)3))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)5))).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateOnePrincipalAclsJson()));
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
    }

    @Test
    public void testAclAddition() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls));
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult.values().get()).asScala().toSet(), this.currentDestAclSet());
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentTasksOutstanding());
    }

    @Test
    public void testAclAddedToDestClusterOutOfBand() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "topic1", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "topic2", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set expectedAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        AclBinding outOfBandAclBind = this.linkAcl(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:OutOfBandUser", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        this.destAdmin().addAclOutOfBand(outOfBandAclBind);
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(Collections.singletonList(outOfBandAclBind)));
        Assertions.assertNotEquals((Object)expectedAclSet, this.currentDestAclSet());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
    }

    @Test
    public void testAclRemovedFromDestClusterOutOfBand() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding bobAcl = this.aclBinding(ResourceType.TOPIC, "topic1", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(bobAcl);
        AclBinding linkedBobAcl = this.linkAcl(bobAcl);
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "topic2", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set expectedAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        this.destAdmin().removeAclOutOfBand(linkedBobAcl);
        Assertions.assertNotEquals((Object)expectedAclSet, this.currentDestAclSet());
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(Collections.singletonList(linkedBobAcl)));
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
    }

    @Test
    public void testAclAdditionWithMultipleAclBindingFilters() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testNoRepeatedUpdateWhenNoChange() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        scala.collection.immutable.Set expectedAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testNoRepeatedUpdateWhenNoChangeWithMultipleAclBindingFilters() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testAclDeletion() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclToDelete = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(aclToDelete);
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        ArrayList<AclBinding> acls1 = new ArrayList<AclBinding>(this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY)));
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(acls1));
        java.util.List<AclBinding> acls2 = this.removeAclBinding(aclToDelete);
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(acls2));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult1, (Object[])new DescribeAclsResult[]{describeAclsResult2});
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls1));
        AclBinding deletedAclBinding = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls(Collections.singletonList(deletedAclBinding))));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult2.values().get()).asScala().toSet(), this.currentDestAclSet());
    }

    @Test
    public void testAclDeletionWithMultipleAclBindingFilters() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)deletedDescribeAclsResult);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls(Collections.singletonList(aclBinding1))));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testAclAdditionAndDeletion() {
        this.verifyAclAdditionAndDeletion(this.migrateAllAclsJson(), this.anyAclFilter((scala.collection.immutable.Set<Uuid>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID, this.linkId()})))));
    }

    @Test
    public void testAclAdditionAndDeletionWithDefaultFilter() {
        this.verifyAclAdditionAndDeletion(this.migrateDefaultAclsJson(), this.anyAclFilter((scala.collection.immutable.Set<Uuid>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID})))));
    }

    private void verifyAclAdditionAndDeletion(String filterJson, AclBindingFilter filter) {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclToDelete = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(aclToDelete);
        ArrayList<AclBinding> acls1 = new ArrayList<AclBinding>(this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW)));
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(acls1));
        AclBinding addedAcl = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        this.addAclBinding(addedAcl);
        java.util.List<AclBinding> acls2 = this.removeAclBinding(aclToDelete);
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(acls2));
        Mockito.when((Object)this.admin().describeAcls(filter)).thenReturn((Object)describeAclsResult1, (Object[])new DescribeAclsResult[]{describeAclsResult2});
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(acls1));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)addedAcl, (List)Nil$.MODULE$)).asJava())));
        AclBinding deletedAclBinding = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls(Collections.singletonList(deletedAclBinding))));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)filterJson)}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(filter);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult2.values().get()).asScala().toSet(), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.destAdmin().describeAcls(AclBindingFilter.ANY).values().get()).asScala().toSet());
    }

    @Test
    public void testAclAdditionAndDeletionWithMultipleAclBindingFilters() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult emptyDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1, (Object[])new DescribeAclsResult[]{emptyDescribeAclsResult});
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)emptyDescribeAclsResult).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)Nil$.MODULE$))).asJava())));
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(this.linkAcls(Collections.singletonList(aclBinding1))));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)).asJava())));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testExceptionIsThrownIfUnableToGetSourceAcls() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        KafkaFutureImpl describeFuture = new KafkaFutureImpl();
        describeFuture.completeExceptionally((Throwable)new AuthorizationException("Unauthorized for DESCRIBE on Cluster"));
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)new DescribeAclsResult((KafkaFuture)describeFuture));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS));
        Assertions.assertEquals(AuthorizationException.class, ex.getCause().getCause().getClass());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclAdditionUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultFailure(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava()), (Throwable)new AuthorizationException("Unable to create ACLs")));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclDeletionUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1).thenReturn((Object)deletedDescribeAclsResult);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        this.destAdmin().addDeleteResults(this.deleteAclsResultFailure(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava()), (Throwable)new AuthorizationException("Unable to delete ACLs")));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testHandleAclDeleteResult() {
        this.setupMock();
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.tasksOutstanding_(1);
        Assertions.assertTrue((boolean)syncAclsTask.handleAclDeleteResult(this.deleteAclsResultFailureApiException(acls), (Function0)(JFunction0.mcV.sp & Serializable)() -> {}));
        syncAclsTask.tasksOutstanding_(1);
        Assertions.assertTrue((boolean)syncAclsTask.handleAclDeleteResult(this.deleteAclsResultFailure(acls, new Exception("Unknown error")), (Function0)(JFunction0.mcV.sp & Serializable)() -> {}));
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
    }

    @Test
    public void testErrorOnAclAdditionFutureUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultFailure(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava()), (Throwable)new AuthenticationException("Unable to authenticate")));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(aclBindingFilter3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclDeletionFutureUpdatesLocalAclMapCorrectly() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter1)).thenReturn((Object)describeAclsResult1).thenReturn((Object)deletedDescribeAclsResult);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter2)).thenReturn((Object)describeAclsResult2);
        Mockito.when((Object)this.admin().describeAcls(aclBindingFilter3)).thenReturn((Object)describeAclsResult3);
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava())));
        this.destAdmin().addDeleteResults(this.deleteAclsResultFailure(this.linkAcls(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclBinding1, (List)new .colon.colon((Object)aclBinding2, (List)new .colon.colon((Object)aclBinding3, (List)Nil$.MODULE$)))).asJava()), (Throwable)new AuthenticationException("Unable to authenticate")));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter1);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter2);
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)2))).describeAcls(aclBindingFilter3);
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnSourceAcls() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        KafkaFutureImpl completedFuture = new KafkaFutureImpl();
        completedFuture.completeExceptionally((Throwable)new TimeoutException("Timed out getting source ACLs"));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult((KafkaFuture)completedFuture);
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)describeAclsResult);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.startup();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncAclsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 928));
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin())).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.currentDestAclSet());
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentTasksOutstanding());
    }

    @Test
    public void testSecurityDisabledExceptionLimitWarnLog() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        KafkaFutureImpl futureCompletedWithSecDisException = new KafkaFutureImpl();
        futureCompletedWithSecDisException.completeExceptionally((Throwable)Errors.SECURITY_DISABLED.exception());
        KafkaFuture futureCompletedSuccessfully = KafkaFuture.completedFuture(Collections.emptyList());
        KafkaFutureImpl futureCompletedWithDifferentExecException = new KafkaFutureImpl();
        futureCompletedWithDifferentExecException.completeExceptionally((Throwable)Errors.REQUEST_TIMED_OUT.exception());
        Mockito.when((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException)).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException)).thenReturn((Object)new DescribeAclsResult(futureCompletedSuccessfully)).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException)).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithDifferentExecException)).thenReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)2, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        Assertions.assertEquals(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncAclsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 973))).getCause().getCause().getClass(), TimeoutException.class);
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)6))).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((Admin)Mockito.verify((Object)this.admin(), (VerificationMode)Mockito.times((int)6))).describeAcls(this.aclFilter(this.migrateAllAclsJson()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.currentDestAclSet());
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentTasksOutstanding());
    }

    @Test
    public void testDoesInitialize() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding acl = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AclBinding linkedAcl = this.linkAcl(acl);
        this.destAdmin().addAclOutOfBand(linkedAcl);
        this.destAdmin().addDeleteResults(this.deleteAclsResultSuccess(Collections.singletonList(linkedAcl)));
        this.destAdmin().addCreateResults(this.createAclsResultSuccess(Collections.singletonList(acl)));
        String aclFilterJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }"));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)aclFilterJson)}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        Assertions.assertFalse((boolean)syncAclsTask.isInitialized());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        Assertions.assertTrue((boolean)syncAclsTask.isInitialized());
    }

    @Test
    public void testDoesNotInitializeOnError() {
        this.setupMock();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AclBinding localAclBinding = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AclBinding linkedAcl = this.linkAcl(localAclBinding);
        this.destAdmin().addAclOutOfBand(linkedAcl);
        this.destAdmin().addCreateResults(this.createAclsResultFailure(Collections.singletonList(localAclBinding), new Exception("Unknown error")));
        String aclFilterJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [{\n        |  \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:Bob\",\n        |     \"host\":\"*\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        |  }]\n        | }"));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)aclFilterJson)}))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)config);
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics(), (AclBindingFilterTransformer)new IdentityAclBindingFilterTransformer(), false);
        Assertions.assertFalse((boolean)syncAclsTask.isInitialized());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager())).isLinkCoordinator(ArgumentMatchers.anyString());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        Assertions.assertFalse((boolean)syncAclsTask.isInitialized());
    }

    private AclBinding aclBinding(ResourceType resourceType, String resourceName, PatternType patternType, String principalName, String hostName, AclOperation aclOperation, AclPermissionType permissionType) {
        ResourcePattern resourcePattern = new ResourcePattern(resourceType, resourceName, patternType);
        AccessControlEntry accessControlEntry = new AccessControlEntry(principalName, hostName, aclOperation, permissionType);
        return new AclBinding(resourcePattern, accessControlEntry);
    }

    private java.util.List<AclBinding> addAclBinding(AclBinding acl) {
        this.aclList().add(acl);
        return this.linkAcls(this.aclList());
    }

    private java.util.List<AclBinding> removeAclBinding(AclBinding acl) {
        this.aclList().remove(acl);
        return this.linkAcls(this.aclList());
    }

    private AclBindingFilter anyAclFilter(scala.collection.immutable.Set<Uuid> linkIds) {
        return new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, (Collection)CollectionConverters$.MODULE$.SetHasAsJava(linkIds).asJava()));
    }

    private java.util.List<AclBinding> linkAcls(java.util.List<AclBinding> acls) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(acls).asScala().map((Function1 & Serializable)sourceAcl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)sourceAcl, Collections.singleton(this.linkId())))).asJava();
    }

    private AclBinding linkAcl(AclBinding acl) {
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, Collections.singleton(this.linkId()));
    }

    private scala.collection.immutable.Set<AclBinding> linkAcls(scala.collection.immutable.Set<AclBinding> acls) {
        return (scala.collection.immutable.Set)acls.map((Function1 & Serializable)sourceAcl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)sourceAcl, Collections.singleton(this.linkId())));
    }

    private CreateAclsResult createAclsResultSuccess(java.util.List<AclBinding> acls) {
        scala.collection.immutable.Map values = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(acls).asScala().map((Function1 & Serializable)acl -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete(null);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(acl), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        CreateAclsResult result = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)values).asJava());
        return result;
    }

    private CreateAclsResult createAclsResultFailure(java.util.List<AclBinding> acls, Throwable ex) {
        scala.collection.immutable.Map values = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(acls).asScala().map((Function1 & Serializable)acl -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally(ex);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(acl), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        CreateAclsResult result = (CreateAclsResult)Mockito.mock(CreateAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)values).asJava());
        return result;
    }

    private DeleteAclsResult deleteAclsResultSuccess(java.util.List<AclBinding> acls) {
        scala.collection.immutable.Map values = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(acls).asScala().map((Function1 & Serializable)aclBinding -> {
            DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
            Mockito.when((Object)filterResult.binding()).thenReturn(aclBinding);
            Mockito.when((Object)((Object)filterResult.exception())).thenReturn(null);
            DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
            Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)filterResults);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        DeleteAclsResult result = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)values).asJava());
        return result;
    }

    private DeleteAclsResult deleteAclsResultFailureApiException(java.util.List<AclBinding> acls) {
        scala.collection.immutable.Map values = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(acls).asScala().map((Function1 & Serializable)aclBinding -> {
            DeleteAclsResult.FilterResult filterResult = (DeleteAclsResult.FilterResult)Mockito.mock(DeleteAclsResult.FilterResult.class);
            Mockito.when((Object)filterResult.binding()).thenReturn(aclBinding);
            Mockito.when((Object)((Object)filterResult.exception())).thenReturn((Object)new ApiException("Fail"));
            DeleteAclsResult.FilterResults filterResults = (DeleteAclsResult.FilterResults)Mockito.mock(DeleteAclsResult.FilterResults.class);
            Mockito.when((Object)filterResults.values()).thenReturn(Collections.singletonList(filterResult));
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)filterResults);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        DeleteAclsResult result = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)values).asJava());
        return result;
    }

    private DeleteAclsResult deleteAclsResultFailure(java.util.List<AclBinding> acls, Throwable ex) {
        scala.collection.immutable.Map values = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(acls).asScala().map((Function1 & Serializable)aclBinding -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.completeExceptionally(ex);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aclBinding.toFilter()), (Object)future);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        DeleteAclsResult result = (DeleteAclsResult)Mockito.mock(DeleteAclsResult.class);
        Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)values).asJava());
        return result;
    }

    private ClusterLinkConfig newConfig(scala.collection.immutable.Map<String, String> configs) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(configs);
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)props, true);
    }

    private scala.collection.immutable.Set<AclBinding> currentDestAclSet() {
        return this.matchingDestAclSet((AclFiltersJson)this.clientManager().currentConfig().aclFilters().get());
    }

    private scala.collection.immutable.Set<AclBinding> matchingDestAclSet(AclFiltersJson aclFilterJson) {
        return ((IterableOnceOps)AclJson$.MODULE$.toAclBindingFilters(aclFilterJson).flatMap((Function1 & Serializable)filter -> {
            AclBindingFilter allFilter = SecurityUtils.aclFilterWithClusterLinkIds((AclBindingFilter)filter, Collections.emptyList());
            return CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer().acls(allFilter)).asScala();
        })).toSet();
    }

    private AclBindingFilter aclFilter(String filterStr) {
        return (AclBindingFilter)AclJson$.MODULE$.toAclBindingFilters((AclFiltersJson)Option$.MODULE$.option2Iterable(AclJson$.MODULE$.parse(filterStr)).head()).head();
    }

    private AclBindingFilter localAclFilter(AclBinding binding) {
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)binding, Collections.singleton(Uuid.ZERO_UUID)).toFilter();
    }

    public class TestAdminClient
    extends MockAdminClient {
        private final scala.collection.mutable.Set<AclBinding> acls;
        private final ConcurrentLinkedQueue<CreateAclsResult> nextCreateResults;
        private final ConcurrentLinkedQueue<DeleteAclsResult> nextDeleteResults;
        public final /* synthetic */ ClusterLinkSyncAclsTest $outer;

        public ConcurrentLinkedQueue<CreateAclsResult> nextCreateResults() {
            return this.nextCreateResults;
        }

        public ConcurrentLinkedQueue<DeleteAclsResult> nextDeleteResults() {
            return this.nextDeleteResults;
        }

        public DescribeAclsResult describeAcls(AclBindingFilter filter) {
            Set resultAcls = CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)this.acls.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1)))).asJava();
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete((Object)resultAcls);
            DescribeAclsResult result = (DescribeAclsResult)Mockito.mock(DescribeAclsResult.class);
            Mockito.when((Object)result.values()).thenReturn((Object)future);
            return result;
        }

        public CreateAclsResult createAcls(Collection<AclBinding> newAcls) {
            CreateAclsResult result = this.nextCreateResults().poll();
            if (result == null) {
                throw new IllegalArgumentException("No next CreateAclsResult");
            }
            scala.collection.mutable.Map resultValues = CollectionConverters$.MODULE$.MapHasAsScala(result.values()).asScala();
            newAcls.forEach(acl -> {
                if (!((KafkaFuture)resultValues.apply(acl)).isCompletedExceptionally()) {
                    $this.acls.add(acl);
                    return;
                }
            });
            return result;
        }

        public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters) {
            DeleteAclsResult result = this.nextDeleteResults().poll();
            if (result == null) {
                throw new IllegalArgumentException("No next DeleteAclsResult");
            }
            scala.collection.mutable.Map resultValues = CollectionConverters$.MODULE$.MapHasAsScala(result.values()).asScala();
            filters.forEach(filter -> {
                if (!((KafkaFuture)resultValues.apply(filter)).isCompletedExceptionally()) {
                    $this.acls.$minus$minus$eq((IterableOnce)$this.acls.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1))));
                    return;
                }
            });
            return result;
        }

        public void addCreateResults(CreateAclsResult result) {
            this.nextCreateResults().add(result);
        }

        public void addDeleteResults(DeleteAclsResult result) {
            this.nextDeleteResults().add(result);
        }

        public void addAclOutOfBand(AclBinding aclBinding) {
            this.acls.$plus$eq((Object)aclBinding);
        }

        public void removeAclOutOfBand(AclBinding aclBinding) {
            this.acls.remove((Object)aclBinding);
        }

        public /* synthetic */ ClusterLinkSyncAclsTest kafka$server$link$ClusterLinkSyncAclsTest$TestAdminClient$$$outer() {
            return this.$outer;
        }

        public TestAdminClient(ClusterLinkSyncAclsTest $outer, Node node, scala.collection.mutable.Set<AclBinding> acls) {
            this.acls = acls;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(Collections.singletonList(node), node);
            this.nextCreateResults = new ConcurrentLinkedQueue();
            this.nextDeleteResults = new ConcurrentLinkedQueue();
        }
    }

    private class TestAuthorizer
    extends AclAuthorizer {
        private final scala.collection.mutable.Set<AclBinding> acls;
        public final /* synthetic */ ClusterLinkSyncAclsTest $outer;

        public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return Collections.emptyMap();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            throw new UnsupportedOperationException("authorize()");
        }

        public void configure(java.util.Map<String, ?> configs) {
        }

        public void close() {
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)this.acls.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1)))).asJava();
        }

        public /* synthetic */ ClusterLinkSyncAclsTest kafka$server$link$ClusterLinkSyncAclsTest$TestAuthorizer$$$outer() {
            return this.$outer;
        }

        public TestAuthorizer(ClusterLinkSyncAclsTest $outer, scala.collection.mutable.Set<AclBinding> acls) {
            this.acls = acls;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

