/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkScheduler;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001\u0002\u000b\u0016\u0001qAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013\u0005\u0001\u0006\u0003\u0004-\u0001\u0001\u0006I!\u000b\u0005\b[\u0001\u0001\r\u0011\"\u0001/\u0011\u001d1\u0004\u00011A\u0005\u0002]Ba!\u0010\u0001!B\u0013y\u0003b\u0002 \u0001\u0005\u0004%Ia\u0010\u0005\u0007!\u0002\u0001\u000b\u0011\u0002!\t\u000bE\u0003A\u0011\u0002*\t\u000b]\u0003A\u0011\u0002-\t\u000bi\u0003A\u0011B.\t\u000bu\u0003A\u0011\u00010\t\u000b1\u0004A\u0011\u00010\t\u000bE\u0004A\u0011\u00010\t\u000bY\u0004A\u0011\u00010\t\u000ba\u0004A\u0011\u00010\t\u000bi\u0004A\u0011\u00010\t\u000bq\u0004A\u0011\u00010\t\u000by\u0004A\u0011\u00010\u00031\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s)\u0016\u001cHO\u0003\u0002\u0017/\u0005!A.\u001b8l\u0015\tA\u0012$\u0001\u0004tKJ4XM\u001d\u0006\u00025\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011!F\u0001\ng\u000eDW\rZ;mKJ,\u0012!\u000b\t\u0003M)J!aK\u000b\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0005i\u0006\u001c8.F\u00010!\t\u00014G\u0004\u0002'c%\u0011!'F\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u0005Q*$\u0001\u0004)fe&|G-[2UCN\\'B\u0001\u001a\u0016\u0003!!\u0018m]6`I\u0015\fHC\u0001\u001d<!\tq\u0012(\u0003\u0002;?\t!QK\\5u\u0011\u001daT!!AA\u0002=\n1\u0001\u001f\u00132\u0003\u0015!\u0018m]6!\u0003%)\u0007p\u00195b]\u001e,'/F\u0001A!\r\t\u0005JS\u0007\u0002\u0005*\u00111\tR\u0001\u000bG>t7-\u001e:sK:$(BA#G\u0003\u0011)H/\u001b7\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011J\u0011\u0002\n\u000bb\u001c\u0007.\u00198hKJ\u0004\"a\u0013(\u000e\u00031S!!\u0014$\u0002\t1\fgnZ\u0005\u0003\u001f2\u0013q!\u00138uK\u001e,'/\u0001\u0006fq\u000eD\u0017M\\4fe\u0002\na\"\u001a=dQ\u0006tw-Z#ya\u0016\u001cG\u000fF\u00029'VCQ\u0001V\u0005A\u0002)\u000bQA^1mk\u0016DQAV\u0005A\u0002)\u000ba!\u001a=qK\u000e$\u0018A\u0003;fgRtu\u000e^5gsR\u0011\u0001(\u0017\u0005\u0006)*\u0001\rAS\u0001\ti\u0016\u001cHoV1jiR\u0011\u0001\b\u0018\u0005\u0006).\u0001\rAS\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002q!\u0012A\u0002\u0019\t\u0003C*l\u0011A\u0019\u0006\u0003G\u0012\f1!\u00199j\u0015\t)g-A\u0004kkBLG/\u001a:\u000b\u0005\u001dD\u0017!\u00026v]&$(\"A5\u0002\u0007=\u0014x-\u0003\u0002lE\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#!\u00048\u0011\u0005\u0005|\u0017B\u00019c\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\ruKN$8k\u00195fIVdWm\u00165f]\u000e{W\u000e\u001d7fi\u0016D#AD:\u0011\u0005\u0005$\u0018BA;c\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f\u001e)fe&|G-[2UCN\\\u0007+\u001a:j_\u0012D#aD:\u00021Q,7\u000f\u001e)fe&|G-[2UCN\\7k\u00195fIVdW\r\u000b\u0002\u0011g\u0006IB/Z:u!\u0016\u0014\u0018n\u001c3jGR\u000b7o[#yG\u0016\u0004H/[8oQ\t\t2/A\u0006uKN$(+\u001e8P]\u000e,\u0007F\u0001\nt\u0003Q!Xm\u001d;Sk:|enY3Fq\u000e,\u0007\u000f^5p]\"\u00121c\u001d")
public class ClusterLinkSchedulerTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private ClusterLinkScheduler.PeriodicTask task = null;
    private final Exchanger<Integer> exchanger = new Exchanger();

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public ClusterLinkScheduler.PeriodicTask task() {
        return this.task;
    }

    public void task_$eq(ClusterLinkScheduler.PeriodicTask x$1) {
        this.task = x$1;
    }

    private Exchanger<Integer> exchanger() {
        return this.exchanger;
    }

    private void exchangeExpect(Integer value, Integer expect) {
        Assertions.assertEquals((Integer)expect, (Integer)this.exchanger().exchange(value, 1L, TimeUnit.SECONDS));
    }

    public void kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Integer value) {
        this.exchangeExpect(value, null);
    }

    public void kafka$server$link$ClusterLinkSchedulerTest$$testWait(Integer value) {
        this.exchangeExpect(null, value);
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        if (this.task() != null) {
            this.task().shutdown();
        }
        this.scheduler().shutdown();
    }

    @Test
    public void testScheduleWhenComplete() {
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        this.scheduler().scheduleWhenComplete("test", (KafkaFuture)future1, () -> this.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1)));
        Thread.sleep(10L);
        future1.complete(null);
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        KafkaFutureImpl future2 = new KafkaFutureImpl();
        this.scheduler().scheduleWhenComplete("test", (KafkaFuture)future2, () -> this.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2)));
        Thread.sleep(10L);
        future2.completeExceptionally((Throwable)new InvalidRequestException(""));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
    }

    @Test
    public void testPeriodicTaskPeriod() {
        int rescheduleDelayMs = 10;
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, rescheduleDelayMs){
            private boolean first;
            private final /* synthetic */ ClusterLinkSchedulerTest $outer;

            private boolean first() {
                return this.first;
            }

            private void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public boolean run() {
                if (this.first()) {
                    this.first_$eq(false);
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1));
                } else {
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2));
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.scheduler(), "TestTask", rescheduleDelayMs$1);
                this.first = true;
            }
        });
        long start = System.nanoTime();
        this.task().startup();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
        Assertions.assertTrue(((double)(System.nanoTime() - start) / 1000000.0 >= (double)(rescheduleDelayMs * 2) ? 1 : 0) != 0);
    }

    @Test
    public void testPeriodicTaskSchedule() {
        int rescheduleDelayMs = 10;
        KafkaFutureImpl future = new KafkaFutureImpl();
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this, rescheduleDelayMs, future){
            private boolean running;
            private boolean done;
            private final /* synthetic */ ClusterLinkSchedulerTest $outer;
            private final KafkaFutureImpl future$1;

            private boolean running() {
                return this.running;
            }

            private void running_$eq(boolean x$1) {
                this.running = x$1;
            }

            private boolean done() {
                return this.done;
            }

            private void done_$eq(boolean x$1) {
                this.done = x$1;
            }

            public boolean run() {
                Assertions.assertFalse((boolean)this.running());
                if (this.done()) {
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(6));
                    return true;
                }
                this.running_$eq(true);
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1));
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
                this.scheduleOnce((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.next(), 0L);
                return false;
            }

            private boolean next() {
                Assertions.assertTrue((boolean)this.running());
                Assertions.assertFalse((boolean)this.done());
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(3));
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(4));
                JFunction0.mcZ.sp & Serializable scheduleWhenComplete_callback = (JFunction0.mcZ.sp & Serializable)() -> this.finish();
                KafkaFutureImpl scheduleWhenComplete_future = this.future$1;
                this.scheduler().scheduleWhenComplete(this.name(), (KafkaFuture)scheduleWhenComplete_future, () -> ClusterLinkScheduler.PeriodicTask.$anonfun$wrap$1((ClusterLinkScheduler.PeriodicTask)this, (Function0)scheduleWhenComplete_callback));
                return false;
            }

            private boolean finish() {
                Assertions.assertTrue((boolean)this.running());
                Assertions.assertFalse((boolean)this.done());
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(5));
                this.running_$eq(false);
                this.done_$eq(true);
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.future$1 = future$1;
                super($outer.scheduler(), "TestTask", rescheduleDelayMs$2);
                this.running = false;
                this.done = false;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$wrap$1(kafka.server.link.ClusterLinkScheduler$PeriodicTask scala.Function0 ), $anonfun$next$1(kafka.server.link.ClusterLinkSchedulerTest$$anon$2 ), $anonfun$run$1(kafka.server.link.ClusterLinkSchedulerTest$$anon$2 )}, serializedLambda);
            }
        });
        this.task().startup();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(3));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(4));
        Thread.sleep(rescheduleDelayMs);
        future.complete(null);
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(5));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(6));
    }

    @Test
    public void testPeriodicTaskException() {
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this){
            private boolean first;
            private final /* synthetic */ ClusterLinkSchedulerTest $outer;

            private boolean first() {
                return this.first;
            }

            private void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public boolean run() {
                if (this.first()) {
                    this.first_$eq(false);
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1));
                    throw new InvalidRequestException("");
                }
                this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2));
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.scheduler(), "TestTask", 10);
                this.first = true;
            }
        });
        this.task().startup();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
    }

    @Test
    public void testRunOnce() {
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this){
            private boolean first;
            private final /* synthetic */ ClusterLinkSchedulerTest $outer;

            private boolean first() {
                return this.first;
            }

            private void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public boolean run() {
                if (this.first()) {
                    this.first_$eq(false);
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(1));
                } else {
                    this.shutdown();
                    this.$outer.kafka$server$link$ClusterLinkSchedulerTest$$testNotify(Predef$.MODULE$.int2Integer(2));
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.scheduler(), "TestTask", 10);
                this.first = true;
            }
        });
        KafkaFuture result1 = this.task().runOnce();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(1));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)result1.get()));
        KafkaFuture result2 = this.task().runOnce();
        this.kafka$server$link$ClusterLinkSchedulerTest$$testWait(Predef$.MODULE$.int2Integer(2));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)result2.get()));
    }

    @Test
    public void testRunOnceException() {
        this.task_$eq(new ClusterLinkScheduler.PeriodicTask(this){

            public boolean run() {
                throw new InvalidRequestException("");
            }
        });
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.task().runOnce().get());
        Assertions.assertEquals(InvalidRequestException.class, e.getCause().getClass());
    }
}

