/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkBrokerMetrics;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkOutboundConnectionManager;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ConnectionMode;
import kafka.server.link.LinkType;
import kafka.server.link.LinkType$;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\u0011\"\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004>\u0001\u0001\u0006I!\u000e\u0005\b}\u0001\u0011\r\u0011\"\u00035\u0011\u0019y\u0004\u0001)A\u0005k!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002)\u0001A\u0003%!\tC\u0004R\u0001\t\u0007I\u0011\u0002*\t\ry\u0003\u0001\u0015!\u0003T\u0011\u001dy\u0006A1A\u0005\n\u0001Da\u0001\u001b\u0001!\u0002\u0013\t\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007_\u0002\u0001\u000b\u0011B6\t\u000fA\u0004!\u0019!C\u0005c\"1q\u0010\u0001Q\u0001\nID\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u0003\u000bA\u0011\"!\u000b\u0001\u0005\u0004%I!a\u000b\t\u0011\u0005]\u0002\u0001)A\u0005\u0003[A\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003{A\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0013Bq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002r\u0001!\t!a\u0015\t\u000f\u0005m\u0004\u0001\"\u0001\u0002T!9\u0011q\u0010\u0001\u0005\u0002\u0005M\u0003bBAB\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003\u000f\u0003A\u0011AA*\u0011\u001d\tY\t\u0001C\u0005\u0003'Bq!!$\u0001\t\u0013\tyI\u0001\fDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001cH+Z:u\u0015\t\u00113%\u0001\u0003mS:\\'B\u0001\u0013&\u0003\u0019\u0019XM\u001d<fe*\ta%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011!\u0007A\u0007\u0002C\u00051A/\u001a8b]R,\u0012!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nA\u0001\\1oO*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u001f8\u0005\u0019\u0019FO]5oO\u00069A/\u001a8b]R\u0004\u0013\u0001\u0004;f]\u0006tG\u000f\u0015:fM&D\u0018!\u0004;f]\u0006tG\u000f\u0015:fM&D\b%\u0001\u0005mS:\\G)\u0019;b+\u0005\u0011\u0005cA\"I\u00156\tAI\u0003\u0002F\r\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u000f.\n!bY8mY\u0016\u001cG/[8o\u0013\tIEIA\u0002TKF\u0004\"a\u0013(\u000e\u00031S!!T\u0013\u0002\u0005i\\\u0017BA(M\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017!\u00037j].$\u0015\r^1!\u00035\u0019x.\u001e:dKR{\u0007/[2JIV\t1\u000b\u0005\u0002U96\tQK\u0003\u0002W/\u000611m\\7n_:T!A\n-\u000b\u0005eS\u0016AB1qC\u000eDWMC\u0001\\\u0003\ry'oZ\u0005\u0003;V\u0013A!V;jI\u0006q1o\\;sG\u0016$v\u000e]5d\u0013\u0012\u0004\u0013A\u00039beRLG/[8ogV\t\u0011\rE\u0002D\u0011\n\u0004BAK2fK&\u0011Am\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005)2\u0017BA4,\u0005\rIe\u000e^\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0004qCV\u001cX\rZ\u000b\u0002WB\u00191\t\u00137\u0011\u0005)j\u0017B\u00018,\u0005\u001d\u0011un\u001c7fC:\fq\u0001]1vg\u0016$\u0007%A\u0005mS:\\Wj\u001c3fgV\t!\u000fE\u0002D\u0011N\u0004\"\u0001^?\u000e\u0003UT!A^<\u0002#\rcWo\u001d;fe2Kgn[\"p]\u001aLwM\u0003\u0002#q*\u0011a%\u001f\u0006\u0003un\f\u0011bY8oM2,XM\u001c;\u000b\u0003q\f!![8\n\u0005y,(\u0001\u0003'j].lu\u000eZ3\u0002\u00151Lgn['pI\u0016\u001c\b%\u0001\u0004u_BL7m]\u000b\u0003\u0003\u000b\u0001baQA\u0004k\u0005-\u0011bAA\u0005\t\n\u0019Q*\u00199\u0013\u0011\u00055\u0011\u0011CA\f\u0003;1a!a\u0004\u0001\u0001\u0005-!\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004c\u0001\u0016\u0002\u0014%\u0019\u0011QC\u0016\u0003\u000fA\u0013x\u000eZ;diB\u0019!'!\u0007\n\u0007\u0005m\u0011EA\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3\u0011\t\u0005}\u00111E\u0007\u0003\u0003CQ!\u0001`\u001d\n\t\u0005\u0015\u0012\u0011\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\bi>\u0004\u0018nY:!\u0003\u001diW\r\u001e:jGN,\"!!\f\u0011\t\u0005=\u00121G\u0007\u0003\u0003cQ1!!\u000bV\u0013\u0011\t)$!\r\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\u0004nC:\fw-\u001a:\u0016\u0005\u0005u\u0002c\u0001\u001a\u0002@%\u0019\u0011\u0011I\u0011\u0003%\rcWo\u001d;fe2Kgn['b]\u0006<WM]\u0001\t[\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u0002JA\u0019!'a\u0013\n\u0007\u00055\u0013E\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005AA/Z1s\t><h\u000e\u0006\u0002\u0002VA\u0019!&a\u0016\n\u0007\u0005e3F\u0001\u0003V]&$\bf\u0001\r\u0002^A!\u0011qLA7\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014aA1qS*!\u0011qMA5\u0003\u001dQW\u000f]5uKJT1!a\u001b[\u0003\u0015QWO\\5u\u0013\u0011\ty'!\u0019\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u0003;fgRlU\r\u001e:jGND3!GA;!\u0011\ty&a\u001e\n\t\u0005e\u0014\u0011\r\u0002\u0005)\u0016\u001cH/\u0001\fuKN$\b+Y;tK\u0012$v\u000e]5d\u001b\u0016$(/[2tQ\rQ\u0012QO\u0001\u001bi\u0016\u001cH\u000fT5oW\u000e{wN\u001d3j]\u0006$xN]'fiJL7m\u001d\u0015\u00047\u0005U\u0014\u0001\u0004;fgRd\u0015N\\6UsB,\u0007f\u0001\u000f\u0002v\u00051C/Z:u\u0007>tGO]8mY\u0016\u0014(+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8NKR\u0014\u0018nY:)\u0007u\t)(A\u0005tKR,\b/T8dW\u0006\u0011\u0012m]:feRlU\r\u001e:jG\u0016\u000bX/\u00197t)\u0019\t)&!%\u0002\u001c\"9\u00111S\u0010A\u0002\u0005U\u0015\u0001\u00028b[\u0016\u00042\u0001VAL\u0013\r\tI*\u0016\u0002\u000b\u001b\u0016$(/[2OC6,\u0007bBAO?\u0001\u0007\u0011qT\u0001\u000eKb\u0004Xm\u0019;fIZ\u000bG.^3\u0011\u0007)\n\t+C\u0002\u0002$.\u0012a\u0001R8vE2,\u0007")
public class ClusterLinkMetricsTest {
    private final String tenant;
    private final String tenantPrefix = new StringBuilder(1).append(this.tenant()).append("_").toString();
    private final scala.collection.immutable.Seq<ClusterLinkData> linkData = new .colon.colon((Object)new ClusterLinkData(new StringBuilder(11).append(this.tenantPrefix()).append("test-link-1").toString(), Uuid.randomUuid(), (Option)None$.MODULE$, (Option)new Some((Object)this.tenantPrefix()), false), (List)new .colon.colon((Object)new ClusterLinkData("test-link-2", Uuid.randomUuid(), (Option)None$.MODULE$, (Option)None$.MODULE$, false), (List)Nil$.MODULE$));
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final scala.collection.immutable.Seq<Tuple2<Object, Object>> partitions = new .colon.colon((Object)new Tuple2.mcII.sp(4, 1), (List)new .colon.colon((Object)new Tuple2.mcII.sp(6, 2), (List)Nil$.MODULE$));
    private final scala.collection.immutable.Seq<Object> paused = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true}));
    private final scala.collection.immutable.Seq<ClusterLinkConfig.LinkMode> linkModes = new .colon.colon((Object)ClusterLinkConfig.LinkMode.DESTINATION, (List)new .colon.colon((Object)ClusterLinkConfig.LinkMode.SOURCE, (List)Nil$.MODULE$));
    private final Map<String, Product> topics;
    private final Metrics metrics;
    private final ClusterLinkManager manager;
    private final ClusterLinkMetadataManager metadataManager;

    private String tenant() {
        return this.tenant;
    }

    private String tenantPrefix() {
        return this.tenantPrefix;
    }

    private scala.collection.immutable.Seq<ClusterLinkData> linkData() {
        return this.linkData;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private scala.collection.immutable.Seq<Tuple2<Object, Object>> partitions() {
        return this.partitions;
    }

    private scala.collection.immutable.Seq<Object> paused() {
        return this.paused;
    }

    private scala.collection.immutable.Seq<ClusterLinkConfig.LinkMode> linkModes() {
        return this.linkModes;
    }

    private Map<String, Product> topics() {
        return this.topics;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClusterLinkManager manager() {
        return this.manager;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testMetrics() {
        this.setupMock();
        ClusterLinkBrokerMetrics brokerMetrics = new ClusterLinkBrokerMetrics(this.metrics());
        brokerMetrics.startup();
        scala.collection.immutable.Seq brokerSensors = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Sensor[]{brokerMetrics.linkedTopicPartitionAdditionSensor(), brokerMetrics.linkedLeaderEpochChangeSensor(), brokerMetrics.aclsAddedSensor(), brokerMetrics.aclsAddFailedSensor(), brokerMetrics.aclsDeletedSensor(), brokerMetrics.aclsDeleteFailedSensor(), brokerMetrics.describeAclsFromSourceFailedSensor(), brokerMetrics.consumerOffsetCommitSensor(), brokerMetrics.consumerOffsetCommitFailedSensor(), brokerMetrics.topicConfigUpdateSensor(), brokerMetrics.topicConfigUpdateFailedSensor(), brokerMetrics.autoMirrorCreateSensor(), brokerMetrics.autoMirrorCreateFailedSensor(), brokerMetrics.autoMirrorListTopicsFromSourceFailedSensor(), brokerMetrics.autoMirrorListTopicsFromDestinationFailedSensor(), brokerMetrics.autoMirrorListMirrorsFromSourceFailedSensor(), brokerMetrics.listConsumerOffsetsFromSourceFailedSensor(), brokerMetrics.listConsumerOffsetsFromDestinationFailedSensor(), brokerMetrics.listConsumerGroupsFromSourceFailedSensor(), brokerMetrics.prefixedAutoMirrorCreateSensor(), brokerMetrics.prefixedAutoMirrorCreateFailedSensor(), brokerMetrics.prefixedAutoMirrorTopicFilteredSensor(), brokerMetrics.deprecatedSourceReverseConnectionCreatedSensor(), brokerMetrics.deprecatedDestReverseConnectionCreatedSensor(), brokerMetrics.deprecatedSourceReverseConnectionClosedSensor(), brokerMetrics.deprecatedDestReverseConnectionClosedSensor(), brokerMetrics.deprecatedSourceReverseConnectionFailedSensor(), brokerMetrics.outboundReverseConnectionCreatedSensor(), brokerMetrics.inboundReverseConnectionCreatedSensor(), brokerMetrics.outboundReverseConnectionClosedSensor(), brokerMetrics.inboundReverseConnectionClosedSensor(), brokerMetrics.outboundReverseConnectionFailedSensor(), brokerMetrics.destinationLagLinkFetcherThrottleSensor(), brokerMetrics.timeToStopMirrorTopicFailoverSensor(), brokerMetrics.timeToStopMirrorTopicPromoteSensor()}));
        brokerSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$1(this, s);
            return BoxedUnit.UNIT;
        });
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false, this.manager(), (Option)new Some((Object)brokerMetrics), this.metrics(), (Option)new Some((Object)this.tenant()));
        linkMetrics.startup();
        scala.collection.immutable.Seq linkSensors = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Sensor[]{linkMetrics.activeLinkCountSensor(), linkMetrics.throttleTimeSensor(), linkMetrics.linkedTopicPartitionAdditionSensor(), linkMetrics.linkedLeaderEpochChangeSensor(), linkMetrics.aclsAddedSensor(), linkMetrics.aclsAddFailedSensor(), linkMetrics.aclsDeletedSensor(), linkMetrics.aclsDeleteFailedSensor(), linkMetrics.describeAclsFromSourceFailedSensor(), linkMetrics.consumerOffsetCommitSensor(), linkMetrics.consumerOffsetCommitFailedSensor(), linkMetrics.topicConfigUpdateSensor(), linkMetrics.topicConfigUpdateFailedSensor(), linkMetrics.autoMirrorCreateSensor(), linkMetrics.autoMirrorCreateFailedSensor(), linkMetrics.autoMirrorListTopicsFromSourceFailedSensor(), linkMetrics.autoMirrorListTopicsFromDestinationFailedSensor(), linkMetrics.autoMirrorListMirrorsFromSourceFailedSensor(), linkMetrics.listConsumerGroupOffsetsFromSourceFailedSensor(), linkMetrics.listConsumerGroupOffsetsFromDestinationFailedSensor(), linkMetrics.listConsumerGroupsFromSourceFailedSensor(), linkMetrics.prefixedAutoMirrorCreateSensor(), linkMetrics.prefixedAutoMirrorCreateFailedSensor(), linkMetrics.prefixedAutoMirrorTopicFilteredSensor(), linkMetrics.linkUnavailableSensor(), linkMetrics.deprecatedReverseConnectionCreatedSensor(), linkMetrics.deprecatedReverseConnectionClosedSensor(), linkMetrics.deprecatedSourceReverseConnectionFailedSensor(), linkMetrics.reverseConnectionCreatedSensor(), linkMetrics.reverseConnectionClosedSensor(), linkMetrics.outboundReverseConnectionFailedSensor(), linkMetrics.destinationLagLinkFetcherThrottleSensor(), linkMetrics.timeToStopMirrorTopicFailoverSensor()}));
        linkSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$2(this, s);
            return BoxedUnit.UNIT;
        });
        this.assertMetricEquals(linkMetrics.mirrorPartitionCountMetricName(), 4.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
        linkSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$4(this, s);
            return BoxedUnit.UNIT;
        });
        brokerSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$5(this, s);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPausedTopicMetrics() {
        this.setupMock();
        String linkName = ((ClusterLinkData)this.linkData().apply(1)).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().apply(1)).linkId(), (ClusterLinkConfig.LinkMode)this.linkModes().apply(1), (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false, this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$);
        linkMetrics.startup();
        this.assertMetricEquals((MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        this.assertMetricEquals(linkMetrics.mirrorPartitionCountMetricName(), 6.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testPausedTopicMetrics$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
    }

    @Test
    public void testLinkCoordinatorMetrics() {
        this.setupMock();
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (ClusterLinkConfig.LinkMode)this.linkModes().head(), (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false, this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$);
        linkMetrics.startup();
        this.assertMetricEquals((MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        linkMetrics.shutdown();
    }

    @Test
    public void testLinkType() {
        Assertions.assertEquals((Object)LinkType.Cloud$.MODULE$, (Object)LinkType$.MODULE$.determineLinkType(true, (Option)new Some((Object)"tenant")));
        Assertions.assertEquals((Object)LinkType.Hybrid$.MODULE$, (Object)LinkType$.MODULE$.determineLinkType(false, (Option)new Some((Object)"tenant")));
        Assertions.assertEquals((Object)LinkType.None$.MODULE$, (Object)LinkType$.MODULE$.determineLinkType(false, (Option)None$.MODULE$));
    }

    @Test
    public void testControllerReverseConnectionMetrics() {
        Mockito.reset((Object[])new ClusterLinkManager[]{this.manager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        ClusterLinkOutboundConnectionManager connectionManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
        Mockito.when((Object)this.manager().metadataManager()).thenReturn((Object)this.metadataManager());
        this.linkData().foreach((Function1 & Serializable)data -> {
            Mockito.when((Object)this.manager().resolveLinkId(data.linkName())).thenReturn((Object)new Some((Object)data.linkId()));
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)connectionManager.persistentConnectionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
            return Mockito.when((Object)this.manager().connectionManager(data.linkId())).thenReturn((Object)new Some((Object)connectionManager));
        });
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (ClusterLinkConfig.LinkMode)this.linkModes().apply(1), (ConnectionMode)ConnectionMode.Outbound$.MODULE$, true, this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)new Some((Object)this.tenant()));
        linkMetrics.startup();
        this.assertMetricEquals(linkMetrics.controllerReverseConnectionMetricName(), 1.0);
        Assertions.assertTrue((boolean)linkMetrics.controllerReverseConnectionMetricName().tags().containsKey("mode"));
        Assertions.assertEquals((Object)"source", linkMetrics.controllerReverseConnectionMetricName().tags().get("mode"));
        Assertions.assertTrue((boolean)linkMetrics.controllerReverseConnectionMetricName().tags().containsKey("connection-mode"));
        Assertions.assertEquals((Object)"outbound", linkMetrics.controllerReverseConnectionMetricName().tags().get("connection-mode"));
        Assertions.assertTrue((boolean)linkMetrics.controllerReverseConnectionMetricName().tags().containsKey("deployed-link-type"));
        Assertions.assertEquals((Object)"cloud", linkMetrics.controllerReverseConnectionMetricName().tags().get("deployed-link-type"));
        linkMetrics.shutdown();
    }

    private void setupMock() {
        Mockito.reset((Object[])new ClusterLinkManager[]{this.manager()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)this.manager().listClusterLinks()).thenReturn(this.linkData());
        ((IterableOps)this.partitions().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Tuple2 data = (Tuple2)x0$1._1();
                int index = x0$1._2$mcI$sp();
                ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)fetcherManager.mirrorPartitionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)data._1$mcI$sp()));
                return Mockito.when((Object)this.manager().fetcherManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).thenReturn((Object)new Some((Object)fetcherManager));
            }
            throw new MatchError(null);
        });
        ((IterableOnceOps)this.paused().zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                boolean paused = x0$2._1$mcZ$sp();
                int index = x0$2._2$mcI$sp();
                ClusterLinkConfig config = (ClusterLinkConfig)Mockito.mock(ClusterLinkConfig.class);
                Mockito.when((Object)config.clusterLinkPaused()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(paused));
                ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
                Mockito.when((Object)clientManager.currentConfig()).thenReturn((Object)config);
                Mockito.when((Object)this.manager().clientManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).thenReturn((Object)new Some((Object)clientManager));
                return Mockito.when((Object)this.manager().destClientManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).thenReturn((Object)new Some((Object)clientManager));
            }
            throw new MatchError(null);
        });
        Mockito.when((Object)this.manager().metadataManager()).thenReturn((Object)this.metadataManager());
        this.linkData().foreach((Function1 & Serializable)data -> {
            Mockito.when((Object)this.manager().resolveLinkId(data.linkName())).thenReturn((Object)new Some((Object)data.linkId()));
            return Mockito.when((Object)this.manager().linkState(data.linkName())).thenReturn((Object)ActiveClusterLink$.MODULE$);
        });
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache(((ClusterLinkData)this.linkData().head()).linkId())).thenReturn(this.topics().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsTest.$anonfun$setupMock$4(this, t))));
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache(((ClusterLinkData)this.linkData().apply(1)).linkId())).thenReturn(this.topics().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsTest.$anonfun$setupMock$5(this, t))));
    }

    private void assertMetricEquals(MetricName name, double expectedValue) {
        Option option = CollectionConverters$.MODULE$.MapHasAsScala(this.metrics().metrics()).asScala().get((Object)name);
        if (option instanceof Some) {
            KafkaMetric metric = (KafkaMetric)((Some)option).value();
            Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)expectedValue), (Object)metric.metricValue());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Metric ").append(name).append(" not found").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$1(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$2(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$3(ClusterLinkMetricsTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean bl;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                bl = true;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    bl = false;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        bl = false;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            bl = true;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                bl = true;
                            } else {
                                throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                            }
                        }
                    }
                }
            }
            boolean expectedValue = bl;
            $this.assertMetricEquals(name, (double)expectedValue);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$4(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNull((Object)$this.metrics().getSensor(s.name()), (String)new StringBuilder(32).append("Sensor ").append(s.name()).append(" should not be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$5(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(34).append("Sensor ").append(s.name()).append(" should still be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testPausedTopicMetrics$1(ClusterLinkMetricsTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int n;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                n = 2;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    n = 2;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        n = 0;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            n = 0;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                n = 0;
                            } else {
                                throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                            }
                        }
                    }
                }
            }
            int expectedValue = n;
            $this.assertMetricEquals(name, expectedValue);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$setupMock$4(ClusterLinkMetricsTest $this, Tuple2 t) {
        return ((ClusterLinkTopicState)t._2()).linkName().equals(((ClusterLinkData)$this.linkData().head()).linkName());
    }

    public static final /* synthetic */ boolean $anonfun$setupMock$5(ClusterLinkMetricsTest $this, Tuple2 t) {
        return ((ClusterLinkTopicState)t._2()).linkName().equals(((ClusterLinkData)$this.linkData().apply(1)).linkName());
    }

    public ClusterLinkMetricsTest() {
        this.tenant = "test-tenant";
        Object[] objectArray = new Tuple2[5];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new ClusterLinkTopicState.StoppedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.List().empty(), Time.SYSTEM.milliseconds()));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, Time.SYSTEM.milliseconds()));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-4"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-5"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty()));
        this.topics = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.metrics = new Metrics();
        this.manager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
        this.metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    }
}

