/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import kafka.server.link.AbstractClusterLinkMetadataManagerTest;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00154A!\u0004\b\u0001+!)!\u0004\u0001C\u00017!9Q\u0004\u0001b\u0001\n\u0013q\u0002B\u0002\u0016\u0001A\u0003%q\u0004C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\rQ\u0002\u0001\u0015!\u0003.\u0011\u001d)\u0004A1A\u0005\nYBa!\u0010\u0001!\u0002\u00139\u0004\"\u0002 \u0001\t\u0003y\u0004\"\u0002,\u0001\t\u00039\u0006\"\u0002/\u0001\t\u00039\u0006\"B1\u0001\t\u00039\u0006\"B2\u0001\t\u00039&AL\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014x+\u001b;i\u0017J\fg\r^*vaB|'\u000f\u001e+fgRT!a\u0004\t\u0002\t1Lgn\u001b\u0006\u0003#I\taa]3sm\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ai\u0011AD\u0005\u000339\u0011a%\u00112tiJ\f7\r^\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u0018\u0001\u0005q!M]8lKJ,e\u000e\u001a9pS:$X#A\u0010\u0011\u0005\u0001BS\"A\u0011\u000b\u0005\t\u001a\u0013AB2p[6|gN\u0003\u0002\u0014I)\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0013\tI\u0013E\u0001\u0005F]\u0012\u0004x.\u001b8u\u0003=\u0011'o\\6fe\u0016sG\r]8j]R\u0004\u0013AC:feZ,'/\u00138g_V\tQ\u0006\u0005\u0002/e5\tqF\u0003\u00021c\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005E\u0019\u0013BA\u001a0\u0005Q\tU\u000f\u001e5pe&TXM]*feZ,'/\u00138g_\u0006Y1/\u001a:wKJLeNZ8!\u00035iW\r^1eCR\f7)Y2iKV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;!\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0002=s\t\u00112JU1gi6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\nQa]3u+B$\"\u0001\u0011$\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000f\"\u0001\r\u0001S\u0001\u0005S:4w\u000e\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006\u0019\u0011\r]5\u000b\u00055s\u0015a\u00026va&$XM\u001d\u0006\u0003\u001f\u001a\nQA[;oSRL!!\u0015&\u0003\u0011Q+7\u000f^%oM>D#\u0001C*\u0011\u0005%#\u0016BA+K\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\t\u0001\t\u000b\u0002\n3B\u0011\u0011JW\u0005\u00037*\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002UQ,7\u000f^'fi\u0006$\u0017\r^1U_BL7m\u0011:fCRLwN\\,ji\"4\u0015-\u001b7fI\u0006#H/Z7qi\"\u0012!B\u0018\t\u0003\u0013~K!\u0001\u0019&\u0003\tQ+7\u000f^\u00012i\u0016\u001cH/T3uC\u0012\fG/\u0019+pa&\u001c7I]3bi&|gnV5uQR{\u0007/[2Fq&\u001cHo]#yG\u0016\u0004H/[8oQ\tYa,A\u0012uKN$\b+\u0019:uSRLwN\\#mK\u000e$\u0018n\u001c8B]\u0012\u0014Vm]5h]\u0006$\u0018n\u001c8)\u00051q\u0006")
public class ClusterLinkMetadataManagerWithKraftSupportTest
extends AbstractClusterLinkMetadataManagerTest {
    private final Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
    private final AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)Mockito.mock(AuthorizerServerInfo.class);
    private final KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);

    private Endpoint brokerEndpoint() {
        return this.brokerEndpoint;
    }

    private AuthorizerServerInfo serverInfo() {
        return this.serverInfo;
    }

    private KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    @BeforeEach
    public void setUp(TestInfo info) {
        Mockito.reset((Object[])new Object[]{this.destAdmin(), this.serverInfo(), this.metadataCache()});
        Mockito.when((Object)this.serverInfo().interBrokerEndpoint()).thenReturn((Object)this.brokerEndpoint());
        Mockito.when((Object)this.metadataCache().currentImage()).thenReturn((Object)MetadataImage.EMPTY);
        if (info.getDisplayName().startsWith("testMetadataTopicCreation")) {
            this.metadataManager_$eq((ClusterLinkMetadataManager)new ClusterLinkMetadataManagerWithKRaftSupport(this.brokerConfig(), this.scheduler(), this.metadataCache(), null, (Function0 & Serializable)() -> this.destAdmin(), this.serverInfo()));
            return;
        }
        Mockito.when((Object)this.metadataCache().numPartitions("_confluent-link-metadata")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)50)));
        this.metadataManager_$eq((ClusterLinkMetadataManager)new ClusterLinkMetadataManagerWithKRaftSupport(this.brokerConfig(), this.scheduler(), this.metadataCache(), null, (Function0 & Serializable)() -> this.destAdmin(), this.serverInfo()));
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic();
    }

    @AfterEach
    public void tearDown() {
        if (this.metadataManager() != null) {
            this.metadataManager().shutdown();
        }
        this.metadataManager_$eq(null);
    }

    @Test
    public void testMetadataTopicCreationWithFailedAttempt() {
        Mockito.reset((Object[])new KRaftMetadataCache[]{this.metadataCache()});
        Mockito.when((Object)this.metadataCache().numPartitions("_confluent-link-metadata")).thenReturn((Object)None$.MODULE$);
        Mockito.reset((Object[])new Admin[]{this.destAdmin()});
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicAuthorizationException("")))).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)None$.MODULE$));
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic();
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((KRaftMetadataCache)Mockito.verify((Object)this.metadataCache(), (VerificationMode)Mockito.times((int)2))).numPartitions("_confluent-link-metadata");
    }

    @Test
    public void testMetadataTopicCreationWithTopicExistsException() {
        Mockito.reset((Object[])new KRaftMetadataCache[]{this.metadataCache()});
        Mockito.when((Object)this.metadataCache().numPartitions("_confluent-link-metadata")).thenReturn((Object)None$.MODULE$, (Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions())))});
        Mockito.reset((Object[])new Admin[]{this.destAdmin()});
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)this.createMetadataTopicResult((Option<Throwable>)new Some((Object)new TopicExistsException(""))));
        this.metadataManager().startup();
        this.waitAndCreateMetadataTopic();
        ((Admin)Mockito.verify((Object)this.destAdmin())).createTopics((Collection)ArgumentMatchers.any());
        ((KRaftMetadataCache)Mockito.verify((Object)this.metadataCache(), (VerificationMode)Mockito.times((int)2))).numPartitions("_confluent-link-metadata");
    }

    @Test
    public void testPartitionElectionAndResignation() {
        String clusterLinkName = "testLink";
        int partition = (Utils.murmur2((byte[])clusterLinkName.getBytes()) & Integer.MAX_VALUE) % Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions());
        this.metadataManager().onElection(partition, 10);
        Assertions.assertTrue((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is not leader for cluster link");
        Assertions.assertFalse((boolean)this.metadataManager().isLinkCoordinator("testLink2"), (String)"Broker is leader for cluster link");
        this.metadataManager().onResignation(partition, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)9)));
        Assertions.assertTrue((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is not leader for cluster link");
        this.metadataManager().onResignation(partition, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)11)));
        Assertions.assertFalse((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is leader for cluster link");
        this.metadataManager().onElection(partition, 9);
        Assertions.assertFalse((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is leader for cluster link");
        this.metadataManager().onElection(partition, 12);
        Assertions.assertTrue((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is not leader for cluster link");
        this.metadataManager().onResignation(partition, (Option)None$.MODULE$);
        Assertions.assertFalse((boolean)this.metadataManager().isLinkCoordinator(clusterLinkName), (String)"Broker is leader for cluster link");
    }
}

