/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.TopicClusterLinkFilter;
import kafka.server.link.TopicFilterJson;
import kafka.server.link.TopicType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\r\u001b\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%BQ\u0001\f\u0001\u0005\u00025BQA\u0010\u0001\u0005\u00025BQ\u0001\u0011\u0001\u0005\u00025BQA\u0011\u0001\u0005\u00025BQ\u0001\u0012\u0001\u0005\u00025BQA\u0012\u0001\u0005\n\u001dCQ\u0001\u001b\u0001\u0005\u00025BQA\u001b\u0001\u0005\u00025BQ\u0001\u001c\u0001\u0005\u00025BQA\u001c\u0001\u0005\u00025BQ\u0001\u001d\u0001\u0005\u00025BQA\u001d\u0001\u0005\u00025BQ\u0001\u001e\u0001\u0005\u00025BQA\u001e\u0001\u0005\u00025BQ\u0001\u001f\u0001\u0005\u00025BQA\u001f\u0001\u0005\u00025BQ\u0001 \u0001\u0005\u00025BQA \u0001\u0005\u00025Ba!!\u0001\u0001\t\u0003i\u0003BBA\u0003\u0001\u0011\u0005Q\u0006\u0003\u0004\u0002\n\u0001!\t!\f\u0005\u0007\u0003\u001b\u0001A\u0011A\u0017\t\r\u0005E\u0001\u0001\"\u0001.\u0005e\u0019E.^:uKJd\u0015N\\6GS2$XM\u001d&t_:$Vm\u001d;\u000b\u0005ma\u0012\u0001\u00027j].T!!\b\u0010\u0002\rM,'O^3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001+!\tY\u0003!D\u0001\u001b\u00031\"Xm\u001d;F[B$\u0018p\u0015;sS:<\u0007+\u0019:tKN$v.R7qif<%o\\;q\r&dG/\u001a:t\u0015N|g\u000eF\u0001/!\t\u0019s&\u0003\u00021I\t!QK\\5uQ\t\u0011!\u0007\u0005\u00024y5\tAG\u0003\u00026m\u0005\u0019\u0011\r]5\u000b\u0005]B\u0014a\u00026va&$XM\u001d\u0006\u0003si\nQA[;oSRT\u0011aO\u0001\u0004_J<\u0017BA\u001f5\u0005\u0011!Vm\u001d;\u0002YQ,7\u000f^#naRL8\u000b\u001e:j]\u001e\u0004\u0016M]:fgR{W)\u001c9usR{\u0007/[2GS2$XM]:Kg>t\u0007FA\u00023\u0003\u001d\"Xm\u001d;WC2LGm\u0015;sS:<\u0007+\u0019:tKN$vn\u0012:pkB4\u0015\u000e\u001c;feNT5o\u001c8)\u0005\u0011\u0011\u0014!\n;fgR\u0004\u0016M]:f\u000fJ|W\u000f\u001d+pa&\u001cG+\u001f9fgN+Go\u001d'pG\u0006dwJ\u001c7zQ\t)!'\u0001\u0014uKN$\b+\u0019:tK\u001e\u0013x.\u001e9U_BL7\rV=qKN\u001cV\r^:SK6|G/Z(oYfD#A\u0002\u001a\u00023\u0005\u001c8/\u001a:u\u000b\u001a4Wm\u0019;jm\u0016$v\u000e]5d)f\u0004Xm\u001d\u000b\u0004]!\u001b\u0007\"B%\b\u0001\u0004Q\u0015\u0001C3ya\u0016\u001cG/\u001a3\u0011\u0007-\u001bfK\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011q\nI\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!A\u0015\u0013\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0004'\u0016\f(B\u0001*%!\t9\u0006M\u0004\u0002Y=:\u0011\u0011,\u0018\b\u00035rs!!T.\n\u0003}I!!\b\u0010\n\u0005ma\u0012BA0\u001b\u0003%!v\u000e]5d)f\u0004X-\u0003\u0002bE\nIAk\u001c9jGRK\b/\u001a\u0006\u0003?jAQ\u0001Z\u0004A\u0002\u0015\f1b\u001a:pkB4\u0015\u000e\u001c;feB\u00111FZ\u0005\u0003Oj\u0011ac\u0012:pkB\u001cE.^:uKJd\u0015N\\6GS2$XM]\u0001(i\u0016\u001cHOV1mS\u0012\u001cFO]5oOB\u000b'o]3t)>$v\u000e]5d\r&dG/\u001a:t\u0015N|g\u000e\u000b\u0002\te\u0005)B/Z:u\t\u00164\u0017-\u001e7u)>\u0004\u0018n\u0019+za\u0016\u001c\bFA\u00053\u0003Q!Xm\u001d;Ok2d'j]8o\u0003J<W/\\3oi\"\u0012!BM\u0001\u001fi\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d\u001dVdGNS:p]\u0006\u0013x-^7f]RD#a\u0003\u001a\u0002+Q,7\u000f^%om\u0006d\u0017\u000e\u001a$jYR,'\u000fV=qK\"\u0012ABM\u0001 i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d\u0013:4\u0018\r\\5e\r&dG/\u001a:UsB,\u0007FA\u00073\u0003U!Xm\u001d;NSN\u001c\u0018N\\4GS2$XM\u001d+za\u0016D#A\u0004\u001a\u0002?Q,7\u000f\u001e)beN,Gk\u001c9jG6K7o]5oO\u001aKG\u000e^3s)f\u0004X\r\u000b\u0002\u0010e\u00051B/Z:u\u001b&\u001c8/\u001b8h!\u0006$H/\u001a:o)f\u0004X\r\u000b\u0002\u0011e\u0005\u0001C/Z:u!\u0006\u00148/\u001a+pa&\u001cW*[:tS:<\u0007+\u0019;uKJtG+\u001f9fQ\t\t\"'\u0001\fuKN$\u0018J\u001c<bY&$\u0007+\u0019;uKJtG+\u001f9fQ\t\u0011\"'\u0001\u000buKN$X)\u001c9usB\u000bG\u000f^3s]RK\b/\u001a\u0015\u0003'I\nq\b^3tiB\u000b'o]3He>,\b\u000f\u00165s_^\u001c\u0018\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8G_J,fn\u001b8po:$v\u000e]5d)f\u0004X\r\u000b\u0002\u0015e\u0005AD/Z:u!\u0006\u00148/Z$s_V\u0004H\u000b\u001b:poNLE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c$pe\u0016k\u0007\u000f^=MSN$\bFA\u000b3\u0003\u0001\"Xm\u001d;QCJ\u001cX\rV8qS\u000eLeN^1mS\u0012\u0004\u0016\r\u001e;fe:$\u0016\u0010]3)\u0005Y\u0011\u0014A\b;fgR\u0004\u0016M]:f)>\u0004\u0018nY#naRL\b+\u0019;uKJtG+\u001f9fQ\t9\"'A\fuKN$Hk\u001c9jGRK\b/\u001a$s_6\u001cFO]5oO\"\u0012\u0001D\r")
public class ClusterLinkFilterJsonTest {
    @Test
    public void testEmptyStringParsesToEmptyGroupFiltersJson() {
        Assertions.assertTrue((boolean)ClusterLinkFilterJson$.MODULE$.parseGroup("").isEmpty());
    }

    @Test
    public void testEmptyStringParsesToEmptyTopicFiltersJson() {
        Assertions.assertTrue((boolean)ClusterLinkFilterJson$.MODULE$.parseTopic("").isEmpty());
    }

    @Test
    public void testValidStringParsesToGroupFiltersJson() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\",\n                               |     \"filterType\": \"INCLUDE\",\n                               |     \"topicTypes\": [\"LOCAL_MIRROR\", \"REMOTE_MIRROR\"]\n                               |  }\n                               |]}"));
        Option groupJson = ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson);
        Assertions.assertTrue((boolean)groupJson.isDefined());
        GroupClusterLinkFilter groupFilter = (GroupClusterLinkFilter)((GroupFilterJson)groupJson.get()).filters().head();
        Assertions.assertEquals((Object)"*", (Object)groupFilter.name());
        Assertions.assertEquals((Object)"LITERAL", (Object)groupFilter.patternType());
        Assertions.assertEquals((Object)"INCLUDE", (Object)groupFilter.filterType());
        Assertions.assertEquals((Object)new .colon.colon((Object)"LOCAL_MIRROR", (List)new .colon.colon((Object)"REMOTE_MIRROR", (List)Nil$.MODULE$)), (Object)groupFilter.topicTypes());
        this.assertEffectiveTopicTypes((Seq<Enumeration.Value>)new .colon.colon((Object)TopicType$.MODULE$.LOCAL_MIRROR(), (List)new .colon.colon((Object)TopicType$.MODULE$.REMOTE_MIRROR(), (List)Nil$.MODULE$)), groupFilter);
    }

    @Test
    public void testParseGroupTopicTypesSetsLocalOnly() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\",\n                               |     \"filterType\": \"INCLUDE\",\n                               |     \"topicTypes\": [\"LOCAL_MIRROR\"]\n                               |  }\n                               |]}"));
        Option groupJson = ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson);
        Assertions.assertTrue((boolean)groupJson.isDefined());
        GroupClusterLinkFilter groupFilter = (GroupClusterLinkFilter)((GroupFilterJson)groupJson.get()).filters().head();
        Assertions.assertEquals((Object)new .colon.colon((Object)"LOCAL_MIRROR", (List)Nil$.MODULE$), (Object)groupFilter.topicTypes());
        this.assertEffectiveTopicTypes((Seq<Enumeration.Value>)new .colon.colon((Object)TopicType$.MODULE$.LOCAL_MIRROR(), (List)Nil$.MODULE$), groupFilter);
    }

    @Test
    public void testParseGroupTopicTypesSetsRemoteOnly() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\",\n                               |     \"filterType\": \"INCLUDE\",\n                               |     \"topicTypes\": [\"REMOTE_MIRROR\"]\n                               |  }\n                               |]}"));
        Option groupJson = ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson);
        Assertions.assertTrue((boolean)groupJson.isDefined());
        GroupClusterLinkFilter groupFilter = (GroupClusterLinkFilter)((GroupFilterJson)groupJson.get()).filters().head();
        Assertions.assertEquals((Object)new .colon.colon((Object)"REMOTE_MIRROR", (List)Nil$.MODULE$), (Object)groupFilter.topicTypes());
        this.assertEffectiveTopicTypes((Seq<Enumeration.Value>)new .colon.colon((Object)TopicType$.MODULE$.REMOTE_MIRROR(), (List)Nil$.MODULE$), groupFilter);
    }

    private void assertEffectiveTopicTypes(Seq<Enumeration.Value> expected, GroupClusterLinkFilter groupFilter) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ClusterLinkConfig.LinkMode.values()), (Function1 & Serializable)linkMode -> {
            ClusterLinkFilterJsonTest.$anonfun$assertEffectiveTopicTypes$1(groupFilter, expected, linkMode);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testValidStringParsesToTopicFiltersJson() {
        String topicFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"topicFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\",\n                               |     \"filterType\": \"INCLUDE\"\n                               |  }\n                               |]}"));
        Option groupJson = ClusterLinkFilterJson$.MODULE$.parseTopic(topicFiltersJson);
        Assertions.assertTrue((boolean)groupJson.isDefined());
        TopicClusterLinkFilter groupFilter = (TopicClusterLinkFilter)((TopicFilterJson)groupJson.get()).filters().head();
        Assertions.assertEquals((Object)"*", (Object)groupFilter.name());
        Assertions.assertEquals((Object)"LITERAL", (Object)groupFilter.patternType());
        Assertions.assertEquals((Object)"INCLUDE", (Object)groupFilter.filterType());
    }

    @Test
    public void testDefaultTopicTypes() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\",\n                               |     \"filterType\": \"INCLUDE\"\n                               |  }\n                               |]}"));
        Option groupJson = ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson);
        Assertions.assertTrue((boolean)groupJson.isDefined());
        GroupClusterLinkFilter groupFilter = (GroupClusterLinkFilter)((GroupFilterJson)groupJson.get()).filters().head();
        Assertions.assertNull((Object)groupFilter.topicTypes());
        Assertions.assertEquals((Object)new .colon.colon((Object)TopicType$.MODULE$.LOCAL_MIRROR(), (List)new .colon.colon((Object)TopicType$.MODULE$.REMOTE_MIRROR(), (List)Nil$.MODULE$)), (Object)groupFilter.effectiveTopicTypes(ClusterLinkConfig.LinkMode.BIDIRECTIONAL));
        Assertions.assertEquals((Object)new .colon.colon((Object)TopicType$.MODULE$.LOCAL_MIRROR(), (List)Nil$.MODULE$), (Object)groupFilter.effectiveTopicTypes(ClusterLinkConfig.LinkMode.DESTINATION));
        IllegalStateException ex = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> groupFilter.effectiveTopicTypes(ClusterLinkConfig.LinkMode.SOURCE));
        Assertions.assertEquals((Object)"SOURCE links do not sync offsets", (Object)ex.getMessage());
    }

    @Test
    public void testNullJsonArgument() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseGroup("{}"));
        Assertions.assertEquals((Object)"ClusterLinkFilters cannot be the JSON null", (Object)thrown.getMessage());
    }

    @Test
    public void testParseTopicNullJsonArgument() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseTopic("{}"));
        Assertions.assertEquals((Object)"ClusterLinkFilters cannot be the JSON null", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidFilterType() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\",\n                               |     \"filterType\": \"FOO\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson));
        Assertions.assertEquals((Object)"Unknown filterType: FOO", (Object)thrown.getMessage());
    }

    @Test
    public void testParseTopicInvalidFilterType() {
        String topicFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"topicFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\",\n                               |     \"filterType\": \"FOO\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseTopic(topicFiltersJson));
        Assertions.assertEquals((Object)"Unknown filterType: FOO", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingFilterType() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson));
        Assertions.assertEquals((Object)"filterType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testParseTopicMissingFilterType() {
        String topicFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"topicFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseTopic(topicFiltersJson));
        Assertions.assertEquals((Object)"filterType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPatternType() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"filterType\": \"INCLUDE\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testParseTopicMissingPatternType() {
        String topicFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"topicFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"filterType\": \"INCLUDE\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseTopic(topicFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidPatternType() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"FOO\",\n                               |     \"filterType\": \"INCLUDE\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson));
        Assertions.assertEquals((Object)"Unknown patternType: FOO", (Object)thrown.getMessage());
    }

    @Test
    public void testEmptyPatternType() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"\",\n                               |     \"filterType\": \"INCLUDE\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testParseGroupThrowsIllegalArgumentExceptionForUnknownTopicType() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\",\n                               |     \"filterType\": \"INCLUDE\",\n                               |     \"topicTypes\": [\"INVALID_TOPIC_TYPE\"]\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson));
        Assertions.assertEquals((Object)"Unknown topic type: INVALID_TOPIC_TYPE", (Object)thrown.getMessage());
    }

    @Test
    public void testParseGroupThrowsIllegalArgumentExceptionForEmptyList() {
        String groupFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"groupFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"LITERAL\",\n                               |     \"filterType\": \"INCLUDE\",\n                               |     \"topicTypes\": []\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseGroup(groupFiltersJson));
        Assertions.assertEquals((Object)"topicTypes cannot be empty", (Object)thrown.getMessage());
    }

    @Test
    public void testParseTopicInvalidPatternType() {
        String topicFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"topicFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"FOO\",\n                               |     \"filterType\": \"INCLUDE\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseTopic(topicFiltersJson));
        Assertions.assertEquals((Object)"Unknown patternType: FOO", (Object)thrown.getMessage());
    }

    @Test
    public void testParseTopicEmptyPatternType() {
        String topicFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n                               |\"topicFilters\": [\n                               |  {\n                               |     \"name\": \"*\",\n                               |     \"patternType\": \"\",\n                               |     \"filterType\": \"INCLUDE\"\n                               |  }\n                               |]}"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parseTopic(topicFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testTopicTypeFromString() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)TopicType$.MODULE$.fromString("UNKNOWN"));
        Assertions.assertEquals((Object)new Some((Object)TopicType$.MODULE$.LOCAL_MIRROR()), (Object)TopicType$.MODULE$.fromString("LOCAL_MIRROR"));
        Assertions.assertEquals((Object)new Some((Object)TopicType$.MODULE$.REMOTE_MIRROR()), (Object)TopicType$.MODULE$.fromString("REMOTE_MIRROR"));
    }

    public static final /* synthetic */ void $anonfun$assertEffectiveTopicTypes$1(GroupClusterLinkFilter groupFilter$1, Seq expected$1, ClusterLinkConfig.LinkMode linkMode) {
        if (linkMode.equals((Object)ClusterLinkConfig.LinkMode.SOURCE)) {
            IllegalStateException ex = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> groupFilter$1.effectiveTopicTypes(linkMode));
            Assertions.assertEquals((Object)"SOURCE links do not sync offsets", (Object)ex.getMessage());
            return;
        }
        Assertions.assertEquals((Object)expected$1, (Object)groupFilter$1.effectiveTopicTypes(linkMode));
    }
}

